//  Persistance of Vision Raytracer V2.0
//  World definition file.
//
//  Contains 2 lights, 3 textures and 180 primitives.
//
//  This file was generated for POV-Ray V2.0 by
//  MORAY.EXE (c) '91 '92 '93 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 10/05/1995    (05.10.1995)
//

//
//  This is MORAY's default standard include file for POV 2.0.
//  called MRYDFLT2.INC
//
//  It defines a standard scene environment of a grass plane on the 'floor'
//  and a blue sky that gets hazy towards the horizon.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "workmen.pov"
plane {
  <0.0, 0.0, 1.0>, -0.01
  texture {
    pigment {
      rgb <0.0, 1.0, 0.0>
    }
    finish {
      ambient 0.4
      diffuse 0.3
      phong 0.2
      phong_size 5
      crand 0.075
    }
  }
}

sphere {
  <0, 0, 0>, 1
  texture {
    pigment {
      gradient z
      color_map {
         [0, 1 color rgb <0.9,0.9,1.0> color rgb <0.4,0.5,1.0> ]
      }
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }
  }
  no_shadow
  scale <1000,1000,1000>
}

#declare BezFlatness = 0.01
#declare BezUStep    = 3
#declare BezVStep    = 3

camera {  //  Camera StdCam
  location  <-450.000, 75.000, 200.000>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0,0,0>
}

// *******  L I G H T S *******
object {   // Light source Neon_Light1
  light_source {
    <0.000, 0.000, 75.000>
    color  SpicyPink
  }
}

object {   // Light source World_Light
  light_source {
    <500.000, -2000.000, 500.000>
    color  red 0.682 green 0.682 blue 1.000
  }
}


//
// ********  T E X T U R E S  *******
//

#include "house.INC"

// ********  O B J E C T S *******
#declare Bound012 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <177.100677, 259.849274, 56.324024>
  translate <11.723350, 96.474745, 50.000000>
}

#declare Bound004 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <136.933334, 154.433334, 54.433334>
  translate <0.000000, -0.000000, 140.000000>
}

#declare Roof_P1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <82.000000, 64.000000, 25.000000>
  translate <0.000000, 0.000000, 115.000000>
}

#declare Roof_Cut1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <50.000000, 50.000000, 200.000000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <82.500000, -100.000000, 140.000000>
}

#declare Roof_Cut2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <50.000000, 50.000000, 200.000000>
  rotate <-90.000000, -0.000000, -0.000000>
  translate <-82.500000, -100.000000, 140.000000>
}

#declare Roof_Cut3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <50.000000, 50.000000, 200.000000>
  rotate <-90.000000, -0.000000, -90.000000>
  translate <-82.500000, -100.000000, 140.000000>
}

#declare Roof_Cut4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  scale <50.000000, 50.000000, 200.000000>
  rotate <-90.000000, -0.000000, -90.000000>
  translate <-82.500000, 100.000000, 140.000000>
}

#declare Roof = difference {
  object { Roof_P1 }
  object { Roof_Cut1 }
  object { Roof_Cut2 }
  object { Roof_Cut3 }
  object { Roof_Cut4 }
  texture {
    White_Marble
  }
  bounded_by { Bound004 }
  translate <300.000000, -25.000000, -90.000000>
}

#declare Neon_Light = object{torus{7.5,1.25}
  
  texture {
    Neon_T
  }
  no_shadow
  rotate <90,0,0>
  translate <0.000000, 0.000000, 75.000000>
}

#declare Bound009 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <118.340424, 130.319992, 48.813770>
  translate <-44.526650, -30.544285, 45.000000>
}

#declare Bound003 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <72.888596, 104.533157, 47.888596>
  translate <0.000000, -49.144563, 45.000000>
}

#declare Bound020 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting1 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting2 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting3 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting4 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting5 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting6 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting7 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting8 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar = difference {
  object { Column_Mid }
  object { Fluting1 }
  object { Fluting2 }
  object { Fluting3 }
  object { Fluting4 }
  object { Fluting5 }
  object { Fluting6 }
  object { Fluting7 }
  object { Fluting8 }
  texture {
    White_Marble
  }
}

#declare Cylndr001 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus001 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base = difference {
  object { Cylndr001 }
  object { Torus001 }
  texture {
    White_Marble
  }
}

#declare Cone001 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column1 = union {
  object { CSG_Pillar }
  object { Base }
  object { Cone001 }
  texture {
    White_Marble
  }
  bounded_by { Bound020 }
  translate <60.000000, 42.500000, 35.000000>
}

#declare Bound019 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid1 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting9 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting10 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting11 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting12 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting13 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting14 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting15 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting16 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar1 = difference {
  object { Column_Mid1 }
  object { Fluting9 }
  object { Fluting10 }
  object { Fluting11 }
  object { Fluting12 }
  object { Fluting13 }
  object { Fluting14 }
  object { Fluting15 }
  object { Fluting16 }
  texture {
    White_Marble
  }
}

#declare Cylndr2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus2 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base1 = difference {
  object { Cylndr2 }
  object { Torus2 }
  texture {
    White_Marble
  }
}

#declare Cone2 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column2 = union {
  object { CSG_Pillar1 }
  object { Base1 }
  object { Cone2 }
  texture {
    White_Marble
  }
  bounded_by { Bound019 }
  translate <36.000000, 42.500000, 35.000000>
}

#declare Bound018 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid2 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting17 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting18 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting19 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting20 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting21 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting22 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting23 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting24 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar2 = difference {
  object { Column_Mid2 }
  object { Fluting17 }
  object { Fluting18 }
  object { Fluting19 }
  object { Fluting20 }
  object { Fluting21 }
  object { Fluting22 }
  object { Fluting23 }
  object { Fluting24 }
  texture {
    White_Marble
  }
}

#declare Cylndr3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus3 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base2 = difference {
  object { Cylndr3 }
  object { Torus3 }
  texture {
    White_Marble
  }
}

#declare Cone3 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column3 = union {
  object { CSG_Pillar2 }
  object { Base2 }
  object { Cone3 }
  texture {
    White_Marble
  }
  bounded_by { Bound018 }
  translate <12.000000, 42.500000, 35.000000>
}

#declare Bound017 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid3 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting25 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting26 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting27 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting28 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting29 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting30 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting31 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting32 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar3 = difference {
  object { Column_Mid3 }
  object { Fluting25 }
  object { Fluting26 }
  object { Fluting27 }
  object { Fluting28 }
  object { Fluting29 }
  object { Fluting30 }
  object { Fluting31 }
  object { Fluting32 }
  texture {
    White_Marble
  }
}

#declare Cylndr4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus4 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base3 = difference {
  object { Cylndr4 }
  object { Torus4 }
  texture {
    White_Marble
  }
}

#declare Cone4 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column4 = union {
  object { CSG_Pillar3 }
  object { Base3 }
  object { Cone4 }
  texture {
    White_Marble
  }
  bounded_by { Bound017 }
  rotate <90.000000, -0.000000, 35.000000>
  translate <15.000000, -100.000000, 10.000000>
}

#declare Bound016 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid4 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting33 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting34 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting35 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting36 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting37 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting38 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting39 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting40 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar4 = difference {
  object { Column_Mid4 }
  object { Fluting33 }
  object { Fluting34 }
  object { Fluting35 }
  object { Fluting36 }
  object { Fluting37 }
  object { Fluting38 }
  object { Fluting39 }
  object { Fluting40 }
  texture {
    White_Marble
  }
}

#declare Cylndr5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus5 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base4 = difference {
  object { Cylndr5 }
  object { Torus5 }
  texture {
    White_Marble
  }
}

#declare Cone5 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column5 = union {
  object { CSG_Pillar4 }
  object { Base4 }
  object { Cone5 }
  texture {
    White_Marble
  }
  bounded_by { Bound016 }
  translate <-36.000000, 42.500000, 35.000000>
}

#declare Bound015 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid5 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting41 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting42 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting43 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting44 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting45 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting46 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting47 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting48 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar5 = difference {
  object { Column_Mid5 }
  object { Fluting41 }
  object { Fluting42 }
  object { Fluting43 }
  object { Fluting44 }
  object { Fluting45 }
  object { Fluting46 }
  object { Fluting47 }
  object { Fluting48 }
  texture {
    White_Marble
  }
}

#declare Cylndr6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus6 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base5 = difference {
  object { Cylndr6 }
  object { Torus6 }
  texture {
    White_Marble
  }
}

#declare Cone6 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column6 = union {
  object { CSG_Pillar5 }
  object { Base5 }
  object { Cone6 }
  texture {
    White_Marble
  }
  bounded_by { Bound015 }
  translate <-60.000000, 42.500000, 35.000000>
}

#declare Row_Of_Columns = union {
  object { Column1 }
  object { Column2 }
  object { Column3 }
  object { Column4 }
  object { Column5 }
  object { Column6 }
  texture {
    White_Marble
  }
  bounded_by { Bound003 }
}

#declare Bound010 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <41.080181, 64.226425, 46.884689>
  translate <30.870988, -9.775255, 45.066481>
}

#declare Bound014 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting49 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting50 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting51 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting52 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting53 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting54 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting55 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting56 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar6 = difference {
  object { Column_Mid6 }
  object { Fluting49 }
  object { Fluting50 }
  object { Fluting51 }
  object { Fluting52 }
  object { Fluting53 }
  object { Fluting54 }
  object { Fluting55 }
  object { Fluting56 }
  texture {
    White_Marble
  }
}

#declare Cylndr7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus7 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base6 = difference {
  object { Cylndr7 }
  object { Torus7 }
  texture {
    White_Marble
  }
}

#declare Cone7 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column7 = union {
  object { CSG_Pillar6 }
  object { Base6 }
  object { Cone7 }
  texture {
    White_Marble
  }
  bounded_by { Bound014 }
  translate <60.000000, 42.500000, 35.000000>
}

#declare Bound013 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting49 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting50 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting51 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting52 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting53 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting54 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting55 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting56 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar6 = difference {
  object { Column_Mid6 }
  object { Fluting49 }
  object { Fluting50 }
  object { Fluting51 }
  object { Fluting52 }
  object { Fluting53 }
  object { Fluting54 }
  object { Fluting55 }
  object { Fluting56 }
  texture {
    White_Marble
  }
}

#declare Cylndr7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus7 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base6 = difference {
  object { Cylndr7 }
  object { Torus7 }
  texture {
    White_Marble
  }
}

#declare Cone7 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column10 = union {
  object { CSG_Pillar6 }
  object { Base6 }
  object { Cone7 }
  texture {
    White_Marble
  }
  bounded_by { Bound013 }
  translate <36.000000, 42.500000, 35.000000>
}

#declare Bound011 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid6 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting49 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting50 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting51 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting52 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting53 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting54 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting55 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting56 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar6 = difference {
  object { Column_Mid6 }
  object { Fluting49 }
  object { Fluting50 }
  object { Fluting51 }
  object { Fluting52 }
  object { Fluting53 }
  object { Fluting54 }
  object { Fluting55 }
  object { Fluting56 }
  texture {
    White_Marble
  }
}

#declare Cylndr7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus7 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base6 = difference {
  object { Cylndr7 }
  object { Torus7 }
  texture {
    White_Marble
  }
}

#declare Cone7 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column11 = union {
  object { CSG_Pillar6 }
  object { Base6 }
  object { Cone7 }
  texture {
    White_Marble
  }
  bounded_by { Bound011 }
  rotate <-75.000000, -0.000000, -55.000000>
  translate <0.000000, -62.500000, 10.000000>
}

#declare Row_Of_Colum1 = union {
  object { Column7 }
  object { Column10 }
  object { Column11 }
  texture {
    White_Marble
  }
  bounded_by { Bound010 }
  translate <0.000000, -85.000000, 0.000000>
}

#declare Bound008 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting73 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting74 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting75 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting76 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting77 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting78 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting79 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting80 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar9 = difference {
  object { Column_Mid9 }
  object { Fluting73 }
  object { Fluting74 }
  object { Fluting75 }
  object { Fluting76 }
  object { Fluting77 }
  object { Fluting78 }
  object { Fluting79 }
  object { Fluting80 }
  texture {
    White_Marble
  }
}

#declare Cylndr10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus10 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base9 = difference {
  object { Cylndr10 }
  object { Torus10 }
  texture {
    White_Marble
  }
}

#declare Cone10 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column15 = union {
  object { CSG_Pillar9 }
  object { Base9 }
  object { Cone10 }
  texture {
    White_Marble
  }
  bounded_by { Bound008 }
  rotate <-90.000000, -0.000000, -45.000000>
  translate <-150.000000, 50.000000, 10.000000>
}

#declare Bound007 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid10 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting81 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting82 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting83 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting84 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting85 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting86 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting87 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting88 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar10 = difference {
  object { Column_Mid10 }
  object { Fluting81 }
  object { Fluting82 }
  object { Fluting83 }
  object { Fluting84 }
  object { Fluting85 }
  object { Fluting86 }
  object { Fluting87 }
  object { Fluting88 }
  texture {
    White_Marble
  }
}

#declare Cylndr11 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus11 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base10 = difference {
  object { Cylndr11 }
  object { Torus11 }
  texture {
    White_Marble
  }
}

#declare Cone11 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column16 = union {
  object { CSG_Pillar10 }
  object { Base10 }
  object { Cone11 }
  texture {
    White_Marble
  }
  bounded_by { Bound007 }
  translate <-60.000000, -13.500000, 35.000000>
}

#declare Bound006 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid7 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting57 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting58 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting59 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting60 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting61 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting62 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting63 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting64 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar7 = difference {
  object { Column_Mid7 }
  object { Fluting57 }
  object { Fluting58 }
  object { Fluting59 }
  object { Fluting60 }
  object { Fluting61 }
  object { Fluting62 }
  object { Fluting63 }
  object { Fluting64 }
  texture {
    White_Marble
  }
}

#declare Cylndr8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus8 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base7 = difference {
  object { Cylndr8 }
  object { Torus8 }
  texture {
    White_Marble
  }
}

#declare Cone8 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column13 = union {
  object { CSG_Pillar7 }
  object { Base7 }
  object { Cone8 }
  texture {
    White_Marble
  }
  bounded_by { Bound006 }
  translate <60.000000, 13.500000, 35.000000>
}

#declare Bound005 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <10.666667, 10.666667, 30.666666>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Column_Mid8 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <5.000000, 5.000000, 50.000000>
}

#declare Fluting65 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <5.000000, 0.000000, 25.000000>
}

#declare Fluting66 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-5.000000, 0.000000, 25.000000>
}

#declare Fluting67 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, 5.000000, 25.000000>
}

#declare Fluting68 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <0.000000, -5.000000, 25.000000>
}

#declare Fluting69 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, 3.535534, 25.000000>
}

#declare Fluting70 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, 3.535534, 25.000000>
}

#declare Fluting71 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <3.535534, -3.535534, 25.000000>
}

#declare Fluting72 = object { 
  sphere {<0,0,0>,1}
  scale <1.000000, 1.000000, 20.000000>
  translate <-3.535534, -3.535534, 25.000000>
}

#declare CSG_Pillar8 = difference {
  object { Column_Mid8 }
  object { Fluting65 }
  object { Fluting66 }
  object { Fluting67 }
  object { Fluting68 }
  object { Fluting69 }
  object { Fluting70 }
  object { Fluting71 }
  object { Fluting72 }
  texture {
    White_Marble
  }
}

#declare Cylndr9 = cylinder {
  <0,0,1>, <0,0,0>, 1
  texture {
    White_Marble
  }
  scale <7.500000, 7.500000, 5.000000>
  translate <0.000000, 0.000000, -5.000000>
}

#declare Torus9 = quartic { 
           // Torus MinRadius=   2.500   MajRadius=   7.500 
           < 1.000,  0.000,  0.000,  0.000,  2.000,
             0.000,  0.000,  2.000,  0.000,  -125.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             0.000,  0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  0.000,  2.000,  0.000,
             -125.000,   0.000,  0.000,  0.000,  0.000,
             1.000,  0.000,  100.000, 0.000,  2500.000 >
  scale <1.000000, 1.000000, 2.000000>
}

#declare Base8 = difference {
  object { Cylndr9 }
  object { Torus9 }
  texture {
    White_Marble
  }
}

#declare Cone9 = cone {
  <0,0,0>, 0
  <0,0,1>, 1
  texture {
    White_Marble
  }
  scale <10.000000, 10.000000, 10.000000>
  translate <0.000000, 0.000000, 45.000000>
}

#declare Column14 = union {
  object { CSG_Pillar8 }
  object { Base8 }
  object { Cone9 }
  texture {
    White_Marble
  }
  bounded_by { Bound005 }
  translate <60.000000, -13.500000, 35.000000>
}

#declare Bound001 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <25.833334, 8.333333, 30.833334>
  translate <0.000000, -42.500000, 60.000000>
}

#declare CrossPiece = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PinkAlabaster
  }
  scale <25.000000, 7.500000, 5.000000>
  translate <0.000000, -42.500000, 85.000000>
}

#declare Pillarb1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PinkAlabaster
  }
  scale <5.000000, 5.000000, 25.000000>
  translate <-18.000000, -42.500000, 55.000000>
}

#declare Pillarb2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PinkAlabaster
  }
  scale <5.000000, 5.000000, 25.000000>
  translate <18.000000, -42.500000, 55.000000>
}

#declare Doorway_Arch = union {
  object { CrossPiece }
  object { Pillarb1 }
  object { Pillarb2 }
  texture {
    PinkAlabaster
  }
  bounded_by { Bound001 }
}

#declare Pillars_A = union {
  object { Row_Of_Columns }
  object { Row_Of_Colum1 }
  object { Column15 }
  object { Column16 }
  object { Column13 }
  object { Column14 }
  object { Doorway_Arch }
  texture {
    White_Marble
  }
  bounded_by { Bound009 }
}

#declare Bound002 = box {
   <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
  scale <102.533333, 77.533333, 17.533333>
  translate <0.000000, 0.000000, 15.000000>
}

#declare Base_Stairs_P1 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <100.000000, 75.000000, 1.000000>
  translate <0.000000, 0.000000, 1.000000>
}

#declare Base_Stairs_2 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <98.000000, 73.500000, 1.000000>
  translate <0.000000, 0.000000, 3.000000>
}

#declare Base_Stairs_3 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <96.000000, 72.000000, 1.000000>
  translate <0.000000, 0.000000, 5.000000>
}

#declare Base_Stairs_4 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <94.000000, 70.500000, 1.000000>
  translate <0.000000, 0.000000, 7.000000>
}

#declare Base_Stairs_5 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <92.000000, 69.000000, 1.000000>
  translate <0.000000, 0.000000, 9.000000>
}

#declare Base_Stairs_6 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <90.000000, 67.500000, 1.000000>
  translate <0.000000, 0.000000, 11.000000>
}

#declare Base_Stairs_7 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <88.000000, 66.000000, 1.000000>
  translate <0.000000, 0.000000, 13.000000>
}

#declare Base_Stairs_8 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <86.000000, 64.500000, 1.000000>
  translate <0.000000, 0.000000, 15.000000>
}

#declare Base_Stairs_9 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <84.000000, 63.000000, 1.000000>
  translate <0.000000, 0.000000, 17.000000>
}

#declare Base_Stairs_10 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <82.000000, 61.500000, 1.000000>
  translate <0.000000, 0.000000, 19.000000>
}

#declare Base_Stairs_11 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <80.000000, 60.000000, 1.000000>
  translate <0.000000, 0.000000, 21.000000>
}

#declare Base_Stairs_12 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <78.000000, 58.500000, 1.000000>
  translate <0.000000, 0.000000, 23.000000>
}

#declare Base_Stairs_13 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <76.000000, 57.000000, 1.000000>
  translate <0.000000, 0.000000, 25.000000>
}

#declare Base_Stairs_14 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <74.000000, 55.500000, 1.000000>
  translate <0.000000, 0.000000, 27.000000>
}

#declare Base_Stairs_15 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    White_Marble
  }
  scale <72.000000, 54.000000, 1.000000>
  translate <0.000000, 0.000000, 29.000000>
}

#declare Stairs = union {
  object { Base_Stairs_P1 }
  object { Base_Stairs_2 }
  object { Base_Stairs_3 }
  object { Base_Stairs_4 }
  object { Base_Stairs_5 }
  object { Base_Stairs_6 }
  object { Base_Stairs_7 }
  object { Base_Stairs_8 }
  object { Base_Stairs_9 }
  object { Base_Stairs_10 }
  object { Base_Stairs_11 }
  object { Base_Stairs_12 }
  object { Base_Stairs_13 }
  object { Base_Stairs_14 }
  object { Base_Stairs_15 }
  texture {
    White_Marble
  }
  bounded_by { Bound002 }
}

#declare House = union {
  object { Roof }
  object { Neon_Light }
  object { Pillars_A }
  object { Stairs }
}
object{Workmen
rotate<0,0,95>
translate<-0,0,30>}
union {   // House_T
  object { House }
  texture {
    White_Marble
  }
  bounded_by { Bound012 }
}
