// Persistence of Vision Raytracer
// Entry into the Ray Tracing Competition for October
// Subject is "Architecture"

// the standard stuff...
#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

// set the tone of the pic
default
  {
    texture
      {
        finish
          {
            ambient    0.65
            diffuse    0.6
          }
      }
  }

// an attempt at a nice white stucco
declare Stucco =
  texture
    {
      pigment
        {
          color White
        }
      finish
        {
          specular 0.1  roughness 0.5 // Very dull 
        }
    }

// shapes used repeatedly should be declared
declare Cutout =
  union
    {
      box
        {
          < -41.000,  66.000,  -1.000 >,
          <  41.000,  76.000,   1.000 >
        }
      box
        {
          < -41.000,  66.000,  -1.000 >,
          <  41.000,  76.000,   1.000 >
          rotate    <   0.000,  90.000,   0.000 >
        }
    }

declare HalfCylinderX =
  intersection
    {
      object
        {
          Cylinder_X 
        }
      box
        {
          <  -1.000,   0.000,  -1.000 >,
          <   1.000,   1.000,   1.000 >
        }
    }

declare HollowConeY =
  difference  // a hollowed out cone
    {
      object
        {
          QCone_Y
          translate <   0.000,   2.000,   0.000 >
        } 
      object
        {
          QCone_Y
          translate <   0.000,   2.000,   0.000 >
          scale     <   0.900,   1.010,   0.900 >
        } 
    } 

//--------------------------------------------------------
// parts used to create a lamp room in a light house
//--------------------------------------------------------
// pillars what support the roof
declare LightHousePillars2 =
  union
    {
      object
        {
          box
            {
              <  -0.250,   0.000,  -0.500 >,
              <   0.250,   7.000,   0.500 >
              translate <  -3.500,   0.000,   0.000 >
            }
          texture
            {
              Stucco
            }
        }
      object  // glass for the window
        {
          box
            {
              <  -0.050,   0.000,   0.000 >,
              <   0.050,   7.000,   2.500 >
            }
          texture
            {
              Glass2
            }
          translate <  -3.500,   0.000,   0.000 >
          rotate    <   0.000,  22.500,   0.000 >
        }
      object
        {
          box
            {
              <  -0.250,   0.000,  -0.500 >,
              <   0.250,   7.000,   0.500 >
              translate <  -3.500,   0.000,   0.000 >
              rotate    <   0.000,  22.500,   0.000 >
            }
          texture
            {
              Stucco
            }
        }
    }

// pillars what support the roof
declare LightHousePillars4 =
  union
    {
      object
        {
          LightHousePillars2
          rotate    <   0.000,   0.000,   0.000 >
        }
      object
        {
          LightHousePillars2
          rotate    <   0.000,  45.000,   0.000 >
        }
    }

// the whole lamp room
declare LampRoom =
  union
    {
      object    // a spire
        {
          Cone_Y
          texture
            {
              Stucco
            }
          scale     <   0.100,   0.500,   0.100 >
          translate <   0.000,   7.750,   0.000 >
        }
      object  // the roof
        {
          Cone_Y
          texture
            {
              Stucco
            }
          scale     <   4.000,   0.750,   4.000 >
          translate <   0.000,   7.000,   0.000 >
        }
      object
        {
          LightHousePillars4
          rotate    <   0.000,   0.000,   0.000 >
        }
      object
        {
          LightHousePillars4
          rotate    <   0.000,  90.000,   0.000 >
        }
      object
        {
          LightHousePillars4
          rotate    <   0.000, 180.000,   0.000 >
        }
      object
        {
          LightHousePillars4
          rotate    <   0.000, 270.000,   0.000 >
        }
      light_source
        {
          <   0.000,   3.500,   0.000 >
          color red  1.000 green  1.000 blue  1.000
          spotlight
          point_at <   3.500,   3.500,   0.000 >
          tightness 50
          radius    20.000
          falloff   25.000
        }
    }

declare Tower =
  object
    {
      union
        {
          intersection  // the small observation tower
            { 
              object
                {
                  HollowConeY
                  translate <   0.000,   2.000,   0.000 >
                  scale     <   5.000, 320.000,   5.000 >
                } 
              box
                {
                  < -10.000,   0.000, -10.000 >,
                  <  10.000,  80.000,  10.000 >
                }
              translate <-120.000,   0.000,   0.000 >
            }
          box      // a walk connecting the tower to the cathedral
            {
              <  0.000,  0.000, -2.500 >,
              < 80.000,  3.000,  2.500 >
              translate <-112.000,  65.000,   0.000 >
            }
          difference
            {
              box      // the walk support wall
                {
                  <  0.000,  0.000, -1.500 >,
                  < 80.000, 65.000,  1.500 >
                }
              object  // cut out an archway...
                {
                  HalfCylinderX
                  rotate    <   0.000,  90.000,   0.000 >
                  scale     <   8.500,  63.000,   4.000 >
                  translate <  13.000,   0.000,   0.000 >
                }
              object  // cut out an archway...
                {
                  HalfCylinderX
                  rotate    <   0.000,  90.000,   0.000 >
                  scale     <   8.500,  63.000,   4.000 >
                  translate <  32.000,   0.000,   0.000 >
                }
              object  // cut out an archway...
                {
                  HalfCylinderX
                  rotate    <   0.000,  90.000,   0.000 >
                  scale     <   8.500,  63.000,   4.000 >
                  translate <  51.000,   0.000,   0.000 >
                }
              object  // cut out an archway...
                {
                  HalfCylinderX
                  rotate    <   0.000,  90.000,   0.000 >
                  scale     <   8.500,  63.000,   4.000 >
                  translate <  70.000,   0.000,   0.000 >
                }
              translate <-112.000,   0.000,   0.000 >
            }
        }
      texture
        {
          Stucco
        }
    }

// establish the camera
camera {
   location  <   0.0,   16.0,   -40.0 >
   direction <   0.0,    0.0,     1.5 >
   up        <   0.0,    1.0,     0.0 >
   right     <   1.33,   0.0,     0.0 >
   look_at   <   0.0,   14.0,     0.0 >
}

include "scene2.inc"

//--------------------------------------------------------
// the sun...
//--------------------------------------------------------
object
  { 
    union
      {
        sphere
          {
            <   0.000,   0.000,   0.000 >, 15
          texture
            {
              pigment
                {
                  color White filter .35
                }
              finish
                {
                  ambient 1.0
                  diffuse 0.0
                }
            }
          }
        light_source
          {
            <   0.000,   0.000,   0.000 > color White
          }
      }
    translate <  36.000,   0.000, -780000 >
  }

//--------------------------------------------------------
// the BUILDING...
//--------------------------------------------------------
object
  {
    union
      {
        difference  // the large central cathedral
          {
            union
              {
                intersection   // the central spire
                  { 
                    object
                      {
                        HollowConeY
                        scale     <  20.000, 320.000,  20.000 >
                      }
                    box
                      {
                        < -40.000,   0.000, -40.000 >,
                        <  40.000,  80.000,  40.000 >
                      }
                  }
                intersection   // the outset ring in the center
                  { 
                    object
                      {
                        QCone_Y
                        translate <   0.000,   2.000,   0.000 >
                        scale     <  20.000, 320.000,  20.000 >
                      } 
                    box
                      {
                        < -40.000,  42.000, -40.000 >,
                        <  40.000,  67.000,  40.000 >
                      }
                    scale     <   1.100,   1.000,   1.100 >
                  }
                intersection   // the outset ring at the top
                  { 
                    object
                      {
                        QCone_Y
                        translate <   0.000,   2.000,   0.000 >
                        scale     <  20.000, 320.000,  20.000 >
                      } 
                    box
                      {
                        < -40.000,  75.000, -40.000 >,
                        <  40.000,  80.000,  40.000 >
                      }
                    scale     <   1.100,   1.000,   1.100 >
                  }
              }
            object
              {
                Cutout
              }
            object
              {
                Cutout
                rotate    <   0.000,  22.500,   0.000 >
              }
            object
              {
                Cutout
                rotate    <   0.000,  45.000,   0.000 >
              }
            object
              {
                Cutout
                rotate    <   0.000,  67.500,   0.000 >
              }
            object  // cut out an doorway...
              {
                HalfCylinderX
                scale     <  20.000,   8.000,   4.000 >
                translate < -30.000,  65.000,   0.000 >
              }
          }
        // a dome on top
        difference
          {
            sphere
              {
                <   0.000,   0.000,   0.000 >,  1.000
              }
            box  // cut off bottom
              {
                <  -1.000,  -1.000,  -1.000 >,
                <   1.000,   0.000,   1.000 >
              }
            scale     <  35.000,  35.000,  35.000 >
            translate <   0.000,  80.000,   0.000 >
          }
        object
          {
            LampRoom
            translate <   0.000, 115.000,   0.000 >
          }
        object
          {
            Tower
          }
        object
          {
            Tower
            rotate    <   0.000,-160.000,   0.000 >
          }
      }
    texture
      {
        Stucco
      }
    translate <  85.000,   0.000, 380.000 >
  }

