// File: bare_room.pov

#declare kitchen_length = (10*FEET)
#declare kitchen_width  = (12*FEET)
#declare kitchen_height = ( 8*FEET)+6

#declare counter_height = (3*FEET)

#declare doorway_height = (7*FEET)

// ============================================================
// North wall
// ============================================================

#declare north_doorway_left_edge  = (4*FEET)+6
#declare north_doorway_right_edge = (8*FEET)+6

box     { <  0, 0,              0                       >,
          < -6, kitchen_height, north_doorway_left_edge >
          texture { WhiteEnamelOnSheetrock } }

box     { <  0, doorway_height, north_doorway_left_edge  >,
          < -6, kitchen_height, north_doorway_right_edge >
          texture { WhiteEnamelOnSheetrock } }

box     { <  0, 0,              north_doorway_right_edge >,
          < -6, kitchen_height, kitchen_width            >
          texture { WhiteEnamelOnSheetrock } }

// ------------------------------------------------------------
// light switch plate
// ------------------------------------------------------------

#declare north_wall_switch_height = counter_height + (1*FEET)

box      { < 0,   north_wall_switch_height,     north_doorway_left_edge - 6 >,
           < 0.5, north_wall_switch_height + 4, north_doorway_left_edge - 3 >
          texture { WhiteBakelite } }

// ============================================================
// South wall
// ============================================================

#declare south_doorway_left_edge  = (4*FEET)+9
#declare south_doorway_right_edge = (8*FEET)+3

box     { < kitchen_length,     0,              0                       >,
          < kitchen_length + 6, kitchen_height, south_doorway_left_edge >
          texture { WhiteEnamelOnSheetrock } }

box     { < kitchen_length,     doorway_height, south_doorway_left_edge  >,
          < kitchen_length + 6, kitchen_height, south_doorway_right_edge >
          texture { WhiteEnamelOnSheetrock } }

box     { < kitchen_length,     0,              south_doorway_right_edge >,
          < kitchen_length + 6, kitchen_height, kitchen_width            >
          texture { WhiteEnamelOnSheetrock } }

// ============================================================
// West wall
// ============================================================

#declare  west_window_bottom = (4*FEET)+6
#declare  west_window_top    = (7*FEET)+1

#declare  west_window_right_edge = (2*FEET)+6
#declare  west_window_left_edge  = (6*FEET)
#declare  west_window_center     = (4*FEET)+3

box     { < -6,                     0,              -6 >,
          < west_window_right_edge, kitchen_height,  0 >
          texture { WhiteEnamelOnSheetrock } }

box     { < west_window_right_edge, 0,                  -6 >,
          < west_window_left_edge,  west_window_bottom,  0 >
          texture { WhiteEnamelOnSheetrock } }

box     { < west_window_right_edge, west_window_top, -6 >,
          < west_window_left_edge,  kitchen_height,   0 >
          texture { WhiteEnamelOnSheetrock } }

box     { < west_window_left_edge,   0,              -6 >,
          < kitchen_length + 6,      kitchen_height,  0 >
          texture { WhiteEnamelOnSheetrock } }

// ============================================================
// Floor
// ============================================================

box     { <  -6,                -6, -6                >,
          < kitchen_length + 6,  0, kitchen_width + 6 >
          texture { LinoleumTiles } }

// ============================================================
// Ceiling
// ============================================================

//box     { <  -6,                kitchen_height,     -6                 >,
//          < kitchen_length + 6, kitchen_height + 6,  kitchen_width + 6 >
//          texture { WhiteStuccoCeiling } }

// ============================================================
// End of file
// ============================================================
