 
// File: counter.pov

#declare cabinet_depth    = (2*FEET)

#declare sink_right_edge  = (3*FEET)
#declare sink_left_edge   = (5*FEET)+6
#declare sink_center      = (4*FEET)+3
 
// ============================================================
// Bottom cabinet pedestals - NW wall
// ============================================================
 
box      { < 0,                 0, cabinet_depth - 3           >
           < cabinet_depth - 3, 3, north_doorway_left_edge - 6 >
           texture { WhiteEnamelOnWood } }
 
box      { < 0,              0, 0                 >
           < kitchen_length, 3, cabinet_depth - 3 >
           texture { WhiteEnamelOnWood } }
 
// ============================================================
// Bottom cabinets - NW wall
// ============================================================
 
box      { < 0,             3,                  cabinet_depth               >
           < cabinet_depth, counter_height - 1, north_doorway_left_edge - 3 >
           texture { WhiteEnamelOnWood } }

box      { < 0,               3,                  0             >
           < sink_right_edge, counter_height - 1, cabinet_depth >
           texture { WhiteEnamelOnWood } }

box      { < sink_right_edge, 3,                  cabinet_depth - 2 > 
           < sink_left_edge,  counter_height - 1, cabinet_depth     >
           texture { WhiteEnamelOnWood } }
 
box      { < sink_left_edge, 3,                  0             >
           < kitchen_length, counter_height - 1, cabinet_depth >
           texture { WhiteEnamelOnWood } }

// ------------------------------------------------------------
// Bottom cabinet doors - NW wall
// ------------------------------------------------------------

box      { < sink_left_edge - 0.25,  4,                  cabinet_depth        >
           < sink_center,            counter_height - 2, cabinet_depth + 0.25 >
           texture { WhiteEnamelOnWood } }

box      { < sink_center,            4,                  cabinet_depth        >
           < sink_right_edge + 0.25, counter_height - 2, cabinet_depth + 0.25 >
           texture { WhiteEnamelOnWood } }

box      { < sink_right_edge - 1, 4,                  cabinet_depth        >
           < cabinet_depth   + 1, counter_height - 2, cabinet_depth + 0.25 >
           texture { WhiteEnamelOnWood } }

box      { < cabinet_depth,        4,                  cabinet_depth + 1  >
           < cabinet_depth + 0.25, counter_height - 2, cabinet_depth + 10 >
           texture { WhiteEnamelOnWood } }
 
// ============================================================
// Countertop - NW wall
// ============================================================
 
box      { < 0,             counter_height - 1, cabinet_depth               >
           < cabinet_depth, counter_height,     north_doorway_left_edge - 3 >
           texture { Formica } }

difference {
    box      { < 0,              counter_height - 1, 0             >
               < kitchen_length, counter_height,     cabinet_depth >       }

    box      { < sink_left_edge  - 1, counter_height - 2, 3                 >
               < sink_right_edge + 1, counter_height + 1, cabinet_depth - 3 > }

    texture { Formica } }

box { < 0,              counter_height,            0   >
      < kitchen_length, counter_height + (1*FEET), 0.1 >
      texture { Formica } }

box { < 0,   counter_height,            0                           >
      < 0.1, counter_height + (1*FEET), north_doorway_left_edge - 3 >
      texture { Formica } }

difference {
    box { < 0, counter_height,           0 >
          < 2, counter_height +(1*FEET), 2 > }

    cylinder { < 2  counter_height + 1.9,      2 >
               < 2, counter_height + (1*FEET), 2 > 1.9 }

    sphere { < 2  counter_height + 1.9, 2 > 1.9 }

    texture { Formica }
}

difference {
    box { < 0,              counter_height,       0 >
          < kitchen_length, counter_height + 1.9, 2 > }

    cylinder { < -1,                  counter_height + 1.9, 2 >
               < kitchen_length  + 1, counter_height + 1.9, 2 > 1.9 }

    texture { Formica }
}

difference {
    box { < 0, counter_height,       0                           >
          < 2, counter_height + 1.9, north_doorway_left_edge - 3 > }

    cylinder { < 2, counter_height + 1.9, -1 >
               < 2, counter_height + 1.9, north_doorway_left_edge > 1.9 }

    texture { Formica }
}

// ------------------------------------------------------------
// Countertop rounded edges - NW wall
// ------------------------------------------------------------

cylinder { < 0,             counter_height - 0.5, north_doorway_left_edge - 3 >
           < cabinet_depth, counter_height - 0.5, north_doorway_left_edge - 3 >
	   0.5
           texture { Formica } }

sphere   { < cabinet_depth, counter_height - 0.5, north_doorway_left_edge - 3 >
	   0.5
           texture { Formica } }

cylinder { < cabinet_depth, counter_height - 0.5, cabinet_depth               >
           < cabinet_depth, counter_height - 0.5, north_doorway_left_edge - 3 >
	   0.5
           texture { Formica } }

cylinder { < cabinet_depth,  counter_height - 0.5, cabinet_depth >
           < kitchen_length, counter_height - 0.5, cabinet_depth >
	   0.5
           texture { Formica } }

// ------------------------------------------------------------
// sponge
// ------------------------------------------------------------

box { < -2, counter_height,     -3 >
      <  2, counter_height + 1,  3 >
      rotate < 0, 51, 0 >
      translate < (2*FEET)+4, 0, 15 >
      texture { YellowSponge } }

// ------------------------------------------------------------
// toaster
// ------------------------------------------------------------
      
difference {
    union {
        box { < -4.5, counter_height,     -3.0 >
              <  4.5, counter_height + 5,  3.0 > }

        box { < -4.0, counter_height,     -3.5 >
              <  4.0, counter_height + 5,  3.5 > }

        box { < -4.0, counter_height + 4.5, -3.0 >
              <  4.0, counter_height + 5.5,  3.0 > }

        cylinder { < -4.0, counter_height,     -3.0 >
                   < -4.0, counter_height + 5, -3.0 > 0.5 }
        
        cylinder { <  4.0, counter_height,     -3.0 >
                   <  4.0, counter_height + 5, -3.0 > 0.5 }
        
        cylinder { < -4.0, counter_height,      3.0 >
                   < -4.0, counter_height + 5,  3.0 > 0.5 }
        
        cylinder { <  4.0, counter_height,      3.0 >
                   <  4.0, counter_height + 5,  3.0 > 0.5 }

        cylinder { < -4.0, counter_height + 5,  3.0 >
                   <  4.0, counter_height + 5,  3.0 > 0.5 }

        cylinder { < -4.0, counter_height + 5, -3.0 >
                   <  4.0, counter_height + 5, -3.0 > 0.5 }
        
        cylinder { <  4.0, counter_height + 5, -3.0 >
                   <  4.0, counter_height + 5,  3.0 > 0.5 }

        cylinder { <  4.0, counter_height + 5,  3.0 >
                   < -4.0, counter_height + 5,  3.0 > 0.5 }

        sphere   { <  4.0, counter_height + 5,  3.0 > 0.5 }
        sphere   { < -4.0, counter_height + 5,  3.0 > 0.5 }
        sphere   { <  4.0, counter_height + 5, -3.0 > 0.5 }
        sphere   { < -4.0, counter_height + 5, -3.0 > 0.5 }

    }

    box { < -3,   counter_height + 1, -2 >
          <  3,   counter_height + 6, -1 > }

    box { < -3,   counter_height + 1,  2 >
          <  3,   counter_height + 6,  1 > }

    rotate < 0, 15, 0 >
    translate < 15, 0.5, 11 >
    texture { StainlessSteel } }

// ------------------------------------------------------------
// coffee cup
// ------------------------------------------------------------

#declare coffee_cup = union {
    difference {
        cylinder { < 0, 0.25, 0 > < 0, 4.0, 0 > 1.75 }
        cylinder { < 0, 0.50, 0 > < 0, 4.1, 0 > 1.65 } }

    cylinder { < 0, 0, 0 > < 0, 0.25, 0 > 1.5 }

    difference {
      torus { 1 0.25 rotate < 90 0 0 > translate < -1.75, 2, 0 > }
      cylinder { < 0, 0.1, 0 > < 0, 3.6, 0 > 1.64 } }

    rotate < 0, -10, 0 >
    translate < (6*FEET)+2, counter_height, 9 >
    texture { ChinaPlate }
}

object { coffee_cup }

// ============================================================
// End of file
// ============================================================
