// Kitchen.pov

// All units in inches
#declare FEET = 12.0
#declare MILE = (5280*FEET)

#include "kitchen_textures.pov"
#include "outside.pov"
#include "bare_room.pov"
#include "sink.pov"
#include "counter.pov"
#include "window.pov"
#include "top_cabinets.pov"

// ============================================================
// Camera
// ============================================================

camera { location < (5*FEET),   (5*FEET)+6, (5*FEET) >
         look_at  < (4*FEET)+6, (5*FEET),   (3*FEET) > }

// ============================================================
// Light
// ============================================================

light_source { < (6*FEET), (9*FEET), (-4*FEET) >
               color rgb < 1.6, 1.6, 2.0 > }

light_source { < (8*FEET), (9*FEET), (10*FEET) >
               color rgb < 0.8, 0.8, 1.0 > }

// ============================================================
// End of file
// ============================================================
