// File: sink.pov

#declare sink_bottom = counter_height - 7
#declare sink_top    = counter_height - 0.1

#declare cabinet_depth  = (2*FEET)

#declare sink_right_edge  = (3*FEET)
#declare sink_left_edge   = (5*FEET)+6
#declare sink_center = sink_left_edge - 17
 
// ============================================================
// Sink Basins
// ============================================================
 
 difference {
 
   box { < sink_right_edge + 1, sink_bottom - 1, 3                 >
         < sink_left_edge  - 1, sink_top,        cabinet_depth - 3 > }
 
   // ------------------------------------------------------------
   // left basin
   // ------------------------------------------------------------
 
   box { < sink_left_edge - 4, sink_bottom + 2, 6                 >
         < sink_center    + 3, sink_top    + 1, cabinet_depth - 4 > }
 
  box { < sink_left_edge - 2, sink_bottom + 2, 8                 >
        < sink_center    + 1, sink_top    + 1, cabinet_depth - 6 > }

  box { < sink_left_edge - 4, sink_bottom,     8                 >
        < sink_center    + 3, sink_bottom + 3, cabinet_depth - 6 > }

  cylinder { < sink_left_edge - 4, sink_bottom + 2, 8 >
             < sink_left_edge - 4, sink_top    + 2, 8 > 2 }

  cylinder { < sink_left_edge - 4, sink_bottom + 2, cabinet_depth - 6 >
             < sink_left_edge - 4, sink_top    + 2, cabinet_depth - 6 > 2 }

  cylinder { < sink_center    + 3, sink_bottom + 2, 8 >
             < sink_center    + 3, sink_top    + 2, 8 > 2 }

  cylinder { < sink_center    + 3, sink_bottom + 2, cabinet_depth - 6 >
             < sink_center    + 3, sink_top    + 2, cabinet_depth - 6 > 2 }

  sphere   { < sink_left_edge - 4, sink_bottom + 2, cabinet_depth - 6 > 2 }
  sphere   { < sink_left_edge - 4, sink_bottom + 2, 8                 > 2 }
  sphere   { < sink_center    + 3, sink_bottom + 2, cabinet_depth - 6 > 2 }
  sphere   { < sink_center    + 3, sink_bottom + 2, 8                 > 2 }

  cylinder { < sink_left_edge - 4, sink_bottom + 2, 8 >
             < sink_center    + 3, sink_bottom + 2, 8 > 2 }

  cylinder { < sink_left_edge - 4, sink_bottom + 2, cabinet_depth - 6 >
             < sink_center    + 3, sink_bottom + 2, cabinet_depth - 6 > 2 }

  cylinder { < sink_left_edge - 4, sink_bottom + 2, 8 >
             < sink_left_edge - 4, sink_bottom + 2, cabinet_depth - 6 > 2 }

  cylinder { < sink_center    + 3, sink_bottom + 2, 8 >
             < sink_center    + 3, sink_bottom + 2, cabinet_depth - 6 > 2 }

  cylinder { < sink_left_edge - 9, sink_bottom + 1, 13 >
             < sink_left_edge - 9, sink_bottom - 5, 13 > 2 }

  // ------------------------------------------------------------
  // right basin
  // ------------------------------------------------------------

  box { < sink_center     - 3, sink_bottom + 2, 6                 >
        < sink_right_edge + 4, sink_top    + 1, cabinet_depth - 4 > }

  box { < sink_center     - 1, sink_bottom + 2, 8                 >
        < sink_right_edge + 2, sink_top    + 1, cabinet_depth - 6 > }

  box { < sink_center     - 3, sink_bottom,     8                 >
        < sink_right_edge + 4, sink_bottom + 3, cabinet_depth - 6 > }

  cylinder { < sink_center - 3,     sink_bottom + 2, 8 >
             < sink_center - 3,     sink_top    + 2, 8 > 2 }

  cylinder { < sink_center - 3,     sink_bottom + 2, cabinet_depth - 6 >
             < sink_center - 3,     sink_top    + 2, cabinet_depth - 6 > 2 }

  cylinder { < sink_right_edge + 4, sink_bottom + 2, cabinet_depth - 6 >
             < sink_right_edge + 4, sink_top    + 2, cabinet_depth - 6 > 2 }

  cylinder { < sink_right_edge + 4, sink_bottom + 2, 8 >
             < sink_right_edge + 4, sink_top    + 2, 8 > 2 }

  sphere   { < sink_center     - 3, sink_bottom + 2, cabinet_depth - 6 > 2 }
  sphere   { < sink_center     - 3, sink_bottom + 2, 8                 > 2 }
  sphere   { < sink_right_edge + 4, sink_bottom + 2, cabinet_depth - 6 > 2 }
  sphere   { < sink_right_edge + 4, sink_bottom + 2, 8                 > 2 }

  cylinder { < sink_center     - 3, sink_bottom + 2, 8 >
             < sink_right_edge + 4, sink_bottom + 2, 8 > 2 }

  cylinder { < sink_center     - 3, sink_bottom + 2, cabinet_depth - 6 >
             < sink_right_edge + 4, sink_bottom + 2, cabinet_depth - 6 > 2 }

  cylinder { < sink_center     - 3, sink_bottom + 2, 8 >
             < sink_center     - 4, sink_bottom + 2, cabinet_depth - 6 > 2 }

  cylinder { < sink_right_edge + 4, sink_bottom + 2, 8 >
             < sink_right_edge + 4, sink_bottom + 2, cabinet_depth - 6 > 2 }

  cylinder { < sink_right_edge + 7, sink_bottom + 1, 13 >
             < sink_right_edge + 7, sink_bottom - 5, 13 > 2 }

  texture { StainlessSteel } }

// ============================================================
// Faucets
// ============================================================

intersection {
    cylinder { < sink_center - 5, sink_top,        4.5 >
               < sink_center - 5, sink_top + 0.25, 4.5 > 2  }

    cylinder { < sink_center + 5, sink_top,        4.5 >
               < sink_center + 5, sink_top + 0.25, 4.5 > 2  }

    box      { < sink_center - 6, sink_top,        3.5 >
               < sink_center + 6, sink_top + 0.25, 5.5 > }

    cylinder { < sink_center + 5, sink_top, 4.5 >
               < sink_center - 5, sink_top, 4.5 > 2 }

    texture { StainlessSteel } }

cylinder { < sink_center, sink_top,     4.5 >
           < sink_center, sink_top + 2, 4.5 > 1
           texture { StainlessSteel } }

intersection {
    sphere { < sink_center, sink_top + 2.1, 4.5 > 1.25 }
    box    { < sink_center - 1.5, sink_top + 2.1, 2    >
             < sink_center + 1.5, sink_top + 3.1, 6    > }
    texture { StainlessSteel } }

// ------------------------------------------------------------
// Faucet arm
// ------------------------------------------------------------

union {
    box      { < -0.5, 0, 0 > < 0.5, 0.5, 8 >     }

    intersection {
        difference {
            cylinder { < -0.5, -2, 8  > < 0.5, -2, 8 > 2.5 }
            cylinder { < -1,   -2, 8  > < 1,   -2, 8 > 2   }
        }
        box      { < -1,   -2, 8  > < 1, 1, 11 > }
        box      { < -1,    0, 0  > < 1, 5, 5 >
                   rotate < -30, 0, 0 > translate < 0, -2, 8 > }
    }

    union {
        box      { < -0.5, 2, 0 > < 0.5, 2.5, 1 > }
        cylinder { <    0, 2, 1 > <   0, 2.5, 1 > 0.5 }
        cylinder { <    0, 2, 1 > <   0, 1.8, 1 > 0.3 }
        rotate < 30, 0, 0 > translate < 0, -2, 8 >
    }

    rotate    < -30,  0, 0 >
    rotate    <   0, 83, 0 >
    translate < sink_center, sink_top + 0.5, 4.5 >

    texture { StainlessSteel }
}

union {
    box      { < -0.5, 0, 0 > < 0.5, 0.5, 6 >     }
    cylinder { <    0, 0, 6 > <   0, 0.5, 6 > 0.5 }
    rotate    < -30,   0, 0 >
    rotate    <   0, -52, 0 >
    translate < sink_center, sink_top + 2.1, 4.5 >

    texture { StainlessSteel }
}

// ============================================================
// Sink Rim
// ============================================================

box      { < sink_right_edge,     sink_top,       4                 >
           < sink_right_edge + 1, sink_top + 0.2, cabinet_depth - 4 >
           texture { StainlessSteel } }

box      { < sink_left_edge - 1, sink_top,       4                 >
           < sink_left_edge,     sink_top + 0.2, cabinet_depth - 4 >
           texture { StainlessSteel } }

box      { < sink_left_edge  - 2, sink_top,       2 >
           < sink_right_edge + 2, sink_top + 0.2, 3 >
           texture { StainlessSteel } }

box      { < sink_left_edge  - 2, sink_top,       cabinet_depth - 2 >
           < sink_right_edge + 2, sink_top + 0.2, cabinet_depth - 3 >
           texture { StainlessSteel } }

#declare sink_rim_corner =
intersection
{
    difference {
        cylinder { < 0, sink_top,     0 > < 0, sink_top + 0.2, 0 > 2 }
        cylinder { < 0, sink_top - 1, 0 > < 0, sink_top + 1,   0 > 1 }
    }

    box { < 0, sink_top - 1, 0 > < 3, sink_top + 1, 3 > }

    texture { StainlessSteel }
}

object { sink_rim_corner
         translate < sink_left_edge - 2, 0, cabinet_depth - 4 > }

object { sink_rim_corner
	 rotate    < 0, 270, 0 >
         translate < sink_right_edge + 2, 0, cabinet_depth - 4 > }

object { sink_rim_corner
	 rotate    < 0, 180, 0 >
         translate < sink_right_edge + 2, 0, 4 > }

object { sink_rim_corner
	 rotate    < 0, 90, 0 >
         translate < sink_left_edge - 2, 0, 4 > }

// ============================================================
// End of file
// ============================================================
