#declare Table = intersection {
	plane {y, 0}
	plane {z, 2}
	texture {My_wood rotate y*90}
	texture {
		pigment { rgbf <0.1, 0.02, 0, 0.3>}
		finish { ambient 1 diffuse 1 phong 1 reflection 0.12}
	}
}

#declare Wall = difference {
	intersection {
		plane {-z, -2}
		plane {z, 2.8}
	}
	intersection {
		plane {-x, 2.83}
		plane {x, 3}
		plane {y, 3}
		plane {-y, 3}
		translate <1, 3.5, 0>
	}
	intersection {
		plane {-x, 0 rotate y*70 translate -x*2.83}
		plane {x, 3 rotate -y*40}
		plane {y, 3 rotate x*10}
		plane {-y, 3 rotate -x*5}
		translate <1, 3.5, 2.5>
		pigment {color rgb <0.8, 0.7, 0.5>}
		finish {ambient 0.2 phong 1}
	}
	pigment {color rgb <0.8, 0.7, 0.5>}
	finish {ambient 0.2 phong 1}
	normal {bumps 0.25 scale 0.02}
}

#declare Frame = difference {
	intersection {
		plane {-z, -2.5}
		plane {z, 2.8}
	}
	box {<-2.8, -2.94, 2.4>, <2.8, 2.8, 2.9>}
	translate <1, 3.5, 0>
	texture {My_wood scale <1, 0.75, 1> rotate y*90}
	texture {
		pigment { rgbf <0.3, 0.18, 0.15, 0.35>}
		finish { ambient 1 diffuse 1 phong 1}
	}
}

#declare Half = union {
	difference {
		box {<-2.85, -2.97, -0.1>, <2.85/2, 2.97, 0>}
		box {<-2.7, -2.82, -0.3>, <2.7/2, 2.82, 0.1>}
		texture {My_wood scale <1, 0.75, 1> rotate y*90}
		texture {
			pigment { rgbf <0.3, 0.18, 0.15, 0.35>}
			finish { ambient 1 diffuse 1 phong 1}
		}
	}
	difference {
		box {<-2.8, -2.9, -0.06>, <2.8/2, 2.97, 0>
			texture {My_glass}
		}
		box {<-2.9, -3, -0.04>, <2.9/2, 3, 0.1>
			texture {
				My_glass
				normal {
					bump_map {
						gif "rain.gif"
						bump_size -4
					}
					scale 0.6
				}
			}
		}
	}
}

#declare Window = union {
	object {Frame}
	object {
		Half
		translate x*2.85 rotate y*135 translate -x*2.85
		translate <1.04, 3.5, 2.46>
	}
	object {
		Half
		translate <4, 3.5, 2.45>
	}
}

#declare House = object {
	union {
		smooth_triangle {
		<0, 0, 0>, <0, 0, -1>,
		<0, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
		smooth_triangle {
		<0, 1, 0>, <0, 0, -1>,
		<1, 1, 0>, <0, 0, -1>,
		<1, 0, 0>, <0, 0, -1>
		}
	}
	texture {
		pigment {
			image_map {
				gif "house.gif"
				once
				map_type 0
				filter 255, 1
				interpolate 2
			}
		}
		finish { ambient 0.3 diffuse 0.5 phong 0 }
	}
	no_shadow
	scale <1.333, 1, 1>
	scale 2.5
	translate <1.7, 0.6, 3.5>
}

#declare Sky = intersection {
	plane {
		y, 10
		pigment {
			bozo
			turbulence 1
			color_map {
			[0.0 0.4 color rgbf <0.5, 0.5, 0.55, 0.6> color rgbf <0.5, 0.5, 0.55, 0.6>]
			[0.4 0.8 color rgbf <0.5, 0.5, 0.55, 0.6> color rgbf <1, 1, 1, 0.9>]
			[0.8 1.0 color rgbf <1, 1, 1, 0.9> color rgbf <1, 1, 1, 0.9>]
			}
			scale <15, 1, 13>
		}
		finish {ambient 1 phong 0}
		rotate x*5
	}
	plane {-z, -2.801
		pigment {color rgbf <1, 1, 1, 1>}
		finish {ambient 1 phong 0}
	}
	no_shadow
}

#declare Environment = union {
	object {Wall}
	object {House}
	object {Sky}
	object {Window}
}











