#declare Spoon = union {
	difference {
		sphere {<0, 0, 0>, 0.2 scale <1.5, 0.5, 0.8>}
		plane {-y, 0}
		sphere {<0, 0, 0>, 0.2 scale <1.5, 0.5, 0.8> scale 0.95}
	}
	difference {
    	cylinder {<0, 0, -0.025>, <0, 0, 0.025>, 0.05}
		cylinder {<0, 0, -0.03>, <0, 0, 0.03>, 0.04}
		plane {y, 0}
		plane {-x, 0 rotate z*10}
		translate <0.04+0.3, 0, 0>
	}
	union {
		box {<0, 0.04, -0.025>, <1.1, 0.05, 0.025>}
		sphere {<0, 0, 0>, 0.5
			scale <0.35, 0.02, 0.12>
			translate <1.1, 0.045, 0>
		}
		sphere {<0, 0, 0>, 0.35
			scale <0.35, 0.05, 0.12>
			translate <1.1, 0.045, 0>
		}
		rotate z*10
		translate x*0.34
	}
	texture {My_chrome}

	translate x*0.3
	rotate <-10, 0, 60>
	translate <-0.1, 0.2, 0>
}


#declare Tea = union {
	difference {	// glass
		merge {
			difference {
				sphere {
					<0, 0.5, 0>, 0.5
					scale <1, 0.4, 1>
					translate -y*0.1
				}
				plane {y, 0}
			}
			cylinder {<0, 0.1, 0>, <0, 1.4, 0>, 0.5}
		}
		difference {
			cylinder {<0, 0.08, 0>, <0, 1.5, 0>, 0.48}
			sphere {<0, 0, 0>, 0.48 scale <1, 0.2, 1> translate y*0.1}
		}
		texture {My_glass}
	}
	cylinder {	// tea
		<0, 0.0799, 0>, <0, 1.15, 0>, 0.4799
		pigment {color rgbf <0.7, 0.1, 0, 0.9>}
		finish {
			ambient 0.2
			phong 1
			refraction 1
			ior 1.2
		}
	}
	union {
		box {	// sugar
			<-0.2, 0.0799, -0.12>, <0.2, 0.2, 0.12>
			pigment {color rgb <1, 1, 1>}
			finish {ambient 0.45 phong 1}
			normal {bumps -0.5 scale 0.004}
		}
		union {	// bubbles
			sphere {<-0.08, 0.4, 0.15>, 0.01}
			sphere {<-0.11, 0.45, 0.15>, 0.01}
			sphere {<-0.13, 0.5, 0.15>, 0.011}
			sphere {<-0.06, 0.55, 0.15>, 0.012}
			sphere {<-0.10, 0.6, 0.15>, 0.01}
			sphere {<-0.06, 0.7, 0.15>, 0.01}
			sphere {<-0.09, 0.8, 0.15>, 0.008}
			sphere {<-0.08, 0.9, 0.15>, 0.008}
			pigment {color rgb <1, 0.8, 0.6>}
			finish {ambient 0.5 phong 1}
			no_shadow
		}
		rotate -y*30
		translate <-0.1, 0, -0.1>
	}
	object {Spoon}
	scale 0.32
}