// Persistence of Vision Raytracer 2.2

// Direction Vectors for Field of View angles from 1-180 degrees.
//
// Use in camera statement as follows:
//
//     direction <0, 0, FoV45 * Height_or_Width>
//
// The formula used to calculate the FoV constants is:
//
//     FoV = 1 / ( 2 * tan ( angle / 2 ) )
//
// These constants set the field of view angle for a view window that is
// either 1.0 unit high or 1.0 unit wide.  To set a 60 degree horizontal
// field of view where "right" equals <4/3, 0, 0>, multiply the FoV
// constant by the width of the window as follows:
//
//     direction <0, 0, FoV60 * 4/3>
//
// Notes: If the FoV constant is omitted and direction is set equal to
// right, the horizontal field of view is approximately 53 degrees.  If
// direction equals 1 when right equals 4/3, the horizontal field of
// view is approximately 67 degrees.  Angles beyond 180 degrees are not
// included below, because PoVRay uses the absolute value of the
// direction vector.

#declare FoV1 = 57.29432506 
#declare FoV2 = 28.64498082 
#declare FoV3 = 19.09422965 
#declare FoV4 = 14.31812664 
#declare FoV5 = 11.45188277 
#declare FoV6 = 9.54056834 
#declare FoV7 = 8.17492774 
#declare FoV8 = 7.15033313 
#declare FoV9 = 6.35310237 
#declare FoV10 = 5.71502615 
#declare FoV11 = 5.19269854 
#declare FoV12 = 4.75718223 
#declare FoV13 = 4.38844368 
#declare FoV14 = 4.07217321 
#declare FoV15 = 3.79787706 
#declare FoV16 = 3.55768486 
#declare FoV17 = 3.34557812 
#declare FoV18 = 3.15687576 
#declare FoV19 = 2.98788218 
#declare FoV20 = 2.83564091 
#declare FoV21 = 2.69775859 
#declare FoV22 = 2.57227701 
#declare FoV23 = 2.45757852 
#declare FoV24 = 2.35231505 
#declare FoV25 = 2.25535425 
#declare FoV26 = 2.16573794 
#declare FoV27 = 2.08264989 
#declare FoV28 = 2.00539047 
#declare FoV29 = 1.93335655 
#declare FoV30 = 1.86602540 
#declare FoV31 = 1.80294175 
#declare FoV32 = 1.74370722 
#declare FoV33 = 1.68797171 
#declare FoV34 = 1.63542631 
#declare FoV35 = 1.58579740 
#declare FoV36 = 1.53884177 
#declare FoV37 = 1.49434248 
#declare FoV38 = 1.45210544 
#declare FoV39 = 1.41195644 
#declare FoV40 = 1.37373871 
#declare FoV41 = 1.33731075 
#declare FoV42 = 1.30254453 
#declare FoV43 = 1.26932395 
#declare FoV44 = 1.23754343 
#declare FoV45 = 1.20710678 
#declare FoV46 = 1.17792618 
#declare FoV47 = 1.14992127 
#declare FoV48 = 1.12301839 
#declare FoV49 = 1.09714987 
#declare FoV50 = 1.07225346 
#declare FoV51 = 1.04827180 
#declare FoV52 = 1.02515192 
#declare FoV53 = 1.00284485 
#declare FoV54 = 0.98130525 
#declare FoV55 = 0.96049106 
#declare FoV56 = 0.94036323 
#declare FoV57 = 0.92088544 
#declare FoV58 = 0.90202388 
#declare FoV59 = 0.88374701 
#declare FoV60 = 0.86602540 
#declare FoV61 = 0.84883156 
#declare FoV62 = 0.83213974 
#declare FoV63 = 0.81592584 
#declare FoV64 = 0.80016726 
#declare FoV65 = 0.78484279 
#declare FoV66 = 0.76993248 
#declare FoV67 = 0.75541760 
#declare FoV68 = 0.74128048 
#declare FoV69 = 0.72750451 
#declare FoV70 = 0.71407400 
#declare FoV71 = 0.70097415 
#declare FoV72 = 0.68819096 
#declare FoV73 = 0.67571122 
#declare FoV74 = 0.66352241 
#declare FoV75 = 0.65161269 
#declare FoV76 = 0.63997082 
#declare FoV77 = 0.62858615 
#declare FoV78 = 0.61744858 
#declare FoV79 = 0.60654850 
#declare FoV80 = 0.59587680 
#declare FoV81 = 0.58542478 
#declare FoV82 = 0.57518420 
#declare FoV83 = 0.56514719 
#declare FoV84 = 0.55530626 
#declare FoV85 = 0.54565425 
#declare FoV86 = 0.53618436 
#declare FoV87 = 0.52689006 
#declare FoV88 = 0.51776516 
#declare FoV89 = 0.50880370 
#declare FoV90 = 0.50000000 
#declare FoV91 = 0.49134863 
#declare FoV92 = 0.48284439 
#declare FoV93 = 0.47448228 
#declare FoV94 = 0.46625754 
#declare FoV95 = 0.45816559 
#declare FoV96 = 0.45020202 
#declare FoV97 = 0.44236263 
#declare FoV98 = 0.43464337 
#declare FoV99 = 0.42704034 
#declare FoV100 = 0.41954982 
#declare FoV101 = 0.41216819 
#declare FoV102 = 0.40489202 
#declare FoV103 = 0.39771796 
#declare FoV104 = 0.39064281 
#declare FoV105 = 0.38366349 
#declare FoV106 = 0.37677703 
#declare FoV107 = 0.36998054 
#declare FoV108 = 0.36327126 
#declare FoV109 = 0.35664653 
#declare FoV110 = 0.35010377 
#declare FoV111 = 0.34364048 
#declare FoV112 = 0.33725426 
#declare FoV113 = 0.33094278 
#declare FoV114 = 0.32470380 
#declare FoV115 = 0.31853513 
#declare FoV116 = 0.31243468 
#declare FoV117 = 0.30640039 
#declare FoV118 = 0.30043031 
#declare FoV119 = 0.29452251 
#declare FoV120 = 0.28867513 
#declare FoV121 = 0.28288639 
#declare FoV122 = 0.27715453 
#declare FoV123 = 0.27147785 
#declare FoV124 = 0.26585472 
#declare FoV125 = 0.26028353 
#declare FoV126 = 0.25476272 
#declare FoV127 = 0.24929080 
#declare FoV128 = 0.24386629 
#declare FoV129 = 0.23848777 
#declare FoV130 = 0.23315383 
#declare FoV131 = 0.22786313 
#declare FoV132 = 0.22261434 
#declare FoV133 = 0.21740619 
#declare FoV134 = 0.21223741 
#declare FoV135 = 0.20710678 
#declare FoV136 = 0.20201311 
#declare FoV137 = 0.19695524 
#declare FoV138 = 0.19193202 
#declare FoV139 = 0.18694234 
#declare FoV140 = 0.18198512 
#declare FoV141 = 0.17705929 
#declare FoV142 = 0.17216381 
#declare FoV143 = 0.16729766 
#declare FoV144 = 0.16245985 
#declare FoV145 = 0.15764939 
#declare FoV146 = 0.15286534 
#declare FoV147 = 0.14810675 
#declare FoV148 = 0.14337269 
#declare FoV149 = 0.13866227 
#declare FoV150 = 0.13397460 
#declare FoV151 = 0.12930879 
#declare FoV152 = 0.12466400 
#declare FoV153 = 0.12003938 
#declare FoV154 = 0.11543410 
#declare FoV155 = 0.11084733 
#declare FoV156 = 0.10627828 
#declare FoV157 = 0.10172615 
#declare FoV158 = 0.09719015 
#declare FoV159 = 0.09266952 
#declare FoV160 = 0.08816349 
#declare FoV161 = 0.08367130 
#declare FoV162 = 0.07919222 
#declare FoV163 = 0.07472550 
#declare FoV164 = 0.07027042 
#declare FoV165 = 0.06582625 
#declare FoV166 = 0.06139228 
#declare FoV167 = 0.05696780 
#declare FoV168 = 0.05255212 
#declare FoV169 = 0.04814452 
#declare FoV170 = 0.04374433 
#declare FoV171 = 0.03935085 
#declare FoV172 = 0.03496341 
#declare FoV173 = 0.03058131 
#declare FoV174 = 0.02620389 
#declare FoV175 = 0.02183047 
#declare FoV176 = 0.01746038 
#declare FoV177 = 0.01309296 
#declare FoV178 = 0.00872753 
#declare FoV179 = 0.00436343 
#declare FoV180 = 0.00000000 

// Location Vectors for Field of View angles from 1-180 degrees.
//
// Use in camera statement as follows:
//
//     location <0, 0, Loc45 * Height_or_Width>
//
// The formula used to calculate the Loc constants is:
//
//     Loc = 1 / ( 2 * sin ( angle / 2 ) )
//
// These constants are used in conjunction with the FoV constants above.
// Set the Loc constant to the same angle as the FoV constant to maintain
// the same visual distance from your scene.  

#declare Loc1 = 57.29650674
#declare Loc2 = 28.64934425
#declare Loc3 = 19.10077501
#declare Loc4 = 14.32685417
#declare Loc5 = 11.46279281
#declare Loc6 = 9.55366130
#declare Loc7 = 8.19020412
#declare Loc8 = 7.16779351
#declare Loc9 = 6.37274742
#declare Loc10 = 5.73685662
#declare Loc11 = 5.21671526
#declare Loc12 = 4.78338612
#declare Loc13 = 4.41683574
#declare Loc14 = 4.10275452
#declare Loc15 = 3.83064879
#declare Loc16 = 3.59264827
#declare Loc17 = 3.38273454
#declare Loc18 = 3.19622661
#declare Loc19 = 3.02942898
#declare Loc20 = 2.87938524
#declare Loc21 = 2.74370213
#declare Loc22 = 2.62042153
#declare Loc23 = 2.50792587
#declare Loc24 = 2.40486717
#declare Loc25 = 2.31011316
#declare Loc26 = 2.22270574
#declare Loc27 = 2.14182878
#declare Loc28 = 2.06678275
#declare Loc29 = 1.99696458
#declare Loc30 = 1.93185165
#declare Loc31 = 1.87098877
#declare Loc32 = 1.81397764
#declare Loc33 = 1.76046826
#declare Loc34 = 1.71015181
#declare Loc35 = 1.66275476
#declare Loc36 = 1.61803399
#declare Loc37 = 1.57577265
#declare Loc38 = 1.53577674
#declare Loc39 = 1.49787216
#declare Loc40 = 1.46190220
#declare Loc41 = 1.42772548
#declare Loc42 = 1.39521405
#declare Loc43 = 1.36425191
#declare Loc44 = 1.33473358
#declare Loc45 = 1.30656296
#declare Loc46 = 1.27965233
#declare Loc47 = 1.25392142
#declare Loc48 = 1.22929667
#declare Loc49 = 1.20571051
#declare Loc50 = 1.18310079
#declare Loc51 = 1.16141025
#declare Loc52 = 1.14058602
#declare Loc53 = 1.12057923
#declare Loc54 = 1.10134463
#declare Loc55 = 1.08284029
#declare Loc56 = 1.06502723
#declare Loc57 = 1.04786927
#declare Loc58 = 1.03133267
#declare Loc59 = 1.01538602
#declare Loc60 = 1.00000000
#declare Loc61 = 0.98514721
#declare Loc62 = 0.97080201
#declare Loc63 = 0.95694043
#declare Loc64 = 0.94353996
#declare Loc65 = 0.93057950
#declare Loc66 = 0.91803923
#declare Loc67 = 0.90590052
#declare Loc68 = 0.89414582
#declare Loc69 = 0.88275864
#declare Loc70 = 0.87172340
#declare Loc71 = 0.86102541
#declare Loc72 = 0.85065081
#declare Loc73 = 0.84058649
#declare Loc74 = 0.83082007
#declare Loc75 = 0.82133982
#declare Loc76 = 0.81213462
#declare Loc77 = 0.80319397
#declare Loc78 = 0.79450786
#declare Loc79 = 0.78606685
#declare Loc80 = 0.77786191
#declare Loc81 = 0.76988452
#declare Loc82 = 0.76212654
#declare Loc83 = 0.75458025
#declare Loc84 = 0.74723827
#declare Loc85 = 0.74009362
#declare Loc86 = 0.73313959
#declare Loc87 = 0.72636984
#declare Loc88 = 0.71977827
#declare Loc89 = 0.71335910
#declare Loc90 = 0.70710678
#declare Loc91 = 0.70101603
#declare Loc92 = 0.69508180
#declare Loc93 = 0.68929924
#declare Loc94 = 0.68366373
#declare Loc95 = 0.67817085
#declare Loc96 = 0.67281636
#declare Loc97 = 0.66759621
#declare Loc98 = 0.66250650
#declare Loc99 = 0.65754350
#declare Loc100 = 0.65270364
#declare Loc101 = 0.64798350
#declare Loc102 = 0.64337978
#declare Loc103 = 0.63888933
#declare Loc104 = 0.63450911
#declare Loc105 = 0.63023621
#declare Loc106 = 0.62606783
#declare Loc107 = 0.62200128
#declare Loc108 = 0.61803399
#declare Loc109 = 0.61416346
#declare Loc110 = 0.61038729
#declare Loc111 = 0.60670321
#declare Loc112 = 0.60310897
#declare Loc113 = 0.59960247
#declare Loc114 = 0.59618165
#declare Loc115 = 0.59284452
#declare Loc116 = 0.58958920
#declare Loc117 = 0.58641385
#declare Loc118 = 0.58331670
#declare Loc119 = 0.58029605
#declare Loc120 = 0.57735027
#declare Loc121 = 0.57447777
#declare Loc122 = 0.57167703
#declare Loc123 = 0.56894659
#declare Loc124 = 0.56628503
#declare Loc125 = 0.56369097
#declare Loc126 = 0.56116312
#declare Loc127 = 0.55870019
#declare Loc128 = 0.55630097
#declare Loc129 = 0.55396427
#declare Loc130 = 0.55168896
#declare Loc131 = 0.54947393
#declare Loc132 = 0.54731814
#declare Loc133 = 0.54522055
#declare Loc134 = 0.54318019
#declare Loc135 = 0.54119610
#declare Loc136 = 0.53926737
#declare Loc137 = 0.53739312
#declare Loc138 = 0.53557250
#declare Loc139 = 0.53380468
#declare Loc140 = 0.53208889
#declare Loc141 = 0.53042435
#declare Loc142 = 0.52881034
#declare Loc143 = 0.52724615
#declare Loc144 = 0.52573111
#declare Loc145 = 0.52426456
#declare Loc146 = 0.52284588
#declare Loc147 = 0.52147446
#declare Loc148 = 0.52014972
#declare Loc149 = 0.51887111
#declare Loc150 = 0.51763809
#declare Loc151 = 0.51645016
#declare Loc152 = 0.51530681
#declare Loc153 = 0.51420760
#declare Loc154 = 0.51315205
#declare Loc155 = 0.51213976
#declare Loc156 = 0.51117030
#declare Loc157 = 0.51024328
#declare Loc158 = 0.50935835
#declare Loc159 = 0.50851513
#declare Loc160 = 0.50771331
#declare Loc161 = 0.50695255
#declare Loc162 = 0.50623256
#declare Loc163 = 0.50555306
#declare Loc164 = 0.50491379
#declare Loc165 = 0.50431448
#declare Loc166 = 0.50375491
#declare Loc167 = 0.50323487
#declare Loc168 = 0.50275414
#declare Loc169 = 0.50231255
#declare Loc170 = 0.50190992
#declare Loc171 = 0.50154610
#declare Loc172 = 0.50122095
#declare Loc173 = 0.50093434
#declare Loc174 = 0.50068617
#declare Loc175 = 0.50047634
#declare Loc176 = 0.50030477
#declare Loc177 = 0.50017140
#declare Loc178 = 0.50007616
#declare Loc179 = 0.50001904
#declare Loc180 = 0.50000000
