#declare Pointy = 0.35

#declare KnifeBlade =
intersection {
	intersection {
		union {
			box {<-2,-4,-2>,<0,0,2>}
			intersection {
				union {
					cone {<0,Pointy,0>,4+Pointy,<0,Pointy,2+Pointy/2>,0}
					cone {<0,Pointy,0>,4+Pointy,<0,Pointy,-2-Pointy/2>,0}
				}
				plane {y,0}
				plane {-x,0}
			}
		}
		plane {<0,-1,-2>,1.7888}
	}
	plane {<0,-1,2>,1.7888}
	bounded_by {
		box {<-2.1,-4.1,-2.1>,<4.1+Pointy,0.1,2.1>}
	}
	translate x*2
}

#declare KnifeHandle =
union {
	difference {
		union {
			union {
				box {<-3,-0.5,-0.025>,<0,0,0.125>}
				box {<-3,-0.4,-0.125>,<0,-0.1,0.125>}
				cylinder {<-3,-0.1,-0.025>,<0,-0.1,-0.025>,0.1}
				cylinder {<-3,-0.4,-0.025>,<0,-0.4,-0.025>,0.1}
				cylinder {<-3,-1/3,-0.025>,<-3,-1/3,0.125>,1/3}
				cylinder {<-3,-1/3,-0.125>,<-3,-1/3,0.125>,1/3-0.1}
				torus {1/3-0.1,0.1 sturm
					rotate -x*90 translate <-3,-1/3,-0.025>}
				texture { finish {Shiny} pigment {Black}}
				translate -z*0.1875
			}
			union {
				box {<-3,-0.5,-0.0625>,<0,0,0.0625>}
				cylinder {<-3,-1/3,-0.0625>,<-3,-1/3,0.0625>,1/3}
				texture {SmoothSteel rotate y*90}
			}
			union {
				box {<-3,-0.5,0.025>,<0,0,-0.125>}
				box {<-3,-0.4,0.125>,<0,-0.1,-0.125>}
				cylinder {<-3,-0.1,0.025>,<0,-0.1,0.025>,0.1}
				cylinder {<-3,-0.4,0.025>,<0,-0.4,0.025>,0.1}
				cylinder {<-3,-1/3,0.025>,<-3,-1/3,-0.125>,1/3}
				cylinder {<-3,-1/3,0.125>,<-3,-1/3,-0.125>,1/3-0.1}
				torus {1/3-0.1,0.1 sturm
					rotate -x*90 translate <-3,-1/3,0.025>}
				texture { finish {Shiny} pigment {Black}}
				translate z*0.1875
			}
			scale <4/3,4/3,1>
		}
		cylinder {<-4/3,-1/3,-0.5>,<-4/3,-1/3,0.5>,1/12}
		cylinder {<-8/3,-1/3,-0.5>,<-8/3,-1/3,0.5>,1/12}
	}
	cylinder {<-4/3,-1/3,-0.3125>,<-4/3,-1/3,0.3125>,1/12
		texture {SmoothSteel}
	}
	cylinder {<-8/3,-1/3,-0.3125>,<-8/3,-1/3,0.3125>,1/12
		texture {SmoothSteel}
	}
	bounded_by {
		box {<-4.5,-1,-0.5>,<0.1,0.1,0.5>}
	}
	
}

#declare ChefKnife =
union {
	object { KnifeBlade
		scale <1,1/3,1/32>
		texture { SmoothSteel }
	}
	object { KnifeHandle }
}

#declare BWid = 12
#declare BLen = 16
#declare BHit = 1.2
#declare Bev = 0.2
#declare Cnr = 1

#declare CuttingBoard =
union {
	box {<0,Bev,Cnr>,<BLen,BHit-Bev,BWid-Cnr>}
	box {<Bev,0,Cnr>,<BLen-Bev,BHit,BWid-Cnr>}
	box {<Cnr,Bev,0>,<BLen-Cnr,BHit-Bev,BWid>}
	box {<Cnr,0,Bev>,<BLen-Cnr,BHit,BWid-Bev>}
	cylinder {<Cnr,Bev,Bev>,<BLen-Cnr,Bev,Bev>,Bev}
	cylinder {<Cnr,BHit-Bev,Bev>,<BLen-Cnr,BHit-Bev,Bev>,Bev}
	cylinder {<Cnr,Bev,BWid-Bev>,<BLen-Cnr,Bev,BWid-Bev>,Bev}
	cylinder {<Cnr,BHit-Bev,BWid-Bev>,<BLen-Cnr,BHit-Bev,BWid-Bev>,Bev}
	cylinder {<Bev,Bev,Cnr>,<Bev,Bev,BWid-Cnr>,Bev}
	cylinder {<Bev,BHit-Bev,Cnr>,<Bev,BHit-Bev,BWid-Cnr>,Bev}
	cylinder {<BLen-Bev,Bev,Cnr>,<BLen-Bev,Bev,BWid-Cnr>,Bev}
	cylinder {<BLen-Bev,BHit-Bev,Cnr>,<BLen-Bev,BHit-Bev,BWid-Cnr>,Bev}
	cylinder {<Cnr,0,Cnr>,<Cnr,BHit,Cnr>,Cnr-Bev}
	cylinder {<Cnr,Bev,Cnr>,<Cnr,BHit-Bev,Cnr>,Cnr}
	cylinder {<Cnr,0,BWid-Cnr>,<Cnr,BHit,BWid-Cnr>,Cnr-Bev}
	cylinder {<Cnr,Bev,BWid-Cnr>,<Cnr,BHit-Bev,BWid-Cnr>,Cnr}
	cylinder {<BLen-Cnr,0,Cnr>,<BLen-Cnr,BHit,Cnr>,Cnr-Bev}
	cylinder {<BLen-Cnr,Bev,Cnr>,<BLen-Cnr,BHit-Bev,Cnr>,Cnr}
	cylinder {<BLen-Cnr,0,BWid-Cnr>,<BLen-Cnr,BHit,BWid-Cnr>,Cnr-Bev}
	cylinder {<BLen-Cnr,Bev,BWid-Cnr>,<BLen-Cnr,BHit-Bev,BWid-Cnr>,Cnr}
	torus {Cnr-Bev,Bev sturm translate <Cnr,Bev,Cnr>}
	torus {Cnr-Bev,Bev sturm translate <Cnr,BHit-Bev,Cnr>}
	torus {Cnr-Bev,Bev sturm translate <Cnr,Bev,BWid-Cnr>}
	torus {Cnr-Bev,Bev sturm translate <Cnr,BHit-Bev,BWid-Cnr>}
	torus {Cnr-Bev,Bev sturm translate <BLen-Cnr,Bev,Cnr>}
	torus {Cnr-Bev,Bev sturm translate <BLen-Cnr,BHit-Bev,Cnr>}
	torus {Cnr-Bev,Bev sturm translate <BLen-Cnr,Bev,BWid-Cnr>}
	torus {Cnr-Bev,Bev sturm translate <BLen-Cnr,BHit-Bev,BWid-Cnr>}
	texture { BoardTex
		rotate x*10
		rotate y*80
		scale 1.5
		translate <0,.5,4>
	}
	bounded_by {box {<-0.1,-0.1,-0.1>,<BLen+0.1,BHit+0.1,BWid+0.1>}}
}
