#declare ShinyChrome =
texture {
	pigment { color White }
	finish {
		metallic
		ambient 0.0
		diffuse 0.6
		reflection 0.4
		brilliance 8
		specular 1.0
		roughness 0.002
	}
}

#declare SmoothSteel =
texture {
	pigment {color rgb <1.0,1.0,1.0>}
	normal {
		bumps 0.015
		turbulence <0,0.1,0.1>
		scale <0.01,0.5,0.5>
	}
	finish {
		metallic
		reflection 0.25
		ambient 0.0
		diffuse 0.75
		specular 1.0
		roughness 0.01
		brilliance 5
	}
}

#declare BrushedSteel =
texture {
	pigment {color rgb <0.9,0.9,0.9>}
	normal {
		bumps 0.03
		turbulence <0,0.1,0.1>
		scale <0.01,0.5,0.5>
	}
	finish {
		metallic
		reflection 0.1
		ambient 0.1
		diffuse 0.8
		specular 0.8
		roughness 0.03
		brilliance 3
	}
}

#declare WaterTex =
texture {
	pigment { color rgbf <0.98,0.98,1,0.95> }
	finish {
		reflection 0.1
		diffuse 0.1
		ambient 0.0
		refraction 1
		ior 1.33
		specular 1.0
		roughness 0.001
	}
}

#declare BoardTex =
texture {
	pigment {wood
		turbulence 0.075
		scale <0.2, 0.2, 1>
		color_map {
			[0.0 color rgb <0.42,0.26,0.15>]
			[0.1 color rgb <0.42,0.26,0.15>]
			[0.9 color rgb <0.70,0.52,0.40>]
			[1.0 color rgb <0.70,0.52,0.40>]
		}
		quick_color Brown
	}
}

#declare WoodTrim =
texture {
	pigment {wood
		turbulence 0.075
		scale <0.1, 0.1, 1>
		color_map {
			[0.0 color rgb <0.42,0.26,0.15>]
			[0.1 color rgb <0.42,0.26,0.15>]
			[0.9 color rgb <0.52,0.37,0.26>]
			[1.0 color rgb <0.52,0.37,0.26>]
		}
		quick_color Brown
	}
	rotate y*90
	scale 2
}

#declare WallTex =
texture {
	pigment {
		image_map {
			gif "walpaper.gif"
			interpolate 2
		}
		scale 4
		quick_color Wheat
	}
	finish {
		ambient 0.2
		diffuse 0.8
	}
}

#declare GrassTex =
texture {
	pigment { granite
		color_map {
			[0.0 color rgb <0.50, 0.80, 0.20>]
			[0.5 color rgb <0.16, 0.64, 0.16>]
			[1.0 color rgb <0.12, 0.48, 0.30>]
		}
		scale 5
		quick_color Green
	}
	normal {
		wrinkles 0.5
		turbulence 1
	}
	finish {
		ambient 0.2
		diffuse 0.8
	}
}

#declare GlassTex = 
texture {
	pigment { color rgbf <1, 1, 1, 0.95> }
	finish {
		ambient 0
		diffuse 0
		reflection 0.1
		specular 1
		roughness 0.001
		refraction 1
		ior 1.5
	}
}

#declare BlurFilter =
texture {
	pigment { color rgbf <1,1,1,1> }
	finish {
		ambient 0
		diffuse 0
		reflection 0
		refraction 1
		ior 1.3
	}
	normal {
		bumps 0.01
		scale 0.001
	}
}
