#declare SinkWidth = 20
#declare SinkHeight = 16
#declare SinkDepth = 8

#declare SinkTopCorner =
union {
	difference {
		cylinder {<0,-1/4,0>, <0,1/4,0>, 2}
		cylinder {<0,-1,0>, <0,1,0>, 1}
	}
	torus {1, 1/4 sturm}
	torus {2, 1/4 sturm}
	bounded_by {
		box {<-2.3,0,0>, <0,0.3,2.3>}
	}
	clipped_by { bounded_by }
}

#declare SinkTopSide =
union {
	box {<-1,-1/4,-1/2>, <1,1/4,1/2>}
	cylinder {<-1,0,-1/2>, <1,0,-1/2>, 1/4}
	cylinder {<-1,0,1/2>, <1,0,1/2>, 1/4}
	bounded_by {
		box {<-1,0,-0.8>,<1,0.3,0.8>}
	}
	clipped_by { bounded_by }
}

#declare SinkTop =
union {
	object { SinkTopSide
		scale <SinkWidth/2,1,1>
		translate z*(SinkHeight/2+1.5)
	}
	object { SinkTopSide
		scale <SinkWidth/2,1,1>
		translate -z*(SinkHeight/2+1.5)
	}
	object { SinkTopSide
		scale <SinkHeight/2,1,1>
		rotate y*90
		translate -x*(SinkWidth/2+1.5)
	}
	object { SinkTopSide
		scale <SinkHeight/2,1,1>
		rotate y*90
		translate x*(SinkWidth/2+1.5)
	}
	object { SinkTopCorner
		translate <-SinkWidth/2,0,SinkHeight/2>
	}
	object { SinkTopCorner
		rotate y*90
		translate <SinkWidth/2,0,SinkHeight/2>
	}
	object { SinkTopCorner
		rotate y*180
		translate <SinkWidth/2,0,-SinkHeight/2>
	}
	object { SinkTopCorner
		rotate y*270
		translate <-SinkWidth/2,0,-SinkHeight/2>
	}
	texture {BrushedSteel
		rotate y*90
	}
}

#declare SinkBottom =
union {
	difference {
		union {
			box {
				<-SinkWidth/2-1,-1/4,-SinkHeight/2-1>,
				<SinkWidth/2+1,0,SinkHeight/2+1>
			}
			cylinder {<0,0,0>,<0,1/8,0>,2}
		}
		cylinder {<0,-0.3,0>,<0,0.2,0>,1.5}
	}
	merge {
		sphere { <0,0,0>, 1.5 }
		cylinder { <0,0,0>, <0,-6,0>, 0.5 }
		bounded_by { box {<-2,-5,-2>,<2,0,2>}}
		clipped_by { bounded_by }
	}
	bounded_by {
		box {
			<-SinkWidth/2-1.1,-5.1,-SinkHeight/2-1.1>,
			<SinkWidth/2+1.1,0.2,SinkHeight/2+1.1>
		} 
	}
	translate -y*SinkDepth
	texture {BrushedSteel
		rotate y*90
	}
}

#declare SinkSide =
union {
	box {<-1,0,3/4>,<1,SinkDepth,1>}
	difference {
		box {<-1,0,0>,<1,3/4,3/4>}
		cylinder {<-1.1,3/4,0>,<1.1,3/4,0>,3/4}
	}
	bounded_by {
		box {<-1.1,-0.1,-0.1>,<1.1,SinkDepth+0.1,1.1>}
	}
	translate -y*SinkDepth
	texture {BrushedSteel
		rotate z*90
	}
}

#declare SinkRiser =
difference {
	difference {
		box {<-1,-SinkDepth,0>,<0,0,1>}
		cylinder {<0,-SinkDepth+0.75,0>,<0,1,0>,3/4}
	}
	sphere {<0,-SinkDepth+0.75,0>,3/4}
	bounded_by {
		box {<-1.1,-SinkDepth-0.1,-0.1>,<0.1,0.1,1.1>}
	}
	texture {BrushedSteel
		rotate z*90
		rotate -y*45
	}
}

#declare KitchenSink =
union {
	object { SinkTop }
	object { SinkBottom }
	object { SinkSide
		scale <SinkWidth/2,1,1>
		translate z*SinkHeight/2	
	}
	object { SinkSide
		scale <SinkWidth/2,1,1>
		rotate y*180
		translate -z*SinkHeight/2	
	}
	object { SinkSide
		scale <SinkHeight/2,1,1>
		rotate y*90
		translate x*SinkWidth/2	
	}
	object { SinkSide
		scale <SinkHeight/2,1,1>
		rotate y*270
		translate -x*SinkWidth/2	
	}
	object { SinkRiser
		translate <-SinkWidth/2,0,SinkHeight/2>
	}
	object { SinkRiser
		rotate y*90
		translate <SinkWidth/2,0,SinkHeight/2>
	}
	object { SinkRiser
		rotate y*180
		translate <SinkWidth/2,0,-SinkHeight/2>
	}
	object { SinkRiser
		rotate y*270
		translate <-SinkWidth/2,0,-SinkHeight/2>
	}
	bounded_by {
		box {
			<-SinkWidth/2-3,-SinkDepth-5.1,-SinkHeight-3>,
			<SinkWidth/2+3,1,SinkHeight+3>
		}
	}
}
#declare FaucetPipe =
union {
	intersection {
		sphere { <0,0,0>, 20.5 }
		cylinder { <-1,0,0>, <1,0,0>, 20 inverse }
		box { <-0.5,14,0>, <0.5,21,-20> }
		box {	<-1,0,0>, <1,21,20> rotate -x*30 }
		bounded_by {
			box {<-0.6,14,0.1>, <0.6,21,-20>}
		}
	}
	intersection {
		cylinder { <0,0,0>, <0,1.1,0>, 0.5 }
		sphere { <0,-19.5,0>, 20.5 }
		bounded_by {
			box { <-0.6,-0.1,-0.6>, <0.6,1.1,0.6> }
		}
		translate y*19.5
	}
	intersection {
		cylinder { <0,-1,0>, <0,1.1,0>, 1 }
		sphere { <0,-3,0>, 4 }
		bounded_by {
			box {<-1.1,-1.1,-1.1>,<1.1,1.1,1.1>}
		}
		rotate x*30
		translate y*20
		rotate -x*30
	}
	rotate x*30
	translate -y*20
	rotate -x*30
	translate y
	bounded_by {
		box {<-1.1,-0.1,-1.1>,<1.1,8,20>}
	}
	rotate y*180
}

#declare FaucetKnob =
union {
	cylinder {<0,0,0>, <0,2,0>, 0.2}
	sphere {<0,2.3,0>, 0.6}
	cone {<-0.8,2.3,0>, 0.4, <2,2.3,0>, 0.2}
	cone {<2,2.3,0>, 0.25, <2.5,2.3,0>, 0.2}
	bounded_by {
		box {<-1,-0.1,-1>,<2.6,4,1>}
	}
}

#declare FaucetBase =
intersection {
	sphere {<0,-20,0>, 20.5}
	sphere {<0,0,-19>, 20.5}
	sphere {<0,0,19>, 20.5}
	sphere {<-16.5,0,0>, 20.5}
	sphere {<16.5,0,0>, 20.5}
	bounded_by {
		box {<-5,0,-2>,<5,1,2>}
	}
	clipped_by { bounded_by }
}
