// Persistence Of Vision raytracer version 2.2
// Kitchen Still Life
// Scale is approximately 1 unit = 1 inch

// Include Files

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "shapes.inc"
#include "fov2.inc"
#include "newtex.inc"
#include "sink.inc"
#include "knife.inc"
#include "water.inc"
#include "pepper.inc"
#include "window.inc"

// General Scene Parameters
#declare SceneCenter     = <11,3,6>
#declare SceneRadius     = 18
#declare CameraElevation = 28
#declare CameraRotation  = 35
#declare FieldOfView     = FoV30
#declare LocView         = Loc30
#declare AspectRatio     = 4/3
#include "camera.inc"

// Lights

#declare IncanLight = color rgb <0.35, 0.33, 0.25>
#declare FlourLight = color rgb <0.45, 0.45, 0.45>
#declare SunLight   = color rgb <0.70, 0.65, 0.45>
#include "slowlite.inc"
// #include "fastlite.inc"

// Camera

camera { StandardCamera }

// Action!

// The Sky
sphere { <0,0,0>, 600
	texture {
		pigment { Blue_Sky scale 20 }
		finish { ambient 1.0 diffuse 0.0 }
	}
}

// The Ground
plane { y, -72
	texture { GrassTex }
}

// The Counter
difference {
	box {
		<-60,-1.5,-SinkHeight/2-4>,
		<60,0,SinkHeight/2+12>
	}
	box {
		<-SinkWidth/2-1.5,-3,-SinkHeight/2-1.5>,
		<SinkWidth/2+1.5,1,SinkHeight/2+1.5>
	}
	texture { Stone18 scale 3 rotate z*90 }
}

// The Cabinets
box {
	<-60,-1.5,-SinkHeight/2-3>,
	<60,-36,-SinkHeight/2-2>
	texture { WoodTrim
		rotate z*90
	}
}

// The Room
// Front Wall with hole for Window
difference {
	box {
		<-61, -37, SinkHeight/2+12>,
		<61, 73, SinkHeight/2+14>
	}
	box {
		<-20.1, 5.9, SinkHeight/2+11>,
		<20.1, 60.1, SinkHeight/2+15>
	}
	texture { WallTex }
}
// Back Wall
box {
	<-61,-37,-122>,
	<61,73,-120>
	texture { WallTex }
}
// Left Wall
box {
	<-62,-37,-121>,
	<-60,73,SinkHeight/2+13>
	texture { WallTex rotate y*90 }
}
// Right Wall
box {
	<62,-37,-121>,
	<60,73,SinkHeight/2+13>
	texture { WallTex rotate y*90 }
}
// Ceiling
box {
	<-61,72,-121>,
	<61,74,SinkHeight/2+13>
	texture {
		pigment { color White }
		finish { ambient 0.2 diffuse 0.8 }
	}
}
// Floor
box {
	<-61,-38,-121>,
	<61,-36,SinkHeight/2+13>
	texture {
		pigment { color White }
		finish { ambient 0.2 diffuse 0.8 }
	}
}
// Put in the window
object { FullWindow
	translate <-22,3,SinkHeight/2+11>
}

// The Sink
object { KitchenSink }
// The Faucet
union {
	object { FaucetPipe rotate -y*25 }
	object { FaucetBase }
	object { FaucetKnob translate x*3 }
	object { FaucetKnob rotate y*180 translate -x*3 }
	texture { ShinyChrome }
	translate z*12.5
}

object { WaterPuddle
	scale <1,0.5,1>
	texture { WaterTex }
	translate x*2.3
	translate -y*SinkDepth
	rotate -y*30
}

object { WaterDrop
	scale <0.25,0.3,0.25>
	texture { WaterTex }
	translate -z*10
	rotate -y*25
	translate z*12.5
	translate y*2
}

object { CuttingBoard
	rotate -y*100
	translate <28,0,-3>
}

object { ChefKnife
	texture {SmoothSteel}
	rotate x*90
	rotate y*195
	translate <21,1.55,-1.5>
}

object { CutPepper
	rotate -y*5
	translate <23,3.7,5>
}

object { PepperSlice
	rotate y*45
	rotate z*90
	rotate y*45
	translate <17,3.45,5>
}

// Sponge
box {<0,0,0>,<5,0.75,3>
	texture {
		pigment { color rgb <1,0.75,0.78> }
		finish { ambient 0.2 diffuse 0.8 }
		normal { bumps 0.5 scale 0.1 }
	}
	rotate -y*25
	translate <9,0,11.5>
}

// Fern
#declare col_2  = color rgb <0.5,0.3,0.1>
#declare col_4  = color rgb <0.4,0.6,0.2>
#declare l_base = object { cylinder { <0, 0, 0> <0, 1.5, 0>, 0.75 } }
#declare t_base = finish { ambient 0.1 diffuse 0.7 }
#declare t_leaf = finish { ambient 0.2 diffuse 0.8 }
union {
#include "fern.inc"
scale 0.005
rotate y*225
translate <40,2,6>
}

// Beach Ball
sphere { <0,0,0>, 6
	texture {
		pigment { radial
			color_map {
				[0.0 color rgb <0,0,1>]
				[0.5 color rgb <0,0,1>]
				[0.5 color rgb <1,1,0>]
				[0.5 color rgb <1,1,0>]
			}
			frequency 3
		}
		finish {
			ambient 0.3
			diffuse 0.7
			specular 0.5
			roughness 0.05
		}
	}
	rotate -x*45
	rotate y*45
	translate <100,-66,240>
}

// Add focal blur filter for depth of field
box {<0,0,0><200,200,1>
	texture {BlurFilter}
	rotate -y*139
	translate <24,-72,22>
}
