#declare WindowFrame =
union {
	box { <0,0,0>, <44,2,4>
		texture { WoodTrim }
	}
	box { <0,0,0>, <46,1,5>
		texture { WoodTrim }
		translate <-1,2,-1>
	}
	difference {
		box { <0,0,0>, <44,2,4> }
		box { <-1,0,-1>, <4,-4,5>
			rotate -z*45
			translate <0,2,0>
		}
		box { <-4,0,-1>, <1,-4,5>
			rotate z*45
			translate <44,2,0>
		}
		bounded_by {
			box { <-0.1,-0.1,-0.1>, <44.1,2.1,4.1> }
		}
		texture { WoodTrim }
		translate y*57
	}
	difference {
		box {<0,0,0>, <56,2,4> }
		box {<-4,0,-1>, <1,-4,5>
			rotate z*45
			translate <56,2,0>
		}
		bounded_by {
			box { <-0.1,-0.1,-0.1>, <56.1,2.1,4.1> }
		}
		texture { WoodTrim }
		rotate z*90
		translate <2,3,0>
	}
	difference {
		box {<0,0,0>, <56,2,4> }
		box {<-4,0,-1>, <1,4,5>
			rotate -z*45
			translate <56,0,0>
		}
		bounded_by {
			box { <-0.1,-0.1,-0.1>, <56.1,2.1,4.1> }
		}
		texture { WoodTrim }
		rotate z*90
		translate <44,3,0>
	}
}

#declare HorizSide =
difference {
	union {
		box {<0,0,0>, <20,1.5,1>}
		box {<0,1.5,0.25>, <20,1.75,0.75>}
	}
	box {<-1,0,-1>, <3,2,2>
		rotate z*45
	}
	box {<-3,0,-1>, <1,2,2>
		rotate -z*45
		translate x*20
	}
	bounded_by {
		box {<-0.1,-0.1,-0.1>,<20.1,1.8,1.1>}
	}
	texture { WoodTrim }
}

#declare VertSide =
difference {
	union {
		box {<0,0,0>, <54,1.5,1>}
		box {<0,1.5,0.25>, <54,1.75,0.75>}
	}
	box {<-1,0,-1>, <3,2,2>
		rotate z*45
	}
	box {<-3,0,-1>, <1,2,2>
		rotate -z*45
		translate x*54
	}
	bounded_by {
		box {<-0.1,-0.1,-0.1>,<54.1,1.8,1.1>}
	}
	texture { WoodTrim }
}

#declare LongCrossPiece =
union {
	box { <0,0,0.25>, <51,-1,0.75> }
	box { <0,-0.25,0>, <51,-0.75,1> }
	texture { WoodTrim }
	rotate z*90
}

#declare ShortCrossPiece =
union {
	box { <0,0,0.25>, <17,1,0.75> }
	box { <0,0.25,0>, <17,0.75,1> }
	texture { WoodTrim }
}

#declare WindowPane =
box { <0,0,0>, <8,12,0.25>
	texture { GlassTex }
}

#declare WindowSide =
union {
	object { HorizSide }
	object { HorizSide
		rotate z*180
		translate <20,54,0>
	}
	object { VertSide
		rotate -z*90
		translate y*54
	}
	object { VertSide
		rotate z*90
		translate x*20
	}
	object { LongCrossPiece
		translate <9.5,1.5,0>
	}
	object { ShortCrossPiece
		translate <1.5,13.5,0>
	}
	object { ShortCrossPiece
		translate <1.5,26.5,0>
	}
	object { ShortCrossPiece
		translate <1.5,39.5,0>
	}
	object { WindowPane
		translate <1.5,1.5,0.375>
	}
	object { WindowPane
		translate <10.5,1.5,0.375>
	}
	object { WindowPane
		translate <1.5,14.5,0.375>
	}
	object { WindowPane
		translate <10.5,14.5,0.375>
	}
	object { WindowPane
		translate <1.5,27.5,0.375>
	}
	object { WindowPane
		translate <10.5,27.5,0.375>
	}
	object { WindowPane
		translate <1.5,40.5,0.375>
	}
	object { WindowPane
		translate <10.5,40.5,0.375>
	}
	bounded_by {
		box {<-0.1,-0.1,-0.1>,<20.1,54.1,1.1>}
	}
}

#declare FullWindow =
union {
	object { WindowFrame }
	object { WindowSide
		scale <0.999,0.9996,1>
		translate <2.01,3.01,2>
	}
	object { WindowSide
		scale <0.999,0.9996,1>
		translate <22.01,3.01,2>}
	bounded_by {
		box {<-2,-1,-2>,<46,60,5>}
	}
}
