/*  The two truck types are OneTruck and ZeroTruck. Each of these rests
    on the xz plane with the wheel bottoms at y=0. The truck faces in the
    positive z direction, with bounds 
      x: -0.5 to 0.5, y: 0 to 1.3, z: -2 to 2
*/

#declare Truck_Texture=
texture{
  Dull
  pigment{DarkTan}
}
#declare Truck_Texture2=
texture{
  pigment{Gray20}
  finish{Shiny}
}
#declare Trailer_Texture=
texture{
  Dull
  pigment{NewTan}
}

#declare Char_Texture=
texture{
  Shiny
  pigment{Red}
}

#declare Wheel=
object{
  union{
    cylinder{
      <0, 0, 0>,
      <0.05, 0, 0>,
      0.25
      texture{Dull pigment{Gray30}}
    }
    cylinder{
      <-0.001, 0, 0>,
      <0.051, 0, 0>,
      0.12
      texture{Chrome_Texture}
    }
  }
}


#declare Truck=
object{
  union{
    difference{
      box{   //trailer
        <-0.5, 0, 0>,
        <0.5, 1, 2.8>
      }
      cylinder{ //wheel arch
        <-0.51, 0, 0.4>
        <-0.45, 0, 0.4>
        0.3
      }
      cylinder{ //wheel arch
        <0.45, 0, 0.4>
        <0.51, 0, 0.4>
        0.3
      }
      cylinder{ //wheel arch
        <-0.51, 0, 1.2>
        <-0.45, 0, 1.2>
        0.3
      }
      cylinder{ //wheel arch
        <0.45, 0, 1.2>
        <0.51, 0, 1.2>
        0.3
      }
      texture{Trailer_Texture}
    }
    union{  //truck
      difference{
        box{
          <-0.5, 0, 3.1>
          <0.5, 0.5, 4>
        }
        cylinder{ //wheel arch
          <-0.51, 0, 3.5>
          <-0.45, 0, 3.5>
          0.3
        }
        cylinder{ //wheel arch
          <0.45, 0, 3.5>
          <0.51, 0, 3.5>
          0.3
        }
        texture{Truck_Texture}
      }
      box{
        <-0.2, 0, 2.7>,
        <0.2, 0.2, 3.1>
        texture{Truck_Texture}
      }
      box{
        <-0.5, 0.5, 3.1>
        <0.5, 0.9, 3.6>
        texture{Truck_Texture}
      }
      cylinder{
        <-0.4999, 0.5, 3.6>,
        <0.4999, 0.5, 3.6>,
        0.4
        texture{Truck_Texture2}
      }
    }
    object{Wheel translate <-0.5, 0, 0.4>}
    object{Wheel translate <0.45, 0, 0.4>}
    object{Wheel translate <-0.5, 0, 1.2>}
    object{Wheel translate <0.45, 0, 1.2>}
    object{Wheel translate <-0.5, 0, 3.5>}
    object{Wheel translate <0.45, 0, 3.5>}
  }
}

#declare OneTruck=
object{
  union{
    object{Truck}
    object{char_1
      rotate 90*x
      scale<0.2, 0.2, 0.4>
      translate<0, 1.05, 0.3>
      texture{Char_Texture}
    }
    translate <0, 0.25, -2>
  }
  bounded_by{
    box{
      <-0.5, 0, -2>,
      <0.5, 1.3, 2>
    }
  }
}

#declare ZeroTruck=
object{
  union{
    object{Truck}
    object{char_0
      rotate 90*x
      scale<0.2, 0.2, 0.4>
      translate<0, 1.05, 0.3>
      texture{Char_Texture}
    }
    translate <0, 0.25, -2>
  }
  bounded_by{
    box{
      <-0.5, 0, -2>,
      <0.5, 1.3, 2>
    }
  }
}
