// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "Golds.inc"

global_settings {assumed_gamma 1.0}
global_settings { max_trace_level 50 }


camera {
  location  <0.0, 5, -3>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
//  orthographic

}

#default {pigment {color Blue} finish {specular 1 roughness .01}}

#declare Black_Paint=
texture{
	pigment {color rgb .01}
	finish {ambient 0 diffuse .5 specular .3}
}

#declare Red_Paint=
texture{
	pigment {color rgb <1,0,0>}
	finish {specular .3}
}



light_source {
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 20, 5>
}

light_source {
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <00, 20, 10>
}


#declare Neon = texture
{
  pigment
  {
    colour rgb<0.675,1,0.8>
  }
  finish {
    ambient 0.2
    specular 0.28    roughness 0.36
  }
}

#declare Leather = texture
{
  pigment
  {
    bozo
    turbulence 0.8
    color_map
    {
   	[0.00 color rgb <0.220, 0.100, 0.043>]
      [1.00 color rgb <0.349, 0.102, 0.049>]
    }
    scale .3
  }
  normal
  {
    crackle 0.1
slope_map {
	[0 <0,1>]
	[.05 <1,0>]
	[.95 <1,0>]
	[1  <0,-1>]
	}

 turbulence .1
    scale .1
  }
  finish {
    specular 0.45
  }
}


#declare Cutout =
union {
	box {<-.8,0,0>,<.8,1,3>}
	cylinder {<-.8,.5,0>,<-.8,.5,3>,.5}
	cylinder {<.8,.5,0>,<.8,.5,3>,.5}
	rotate 30*x translate <0,2.5,7>
}

#declare Rad=.25

#declare One=
union {
	sphere {<0,3,0>,Rad}
	sphere {<0,0,0>,Rad}
	cylinder {<0,0,0>,<0,3,0>,Rad}
}

#declare Two=
union{
	intersection {
		torus {1,Rad rotate x*90}
		box {<-2,-2,-2>,<0,0,2> inverse}
	}
	intersection {
		torus {1,Rad rotate x*90 translate -2*y}
		box {<-2,-2,-2>,<0,0,2>}
	}
	cylinder {<-1,-2,0>,<1,-2,0>,Rad}
	sphere {<-1,-2,0>,Rad}
	sphere {<-1,0,0>,Rad}
	sphere {<1,-2,0>,Rad}
	translate 2*y
}

#declare Three=
union{
	intersection{
		torus {1,Rad rotate x*90}
		box {<-2,0,-2>,<0,2,2> inverse}
		translate y
	}
	cylinder {<0,2,0>,<1,3,0>,Rad}
	cylinder {<-1,3,0>,<1,3,0>,Rad}
	sphere {<-1,1,0>,Rad}
	sphere {<0,2,0>,Rad}
	sphere {<1,3,0>,Rad}
	sphere {<-1,3,0>,Rad}
}

#declare Four=
union {
	cylinder {<1,0,0>,<1,3,0>,Rad}
	cylinder {<1,3,0>,<-1,1,0>,Rad}
	cylinder {<-1,1,0>,<1,1,0>,Rad}
	sphere {<1,0,0>,Rad}
	sphere {<1,3,0>,Rad}
	sphere {<-1,1,0>,Rad}
}

#declare Five =
union{
	intersection{
		torus {1,Rad rotate x*90}
		box {<-2,0,-2>,<0,2,2> inverse}
		translate y
	}
	cylinder {<0,2,0>,<-1,2,0>,Rad}
	cylinder {<-1,2,0>,<-1,3,0>,Rad}
	cylinder {<-1,3,0>,<1,3,0>,Rad}
	sphere {<1,3,0>,Rad}
	sphere {<-1,3,0>,Rad}
	sphere {<-1,2,0>,Rad}
	sphere {<-1,1,0>,Rad}
}


#declare Zero=
union{
	intersection {
		torus {1,Rad rotate x*90 translate y}
		box {<-2,1,-2>,<2,3,2> inverse}
	}
	intersection {
		torus {1,Rad rotate x*90 translate 2*y}
		box {<-2,0,-2>,<2,2,2> inverse}
	}
	cylinder {<-1,1,0>,<-1,2,0>,Rad}
	cylinder {<1,1,0>,<1,2,0>,Rad}
}


#declare Ring1=
difference{
	union {
		difference{
			torus {8.5,1 translate 1.25*y}
			plane {y,1.25}
		}
		cylinder {<0,1,0>,<0,1.25,0>,9.5}
		cone {<0,0,0>,8.5,<0,1,0>,9.5}
	}
	cylinder {<0,1,0>,<0,3,0>,8}
	cone {<0,1.001,0>,8,<0,-.01,0>,6.97 texture {T_Gold_1C} normal {radial .1 frequency 75 sine_wave}}
	//box {<-1,0,0>,<1,1,3> rotate <30,0,0> translate <0,2.125,7>}
	//cylinder {<0,1,0>,<0,1,3>,.5 scale <2,1,1> rotate 30*x translate <0,2.125,7> rotate 90*y}
	object {Cutout}
	object {Cutout rotate y*60}
	object {Cutout rotate y*120}
	object {Cutout rotate y*180}
	object {Cutout rotate y*240}
	object {Cutout rotate y*300}
	object {Zero scale 1/3 rotate x*-60 translate <0,1.25,9.25> rotate 58*y texture {Black_Paint}}
	object {One  scale 1/3 rotate x*-60 translate <0,1.25,9.25> rotate 62*y texture {Black_Paint}}
	object {Zero scale 1/3 rotate x*-60 translate <0,1.25,9.25> rotate 117*y texture {Black_Paint}}
	object {Two scale <-1/3,1/3,1/3> rotate x*-60 translate <0,1.25,9.25> rotate 123*y texture {Black_Paint}}
	object {Zero scale 1/3 rotate x*-60 translate <0,1.25,9.25> rotate 177*y texture {Black_Paint}}
	object {Three scale <-1/3,1/3,1/3> rotate x*-60 translate <0,1.25,9.25> rotate 183*y texture {Black_Paint}}
	object {Zero scale 1/3 rotate x*-60 translate <0,1.25,9.25> rotate 237*y texture {Red_Paint}}
	object {Four scale <-1/3,1/3,1/3> rotate x*-60 translate <0,1.25,9.25> rotate 243*y texture {Red_Paint}}
	object {Zero scale 1/3 rotate x*-60 translate <0,1.25,9.25> rotate 297*y texture {Red_Paint}}
	object {Five scale <-1/3,1/3,1/3> rotate x*-60 translate <0,1.25,9.25> rotate 303*y texture {Red_Paint}}
//	cylinder {<0,.5,-.25>,<0,.5,.25>,.5 rotate x*-60 translate <0,1.25,9.25> texture {Red_Paint}}
	sphere {<0,.5,0>,.5 scale <1,1,.5> rotate x*-60 translate <0,1.25,9.25> texture {Red_Paint}}
	scale 1/7
}



#declare Watchglass =
difference {
	sphere {<0,-16,0>,19.5}
	sphere {<0,-16,0>,19}
	cylinder {<0,0,0>,<0,5,0>,8.1 inverse}
	scale 1/7
}

#declare Count=0

#declare Dial=
union{
difference {
	cylinder {<0,-.4,0>,<0,-.1,0>,10}
	intersection {
	box {<-1.2,-1.2,-2>,<1.2,1.2,2> rotate 45*z translate 8*x}
	box {<-2,-1.2,-1>,<2,1.2,1> rotate 45*x translate 8*x}
	}
	texture {T_Gold_4A normal {bumps .05 scale .05}}
}
box {<0,-.5,0>,<1,-.4,1>
pigment {image_map {gif "23.gif" map_type 0 interpolate 2}
 rotate 90*x
}
scale <3,1,2.6> translate <6.45,0,-1.5>
}
box {<-2,-.1,-2>,<2,-.05,11> texture {Black_Paint}}
box {<-2,-.1,-11>,<2,-.05,-3.5> texture {Black_Paint}}
box {<-2,-.1,3>,<2,0,4.25> pigment {color Yellow} finish {specular .3}}
box {<-2,-.1,4.5>,<2,0,5> pigment {color Yellow} finish {specular .3}}
box {<-2,-.1,5.25>,<2,0,5.75> pigment {color Yellow} finish {specular .3}}
box {<-2,-.1,6>,<2,0,6.5> pigment {color Yellow} finish {specular .3}}
box {<-2,-.1,6.75>,<2,0,7.25> pigment {color Yellow} finish {specular .3}}
#while (Count<11)
sphere {<0,-.1,0>,.3 translate 9.5*z rotate (4+Count)*30*y texture {Neon}}
#declare Count=Count+1
#end
#declare Count=0
#while (Count<60)
#if (Count <=13 | Count >=17)
box {<-.02,-.1,9.25>,<.02,-.05,9.75> rotate ((Count)*6)*y texture {Black_Paint}}
#end
#declare Count=Count+1
#end
text
{
  ttf          // font type (only TrueType format for now)
  "Jik.ttf",  // Microsoft Windows-format TrueType font file name
  "",   // the string to create
  .2,           // the extrusion depth
  0            // offset
  pigment {Red}
  scale 1.5 rotate x*90 translate <-4.5,0,-3>
}
#declare Count=0
#while (Count<12)
#if (Count != 0 & Count != 3)
cylinder {<0,0,7.75>,<0,0,8.75>,.5
	scale <1,.5,1> rotate y*30*Count
	#if (Count != 6)
		translate -.2*y
	#end
	texture {T_Gold_1A}
}
#end
#declare Count=Count +1
#end

#declare Count=0
#while (Count<12)
#if (Count != 0 & Count != 3)
cylinder {<0,0,7.75>,<0,0,8.75>,.1
	scale <1,1,1> rotate y*30*Count
	#if (Count = 6)
		translate .2*y
	#end
	texture {Black_Paint}
}
#end
#declare Count=Count +1
#end
text
{
  ttf          // font type (only TrueType format for now)
  "Watch.ttf",  // Microsoft Windows-format TrueType font file name
  "A",   // the string to create
  .2,           // the extrusion depth
  0            // offset
  texture {T_Gold_3A}
  scale 4 rotate x*90 translate <-1.25,0,-7.5>
}
text
{
  ttf          // font type (only TrueType format for now)
  "Watch.ttf",  // Microsoft Windows-format TrueType font file name
  "B",   // the string to create
  .2,           // the extrusion depth
  0            // offset
  pigment {color Yellow}
  scale 1.5 rotate x*90 translate <-.59,0,7.3>
}
torus {.8,.1 translate <0,0,8>  texture {T_Gold_3A normal {radial .5 frequency 20 triangle_wave}}}
translate <0,.3,0>
scale .1
}

#declare Minute_Hand=
union{
prism {
  linear_sweep
linear_spline
	-0.1,
	0.1,
	8,
	<0,0>
	<-.25,1.5>
	<-.25,8.5>
	<0,9>
	<.25,8.5>
	<.25,1.5>
	<.125,.5>
	<0,0>
	texture {T_Gold_4C}
}
prism {
  linear_sweep
linear_spline
	-0.11,
	0.11,
	7,
	<0,1>
	<-.125,1.5>
	<-.125,8.5>
	<0,8.5>
	<.125,8.5>
	<.125,1.5>
	<0,1>
	texture {Neon}
}
cylinder {<0,-.1,0>,<0,.1,0>,.375 	texture {T_Gold_4C}}
scale .1
}

#declare Hour_Hand=
union{
prism {
  linear_sweep
linear_spline
	-0.1,
	0.1,
	8,
	<0,0>
	<-.25,1.5>
	<-.25,5>
	<0,5.5>
	<.25,5>
	<.25,1.5>
	<.125,.5>
	<0,0>
	texture {T_Gold_4C}
}
prism {
  linear_sweep
linear_spline
	-0.11,
	0.11,
	7,
	<0,1>
	<-.125,1.5>
	<-.125,5>
	<0,5>
	<.125,5>
	<.125,1.5>
	<0,1>
	texture {Neon}
}
cylinder {<0,-.1,0>,<0,.1,0>,.5 	texture {T_Gold_4C}}
scale .1
}


#declare Second_Hand=
union{
prism {
linear_sweep
linear_spline
	-0.01,
	0.01,
	8,
	<0,0>
	<-.125,1.5>
	<-.125,5>
	<-.125,9>
	<0,9.5>
	<.125,9>
	<.125,1.5>
	<0,0>
	pigment {Red}
}
prism {
  linear_sweep
linear_spline
	-0.01,
	0.01,
	4,
	<0,0>
	<-.25,-2>
	<.25,-2>
	<0,0>
	pigment {Red}
	}
cylinder {<0,-.01,0>,<0,.01,0>,.25 pigment {Red}}
scale .1
}

#declare Body=
union{
difference{
cylinder {<0,0,0>,<0,2,0>,10}
cylinder {<9,-.1,9>,<9,2.1,9>,3.5}
cylinder {<-9,-.1,9>,<-9,2.1,9>,3.5}
cylinder {<9,-.1,-9>,<9,2.1,-9>,3.5}
cylinder {<-9,-.1,-9>,<-9,2.1,-9>,3.5}
cylinder {<22,-.1,0>,<22,2.1,0>,14}
cylinder {<-22,-.1,0>,<-22,2.1,0>,14}
//cylinder {<0,-.1,22>,<0,2.1,22>,14}
//cylinder {<0,-.1,-22>,<0,2.1,-22>,14}
box {<-4,-.1,8>,<4,2.1,10.2>}
box {<-4,-.1,-8>,<4,2.1,-10.2>}
sphere {<0,-60,0>,62.5 inverse}
cylinder {<0,-.1,0>,<0,2.1,0>,7}
}
cylinder {<9,1,0>,<10,1,0>,.5 scale y*1.2 rotate y*-45}
cone {<9.5,1,0>,0,<9.7,1,0>,1 scale y*1.2 rotate y*-45}
cylinder {<9.7,1,0>,<10.7,1,0>,1 texture {T_Gold_2C} normal {radial 1 frequency 25 triangle_wave rotate 90*z} scale y*1.2 rotate y*-45}
cone {<10.7,1,0>,1,<10.9,1,0>,.5 scale y*1.2 rotate y*-45}
cone {<10.9,1,0>,.5,<11,1,0>,0 scale y*1.2 rotate y*-45}


scale <.18,.15,.18> translate -.25*y
texture {T_Gold_2C}
}
//--------------------------------
#declare Band=
union{
union{
	cylinder {<-4,1,9>,<4,1,9>,1}
	box {<-4,.75,9>,<4,1.25,45>}
	cylinder {<-2,0,12>,<2,0,12>,1 scale <1,.5,1> translate 1.25*y}
	sphere {<-2,0,12>,1 scale <1,.5,1> translate 1.25*y}
	sphere {<2,0,12>,1 scale <1,.5,1> translate 1.25*y}
	cylinder {<-2,0,12>,<-2,0,28>,1 scale <1,.5,1> translate 1.25*y}
	cylinder {<2,0,12>,<2,0,28>,1 scale <1,.5,1> translate 1.25*y}
	box {<-2,1,12>,<2,1.75,28>}
	cylinder {<0,1,28>,<0,1.75,28>,2}
	torus {2,1 scale <1,.5,1> translate <0,1.25,28>}
	cylinder {<0,.75,0>,<0,1,0>,2 scale <2,1,4> translate 45*z}
scale <.18,.15,.18> translate -.25*y texture {Leather}
}
union{
	cylinder {<-4,1,9>,<4,1,9>,1}
	box {<-4,.75,9>,<4,1.25,45>}
	cylinder {<-2,0,12>,<2,0,12>,1 scale <1,.5,1> translate 1.25*y}
	sphere {<-2,0,12>,1 scale <1,.5,1> translate 1.25*y}
	sphere {<2,0,12>,1 scale <1,.5,1> translate 1.25*y}
	cylinder {<-2,0,12>,<-2,0,28>,1 scale <1,.5,1> translate 1.25*y}
	cylinder {<2,0,12>,<2,0,28>,1 scale <1,.5,1> translate 1.25*y}
	box {<-2,1,12>,<2,1.75,28>}
	cylinder {<0,1,28>,<0,1.75,28>,2}
	torus {2,1 scale <1,.5,1> translate <0,1.25,28>}
scale <.18,.15,-.18> translate -.25*y texture {Leather}
}
}

object {Ring1 texture {T_Gold_1C}}
object {Dial}
object {Watchglass texture {Glass2  finish {specular .45 roughness .004 reflection 0.05}}}

object {Minute_Hand translate .1*y rotate -55*y}
object {Hour_Hand translate .05*y rotate 60*y}
object {Second_Hand translate .15*y rotate 82*y}
cylinder {<0,0,0>,<0,.17,0>,.01 texture {T_Gold_1C}}
object {Body}
object {Band}


box {<-10,-1,-10>,<10,-.3,10> pigment {color rgb <.0,.7,.2>}}
box {<-3,-1,-5>,<3,-.25,5> pigment {image_map{
  gif "page.gif" 
  map_type 0 
  interpolate 2}
rotate 90*x translate <-.5,0,-.5> scale <6,0,10>
} finish {specular 0}
 scale <1.5,1,1.5>}

/*
camera {
  location  <0,30,0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0>
  orthographic

}
*/
camera {
  location  <2,4,-3>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  -.2>


}

//box {-40,40 texture {Tan_Wood}}
//SUMMER SKY BEGINS
sky_sphere {
	pigment {
		gradient y
		color_map {
			[0 color White]
			[.4 color SkyBlue]
			[.7 color rgb <0,0,.4>]
			[1 color rgb <0,0,.4>]
	 	}


  	}
}

//SUMMER SKY ENDS

intersection {
	box {<-1,-.5,-7>,<1,.5,7>}
	box {<-1,-.5,-7>,<1,.5,7> rotate z*60}
	box {<-1,-.5,-7>,<1,.5,7> rotate z*120}
	cylinder {<0,0,-8>,<0,0,8>,.55}
	union {
		cone {<0,0,4>,.7,<0,0,7>,.01 texture {pigment{DMFWood4}} finish {specular .1 roughness .1}}
		cylinder {<0,0,-10>,<0,0,4>,.7}
	}
		union {
		cone {<0,0,6>,.229,<0,0,7>,.01 texture {pigment {color rgb .01} finish {specular .1 roughness .02}}}
		cylinder {<0,0,-10>,<0,0,6>,.7}
	}
	texture {Red_Paint finish {specular .5 roughness .07}}
	scale .3 rotate <0,0,60> rotate 160*y
	translate <-3,-.15,1>
}
