
//------------------------------------------------------------------->
// "alicia.pov" - A little clock for the "time" contest.
//              - Do whatever you want with it! 8-)
//
//                Designed by: Paul T. Dawson.
//                ptdawson@voicenet.com

//------------------------------------------------------------------->
// This scene is built from several major parts. For easy testing,
// you can turn each part on or off, right here. Make certain that
// everything is "on" before you start that overnight render!

        #declare Show_Background   = on
        #declare Show_Big_Picture  = on
        #declare Show_Clock_Border = on
        #declare Show_Floor        = on
        #declare Show_Halo         = on
        #declare Show_Hands        = on
        #declare Show_Hour_Markers = on
        #declare Show_Spirals      = on

//------------------------------------------------------------------->
// Miscellaneous include files and defaults.

        #include "colors.inc"
        #include "textures.inc"
        #include "metals.inc"
        #include "skies.inc"
        #include "stones.inc"

        #declare Original_Finish = finish {}
        #default { finish { Shiny } }

        background { White }

        #declare R = seed(0)

//------------------------------------------------------------------->
// Set up the camera and lighting.

        camera { location < 0, 0, -62 > look_at 0 }

        // Back and to the left.
                light_source { < -50, 10, -90 > color rgb < 2, 2, 2 > }

        // High overhead.
                light_source { < 0, 100, 0 > color rgb < 1, 1, 1 > }

//------------------------------------------------------------------->
// Here's the background - a magnificent sky sphere!

        #if ( Show_Background = on )

                sky_sphere { S_Cloud1 rotate y * 270 }

        #end // End of if block.

//------------------------------------------------------------------->
// Create the central picture, on a simple cylinder. The picture is
// on the END of the cylinder, not the curved side!

        #if ( Show_Big_Picture = on )

        #declare Texture_Who_Is_That = texture {
                pigment {

                image_map { tga "alicia_1.tga"

                interpolate 2
                once
                } // End of image_map.
                } // End of pigment.
        } // End of texture.

        cylinder {

                < 0.5, 0.5, 0 > < 0.5, 0.5, 0.1 >, 0.5
                texture { Texture_Who_Is_That }
                translate < -0.5, -0.5, -0.05 >
                scale 40

        } // End of cylinder.

        #end // End of if block.

//------------------------------------------------------------------->
// Create the gold border around the picture, with a lot of notches
// and assorted cutouts of all kinds!

        #if ( Show_Clock_Border = on )

        difference {

                // Start with a big cylinder.
                        cylinder { <0,0,-3><0,0,3>,28 }

                // Cut a bevel on the front.
                        cone { <0,0,-3.001 >,22 <0,0,-1.999  >,20 }

                // Cut three thin slots for clock hands.
                difference{cylinder { <0,0,-4><0,0,1>, 20.5+0.15 }
                           cylinder { <0,0,-5><0,0,0>, 20.5-0.15 } }

                difference{cylinder { <0,0,-4><0,0,1>, 21.0+0.15 }
                           cylinder { <0,0,-5><0,0,0>, 21.0-0.15 } }

                difference{cylinder { <0,0,-4><0,0,1>, 21.5+0.15 }
                           cylinder { <0,0,-5><0,0,0>, 21.5-0.15 } }

                // Cut 60 notches around edge (one for each second).
                #declare A = 0
                #while ( A < 360 )

                        box { < 0, -0.1, -0.1 > < 30, 0.1, 0.1 >
                                rotate x * 45
                                rotate z * A
                                translate z * -3
                                } // End of box.

                #declare A = A + 6
                #end

                // Cut 12 holes for the hour markers.
                #declare A = 0
                #while ( A < 360 )

                        cone { < 0, 0, -3.001 >, 2.5 < 0, 0, -2.5 >, 2
                        scale < 1, 1.6, 1 >
                        translate < 25, 0, 0 >

                                rotate z * A
                                } // End of cone.

                #declare A = A + 30
                #end

                // Give it all a texture.
                        texture { T_Gold_3C }

        } // End of difference.

        #end // End of if block.

//------------------------------------------------------------------->
// Build the floor. This is made from several hundred boxes. Each one
// starts on the origin, and is randomly rotated in all directions.
// Then it is moved to the proper x,y,z location. The floor extends past
// the edges of the visible screen - on purpose! That's so all of the
// reflections show up properly.

        #if ( Show_Floor = on )

        union{

                #declare X = -120 #while ( X <= 120 )
                #declare Z = -120 #while ( Z <= 120 )

                        box { < -9, -9, -9 > < 9, 9, 9 >
                        rotate < rand(R)*360, rand(R)*360, rand(R)*360 >
                        translate < X, -40, Z > }

                #declare Z = Z + 10 #end
                #declare X = X + 10 #end

                // This is the nicest black&white stone texture!
                        texture { T_Stone31 scale 9 }

                // Tilt it down in front a little.
                        rotate x * -12.5

        } // End of union.

        #end // End of if block.

//------------------------------------------------------------------->
// Create the halo around the clock.

        #if ( Show_Halo = on )

        sphere { 0, 1

                pigment { color rgbt < 1, 1, 1, 1 > }

                halo {
                        emitting
                        spherical_mapping
                        linear

                        // Zero (0) transmittance is opaque!
                        color_map {
                        [ 0 color rgbt <1, 1, 1, 1> ]
                        [ 1 color rgbt <1, 1, 1, -0.5> ]}

                        samples 10
                        } // End of halo.

                hollow

                // Scale it to fit around the clock. This was tested
                // by using a solid blue sphere, and looking at it
                // from different angles.

                        scale < 40, 40, 1 >

                // Make sure it isn't shiny!

                        finish { Original_Finish }

        } // End of sphere.

        #end // End of if block.

//------------------------------------------------------------------->
// Create the three hands (hour, minute, second).
//
// These objects are rather confusing! Here's how they are built:
//
//       1. Start with a solid cylinder - outer diameter matches slot.
//          This is the part that pokes straight into the clock.
//       2. Cut away most of the cylinder, to leave just a "pie slice".
//       3. Add a perpendicular box - the actual hand. It is a union
//          with several pieces.
//       4. Use difference to remove the inner part of the solid cylinder.
//          This trims the starting cylinder AND the "hand", at exactly
//          the correct (curved) angle.

        #if ( Show_Hands = on )

        #declare Hour_Hand = difference {

                union {

                // Solid cylinder - minus pie slice.
                difference{
                        cylinder { <0,0,-1><0,0,-3.2>, 21.5 + 0.15 }
                        box{<0,-30,-9><30,30,9> rotate z * -5 }
                        box{<0,-30,-9><-30,30,9> rotate z * 5 }
                } // End of difference.

                // The union of the hand.
                union {
                        // The big flat part.
                                box { < -1.0, 20, -3.1 > < 1.0, 23, -3.2 > }
                        // The rounded end part.
                                cylinder { <0,0,-3.1><0,0,-3.2>,1.0
                                        translate y*23 }
                } // End of union.

                } // End of union.

                // Subtract the inner cylinder.
                        cylinder { <0,0,-9><0,0,9>, 21.5 - 0.15 }

                texture { T_Stone18 scale 0.5 }

                } // End of difference.

        #declare Minute_Hand = difference {

                union {

                // Solid cylinder - minus pie slice.
                difference{
                        cylinder { <0,0,-1><0,0,-3.4>, 21.0 + 0.15 }
                        box{<0,-30,-9><30,30,9> rotate z * -5 }
                        box{<0,-30,-9><-30,30,9> rotate z * 5 }
                } // End of difference.

                // The union of the hand.
                union {
                        // The big flat part.
                                box { < -0.7, 20, -3.3 > < 0.7, 25, -3.4 > }
                        // The rounded end part.
                                cylinder { <0,0,-3.3><0,0,-3.4>,0.7
                                        translate y*25 }
                } // End of union.

                } // End of union.

                // Subtract the inner cylinder.
                        cylinder { <0,0,-9><0,0,9>, 21.0 - 0.15 }

                texture { T_Stone18 scale 0.5 }

                } // End of difference.

        #declare Second_Hand = difference {

                union {

                // Solid cylinder - minus pie slice.
                difference{
                        cylinder { <0,0,-1><0,0,-3.6>, 20.5 + 0.15 }
                        box{<0,-30,-9><30,30,9> rotate z * -5 }
                        box{<0,-30,-9><-30,30,9> rotate z * 5 }
                } // End of difference.

                // The union of the hand.
                union {
                        // The big flat part.
                                box { < -0.4, 20, -3.5 > < 0.4, 27, -3.6 > }
                        // The rounded end part.
                                cylinder { <0,0,-3.5><0,0,-3.6>,0.4
                                        translate y*27 }
                } // End of union.

                } // End of union.

                // Subtract the inner cylinder.
                        cylinder { <0,0,-9><0,0,9>, 20.5 - 0.15 }

                texture { T_Stone18 scale 0.5 }

                } // End of difference.

        // Make the time equal 10:27:12.5 (just because!?!).
        // The hands are positioned 100% accurately!
        // These numbers are for: HOURS     MINUTES    SECONDS.
        #declare Hour_Angle   =   (10*30) + (27*0.5) + (12.5*0.5/60)
        #declare Minute_Angle =             (27*6.0) + (12.5*0.1)
        #declare Second_Angle =                        (12.5*6)

        union {

                object { Hour_Hand   rotate z * Hour_Angle   * -1 }
                object { Minute_Hand rotate z * Minute_Angle * -1 }
                object { Second_Hand rotate z * Second_Angle * -1 }

        } // End of union.

        #end // End of if block.


//------------------------------------------------------------------->
// Now create the hour markers - these are sized to fit exactly into
// the holes in the clock border. The bitmaps (with the six letters)
// were created with a little Visual Basic program. It draws all of
// the letters, and then fills in the gradient colors. Then I just cut
// out the square sections, and put them into the TGA files.

        #if ( Show_Hour_Markers = on )

        #declare LETTER = 1

        union {

                #declare A = 0
                #while ( A < 360 )

                        sphere { 0, 0.5

                        translate < 0.5, 0.5, 0.5 >

                        texture {
                        pigment {

                        #if (LETTER=1) #declare FILENAME="letter_1.tga" #end
                        #if (LETTER=2) #declare FILENAME="letter_2.tga" #end
                        #if (LETTER=3) #declare FILENAME="letter_3.tga" #end
                        #if (LETTER=4) #declare FILENAME="letter_4.tga" #end
                        #if (LETTER=5) #declare FILENAME="letter_5.tga" #end
                        #if (LETTER=6) #declare FILENAME="letter_6.tga" #end

                        image_map { tga FILENAME

                                interpolate 2
                                } // end of image_map
                        } // end of pigment
                        } // end of texture

                        translate < -0.5, -0.5, -0.5 >
                        rotate z*-90
                        scale 4

                        scale < 1, 1.6, 0.2 >
                        translate < 25, 0, -2.5 >

                        rotate z * 270
                        rotate z * A * -1

                        } // End of sphere.

                #declare LETTER = LETTER + 1
                #if ( LETTER > 6 ) #declare LETTER = 1 #end

                #declare A = A + 30
                #end

        } // End of union.

        #end // End of if block.

//------------------------------------------------------------------->
// Create the four spiral thingies.

        #if ( Show_Spirals = on )

        #declare Sphere_Size = 1.0
        #declare Y_Rotate = 5
        #declare Spiral_Radius = 3.0
        #declare Move_Up = 0.12
        #declare Move_Left = -35.5
        #declare Move_Right = 35.5

        #declare A = -300
        #while ( A < 300 )

                // Spiral #1 - Left side.

                sphere { 0, Sphere_Size
                        // Move it over to the right.
                                translate x * Spiral_Radius

                        // Rotate each one a little bit around y axis.
                                rotate y * A * Y_Rotate

                        // Move it up a TINY bit.
                                translate y * A * Move_Up

                        // Move it way over to the left.
                                translate x * Move_Left

                        // Select a nice color.
                                #declare RR = 1 - abs ( A / 300 )
                                #declare GG = (1 - abs ( A / 300 )) /2
                                #declare BB = abs ( A / 300 ) + 0.5
                                pigment { color rgb < RR, GG, BB > }
                                finish { F_MetalE }

                } // End of sphere.

                // Spiral #2 - Left side.

                sphere { 0, Sphere_Size
                        // Move it over to the right.
                                translate x * Spiral_Radius

                        // Rotate each one a little bit around y axis.
                                rotate y * A * Y_Rotate
                                rotate y * 180

                        // Move it up a TINY bit.
                                translate y * A * Move_Up

                        // Move it way over to the left.
                                translate x * Move_Left

                        // Select a nice color.
                                #declare RR = 1 - abs ( A / 300 )
                                #declare GG = (1 - abs ( A / 300 )) /2
                                #declare BB = abs ( A / 300 ) + 0.5
                                pigment { color rgb < RR, GG, BB > }
                                finish { F_MetalE }

                } // End of sphere.

                // Spiral #3 - Right side.

                sphere { 0, Sphere_Size
                        // Move it over to the right.
                                translate x * Spiral_Radius

                        // Rotate each one a little bit around y axis.
                                rotate y * A * Y_Rotate * -1

                        // Move it up a TINY bit.
                                translate y * A * Move_Up

                        // Move it way over to the right.
                                translate x * Move_Right

                        // Select a nice color.
                                #declare RR = 1 - abs ( A / 300 )
                                #declare GG = (1 - abs ( A / 300 )) /2
                                #declare BB = abs ( A / 300 ) + 0.5
                                pigment { color rgb < RR, GG, BB > }
                                finish { F_MetalE }

                } // End of sphere.

                // Spiral #4 - Right side.

                sphere { 0, Sphere_Size
                        // Move it over to the right.
                                translate x * Spiral_Radius

                        // Rotate each one a little bit around y axis.
                                rotate y * A * Y_Rotate * -1
                                rotate y * 180

                        // Move it up a TINY bit.
                                translate y * A * Move_Up

                        // Move it way over to the right.
                                translate x * Move_Right

                        // Select a nice color.
                                #declare RR = 1 - abs ( A / 300 )
                                #declare GG = (1 - abs ( A / 300 )) /2
                                #declare BB = abs ( A / 300 ) + 0.5
                                pigment { color rgb < RR, GG, BB > }
                                finish { F_MetalE }

                } // End of sphere.

        #declare A = A + 1
        #end

        #end // End of if block.

//------------------------------------------------------------------->
// End of this file.


