/* File     : clock.inc
 *
 * Purpose  : Break a time down into digits
 * Author   : (C)1996 Matthew Hunter
 * Version  : 0.01 (25 June 1996)
 *            0.02 (27 June 1996)
 *              Release version.
 */

/* Input state
 *
 * identifier 'internal_clock' must be declared in one of two forms
 *
 * a) A float value  0<=internal_clock<1 representing the fraction of the
 *    way through the day, 0 represents midnight, 0.5 represents midday
 *    and so on.
 *
 * b) A negative integer value representing the time to be displayed
 *    e.g. -1245 represents quarter to 1 in the afternoon. values
 *    out of range, e.g. -1278 will raise an error.
 */

/* Output state
 *
 * identifiers hour_1, hour_2, minute_1 and minute_2 will be declared
 * and internal_clock will be updated.
 *
 * hour_1   : the 'ten' digit of the hour, will be in the range 0-2
 *
 * hour_2   : the 'one' digit of the hour, will be in the range 0-9
 *            or 0-3 if hour_1 = 2
 *
 * minute_1 : the 'ten' digit of the minute, will be in the range 0-5
 *
 * minute_2 : the 'one' digit of the minute, will be in the range 0-9
 *
 * internal_clock will be updated to contain a positive integer
 * representing the time in digits, e.g. 1130 representing half past
 * eleven in the morning. This value is then suitable for passing
 * into the text functions (via str())
 *
 * The value returned will be in 24hr time.
 */

#if (internal_clock<0)
  #declare internal_clock=-internal_clock
  #declare hour_1   = mod(div(internal_clock,1000),10)
  #declare hour_2   = mod(div(internal_clock, 100),10)
  #declare minute_1 = mod(div(internal_clock,  10),10)
  #declare minute_2 = mod(div(internal_clock,   1),10)
#else
  #declare internal_clock = internal_clock*24*60
  #declare hour_1 = mod(div(internal_clock,600),10)
  #declare hour_2 = mod(div(internal_clock, 60),10)
  #declare internal_clock = mod(internal_clock,60)
  #declare minute_1 = mod(div(internal_clock,10),10)
  #declare minute_2 = mod(div(internal_clock, 1),10)
  #declare internal_clock = (hour_1*1000)+(hour_2*100)+(minute_1*10)+minute_2
#end

#if ((minute_1>5) | (hour_1>2) | ((hour_1=2) & (hour_2>3)))
  #error "Clock time is invalid - Aborting\n"
#end

#render "Clock time is "
#render str(hour_1,0,0)
#render str(hour_2,0,0)
#render ":"
#render str(minute_1,0,0)
#render str(minute_2,0,0)
#render "\n"
#render concat("internal clock set at ",str(internal_clock,4,0),"\n")

