/* File     : Maketime.inc
 *
 * Purpose  : Build an object holding the LCD digits to display the time
 * Author   : (C) 1996 Matthew Hunter
 * Version  : 0.01 (25 June 1996)
 *            0.02 (27 June 1996)
 *              Release Version.
 */

/* Input state
 *
 * hour_1, hour_2, minute_1 and minute_2 should be set up using
 * clock.inc. They can be set manually if prefered, but no checks
 * will be made here so the result may be an invalid time.
 *
 * Maketime_Off if non-zero then the 'off' segments will also be
 * shown. Defaults to 0.
 *
 * Maketime_Pad if non-zero then leading zeros will be added for
 * times between midnight and 10am. If zero then the lead zero will
 * not be shown, but the space will be included so as to ensure that
 * the spacing is constant, whatever the time. If Maketime_Off is
 * non-zero and Maketime_Pad is zero then the first digit will shown
 * with all segments off. Defaults to 0.
 *
 * Maketime_Space is the horizontal distance between the centres of
 * adjacent digits. Defaults to 22
 *
 * Maketime_Centre is half the horizontal distance between the hour
 * and minute numbers. Defaults to 4
 *
 * Maketime_TOn the texture to use for the 'on' segments.  If this is
 * undefined then an error will be raised.
 *
 * Maketime_TOff the texture to use for 'off' segments. If this is
 * undefined then no 'off' segments will be shown, and Maketime_Off
 * will be set to 0.
 */

/* Output State
 *
 * Maketime_Time will be declared as the union of the digits, centred on
 * 0,0,0.
 */

/* Make sure defaults, and check that all required elements are present */
#ifndef (Maketime_Off)
  #declare Maketime_Off=0
#end

#ifndef (Maketime_Pad)
  #declare Maketime_Pad=0
#end

#ifndef (Maketime_Space)
  #declare Maketime_Space=22
#end

#ifndef (Maketime_TOn)
  #error "Maketime_TOn MUST be declared to use Maketime.inc\n"
#end

#ifndef (Maketime_TOff)
  #declare Maketime_Off=0
#end

#ifndef (Maketime_Centre)
  #declare Maketime_Centre=4
#end

#if (Maketime_Off)
  #render "Displaying off segments\n"
#end

/* Calculate start position of time object */
#declare Maketime_X = -((Maketime_Space*1.5)+Maketime_Centre)

#declare Maketime_Time = union {
  // hour_1
  #if ((hour_1>0) | Maketime_Pad)
    #declare LCD_Ext_Number=hour_1
    #include "LCD_Ext.inc"
    object {
      LCD_Ext_Digit
      texture { Maketime_TOn }
      translate <Maketime_X,0,0>
    }
    #if (Maketime_Off)
      object {
        LCD_Ext_Digit_off
        texture { Maketime_TOff }
        translate <Maketime_X,0,0>
      }
    #end
  #else
    #if ((hour_1=0) & Maketime_Off)
      object {
        LCD_Digit8
        texture { Maketime_TOff }
        translate <Maketime_X,0,0>
      }
    #end
  #end
  //hour_2
  #declare Maketime_X=Maketime_X+Maketime_Space
  #declare LCD_Ext_Number=hour_2
  #include "LCD_Ext.inc"
  object {
    LCD_Ext_Digit
    texture { Maketime_TOn }
    translate <Maketime_X,0,0>
  }
  #if (Maketime_Off)
    object {
      LCD_Ext_Digit_off
      texture { Maketime_TOff }
      translate <Maketime_X,0,0>
    }
  #end
  //minute_1
  #declare Maketime_X=Maketime_X+Maketime_Space+(2*Maketime_Centre)
  #declare LCD_Ext_Number=minute_1
  #include "LCD_Ext.inc"
  object {
    LCD_Ext_Digit
    texture { Maketime_TOn }
    translate <Maketime_X,0,0>
  }
  #if (Maketime_Off)
    object {
      LCD_Ext_Digit_off
      texture { Maketime_TOff }
      translate <Maketime_X,0,0>
    }
  #end
  //minute_2
  #declare Maketime_X=Maketime_X+Maketime_Space
  #declare LCD_Ext_Number=minute_2
  #include "LCD_Ext.inc"
  object {
    LCD_Ext_Digit
    texture { Maketime_TOn }
    translate <Maketime_X,0,0>
  }
  #if (Maketime_Off)
    object {
      LCD_Ext_Digit_off
      texture { Maketime_TOff }
      translate <Maketime_X,0,0>
    }
  #end
  object {
    LCD_Colon
    texture { Maketime_TOn }
  }
}

