// ----------------------------------------------------------------------------
// ------------ GLOBALS DECLARATIONS ------------------------------------------
// ----------------------------------------------------------------------------

#declare Dull = finish { specular 0.5 roughness 0.15 }
#declare Algae1= texture{
                pigment{
                marble
                color_map{
                [0.1 color green .8 blue .7]
                [0.5 color green .45 blue .45]
                [0.6 color green .5 blue .55]
                [0.8 color red .1 green .6 blue .55]}
                turbulence .9
                octaves 3
                omega .3
                }
                finish{
                specular .7 roughness .005
                diffuse .2
                brilliance 1.5
                }
       }

#declare Shiny = finish { specular 1 roughness 0.001 }
#declare Bark1=  texture {pigment{color rgb<.56 .56 .4>}
        normal {wrinkles .6 scale .15}
        finish {crand .05}
        scale <1,5,1>}
#declare Phong_Dull = finish { phong 0.5  phong_size 1 }
#declare Phong_Shiny = finish { phong 1  phong_size 200 }
#declare Glossy = finish { specular 1 roughness 0.0001 reflection 0.13 }
#declare Phong_Glossy = finish { phong 1 phong_size 300 reflection 0.13 }
#declare Luminous = finish { ambient 1  diffuse 0 }
#declare Mirror = finish { ambient 0  diffuse 0 reflection 1 }
#declare LBlue = color red 0.0 green 0.6 blue 0.6
#declare Vein = color red 0.6 green 0.0 blue 0.0
#declare DimGray = color red 0.329412 green 0.329412 blue 0.329412
#declare Gray = color red 0.752941 green 0.752941 blue 0.752941
#declare Mica = color rgb <0,0,0>
#declare White = color rgb <1,1,1>
#declare Black = color rgb <0,0,0>
#declare Clear = color rgbf <1,1,1,1>
#declare SeaGreen = color red 0.137255 green 0.556863 blue 0.419608
#declare DarkGreen = color red 0.184314 green 0.309804 blue 0.184314
#declare Scarlet = color red 0.55 green 0.09 blue 0.09
#declare Salmon = color red 0.435294 green 0.258824 blue 0.258824
#declare Feldspar = color red 0.82 green 0.57 blue 0.46
#declare Yellow = color red 1.0 green 1.0

#declare Glass_Finish = finish {
  Shiny
  ambient 0
  diffuse 0
  reflection 0.1
  refraction 1
  ior 1.5
}

#declare Metal = finish {
  metallic
  ambient 0.2
  diffuse 0.7
  brilliance 6
  reflection 0.25
  phong 0.75
  phong_size 80
}

#declare Finish_Silver_Metal = finish {
  metallic
  ambient 0.25
  diffuse 0.65
  reflection 0.45
  brilliance 6
  phong 1
  phong_size 100
}

// ----------------------------------------------------------------------------
// ------------ STONES TEXTURES DESCRIPTION -----------------------------------
// ----------------------------------------------------------------------------

#declare Red_Marble_1 = pigment {
  marble
  turbulence 1
  color_map{
   [0.0, 0.8   color red 0.8 green 0.8 blue 0.6
               color red 0.8 green 0.4 blue 0.4]
   [0.8, 1.001 color red 0.8 green 0.4 blue 0.4
               color red 0.8 green 0.2 blue 0.2]
  }
}

#declare Blue_Agate = pigment {
  agate
  color_map {
    [0.0, 0.5   color red 0.30 green 0.30 blue 0.50
                color red 0.30 green 0.30 blue 0.50]
    [0.5, 0.55  color red 0.30 green 0.30 blue 0.50
                color red 0.20 green 0.20 blue 0.30]
    [0.55, 0.6  color red 0.20 green 0.20 blue 0.30
                color red 0.25 green 0.25 blue 0.35]
    [0.6, 0.7   color red 0.25 green 0.25 blue 0.35
                color red 0.15 green 0.15 blue 0.26]
    [0.7, 0.8   color red 0.15 green 0.15 blue 0.26
                color red 0.10 green 0.10 blue 0.20]
    [0.8, 0.9   color red 0.10 green 0.10 blue 0.20
                color red 0.30 green 0.30 blue 0.50]
    [0.9, 1.001 color red 0.30 green 0.30 blue 0.50
                color red 0.10 green 0.10 blue 0.20]
  }
}

#declare White_Bleu_Agate = texture {
  pigment {
    agate
    color_map {
      [0.0, 0.5   color red 0.10 green 0.10 blue 0.50
                  color red 1.00 green 1.00 blue 1.00]
      [0.5, 1.001 color red 1.00 green 1.00 blue 1.00
                  color red 0.10 green 0.10 blue 0.50]
    }
  }
  finish {
    reflection 0.2
    phong 1.0
  }
  scale <2,2,2>
}

#declare Saphirre_Agate = pigment {
  agate
  color_map {
    [0.0, 0.3   color blue 0.9
                color blue 0.8]
     [0.3,1.001 color blue 0.8
                color blue 0.4]
  }
}

#declare White_Maroon_Agate_2 = pigment {
  agate
  color_map {
    [0.0, 0.5   color red 1 green 1 blue 1
                color red 0.9 green 0.7 blue 0.6]
    [0.5, 0.6   color red 0.9 green 0.7 blue 0.6
                color red 0.9 green 0.7 blue 0.4]
    [0.6, 1.001 color red 0.9 green 0.7 blue 0.4
                color red 0.7 green 0.4 blue 0.2]
  }
}

#declare Pink_Alabaster = texture {
  pigment {
    bozo
    turbulence 0.25
    color_map {
      [0,  1 color red 0.9 green 0.75 blue 0.75
             color red 0.6 green 0.6  blue 0.6 ]
    }
    scale 0.4
  }
  finish {
    ambient 0.25
  }
}
texture {
  pigment {
    granite
    color_map {
       [0,   0.9 color red 0.52 green 0.39 blue 0.39 filter 1
                 color red 0.52 green 0.39 blue 0.39 filter 0.5]
       [0.9, 1   color red 0.184314 green 0.309804 blue 0.309804
                 color red 0.184314 green 0.309804 blue 0.309804]
    }
    scale 2       // Twice as large as unit shape
  }
  finish {
    specular 1
    roughness 0.0001
    phong 0.25
    phong_size 75
    brilliance 4
  }
}

// ----------------------------------------------------------------------------
// ------------ SKIES TEXTURES ------------------------------------------------
// ----------------------------------------------------------------------------

#declare Blue_Sky = pigment {
  bozo
  turbulence 0.3
  color_map {
    [0.0, 0.5   color red 0.25 green 0.25 blue 0.5
                color red 0.25 green 0.25 blue 0.5]
    [0.5, 0.6   color red 0.25 green 0.25 blue 0.5
                color red 0.7  green 0.7  blue 0.7]
    [0.6, 1.001 color red 0.7  green 0.7  blue 0.7
                color red 0.3  green 0.3  blue 0.3]
  }
}

#declare Bright_Blue_Sky = pigment {
  bozo
  turbulence 0.56
  color_map {
    [0.0, 0.5  color red 0.5 green 0.5 blue 1.0
               color red 0.5 green 0.5 blue 1.0]
    [0.5, 0.6  color red 0.5 green 0.5 blue 1.0
               color red 1.0 green 1.0 blue 1.0]
    [0.6, 1.01 color red 1.0 green 1.0 blue 1.0
               color red 0.5 green 0.5 blue 0.5]
  }
}

#declare Blue_Sky_2 = pigment {
  agate
  color_map {
    [ 0, .3  color red 0 green 0 blue 1  color red 0 green 0 blue 1  ]
    [.3,  1  color red 0 green 0 blue 1  color red 1 green 1 blue 1 ]
  }
  scale .75
}

#declare Blue_Sky_3 = pigment {
  granite
  turbulence 0.1
  color_map {
    [ 0, .3  color red 0 green 0 blue 1
             color red 0 green 0 blue 1  ]
    [.3,  1  color red 0 green 0 blue 1
             color red 1 green 1 blue 1 ]
  }
  scale .75
}

#declare Blood_Sky = pigment {
  bozo
  turbulence 0.5
  color_map {
    [0.0, 0.5  color red 0.9 green 0.7
               color red 0.3 green 0.2]
    [0.5, 0.6  color red 0.6 green 0.025
               color red 0.9 green 0.7]
    [0.6, 1.01 color red 0.6 green 0.025
               color red 0.6 green 0.025]
  }
}

#declare Apocalypse_Sky = pigment {
  bozo
  color_map {
    [0.0, 0.4  color red 0.8
               color red 0.4 blue 0.4]
    [0.4, 0.6  color red 0.4 blue 0.4
               color        blue 0.2]
    [0.6, 1.01 color        blue 0.2
               color red 0 green 0 blue 0]
  }
}

#declare Just_Clouds = pigment {
  bozo
  turbulence 0
  color_map {
    [0.0, 0.1   color red 0.8 green 0.8 blue 0.8
                color red 0.8 green 0.8 blue 0.8]
    [0.1, 0.5   color red 0.8 green 0.8 blue 0.8
                color red 1.0 green 1.0 blue 1.0 filter 1.0]
    [0.5, 1.001 color red 1.0 green 1.0 blue 1.0 filter 1.0
                color red 1.0 green 1.0 blue 1.0 filter 1.0]
  }
}

// ----------------------------------------------------------------------------
// ------------ WOODEN TEXTURES -----------------------------------------------
// ----------------------------------------------------------------------------

#declare Cherry_Wood = pigment {
  wood
  turbulence 0.3
  color_map {
    [0.0, 0.8  color red 0.666 green 0.312 blue 0.2
               color red 0.666 green 0.312 blue 0.2]
    [0.8, 1.01 color red 0.4 green 0.133 blue 0.066
               color red 0.2 green 0.065 blue 0.033]
  }
}

#declare Pine_Wood = pigment {
  wood
  turbulence 0.2
  color_map {
    [0.0, 0.8  color red 1.0 green 0.71875 blue 0.25
               color red 1.0 green 0.71875 blue 0.25]
    [0.8, 1.01 color red 0.5 green 0.5     blue 0.066
               color red 0.4 green 0.4     blue 0.033]
  }
}

#declare Dark_Wood = pigment {
  wood
  turbulence 0.2
  color_map {
    [0.0, 0.8  color red 0.42857 green 0.23810 blue 0.04762
               color red 0.42857 green 0.23810 blue 0.04762]
    [0.8, 1.01 color red 0.4     green 0.333   blue 0.066
               color red 0.2     green 0.033   blue 0.033]
  }
}

#declare Tan_Wood = pigment {
  wood
  turbulence 0.1
  color_map {
    [0.0, 0.8  color red 0.888 green 0.600 blue 0.3
               color red 0.888 green 0.600 blue 0.3]
    [0.8, 1.01 color red 0.6   green 0.4   blue 0.2
               color red 0.4   green 0.3   blue 0.2]
  }
}

#declare White_Wood = pigment {
  wood
  turbulence 0.6
  color_map {
    [0.0, 0.8  color red 0.93 green 0.71 blue 0.532
               color red 0.98 green 0.81 blue 0.6]
    [0.8, 1.01 color red 0.6 green 0.333 blue 0.266
               color red 0.7 green 0.6 blue 0.23]
  }
}

#declare Tom_Wood = pigment {
  wood
  turbulence 0.31
  color_map {
    [0.0, 0.8   color red 0.7 green 0.3
                color red 0.7 green 0.3]
    [0.8, 1.01  color red 0.5 green 0.2
                color red 0.4 green 0.1]
  }
}

#declare Yellow_Pine = texture {
 pigment {
   wood
   turbulence 0.02
   color_map {
      [0.000, 0.222  color red  0.808  green  0.671  blue  0.251  filter  0.000
                     color red  0.808  green  0.671  blue  0.251  filter  0.000]
      [0.222, 0.342  color red  0.808  green  0.671  blue  0.251  filter  0.000
                     color red  0.600  green  0.349  blue  0.043  filter  0.000]
      [0.342, 0.393  color red  0.600  green  0.349  blue  0.043  filter  0.000
                     color red  0.808  green  0.671  blue  0.251  filter  0.000]
      [0.393, 0.709  color red  0.808  green  0.671  blue  0.251  filter  0.000
                     color red  0.808  green  0.671  blue  0.251  filter  0.000]
      [0.709, 0.821  color red  0.808  green  0.671  blue  0.251  filter  0.000
                     color red  0.533  green  0.298  blue  0.027  filter  0.000]
      [0.821, 1      color red  0.533  green  0.298  blue  0.027  filter  0.000
                     color red  0.808  green  0.671  blue  0.251  filter  0.000]
   }
   scale 0.1
   translate <10, 0, 0>
   }
}
// Yellow_Pine layer 2
texture {
 pigment {
   wood
   turbulence 0.01
   color_map {
      [0.000, 0.120   color red  1.000  green  1.000  blue  1.000  filter  1.000
                      color red  0.702  green  0.412  blue  0.118  filter  0.608]
      [0.120, 0.231   color red  0.702  green  0.412  blue  0.118  filter  0.608
                      color red  0.702  green  0.467  blue  0.118  filter  0.608]
      [0.231, 0.496   color red  0.702  green  0.467  blue  0.118  filter  0.608
                      color red  1.000  green  1.000  blue  1.000  filter  1.000]
      [0.496, 0.701   color red  1.000  green  1.000  blue  1.000  filter  1.000
                      color red  1.000  green  1.000  blue  1.000  filter  1.000]
      [0.701, 0.829   color red  1.000  green  1.000  blue  1.000  filter  1.000
                      color red  0.702  green  0.467  blue  0.118  filter  0.608]
      [0.829, 1       color red  0.702  green  0.467  blue  0.118  filter  0.608
                      color red  1.000  green  1.000  blue  1.000  filter  1.000]
   }
   scale 0.5 
   translate <10, 0, 0>
 }
}

//
//   Rosewood
//
#declare Rosewood = texture {
 pigment {
   bozo
   turbulence 0.04
   color_map {
      [0.000, 0.256   color red  0.204  green  0.110  blue  0.078  filter  0.000
                      color red  0.231  green  0.125  blue  0.090  filter  0.000]
      [0.256, 0.393   color red  0.231  green  0.125  blue  0.090  filter  0.000
                      color red  0.247  green  0.133  blue  0.090  filter  0.000]
      [0.393, 0.581   color red  0.247  green  0.133  blue  0.090  filter  0.000
                      color red  0.204  green  0.110  blue  0.075  filter  0.000]
      [0.581, 0.726   color red  0.204  green  0.110  blue  0.075  filter  0.000
                      color red  0.259  green  0.122  blue  0.102  filter  0.000]
      [0.726, 0.983   color red  0.259  green  0.122  blue  0.102  filter  0.000
                      color red  0.231  green  0.125  blue  0.086  filter  0.000]
      [0.983, 1       color red  0.231  green  0.125  blue  0.086  filter  0.000
                      color red  0.204  green  0.110  blue  0.078  filter  0.000]
   }
   scale <0.5, 0.5, 1>
   translate <10, 0, 0>
 }
 finish {
   ambient 0.5
   diffuse 0.8
 }
}
// Rosewood layer 2
texture {
 pigment {
   wood
   turbulence 0.04
   color_map {
      [0.000, 0.139   color red  0.545  green  0.349  blue  0.247  filter  1.000
                      color red  0.000  green  0.000  blue  0.000  filter  0.004]
      [0.139, 0.148   color red  0.000  green  0.000  blue  0.000  filter  0.004
                      color red  0.000  green  0.000  blue  0.000  filter  0.004]
      [0.148, 0.287   color red  0.000  green  0.000  blue  0.000  filter  0.004
                      color red  0.545  green  0.349  blue  0.247  filter  1.000]
      [0.287, 0.443   color red  0.545  green  0.349  blue  0.247  filter  1.000
                      color red  0.545  green  0.349  blue  0.247  filter  1.000]
      [0.443, 0.626   color red  0.545  green  0.349  blue  0.247  filter  1.000
                      color red  0.000  green  0.000  blue  0.000  filter  0.004]
      [0.626, 0.635   color red  0.000  green  0.000  blue  0.000  filter  0.004
                      color red  0.000  green  0.000  blue  0.000  filter  0.004]
      [0.635, 0.843   color red  0.000  green  0.000  blue  0.000  filter  0.004
                      color red  0.545  green  0.349  blue  0.247  filter  1.000]
      [0.843, 1       color red  0.545  green  0.349  blue  0.247  filter  1.000
                      color red  0.545  green  0.349  blue  0.247  filter  1.000]
   }
   scale <0.5, 0.5, 1>
   translate <10, 0, 0>
 }
 finish {
   ambient 0.5
   diffuse 0.8
 }
}

//
//   Sandalwood ( makes a great burled maple, too)
//
#declare Sandalwood = texture {
 pigment {
   bozo
   turbulence 0.2
   color_map {
      [0.000, 0.171   color red  0.725  green  0.659  blue  0.455  filter  0.000
                      color red  0.682  green  0.549  blue  0.420  filter  0.000]
      [0.171, 0.274   color red  0.682  green  0.549  blue  0.420  filter  0.000
                      color red  0.557  green  0.451  blue  0.322  filter  0.000]
      [0.274, 0.393   color red  0.557  green  0.451  blue  0.322  filter  0.000
                      color red  0.725  green  0.659  blue  0.455  filter  0.000]
      [0.393, 0.564   color red  0.725  green  0.659  blue  0.455  filter  0.000
                      color red  0.682  green  0.549  blue  0.420  filter  0.000]
      [0.564, 0.701   color red  0.682  green  0.549  blue  0.420  filter  0.000
                      color red  0.482  green  0.392  blue  0.278  filter  0.000]
      [0.701, 1       color red  0.482  green  0.392  blue  0.278  filter  0.000
                      color red  0.725  green  0.659  blue  0.455  filter  0.000]
   }
   scale <0.2, 0.2, 1>
   scale 2
 }
}
// Sandalwood layer 2
texture {
 pigment {
   bozo
   turbulence 0.8
   color_map {
      [0.000, 0.087   color red  0.682  green  0.604  blue  0.380  filter  1.000
                      color red  0.761  green  0.694  blue  0.600  filter  0.020]
      [0.087, 0.226   color red  0.761  green  0.694  blue  0.600  filter  0.020
                      color red  0.635  green  0.553  blue  0.325  filter  1.000]
      [0.226, 0.348   color red  0.635  green  0.553  blue  0.325  filter  1.000
                      color red  0.761  green  0.694  blue  0.600  filter  0.020]
      [0.348, 0.496   color red  0.761  green  0.694  blue  0.600  filter  0.020
                      color red  0.682  green  0.604  blue  0.380  filter  1.000]
      [0.496, 0.565   color red  0.682  green  0.604  blue  0.380  filter  1.000
                      color red  0.761  green  0.694  blue  0.600  filter  0.020]
      [0.565, 0.661   color red  0.761  green  0.694  blue  0.600  filter  0.020
                      color red  0.682  green  0.604  blue  0.380  filter  1.000]
      [0.661, 0.835   color red  0.682  green  0.604  blue  0.380  filter  1.000
                      color red  0.761  green  0.694  blue  0.600  filter  0.020]
      [0.835, 1       color red  0.761  green  0.694  blue  0.600  filter  0.020
                      color red  0.682  green  0.604  blue  0.380  filter  1.000]
   }
   scale 0.2
   scale 2
 }
}

// ----------------------------------------------------------------------------
// ------------ GLASS TEXTURES ------------------------------------------------
// ----------------------------------------------------------------------------

#declare Glass = texture {
  pigment {
    color red 1 green 1 blue 1 filter 0.7
  }
  finish {
    specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1
    refraction 1
    ior 1.5
  }
}

#declare Plexiglas = texture {
  pigment { color red 1 green 1 blue 1 filter 1.0 }
  finish {
    ambient 0
    diffuse 0
    reflection 0.5
    refraction 0.85
    ior 1.5
    phong 0.3
    phong_size 60
  }
}

#declare Crystal = texture {
  pigment {
    color red 0.98 green 0.98 blue 0.98 filter 0.9
  }
  finish {
    ambient 0.1
    diffuse 0.1
    specular 0.8
    reflection 0.1
    refraction 0.9
    ior 1.45
    roughness 0.0003
    phong 1
    phong_size 400
  }
}

#declare Green_Glass = texture {
  pigment {
    color red 0.8 green 1 blue 0.95 filter 0.9
  }
  finish {
    ambient 0.1
    diffuse 0.1
    specular 0.8
    reflection 0.1
    refraction 0.9
    ior 1.45
    roughness 0.0003
    phong 1
    phong_size 400
  }
}

// ----------------------------------------------------------------------------
// ------------ METAL TEXTURES ------------------------------------------------
// ----------------------------------------------------------------------------

#declare Metal_Chrome_1 = texture {
  pigment {
    rgb <0,0,0>
  }
  finish {
    ambient 0.3
    diffuse 0.7
    reflection 0.9
    phong 1.0
  }
}

#declare Brass_Metal    = texture { pigment { color red 0.71 green 0.65 blue 0.26 } finish { Metal }}
#declare Gold_Metal     = texture { pigment { color red 0.85 green 0.85 blue 0.10 } finish { Metal }}
#declare Bronze_Metal   = texture { pigment { color red 0.55 green 0.47 blue 0.14 } finish { Metal }}
#declare Copper_Metal   = texture { pigment { color red 0.72 green 0.45 blue 0.20 } finish { Metal }}
#declare Silver_Metal_1 = texture { pigment { color red 0.90 green 0.91 blue 0.98 } finish { Metal }}

#declare Polish_Chrome_Metal = texture {
  pigment { red 0.20 green 0.20 blue 0.20 }
  finish {
    ambient 0.1
    diffuse 0.7
    brilliance 6.0
    reflection 0.6
    phong 0.8
    phong_size 120
  }
}

#declare Polish_Brass_Metal = texture {
  pigment { color red 0.578 green 0.422 blue 0.195 }
  finish {
    metallic
    ambient 0.1
    diffuse 0.8
    brilliance 6.0
    reflection 0.4
    phong 0.8
    phong_size 120
  }
}

#declare Military_Brass_Metal = texture {
  pigment { color red 0.70  green 0.56  blue 0.37 }
  finish {
    ambient 0.35
    diffuse 1.00
    brilliance 15
    phong 0.41
    phong_size 5
  }
}

#declare Cymbals_Metal = texture {
  pigment { color rgb<0.55,0.55,0.30> }
  normal { bumps 0.3 scale 0.07 }
  finish { phong 1.0 phong_size 60 reflection 0.25 }
}

#declare Silver_Metal_2 = texture {
  pigment { red 0.94 green 0.93 blue 0.83 }
  finish { Finish_Silver_Metal }
}

#declare Rusty_Iron = pigment {
  agate
  color_map {
    [0.0, 0.5   color red 0.21 green 0.10 blue 0.1
                color red 0.25 green 0.25 blue 0.01]
    [0.5, 0.6   color red 0.25 green 0.25 blue 0.01
                color red 0.30 green 0.10 blue 0.1]
    [0.6, 1.001 color red 0.15 green 0.10 blue 0.1
                color red 0.15 green 0.10 blue 0.1]
  }
}

#declare Rust = pigment {
  spotted
  color_map {
    [0.0, 0.4   color red 0.89 green 0.51 blue 0.28
                color red 0.70 green 0.13]
    [0.4, 0.5   color red 0.70 green 0.13
                color red 0.69 green 0.41 blue 0.08]
    [0.5, 0.6   color red 0.69 green 0.41 blue 0.08
                color red 0.49 green 0.31 blue 0.28]
    [0.6, 1.001 color red 0.49 green 0.31 blue 0.28
                color red 0.89 green 0.51 blue 0.28]
  }
}

// ----------------------------------------------------------------------------
// ------------ FX TEXTURES ---------------------------------------------------
// ----------------------------------------------------------------------------

#declare Candy_Cane = pigment {
   gradient x+y
   color_map {
     [0.00, 0.25  color red 1 green 0 blue 0
                  color red 1 green 0 blue 0]
     [0.25, 0.75  color red 1 green 1 blue 1
                  color red 1 green 1 blue 1]
     [0.75, 1.001 color red 1 green 0 blue 0
                  color red 1 green 0 blue 0]
    }
  }

#declare Peel = texture {
  pigment {
    gradient < 1, 1, 0 >
    color_map {
      [0.00, 0.25  color red 1 green 0.5 blue 0.0
                   color red 1 green 0.5 blue 0.0]
      [0.25, 0.75  color red 1 green 1 blue 1 filter 1
                   color red 1 green 1 blue 1 filter 1]
      [0.75, 1.001 color red 1 green 0.5 blue 0.0
                   color red 1 green 0.5 blue 0.0]
    }
  }
}

#declare Water = texture {
  pigment {
    color rgbf <0.9,0.9,1.0,0.6>
  }
  normal { bumps 0.5 }
  finish {
    reflection 0.3
    refraction 0.5
    ior 1.33
    phong 1.0
    phong_size 50
  }
  scale <0.2,0.2,0.2>
}

// ----------------------------------------------------------------------------
// ------------ MY OWN TEXTURES - Denis Olivier -------------------------------
// ----------------------------------------------------------------------------

#declare Red_Plastic = texture { pigment { color rgb <1,0,0> } finish { phong 1.0 } }
#declare White_Plastic = texture { pigment { color rgb <1,1,1> } finish { phong 1.0 } }
#declare Green_Plastic = texture { pigment { color rgb <0,1,0> } finish { phong 1.0 } }
#declare Blue_Plastic = texture { pigment { color rgb <0,0,1> } finish { phong 1.0 } }
#declare Black_Plastic = texture { pigment { color rgb <0,0,0> } finish { phong 1.0 } }
#declare Yellow_Plastic = texture { pigment { color rgb <1,1,0> } finish { phong 1.0 } }
#declare Magenta_Plastic = texture { pigment { color red 1.0 blue 1.0 } finish { phong 1.0 } }
#declare Aquamarine_Plastic = texture { pigment { color red 0.439216 green 0.858824 blue 0.576471 } finish { phong 1.0 } }
#declare Brown_Plastic = texture { pigment { color red 0.647059 green 0.164706 blue 0.164706 } finish { phong 1.0 } }
#declare DarkOliveGreen_Plastic = texture { pigment { color red 0.309804 green 0.309804 blue 0.184314 } finish { phong 1.0 } }
#declare Firebrick_Plastic = texture { pigment { color red 0.556863 green 0.137255 blue 0.137255 } finish { phong 1.0 } }
#declare LightBlue_Plastic = texture { pigment { color red 0.74902 green 0.847059 blue 0.847059 } finish { phong 1.0 } }
#declare Maroon_Plastic = texture { pigment { color red 0.556863 green 0.137255 blue 0.419608 } finish { phong 1.0 } }
#declare MediumAquamarine_Plastic = texture { pigment { color red 0.196078 green 0.8 blue 0.6 } finish { phong 1.0 } }
#declare MidnightBlue_Plastic = texture { pigment { color red 0.184314 green 0.184314 blue 0.309804 } finish { phong 1.0 } }
#declare Navy_Plastic = texture { pigment { color red 0.137255 green 0.137255 blue 0.556863 } finish { phong 1.0 } }
#declare Orange_Plastic = texture { pigment { color red 1 green 0.5 blue 0.0 } finish { phong 1.0 } }
#declare Orchid_Plastic = texture { pigment { color red 0.858824 green 0.439216 blue 0.858824 } finish { phong 1.0 } }
#declare Pink_Plastic = texture { pigment { color red 0.737255 green 0.560784 blue 0.560784 } finish { phong 1.0 } }
#declare Salmon_Plastic = texture { pigment { color red 0.435294 green 0.258824 blue 0.258824 } finish { phong 1.0 } }
#declare Tan_Plastic = texture { pigment { color red 0.858824 green 0.576471 blue 0.439216 } finish { phong 1.0 } }
#declare Turquoise_Plastic = texture { pigment { color red 0.678431 green 0.917647 blue 0.917647 } finish { phong 1.0 } }
#declare Violet_Plastic = texture { pigment { color red 0.309804 green 0.184314 blue 0.309804 } finish { phong 1.0 } }
#declare DarkBrown_Plastic = texture { pigment { color red 0.36 green 0.25 blue 0.20 } finish { phong 1.0 } }

#declare Red_RPlastic = texture { pigment { color rgb <1,0,0> } finish { phong 1.0 reflection 0.4 } }
#declare White_RPlastic = texture { pigment { color rgb <1,1,1> } finish { phong 1.0 reflection 0.4 } }
#declare Green_RPlastic = texture { pigment { color rgb <0,1,0>  } finish { phong 1.0 reflection 0.4 } }
#declare Blue_RPlastic = texture { pigment { color rgb <0,0,1>  } finish { phong 1.0 reflection 0.4 } }
#declare Black_RPlastic = texture { pigment { color rgb <0,0,0> } finish { phong 1.0 reflection 0.4 } }
#declare Yellow_RPlastic = texture { pigment { color rgb <1,1,0> } finish { phong 1.0 reflection 0.4 } }
#declare Magenta_RPlastic = texture { pigment { color red 1.0 blue 1.0 } finish { phong 1.0 reflection 0.4 } }
#declare Aquamarine_RPlastic = texture { pigment { color red 0.439216 green 0.858824 blue 0.576471 } finish { phong 1.0 reflection 0.4 } }
#declare Brown_RPlastic = texture { pigment { color red 0.647059 green 0.164706 blue 0.164706 } finish { phong 1.0 reflection 0.4 } }
#declare DarkOliveGreen_RPlastic = texture { pigment { color red 0.309804 green 0.309804 blue 0.184314 } finish { phong 1.0 reflection 0.4 } }
#declare Firebrick_RPlastic = texture { pigment { color red 0.556863 green 0.137255 blue 0.137255 } finish { phong 1.0 reflection 0.4 } }
#declare LightBlue_RPlastic = texture { pigment { color red 0.74902 green 0.847059 blue 0.847059 } finish { phong 1.0 reflection 0.4 } }
#declare Maroon_RPlastic = texture { pigment { color red 0.556863 green 0.137255 blue 0.419608 } finish { phong 1.0 reflection 0.4 } }
#declare MediumAquamarine_RPlastic = texture { pigment { color red 0.196078 green 0.8 blue 0.6 } finish { phong 1.0 reflection 0.4 } }
#declare MidnightBlue_RPlastic = texture { pigment { color red 0.184314 green 0.184314 blue 0.309804 } finish { phong 1.0 reflection 0.4 } }
#declare Navy_RPlastic = texture { pigment { color red 0.137255 green 0.137255 blue 0.556863 } finish { phong 1.0 reflection 0.4 } }
#declare Orange_RPlastic = texture { pigment { color red 1 green 0.5 blue 0.0 } finish { phong 1.0 reflection 0.4 } }
#declare Orchid_RPlastic = texture { pigment { color red 0.858824 green 0.439216 blue 0.858824 } finish { phong 1.0 reflection 0.4 } }
#declare Pink_RPlastic = texture { pigment { color red 0.737255 green 0.560784 blue 0.560784 } finish { phong 1.0 reflection 0.4 } }
#declare Salmon_RPlastic = texture { pigment { color red 0.435294 green 0.258824 blue 0.258824 } finish { phong 1.0 reflection 0.4 } }
#declare Tan_RPlastic = texture { pigment { color red 0.858824 green 0.576471 blue 0.439216 } finish { phong 1.0 reflection 0.4 } }
#declare Turquoise_RPlastic = texture { pigment { color red 0.678431 green 0.917647 blue 0.917647 } finish { phong 1.0 reflection 0.4 } }
#declare Violet_RPlastic = texture { pigment { color red 0.309804 green 0.184314 blue 0.309804 } finish { phong 1.0 reflection 0.4 } }
#declare DarkBrown_RPlastic = texture { pigment { color red 0.36 green 0.25 blue 0.20 } finish { phong 1.0 reflection 0.4 } }

#declare Red_Dull = texture { pigment { color rgb <1,0,0> } finish { phong 0.2 } }
#declare White_Dull = texture { pigment { color rgb <1,1,1> } finish { phong 0.2 } }
#declare Green_Dull = texture { pigment { color rgb <0,1,0> } finish { phong 0.2 } }
#declare Blue_Dull = texture { pigment { color rgb <0,0,1> } finish { phong 0.2 } }
#declare Black_Dull = texture { pigment { color rgb <0,0,0> } finish { phong 0.2 } }
#declare Yellow_Dull = texture { pigment { color rgb <1,1,0> } finish { phong 0.2 } }
#declare Magenta_Dull = texture { pigment { color red 1.0 blue 1.0 } finish { phong 0.2 } }
#declare Aquamarine_Dull = texture { pigment { color red 0.439216 green 0.858824 blue 0.576471 } finish { phong 0.2 } }
#declare Brown_Dull = texture { pigment { color red 0.647059 green 0.164706 blue 0.164706 } finish { phong 0.2 } }
#declare DarkOliveGreen_Dull = texture { pigment { color red 0.309804 green 0.309804 blue 0.184314 } finish { phong 0.2 } }
#declare Firebrick_Dull = texture { pigment { color red 0.556863 green 0.137255 blue 0.137255 } finish { phong 0.2 } }
#declare LightBlue_Dull = texture { pigment { color red 0.74902 green 0.847059 blue 0.847059 } finish { phong 0.2 } }
#declare Maroon_Dull = texture { pigment { color red 0.556863 green 0.137255 blue 0.419608 } finish { phong 0.2 } }
#declare MediumAquamarine_Dull = texture { pigment { color red 0.196078 green 0.8 blue 0.6 } finish { phong 0.2 } }
#declare MidnightBlue_Dull = texture { pigment { color red 0.184314 green 0.184314 blue 0.309804 } finish { phong 0.2 } }
#declare Navy_Dull = texture { pigment { color red 0.137255 green 0.137255 blue 0.556863 } finish { phong 0.2 } }
#declare Orange_Dull = texture { pigment { color red 1 green 0.5 blue 0.0 } finish { phong 0.2 } }
#declare Orchid_Dull = texture { pigment { color red 0.858824 green 0.439216 blue 0.858824 } finish { phong 0.2 } }
#declare Pink_Dull = texture { pigment { color red 0.737255 green 0.560784 blue 0.560784 } finish { phong 0.2 } }
#declare Salmon_Dull = texture { pigment { color red 0.435294 green 0.258824 blue 0.258824 } finish { phong 0.2 } }
#declare Tan_Dull = texture { pigment { color red 0.858824 green 0.576471 blue 0.439216 } finish { phong 0.2 } }
#declare Turquoise_Dull = texture { pigment { color red 0.678431 green 0.917647 blue 0.917647 } finish { phong 0.2 } }
#declare Violet_Dull = texture { pigment { color red 0.309804 green 0.184314 blue 0.309804 } finish { phong 0.2 } }
#declare DarkBrown_Dull = texture { pigment { color red 0.36 green 0.25 blue 0.20 } finish { phong 0.2 } }

#version 1.0

#declare Maroon_White_Agate_1 = texture {
  agate
  phong 0.3
}

#declare Grey_Blue_Alabaster = texture {
  bozo
  turbulence 1.2
  color_map {
    [0   0.2   color red 1   green 1   blue 1
               color red 0.9 green 0.9 blue 1]
    [0.2 0.4   color red 0.9 green 0.9 blue 1
               color red 0.8 green 0.8 blue 0.9]
    [0.4 0.6   color red 0.8 green 0.8 blue 0.9
               color red 0.7 green 0.7 blue 0.8]
    [0.6 0.8   color red 0.7 green 0.7 blue 0.8
               color red 0.65 green 0.65 blue 0.7]
    [0.8 1.001 color red 0.65 green 0.65 blue 0.7
               color red 0.7 green 0.7 blue 0.8]
  }
  phong 1.0
  ambient 0.4
}

#declare Anticyclone = texture {
  granite
  turbulence 0.7
  color_map {
    [0   0.22   color red 0.5945 green 0.2855 blue 0.3515
                color red 0.5945 green 0.2855 blue 0.3515]
    [0.22 0.72  color red 0.3285 green 0.8692 blue 0.8863
                color red 0.3917 green 0.0324 blue 0.2404]
    [0.72 1.001 color red 0.9442 green 0.8700 blue 0.7092
                color red 0.4873 green 0.4105 blue 0.2861]
   }
  phong 1.0
  ambient 0.4
  rotate <128 329 120>
  scale  <3.6 3.6 1.9>
}

#declare Azurite = texture {
  agate
   color_map {
      [0.0 0.3 color red 0.0 green 0.0 blue 0.9
               color red 0.0 green 0.0 blue 0.8 ]
      [0.3 1.0 color red 0.0 green 0.0 blue 0.8
               color red 0.0 green 0.0 blue 0.4 ]
   }
  phong 1.0
}

#declare Wood_0 = texture {
  wood
  turbulence 0.2
  color_map {
    [0.0 0.5 color red 0.866 green 0.512 blue 0.4
             color red 0.866 green 0.512 blue 0.4 ]
    [0.5 1.0 color red 0.4 green 0.133 blue 0.066
             color red 0.2 green 0.065 blue 0.033 ]
  }
  scale <0.05 1 0.05>
  rotate <10 -45 0>
  phong 0.2
  ambient 0.4
}

#declare Wood_2 = texture {
  wood
  turbulence 0.2
  color_map {
    [0.0 0.8 color red 1.0 green 0.71875 blue 0.25
             color red 1.0 green 0.71875 blue 0.25]
    [0.8 1   color red 0.5 green 0.5 blue 0.066
             color red 0.4 green 0.4 blue 0.033]
  }
 scale <0.1 100 0.1>
 rotate <10 -45 0>
}

#declare Wood_3 = texture {
  wood
  turbulence 0.2
  color_map {
    [0.0 0.8 color red  0.42857 green 0.23810 blue 0.04762
             color red  0.42857 green 0.23810 blue 0.04762]
    [0.8 1.0 color red  0.40000 green 0.33301 blue 0.06601
             color red  0.20000 green 0.03310 blue 0.03303]
  }
  ambient 0.4
  scale <0.4 5 0.3>
  roughness 1.0
  rotate <8 45 33>
  phong 0.1
}

#declare Wood_4 = texture {
   wood
   turbulence 0.04
   octaves 3
   color_map {
      [0.00 0.10 color red 0.60 green 0.30 blue 0.18
      color red 0.60 green 0.30 blue 0.18 ]
      [0.10 0.90 color red 0.60 green 0.30 blue 0.18
      color red 0.30 green 0.15 blue 0.09 ]
      [0.90 1 color red 0.30 green 0.15 blue 0.09
      color red 0.30 green 0.15 blue 0.09  ]
   }
   scale <0.2 0.2 1>
}

#declare Wood_5 = texture {
   wood
   turbulence 0.02
   color_map {
      [0.000 0.222 color red  0.808  green  0.671  blue  0.251
                   color red  0.808  green  0.671  blue  0.251]
      [0.222 0.342 color red  0.808  green  0.671  blue  0.251
                   color red  0.600  green  0.349  blue  0.043]
      [0.342 0.393 color red  0.600  green  0.349  blue  0.043
                   color red  0.808  green  0.671  blue  0.251]
      [0.393 0.709 color red  0.808  green  0.671  blue  0.251
                   color red  0.808  green  0.671  blue  0.251]
      [0.709 0.821 color red  0.808  green  0.671  blue  0.251
                   color red  0.533  green  0.298  blue  0.027]
      [0.821 1     color red  0.533  green  0.298  blue  0.027
                   color red  0.808  green  0.671  blue  0.251]
   }
   scale <0.1 10 0.1>
   translate <10 0 0>
}

#declare Wood_6 = texture {
   bozo
   turbulence 0.2
   color_map {
      [0.000 0.171 color red 0.725 green 0.659 blue 0.455
                   color red 0.682 green 0.549 blue 0.420 ]
      [0.171 0.274 color red 0.682 green 0.549 blue 0.420
                   color red 0.557 green 0.451 blue 0.322 ]
      [0.274 0.393 color red 0.557 green 0.451 blue 0.322
                   color red 0.725 green 0.659 blue 0.455 ]
      [0.393 0.564 color red 0.725 green 0.659 blue 0.455
                   color red 0.682 green 0.549 blue 0.420 ]
      [0.564 0.701 color red 0.682 green 0.549 blue 0.420
                   color red 0.482 green 0.392 blue 0.278 ]
      [0.701 1.000 color red 0.482 green 0.392 blue 0.278
                   color red 0.725 green 0.659 blue 0.455 ]
   }
   scale <0.2 0.2 1>
   scale <0.2 0.2 0.2>
}

#declare Wood_7 = texture {
  wood
  turbulence 0.3
  color_map {
    [0.0 0.8 color red 0.666 green 0.312 blue 0.2
             color red 0.666 green 0.312 blue 0.2]
    [0.8 1.0 color red 0.4 green 0.133 blue 0.066
             color red 0.2 green 0.065 blue 0.033]
   }
  scale <5.0 0.3 0.3>
  phong 1.0
  ambient 0.4
}

#declare Wood_8 = texture {
   wood
   color_map {
     [0.0 0.8  color red 0.789 green 0.512 blue 0.200
               color red 0.789 green 0.512 blue 0.200 ]
     [0.8 1.0  color red 0.400 green 0.133 blue 0.066
               color red 0.200 green 0.065 blue 0.033 ]
   }
   turbulence 0.6
   scale <0.2 1.2 0.2>
   wood
   phong 0.52
   phong_size 90
   ambient 0.4
   turbulence 0.2
   scale <1.0 1.4 1.3>
   rotate <95 121 341>
}

#declare Wood_9 = texture {
  wood
  color_map {
    [0.0 0.8  color red 0.789 green 0.512 blue 0.200
              color red 0.789 green 0.512 blue 0.200 ]
    [0.8 1.01 color red 0.400 green 0.133 blue 0.066
              color red 0.200 green 0.065 blue 0.033 ]
  }
  turbulence 0.6
  scale <0.2 1.2 0.2>
  gradient <1.0 3.6 3.9>
  phong 0.76
  phong_size 63
  ambient 0.4
  turbulence 0.9
  scale <3.6 3.9 1.0>
  rotate <346 271 150>
}

#declare Wood_10 = texture {
  wood
  turbulence 0.04
  octaves 3
  scale <0.05 .05 1>
  color_map {
     [0.00 0.10 color red 0.888 green 0.600 blue 0.300
                color red 0.888 green 0.600 blue 0.300 ]
     [0.10 0.90 color red 0.888 green 0.600 blue 0.300
                color red 0.600 green 0.400 blue 0.200 ]
     [0.90 1.00 color red 0.600 green 0.400 blue 0.200
                color red 0.600 green 0.400 blue 0.200 ]
  }
}

#declare Wood_11 = texture {
  color_map {
    [0.0 0.8  color red 0.888 green 0.600 blue 0.3
              color red 0.888 green 0.600 blue 0.3 ]
    [0.8 1.01 color red 0.6   green 0.4   blue 0.2
              color red 0.4   green 0.3   blue 0.2 ]
  }
  gradient <0.4 0.8 0.6>
  refraction 0.3
  phong 0.84
  phong_size 72
  ambient 0.4
  turbulence 0.5
  scale <0.8 0.6 0.4>
  rotate <315 124 175>
}

#declare Island_Wood = texture {
  bozo
  color_map {
     [0.00 0.05 color red 0.647059 green 0.164706 blue 0.164706
                color red 0.647059 green 0.164706 blue 0.164706 ]
     [0.05 0.25 color red 0.647059 green 0.164706 blue 0.164706
                color red 0.858824 green 0.576471 blue 0.439216 ]
     [0.25 0.75 color red 0.858824 green 0.576471 blue 0.439216
                color red 0.858824 green 0.576471 blue 0.439216 ]
     [0.75 0.95 color red 0.858824 green 0.576471 blue 0.439216
                color red 0.647059 green 0.164706 blue 0.164706 ]
     [0.95 1.01 color red 0.647059 green 0.164706 blue 0.164706
                color red 0.647059 green 0.164706 blue 0.164706 ]
  }
  scale <0.01 0.01 1>
  rotate <0 90 0>
  ambient 0.15
  diffuse 0.7
  specular 1
  roughness 0.005
  phong 1
  phong_size 100
}
texture {
  wood
  turbulence 0.05
  color_map {
     [0.00 0.05 color red 1.0 green 1.0 blue 1.0 alpha 1.0
                color red 1.0 green 1.0 blue 1.0 alpha 1.0]
     [0.05 0.30 color red 1.0 green 1.0 blue 1.0 alpha 1.0
                color red 0.36 green 0.25 blue 0.20 ]
     [0.30 0.70 color red 0.36 green 0.25 blue 0.20
                color red 0.36 green 0.25 blue 0.20 ]
     [0.70 0.95 color red 0.36 green 0.25 blue 0.20
                color red 1.0 green 1.0 blue 1.0 alpha 1.0]
     [0.95 1.01 color red 1.0 green 1.0 blue 1.0 alpha 1.0
                color red 1.0 green 1.0 blue 1.0 alpha 1.0]
  }
  scale <0.1 0.1 1>
  translate <0 -0.5 0>
  scale <1 1 1>
  rotate <14 90 34>
  ambient 0.15
  diffuse 0.7
}

#declare Ebony_Wood = texture {
  agate
  color_map {
    [0.0 0.5   color red 0.21 green 0.1  blue 0.1
               color red 0.25 green 0.25 blue 0.01]
    [0.5 0.6   color red 0.25 green 0.25 blue 0.01
               color red 0.3  green 0.1  blue 0.1]
    [0.6 1.001 color red 0.15 green 0.1  blue 0.1
               color red 0.15 green 0.1  blue 0.1]
  }
  ambient 0.6
  phong 1.0
}

#declare Henna_Wood = texture {
  turbulence 0.2
  wood
  phong 0.3
  ambient 0.4
  scale <0.4 14 0.4>
  rotate <0 45 0>
}

#declare Cork_Wood_1 = texture {
  granite
  color_map {
     [0.0 0.6  color red 0.93 green 0.71 blue 0.532
               color red 0.98 green 0.81 blue 0.60]
     [0.6 0.65 color red 0.50 green 0.30 blue 0.20
               color red 0.50 green 0.30 blue 0.20]
     [0.65 1.0 color red 0.80 green 0.53 blue 0.46
               color red 0.85 green 0.75 blue 0.35]
  }
  scale <0.25 0.25 0.25>
  specular 0.1
  roughness 0.5
}

#declare Cork_Wood_2 = texture {
   granite
   color_map {
      [0.00 0.60 color red 0.93 green 0.71 blue 0.53
                 color red 0.98 green 0.81 blue 0.60 ]
      [0.60 0.65 color red 0.50 green 0.30 blue 0.20
                 color red 0.50 green 0.30 blue 0.20 ]
      [0.65 1.00 color red 0.80 green 0.53 blue 0.46
                 color red 0.85 green 0.75 blue 0.35 ]
   }
   scale <0.25 1.00 0.25>
   specular 0.1
   roughness 0.5
}

#declare High_Sky = texture {
  bozo
  turbulence 0.5
  color_map {
      [0.0 0.5   color red 0.5 green 0.5 blue 1.0
                 color red 0.5 green 0.5 blue 1.0]
      [0.5 0.6   color red 0.5 green 0.5 blue 1.0
                 color red 1.0 green 1.0 blue 1.0]
      [0.6 1.001 color red 1.0 green 1.0 blue 1.0
                 color red 0.5 green 0.5 blue 0.5]
  }
  phong 1.0
  scale <0.5 0.5 0.5>
}

#declare Midnight_Sky = texture {
   bozo
   turbulence 0.3
   color_map {
      [0.00 0.50 color red 0.25 green 0.25 blue 0.50
                 color red 0.25 green 0.25 blue 0.50 ]
      [0.50 0.60 color red 0.25 green 0.25 blue 0.50
                 color red 0.70 green 0.70 blue 0.70 ]
      [0.60 1.00 color red 0.70 green 0.70 blue 0.70
                 color red 0.30 green 0.30 blue 0.30 ]
   }
   ambient 0.4
}

#declare Bright_Sky_2 = texture {
   bozo
   turbulence 0.56
   color_map {
      [0.0 0.5 color red 0.5 green 0.5 blue 1.0
               color red 0.5 green 0.5 blue 1.0 ]
      [0.5 0.6 color red 0.5 green 0.5 blue 1.0
               color red 1.0 green 1.0 blue 1.0 ]
      [0.6 1.0 color red 1.0 green 1.0 blue 1.0
               color red 0.5 green 0.5 blue 0.5 ]
   }
   ambient 0.4
}

#declare Red_Blue_Checker = texture {
  checker
  color red 1.0
  color blue 1.0
  phong 1.0
}

#declare White_Black_Checker = texture {
  checker
  color red 0 green 0 blue 0
  color blue 1 red 1 green 1
  phong 1.0
}

#declare White_Blue_Checker = texture {
  pigment {
    checker
    color red 0.8 green 0.8 blue 1
    color blue 1 red 1 green 1
  }
  finish {
   phong 1.0
   reflection 0.3
  }
}

#declare Dendrite = texture {
  granite
  turbulence 0.0
  color_map {
    [0.00 0.07 color red 1.000000 green 1.000000 blue 1.000000
               color red 1.000000 green 1.000000 blue 1.000000 ]
    [0.07 0.20 color red 1.000000 green 1.000000 blue 1.000000
               color red 0.329412 green 0.329412 blue 0.329412 ]
    [0.20 0.30 color red 0.329412 green 0.329412 blue 0.329412
               color red 1.000000 green 1.000000 blue 1.000000 alpha 1.0 ]
    [0.30 0.70 color red 1.000000 green 1.000000 blue 1.000000 alpha 1.0
               color red 1.000000 green 1.000000 blue 1.000000 alpha 1.0 ]
    [0.70 1.00 color red 1.000000 green 1.000000 blue 1.000000 alpha 1.0
               color red 0.329412 green 0.329412 blue 0.329412 ]
  }
  phong 0.867
}

#declare Funny_Pattern = texture {
  wood
  color_map {
    [0   0.23   color red 0.3017 green 0.2697 blue 0.3231
                color red 0.3017 green 0.2697 blue 0.3231 ]
    [0.23 0.88  color red 0.9167 green 0.4900 blue 0.0287
                color red 0.1358 green 0.4347 blue 0.9851 ]
    [0.88 0.00  color red 0.1404 green 0.6290 blue 0.6517
                color red 0.8902 green 0.4708 blue 0.3765 ]
    [0.00 1.001 color red 0.8902 green 0.4708 blue 0.3765
                color red 0.4432 green 0.8593 blue 0.0434 ]
  }
  phong 0.45
  phong_size 72
  ambient 0.4
  turbulence 0.6
  scale <0.4 0.9 0.4>
  rotate < 35 355 137>
}

#declare Pink_Flock = texture {
  leopard
  color_map {
     [0.0 0.3  color red 1.00 green 1.00 blue 1.000 alpha 1.0
               color red 1.00 green 1.00 blue 1.000 alpha 1.0 ]
     [0.3  1.0 color red 0.80 green 0.53 blue 0.846
               color red 0.85 green 0.75 blue 0.835 ]
  }
  scale <0.05 0.05 0.05>
  rotate <0 30 0>
  ambient 0.8
}

#declare Salmon_Cock = texture {
  granite
  color_map {
     [0.0 0.9 color red 1.00 green 1.00 blue 1.0 alpha 1.0
              color red 0.80 green 0.53 blue 0.46 ]
     [0.9 1.0 color red 0.85 green 0.75 blue 0.35
              color red 1.00 green 1.00 blue 1.0 alpha 1.0 ]
  }
  scale <0.5 0.5 0.5>
  rotate <0 30 0>
  ambient 0.8
}

#declare Granit_DO = texture {
  dents 0.8
  granite
  phong 1.0
}

#declare Red_Gray_Granit = texture {
  granite
  refraction 0.2
  ior 1.1
  color_map {
    [0   0.09   color red 0.2168 green 0.6793 blue 0.4631 alpha 0
                color red 0.2058 green 0.7014 blue 0.2960 alpha 0 ]
    [0.09 0.16  color red 0.2058 green 0.7014 blue 0.2960 alpha 0
                color red 0.6494 green 0.1976 blue 0.2262 alpha 0 ]
    [0.16 0.23  color red 0.6494 green 0.1976 blue 0.2262 alpha 0
                color red 0.7978 green 0.1631 blue 0.2152 alpha 0 ]
    [0.23 0.43  color red 0.7978 green 0.1631 blue 0.2152 alpha 0
                color red 0.6321 green 0.4497 blue 0.6554 alpha 0 ]
    [0.43 0.68  color red 0.6321 green 0.4497 blue 0.6554 alpha 0
                color red 0.7079 green 0.6002 blue 0.6073 alpha 0 ]
    [0.68 1.00  color red 0.7079 green 0.6002 blue 0.6073 alpha 0
                color red 0.0770 green 0.2991 blue 0.7439 alpha 0 ]
  }
  phong 0.68
  phong_size 63
  ambient 0.4
  turbulence 0.7
  scale <0.29 0.31 0.61>
  rotate <209 157 283>
}

#declare Pink_Granit = texture {
  granite
  color_map {
     [0.000 0.241 color red 0.973 green 0.973 blue 0.976 alpha 0.0
                  color red 0.973 green 0.973 blue 0.976 alpha 0.0 ]
     [0.241 0.284 color red 0.973 green 0.973 blue 0.976 alpha 0.0
                  color red 0.600 green 0.741 blue 0.608 alpha 0.0 ]
     [0.284 0.336 color red 0.600 green 0.741 blue 0.608 alpha 0.0
                  color red 0.820 green 0.643 blue 0.537 alpha 0.0 ]
     [0.336 0.474 color red 0.820 green 0.643 blue 0.537 alpha 0.0
                  color red 0.886 green 0.780 blue 0.714 alpha 0.0 ]
     [0.474 0.810 color red 0.886 green 0.780 blue 0.714 alpha 0.0
                  color red 0.996 green 0.643 blue 0.537 alpha 0.0 ]
     [0.810 0.836 color red 0.996 green 0.643 blue 0.537 alpha 0.0
                  color red 0.973 green 0.973 blue 0.976 alpha 0.0 ]
     [0.836 1.001 color red 0.973 green 0.973 blue 0.976 alpha 0.0
                  color red 0.973 green 0.973 blue 0.976 alpha 0.0 ]
  }
  phong 0.789
}

#declare Gray_Vein_Granit = texture {
  granite
  turbulence 0.0
  color_map {
     [0.0 0.3 color red 1.000000 green 1.000000 blue 1.000000
              color red 0.329412 green 0.329412 blue 0.329412 ]
     [0.2 0.4 color red 0.329412 green 0.329412 blue 0.329412
              color red 0.329412 green 0.329412 blue 0.329412 ]
     [0.4 0.6 color red 0.329412 green 0.329412 blue 0.329412
              color red 0.329412 green 0.329412 blue 0.329412 ]
     [0.6 1.0 color red 0.329412 green 0.329412 blue 0.329412
              color red 0.329412 green 0.329412 blue 0.329412 ]
  }
  phong 0.7
}

#declare Black_Vein_Granit = texture {
  granite
  turbulence 0.0
  color_map {
     [0.0 0.3 color red 0.0 green 0.0 blue 0.0
              color red 1.0 green 1.0 blue 1.0 ]
     [0.2 0.4 color red 1.0 green 1.0 blue 1.0
              color red 1.0 green 1.0 blue 1.0 ]
     [0.4 0.6 color red 1.0 green 1.0 blue 1.0
              color red 1.0 green 1.0 blue 1.0 ]
     [0.6 1.0 color red 1.0 green 1.0 blue 1.0
              color red 1.0 green 1.0 blue 1.0 ]
  }
  phong 0.77
}

#declare Purple_Granit = texture {
  bozo
  color_map {
    [0.00 0.09 color red 0.2172 green 0.1237 blue 0.7066 alpha 0.56
               color red 0.6871 green 0.4201 blue 0.0434 alpha 0.92 ]
    [0.09 0.15 color red 0.6871 green 0.4201 blue 0.0434 alpha 0.92
               color red 0.3897 green 0.3777 blue 0.0352 alpha 0.59 ]
    [0.15 0.22 color red 0.3897 green 0.3777 blue 0.0352 alpha 0.59
               color red 0.0973 green 0.7580 blue 0.9859 alpha 0.56 ]
    [0.22 0.31 color red 0.0973 green 0.7580 blue 0.9859 alpha 0.56
               color red 0.0145 green 0.9400 blue 0.2154 alpha 0.60 ]
    [0.31 0.33 color red 0.0145 green 0.9400 blue 0.2154 alpha 0.60
               color red 0.7688 green 0.1050 blue 0.5760 alpha 0.07 ]
    [0.33 1.00 color red 0.7688 green 0.1050 blue 0.5760 alpha 0.07
               color red 0.9939 green 0.7191 blue 0.8677 alpha 0.39 ]
  }
  phong 0.90
  phong_size 72
  turbulence 0.9
  scale <0.08 0.13 0.34>
}

#declare Grass = texture {
  granite
  color_map {
    [0.00 0.07 color red 0.7743 green 0.3353 blue 0.5701 alpha 0.98
               color red 0.5210 green 0.1044 blue 0.0333 alpha 0.45 ]
    [0.07 0.13 color red 0.5210 green 0.1044 blue 0.0333 alpha 0.45
               color red 0.3663 green 0.5682 blue 0.0687 alpha 0.82 ]
    [0.13 0.31 color red 0.3663 green 0.5682 blue 0.0687 alpha 0.82
               color red 0.0887 green 0.9886 blue 0.4438 alpha 0.01 ]
    [0.31 0.39 color red 0.0887 green 0.9886 blue 0.4438 alpha 0.01
               color red 0.1308 green 0.9083 blue 0.5524 alpha 0.74 ]
    [0.39 0.55 color red 0.1308 green 0.9083 blue 0.5524 alpha 0.74
               color red 0.4840 green 0.3945 blue 0.7343 alpha 0.69 ]
    [0.55 1.00 color red 0.4840 green 0.3945 blue 0.7343 alpha 0.69
               color red 0.1755 green 0.5095 blue 0.4480 alpha 0.43 ]
  }
  phong 0.66
  phong_size 81
  turbulence 0.7
  scale <0.98 0.87 0.81>
}

#declare Hollywood = texture {
  onion
  ripples 1.0
  turbulence 0.6
  color_map {
    [0   0.29   color red 0.9136 green 0.8418 blue 0.8764
                color red 0.9136 green 0.8418 blue 0.8764]
    [0.29 0.93  color red 0.4478 green 0.7337 blue 0.4993
                color red 0.2489 green 0.3407 blue 0.2393]
    [0.93 1.001 color red 0.4917 green 0.9572 blue 0.0833
                color red 0.0667 green 0.4001 blue 0.3527]
  }
  phong 1.0
  ambient 0.4
  rotate <340  72 287>
  scale  <0.1 0.9 4.0>
}

#declare Inferno_1 = texture {
  wood
  wrinkles 0.2
  color_map {
    [0   0.58   color red 0.3501 green 0.4402 blue 0.0798
                color red 0.3501 green 0.4402 blue 0.0798 ]
    [0.58 0.44  color red 0.3623 green 0.1044 blue 0.5842
                color red 0.9410 green 0.9179 blue 0.3361 ]
    [0.44 0.00  color red 0.5917 green 0.8572 blue 0.5896
                color red 0.7324 green 0.2038 blue 0.2956 ]
    [0.00 1.001 color red 0.7324 green 0.2038 blue 0.2956
                color red 0.6273 green 0.9007 blue 0.1178 ]
  }
  phong 0.33
  phong_size 90
  ambient 0.4
  turbulence 0.3
  scale <0.5 0.4 0.7>
  rotate <3 340 91>
}

#declare Inferno_2 = texture {
  wood
  wrinkles 0.2
  metallic 0.0
  color_map {
    [0.00 0.06 color red 0.2259 green 0.2300 blue 0.2794 alpha 0.53
               color red 0.6536 green 0.8927 blue 0.1314 alpha 0.49 ]
    [0.06 0.14 color red 0.6536 green 0.8927 blue 0.1314 alpha 0.49
               color red 0.6191 green 0.0502 blue 0.1610 alpha 0.09 ]
    [0.14 0.27 color red 0.6191 green 0.0502 blue 0.1610 alpha 0.09
               color red 0.3962 green 0.9469 blue 0.1328 alpha 0.71 ]
    [0.27 0.28 color red 0.3962 green 0.9469 blue 0.1328 alpha 0.71
               color red 0.3543 green 0.6589 blue 0.2293 alpha 0.98 ]
    [0.28 0.85 color red 0.3543 green 0.6589 blue 0.2293 alpha 0.98
               color red 0.3748 green 0.0369 blue 0.7473 alpha 0.69 ]
    [0.85 1.00 color red 0.3748 green 0.0369 blue 0.7473 alpha 0.69
               color red 0.2141 green 0.6359 blue 0.9982 alpha 0.45 ]
  }
  phong 0.63
  phong_size 90
  ambient 0.4
  turbulence 0.2
  scale <0.99 0.96 0.39>
  rotate <349 208 121>
}

#declare Jade_1 = texture {
  marble
  turbulence 1.8
  color_map {
    [0.0 0.8 color red 0.1 green 0.6 blue 0.1
             color red 0.0 green 0.3 blue 0.0]
    [0.8 1.0 color red 0.1 green 0.6 blue 0.1
             color red 0.0 green 0.2 blue 0.0]
  }
}

#declare Jade_2 = texture {
  marble
  turbulence 2.3
  color_map {
    [0.0 0.8 color red 0 green 0 blue 0
             color red 0.0 green 0.6 blue 0.6]
    [0.8 0.9 color red 0.0 green 0.6 blue 0.6
             color red 0.6 green 0.0 blue 0.0]
    [0.9 1   color red 0.6 green 0.0 blue 0.0
             color red 0 green 0 blue 0]
  }
  ambient 0.4
}

#declare Leopard = texture {
  leopard
  bumps 0.1
  color_map {
    [0   0.07   color red 0.8944 green 0.8251 blue 0.1203 alpha .31
                color red 0.8944 green 0.8251 blue 0.1203 alpha .31 ]
    [0.07 0.19  color red 0.6406 green 0.1485 blue 0.1700 alpha .02
                color red 0.6406 green 0.1485 blue 0.1700 alpha .02 ]
    [0.19 0.37  color red 0.3889 green 0.0074 blue 0.3002 alpha .9
                color red 0.3889 green 0.0074 blue 0.3002 alpha .9 ]
    [0.37 0.57  color red 0.2357 green 0.2495 blue 0.1793 alpha .62
                color red 0.2357 green 0.2495 blue 0.1793 alpha .62 ]
    [0.57 0.84  color red 0.3302 green 0.1342 blue 0.0686 alpha .89
                color red 0.3302 green 0.1342 blue 0.0686 alpha .89 ]
    [0.84 1.00  color red 0.0260 green 0.8683 blue 0.9984 alpha .93
                color red 0.0260 green 0.8683 blue 0.9984 alpha .93 ]
  }
  phong 0.57
  phong_size 90
  ambient 0.4
  turbulence 0.4
  scale <0.06 0.09 0.06>
  rotate <318 279 203>
}

#declare Pink_Grey_Floor = texture {
  ambient 0.25
  bozo
  turbulence 0.25
  color_map {
     [0.0 1.0 color red 0.90 green 0.75 blue 0.75
              color red 0.60 green 0.60 blue 0.60 ]
  }
  scale <0.1 0.1 0.1>
  phong 0.9
  phong_size 85
}

#declare May_68 = texture {
  marble
  bumps 1.0
  color_map {
    [0   0.17   color red 0.2170 green 0.4924 blue 0.8205
                color red 0.2170 green 0.4924 blue 0.8205]
    [0.17 0.79  color red 0.4739 green 0.8551 blue 0.0012
                color red 0.0304 green 0.1953 blue 0.6764]
    [0.79 0.00  color red 0.4252 green 0.7422 blue 0.5126
                color red 0.9843 green 0.0119 blue 0.2422]
    [0.00 1.001 color red 0.9843 green 0.0119 blue 0.2422
                color red 0.5564 green 0.8157 blue 0.1293]
  }
  phong 1.0
  ambient 0.4
  turbulence 0.2
  scale <0.7 3.5 3.6>
  rotate < 93 206 312>
}

#declare White_Vein_Black_Marble = texture {
  marble
  turbulence 0.9
  color_map {
    [0   0.8   color red 1.0 green 1.0 blue 1.0
               color red 0.6 green 0.6 blue 0.6]
    [0.8 1.001 color red 0.6 green 0.6 blue 0.6
               color red 0.1 green 0.1 blue 0.1]
  }
  phong 1.0
  ambient 0.4
  scale  <1 1 1>
}

#declare Grey_Vein_Black_Marble = texture {
  marble
  turbulence 1.0
  color_map {
    [0.0 0.8 color red 0.9 green 0.9 blue 0.9
             color red 0.5 green 0.5 blue 0.5]
    [0.8 1.0 color red 0.5 green 0.5 blue 0.5
             color red 0.2 green 0.2 blue 0.2]
  }
}

#declare Red_Marble_2 = texture {
  marble
  turbulence 1.0
  color_map {
    [0.0 0.8 color red 0.8 green 0.8 blue 0.6
             color red 0.8 green 0.4 blue 0.4]
    [0.8 1.0 color red 0.8 green 0.4 blue 0.4
             color red 0.8 green 0.2 blue 0.2]
  }
  scale <0.2 0.2 0.2>
}

#declare Dark_Red_Marble = texture {
  marble
  turbulence 1.0
  color_map {
     [0.0 0.8 color red 0.8 green 0.8 blue 0.6
              color red 0.8 green 0.4 blue 0.4 ]
     [0.8 1.0 color red 0.8 green 0.4 blue 0.4
              color red 0.8 green 0.2 blue 0.2 ]
  }
  phong 1.0
  phong_size 85
}

#declare Chrome_Metal_2 = texture {
  color red 0 green 0 blue 0
  ambient 0.3
  diffuse 0.0
  reflection 1.0
  brilliance 20.0
  specular 1.0
  roughness 0.001
  phong 1.0
  phong_size 90
}

#declare Black_Galaxy = texture {
  granite
  wrinkles 0.0
  turbulence 0.7
  color_map {
    [0   0.29   color red 0.0240 green 0.1189 blue 0.1877
                color red 0.0240 green 0.1189 blue 0.1877]
    [0.29 0.30  color red 0.1991 green 0.4928 blue 0.4967
                color red 0.5606 green 0.4679 blue 0.0630]
    [0.30 1.001 color red 0.1194 green 0.0568 blue 0.0426
                color red 0.5284 green 0.7513 blue 0.1368]
  }
  phong 1.0
  ambient 0.4
  rotate < 52 293 142>
  scale <1.6 1.8 1.2>
}

#declare Easter_Egg = texture {
  granite
  refraction 1.0
  turbulence 0.6
  color_map {
    [0   0.51   color red 0.4026 green 0.9165 blue 0.7932
                color red 0.4026 green 0.9165 blue 0.7932]
    [0.51 0.17  color red 0.0099 green 0.1125 blue 0.6465
                color red 0.3074 green 0.1857 blue 0.9227]
    [0.17 1.001 color red 0.0880 green 0.2992 blue 0.6395
                color red 0.6386 green 0.2604 blue 0.5928]
   }
  phong 1.0
  ambient 0.4
  rotate <207 222  48>
  scale  <0.7 1.0 1.0>
}

#declare Pacific = texture {
  granite
  color_map {
    [0   0.12   color red 0.6602 green 0.8021 blue 0.8680
                color red 0.6602 green 0.8021 blue 0.8680]
    [0.12 0.74  color red 0.6211 green 0.5580 blue 0.7332
                color red 0.1284 green 0.1723 blue 0.9133]
    [0.74 0.00  color red 0.2577 green 0.3911 blue 0.1019
                color red 0.5084 green 0.3372 blue 0.8250]
    [0.00 1.001 color red 0.5084 green 0.3372 blue 0.8250
                color red 0.2430 green 0.1515 blue 0.2866]
  }
  phong 0.63
  phong_size 81
  ambient 0.4
  turbulence 0.4
  scale <0.7 0.2 0.8>
  rotate <1 78 236>
}

#declare Copper_Shavings = texture {
  agate
  color_map {
     [0.0 0.5  color red 1.00 green 1.00 blue 1.00 alpha 1.0
               color red 1.00 green 1.00 blue 1.00 alpha 1.0 ]
     [0.5  1.0 color red 0.80 green 0.53 blue 0.46
               color red 0.85 green 0.75 blue 0.35 ]
  }
  scale <0.02 200 0.02>
  rotate <0 30 0>
  specular 1.0
}

#declare Iron_Shavings = texture {
  marble
  color_map {
     [0.0 0.5 color red 1.0 green 1.0 blue 1.0 alpha 1.0
              color red 1.0 green 1.0 blue 1.0 alpha 1.0 ]
     [0.5 1.0 color red 1.0 green 1.0 blue 1.0
              color red 1.0 green 1.0 blue 1.0 ]
  }
  scale <0.02 200 0.02>
  rotate <0 30 0>
  specular 1.0
}

#declare Paint_Cream = texture {
  wood
  ripples 1.0
  color_map {
    [0   0.87   color red 0.6234 green 0.8872 blue 0.7855
                color red 0.6234 green 0.8872 blue 0.7855]
    [0.87 0.74  color red 0.1126 green 0.2688 blue 0.4823
                color red 0.1270 green 0.0232 blue 0.2029]
    [0.74 0.00  color red 0.7802 green 0.4708 blue 0.9490
                color red 0.8964 green 0.5643 blue 0.4392]
    [0.00 1.001 color red 0.8964 green 0.5643 blue 0.4392
                color red 0.6899 green 0.9496 blue 0.1711]
  }
  phong 1.0
  ambient 0.4
  turbulence 1.0
  scale <4.1 0.1 2.4>
  rotate <328 127 140>
}

#declare Particles_1 = texture {
  bozo
  turbulence 0.8
  color_map {
     [0.000 0.087 color red 0.682 green 0.604 blue 0.380 alpha 1.000
                  color red 0.761 green 0.694 blue 0.600 alpha 0.020 ]
     [0.087 0.226 color red 0.761 green 0.694 blue 0.600 alpha 0.020
                  color red 0.635 green 0.553 blue 0.325 alpha 1.000 ]
     [0.226 0.348 color red 0.635 green 0.553 blue 0.325 alpha 1.000
                  color red 0.761 green 0.694 blue 0.600 alpha 0.020 ]
     [0.348 0.496 color red 0.761 green 0.694 blue 0.600 alpha 0.020
                  color red 0.682 green 0.604 blue 0.380 alpha 1.000 ]
     [0.496 0.565 color red 0.682 green 0.604 blue 0.380 alpha 1.000
                  color red 0.761 green 0.694 blue 0.600 alpha 0.020 ]
     [0.565 0.661 color red 0.761 green 0.694 blue 0.600 alpha 0.020
                  color red 0.682 green 0.604 blue 0.380 alpha 1.000 ]
     [0.661 0.835 color red 0.682 green 0.604 blue 0.380 alpha 1.000
                  color red 0.761 green 0.694 blue 0.600 alpha 0.020 ]
     [0.835 1.000 color red 0.761 green 0.694 blue 0.600 alpha 0.020
                  color red 0.682 green 0.604 blue 0.380 alpha 1.000 ]
  }
  scale <0.2 0.2 2.0>
  scale <1 1 1>
}

#declare Particles_2 = texture {
  agate
  waves 0.9
  roughness 0.3
  color_map {
    [0.00 0.09 color red 0.6514 green 0.4223 blue 0.8026 alpha 0.39
               color red 0.6514 green 0.4223 blue 0.8026 alpha 0.39 ]
    [0.09 0.13 color red 0.5378 green 0.4306 blue 0.9972 alpha 0.05
               color red 0.5378 green 0.4306 blue 0.9972 alpha 0.05 ]
    [0.13 0.28 color red 0.3555 green 0.2631 blue 0.1179 alpha 0.86
               color red 0.3555 green 0.2631 blue 0.1179 alpha 0.86 ]
    [0.28 0.47 color red 0.0664 green 0.5731 blue 0.6892 alpha 0.67
               color red 0.0664 green 0.5731 blue 0.6892 alpha 0.67 ]
    [0.47 0.85 color red 0.4443 green 0.0841 blue 0.7888 alpha 0.45
               color red 0.4443 green 0.0841 blue 0.7888 alpha 0.45 ]
    [0.85 1.00 color red 0.2672 green 0.8101 blue 0.7697 alpha 0.43
               color red 0.2672 green 0.8101 blue 0.7697 alpha 0.43 ]
  }
  phong 0.82
  phong_size 72
  ambient 0.4
  turbulence 0.4
  scale <0.37 0.20 0.18>
  rotate <116  70 307>
}

#declare Particles_3 = texture {
  granite
  color_map {
    [0   0.09   color red 0.4313 green 0.8570 blue 0.8943 alpha 0.42
                color red 0.4313 green 0.8570 blue 0.8943 alpha 0.42 ]
    [0.09 0.18  color red 0.6569 green 0.0018 blue 0.5253 alpha 0.35
                color red 0.6569 green 0.0018 blue 0.5253 alpha 0.35 ]
    [0.18 0.26  color red 0.4516 green 0.3755 blue 0.9183 alpha 0.87
                color red 0.4516 green 0.3755 blue 0.9183 alpha 0.87 ]
    [0.26 0.46  color red 0.0548 green 0.7616 blue 0.5482 alpha 0.61
                color red 0.0548 green 0.7616 blue 0.5482 alpha 0.61 ]
    [0.46 0.74  color red 0.9618 green 0.8725 blue 0.6565 alpha 0.42
                color red 0.9618 green 0.8725 blue 0.6565 alpha 0.42 ]
    [0.74 1.00  color red 0.9024 green 0.5490 blue 0.4140 alpha 1
                color red 0.9024 green 0.5490 blue 0.4140 alpha 1 ]
  }
  phong 0.08
  phong_size 63
  ambient 0.4
  turbulence 0.6
  scale <0.86 0.26 0.25>
  rotate <252  98 195>
}

#declare Blue_Particles = texture {
  granite
  color_map {
    [0   0.05   color red 0.1904 green 0.4554 blue 0.6735 alpha .08
                color red 0.1904 green 0.4554 blue 0.6735 alpha .08 ]
    [0.05 0.05  color red 0.9138 green 0.8481 blue 0.1662 alpha .65
                color red 0.9138 green 0.8481 blue 0.1662 alpha .65 ]
    [0.05 0.15  color red 0.1833 green 0.7413 blue 0.2904 alpha .93
                color red 0.1833 green 0.7413 blue 0.2904 alpha .93 ]
    [0.15 0.33  color red 0.9108 green 0.8256 blue 0.7252 alpha .73
                color red 0.9108 green 0.8256 blue 0.7252 alpha .73 ]
    [0.33 0.82  color red 0.2749 green 0.4311 blue 0.7643 alpha .01
                color red 0.2749 green 0.4311 blue 0.7643 alpha .01 ]
    [0.82 1.00  color red 0.1158 green 0.1045 blue 0.5100 alpha .84
                color red 0.1158 green 0.1045 blue 0.5100 alpha .84 ]
  }
  phong 0.40
  phong_size 63
  ambient 0.4
  turbulence 0.6
  scale <0.43 0.88 0.58>
  rotate <305 201  15>
}

#declare Onion_Peel = texture {
  gradient <1.2 1.2 0.3>
  refraction 1.0
  turbulence 0.3
  color_map {
    [0   0.36   color red 0.3439 green 0.7016 blue 0.4760
                color red 0.3439 green 0.7016 blue 0.4760]
    [0.36 0.17  color red 0.4653 green 0.4809 blue 0.2126
                color red 0.8636 green 0.6378 blue 0.7462]
    [0.17 1.001 color red 0.4276 green 0.0905 blue 0.3921
                color red 0.4470 green 0.7727 blue 0.3792]
   }
  phong 1.0
  ambient 0.4
  rotate <328 247 136>
  scale  <1.2 0.3 1.2>
}

#declare Stone_1 = texture {
  granite
  color_map {
    [0.00 0.09 color red 0.1400 green 0.0571 blue 0.2182 alpha 0
               color red 0.0618 green 0.2772 blue 0.1627 alpha 0 ]
    [0.09 0.19 color red 0.0618 green 0.2772 blue 0.1627 alpha 0
               color red 0.0443 green 0.7271 blue 0.7939 alpha 0 ]
    [0.19 0.38 color red 0.0443 green 0.7271 blue 0.7939 alpha 0
               color red 0.4215 green 0.6412 blue 0.6240 alpha 0 ]
    [0.38 0.48 color red 0.4215 green 0.6412 blue 0.6240 alpha 0
               color red 0.8587 green 0.3760 blue 0.0453 alpha 0 ]
    [0.48 0.83 color red 0.8587 green 0.3760 blue 0.0453 alpha 0
               color red 0.2012 green 0.3254 blue 0.2589 alpha 0 ]
    [0.83 1.00 color red 0.2012 green 0.3254 blue 0.2589 alpha 0
               color red 0.9386 green 0.9777 blue 0.8777 alpha 0 ]
  }
  phong 0.10
  phong_size 72
  turbulence 0.8
  scale <0.63 0.57 0.44>
}

#declare Stone_2 = texture {
  granite
  color_map {
    [0.00 0.09 color red 0.7420 green 0.1957 blue 0.1646 alpha 0.70
               color red 0.3277 green 0.4617 blue 0.4008 alpha 0.62 ]
    [0.09 0.13 color red 0.3277 green 0.4617 blue 0.4008 alpha 0.62
               color red 0.8833 green 0.8066 blue 0.8869 alpha 0.36 ]
    [0.13 0.17 color red 0.8833 green 0.8066 blue 0.8869 alpha 0.36
               color red 0.3138 green 0.3189 blue 0.4586 alpha 0.74 ]
    [0.17 0.42 color red 0.3138 green 0.3189 blue 0.4586 alpha 0.74
               color red 0.5701 green 0.6466 blue 0.3433 alpha 0.23 ]
    [0.42 0.75 color red 0.5701 green 0.6466 blue 0.3433 alpha 0.23
               color red 0.8167 green 0.4925 blue 0.7607 alpha 0.97 ]
    [0.75 1.00 color red 0.8167 green 0.4925 blue 0.7607 alpha 0.97
               color red 0.3506 green 0.8950 blue 0.3793 alpha 0.92 ]
  }
  phong 0.55
  phong_size 81
  turbulence 1.1
  scale <0.55 0.54 0.48>
}

#declare Pink_Granite = texture {
  granite
  turbulence 0
  color_map {
     [0.00 0.40 color red 0.000 green 0.000 blue 0.000
                color red 0.000 green 0.000 blue 0.000 ]
     [0.40 0.45 color red 0.850 green 0.850 blue 0.950
                color red 0.850 green 0.850 blue 0.950 ]
     [0.45 0.50 color red 0.850 green 0.850 blue 0.950
                color red 0.753 green 0.753 blue 0.753 ]
     [0.50 0.55 color red 0.753 green 0.753 blue 0.753
                color red 0.820 green 0.570 blue 0.460 ]
     [0.55 0.80 color red 0.820 green 0.570 blue 0.460
                color red 0.820 green 0.570 blue 0.460 ]
     [0.80 1.00 color red 0.820 green 0.570 blue 0.460
                color red 1.000 green 0.500 blue 0.000 ]
  }
  phong 1.0
  phong_size 85
}

#declare Pistachio_Nut = texture {
  bozo
  color_map {
    [0   0.06   color red 0.6297 green 0.3571 blue 0.6976 alpha 0
                color red 0.1408 green 0.9514 blue 0.5200 alpha 0 ]
    [0.06 0.14  color red 0.1408 green 0.9514 blue 0.5200 alpha 0
                color red 0.6599 green 0.8747 blue 0.2528 alpha 0 ]
    [0.14 0.34  color red 0.6599 green 0.8747 blue 0.2528 alpha 0
                color red 0.9483 green 0.7884 blue 0.6313 alpha 0 ]
    [0.34 0.56  color red 0.9483 green 0.7884 blue 0.6313 alpha 0
                color red 0.4711 green 0.7890 blue 0.3997 alpha 0 ]
    [0.56 0.70  color red 0.4711 green 0.7890 blue 0.3997 alpha 0
                color red 0.8220 green 0.9360 blue 0.3860 alpha 0 ]
    [0.70 1.00  color red 0.8220 green 0.9360 blue 0.3860 alpha 0
                color red 0.1711 green 0.5548 blue 0.1139 alpha 0 ]
  }
  phong 0.08
  phong_size 63
  ambient 0.4
  turbulence 0.3
  scale <0.13 0.10 0.50>
  rotate < 49  18 306>
}

#declare Planet_1 = texture {
  granite
  bumps 1.0
  metallic
  turbulence 0.1
  color_map {
    [0   0.18   color red 0.5586 green 0.7248 blue 0.2998
                color red 0.5586 green 0.7248 blue 0.2998]
    [0.18 0.76  color red 0.5461 green 0.6625 blue 0.4053
                color red 0.4134 green 0.5366 blue 0.9395]
    [0.76 1.001 color red 0.7083 green 0.1053 blue 0.0655
                color red 0.7737 green 0.5325 blue 0.3206]
  }
  phong 1.0
  rotate <291  82 198>
  scale  <2.2 2.7 1.3>
}

#declare Blue_Vein_Pink_Plastic = texture {
  wood
  ripples 0.0
  color_map {
    [0   0.89   color red 0.0468 green 0.0862 blue 0.6746
                color red 0.0468 green 0.0862 blue 0.6746]
    [0.89 0.23  color red 0.8405 green 0.9888 blue 0.9298
                color red 0.0406 green 0.8997 blue 0.3637]
    [0.23 0.00  color red 0.5662 green 0.2521 blue 0.6819
                color red 0.9011 green 0.2936 blue 0.0707]
    [0.00 1.001 color red 0.9011 green 0.2936 blue 0.0707
                color red 0.7730 green 0.5941 blue 0.5171]
  }
  phong 1.0
  ambient 0.4
  turbulence 0.8
  scale <1.1 0.7 3.1>
  rotate <106 255  43>
}

#declare Mauve_Marble_Marine_Plastic = texture {
  gradient <0.2 1.1 2.0>
  roughness 1.0
  color_map {
    [0   0.66   color red 0.7928 green 0.6860 blue 0.9390
                color red 0.7928 green 0.6860 blue 0.9390]
    [0.66 0.58  color red 0.9091 green 0.3747 blue 0.7370
                color red 0.6217 green 0.6140 blue 0.5999]
    [0.58 0.00  color red 0.8846 green 0.4936 blue 0.2392
                color red 0.1685 green 0.0771 blue 0.1102]
    [0.00 1.001 color red 0.1685 green 0.0771 blue 0.1102
                color red 0.0406 green 0.0322 blue 0.3444]
  }
  phong 1.0
  ambient 0.4
  turbulence 0.9
  scale <1.1 2.0 0.2>
  rotate <284 251  67>
}

#declare Pistachio_Marble_Black_Plastic = texture {
  agate
  dents 0.0
  turbulence 0.9
  color_map {
    [0   0.71   color red 0.0226 green 0.1489 blue 0.0900
                color red 0.0226 green 0.1489 blue 0.0900]
    [0.71 0.52  color red 0.6521 green 0.8775 blue 0.5787
                color red 0.1011 green 0.1854 blue 0.9406]
    [0.52 1.001 color red 0.3205 green 0.9668 blue 0.0943
                color red 0.8730 green 0.9234 blue 0.6004]
  }
  phong 1.0
  ambient 0.4
  rotate <148 323 164>
  scale <2.3 0.2 3.5>
}

#declare Red_Vein_Grey_Plastic = texture {
  marble
  turbulence 1.0
  color_map {
    [0.0 0.7 color red 1.0
             color red 1.0]
    [0.7 0.9 color red 1.0
             color red 1.0 green 1.0 blue 1.0]
    [0.9 1.0 color red 0.9 green 0.8 blue 0.8
             color red 0.7 green 0.5 blue 0.5]
  }
  rotate <0 -30 0>
  phong 1.0
}

#declare Green_Vein_Pistachio_Plastic = texture {
  wood
  ripples 0.0
  color_map {
    [0   0.81   color red 0.1686 green 0.3219 blue 0.0639
                color red 0.1686 green 0.3219 blue 0.0639]
    [0.81 0.23  color red 0.0283 green 0.2406 blue 0.4457
                color red 0.2252 green 0.7120 blue 0.3254]
    [0.23 0.00  color red 0.9740 green 0.5141 blue 0.5747
                color red 0.1422 green 0.2789 blue 0.3231]
    [0.00 1.001 color red 0.1422 green 0.2789 blue 0.3231
                color red 0.3723 green 0.7744 blue 0.0549]
  }
  phong 1.0
  ambient 0.4
  turbulence 0.4
  scale <0.5 1.2 2.6>
  rotate <124 222 358>
}

#declare Psychedelik_1 = texture {
  wood
  color_map {
    [0   0.09   color red 0.9138 green 0.3142 blue 0.3359
                color red 0.9138 green 0.3142 blue 0.3359]
    [0.09 0.86  color red 0.2600 green 0.8661 blue 0.4363
                color red 0.3114 green 0.7216 blue 0.6458]
    [0.86 0.00  color red 0.5377 green 0.2882 blue 0.5914
                color red 0.5984 green 0.8569 blue 0.8621]
    [0.00 1.001 color red 0.5984 green 0.8569 blue 0.8621
                color red 0.2072 green 0.0735 blue 0.4433]
  }
  phong 1.0
  ambient 0.4
  turbulence 1.0
  scale <2.0 1.5 1.0>
  rotate <272  31  39>
}

#declare Psychedelik_2 = texture {
  wood
  color_map {
    [0   0.12   color red 0.3372 green 0.5133 blue 0.2250
                color red 0.3372 green 0.5133 blue 0.2250]
    [0.12 0.36  color red 0.9879 green 0.5860 blue 0.8839
                color red 0.2251 green 0.5980 blue 0.8066]
    [0.36 0.00  color red 0.3237 green 0.0695 blue 0.3244
                color red 0.6031 green 0.5862 blue 0.4936]
    [0.00 1.001 color red 0.6031 green 0.5862 blue 0.4936
                color red 0.2903 green 0.7180 blue 0.7893]
  }
  phong 1.0
  ambient 0.4
  turbulence 0.8
  scale <3.0 2.1 1.7>
  rotate < 51 159 302>
}

#declare Psychedelik_3 = texture {
  granite
  turbulence 1.1
  color_map {
    [0   0.17   color red 0.7616 green 0.8549 blue 0.5759
                color red 0.7616 green 0.8549 blue 0.5759]
    [0.17 0.52  color red 0.4968 green 0.0588 blue 0.1270
                color red 0.5049 green 0.5687 blue 0.2050]
    [0.52 1.001 color red 0.4033 green 0.3751 blue 0.6748
                color red 0.4208 green 0.9663 blue 0.0133]
   }
  phong 1.0
  ambient 0.4
  rotate <123 249 306>
  scale  <1.7 2.3 3.8>
}

#declare Riviera_1 = texture {
  marble
  turbulence 0.9
  color_map {
    [0.0 0.7   color red 0.184 green 0.184 blue 0.309
               color red 0.184 green 0.184 blue 0.309 ]
    [0.7 1.001 color red 1.000 green 1.000 blue 1.000
               color red 0.000 green 0.000 blue 1.000 ]
  }
  phong 1.0
  scale <0.4 0.4 0.4>
}

#declare Riviera_2 = texture {
  marble
  refraction 1.0
  color_map {
    [0   0.44   color red 0.3872 green 0.8987 blue 0.9664
                color red 0.3872 green 0.8987 blue 0.9664]
    [0.44 0.35  color red 0.1073 green 0.7214 blue 0.0725
                color red 0.0201 green 0.4910 blue 0.9891]
    [0.35 0.00  color red 0.2843 green 0.2324 blue 0.3433
                color red 0.0675 green 0.7303 blue 0.4137]
    [0.00 1.001 color red 0.0675 green 0.7303 blue 0.4137
                color red 0.3399 green 0.0372 blue 0.7414]
  }
  phong 1.0
  ambient 0.4
  turbulence 0.5
  scale <0.2 2.3 0.2>
  rotate < 79 157 220>
}

#declare Scanner = texture {
  marble
  bumps 0.9
  color_map {
    [0   0.05  color red 0.2183 green 0.6550 blue 0.3040
               color red 0.4810 green 0.5457 blue 0.0340 ]
    [0.05 0.16 color red 0.4810 green 0.5457 blue 0.0340
               color red 0.2517 green 0.2356 blue 0.6608 ]
    [0.16 0.20 color red 0.2517 green 0.2356 blue 0.6608
               color red 0.1233 green 0.1173 blue 0.2549 ]
    [0.20 0.50 color red 0.1233 green 0.1173 blue 0.2549
               color red 0.4906 green 0.1921 blue 0.6600 ]
    [0.50 0.81 color red 0.4906 green 0.1921 blue 0.6600
               color red 0.2150 green 0.6789 blue 0.7684 ]
    [0.81 1.00 color red 0.2150 green 0.6789 blue 0.7684
               color red 0.7305 green 0.8288 blue 0.5263 ]
  }
  phong 0.82
  phong_size 81
  ambient 0.4
  turbulence 1.1
  scale <0.79 0.53 0.60>
  rotate < 62  59 126>
}

#declare Tempest = texture {
  agate
  refraction 0.0
  turbulence 0.7
  color_map {
    [0   0.34   color red 0.4389 green 0.1428 blue 0.4260
                color red 0.4389 green 0.1428 blue 0.4260]
    [0.34 0.22  color red 0.7746 green 0.8381 blue 0.5612
                color red 0.7973 green 0.5913 blue 0.0370]
    [0.22 1.001 color red 0.3723 green 0.0032 blue 0.6093
                color red 0.5034 green 0.8444 blue 0.6547]
   }
  phong 1.0
  ambient 0.4
  rotate <355 267 317>
  scale  <1.0 2.0 4.0>
}

#declare Blob_Paint_1 = texture {
  phong 0.93
  phong_size 90
  ambient 0.4
  reflection 0.3
  refraction 1.0
  ior 1.0
  roughness 0.0001
  color_map {
    [ 0.0 0.96 color red 1.0 green 1.0 blue 1.0 alpha 0.9
               color red 1.0 green 1.0 blue 1.0 alpha 0.9 ]
    [ 0.96 1.0 color red 1.0 green 1.0 blue 1.0
               color red 1.0 green 1.0 blue 1.0 ]
  }
  agate
  turbulence 0.2
  scale <1.2 2.6 3.9>
  rotate <276 282 252>
}

#declare Blob_Paint_2 = texture {
  phong 0.93
  phong_size 90
  ambient 0.4
  reflection 0.3
  refraction 1.0
  ior 1.0
  roughness 0.0001
  color_map {
    [ 0.0 0.96 color red 1.0 green 1.0 blue 1.0 alpha 0.9
               color red 1.0 green 1.0 blue 1.0 alpha 0.9 ]
    [ 0.96 1.0 color red 1.0 green 1.0 blue 1.0
               color red 1.0 green 1.0 blue 1.0 ]
  }
  gradient <0.8 0.6 2.9>
  turbulence 0.2
  scale <0.6 2.9 0.8>
  rotate <221 340 99>
}

#declare Glass_Colored_Blue = texture {
  gradient <0.50 0.46 0.65>
  color_map {
    [0   0.10   color red 0.6958 green 0.1164 blue 0.8589 alpha .83
                color red 0.6958 green 0.1164 blue 0.8589 alpha .83 ]
    [0.10 0.19  color red 0.9704 green 0.3980 blue 0.9414 alpha .59
                color red 0.9704 green 0.3980 blue 0.9414 alpha .59 ]
    [0.19 0.24  color red 0.1775 green 0.5148 blue 0.8690 alpha .13
                color red 0.1775 green 0.5148 blue 0.8690 alpha .13 ]
    [0.24 0.27  color red 0.2514 green 0.3192 blue 0.9290 alpha .32
                color red 0.2514 green 0.3192 blue 0.9290 alpha .32 ]
    [0.27 0.30  color red 0.4005 green 0.0619 blue 0.8237 alpha .99
                color red 0.4005 green 0.0619 blue 0.8237 alpha .99 ]
    [0.30 1.00  color red 0.2303 green 0.7319 blue 0.9427 alpha .68
                color red 0.2303 green 0.7319 blue 0.9427 alpha .68 ]
  }
  phong 0.47
  phong_size 90
  ambient 0.4
  turbulence 1.0
  scale <0.46 0.65 0.50>
  rotate <157 86 318>
}

#declare Thin_Glass = texture {
  color red 1.0 green  1.0 blue 1.0 alpha 0.99999
  ambient 0.0
  diffuse 0.0
  reflection 0.1
  refraction 1.0
  specular 1.0
  roughness 0.001
  phong 1.0
}

#declare Blue_Volute = texture {
  onion
  brilliance 0.9
  color_map {
    [0   0.77   color red 0.4965 green 0.2714 blue 0.6892
                color red 0.4965 green 0.2714 blue 0.6892 ]
    [0.77 0.08  color red 0.5210 green 0.8875 blue 0.4673
                color red 0.9060 green 0.2643 blue 0.3944 ]
    [0.08 0.00  color red 0.9637 green 0.7192 blue 0.9106
                color red 0.2672 green 0.5501 blue 0.6322 ]
    [0.00 1.001 color red 0.2672 green 0.5501 blue 0.6322
                color red 0.8755 green 0.2391 blue 0.8814 ]
  }
  phong 0.83
  phong_size 90
  ambient 0.4
  turbulence 0.2
  scale <0.9 0.1 0.2>
  rotate <132 263 334>
}

#version 2.0

// --------------------------------------------------------------------------
// ---------------- STONE TEXTURES BY MIKE MILLER 1992 ----------------------
// --------------------------------------------------------------------------

//--------- Gray  Tan with Rose
#declare Grnt0 =
texture {
pigment
 {granite
  turbulence 0.4
  color_map
   {[0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.000>
                    color rgbf <0.769, 0.686, 0.592, 0.000>]
    [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.000>
                    color rgbf <0.843, 0.753, 0.718, 0.000>]
    [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.000>
                    color rgbf <0.780, 0.667, 0.561, 0.000>]
    [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.000>
                    color rgbf <0.741, 0.659, 0.576, 0.000>]
    [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.000>
                    color rgbf <0.729, 0.502, 0.451, 0.000>]
   }
 }
 }

//----- Creamy Whites with yellow & light gray
#declare Grnt1 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.212   color rgbf <0.898, 0.898, 0.851, 0.000>
                    color rgbf <0.969, 0.980, 0.875, 0.000>]
    [0.212, 0.424   color rgbf <0.969, 0.980, 0.875, 0.000>
                    color rgbf <0.859, 0.859, 0.859, 0.000>]
    [0.424, 0.627   color rgbf <0.859, 0.859, 0.859, 0.000>
                    color rgbf <0.992, 0.922, 0.659, 0.000>]
    [0.627, 0.881   color rgbf <0.992, 0.922, 0.659, 0.000>
                    color rgbf <0.937, 0.965, 0.902, 0.000>]
    [0.881, 1.001   color rgbf <0.937, 0.965, 0.902, 0.000>
                    color rgbf <0.898, 0.898, 0.851, 0.000>]
   }
 }
 }

//------- Deep Cream with light rose, yellow orchid & tan
#declare Grnt2 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.863, 0.757, 0.596, 0.000>
                    color rgbf <0.925, 0.792, 0.714, 0.000>]
    [0.178, 0.356   color rgbf <0.925, 0.792, 0.714, 0.000>
                    color rgbf <0.871, 0.702, 0.659, 0.000>]
    [0.356, 0.525   color rgbf <0.871, 0.702, 0.659, 0.000>
                    color rgbf <0.992, 0.922, 0.659, 0.000>]
    [0.525, 0.729   color rgbf <0.992, 0.922, 0.659, 0.000>
                    color rgbf <0.902, 0.812, 0.714, 0.000>]
    [0.729, 1.001   color rgbf <0.902, 0.812, 0.714, 0.000>
                    color rgbf <0.863, 0.757, 0.596, 0.000>]
   }
 }
 }

//------- Warm tans olive & light rose with cream
#declare Grnt3 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.831, 0.631, 0.569, 0.000>
                    color rgbf <0.925, 0.831, 0.714, 0.000>]
    [0.178, 0.356   color rgbf <0.925, 0.831, 0.714, 0.000>
                    color rgbf <0.871, 0.702, 0.659, 0.000>]
    [0.356, 0.525   color rgbf <0.871, 0.702, 0.659, 0.000>
                    color rgbf <0.831, 0.631, 0.569, 0.000>]
    [0.525, 0.729   color rgbf <0.831, 0.631, 0.569, 0.000>
                    color rgbf <0.937, 0.882, 0.820, 0.000>]
    [0.729, 1.001   color rgbf <0.937, 0.882, 0.820, 0.000>
                    color rgbf <0.831, 0.631, 0.569, 0.000>]
   }
 }
 }

//-------- Orchid sand & mouve
#declare Grnt4 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.804, 0.569, 0.494, 0.000>
                    color rgbf <0.816, 0.725, 0.537, 0.000>]
    [0.178, 0.356   color rgbf <0.816, 0.725, 0.537, 0.000>
                    color rgbf <0.820, 0.580, 0.522, 0.000>]
    [0.356, 0.525   color rgbf <0.820, 0.580, 0.522, 0.000>
                    color rgbf <0.882, 0.725, 0.537, 0.000>]
    [0.525, 0.729   color rgbf <0.882, 0.725, 0.537, 0.000>
                    color rgbf <0.855, 0.729, 0.584, 0.000>]
    [0.729, 1.001   color rgbf <0.855, 0.729, 0.584, 0.000>
                    color rgbf <0.804, 0.569, 0.494, 0.000>]
   }
 }
 }

//------- Medium Mauve Med.Rose & deep cream
#declare Grnt5 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.804, 0.569, 0.494, 0.000>
                    color rgbf <0.855, 0.729, 0.584, 0.000>]
    [0.178, 0.356   color rgbf <0.855, 0.729, 0.584, 0.000>
                    color rgbf <0.667, 0.502, 0.478, 0.000>]
    [0.356, 0.525   color rgbf <0.667, 0.502, 0.478, 0.000>
                    color rgbf <0.859, 0.624, 0.545, 0.000>]
    [0.525, 0.729   color rgbf <0.859, 0.624, 0.545, 0.000>
                    color rgbf <0.855, 0.729, 0.584, 0.000>]
    [0.729, 1.001   color rgbf <0.855, 0.729, 0.584, 0.000>
                    color rgbf <0.804, 0.569, 0.494, 0.000>]
   }
 }
 }

//--------- Med. Orchid Olive & Dark Tan "mud pie"
#declare Grnt6 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.153   color rgbf <0.545, 0.380, 0.345, 0.000>
                    color rgbf <0.588, 0.475, 0.333, 0.000>]
    [0.153, 0.398   color rgbf <0.588, 0.475, 0.333, 0.000>
                    color rgbf <0.675, 0.478, 0.404, 0.000>]
    [0.398, 0.559   color rgbf <0.675, 0.478, 0.404, 0.000>
                    color rgbf <0.757, 0.635, 0.522, 0.000>]
    [0.559, 0.729   color rgbf <0.757, 0.635, 0.522, 0.000>
                    color rgbf <0.659, 0.549, 0.443, 0.000>]
    [0.729, 1.001   color rgbf <0.659, 0.549, 0.443, 0.000>
                    color rgbf <0.545, 0.380, 0.345, 0.000>]
   }
 }
 }

//------- Dark Orchid Olive & Dark Putty
#declare Grnt7 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.153   color rgbf <0.439, 0.310, 0.282, 0.000>
                    color rgbf <0.463, 0.369, 0.259, 0.000>]
    [0.153, 0.398   color rgbf <0.463, 0.369, 0.259, 0.000>
                    color rgbf <0.541, 0.369, 0.298, 0.000>]
    [0.398, 0.559   color rgbf <0.541, 0.369, 0.298, 0.000>
                    color rgbf <0.573, 0.424, 0.286, 0.000>]
    [0.559, 0.729   color rgbf <0.573, 0.424, 0.286, 0.000>
                    color rgbf <0.494, 0.396, 0.306, 0.000>]
    [0.729, 1.001   color rgbf <0.494, 0.396, 0.306, 0.000>
                    color rgbf <0.439, 0.310, 0.282, 0.000>]
   }
 }
 }

//--------- Rose & Light cream Yellows
#declare Grnt8 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.179   color rgbf <0.843, 0.655, 0.655, 0.000>
                    color rgbf <0.886, 0.769, 0.627, 0.000>]
    [0.179, 0.368   color rgbf <0.886, 0.769, 0.627, 0.000>
                    color rgbf <0.906, 0.820, 0.714, 0.000>]
    [0.368, 0.538   color rgbf <0.906, 0.820, 0.714, 0.000>
                    color rgbf <0.851, 0.671, 0.671, 0.000>]
    [0.538, 0.846   color rgbf <0.851, 0.671, 0.671, 0.000>
                    color rgbf <0.890, 0.792, 0.675, 0.000>]
    [0.846, 0.983   color rgbf <0.890, 0.792, 0.675, 0.000>
                    color rgbf <0.827, 0.612, 0.612, 0.000>]
    [0.983, 1.001   color rgbf <0.827, 0.612, 0.612, 0.000>
                    color rgbf <0.843, 0.655, 0.655, 0.000>]
   }
 }
 }

//--------- Light Steely Grays
#declare Grnt9 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.894, 0.886, 0.886, 0.000>
                    color rgbf <0.745, 0.745, 0.753, 0.000>]
    [0.154, 0.308   color rgbf <0.745, 0.745, 0.753, 0.000>
                    color rgbf <0.902, 0.902, 0.859, 0.000>]
    [0.308, 0.444   color rgbf <0.902, 0.902, 0.859, 0.000>
                    color rgbf <0.729, 0.706, 0.694, 0.000>]
    [0.444, 0.615   color rgbf <0.729, 0.706, 0.694, 0.000>
                    color rgbf <0.588, 0.592, 0.635, 0.000>]
    [0.615, 0.803   color rgbf <0.588, 0.592, 0.635, 0.000>
                    color rgbf <0.608, 0.616, 0.659, 0.000>]
    [0.803, 1.001   color rgbf <0.608, 0.616, 0.659, 0.000>
                    color rgbf <0.894, 0.886, 0.886, 0.000>]
   }
 }
 }

//--------- Gray Creams & lavender tans
#declare Grnt10 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.890, 0.690, 0.690, 0.000>
                    color rgbf <0.996, 0.835, 0.737, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.835, 0.737, 0.000>
                    color rgbf <0.745, 0.635, 0.651, 0.004>]
    [0.308, 0.444   color rgbf <0.745, 0.635, 0.651, 0.004>
                    color rgbf <0.733, 0.596, 0.557, 0.004>]
    [0.444, 0.615   color rgbf <0.733, 0.596, 0.557, 0.004>
                    color rgbf <0.996, 0.835, 0.737, 0.000>]
    [0.615, 0.803   color rgbf <0.996, 0.835, 0.737, 0.000>
                    color rgbf <0.765, 0.616, 0.659, 0.000>]
    [0.803, 1.001   color rgbf <0.765, 0.616, 0.659, 0.000>
                    color rgbf <0.890, 0.690, 0.690, 0.000>]
   }
 }
 }

//--------- Creams & Grays Kakhi
#declare Grnt11 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.800, 0.651, 0.557, 0.000>
                    color rgbf <0.996, 0.835, 0.737, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.835, 0.737, 0.000>
                    color rgbf <0.800, 0.651, 0.557, 0.000>]
    [0.308, 0.444   color rgbf <0.800, 0.651, 0.557, 0.000>
                    color rgbf <0.694, 0.624, 0.604, 0.004>]
    [0.444, 0.615   color rgbf <0.694, 0.624, 0.604, 0.004>
                    color rgbf <0.800, 0.651, 0.557, 0.000>]
    [0.615, 0.812   color rgbf <0.800, 0.651, 0.557, 0.000>
                    color rgbf <0.725, 0.655, 0.651, 0.000>]
    [0.812, 1.001   color rgbf <0.725, 0.655, 0.651, 0.000>
                    color rgbf <0.800, 0.651, 0.557, 0.000>]
   }
 }
 }

//--------- Tan Cream & Red Rose
#declare Grnt12 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.969, 0.800, 0.000>
                    color rgbf <0.996, 0.682, 0.604, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.682, 0.604, 0.000>
                    color rgbf <0.906, 0.820, 0.714, 0.000>]
    [0.308, 0.444   color rgbf <0.906, 0.820, 0.714, 0.000>
                    color rgbf <0.816, 0.631, 0.537, 0.000>]
    [0.444, 0.615   color rgbf <0.816, 0.631, 0.537, 0.000>
                    color rgbf <0.890, 0.792, 0.675, 0.000>]
    [0.615, 0.812   color rgbf <0.890, 0.792, 0.675, 0.000>
                    color rgbf <0.973, 0.627, 0.627, 0.000>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.000>
                    color rgbf <0.996, 0.969, 0.800, 0.000>]
   }
 }
 }

//--------- Cream Rose orange
#declare Grnt13 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.824, 0.780, 0.000>
                    color rgbf <0.996, 0.698, 0.624, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.698, 0.624, 0.000>
                    color rgbf <0.906, 0.675, 0.553, 0.000>]
    [0.308, 0.444   color rgbf <0.906, 0.675, 0.553, 0.000>
                    color rgbf <0.996, 0.682, 0.604, 0.000>]
    [0.444, 0.615   color rgbf <0.996, 0.682, 0.604, 0.000>
                    color rgbf <0.996, 0.824, 0.780, 0.000>]
    [0.615, 0.812   color rgbf <0.996, 0.824, 0.780, 0.000>
                    color rgbf <0.973, 0.627, 0.627, 0.000>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.000>
                    color rgbf <0.996, 0.824, 0.780, 0.000>]
   }
 }
 }

//--------- Cream Rose & light moss & light Violet
#declare Grnt14 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.690, 0.612, 0.569, 0.000>
                    color rgbf <0.737, 0.596, 0.522, 0.000>]
    [0.154, 0.368   color rgbf <0.737, 0.596, 0.522, 0.000>
                    color rgbf <0.776, 0.702, 0.624, 0.000>]
    [0.368, 0.538   color rgbf <0.776, 0.702, 0.624, 0.000>
                    color rgbf <0.796, 0.678, 0.643, 0.000>]
    [0.538, 0.846   color rgbf <0.796, 0.678, 0.643, 0.000>
                    color rgbf <0.690, 0.612, 0.569, 0.000>]
    [0.846, 0.932   color rgbf <0.690, 0.612, 0.569, 0.000>
                    color rgbf <0.773, 0.612, 0.569, 0.000>]
    [0.932, 1.001   color rgbf <0.773, 0.612, 0.569, 0.000>
                    color rgbf <0.690, 0.612, 0.569, 0.000>]
   }
 }
 }

//--------- Black with subtle chroma
#declare Grnt15 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.104   color rgbf <0.161, 0.133, 0.118, 0.000>
                    color rgbf <0.110, 0.082, 0.071, 0.000>]
    [0.104, 0.252   color rgbf <0.110, 0.082, 0.071, 0.000>
                    color rgbf <0.161, 0.133, 0.118, 0.000>]
    [0.252, 0.383   color rgbf <0.161, 0.133, 0.118, 0.000>
                    color rgbf <0.000, 0.000, 0.000, 0.000>]
    [0.383, 0.643   color rgbf <0.000, 0.000, 0.000, 0.000>
                    color rgbf <0.161, 0.133, 0.118, 0.000>]
    [0.643, 0.783   color rgbf <0.161, 0.133, 0.118, 0.000>
                    color rgbf <0.220, 0.149, 0.137, 0.000>]
    [0.783, 0.922   color rgbf <0.220, 0.149, 0.137, 0.000>
                    color rgbf <0.000, 0.000, 0.000, 0.000>]
    [0.922, 0.983   color rgbf <0.000, 0.000, 0.000, 0.000>
                    color rgbf <0.220, 0.149, 0.137, 0.000>]
    [0.983, 1.001   color rgbf <0.220, 0.149, 0.137, 0.000>
                    color rgbf <0.161, 0.133, 0.118, 0.000>]
   }
 }
 }

//----- White Cream & Peach
#declare Grnt16 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.316   color rgbf <0.910, 0.788, 0.788, 0.000>
                    color rgbf <0.922, 0.914, 0.871, 0.000>]
    [0.316, 0.453   color rgbf <0.922, 0.914, 0.871, 0.000>
                    color rgbf <0.894, 0.867, 0.780, 0.000>]
    [0.453, 0.624   color rgbf <0.894, 0.867, 0.780, 0.000>
                    color rgbf <0.784, 0.788, 0.788, 0.000>]
    [0.624, 0.726   color rgbf <0.784, 0.788, 0.788, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.000>]
    [0.726, 0.863   color rgbf <0.851, 0.812, 0.741, 0.000>
                    color rgbf <0.647, 0.655, 0.655, 0.000>]
    [0.863, 1.001   color rgbf <0.647, 0.655, 0.655, 0.000>
                    color rgbf <0.910, 0.788, 0.788, 0.000>]
   }
 }
 }

//----- Bug Juice & Green
#declare Grnt17 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.303   color rgbf <0.000, 0.239, 0.000, 0.000>
                    color rgbf <0.333, 0.294, 0.000, 0.000>]
    [0.303, 0.588   color rgbf <0.333, 0.294, 0.000, 0.000>
                    color rgbf <0.000, 0.239, 0.341, 0.000>]
    [0.588, 0.790   color rgbf <0.000, 0.239, 0.341, 0.000>
                    color rgbf <0.000, 0.020, 0.000, 0.000>]
    [0.790, 1.001   color rgbf <0.000, 0.020, 0.000, 0.000>
                    color rgbf <0.000, 0.239, 0.000, 0.000>]
   }
 }
 }

//------------ Rose & cream yellow
#declare Grnt18 =
texture {
pigment
 {granite
  turbulence 0.4
  color_map
   {[0.000, 0.202   color rgbf <1.000, 0.718, 0.541, 0.000>
                    color rgbf <0.890, 0.651, 0.612, 0.000>]
    [0.202, 0.298   color rgbf <0.890, 0.651, 0.612, 0.000>
                    color rgbf <1.000, 0.820, 0.675, 0.000>]
    [0.298, 0.377   color rgbf <1.000, 0.820, 0.675, 0.000>
                    color rgbf <0.890, 0.643, 0.612, 0.000>]
    [0.377, 0.465   color rgbf <0.890, 0.643, 0.612, 0.000>
                    color rgbf <0.937, 0.729, 0.561, 0.000>]
    [0.465, 0.544   color rgbf <0.937, 0.729, 0.561, 0.000>
                    color rgbf <0.878, 0.604, 0.565, 0.000>]
    [0.544, 0.640   color rgbf <0.878, 0.604, 0.565, 0.000>
                    color rgbf <0.984, 0.780, 0.655, 0.000>]
    [0.640, 0.860   color rgbf <0.984, 0.780, 0.655, 0.000>
                    color rgbf <1.000, 0.863, 0.635, 0.000>]
    [0.860, 0.982   color rgbf <1.000, 0.863, 0.635, 0.000>
                    color rgbf <1.000, 0.765, 0.620, 0.000>]
    [0.982, 1.001   color rgbf <1.000, 0.765, 0.620, 0.000>
                    color rgbf <1.000, 0.718, 0.541, 0.000>]
   }
 }
 }

//--------- Gray Marble with White feather Viens
#declare Grnt19 =
texture {
pigment {
  granite
  turbulence 0.0
  color_map
   {[0.0, 0.3 color red 1 green 1 blue 1 color DimGray]
    [0.3, 0.4 color DimGray color DimGray]
    [0.4, 0.6 color DimGray color DimGray]
    [0.6, 1.0 color DimGray color DimGray]
   }
 }
 finish {
  crand 0.02
 }
 }

//--------- White Marble with Gray feather Viens
#declare Grnt20 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.3 color Mica color White]
    [0.3, 0.4 color red 1 green 1 blue 1 color White]
    [0.4, 0.6 color red 1 green 1 blue 1 color White]
    [0.6, 1.0 color red 1 green 1 blue 1 color White]
   }
 }
 finish {
  crand 0.02
 }
 }

//-------- Declare Green Colors
#declare g1 = color red 0.26 green 0.41 blue 0.31 //---Light Gray Green
#declare g2 = color red 0.27 green 0.34 blue 0.26 //---Med Gray Green
#declare g3 = color red 0.13 green 0.29 blue 0.28 //---Med Gray Aqua
#declare g4 = color red 0.03 green 0.18 blue 0.08 //---Dark Green

//--------- Green Jade
#declare Grnt21 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.1 color red 1 green 1 blue 1    filter 0.3 color SeaGreen  filter 0.4]
    [0.1, 0.3 color SeaGreen filter 0.4 color g2        filter 0.7]
    [0.3, 0.5 color g2       filter 0.7 color DarkGreen filter 0.7]
    [0.5, 0.7 color DarkGreen  filter 0.7 color g4 filter 0.7]
    [0.7, 0.8 color g4         filter 0.7 color DarkGreen filter 0.7]
    [0.8, 1.0 color DarkGreen  filter 0.7 color DarkGreen filter 0.7]
   }
 }
 finish {
  crand 0.02
 }
 }

//--------- Clear with White feather Viens ----- This one does contain Filter
#declare Grnt22 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.07 color red 1 green 1 blue 1 color White]
    [0.07, 0.2 color red 1 green 1 blue 1 color DimGray]
    [0.2, 0.3 color DimGray color Clear]
    [0.3, 0.7 color Clear color Clear]
    [0.7, 1.0 color Clear color DimGray]
   }
 }
 finish {
  crand 0.02
 }
 }

//---------- Light Tan to Mouve
#declare Grnt23 =
texture {
pigment
 {marble
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.831, 0.631, 0.569, 0.000>
                    color rgbf <0.925, 0.831, 0.714, 0.000>]
    [0.178, 0.356   color rgbf <0.925, 0.831, 0.714, 0.000>
                    color rgbf <0.871, 0.702, 0.659, 0.000>]
    [0.356, 0.525   color rgbf <0.871, 0.702, 0.659, 0.000>
                    color rgbf <0.831, 0.631, 0.569, 0.000>]
    [0.525, 0.729   color rgbf <0.831, 0.631, 0.569, 0.000>
                    color rgbf <0.937, 0.882, 0.820, 0.000>]
    [0.729, 1.001   color rgbf <0.937, 0.882, 0.820, 0.000>
                    color rgbf <0.831, 0.631, 0.569, 0.000>]
   }
 }
 }

//--------- Light Grays
#declare Grnt24 =
texture {
pigment
 {marble
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.894, 0.886, 0.886, 0.000>
                    color rgbf <0.745, 0.745, 0.753, 0.000>]
    [0.154, 0.308   color rgbf <0.745, 0.745, 0.753, 0.000>
                    color rgbf <0.902, 0.902, 0.859, 0.000>]
    [0.308, 0.444   color rgbf <0.902, 0.902, 0.859, 0.000>
                    color rgbf <0.729, 0.706, 0.694, 0.000>]
    [0.444, 0.615   color rgbf <0.729, 0.706, 0.694, 0.000>
                    color rgbf <0.588, 0.592, 0.635, 0.000>]
    [0.615, 0.803   color rgbf <0.588, 0.592, 0.635, 0.000>
                    color rgbf <0.608, 0.616, 0.659, 0.000>]
    [0.803, 1.001   color rgbf <0.608, 0.616, 0.659, 0.000>
                    color rgbf <0.894, 0.886, 0.886, 0.000>]
   }
 }
 }

//------------ Moss Greens & Tan
#declare Grnt25 =
texture {
pigment
 {marble
  turbulence 0.7
  color_map
   {[0.000, 0.168   color rgbf <0.824, 0.725, 0.584, 0.000>
                    color rgbf <0.514, 0.584, 0.533, 0.000>]
    [0.168, 0.301   color rgbf <0.514, 0.584, 0.533, 0.000>
                    color rgbf <0.298, 0.376, 0.318, 0.000>]
    [0.301, 0.398   color rgbf <0.298, 0.376, 0.318, 0.000>
                    color rgbf <0.263, 0.337, 0.282, 0.000>]
    [0.398, 0.558   color rgbf <0.263, 0.337, 0.282, 0.000>
                    color rgbf <0.431, 0.506, 0.451, 0.000>]
    [0.558, 0.655   color rgbf <0.431, 0.506, 0.451, 0.000>
                    color rgbf <0.529, 0.631, 0.471, 0.000>]
    [0.655, 0.735   color rgbf <0.529, 0.631, 0.471, 0.000>
                    color rgbf <0.333, 0.376, 0.318, 0.000>]
    [0.735, 0.823   color rgbf <0.333, 0.376, 0.318, 0.000>
                    color rgbf <0.298, 0.376, 0.318, 0.000>]
    [0.823, 0.876   color rgbf <0.298, 0.376, 0.318, 0.000>
                    color rgbf <0.416, 0.376, 0.318, 0.000>]
    [0.876, 0.929   color rgbf <0.416, 0.376, 0.318, 0.000>
                    color rgbf <0.416, 0.376, 0.318, 0.000>]
    [0.929, 1.001   color rgbf <0.416, 0.376, 0.318, 0.000>
                    color rgbf <0.824, 0.725, 0.584, 0.000>]
   }
 }
 }

//---------- Salmon with thin Green Viens
#declare Grnt26 =
texture {
pigment
 {granite
  color_map
   {[0.000, 0.241   color rgbf <0.973, 0.973, 0.976, 0.000>
                    color rgbf <0.973, 0.973, 0.976, 0.000>]
    [0.241, 0.284   color rgbf <0.973, 0.973, 0.976, 0.000>
                    color rgbf <0.600, 0.741, 0.608, 0.000>]
    [0.284, 0.336   color rgbf <0.600, 0.741, 0.608, 0.000>
                    color rgbf <0.820, 0.643, 0.537, 0.000>]
    [0.336, 0.474   color rgbf <0.820, 0.643, 0.537, 0.000>
                    color rgbf <0.886, 0.780, 0.714, 0.000>]
    [0.474, 0.810   color rgbf <0.886, 0.780, 0.714, 0.000>
                    color rgbf <0.996, 0.643, 0.537, 0.000>]
    [0.810, 0.836   color rgbf <0.996, 0.643, 0.537, 0.000>
                    color rgbf <0.973, 0.973, 0.976, 0.000>]
    [0.836, 1.001   color rgbf <0.973, 0.973, 0.976, 0.000>
                    color rgbf <0.973, 0.973, 0.976, 0.000>]
   }
 }
 finish {
  crand 0.02
 }
 }

//------ Dark Green & Browns
#declare Grnt27 =
texture {
pigment
 {granite
  color_map
   {[0.000, 0.043   color rgbf <0.773, 0.647, 0.569, 0.000>
                    color rgbf <0.431, 0.322, 0.227, 0.000>]
    [0.043, 0.113   color rgbf <0.431, 0.322, 0.227, 0.000>
                    color rgbf <0.278, 0.282, 0.216, 0.000>]
    [0.113, 0.304   color rgbf <0.278, 0.282, 0.216, 0.000>
                    color rgbf <0.278, 0.282, 0.216, 0.000>]
    [0.304, 0.426   color rgbf <0.278, 0.282, 0.216, 0.000>
                    color rgbf <0.459, 0.341, 0.243, 0.000>]
    [0.426, 0.843   color rgbf <0.459, 0.341, 0.243, 0.000>
                    color rgbf <0.459, 0.341, 0.243, 0.000>]
    [0.843, 0.878   color rgbf <0.459, 0.341, 0.243, 0.000>
                    color rgbf <0.459, 0.341, 0.243, 0.000>]
    [0.878, 0.983   color rgbf <0.459, 0.341, 0.243, 0.000>
                    color rgbf <0.278, 0.282, 0.216, 0.000>]
    [0.983, 1.001   color rgbf <0.278, 0.282, 0.216, 0.000>
                    color rgbf <0.773, 0.647, 0.569, 0.000>]
   }
 }
 }

//------- Red Swirl
#declare Grnt28 =
texture {
pigment
 {marble
  turbulence 0.7
  color_map
   {[0.000, 0.155   color rgbf <0.686, 0.235, 0.282, 0.000>
                    color rgbf <0.686, 0.235, 0.282, 0.000>]
    [0.155, 0.328   color rgbf <0.686, 0.235, 0.282, 0.000>
                    color rgbf <0.494, 0.243, 0.294, 0.000>]
    [0.328, 0.474   color rgbf <0.494, 0.243, 0.294, 0.000>
                    color rgbf <0.769, 0.329, 0.373, 0.000>]
    [0.474, 0.647   color rgbf <0.769, 0.329, 0.373, 0.000>
                    color rgbf <0.769, 0.329, 0.373, 0.000>]
    [0.647, 0.810   color rgbf <0.769, 0.329, 0.373, 0.000>
                    color rgbf <0.686, 0.235, 0.282, 0.000>]
    [0.810, 0.922   color rgbf <0.686, 0.235, 0.282, 0.000>
                    color rgbf <0.792, 0.388, 0.427, 0.000>]
    [0.922, 1.001   color rgbf <0.792, 0.388, 0.427, 0.000>
                    color rgbf <0.686, 0.235, 0.282, 0.000>]
   }
 }
 finish {
  crand 0.03
 }
 }

//-------- White Tan & thin Reds
#declare Grnt29 =
texture {
pigment
 {marble
  turbulence 0.5
  color_map
   {[0.000, 0.053   color rgbf <0.784, 0.627, 0.522, 0.000>
                    color rgbf <0.784, 0.627, 0.624, 0.000>]
    [0.053, 0.263   color rgbf <0.784, 0.627, 0.624, 0.000>
                    color rgbf <0.824, 0.557, 0.376, 0.000>]
    [0.263, 0.281   color rgbf <0.824, 0.557, 0.376, 0.000>
                    color rgbf <0.643, 0.380, 0.376, 0.000>]
    [0.281, 0.325   color rgbf <0.643, 0.380, 0.376, 0.000>
                    color rgbf <0.839, 0.722, 0.722, 0.000>]
    [0.325, 0.711   color rgbf <0.839, 0.722, 0.722, 0.000>
                    color rgbf <0.784, 0.627, 0.522, 0.000>]
    [0.711, 0.798   color rgbf <0.784, 0.627, 0.522, 0.000>
                    color rgbf <0.769, 0.380, 0.376, 0.000>]
    [0.798, 0.895   color rgbf <0.769, 0.380, 0.376, 0.000>
                    color rgbf <0.824, 0.557, 0.376, 0.000>]
    [0.895, 0.982   color rgbf <0.824, 0.557, 0.376, 0.000>
                    color rgbf <0.784, 0.627, 0.522, 0.000>]
    [0.982, 1.001   color rgbf <0.784, 0.627, 0.522, 0.000>
                    color rgbf <0.784, 0.627, 0.522, 0.000>]
   }
 }
 }

//***************************************************************
//------------ start of textures with filter

//----- Translucent Grnt0
#declare Grnt0a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.306>
                    color rgbf <0.769, 0.686, 0.592, 0.792>]
    [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.792>
                    color rgbf <0.843, 0.753, 0.718, 0.396>]
    [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.396>
                    color rgbf <0.780, 0.667, 0.561, 0.976>]
    [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.976>
                    color rgbf <0.741, 0.659, 0.576, 0.820>]
    [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.820>
                    color rgbf <0.729, 0.502, 0.451, 0.306>]
   }
 }
 }

//----- Translucent Grnt1
#declare Grnt1a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.212   color rgbf <0.898, 0.898, 0.851, 0.306>
                    color rgbf <0.969, 0.980, 0.875, 0.792>]
    [0.212, 0.424   color rgbf <0.969, 0.980, 0.875, 0.792>
                    color rgbf <0.859, 0.859, 0.859, 0.396>]
    [0.424, 0.627   color rgbf <0.859, 0.859, 0.859, 0.396>
                    color rgbf <0.992, 0.922, 0.659, 0.976>]
    [0.627, 0.881   color rgbf <0.992, 0.922, 0.659, 0.976>
                    color rgbf <0.937, 0.965, 0.902, 0.820>]
    [0.881, 1.001   color rgbf <0.937, 0.965, 0.902, 0.820>
                    color rgbf <0.898, 0.898, 0.851, 0.306>]
   }
 }
 }

//-----Translucent Grnt2
#declare Grnt2a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.144   color rgbf <0.863, 0.757, 0.596, 0.596>
                    color rgbf <0.925, 0.792, 0.714, 0.349>]
    [0.144, 0.288   color rgbf <0.925, 0.792, 0.714, 0.349>
                    color rgbf <0.871, 0.702, 0.659, 0.784>]
    [0.288, 0.644   color rgbf <0.871, 0.702, 0.659, 0.784>
                    color rgbf <0.992, 0.922, 0.659, 0.498>]
    [0.644, 0.983   color rgbf <0.992, 0.922, 0.659, 0.498>
                    color rgbf <0.902, 0.812, 0.714, 0.722>]
    [0.983, 1.001   color rgbf <0.902, 0.812, 0.714, 0.722>
                    color rgbf <0.863, 0.757, 0.596, 0.596>]
   }
 }
 }

//-----Translucent Grnt3
#declare Grnt3a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.153   color rgbf <0.831, 0.631, 0.569, 0.447>
                    color rgbf <0.925, 0.831, 0.714, 0.678>]
    [0.153, 0.297   color rgbf <0.925, 0.831, 0.714, 0.678>
                    color rgbf <0.871, 0.702, 0.659, 0.475>]
    [0.297, 0.441   color rgbf <0.871, 0.702, 0.659, 0.475>
                    color rgbf <0.831, 0.631, 0.569, 0.918>]
    [0.441, 0.763   color rgbf <0.831, 0.631, 0.569, 0.918>
                    color rgbf <0.937, 0.882, 0.820, 0.655>]
    [0.763, 1.001   color rgbf <0.937, 0.882, 0.820, 0.655>
                    color rgbf <0.831, 0.631, 0.569, 0.447>]
   }
 }
 }

//-----Translucent Grnt4
#declare Grnt4a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.144   color rgbf <0.804, 0.569, 0.494, 0.569>
                    color rgbf <0.816, 0.725, 0.537, 0.467>]
    [0.144, 0.449   color rgbf <0.816, 0.725, 0.537, 0.467>
                    color rgbf <0.820, 0.580, 0.522, 0.584>]
    [0.449, 0.568   color rgbf <0.820, 0.580, 0.522, 0.584>
                    color rgbf <0.882, 0.725, 0.537, 0.871>]
    [0.568, 0.754   color rgbf <0.882, 0.725, 0.537, 0.871>
                    color rgbf <0.855, 0.729, 0.584, 0.816>]
    [0.754, 1.001   color rgbf <0.855, 0.729, 0.584, 0.816>
                    color rgbf <0.804, 0.569, 0.494, 0.569>]
   }
 }
 }

//-----Translucent Grnt5
#declare Grnt5a =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.804, 0.569, 0.494, 0.569>
                    color rgbf <0.855, 0.729, 0.584, 0.467>]
    [0.178, 0.356   color rgbf <0.855, 0.729, 0.584, 0.467>
                    color rgbf <0.667, 0.502, 0.478, 0.584>]
    [0.356, 0.525   color rgbf <0.667, 0.502, 0.478, 0.584>
                    color rgbf <0.859, 0.624, 0.545, 0.871>]
    [0.525, 0.729   color rgbf <0.859, 0.624, 0.545, 0.871>
                    color rgbf <0.855, 0.729, 0.584, 0.816>]
    [0.729, 1.001   color rgbf <0.855, 0.729, 0.584, 0.816>
                    color rgbf <0.804, 0.569, 0.494, 0.569>]
   }
 }
 }

//-----Translucent Grnt6
#declare Grnt6a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.263   color rgbf <0.545, 0.380, 0.345, 0.733>
                    color rgbf <0.588, 0.475, 0.333, 0.741>]
    [0.263, 0.432   color rgbf <0.588, 0.475, 0.333, 0.741>
                    color rgbf <0.675, 0.478, 0.404, 0.545>]
    [0.432, 0.551   color rgbf <0.675, 0.478, 0.404, 0.545>
                    color rgbf <0.757, 0.635, 0.522, 0.384>]
    [0.551, 0.720   color rgbf <0.757, 0.635, 0.522, 0.384>
                    color rgbf <0.659, 0.549, 0.443, 0.675>]
    [0.720, 1.001   color rgbf <0.659, 0.549, 0.443, 0.675>
                    color rgbf <0.545, 0.380, 0.345, 0.733>]
   }
 }
 }

//-----Translucent Grnt7
#declare Grnt7a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.439, 0.310, 0.282, 0.631>
                    color rgbf <0.463, 0.369, 0.259, 0.847>]
    [0.119, 0.322   color rgbf <0.463, 0.369, 0.259, 0.847>
                    color rgbf <0.541, 0.369, 0.298, 0.549>]
    [0.322, 0.449   color rgbf <0.541, 0.369, 0.298, 0.549>
                    color rgbf <0.573, 0.424, 0.286, 0.965>]
    [0.449, 0.729   color rgbf <0.573, 0.424, 0.286, 0.965>
                    color rgbf <0.494, 0.396, 0.306, 0.741>]
    [0.729, 1.001   color rgbf <0.494, 0.396, 0.306, 0.741>
                    color rgbf <0.439, 0.310, 0.282, 0.631>]
   }
 }
 }

//-----Aqua Tints
#declare Grnt8a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.310, 0.384, 0.420, 0.631>
                    color rgbf <0.322, 0.369, 0.416, 0.847>]
    [0.119, 0.322   color rgbf <0.322, 0.369, 0.416, 0.847>
                    color rgbf <0.424, 0.369, 0.420, 0.549>]
    [0.322, 0.449   color rgbf <0.424, 0.369, 0.420, 0.549>
                    color rgbf <0.373, 0.424, 0.518, 0.965>]
    [0.449, 0.729   color rgbf <0.373, 0.424, 0.518, 0.965>
                    color rgbf <0.482, 0.573, 0.533, 0.741>]
    [0.729, 1.001   color rgbf <0.482, 0.573, 0.533, 0.741>
                    color rgbf <0.310, 0.384, 0.420, 0.631>]
   }
 }
 }

//-----Filter Creams With Cracks
#declare Grnt9a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.216   color rgbf <0.812, 0.812, 0.812, 0.835>
                    color rgbf <0.745, 0.843, 0.835, 0.847>]
    [0.216, 0.241   color rgbf <0.745, 0.843, 0.835, 0.847>
                    color rgbf <0.404, 0.337, 0.337, 0.463>]
    [0.241, 0.267   color rgbf <0.404, 0.337, 0.337, 0.463>
                    color rgbf <0.773, 0.729, 0.745, 0.622>]
    [0.267, 0.759   color rgbf <0.773, 0.729, 0.745, 0.622>
                    color rgbf <0.914, 0.843, 0.725, 0.651>]
    [0.759, 0.784   color rgbf <0.914, 0.843, 0.725, 0.651>
                    color rgbf <0.153, 0.133, 0.208, 0.437>]
    [0.784, 0.810   color rgbf <0.153, 0.133, 0.208, 0.437>
                    color rgbf <0.812, 0.812, 0.812, 0.835>]
    [0.810, 1.001   color rgbf <0.812, 0.812, 0.812, 0.835>
                    color rgbf <0.812, 0.812, 0.812, 0.835>]
   }
 }
 }

//--------- Filter Cream Rose & light yellow
#declare Grnt10a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.179   color rgbf <0.843, 0.655, 0.655, 0.455>
                    color rgbf <0.886, 0.769, 0.627, 0.608>]
    [0.179, 0.368   color rgbf <0.886, 0.769, 0.627, 0.608>
                    color rgbf <0.906, 0.820, 0.714, 0.392>]
    [0.368, 0.538   color rgbf <0.906, 0.820, 0.714, 0.392>
                    color rgbf <0.851, 0.671, 0.671, 0.659>]
    [0.538, 0.744   color rgbf <0.851, 0.671, 0.671, 0.659>
                    color rgbf <0.890, 0.792, 0.675, 0.392>]
    [0.744, 0.983   color rgbf <0.890, 0.792, 0.675, 0.392>
                    color rgbf <0.827, 0.612, 0.612, 0.706>]
    [0.983, 1.001   color rgbf <0.827, 0.612, 0.612, 0.706>
                    color rgbf <0.843, 0.655, 0.655, 0.455>]
   }
 }
 }

//--------- Filter Light Grays
#declare Grnt11a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.894, 0.886, 0.886, 0.659>
                    color rgbf <0.745, 0.745, 0.753, 0.584>]
    [0.154, 0.308   color rgbf <0.745, 0.745, 0.753, 0.584>
                    color rgbf <0.902, 0.902, 0.859, 0.780>]
    [0.308, 0.444   color rgbf <0.902, 0.902, 0.859, 0.780>
                    color rgbf <0.729, 0.706, 0.694, 0.686>]
    [0.444, 0.615   color rgbf <0.729, 0.706, 0.694, 0.686>
                    color rgbf <0.588, 0.592, 0.635, 0.424>]
    [0.615, 0.803   color rgbf <0.588, 0.592, 0.635, 0.424>
                    color rgbf <0.608, 0.616, 0.659, 0.761>]
    [0.803, 1.001   color rgbf <0.608, 0.616, 0.659, 0.761>
                    color rgbf <0.894, 0.886, 0.886, 0.659>]
   }
 }
 }

//--------- Filter Creams & Tans
#declare Grnt12a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.890, 0.690, 0.690, 0.659>
                    color rgbf <0.996, 0.835, 0.737, 0.659>]
    [0.154, 0.308   color rgbf <0.996, 0.835, 0.737, 0.659>
                    color rgbf <0.745, 0.635, 0.651, 0.780>]
    [0.308, 0.444   color rgbf <0.745, 0.635, 0.651, 0.780>
                    color rgbf <0.733, 0.596, 0.557, 0.686>]
    [0.444, 0.615   color rgbf <0.733, 0.596, 0.557, 0.686>
                    color rgbf <0.996, 0.835, 0.737, 0.659>]
    [0.615, 0.803   color rgbf <0.996, 0.835, 0.737, 0.659>
                    color rgbf <0.765, 0.616, 0.659, 0.761>]
    [0.803, 1.001   color rgbf <0.765, 0.616, 0.659, 0.761>
                    color rgbf <0.890, 0.690, 0.690, 0.659>]
   }
 }
 }

//--------- Filter Creams & Grays
#declare Grnt13a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.800, 0.651, 0.557, 0.000>
                    color rgbf <0.996, 0.835, 0.737, 0.608>]
    [0.154, 0.308   color rgbf <0.996, 0.835, 0.737, 0.608>
                    color rgbf <0.800, 0.651, 0.557, 0.635>]
    [0.308, 0.444   color rgbf <0.800, 0.651, 0.557, 0.635>
                    color rgbf <0.694, 0.624, 0.604, 0.294>]
    [0.444, 0.615   color rgbf <0.694, 0.624, 0.604, 0.294>
                    color rgbf <0.800, 0.651, 0.557, 0.816>]
    [0.615, 0.812   color rgbf <0.800, 0.651, 0.557, 0.816>
                    color rgbf <0.725, 0.655, 0.651, 0.957>]
    [0.812, 1.001   color rgbf <0.725, 0.655, 0.651, 0.957>
                    color rgbf <0.800, 0.651, 0.557, 0.000>]
   }
 }
 }

//--------- Cream Rose & light moss
#declare Grnt14a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.969, 0.800, 0.373>
                    color rgbf <0.996, 0.682, 0.604, 0.412>]
    [0.154, 0.308   color rgbf <0.996, 0.682, 0.604, 0.412>
                    color rgbf <0.906, 0.820, 0.714, 0.616>]
    [0.308, 0.444   color rgbf <0.906, 0.820, 0.714, 0.616>
                    color rgbf <0.816, 0.631, 0.537, 0.443>]
    [0.444, 0.615   color rgbf <0.816, 0.631, 0.537, 0.443>
                    color rgbf <0.890, 0.792, 0.675, 0.745>]
    [0.615, 0.812   color rgbf <0.890, 0.792, 0.675, 0.745>
                    color rgbf <0.973, 0.627, 0.627, 0.600>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.600>
                    color rgbf <0.996, 0.969, 0.800, 0.373>]
   }
 }
 }

//--------- Filter Sand & light Orange
#declare Grnt15a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.824, 0.780, 0.412>
                    color rgbf <0.996, 0.698, 0.624, 0.412>]
    [0.154, 0.308   color rgbf <0.996, 0.698, 0.624, 0.412>
                    color rgbf <0.906, 0.675, 0.553, 0.616>]
    [0.308, 0.444   color rgbf <0.906, 0.675, 0.553, 0.616>
                    color rgbf <0.996, 0.682, 0.604, 0.412>]
    [0.444, 0.615   color rgbf <0.996, 0.682, 0.604, 0.412>
                    color rgbf <0.996, 0.824, 0.780, 0.412>]
    [0.615, 0.812   color rgbf <0.996, 0.824, 0.780, 0.412>
                    color rgbf <0.973, 0.627, 0.627, 0.600>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.600>
                    color rgbf <0.996, 0.824, 0.780, 0.412>]
   }
 }
 }

//--------- Cream Rose & light moss
#declare Grnt16a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.078   color rgbf <0.769, 0.722, 0.690, 0.180>
                    color rgbf <0.745, 0.690, 0.655, 1.000>]
    [0.078, 0.96    color rgbf <0.745, 0.690, 0.655, 1.000>
                    color rgbf <0.839, 0.804, 0.780, 1.000>]
    [0.96, 1.001    color rgbf <0.839, 0.804, 0.780, 0.278>
                    color rgbf <0.769, 0.722, 0.690, 0.180>]
   }
 }
 }

#declare Grnt17a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.034   color rgbf <0.027, 0.012, 0.012, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.235>]
    [0.034, 0.342   color rgbf <0.851, 0.812, 0.741, 0.235>
                    color rgbf <0.792, 0.694, 0.690, 0.839>]
    [0.342, 0.462   color rgbf <0.792, 0.694, 0.690, 0.839>
                    color rgbf <0.631, 0.506, 0.471, 0.608>]
    [0.462, 0.632   color rgbf <0.631, 0.506, 0.471, 0.608>
                    color rgbf <0.851, 0.812, 0.741, 0.922>]
    [0.632, 0.983   color rgbf <0.851, 0.812, 0.741, 0.922>
                    color rgbf <0.647, 0.655, 0.655, 0.282>]
    [0.983, 1.001   color rgbf <0.647, 0.655, 0.655, 0.282>
                    color rgbf <0.027, 0.012, 0.012, 0.000>]
   }
 }
 }

#declare Grnt18a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.128   color rgbf <0.820, 0.580, 0.580, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.235>]
    [0.128, 0.282   color rgbf <0.851, 0.812, 0.741, 0.235>
                    color rgbf <0.792, 0.694, 0.690, 0.282>]
    [0.282, 0.393   color rgbf <0.792, 0.694, 0.690, 0.282>
                    color rgbf <0.647, 0.655, 0.655, 0.133>]
    [0.393, 0.590   color rgbf <0.647, 0.655, 0.655, 0.133>
                    color rgbf <0.851, 0.812, 0.741, 0.333>]
    [0.590, 0.983   color rgbf <0.851, 0.812, 0.741, 0.333>
                    color rgbf <0.647, 0.655, 0.655, 0.282>]
    [0.983, 1.001   color rgbf <0.647, 0.655, 0.655, 0.282>
                    color rgbf <0.820, 0.580, 0.580, 0.000>]
   }
 }
 }

//--------- Gray Marble with White feather Viens with Filter
#declare Grnt19a =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.3 color red 1 green 1 blue 1 filter 0.0 color DimGray filter 0.5]
    [0.3, 0.4 color DimGray filter 0.5 color DimGray filter 0.8]
    [0.4, 1.0 color DimGray filter 0.8 color DimGray filter 0.9]
   }
 }
 finish {
  crand 0.02
 }
 }

//--------- White Feature Viens
#declare Grnt20a =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.2 color red 1 green 1 blue 1 filter 0.0 color red 1 green 1 blue 1 filter 0.7]
    [0.2, 0.3 color red 1 green 1 blue 1 filter 0.7 color Clear]
    [0.3, 1.0 color Clear color Clear]
   }
 }
 finish {
  crand 0.02
 }
 }

//--------- Thinner White Feature Viens
#declare Grnt21a =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.2 color red 1 green 1 blue 1 filter 0.4 color red 1 green 1 blue 1 filter 0.8]
    [0.2, 0.3 color red 1 green 1 blue 1 filter 0.8 color Clear]
    [0.3, 1.0 color Clear color Clear]
   }
 }
 finish {
  crand 0.02
 }
 }

#declare Grnt22a =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.175   color rgbf <1.000, 0.718, 0.541, 0.890>
                    color rgbf <0.843, 0.678, 0.655, 0.753>]
    [0.175, 0.228   color rgbf <0.843, 0.678, 0.655, 0.753>
                    color rgbf <0.906, 0.831, 0.773, 0.98>]
    [0.228, 0.386   color rgbf <0.906, 0.831, 0.773, 0.698>
                    color rgbf <0.992, 0.718, 0.545, 0.794>]
    [0.386, 0.412   color rgbf <0.992, 0.718, 0.545, 0.794>
                    color rgbf <0.333, 0.188, 0.067, 0.784>]
    [0.412, 0.439   color rgbf <0.333, 0.188, 0.067, 0.784>
                    color rgbf <0.925, 0.557, 0.514, 0.778>]
    [0.439, 0.684   color rgbf <0.925, 0.557, 0.514, 0.678>
                    color rgbf <0.984, 0.780, 0.655, 0.696>]
    [0.684, 0.781   color rgbf <0.984, 0.780, 0.655, 0.696>
                    color rgbf <0.965, 0.847, 0.675, 0.880>]
    [0.781, 0.982   color rgbf <0.965, 0.847, 0.675, 0.880>
                    color rgbf <1.000, 0.718, 0.541, 0.990>]
    [0.982, 1.001   color rgbf <1.000, 0.718, 0.541, 0.890>
                    color rgbf <1.000, 0.718, 0.541, 0.890>]
   }
 }
 }

//---------- Transparent Green Moss Colors
#declare Grnt23a =
texture {
pigment
 {granite
  color_map
   {[0.000, 0.168   color rgbf <0.824, 0.725, 0.584, 0.600>
                    color rgbf <0.514, 0.584, 0.533, 0.600>]
    [0.168, 0.301   color rgbf <0.514, 0.584, 0.533, 0.600>
                    color rgbf <0.298, 0.376, 0.318, 0.600>]
    [0.301, 0.398   color rgbf <0.298, 0.376, 0.318, 0.600>
                    color rgbf <0.263, 0.337, 0.282, 0.700>]
    [0.398, 0.558   color rgbf <0.263, 0.337, 0.282, 0.700>
                    color rgbf <0.431, 0.506, 0.451, 0.600>]
    [0.558, 0.655   color rgbf <0.431, 0.506, 0.451, 0.600>
                    color rgbf <0.529, 0.631, 0.471, 0.500>]
    [0.655, 0.735   color rgbf <0.529, 0.631, 0.471, 0.500>
                    color rgbf <0.333, 0.376, 0.318, 0.700>]
    [0.735, 0.823   color rgbf <0.333, 0.376, 0.318, 0.700>
                    color rgbf <0.298, 0.376, 0.318, 0.600>]
    [0.823, 0.876   color rgbf <0.298, 0.376, 0.318, 0.600>
                    color rgbf <0.416, 0.376, 0.318, 0.500>]
    [0.876, 0.929   color rgbf <0.416, 0.376, 0.318, 0.500>
                    color rgbf <0.416, 0.376, 0.318, 0.600>]
    [0.929, 1.001   color rgbf <0.416, 0.376, 0.318, 0.600>
                    color rgbf <0.824, 0.725, 0.584, 0.700>]
   }
 }
 }

#declare Grnt24a =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.053   color rgbf <0.784, 0.627, 0.522, 0.500>
                    color rgbf <0.784, 0.627, 0.624, 0.500>]
    [0.053, 0.263   color rgbf <0.784, 0.627, 0.624, 0.500>
                    color rgbf <0.824, 0.557, 0.376, 0.500>]
    [0.263, 0.281   color rgbf <0.824, 0.557, 0.376, 0.500>
                    color rgbf <0.643, 0.380, 0.376, 0.500>]
    [0.281, 0.325   color rgbf <0.643, 0.380, 0.376, 0.500>
                    color rgbf <0.839, 0.722, 0.722, 0.500>]
    [0.325, 0.711   color rgbf <0.839, 0.722, 0.722, 0.500>
                    color rgbf <0.784, 0.627, 0.522, 0.500>]
    [0.711, 0.798   color rgbf <0.784, 0.627, 0.522, 0.500>
                    color rgbf <0.769, 0.380, 0.376, 0.500>]
    [0.798, 0.895   color rgbf <0.769, 0.380, 0.376, 0.500>
                    color rgbf <0.824, 0.557, 0.376, 0.500>]
    [0.895, 0.982   color rgbf <0.824, 0.557, 0.376, 0.500>
                    color rgbf <0.784, 0.627, 0.522, 0.500>]
    [0.982, 1.001   color rgbf <0.784, 0.627, 0.522, 0.500>
                    color rgbf <0.784, 0.627, 0.522, 0.500>]
   }
 }
 }

/*--------------------Crack & OverTint /Red---------------------*/
#declare Crack1 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
    [0.04, 0.97 color Scarlet filter 0.80 color DimGray filter 0.90]
    [0.97, 1.001 color Black filter 0.9 color Black filter 1.0]
   }
 }
 }

//-----Filter  Dark Cracks
#declare Crack2 =
texture {
pigment
 {granite
  turbulence 0.8
  color_map
   {[0.0, 0.5   color Clear color Clear]
    [0.5, 0.54   color Clear color Black]
    [0.54, 1.0 color Clear color Clear]
   }
 }
 }

//---------- Overtint Green with Black Cracks
#declare Crack3 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
    [0.04, 0.97 color DarkGreen filter 0.80 color DarkGreen filter 0.90]
    [0.97, 1.001 color Black filter 0.9 color Black filter 1.0]
   }
 }
 }

//--------- Overtint with White Crack
#declare Crack4 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.03 color red 1 green 1 blue 1 filter 0.3 color red 1 green 1 blue 1 filter 1.0]
    [0.03, 0.97 color Black filter 0.70 color DimGray filter 0.90]
    [0.97, 1.001 color red 1 green 1 blue 1 filter 0.9 color red 1 green 1 blue 1 filter 1.0]
   }
 }
 }

//-----------------  complete texture statements
//                   Scaled to cover nicely over a 2 unit Cube

//------------- Deep Rose & Green Marble with large White Swirls
#declare Stone1 =
texture{Grnt7  scale <2, 3, 2> rotate <0, 0, 40>}
texture{Grnt0a scale <2, 3, 2> rotate <0, 0,-30>
        finish{phong 1 phong_size 90}
       }

//------------- Light Greenish Tan Marble with Agate style veining
#declare Stone2 =
texture{Grnt0  scale <2, 3, 2> rotate <0, 0, 40>}
texture{Grnt7a scale <1.3, 2, 1.3> rotate <0, 0, -30> rotate <40, 0, 0>
        finish{phong 1.0 phong_size 90 ambient 0.2 }
}

//------------- Rose & Yellow Marble with fog white veining
#declare Stone3 =
texture{Grnt5  scale <2, 3, 2> rotate <0, 0, 40>}
texture{Grnt0a scale <2, 3, 2> rotate <0, 0, -30>
        finish{phong 1.0 phong_size 90}
}

//------------- Tan Marble with Rose patches
#declare Stone4 =
texture{Grnt6   scale <1.5, 3, 2> rotate <0, 0, 40>
        finish{diffuse 0.5}
}
texture{Grnt10a scale <1, 3, 2> rotate <0, 0, -30>
        finish{phong 1.0 phong_size 90}
}

//------------- White Cream Marble with Pink veining
#declare Stone5 =
texture{Grnt12  scale <2, 3, 2> rotate <0, 0, 40>}
texture{Grnt17a scale <2, 3, 2> rotate <0, 0, -30>}
texture{Crack1  scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90 ambient 0.2}
}

//------------- Rose & Yellow Cream Marble
#declare Stone6 =
texture{Grnt18 scale <1.5, 3, 3> rotate <0, 0, 40>}
texture{Grnt19 scale <2, 4, 1.3> rotate <0, 0, 30>
        finish{phong 1.0 phong_size 90}
}
texture{Crack1 scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90 ambient 0.2}
}

//------------- Light Coffee Marble with darker patches
#declare Stone7 =
texture{pigment{color Salmon}}
texture{Grnt6a scale <1, 3, 2> rotate <0, 0, 40>}
texture{Grnt9a scale <3.5, 5, 4> rotate <0, 0, 60>
        finish{phong 1.0 phong_size 90}
}

//------------- Gray Granite with white patches
#declare Stone8 =
texture{pigment{color White}
        finish{ambient 0.4 crand 0.06 diffuse 0.7}
}
texture{Grnt0a scale <2, 3, 2> rotate <0, 0, -30>}
texture{Grnt9a scale <5, 3, 4> rotate <0, 0, 40>
        finish{phong 1.0 ambient 0.2 diffuse 0.5 phong_size 90}
}

//------------- White & Light Blue Marble with light violets
#declare Stone9 =
texture{Grnt9 scale <1.2, 2.4, 1.2> rotate <0, 0, -30> rotate <40, 0, 0>}
texture{Crack1 scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90 ambient 0.2}
}

//------------- Dark Brown & Tan swirl Granite with gray undertones
#declare Stone10 =
texture{pigment{color Black}}
texture{Grnt17a scale <3, 6, 2> rotate <0, 0, 50>}
texture{Grnt3a scale <1, 2, 1> rotate <0, 0, -50>
        finish{phong 1.0 phong_size 90}
}

//------------- Rose & White Marble with dark tan swirl
#declare Stone11 =
texture{pigment{color Black}}
texture{Grnt15a scale <1.2, 3, 1.5> rotate <70, 0, 30>
        finish{crand 0.03}
}
texture{Grnt2a scale <3, 3, 4> rotate <0, 0, 40>}
texture{Crack1 scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- White & Pinkish Tan Marble
#declare Stone12 =
texture{Grnt23 scale <1, 5, 1> rotate <0, 0, 50>
        finish{ambient 0.2 crand 0.03}
}
texture{Grnt0a scale <1, 3, 2> rotate <0, 0, -30>
        finish{phong 1.0 phong_size 90}
}

//------------- Medium Gray Blue Marble
#declare Stone13 =
texture{Grnt24 scale <2, 5, 2> rotate <0, 0, 50>
        finish{ambient 0.2 crand 0.03}
}
texture{Grnt8a scale <1, 3, 2> rotate <0, 0, -30>
        finish{phong 1.0 phong_size 90}
}

//------------- Tan & Olive Marble with gray white veins
#declare Stone14 =
texture{Grnt6 scale <2, 3, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{Grnt19a scale <1, 3, 1> rotate <0, 0, 40>
        finish{phong 1.0 phong_size 90}
}

//------------- Deep Gray Marble with white veining
#declare Stone15 =
texture{Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{Grnt8a scale <1, 2, 1> rotate <0, 0, 40>
        finish{phong 1.0 phong_size 90}
}

//------------- Peach & Yellow Marble with white veining
#declare Stone16 =
texture{Grnt18 scale <1.3, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{Grnt19 scale <2, 4, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{Grnt20a scale <1, 2, 1> rotate <0, 0, 40>
        finish{phong 1.0 phong_size 90}
}

//------------- White Marble with gray veining
#declare Stone17 =
texture{Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
//texture{Grnt8a scale <2.5, 4.5, 3.5> rotate <0, 0, 40>
//        finish{phong 1.0 phong_size 90}
//}
texture{Crack3 scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- Green Jade with white veining
#declare Stone18 =
texture{pigment{color SeaGreen}
        finish{ambient 0.3 diffuse 0.6 crand 0.03}
}
texture{Grnt22 scale <1.5, 0.7, 0.5> rotate <0, 0, 40>}
texture{Grnt20a scale <2.5, 2, 0.5> rotate <0, 0, -50>}
texture{Crack4 scale <0.7, 1, 1> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- Peach Granite with white patches & green trim
#declare Stone19 =
texture{Grnt26 scale <1, 0.7, 0.5> rotate <0, 0, 40>}
texture{Grnt20a scale <2, 3, 1> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- Brown & Olive Marble with white veining
#declare Stone20 =
texture{Grnt27 scale <0.7, 0.99, 0.7> rotate <0, 0, 40>}
texture{Grnt12a scale <1, 1.3, 2> rotate <0, 0, 40>}
texture{Grnt20a scale <1.9, 3, 0.5> rotate <0, 0, -50>}
texture{Crack1 scale <1, 0.6, 1> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- Red Marble with gray & white veining
#declare Stone21 =
texture{Grnt28 scale <1.3, 2.5, 1.7> rotate <0, 0, 40>}
texture{Grnt22 scale <1, 2, 2> rotate <0, 0, 40>}
texture{Crack4 scale <1, 0.6, 1> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- Dark Tan Marble with gray & white veining
#declare Stone22 =
texture{pigment{color Feldspar}}
texture{Grnt8a scale <1, 2, 2> rotate <0, 0, 40>}
texture{Grnt22 scale <2, 4, 1.5> rotate <0, 0, -50>}
texture{Crack4 scale <1, 1, 1> rotate <10, 0, -40>
        finish{phong 1.0 phong_size 90}
}

//------------- Peach & Cream Marble with orange veining
#declare Stone23 =
texture{Grnt29 scale <1, 1, 2> rotate <40, 0, 0> rotate <0, 0, 30>}
texture{Grnt24a scale <2, 1, 2> rotate <40, 0, 0> rotate <0, 0, 30>}
texture{Crack1 scale <1, 2, 1.5> rotate <0, 0, 40>}
texture{pigment{color Yellow filter 0.9}
        finish{phong 1.0 phong_size 90}  // tint to liking
}

//------------- Green & Tan Moss Marble
#declare Stone24 =
texture{Grnt25 scale <1, 1, 2> rotate <0, 0, 50> rotate <20, 0, 30>}
texture{Grnt23a scale <2, 1, 2> rotate <40, 0, 0> rotate <0, 0, -30>}
texture{pigment{color Gray filter 0.8}
        finish{phong 1.0 phong_size 90} //   tint to liking
}

