#include "colors.inc"
#include "textures.inc" 
#include "metals.inc"  
#include "woods.inc" 
#include "EverMan.inc"

camera 
	{
	location <0,0,0> 
	look_at <0,0,1>
	translate Cam_Translate
	rotate Cam_Rotate 
	}
	
light_source {<0,100,-100>color White}
light_source {<0,0,-2>color White}

#declare Background =
	sphere
		{
		0,150000
		pigment 
			{
			bozo
			color_map
				{
				[0.0 color rgbt <0,0,1,1>]
				[.35 color rgbt <0,0,1,.75>]
				[.5 color rgbt <.45,0,1,.7>]
				[.65 color rgbt <0,0,1,.75>]
				[1.0 color rgbt <0,0,1,1>]
				} 
			turbulence 1/3
			lambda 3                         
			frequency 2
			scale 100000
			}                        
		normal {bumps 2}
		finish {Luminous specular .5 roughness .001}
		hollow
		}
			
#declare Sun = 
	union
		{
		sphere
			{
			0,1
			pigment {rgbt <1,1,1,1>}
			halo
				{
				emitting
				spherical_mapping
				linear
				color_map
					{
					[0.0 color rgbt<1,0,0,1>]
					[1.0 color rgbt<1,1,0,-1>]
					}                        
				samples 10
				}         
			hollow                                   
			scale 1.5
			}
		light_source
			{
			<0,0,0>
			color Yellow
			spotlight
			point_at <0,-20,0>
			radius 10
			falloff 20
			tightness 1
			}
		}  

#declare Ones =
	box {<-.125,-.35,-1><.125,.35,-.225> scale <.25,.25,1>}
	
#declare Fives =
	intersection
		{  
		union
			{
			box {<-.0625,-1,-1><.0625,1,-.225> rotate <0,0,15>}
			box {<-.0625,-1,-1><.0625,1,-.225> rotate <0,0,-15>}
			} 
		box {<-10,0,-10><10,.7,10>}
		translate <0,-.35,0>
		scale <.25,.25,1>
		} 
		
#declare Tens =
	intersection
		{
		union
			{
			box {<-.0625,-1,-1><.0625,1,-.225> rotate <0,0,30>}
			box {<-.0625,-1,-1><.0625,1,-.225> rotate <0,0,-30>}
			} 
		box {<-10,-.35,-10><10,.35,10>} 
		scale <.25,.25,1>
		}
	
#declare One =
	object {Ones}

#declare Two =
	union
		{
		object {Ones translate <-1/24,0,0>}
		object {Ones translate <1/24,0,0>}
		}

#declare Three =
	union
		{
		object {Ones translate <-1/12,0,0>}  
		object {Ones translate <0,0,0>}
		object {Ones translate <1/12,0,0>}
		}
		
#declare Four =
	union
		{
		object {Ones translate <-1/24,0,0>}
		object {Fives translate <1/24,0,0>}
		}                
		
#declare Five =
	object {Fives}

#declare Six =
	union
		{
		object {Ones translate <1/24,0,0>}
		object {Fives translate <-1/24,0,0>}
		}                                         
		
#declare Seven =
	union
		{
		object {Ones translate <1/12,0,0>}
		object {Ones translate <0,0,0>}
		object {Fives translate <-1/12,0,0>}
		} 
		
#declare Eight =
	union
		{
		object {Ones translate <1/12,0,0>}
		object {Ones translate <1/24,0,0>}
		object {Ones translate <-1/24,0,0>}
		object {Fives translate <-1/12,0,0>}
		}
		
#declare Nine =
	union
		{
		object {Ones translate <-1/24,0,0>}
		object {Tens translate <1/24,0,0>}
		}                                 
		
#declare Ten =
	object {Tens}
	
#declare Eleven = 
	union
		{
		object {Tens translate <-1/24,0,0>}
		object {Ones translate <1/24,0,0>}
		} 
		
#declare Twelve = 
	union
		{
		object {Tens translate <-1/12,0,0>}  
		object {Ones translate <0,0,0>}
		object {Ones translate <1/12,0,0>}
		}
		
#declare Dial = 
	intersection
		{
		box {<-.125,-.9999,-10><.125,0,0>}
		box {<-.5,-10,-.5><.5,10,10> rotate <-30,0,0>}
		}
	
					
#declare SunDial =
	union
		{
		difference
			{
			cylinder {<0,0,-.25><0,0,0>1} 
			object {One rotate <0,0,30> 
					translate <0,.8,0> rotate <0,0,-30>}
			object {Two rotate <0,0,60> 
					translate <0,.8,0> rotate <0,0,-60>}
			object {Three rotate <0,0,90> 
					translate <0,.8,0> rotate <0,0,-90>}
			object {Four rotate <0,0,120>
					translate <0,.8,0> rotate <0,0,-120>}
			object {Five rotate <0,0,150>
					translate <0,.8,0> rotate <0,0,-150>}
			object {Six rotate <0,0,180>
					translate <0,.8,0> rotate <0,0,-180>}
			object {Seven rotate <0,0,210>
					translate <0,.8,0> rotate <0,0,-210>}
			object {Eight rotate <0,0,240>
					translate <0,.8,0> rotate <0,0,-240>}
			object {Nine rotate <0,0,270>
					translate <0,.8,0> rotate <0,0,-270>}
			object {Ten rotate <0,0,300>
					translate <0,.8,0> rotate <0,0,-300>}
			object {Eleven rotate <0,0,330>
					translate <0,.8,0> rotate <0,0,-330>}
			object {Twelve translate <0,.8,0>}
			}
		object {Dial translate <0,0,-.0625>}
		texture
			{
			onion
			texture_map
				{
				[0.0 pigment {rgb <.92,.78,.62>}]
				[1.0 pigment {rgb <.92,.78,.62>}
					 normal {crackle .5 scale .1}]
				}     
			frequency .5
			scale 2
			}
		}
		
#declare HGBase =	
	sphere 
		{
		<0,0,0>1	//texture borrowed from T_Wood34 in         
		texture     //Woods.Inc
			{
		    pigment 
		    	{
		        onion
		        turbulence 0.2125
		        color_map 
		        	{
		            [0.225 color rgb <1.000000, 0.53333, 0.11767>]
		            [0.350 color rgb <0.662750, 0.28617, 0.00001>]
		            [0.500 color rgb <1.000100, 0.53333, 0.11765>]
		            [0.625 color rgb <0.662775, 0.28627, 0.00005>]
		            [0.750 color rgb <1.000200, 0.53333, 0.11755>]
		            [0.875 color rgb <0.662755, 0.28629, 0.00001>]
		            [1.000 color rgb <1.000000, 0.53333, 0.11665>]
		        	}
		        scale <0.225, 0.20, 1.15>
		        rotate <0,90,0>
		    	}              
		    finish {specular 1}
		    }
		scale <.75,.1,.75>
		}                             
		
#declare HalfGlassTop =                        
	intersection
		{
		merge
			{
			sphere {<0,0,0>1 scale <.5,.5,.5> translate <0,.75,0>}
			cone {<0,.75,0>.5<0,.05,0>.05}
			cylinder {<0,.1,0><0,-.1,0>.05}
			hollow
			}
		box {<-10,0,-10><10,1,10>}
		texture 
			{
			pigment {rgbt <0,0,0,.9>}
			finish 
				{
				specular 1 
				roughness .01 
				refraction 1
				ior 1.25
				reflection .2
				}
			}
		}
		
#declare HalfGlassBottom =                        
	intersection
		{
		merge
			{
			sphere {<0,0,0>1 scale <.5,.5,.5> translate <0,.75,0>}
			cone {<0,.75,0>.5<0,.05,0>.05}
			cylinder {<0,.1,0><0,-.1,0>.05}
			hollow
			}
		box {<-10,0,-10><10,1,10>}
		texture 
			{
			pigment {rgbt <0,0,0,.9>}
			finish 
				{
				specular 1 
				roughness .01 
				refraction 1
				ior 1.25
				reflection .2
				}
			}
		rotate <180,0,0>
		}               
		
#declare SandTop =
	difference
		{                
		intersection
			{
			merge
				{
				sphere {<0,0,0>1 scale <.475,.475,.475> translate <0,.75,0>}
				cone {<0,.75,0>.475<0,.05,0>.025}
				cylinder {<0,.1,0><0,-.1,0>.025}
				hollow
				}
			box {<-10,0,-10><10,1,10>}          
			}
		sphere {<0,0,0>1 scale <.75,1,.75> translate <0,1.3,0>}
		pigment {NewTan}
		normal {bozo 1 scale .01}
		}
	
#declare SandBottom = 
	union
		{
		intersection
			{                
			intersection
				{
				merge
					{
					sphere {<0,0,0>1 scale <.475,.475,.475> translate <0,.75,0>}
					cone {<0,.75,0>.475<0,.05,0>.025}
					cylinder {<0,.1,0><0,-.1,0>.025}
					hollow
					}
				box {<-10,0,-10><10,1,10>}          
				}
			sphere {<0,0,0>1 scale <.5,1,.5> translate <0,1.6,0>}
			}
		cylinder {<0,-.1,0><0,.75,0>.025
				pigment {NewTan}
				normal {bozo 1 scale <.01,.12,.01>}
				no_shadow}
		pigment {NewTan}
		normal {bozo 1 scale .01}
		rotate <180,0,0>
		} 
		
#declare SpireSphere =
	sphere {<0,0,0>1 scale <.05,.1,.05> rotate <0,0,30>}
	         
	        
#declare Spire =           
	intersection
		{   
		#declare Index = -1
		union
			{
			#while (Index <= 1)
				object {SpireSphere translate <0,Index,0>}
				#declare Index = Index + .1  
			#end
			}
		box {<-10,-1,-10><10,1,10>}
		texture     //Woods.Inc
			{
		    pigment 
		    	{
		        onion
		        turbulence 0.2125
		        color_map 
		        	{
		            [0.225 color rgb <1.000000, 0.53333, 0.11767>]
		            [0.350 color rgb <0.662750, 0.28617, 0.00001>]
		            [0.500 color rgb <1.000100, 0.53333, 0.11765>]
		            [0.625 color rgb <0.662775, 0.28627, 0.00005>]
		            [0.750 color rgb <1.000200, 0.53333, 0.11755>]
		            [0.875 color rgb <0.662755, 0.28629, 0.00001>]
		            [1.000 color rgb <1.000000, 0.53333, 0.11665>]
		        	}
		        scale <0.225, 0.20, 1.15>
		 		rotate <0,90,0> rotate <90,0,0>
		    	}              
		    finish {specular 1} 
		    
		    }
		}
		
#declare HourGlass =
	union
		{ 
		object {HGBase translate <0,1,0>}
		object {HGBase translate <0,-1,0>}
		object {HalfGlassTop}
		object {SandTop}
		object {HalfGlassBottom}
		object {SandBottom}                 
		object {Spire translate <0,0,.65>}
		object {Spire translate <0,0,.65> rotate <0,120,0>}
		object {Spire translate <0,0,.65> rotate <0,-120,0>}
		}   
		
#declare MottledGold = 
	pigment 
		{
		bozo             
		color_map
			{
			[0.0 rgb <.72,.57,.18>]
			[1.0 rgb <.77,.62,.31>]
			}
		scale .1                      
		}


#declare BlackRubber =
	texture 
		{
		pigment {Gray05}
		finish {specular .5}
		}
		
#declare Clock1 = text {ttf "timrom.ttf" "1" .2,0 translate <-.1875,-.25,0> scale <.2,.2,1>}
#declare Clock2 = text {ttf "timrom.ttf" "2" .2,0 translate <-.1875,-.25,0> scale <.2,.2,1>}
#declare Clock3 = text {ttf "timrom.ttf" "3" .2,0 translate <-.1875,-.25,0> scale <.2,.2,1>}
#declare Clock4 = text {ttf "timrom.ttf" "4" .2,0 translate <-.1875,-.25,0> scale <.2,.2,1>}
#declare Clock5 = text {ttf "timrom.ttf" "5" .2,0 translate <-.1875,-.25,0> scale <.2,.2,1>}
#declare Clock6 = text {ttf "timrom.ttf" "6" .2,0 translate <-.1875,-.25,0> scale <.2,.2,1>}
#declare Clock7 = text {ttf "timrom.ttf" "7" .2,0 translate <-.1875,-.25,0> scale <.2,.2,1>}
#declare Clock8 = text {ttf "timrom.ttf" "8" .2,0 translate <-.1875,-.25,0> scale <.2,.2,1>}
#declare Clock9 = text {ttf "timrom.ttf" "9" .2,0 translate <-.1875,-.25,0> scale <.2,.2,1>}
#declare Clock10 = text {ttf "timrom.ttf" "10" .2,0 translate <-.375,-.25,0> scale <.2,.2,1>}
#declare Clock11 = text {ttf "timrom.ttf" "11" .2,0 translate <-.375,-.25,0> scale <.2,.2,1>}
#declare Clock12 = text {ttf "timrom.ttf" "12" .2,0 translate <-.375,-.25,0> scale <.2,.2,1>}                 
		
#declare ClockFace =
	union
		{
		sphere {<0,0,0>1 scale <.75,.75,.1> 
				pigment {Gray95} finish {specular 1 roughness .001 reflection .15}}
		union
			{
			object {Clock1 rotate <0,0,30>
					translate <0,.55,0> rotate <0,0,-30>}
			object {Clock2 rotate <0,0,60>
					translate <0,.55,0> rotate <0,0,-60>}
			object {Clock3 rotate <0,0,90>
					translate <0,.55,0> rotate <0,0,-90>}
			object {Clock4 rotate <0,0,120>
					translate <0,.55,0> rotate <0,0,-120>}
			object {Clock5 rotate <0,0,150>
					translate <0,.55,0> rotate <0,0,-150>}
			object {Clock6 rotate <0,0,180>
					translate <0,.55,0> rotate <0,0,-180>}
			object {Clock7 rotate <0,0,210>
					translate <0,.55,0> rotate <0,0,-210>}
			object {Clock8 rotate <0,0,240>
					translate <0,.55,0> rotate <0,0,-240>}
			object {Clock9 rotate <0,0,270>
					translate <0,.55,0> rotate <0,0,-270>}
			object {Clock10 rotate <0,0,300>
					translate <0,.55,0> rotate <0,0,-300>}
			object {Clock11 rotate <0,0,330>
					translate <0,.55,0> rotate <0,0,-330>}
			object {Clock12 translate <0,.55,0>} 
			translate <0,0,-.1>
			texture {BlackRubber}
			}
		}                                            
		
#declare ClockGlass =
	sphere {<0,0,0>1 scale <.75,.75,.2>
			pigment {rgbt <0,0,0,.9>}
			finish {specular 1 roughness .001
					refraction 1 ior 1.25 reflection .2}}
					
#declare ClockMount =                                               
	intersection
		{
		sphere {<0,0,0>1 scale <1,1,.2> translate <0,0,.125>}
		box {<-10,-10,0><10,10,.25>}
		pigment {MottledGold}
		finish {specular 1 roughness .01 reflection .2 metallic} 
		}                 
		
#declare Focault =
	union
		{
		cone {<0,0,0>.1<0,0,-.1>.05}
		cone {<0,0,-.15>.025<0,0,-.2>0}
		texture {BlackRubber}
		}           
		
#declare BigHand =
	union	
		{
		difference
			{
			cylinder {<0,0,-.15><0,0,-.1>.125/2}
			cylinder {<0,0,-10><0,0,10>.1/2}   
			scale <.5,1,1>
			translate <.1375/4,.15,0>
			}
		difference
			{
			cylinder {<0,0,-.15><0,0,-.1>.125/2}
			cylinder {<0,0,-10><0,0,10>.1/2} 
			scale <.5,1,1>
			translate <-.1375/4,.15,0>
			}
		difference
			{
			box {<-.125,0,-.15><.125,.55,-.1>}
			cylinder {<0,0,-10><0,0,10>.125 scale <1,2,1> translate <.1375,.275,0>}
			cylinder {<0,0,-10><0,0,10>.125 scale <1,2,1> translate <-.1375,.275,0>}
			cylinder {<0,0,-10><0,0,10>.125 translate <.125,.55,0>}
			cylinder {<0,0,-10><0,0,10>.125 translate <-.125,.55,0>}
			cylinder {<0,0,-10><0,0,10>.125 translate <.1375,0,0>}
			cylinder {<0,0,-10><0,0,10>.125 translate <-.1375,0,0>}
			}                          
		scale <1,1.25,1>
		translate <0,-.1,0>
		texture {BlackRubber}
		}                          
		
#declare LittleHand =
	object {BigHand scale .75}
	
#declare ClockKnob =
	union
		{
		cylinder {<0,.95,.125><0,1.1,.125>.125 
				pigment {MottledGold}
				normal {gradient <0,1,0> scale .1}
				finish {specular 1 roughness .01 reflection .2 metallic}}
		cylinder {<0,1.05,.125><0,1.15,.125>.2 
				pigment {MottledGold}
				normal {radial 1 frequency 24 rotate <90,0,0>}
				finish {specular 1 roughness .01 reflection .2 metallic}}
		}                                 
		
#declare Link1 =
	union
		{
		intersection
			{
			torus {1/32,1/64 rotate <90,0,0>}
			box {<-1,0,-1><1,1,1>} 
			translate <0,1/32,0>
			}
		intersection
			{
			torus {1/32,1/64 rotate <90,0,0>}
			box {<-1,-1,-1><1,0,1>} 
			translate <0,-1/32,0>
			}                   
		cylinder {<1/32,-1/32,0><1/32,1/32,0>1/64}
		cylinder {<-1/32,-1/32,0><-1/32,1/32,0>1/64}
		}                                                       
		
#declare Link2 =
	object {Link1 rotate <0,90,0>}
	
#declare StraightChain1 =
	union
		{                             
		#declare Move1 = 1.1
		#while (Move1 >= -1.2)
		object {Link1 translate <0,Move1,0>}
		#declare Move1 = Move1 - 6/64
		object {Link2 translate <0,Move1,0>}
		#declare Move1 = Move1 - 6/64
		#end
		}
		
#declare StraightChain2 =
	union
		{                       
		#declare Move1 = -1.1
		#while (Move1 <= 0)
		object {Link1 translate <0,Move1,0>}
		#declare Move1 = Move1 + 6/64
		object {Link2 translate <0,Move1,0>}
		#declare Move1 = Move1 + 6/64
		#end
		}             
		
#declare CurvedChain =
	union
		{
		#declare Rot1 = 0
		#while (Rot1 <= 180)
		object {Link1 translate <-1.1/2,0,0> rotate <0,0,Rot1>}
		#declare Rot1 = Rot1 + 10
		object {Link2 translate <-1.1/2,0,0> rotate <0,0,Rot1>}
		#declare Rot1 = Rot1 + 10
		#end
		}               
		
#declare Chain =
	union
		{
		object {StraightChain1 translate <0,0,.325>} 
		object {CurvedChain translate <1.1/2,-1.2,.325> translate <0,-6/64,0>}
		object {StraightChain2 translate <1.1,0,.325>}
		pigment {MottledGold}
		finish {specular 1 roughness .01 reflection .2 metallic}
		}
		
#declare Clock =
	union
		{
		object {ClockFace}
		object {ClockGlass} 
		object {ClockMount}
		object {Focault}                    
		object {BigHand rotate <0,0,-345>}      
		object {LittleHand rotate <0,0,-330>}
		object {ClockKnob}
		object {ClockKnob rotate <0,0,-90>}                     
		object {Chain}
		}  
		
#declare GreenRubber =
	texture
		{
		pigment {rgb <0,1,.5>}
		finish {specular .5}
		}                   
		
#declare PlasticBrass =
	texture
		{
		pigment 
			{
			bozo
			color_map
				{
				[0.0 color rgb <.8,.3,.1>]
				[1.0 color rgb <.9,.5,.02>]
				} 
			turbulence 2
			scale .1
			}                             
		normal {crackle .1 scale .001} 
		finish {specular 1 roughness .01}
		}
		
#declare WatchFront =
	difference
		{  
		union
			{
			intersection
				{
				sphere {<0,0,0>1 translate <0,0,.25>}
				box {<-2,-2,-.25><2,2,0>}
				sphere {<0,0,0>1 scale <1.1,1.1,2> translate <0,0,-1.75> 
								 scale <1.1,1.1,2> inverse} 
				} 
			intersection
				{
				box {<.75,-.2,-.225><1.05,.2,.25>}
				box {<-2,-2,-2><2,.2,2> rotate <0,0,-5>}
				box {<-2,-.2,-2><2,2,2> rotate <0,0,5>}
				}             
			intersection
				{
				box {<.75,-.2,-.225><1.05,.2,.25>}
				box {<-2,-2,-2><2,.2,2> rotate <0,0,-5>}
				box {<-2,-.2,-2><2,2,2> rotate <0,0,5>}
				scale <1,1.5,1> rotate <0,0,-150>
				} 
			intersection
				{
				sphere {<0,0,0>1 translate <0,0,.25>}
				box {<-2,-2,-.25><2,2,0>} 
				box {<-2,-2,-2><2,-.5,2>} 
				box {<-.5,-2,-2><2,2,2> rotate <0,0,-30> translate <.25,-.5,0>}
				box {<-2,-2,-2><.5,2,2> rotate <0,0,30> translate <-.25,-.5,0>}
				box {<-2,-2,-2><2,-.75,-.2> inverse}  
				box {<-.3,-2,-2><-.05,-.6,-.05> inverse}
				box {<.3,-2,-2><.05,-.6,-.05> inverse}
				}
			union
				{
				cylinder {<0,0,-.225><0,0,0>.15 translate <0,.85,0> rotate <0,0,30>}
				cylinder {<0,0,-.225><0,0,0>.15 translate <0,.85,0> rotate <0,0,-30>}
				cylinder {<0,0,-.225><0,0,0>.15 translate <0,-.95,0> rotate <0,0,30>}
				cylinder {<0,0,-.225><0,0,0>.15 translate <0,-.95,0> rotate <0,0,-30>}
				}
				    
			}
		union
			{
			sphere {<0,0,-.225>.1 translate <0,.85,0> rotate <0,0,30>}
			sphere {<0,0,-.225>.1 translate <0,.85,0> rotate <0,0,-30>}
			sphere {<0,0,-.225>.1 translate <0,-.95,0> rotate <0,0,30>}
			sphere {<0,0,-.225>.1 translate <0,-.95,0> rotate <0,0,-30>}
			}
		texture {BlackRubber}
		} 
		
#declare WatchButtons = 
	union
		{
		intersection
			{
			sphere {<0,0,0>1 translate <0,0,.25>}
			box {<-2,-2,-.25><2,2,.25>} 
			box {<-2,-2,-2><2,-.5,2>} 
			box {<-.5,-2,-2><2,2,2> rotate <0,0,-30> translate <.25,-.5,0>}
			box {<-2,-2,-2><.5,2,2> rotate <0,0,30> translate <-.25,-.5,0>}
			box {<-2,-2,-2><2,-.75,-.2> inverse}  
			box {<-.3,-2,-2><-.05,-.6,-.05>}
			}
		intersection
			{
			sphere {<0,0,0>1 translate <0,0,.25>}
			box {<-2,-2,-.25><2,2,.25>} 
			box {<-2,-2,-2><2,-.5,2>} 
			box {<-.5,-2,-2><2,2,2> rotate <0,0,-30> translate <.25,-.5,0>}
			box {<-2,-2,-2><.5,2,2> rotate <0,0,30> translate <-.25,-.5,0>}
			box {<-2,-2,-2><2,-.75,-.2> inverse}  
			box {<.3,-2,-2><.05,-.6,-.05>}
			}
		translate <0,0,-.175>
		texture {GreenRubber}
		}
		
#declare WatchScrews =
	union
		{   
		sphere {<0,0,-.15>.075 translate <0,.85,0> rotate <0,0,30>}
		sphere {<0,0,-.15>.075 translate <0,.85,0> rotate <0,0,-30>}
		sphere {<0,0,-.15>.075 translate <0,-.95,0> rotate <0,0,30>}
		sphere {<0,0,-.15>.075 translate <0,-.95,0> rotate <0,0,-30>}
		texture {PlasticBrass}
		}   
		
#declare TimeTexture =
	texture
		{
		pigment {image_map {gif "Timex2.Gif"}}                   
		finish {ambient .5}
		translate <-.5,-.5,-.5>
		scale 1.5
		}
		
#declare WatchBack =
	intersection
		{
		sphere {<0,0,0>1 scale <1.1,1.1,.25> texture {PlasticBrass}}
		box {<-2,-2,-.125><2,2,2> texture {TimeTexture}}
		translate <0,0,.125>
		}                 
		
#declare WatchFilter =
	disc
		{
		<0,0,0><0,0,-1>.7
		pigment 
			{
			image_map
				{
				gif "timex1.gif"
				transmit 255,1
				}
			translate <-.5,-.5,-.5> 
			scale 1.5
			}                 
		translate <0,0,-.2>
		} 
		
#declare WatchGlass =
	disc
		{
		<0,0,0><0,0,-1>.7
		pigment {rgbt <0,0,0,.95>}
		finish {specular 1 roughness .001 refraction 1 ior 1.05 reflection .15}
		translate <0,0,-.25> 
		}
		
#declare Watch =
	union
		{
		object {WatchFront}  
		object {WatchButtons}
		object {WatchScrews}    
		object {WatchBack} 
		object {WatchFilter}
		object {WatchGlass}
		}

#declare Mult = .75
		
#declare TanSkin =
	texture
		{
		pigment
			{            
			color rgb <.89,.58,.33>  
			}
		finish
			{              
			ambient .2
			specular .6 
			roughness .075
			}
		}

#declare HairTexture2 =
	texture
		{
		pigment {NewTan}     
		normal {ripples .2 frequency 4}  
		finish {specular 1}
		}
				
declare Tooth =
	intersection
		{
		sphere {<0,0,0>,1 scale <.25,.25,.01>}
		sphere {<0,0,0>,1 translate <0,1,0>}
		pigment {White} normal {wrinkles .2} finish {specular 1 roughness .01 ambient .5}
		}			                        

#declare ToothSet =
	union
		{                          
		object {Tooth
				translate <0,0,-1>
				rotate <0,5,0>}
		object {Tooth
				translate <0,0,-1>
				rotate <0,10,0>}
		object {Tooth
				translate <0,0,-1>
				rotate <0,15,0>}
		object {Tooth
				translate <0,0,-1>
				rotate <0,-15,0>}
		object {Tooth
				translate <0,0,-1>
				rotate <0,-10,0>}
		object {Tooth
				translate <0,0,-1>
				rotate <0,-5,0>}
		}                           
		
#declare EyeBall =                                                      
	union
		{
		sphere {<0,0,0>,.5 hollow
				pigment 
					{ 
					color rgbt <.9,.9,.9,.5>
					}
				finish
					{
					specular 1
					roughness .001
					reflection .1
					ambient .75
					}
				}                          
		sphere {<0,0,0>,.4999 hollow
				pigment
					{
					color rgbt <.9,.9,.9,.5>
					}          
				finish
					{
					ambient .75  
					specular 1
					roughness .001
					reflection .1
					}         
				}               
		disc
			{
			<0,0,0><0,0,-1>,.075,0
			translate <0,0,-.4999>
			pigment
				{
				Black
				}    
			finish
				{
				specular 1
				roughness .001
				}
			}                   
		sphere
			{
			<0,0,0>,1
			scale <.2,.2,.001>
			pigment
				{
				radial
				color_map
					{
					[0.0 rgbt <.36,.20,.59,.5>]
					[.45 rgbt <.36,.20,.59,.5>]
					[0.5 rgbt <.75,.9,.75,.5>] 
					[.55 rgbt <.36,.20,.59,.5>]
					[1.0 rgbt <.36,.20,.59,.5>]
					}          
				turbulence .01
				frequency 100                   
				rotate <-90,0,0>
				}                              
			finish
				{
				specular 1
				roughness .001
				reflection .2
				} 
			translate <0,0,-.5>
			}
		}
		
#declare Lash =
	intersection
		{  
		torus {1,.01 rotate <90,0,0>}
		box {<2,-.1,2><.975,.1,-2>}
		translate <-1,0,0>
		texture {HairTexture2}
		}

#declare LeftArch = 0
		
#declare LeftEyeBrow =
	union
		{                                    
		#declare Count = 0
		#while (Count < 1)
		object {Lash rotate <0,0,-15 - 30*Count> scale <1,1.5-Count,1> 
				translate <Count,Count/5,0>
				#if (Count < .3)
				 translate <0,Count - .3,0>
				#else
				 translate <0,LeftArch,0>
				#end
				#if (Count > .5)
				 translate <0,0,(Count-.5)/2>
				#end}
		#declare Count = Count + .025
		#end                
		no_shadow            
		scale <1,.5,1>
		}                                
		
#declare RightArch = 0
#declare RightEyeBrow =
	union
		{                                    
		#declare Count = 0
		#while (Count < 1)
		object {Lash rotate <0,0,-15 - 30*Count> scale <1,1.5-Count,1> 
				translate <Count,Count/5,0>
				#if (Count < .3)
				 translate <0,Count - .3,0>
				#else
				 translate <0,RightArch,0>
				#end
				#if (Count > .5)
				 translate <0,0,-(Count-.5)/2>
				#end}
		#declare Count = Count + .025
		#end                
		no_shadow            
		scale <1,.5,1>             
		rotate <0,180,0>
		}
		
#declare Eyelid =
	intersection
		{
		sphere
			{
			<0,0,0>,.53
			texture {TanSkin}
			}          
		box
			{
			<-1,0,-1><1,1,1>
			pigment {Black}
			finish {specular 1 roughness .001}
			}	
		}              
		
#declare HumanHead =
		union
			{
				blob
					{
					threshold .25 
/****************************************Head************************************************/
					//Main Head Sphere
					sphere {<0,0,0>,1,1 scale<3.25,4,4>*Mult translate <0,3,0>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate}
					//Secondary Head Sphere
					sphere {<0,0,0>,1,1 scale<2.75,2.75,3.5>*Mult translate <0,2,0>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Frontal Sphere
					sphere {<0,0,0>,1,1 scale(<1.5,1.5,.75>+(<0,abs(Jaw_Rotate.x/50),0>))*Mult 
							rotate <-30,0,0> translate <0,1-(abs(Jaw_Rotate.x/60)),-1.15>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }  
					//Left Cheek
					sphere {<0,0,0>,1,1.75 scale(<1.75,2.5,3>+(<0,abs(Jaw_Rotate.x/50),0>))*Mult 
							rotate <0,0,-15> translate <.25,1.375-(abs(Jaw_Rotate.x/60)),-.3>
					 		rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Right Cheek
					sphere {<0,0,0>,1,1.75 scale(<1.75,2.5,3>+(<0,abs(Jaw_Rotate.x/50),0>))*Mult 
							rotate <0,0,15> translate <-.25,1.375-(abs(Jaw_Rotate.x/60)),-.3>
					 		rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }	  
					// Left Jaw Bone
					cylinder {<.9,0,0><.05,-.5,-1.75>,.5,1 scale <1.25,1.35,1.35>*Mult 
							rotate Jaw_Rotate - <2.5,0,0> translate <0,1,0> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Right Jaw Bone
					cylinder {<-.9,0,0><-.05,-.5,-1.75>,.5,1 scale <1.25,1.35,1.35>*Mult 
							rotate Jaw_Rotate - <2.5,0,0> translate <0,1,0> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Mouth, Left Half
					sphere {<0,0,0>1,-1 scale(<.7,(.1+abs(Jaw_Rotate.x/30)),1+(abs(Jaw_Rotate.x/2))>)*Mult 
							#if (Smile)
							 scale <1.5,1,1> rotate <0,0,15> translate <.15,0,0>
							#end
							translate <.1-abs(Jaw_Rotate.x/200),1-abs(Jaw_Rotate.x/60),-2.65>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Mouth, Right Half
					sphere {<0,0,0>1,-1 scale(<.7,(.1+abs(Jaw_Rotate.x/30)),1+(abs(Jaw_Rotate.x/2))>)*Mult
							#if (Smile)
							 scale <1.5,1,1> rotate <0,0,-15> translate <-.15,0,0>
							#end
							translate <-.1+abs(Jaw_Rotate.x/200),1-abs(Jaw_Rotate.x/60),-2.65>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Depression below nose
					cylinder {<0,0,0><0,-4,0>,1*Mult,-1 scale <5/32,1/16,2/8> 
							translate <0,1.45,-2.375>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Bridge of Nose
					cylinder {<0,0,0><0,-4,0>,1*Mult,1 rotate <1.25,0,0> scale <6/16,1/4,1.1> rotate <13.75,0,0>
							translate <0,2.5,-1.5>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Left Nostril
					sphere {<0,0,0>,1,1 scale <.3,.3,.3>*Mult translate <.1,1.675,-2.125>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Right Nostril 
					sphere {<0,0,0>,1,1 scale <.3,.3,.3>*Mult translate <-.1,1.675,-2.125>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Left Occular Cavity
					sphere {<0,0,0>1,-1 scale <2,.35,.5>*Mult 
							translate <1.5,2.5,-2.125> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Right Occular Cavity
					sphere {<0,0,0>1,-1 scale <2,.35,.5>*Mult 
							translate <-1.5,2.5,-2.125> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Left Ear
					sphere {<0,0,0>1,1 scale <.5,1.45,.75>*Mult
							rotate <15,10,-15> translate <1.65,2,0> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					sphere {<0,0,0>1,-1 scale <.675,1.15,.65>*Mult
							rotate <15,10,-15> translate <1.85,2,0> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					sphere {<0,0,0>1,-1 scale <.7,.75,.6>*Mult
							rotate <15,10,-15> translate <1.85,1.9,-.1> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					sphere {<0,0,0>1,-1 scale <.75,.3,.3>*Mult
							rotate <0,15,-15> translate <1.85,1.75,-.25> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Right Ear
					sphere {<0,0,0>1,1 scale <.5,1.45,.75>*Mult
							rotate <15,-10,15> translate <-1.65,2,0> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					sphere {<0,0,0>1,-1 scale <.675,1.15,.65>*Mult
							rotate <15,-10,15> translate <-1.85,2,0> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					sphere {<0,0,0>1,-1 scale <.7,.75,.6>*Mult
							rotate <15,-10,15> translate <-1.85,1.9,-.1> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					sphere {<0,0,0>1,-1 scale <.75,.3,.3>*Mult
							rotate <0,-15,15> translate <-1.85,1.75,-.25> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
/********************************************Neck***********************************************/
					cylinder {<0,1,0><0,-1,0>1.5*Mult,1 rotate <0,0,5>  scale <1.25,1,1.6>
							translate <.05,1.5,.25>
							rotate Neck_Rotate  }
					cylinder {<0,1,0><0,-1,0>1.5*Mult,1 rotate <0,0,-5> scale <1.25,1,1.6>
							translate <-.05,1.5,.25>
							rotate Neck_Rotate  }
					sturm                                             
					texture {TanSkin}
					}
			//Teeth, Upper Row
			object {ToothSet
					#if (Smile)
					 translate <0,.85,0> 
					#else           
					 translate <0,1,0>
					#end 
					translate <0,0,-.85>
					rotate Head_Rotate translate Head_Translate
					rotate Neck_Rotate  }
			//Teeth, Lower Row
			object {ToothSet scale <.75,.75,1>
					rotate <0,0,180> translate <0,.7,0> translate <0,0,-.65>
					translate <0,.25+Jaw_Rotate.x/35,0> 
					rotate Head_Rotate translate Head_Translate
					rotate Neck_Rotate  }      
			//Left EyeBall
			object {EyeBall
					rotate <0,-15,0>
					rotate Look_At translate <.5,2.5,-1.575>
					rotate Head_Rotate translate Head_Translate
					rotate Neck_Rotate  }                       
			//LeftEyebrow
			object {LeftEyeBrow
					#if (clock <=.35) 
					 translate <.2,2.75,-2.2> 
					#else  
					 translate <.2,2.75-(((clock-.35)*(1/.65))*.1),-2.2>
					#end
					rotate Head_Rotate translate Head_Translate
					rotate Neck_Rotate  }
			//Right EyeBall
			object {EyeBall         
					rotate <0,15,0>
					rotate Look_At translate <-.5,2.5,-1.575>
					rotate Head_Rotate translate Head_Translate
					rotate Neck_Rotate  }          
			//RightEyeBrow 
			object {RightEyeBrow 
					#if (clock <=.35) 
					 translate <-.2,2.75,-2.2> 
					#else  
					 translate <-.2,2.75-(((clock-.35)*(1/.65))*.1),-2.2>
					#end
					rotate Head_Rotate translate Head_Translate
					rotate Neck_Rotate  }
			//RightEyeLid
			object {Eyelid rotate <0,0,-15> rotate Blink_Rotate translate <-.5,2.5,-1.585>
					rotate Head_Rotate translate Head_Translate
					rotate Neck_Rotate  }
			//LeftEyeLid
			object {Eyelid rotate <0,0,15> rotate Blink_Rotate translate <.5,2.5,-1.585>
					rotate Head_Rotate translate Head_Translate
					rotate Neck_Rotate  }
			texture {TanSkin}
			}        

#declare Pin =
	cylinder {<0,0,0><0,.25,0>.01}
	
#declare PinRow =
	union
		{
		#declare Index = -.45
		#while (Index <= .45) 
		 object {Pin translate <Index,0,0>}
		 #declare Index = Index + .05
		#end           
		pigment {Gray90}
		finish {specular 1 roughness .001 reflection .4}
		rotate <25,0,0>
		}
					
#declare Chip =                 
	union
		{
		box {<-.5,-.5,-.05><.5,.5,.05>
			pigment
				{
				image_map
					{
					gif "IntelOut.Gif"
					}                 
				translate <-.5,-.5,-.5>
				}
			}
		object {PinRow translate <0,.5,0>}
		object {PinRow rotate <0,0,90> translate <-.5,0,0>}  
		object {PinRow rotate <0,0,-90> translate <.5,0,0>} 
		object {PinRow rotate <0,0,180> translate <0,-.5,0>}             
		translate <0,0,-1.725>
		rotate <10,-90,0>
		translate <0,3,0>
		translate Head_Translate
		}
		
#declare TechHead =
	union
		{
		object {HumanHead}
		object {Chip}
		scale ((1/2)+(1/3))/2
		translate <0,-1.5,0>
		rotate <0,90,0>
		}
		
#declare EverMan = 
	union
		{
		difference
			{
			blob
				{
				threshold .25
/****************************************Head************************************************/
				//Main Head Sphere
				sphere {<0,0,0>,1,1 scale<3.25,4,4>*Mult translate <0,3,0>
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Secondary Head Sphere
				sphere {<0,0,0>,1,1 scale<2.75,2.75,3.5>*Mult translate <0,2,0>
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				//Frontal Sphere
				sphere {<0,0,0>,1,1 scale(<1.5,1.5,.75>+(<0,abs(Jaw_Rotate.x/50),0>))*Mult 
						rotate <-30,0,0> translate <0,1-(abs(Jaw_Rotate.x/60)),-1.15>
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}  
				//Left Cheek
				sphere {<0,0,0>,1,1.75 scale(<1.75,2.5,3>+(<0,abs(Jaw_Rotate.x/50),0>))*Mult 
						rotate <0,0,-15> translate <.25,1.375-(abs(Jaw_Rotate.x/60)),-.35>
				 		rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Right Cheek
				sphere {<0,0,0>,1,1.75 scale(<1.75,2.5,3>+(<0,abs(Jaw_Rotate.x/50),0>))*Mult 
						rotate <0,0,15> translate <-.25,1.375-(abs(Jaw_Rotate.x/60)),-.35>
				 		rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}	  
				// Left Jaw Bone
				cylinder {<.9,0,0><.05,-.5,-1.75>,.5,1 scale <1.25,1.35,1.35>*Mult 
						rotate Jaw_Rotate - <2.5,0,0> translate <0,1,0> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Right Jaw Bone
				cylinder {<-.9,0,0><-.05,-.5,-1.75>,.5,1 scale <1.25,1.35,1.35>*Mult 
						rotate Jaw_Rotate - <2.5,0,0> translate <0,1,0> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Mouth, Left Half
				sphere {<0,0,0>1,-1 scale(<.6,(.1+abs(Jaw_Rotate.x/30)),1+(abs(Jaw_Rotate.x/2))>)*Mult 
						#if (Smile)
						 scale <1.5,1,1> rotate <0,0,15> translate <.15,0,0>
						#end
						translate <.1-abs(Jaw_Rotate.x/200),1-abs(Jaw_Rotate.x/60),-2.65>
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				//Mouth, Right Half
				sphere {<0,0,0>1,-1 scale(<.6,(.1+abs(Jaw_Rotate.x/30)),1+(abs(Jaw_Rotate.x/2))>)*Mult
						#if (Smile)
						 scale <1.5,1,1> rotate <0,0,-15> translate <-.15,0,0>
						#end
						translate <-.1+abs(Jaw_Rotate.x/200),1-abs(Jaw_Rotate.x/60),-2.65>
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Depression below nose
				cylinder {<0,0,0><0,-4,0>,1*Mult,-1 scale <5/32,1/16,2/8> 
						translate <0,1.45,-2.375>
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				//Bridge of Nose
				cylinder {<0,0,0><0,-4,0>,1*Mult,1 rotate <1.25,0,0> scale <6/16,1/4,1> rotate <13.75,0,0>
						translate <0,2.5,-1.5>
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				//Left Nostril
				sphere {<0,0,0>,1,1 scale <.3,.3,.3>*Mult translate <.1,1.675,-2.125>
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Right Nostril 
				sphere {<0,0,0>,1,1 scale <.3,.3,.3>*Mult translate <-.1,1.675,-2.125>
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Left Occular Cavity
				sphere {<0,0,0>1,-1 scale <2,.35,.5>*Mult 
						translate <1.5,2.5,-2.125> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				//Right Occular Cavity
				sphere {<0,0,0>1,-1 scale <2,.35,.5>*Mult 
						translate <-1.5,2.5,-2.125> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				//Left Ear
				sphere {<0,0,0>1,1 scale <.5,1.45,.75>*Mult
						rotate <15,10,-15> translate <1.65,2,0> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,-1 scale <.675,1.15,.65>*Mult
						rotate <15,10,-15> translate <1.85,2,0> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				sphere {<0,0,0>1,-1 scale <.7,.75,.6>*Mult
						rotate <15,10,-15> translate <1.85,1.9,-.1> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				sphere {<0,0,0>1,-1 scale <.75,.3,.3>*Mult
						rotate <0,15,-15> translate <1.85,1.75,-.25> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Right Ear
				sphere {<0,0,0>1,1 scale <.5,1.45,.75>*Mult
						rotate <15,-10,15> translate <-1.65,2,0> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,-1 scale <.675,1.15,.65>*Mult
						rotate <15,-10,15> translate <-1.85,2,0> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				sphere {<0,0,0>1,-1 scale <.7,.75,.6>*Mult
						rotate <15,-10,15> translate <-1.85,1.9,-.1> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				sphere {<0,0,0>1,-1 scale <.75,.3,.3>*Mult
						rotate <0,-15,15> translate <-1.85,1.75,-.25> 
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Hair
				sphere {<0,0,0>1,1 
						pigment {BrightGold}
						finish {specular 1}
						scale <3.75,2,4.5>*Mult rotate <7.5,0,15> translate <-.5,4.25,-.25> 
						normal
							{
							ripples 1
							scale <1,.025,1>
							rotate <0,0,88>
							translate <0,-25,0>
							}
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1
						pigment {BrightGold}
						finish {specular 1}
						scale <2,2.5,4.5>*Mult rotate <7.5,0,45> translate <.65,3.85,-.25> 
						normal
							{
							ripples 1
							scale <1,.025,1>
							rotate <0,0,88>
							translate <0,-25,0>
							}
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1
						pigment {BrightGold}
						finish {specular 1}
						scale <3.5,4.75,2.25>*Mult rotate <15,0,0> translate <0,2.4,1.1> 
						normal
							{
							ripples 1
							scale <1,.025,1>
							rotate <0,0,88>
							translate <0,-25,0>
							}
						rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
/********************************************Neck***********************************************/
				cylinder {<0,1,0><0,-2,0>1.5*Mult,1 rotate <0,0,5>  scale <1.25,1,1.6>
						translate <.05,1.5,.25>
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				cylinder {<0,1,0><0,-2,0>1.5*Mult,1 rotate <0,0,-5> scale <1.25,1,1.6>
						translate <-.05,1.5,.25>
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
/*******************************************Torso**********************************************/
	            //Left Collar Muscle
	            sphere {<0,0,0>,1,1 scale <3.5,2,2.5>*Mult 
	            		translate <1.25,1.25,.25> rotate <15,0,0>
	            		rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
	            //Right Collar Muscle
	            sphere {<0,0,0>,1,1 scale <3.5,2,2.5>*Mult 
	            		translate <-1.25,1.25,.25> rotate <15,0,0>
	            		rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}		                  
	            //Left Pec 
	            sphere {<0,0,0>,1,1 scale <3.25,3,1.5>*Mult 
	            		rotate <30,0,0> translate <1.15,0,-1.25> rotate <15,0,0>
	            		rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
	            //Right Pec 
	            sphere {<0,0,0>,1,1 scale <3.25,3,1.5>*Mult 
	            		rotate <30,0,0> translate <-1.15,0,-1.25> rotate <15,0,0>
	            		rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
	            //Left Lower Rib Cage
	            sphere {<0,0,0>,1,1 scale <3.5,5.5,4.25>*Mult rotate <0,15,0> 
	            		translate <1,-.75,.25> rotate <30,0,0>
	            		rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}  
	            //Right Lower Rib Cage
	            sphere {<0,0,0>,1,1 scale <3.5,5.5,4.25>*Mult rotate <0,-15,0> 
	            		translate <-1,-.75,.25> rotate <30,0,0>
	            		rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
/*****************************************Stomach**********************************************/
				//SixPack  
				sphere {<0,0,0>,1,1 scale<2,2.75,2>*Mult translate <.55,2,-.8>
						rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>,1,1 scale<2.1,2,2>*Mult translate <.65,1,-.95>
						rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>,1,1 scale<2,1.75,2>*Mult translate <.6,0,-.8>
						rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>,1,1 scale<2,1.75,2>*Mult translate <-.55,2,-.8>
						rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>,1,1 scale<2.1,2,2>*Mult translate <-.65,1,-.95>
						rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>,1,1 scale<2,1.75,2>*Mult translate <-.6,0,-.8>
						rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}          
				//Left Back Muscle
				cylinder {<0,1,0><0,-3,0>,2*Mult,1 scale <1.25,1,1.5> translate <.875,2.5,0>
						rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Right Back Muscle
				cylinder {<0,1,0><0,-3,0>,2*Mult,1 scale <1.25,1,1.5> translate <-.875,2.5,0>
						rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
/*****************************************Butt*************************************************/
				//Crotch
				sphere {<0,0,0>,1,1 scale <5,5,3.125>*Mult translate <0,-.25,-.75>
						rotate Hip_Rotate translate Hip_Translate}
				//Left Butt 
				sphere {<0,0,0>,1,1 scale <3.5,3.5,3.5>*Mult translate <.75,-.75,.5>
						rotate Hip_Rotate translate Hip_Translate}
				//Right Butt 
				sphere {<0,0,0>,1,1 scale <3.5,3.5,3.5>*Mult translate <-.75,-.75,.5>
						rotate Hip_Rotate translate Hip_Translate} 
/****************************************Left Upper Arm****************************************/
				//Bone??
				cylinder {<0,0,0><0,-4.5,0>1*Mult,1
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}                                         
				//shoulder
				sphere {<0,0,0>1,1 scale <3,3,3>*Mult translate <.1,-.1,.05>
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}        
				//bicep
				sphere {<0,0,0>1,1 scale <2.25,(5.25-((Left_Fore_Arm_Rotate.x/90)*.5)),2.35>*Mult 
						translate <0,-2,-.35> translate <0,0,-.25>
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//tricep
				sphere {<0,0,0>1,1 scale <2,3.5,1.85>*Mult translate <.15,-2,.15>
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
/****************************************Right Upper Arm****************************************/                                         
				//Bone??
				cylinder {<0,0,0><0,-4.5,0>1*Mult,1
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//shoulder
				sphere {<0,0,0>1,1 scale <3,3,3>*Mult translate <-.1,-.1,.05>
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}        
				//bicep
				sphere {<0,0,0>1,1 scale <2.25,(5.25-((Right_Fore_Arm_Rotate.x/90)*.5)),2.35>*Mult 
						translate <0,-2,-.35> translate <0,0,-.25>
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//tricep
				sphere {<0,0,0>1,1 scale <2,3.5,1.85>*Mult translate <-.15,-2,.15>
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
/***************************************Left Fore Arm******************************************/
				//Bone??
				cylinder {<0,-2,0><0,-4.5,0>1*Mult,1 scale <1.25,1,1.25>
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1 scale <1.75,3.5,2>*Mult translate <0,-1.75,-.15>
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1 scale <1.75,3.5,1.85>*Mult translate <0,-1.75,.05>
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1 scale <2,4.75,1.75>*Mult 
						rotate <-5,0,0> translate <.15,-1.5,0>
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
/***************************************Right Fore Arm******************************************/
				//Bone??
				cylinder {<0,-2,0><0,-4.5,0>1*Mult,1 scale <1.25,1,1.25> 
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1 scale <1.75,3.5,2>*Mult translate <0,-1.75,-.15>
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1 scale <1.75,3.5,1.85>*Mult translate <0,-1.75,.05>
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1 scale <2,4.75,1.75>*Mult
						rotate <-5,0,0> translate <-.15,-1.5,0>
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
/*******************************************Left_Hand*******************************************/
				//palm1
				sphere {<0,0,0>1,1.25 scale <.85,1.25,.9>*Mult 
						rotate Left_Thumb_Rotate1 translate <-.25,-.5,.1>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//palm2
				sphere {<0,0,0>1,1.25 scale <.75,1.25,1>*Mult translate <.15,-.5,.1>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//palm3
				sphere {<0,0,0>1,1.25 scale <1.25,2.25,.75>*Mult rotate <0,0,1> translate <0,-.75,-.25>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Thumb1
				cylinder {<0,0,0><0,-.6,0>.35*Mult,2 
						scale <1,1,1.25> rotate <0,0,-15> translate <-.25,0,0>
						rotate Left_Thumb_Rotate1 translate <-.25,-.45,0>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				//Thumb2
				sphere {<0,0,0>1,1.25 scale <.4,1,.5>*Mult translate <0,-.4,0> 
						rotate Left_Thumb_Rotate2 translate <0,-.525,0>
						rotate <0,0,-15> translate <-.25,0,0> 
						rotate Left_Thumb_Rotate1 translate <-.25,-.45,0>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//index0
				cylinder {<0,0,0><0,-1.75,0>.25*Mult,2 rotate <0,0,-3> translate <-.3,0,-.3>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//middle0
				cylinder {<0,0,0><0,-1.75,0>.35*Mult,2 rotate <0,0,0> translate <-.1,0,-.35>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//ring0
				cylinder {<0,0,0><0,-1.75,0>.35*Mult,2 rotate <0,0,3> translate <.1,0,-.35>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//pinky0
				cylinder {<0,0,0><0,-1.75,0>.25*Mult,2 rotate <0,0,6> translate <.3,0,-.3>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//index1
				cylinder {<0,0,0><0,-.45,0>.25*Mult,2 
						rotate Left_Index_Rotate translate <0,-1.75,0>
						rotate <0,0,-3> translate <-.3,0,-.3>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//index2
						cylinder {<0,0,0><0,-.45,0>.225*Mult,2
						rotate Left_Index_Rotate translate <0,-.45,0> 
						rotate Left_Index_Rotate translate <0,-1.75,0>
						rotate <0,0,-3> translate <-.3,0,-.3>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//index3
						cylinder {<0,0,0><0,-.45,0>.2*Mult,2       
						rotate Left_Index_Rotate translate <0,-.45,0>
						rotate Left_Index_Rotate translate <0,-.45,0> 
						rotate Left_Index_Rotate translate <0,-1.75,0>
						rotate <0,0,-3> translate <-.3,0,-.3>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//middle1
				cylinder {<0,0,0><0,-.5,0>.25*Mult,2 
						rotate Left_Middle_Rotate translate <0,-1.75,0>
						rotate <0,0,.5> translate <-.15,0,-.4>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//middle2
						cylinder {<0,0,0><0,-.5,0>.225*Mult,2
						rotate Left_Middle_Rotate translate <0,-.5,0> 
						rotate Left_Middle_Rotate translate <0,-1.75,0>
						rotate <0,0,.5> translate <-.15,0,-.4>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//middle3
						cylinder {<0,0,0><0,-.5,0>.2*Mult,2       
						rotate Left_Middle_Rotate translate <0,-.5,0>
						rotate Left_Middle_Rotate translate <0,-.5,0> 
						rotate Left_Middle_Rotate translate <0,-1.75,0>
						rotate <0,0,.5> translate <-.15,0,-.4>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//ring1
				cylinder {<0,0,0><0,-.45,0>.25*Mult,2
						rotate Left_Ring_Rotate translate <0,-1.75,0>
						rotate <0,0,2.5> translate <.15,0,-.4>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//ring2
						cylinder {<0,0,0><0,-.45,0>.225*Mult,2
						rotate Left_Ring_Rotate translate <0,-.45,0> 
						rotate Left_Ring_Rotate translate <0,-1.75,0>
						rotate <0,0,2.5> translate <.15,0,-.4>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//ring3
						cylinder {<0,0,0><0,-.45,0>.2*Mult,2       
						rotate Left_Ring_Rotate translate <0,-.45,0>
						rotate Left_Ring_Rotate translate <0,-.45,0> 
						rotate Left_Ring_Rotate translate <0,-1.75,0>
						rotate <0,0,2.5> translate <.15,0,-.4>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//pinky1
				cylinder {<0,0,0><0,-.4,0>.25*Mult,2 
						rotate Left_Pinky_Rotate translate <0,-1.75,0>
						rotate <0,0,6> translate <.3,0,-.3>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//pinky2
						cylinder {<0,0,0><0,-.4,0>.225*Mult,2
						rotate Left_Pinky_Rotate translate <0,-.4,0> 
						rotate Left_Pinky_Rotate translate <0,-1.75,0>
						rotate <0,0,6> translate <.3,0,-.3>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//pinky3
						cylinder {<0,0,0><0,-.4,0>.2*Mult,2       
						rotate Left_Pinky_Rotate translate <0,-.4,0>
						rotate Left_Pinky_Rotate translate <0,-.4,0> 
						rotate Left_Pinky_Rotate translate <0,-1.75,0>
						rotate <0,0,6> translate <.3,0,-.3>
						rotate Left_Hand_Rotate translate Left_Hand_Translate
						rotate Left_Fore_Arm_Rotate translate Left_Fore_Arm_Translate
						rotate Left_Arm_Rotate translate Left_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
/*******************************************Right_Hand*******************************************/
				//palm1
				sphere {<0,0,0>1,1.25 scale <.85,1.25,.9>*Mult 
						rotate Right_Thumb_Rotate1 translate <.25,-.5,.1>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//palm2
				sphere {<0,0,0>1,1.25 scale <.75,1.25,1>*Mult translate <-.15,-.5,.1>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//palm3
				sphere {<0,0,0>1,1.25 scale <1.25,2.25,.75>*Mult rotate <0,0,-1> translate <0,-.75,-.25>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//Thumb1
				cylinder {<0,0,0><0,-.6,0>.35*Mult,2 
						scale <1,1,1.25> rotate <0,0,15> translate <.25,0,0>
						rotate Right_Thumb_Rotate1 translate <.25,-.45,0>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate} 
				//Thumb2
				sphere {<0,0,0>1,1.25 scale <.4,1,.5>*Mult translate <0,-.4,0> 
						rotate Right_Thumb_Rotate2 translate <0,-.525,0>
						rotate <0,0,15> translate <.25,0,0> 
						rotate Right_Thumb_Rotate1 translate <.25,-.45,0>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//index0
				cylinder {<0,0,0><0,-1.75,0>.25*Mult,2 rotate <0,0,3> translate <.3,0,-.3>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//middle0
				cylinder {<0,0,0><0,-1.75,0>.35*Mult,2 rotate <0,0,0> translate <.1,0,-.35>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//ring0
				cylinder {<0,0,0><0,-1.75,0>.35*Mult,2 rotate <0,0,-3> translate <-.1,0,-.35>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//pinky0
				cylinder {<0,0,0><0,-1.75,0>.25*Mult,2 rotate <0,0,-6> translate <-.3,0,-.3>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//index1
				cylinder {<0,0,0><0,-.45,0>.25*Mult,2 
						rotate Right_Index_Rotate translate <0,-1.75,0>
						rotate <0,0,3> translate <.3,0,-.3>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//index2
						cylinder {<0,0,0><0,-.45,0>.225*Mult,2
						rotate Right_Index_Rotate translate <0,-.45,0> 
						rotate Right_Index_Rotate translate <0,-1.75,0>
						rotate <0,0,3> translate <.3,0,-.3>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//index3
						cylinder {<0,0,0><0,-.45,0>.2*Mult,2       
						rotate Right_Index_Rotate translate <0,-.45,0>
						rotate Right_Index_Rotate translate <0,-.45,0> 
						rotate Right_Index_Rotate translate <0,-1.75,0>
						rotate <0,0,3> translate <.3,0,-.3>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//middle1
				cylinder {<0,0,0><0,-.5,0>.25*Mult,2 
						rotate Right_Middle_Rotate translate <0,-1.75,0>
						rotate <0,0,-.5> translate <.15,0,-.4>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//middle2
						cylinder {<0,0,0><0,-.5,0>.225*Mult,2
						rotate Right_Middle_Rotate translate <0,-.5,0> 
						rotate Right_Middle_Rotate translate <0,-1.75,0>
						rotate <0,0,-.5> translate <.15,0,-.4>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//middle3
						cylinder {<0,0,0><0,-.5,0>.2*Mult,2       
						rotate Right_Middle_Rotate translate <0,-.5,0>
						rotate Right_Middle_Rotate translate <0,-.5,0> 
						rotate Right_Middle_Rotate translate <0,-1.75,0>
						rotate <0,0,-.5> translate <.15,0,-.4>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//ring1
				cylinder {<0,0,0><0,-.45,0>.25*Mult,2
						rotate Right_Ring_Rotate translate <0,-1.75,0>
						rotate <0,0,-2.5> translate <-.15,0,-.4>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//ring2
						cylinder {<0,0,0><0,-.45,0>.225*Mult,2
						rotate Right_Ring_Rotate translate <0,-.45,0> 
						rotate Right_Ring_Rotate translate <0,-1.75,0>
						rotate <0,0,-2.5> translate <-.15,0,-.4>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//ring3
						cylinder {<0,0,0><0,-.45,0>.2*Mult,2       
						rotate Right_Ring_Rotate translate <0,-.45,0>
						rotate Right_Ring_Rotate translate <0,-.45,0> 
						rotate Right_Ring_Rotate translate <0,-1.75,0>
						rotate <0,0,-2.5> translate <-.15,0,-.4>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//pinky1
				cylinder {<0,0,0><0,-.4,0>.25*Mult,2 
						rotate Right_Pinky_Rotate translate <0,-1.75,0>
						rotate <0,0,-6> translate <-.3,0,-.3>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//pinky2
						cylinder {<0,0,0><0,-.4,0>.225*Mult,2
						rotate Right_Pinky_Rotate translate <0,-.4,0> 
						rotate Right_Pinky_Rotate translate <0,-1.75,0>
						rotate <0,0,-6> translate <-.3,0,-.3>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
				//pinky3
						cylinder {<0,0,0><0,-.4,0>.2*Mult,2       
						rotate Right_Pinky_Rotate translate <0,-.4,0>
						rotate Right_Pinky_Rotate translate <0,-.4,0> 
						rotate Right_Pinky_Rotate translate <0,-1.75,0>
						rotate <0,0,-6> translate <-.3,0,-.3>
						rotate Right_Hand_Rotate translate Right_Hand_Translate
						rotate Right_Fore_Arm_Rotate translate Right_Fore_Arm_Translate
						rotate Right_Arm_Rotate translate Right_Arm_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
/*****************************************Left Thigh*******************************************/
				//Bone??
				cylinder {<0,-2,0><0,-6.75,0>1.5*Mult,1
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Inside Quad
				sphere {<0,0,0>1,2 scale <2.25,6.5,2.25>*Mult translate <-.25,-3.5,0>
				        rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Outside Quad
				sphere {<0,0,0>1,2 scale <2.5,6.75,2.75>*Mult rotate <0,0,-5> translate <.8,-3.25,0>
				        rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Front Quad
				sphere {<0,0,0>1,2 scale <2.5,6,2>*Mult translate <.25,-1.5,-.9>
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Rear Quad
				sphere {<0,0,0>1,2 scale <2.5,7,2>*Mult translate <.25,-3.25,.9>
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
/*****************************************Right Thigh*******************************************/
				//Bone??
				cylinder {<0,-2,0><0,-6.75,0>1.5*Mult,1
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Inside Quad
				sphere {<0,0,0>1,2 scale <2.25,6.5,2.25>*Mult translate <.25,-3.5,0>
				        rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Outside Quad
				sphere {<0,0,0>1,2 scale <2.5,6.75,2.75>*Mult rotate <0,0,5> translate <-.8,-3.25,0>
				        rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Front Quad
				sphere {<0,0,0>1,2 scale <2.5,6,2>*Mult translate <-.25,-1.5,-.9>
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate} 
				//Rear Quad
				sphere {<0,0,0>1,2 scale <2.5,7,2>*Mult translate <-.25,-3.25,.9>
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
/******************************************Left Knee********************************************/
				cylinder {<0,0,-.55><0,0,.45>1*Mult,2 scale <2,2,1> rotate <15,0,0> 
						rotate <0,90,0>
						rotate Left_Knee_Rotate translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				cylinder {<0,0,-.55><0,0,.45>1*Mult,2 scale <1.75,2,1> rotate <-15,0,0>
						rotate <0,90,0> 
						rotate Left_Knee_Rotate translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}  
/******************************************Right Knee*******************************************/
				cylinder {<0,0,-.55><0,0,.45>1*Mult,2 scale <2,2,1> rotate <15,0,0>
						rotate <0,-90,0> 
						rotate Right_Knee_Rotate translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				cylinder {<0,0,-.55><0,0,.45>1*Mult,2 scale <1.75,2,1> rotate <-15,0,0>
						rotate <0,-90,0> 
						rotate Right_Knee_Rotate translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
/*****************************************Left Calf********************************************/
				//Bone??
				sphere {<0,0,0>1,1 scale <2.25,7.75,2>*Mult translate <0,-5,0>
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1 scale <2,6,2>*Mult translate <-.1,-3,-.25>
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Calf1
				sphere {<0,0,0>1,1 scale <3,5.5,2.75>*Mult translate <.25,-2.75,.25>
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Left Ankle
				sphere {<0,0,0>1,1 scale <1,1.5,.75>*Mult translate <.325,-8,0>
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Right Ankle
				sphere {<0,0,0>1,1 scale <1,1.5,.75>*Mult translate <-.325,-8,0>
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
/*****************************************Right Calf********************************************/
				//Bone??
				sphere {<0,0,0>1,1 scale <2.25,7.75,2>*Mult translate <0,-5,0>
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1 scale <2,6,2>*Mult translate <.1,-3,-.25>
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Calf1
				sphere {<0,0,0>1,1 scale <3,5.5,2.75>*Mult translate <-.25,-2.75,.25>
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Left Ankle
				sphere {<0,0,0>1,1 scale <1,1.5,.75>*Mult translate <.325,-8,0>
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Right Ankle
				sphere {<0,0,0>1,1 scale <1,1.5,.75>*Mult translate <-.325,-8,0>
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate} 
/*******************************************Left Foot*******************************************/
				//Ball
				sphere {<0,0,0>1,1 scale <1,.875,2>*Mult 
						rotate <-5,5,0> scale <1.5,1.3,2> translate <-.25,-.8,-1>
						rotate Left_Foot_Rotate translate Left_Foot_Translate
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1 scale <1,.875,2>*Mult 
						rotate <-5,-5,0> scale <1.25,1.3,1.9>translate <.25,-.8,-1>
						rotate Left_Foot_Rotate translate Left_Foot_Translate
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Arch
				sphere {<0,0,0>1,1 scale <1,.875,2>*Mult scale <1.4,1.3,1.75> 
						rotate <-30,0,0> translate <-.2,-.35,-.875>
						rotate Left_Foot_Rotate translate Left_Foot_Translate
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//heel
				sphere {<0,0,0>1,1 scale <1.35,1.75,1.25>*Mult
						translate <-.15,-.5,.5>
						rotate Left_Foot_Rotate translate Left_Foot_Translate
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Toe1
				sphere {<0,0,0>1,.65 scale <.75,.7,1>*Mult translate <0,0,-.6>
						rotate Left_Toes_Rotate translate <0,-.25,-2.3>
						rotate <-15,10,0> translate <-.5,0,0>
						rotate Left_Foot_Rotate translate Left_Foot_Translate
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Toe2
				sphere {<0,0,0>1,.35 scale <.4,.6,.9>*Mult translate <0,0,-.5>
						rotate Left_Toes_Rotate translate <0,0,-2.45>
						rotate <-15,3.75,0> translate <-.25,-.25,0>
						rotate Left_Foot_Rotate translate Left_Foot_Translate
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Toe3
				sphere {<0,0,0>1,.35 scale <.4,.6,.85>*Mult translate <0,0,-.475>
						rotate Left_Toes_Rotate translate <0,0,-2.4>
						rotate <-15,0,0> translate <0,-.25,0>
						rotate Left_Foot_Rotate translate Left_Foot_Translate
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}  
				//Toe4
				sphere {<0,0,0>1,.35 scale <.35,.6,.8>*Mult translate <0,0,-.45>
						rotate Left_Toes_Rotate translate <0,0,-2.3>
						rotate <-15,-3.75,0> translate <.25,-.25,0>
						rotate Left_Foot_Rotate translate Left_Foot_Translate
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate} 
				//Toe5
				sphere {<0,0,0>1,.35 scale <.3,.6,.75>*Mult translate <0,0,-.425>
						rotate Left_Toes_Rotate translate <0,0,-2.2>
						rotate <-15,-6.5,0> translate <.5,-.25,0>
						rotate Left_Foot_Rotate translate Left_Foot_Translate
						rotate Left_Calf_Rotate translate Left_Calf_Translate
												translate Left_Knee_Translate
						rotate Left_Thigh_Rotate translate Left_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
/*******************************************Right Foot*******************************************/
				//Ball
				sphere {<0,0,0>1,1 scale <1,.875,2>*Mult 
						rotate <-5,-5,0> scale <1.5,1.3,2> translate <.25,-.8,-1>
						rotate Right_Foot_Rotate translate Right_Foot_Translate
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				sphere {<0,0,0>1,1 scale <1,.875,2>*Mult 
						rotate <-5,5,0> scale <1.25,1.3,1.9>translate <-.25,-.8,-1>
						rotate Right_Foot_Rotate translate Right_Foot_Translate
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Arch
				sphere {<0,0,0>1,1 scale <1,.875,2>*Mult scale <1.4,1.3,1.75> 
						rotate <-30,0,0> translate <.2,-.35,-.875>
						rotate Right_Foot_Rotate translate Right_Foot_Translate
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//heel
				sphere {<0,0,0>1,1 scale <1.35,1.75,1.25>*Mult
						translate <.15,-.5,.5>
						rotate Right_Foot_Rotate translate Right_Foot_Translate
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Toe1
				sphere {<0,0,0>1,.65 scale <.75,.7,1>*Mult translate <0,0,-.65>
						rotate Right_Toes_Rotate translate <0,0,-2.3>
						rotate <-15,-10,0> translate <.5,-.25,0>
						rotate Right_Foot_Rotate translate Right_Foot_Translate
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Toe2
				sphere {<0,0,0>1,.35 scale <.4,.6,.9>*Mult translate <0,0,-.5>
						rotate Right_Toes_Rotate translate <0,0,-2.45>
						rotate <-15,-3.75,0> translate <.25,-.25,0>
						rotate Right_Foot_Rotate translate Right_Foot_Translate
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				//Toe3
				sphere {<0,0,0>1,.35 scale <.4,.6,.85>*Mult translate <0,0,-.475>
						rotate Right_Toes_Rotate translate <0,-.25,-2.4>
						rotate <-15,0,0> translate <0,0,0>
						rotate Right_Foot_Rotate translate Right_Foot_Translate
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}  
				//Toe4
				sphere {<0,0,0>1,.35 scale <.35,.6,.8>*Mult translate <0,0,-.45>
						rotate Right_Toes_Rotate translate <0,0,-2.3>
						rotate <-15,3.75,0> translate <-.25,-.25,0>
						rotate Right_Foot_Rotate translate Right_Foot_Translate
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate} 
				//Toe5
				sphere {<0,0,0>1,.35 scale <.3,.6,.75>*Mult translate <0,0,-.425>
						rotate Right_Toes_Rotate translate <0,0,-2.2>
						rotate <-15,6.5,0> translate <-.5,-.25,0>
						rotate Right_Foot_Rotate translate Right_Foot_Translate
						rotate Right_Calf_Rotate translate Right_Calf_Translate
												translate Right_Knee_Translate
						rotate Right_Thigh_Rotate translate Right_Thigh_Translate
						rotate Hip_Rotate translate Hip_Translate}
				sturm
				texture {TanSkin}
				} 
			//Inside of Mouth
			sphere {<0,1.15,-(1+(abs(Jaw_Rotate.x/200)))>1
					rotate Head_Rotate translate Head_Translate
						rotate Neck_Rotate translate Neck_Translate
						rotate Torso_Rotate translate Torso_Translate
	            		rotate Stomach_Rotate translate Stomach_Translate 
						rotate Hip_Rotate translate Hip_Translate}
			texture {TanSkin}
			}
		//Teeth, Upper Row
		object {ToothSet
				#if (Smile)
				 translate <0,.85,0> 
				#else           
				 translate <0,1,0>
				#end 
				translate <0,0,-.85>
				rotate Head_Rotate translate Head_Translate
				rotate Neck_Rotate translate Neck_Translate
				rotate Torso_Rotate translate Torso_Translate
	       		rotate Stomach_Rotate translate Stomach_Translate 
				rotate Hip_Rotate translate Hip_Translate}
		//Teeth, Lower Row
		object {ToothSet scale <.75,.75,1>
				rotate <0,0,180> translate <0,.7,0> translate <0,0,-.65>
				translate <0,.25+Jaw_Rotate.x/35,0> 
				rotate Head_Rotate translate Head_Translate
				rotate Neck_Rotate translate Neck_Translate
				rotate Torso_Rotate translate Torso_Translate
	       		rotate Stomach_Rotate translate Stomach_Translate 
				rotate Hip_Rotate translate Hip_Translate}      
		//Left EyeBall
		object {EyeBall
				rotate <0,-15,0>
				rotate Look_At translate <.5,2.5,-1.575>
				rotate Head_Rotate translate Head_Translate
				rotate Neck_Rotate translate Neck_Translate
				rotate Torso_Rotate translate Torso_Translate
	       		rotate Stomach_Rotate translate Stomach_Translate 
				rotate Hip_Rotate translate Hip_Translate}                       
		//LeftEyebrow
		object {LeftEyeBrow
				#if (clock <=.35) 
				 translate <.2,2.75,-2.2> 
				#else  
				 translate <.2,2.75-(((clock-.35)*(1/.65))*.1),-2.2>
				#end
				rotate Head_Rotate translate Head_Translate
				rotate Neck_Rotate translate Neck_Translate
				rotate Torso_Rotate translate Torso_Translate
	       		rotate Stomach_Rotate translate Stomach_Translate 
				rotate Hip_Rotate translate Hip_Translate}
		//Right EyeBall
		object {EyeBall         
				rotate <0,15,0>
				rotate Look_At translate <-.5,2.5,-1.575>
				rotate Head_Rotate translate Head_Translate
				rotate Neck_Rotate translate Neck_Translate
				rotate Torso_Rotate translate Torso_Translate
	       		rotate Stomach_Rotate translate Stomach_Translate 
				rotate Hip_Rotate translate Hip_Translate}          
		//RightEyeBrow 
		object {RightEyeBrow 
				#if (clock <=.35) 
				 translate <-.2,2.75,-2.2> 
				#else  
				 translate <-.2,2.75-(((clock-.35)*(1/.65))*.1),-2.2>
				#end
				rotate Head_Rotate translate Head_Translate
				rotate Neck_Rotate translate Neck_Translate
				rotate Torso_Rotate translate Torso_Translate
	       		rotate Stomach_Rotate translate Stomach_Translate 
				rotate Hip_Rotate translate Hip_Translate}
		//RightEyeLid
		object {Eyelid rotate <0,0,-15> rotate Blink_Rotate translate <-.5,2.5,-1.585>
				rotate Head_Rotate translate Head_Translate
				rotate Neck_Rotate translate Neck_Translate
				rotate Torso_Rotate translate Torso_Translate
	       		rotate Stomach_Rotate translate Stomach_Translate 
				rotate Hip_Rotate translate Hip_Translate}
		//LeftEyeLid
		object {Eyelid rotate <0,0,15> rotate Blink_Rotate translate <.5,2.5,-1.585>
				rotate Head_Rotate translate Head_Translate
				rotate Neck_Rotate translate Neck_Translate
				rotate Torso_Rotate translate Torso_Translate
	       		rotate Stomach_Rotate translate Stomach_Translate 
				rotate Hip_Rotate translate Hip_Translate}
		texture {TanSkin}
		scale 6/31
		}               
		
#declare Startex =
	texture
		{
		pigment {rgbt <1,0,0,1>}
		halo
			{
			emitting
			spherical_mapping
			linear
			color_map
				{
				[0.0 color rgbt<1,1,1,1>]
				[1.0 color rgbt<1,1,1,-1>]
				}                        
			samples 10
			}
		}                
		
#declare Startex2 =
	texture
		{
		pigment {rgbt <1,1,1,1>}
		halo
			{
			emitting
			cylindrical_mapping
			linear
			color_map
				{
				[0.0 color rgbt<1,1,1,-1>]
				[0.1 color rgbt<1,1,1,1>]
				[1.0 color rgbt<1,1,1,1>]
				}                        
			samples 10
			}                          
		rotate <90,0,0>
		} 		                        
		
#declare StarRing =
	sphere {<0,0,0>1 hollow texture {Startex2}}
		
#declare StarBurst =
		union
			{
			sphere {<0,0,0>1 texture {Startex} scale <5,.25,.25>}
			sphere {<0,0,0>1 texture {Startex} scale <3,.2,.2> rotate <0,0,90>}
			sphere {<0,0,0>1 texture {Startex} scale <1.75,.1,.1> rotate <0,0,45>}
			sphere {<0,0,0>1 texture {Startex} scale <1.75,.1,.1> rotate <0,0,-45>}
			sphere {<0,0,0>1 texture {Startex} scale <1.5,.05,.05> rotate <0,0,22.5>}
			sphere {<0,0,0>1 texture {Startex} scale <1.5,.05,.05> rotate <0,0,-22.5>}
			sphere {<0,0,0>1 texture {Startex} scale <1.5,.05,.05> rotate <0,0,67.5>}
			sphere {<0,0,0>1 texture {Startex} scale <1.5,.05,.05> rotate <0,0,-67.5>} 
			object {StarRing}
			hollow      
			no_shadow
			}              
			
#declare HeadGlass =
	texture
		{
		pigment {rgbt <0,0,0,.95>}
		finish {specular 1 roughness .001 reflection .1 refraction 1 ior 1.05}
		}
			
#declare GlassHead =
				blob
					{
					threshold .25 
/****************************************Head************************************************/
					//Main Head Sphere
					sphere {<0,0,0>,1,1 scale<3.25,4,4>*Mult translate <0,3,0>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate}
					//Secondary Head Sphere
					sphere {<0,0,0>,1,1 scale<2.75,2.75,3.5>*Mult translate <0,2,0>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Frontal Sphere
					sphere {<0,0,0>,1,1 scale(<1.5,1.5,.75>+(<0,abs(Jaw_Rotate.x/50),0>))*Mult 
							rotate <-30,0,0> translate <0,1-(abs(Jaw_Rotate.x/60)),-1>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }  
					//Left Cheek
					sphere {<0,0,0>,1,1.75 scale(<1.75,2.5,3>+(<0,abs(Jaw_Rotate.x/50),0>))*Mult 
							rotate <0,0,-15> translate <.25,1.375-(abs(Jaw_Rotate.x/60)),-.3>
					 		rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Right Cheek
					sphere {<0,0,0>,1,1.75 scale(<1.75,2.5,3>+(<0,abs(Jaw_Rotate.x/50),0>))*Mult 
							rotate <0,0,15> translate <-.25,1.375-(abs(Jaw_Rotate.x/60)),-.3>
					 		rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }	  
					// Left Jaw Bone
					cylinder {<.9,0,0><.05,-.5,-1.75>,.5,1 scale <1.25,1.35,1.35>*Mult 
							rotate Jaw_Rotate - <2.5,0,0> translate <0,1,0> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Right Jaw Bone
					cylinder {<-.9,0,0><-.05,-.5,-1.75>,.5,1 scale <1.25,1.35,1.35>*Mult 
							rotate Jaw_Rotate - <2.5,0,0> translate <0,1,0> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Mouth, Left Half
					sphere {<0,0,0>1,-1 scale(<.7,(.1+abs(Jaw_Rotate.x/30)),1+(abs(Jaw_Rotate.x/2))>)*Mult 
							#if (Smile)
							 scale <1.5,1,1> rotate <0,0,15> translate <.15,0,0>
							#end
							translate <.1-abs(Jaw_Rotate.x/200),1-abs(Jaw_Rotate.x/60),-2.65>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Mouth, Right Half
					sphere {<0,0,0>1,-1 scale(<.7,(.1+abs(Jaw_Rotate.x/30)),1+(abs(Jaw_Rotate.x/2))>)*Mult
							#if (Smile)
							 scale <1.5,1,1> rotate <0,0,-15> translate <-.15,0,0>
							#end
							translate <-.1+abs(Jaw_Rotate.x/200),1-abs(Jaw_Rotate.x/60),-2.65>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Depression below nose
					cylinder {<0,0,0><0,-4,0>,1*Mult,-1 scale <5/32,1/16,2/8> 
							translate <0,1.45,-2.375>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Bridge of Nose
					cylinder {<0,0,0><0,-4,0>,1*Mult,1 rotate <1.25,0,0> 
							scale <6/16,1/4,1.1> rotate <25,0,0>
							translate <0,2.5,-1.75>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Left Nostril
					sphere {<0,0,0>,1,1 scale <.3,.3,.3>*Mult translate <.1,1.675,-2.125>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Right Nostril 
					sphere {<0,0,0>,1,1 scale <.3,.3,.3>*Mult translate <-.1,1.675,-2.125>
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
					//Left Occular Cavity
					sphere {<0,0,0>1,-1 scale <2,.35,.5>*Mult 
							translate <1.5,2.5,-2.125> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  } 
					//Right Occular Cavity
					sphere {<0,0,0>1,-1 scale <2,.35,.5>*Mult 
							translate <-1.5,2.5,-2.125> 
							rotate Head_Rotate translate Head_Translate
							rotate Neck_Rotate  }
/********************************************Neck***********************************************/
					cylinder {<0,1,0><0,-1,0>1.5*Mult,1 rotate <0,0,5>  scale <1.25,1,1.6>
							translate <.05,1.5,.25>
							rotate Neck_Rotate  }
					cylinder {<0,1,0><0,-1,0>1.5*Mult,1 rotate <0,0,-5> scale <1.25,1,1.6>
							translate <-.05,1.5,.25>
							rotate Neck_Rotate  }
					sturm	
		scale ((1/2)+(1/3))/2
		translate <0,-1.5,0>
		rotate <0,90,0>
		scale 5.5
		texture {HeadGlass}
		hollow
		}

object {Background}		
object {Sun 
		rotate <0,0,60>
		translate <0,3,0>
		rotate <0,0,-60>}
object {SunDial rotate <30,10,0> 
		rotate <0,0,120>
		translate <0,3,0>
		rotate <0,0,-120>}
object {HourGlass rotate <15,0,0>
		translate <0,-3,0>}                            
object {Clock rotate <10,-10,0>
		rotate <0,0,60>
		translate <0,-3,0>
		rotate <0,0,-60>}
object {Watch rotate <-10,-10,0>
		rotate <0,0,120>
		translate <0,-3,0>
		rotate <0,0,-120>} 
object {TechHead rotate <-15,0,0>
		translate <0,3,0>}
object {EverMan
		rotate <0,180,0>
		translate <0,-1,2>}
object {StarBurst
		translate <0,0,-2>}  
object {BigHand scale <2.5,5.5,1> rotate <0,0,-330> translate <0,0,-1.95>}      
object {LittleHand scale <2.5,5.5,1> rotate <0,0,-345> translate <0,0,-1.95>}                           
//object {GlassHead translate <.75,0,0>}