#include "colors.inc"
#include "stones1.inc"
#include "textures.inc"
#include "metals.inc"
#include "skies.inc"

camera{location<-.1,-3.7,-1.9> look_at<.2,-3.325,.05>}

light_source{<-1,-2,-.4> color White}

sky_sphere{S_Cloud4}

#declare L=2.1
#declare B=.5

#declare Wht=pigment{
  granite
  turbulence 0.0
  color_map{
    [0.0, 0.3 color Mica color White]
    [0.3, 0.4 color White color White]
    [0.4, 0.6 color White color White]
    [0.6, 1.0 color White color White]}
  scale <1, 2, 2> rotate <0, 0, -30>}

#declare Blk = texture{
 pigment {granite
   color_map{
     [0.0 color White]
     [0.2 color rgb<0.3,0.3,0.3>]
     [0.4 color rgb<0.1,0.1,0.1>]
     [1.0 color rgb<0.0,0.0,0>]}
   turbulence 0.5}}

#declare Grn = pigment{Jade}

#declare Tex1=texture{
  pigment{
    brick pigment{Grn scale .1} pigment{Wht scale .1}
    brick_size<3000,.2,3000>
    mortar .1
    translate<10,.05,10>}}

#declare Top=intersection{
  cylinder{<-B,0,-L>,<-B,0,L>,1}
  cylinder{< B,0,-L>,< B,0,L>,1}}

#declare Form1=union{
  object{Top}
  box{<-B+.0001,-4,-L-0*.1>,<B,0,L+0*.1>}
  translate -y*1/sqrt(2) translate z*L rotate x*30 translate -y*.08}

#declare Vault=
difference{
  cylinder{<0,-4.99,0>,<0,.2,0>,1.85 clipped_by{plane{-z,1}}}
  union{
    object{Form1 rotate y*45*0}
    object{Form1 rotate y*45*1}
    object{Form1 rotate y*45*2}
    object{Form1 rotate y*45*3}
    object{Form1 rotate y*45*6}
    object{Form1 rotate y*45*7}}}

#declare Wall1=
difference{
  box{<-.6,-5,-2.05>,<.6,.2,-1.75>}
  union{
    object{Top}
    box{<-B,-2.25+.5,-L-.1>,<B,0,L+.1>}
    scale <.92,.9,1> translate -y*1.77}}

#declare Walls1=union{
  object{Wall1 rotate y*45*2}
  object{Wall1 rotate y*45*3}
  object{Wall1 rotate y*45*4}
  object{Wall1 rotate y*45*5}
  object{Wall1 rotate y*45*6}}

#declare Form2=union{
  intersection{
    cylinder{<-.5,0,-.01>,<-.5,0,.21>,1}
    cylinder{< .5,0,-.01>,< .5,0,.21>,1}}
  box{<-.5,-5,-.01>,<.5,0,.21>}
  translate -y*1/sqrt(2)}

#declare Tri=intersection{
  cylinder{<-.5,0,-.01>,<-.5,0,.21>,1}
  cylinder{< .5,0,-.01>,< .5,0,.21>,1}
  cylinder{< 0,.433*2,-.01>,<0,.433*2,.21>,1}}

#declare Form3=union{
  object{Form2 scale<.4,.4,1> translate< .22,-.05,0>}
  object{Form2 scale<.4,.4,1> translate<-.22,-.05,0>}
  object{Tri   scale<.4,.4,1> translate y*.05}
  object{Form2 scale<.5,.5,1> translate< .22,.0,-.15>}
  object{Form2 scale<.5,.5,1> translate<-.22,.0,-.151>}
  object{Tri   scale<.5,.5,1> translate<0,.03,-.15>}
  translate -y*1.8}

#declare Wall2=difference{
  box{<-.6,-4.5,0>,<.6,2,.15>}
  object{Form3}
  translate<0,.37,1.85>}

#declare Walls2=union{
  object{Wall2 rotate y*45*0}
  object{Wall2 rotate y*45*1}
  object{Wall2 rotate y*45*2}
  object{Wall2 rotate y*45*6}
  object{Wall2 rotate y*45*7}}

#declare Board=
  box{<-.7,0,0>,<.7,.07,.35>
    rotate x*-30
    translate<0,-3.42,1.75>
    texture{T_Stone6 scale .1}}

object{Board rotate y*45*0}
object{Board rotate y*45*1}
object{Board rotate y*45*2}
object{Board rotate y*45*6}
object{Board rotate y*45*7}

object{Walls1 texture{Tex1}}
object{Walls2 texture{T_Stone23}}
object{Vault texture{Tex1}}


#default{texture{T_Gold_1A}}

#declare C=.01

#declare Part=difference{
  torus{C,C/2 rotate x*90}
  box{<-C*1.5-.1,-C*1.5-.1,-C/2-.1>,<C*1.5+.1,0,C/2+.1>}}

#declare Link=merge{
  object{Part}
  object{Part rotate x*180 translate -y*C*1.5}
  cylinder{<-C,0,0>,<-C,-C*1.5,0>,C/2}
  cylinder{< C,0,0>,< C,-C*1.5,0>,C/2}}

#declare Links=union{
  object{Link}
  object{Link rotate y*90 translate y*-C*2.5}}

#declare i=0
#while(i<.8/C-3)
  object{Links
    translate -y*i*C*5 rotate x*15 rotate y*-10}
  #declare i=i+1
#end

union{
  torus{C*2,C/2 rotate x*90 translate y*-3.85}
  sphere{<0,-3.9,0>,.05}
  torus{.05,.015 scale<1,.5,1> translate -y*3.9}
  cone{<0,-3.9,0>,.02,<0,-3.99,0>,0}
  translate -y*.01 rotate x*15 rotate y*-10}

#declare Pin=box{<-C,-C,.82>,<C,C,.9>
  rotate z*45 translate -y*4.005}

#declare i=0
#while(i<360)
  object{Pin rotate i*y}
  #declare i=i+30
#end

#declare StarPin=union{
  cone{<0,0,0>,C,<0,0,-.6>,0}
  cone{<0,0,0>,C,<0,0, .6>,0}}

#declare i=0
#while(i<360)
  object{StarPin translate -y*4 rotate y*i}
  object{StarPin scale .75 translate -y*4 rotate y*(i+22.5)}
  #declare i=i+45
 #end

#declare i=0
#while(i<360)
  sphere{<0,-4,.9>,C/1 rotate y*i}
  #declare i=i+6
#end

plane{y,-4.005 texture{T_Stone21 scale .2 finish{Shiny}}}
cone{<0,-4.1,0>,1.1,<0,-4,0>,1 texture{Blk finish{Shiny}}}

torus{.95,C/2 translate y*-4 texture{T_Gold_1A}}

text{ttf "timrom.ttf" "XII" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*0}
text{ttf "timrom.ttf" "  I " 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*1}
text{ttf "timrom.ttf" " II" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*2}
text{ttf "timrom.ttf" " III" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*3}
text{ttf "timrom.ttf" " IV" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*4}
text{ttf "timrom.ttf" "  V" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*5}
text{ttf "timrom.ttf" "  VI" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*6}
text{ttf "timrom.ttf" " VII" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*7}
text{ttf "timrom.ttf" "VIII" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*8}
text{ttf "timrom.ttf" " IX" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*9}
text{ttf "timrom.ttf" "  X" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7>  rotate y*30*10}
text{ttf "timrom.ttf" " XI" 1,0 scale .1 rotate x*90
  translate<-.08,-3.999,.7> rotate y*30*11}
