#declare Crystal = texture {
	pigment { color rgbf <0.98, 0.98, 1, 0.9> }
	finish {
		ambient 0.1
		diffuse 0.8
		phong 1 phong_size 50
		reflection 0.1
		refraction 1
		ior 1.5
	}
}

#declare Number = 10
#declare Angle1 = 60
#declare Angle2 = 360/Number
#declare Angle3 = 45
#declare Angle4 = 20

#declare Facets = intersection {
	plane {y, 0 rotate -x*Angle1 translate -z*0.5}
	plane {y, 0 rotate -x*Angle3 translate -z*0.5 rotate y*Angle2/2}
	plane {y, 0 rotate -x*Angle4 translate y*0.29 rotate y*Angle2/2}

	plane {y, 0 rotate -x*Angle1 translate -z*0.5 rotate z*180}
	plane {y, 0 rotate -x*Angle3 translate -z*0.5 rotate y*Angle2/2 rotate z*180}
	plane {y, 0 rotate -x*Angle4 translate y*0.29 rotate y*Angle2/2 rotate z*180}

	plane {y, 0.2}
	plane {y, -0.2 inverse}
}

#declare Diamond = intersection {
	#declare Cycle = 0
	#while (Cycle < Number)
		object {Facets rotate y*Cycle*Angle2}
		#declare Cycle = Cycle + 1
	#end

	scale <0.7, 1.1, 0.7>
	scale 1.1
	bounded_by {sphere {0, 1.2}}

	texture {Crystal}
}

#declare Ring1 = union {
	#declare Cycle = 0
	#while (Cycle < 12 )
		object {
			Diamond
			scale 0.4
			rotate x*30*Cycle
			translate -x*1.1
			rotate y*Cycle*30
		}
		#declare Cycle = Cycle + 1
	#end
}

#declare Ring2 = union {
	#declare Cycle = 0
	#while (Cycle < 10 )
		object {
			Diamond
			scale 0.4
			rotate x*30*Cycle
			translate -x*0.7
			rotate y*Cycle*30
		}
		#declare Cycle = Cycle + 1
	#end
}

#declare Rings = union {
	object {
		Ring1
		rotate -x*20
		translate <-0.4, 3, 0>
	}
	object {
		Ring2
		rotate x*5
		translate <0.3, -2.2, 0>
	}

	rotate y*5
	rotate z*50
	rotate y*10
	translate y*5
}
