#declare Leg = blob {
	threshold 0.6
	// leg
	sphere {0, 0.8 strength 1 scale <5, 1, 1> translate -x*0.4}
	sphere {0, 0.35 strength 1 scale <2.5, 1, 1> translate -x*2.5}
	// back
	sphere {0, 0.5 strength 1 scale <1, 1, 0.8> translate <0, 0.2, 0>}
	sphere {0, 0.4 strength 1 scale <1.4, 1, 0.8> translate <0.3, 0.1, 0>}

	rotate -x*90
}

#declare Legs = union {
	union {
		object {Leg rotate z*110 translate x*0.28}
		object {Leg rotate z*80 translate -x*0.28}

		pigment {color rgb <1, 0.75, 0.5>}
		finish {
			ambient 0.12
			diffuse 0.8
			phong 0.12
			phong_size 20
		}
	}
	prism {				// shirt
		cubic_spline
		linear_sweep
		0,
		1.0,
		16,

		<-0.4, 0.1>,
		<-0.4, 0.1>, <-0.38, 0.24>, <-0.34, 0.34>, <-0.26, 0.36>,
		<-0.18, 0.34>, <-0.08, 0.34>, <0, 0.32>, <0.1, 0.34>,
		<0.2, 0.3>, <0.26, 0.26>, <0.3, 0.2>, <0.34, 0.1>, <0, -0.2>,
		<-0.4, 0.1>,
		<-0.38, 0.24>
		open

		pigment {
			gradient y
			color_map {
				[0 0.6 color rgb 1 color rgb 1]
				[0.6 1 color rgb <1, 0, 0.4> color rgb <1, 0, 0.4>]
			}
			frequency 15
		}
		finish {ambient 0.2 diffuse 0.85 phong 0.2 phong_size 15}

		rotate x*180
		scale 2
		translate <0.05, 1.9, 0.1>
	}
}
