#declare My_gold = texture {
	pigment {color rgb <1, 0.8, 0.6>}
	finish {
		metallic
		ambient 0.22
		diffuse 0.7
		reflection 0.15
		brilliance 8
		specular 0.8
		roughness 0.04
   }
}

#declare Watch = union {
	torus {0.7, 0.3 rotate x*90
		texture {My_gold}
	}
	cylinder {<0, 0, -0.3>, <0, 0, 0.3>, 0.7
		pigment {color rgb 1}
		finish {ambient 0.2 diffuse 0.8 phong 0.3 phong_size 20}
	}
	torus {0.7, 0.05 rotate x*90 translate -z*0.3 texture {My_gold}}
	sphere {0, 0.7 scale <1, 1, 0.2>
		pigment {color rgbf <1, 1, 1, 0.98>}
		finish {ambient 0.12 phong 1 phong_size 85}
		translate -z*0.3
	}
	difference {
		union {
			torus {1.4, 0.04 rotate x*90 translate -y*0.25}
			torus {1.2, 0.04 rotate x*90 translate -y*0.15}
		}
		box {<-0.3, 0, -0.1>, <0.3, 1.5, 0.1>}
		texture {My_gold}
	}
	union {
		cylinder {<-0.3, 0.8, 0>, <-0.3, 1.2, 0>, 0.05}
		cylinder {<0.3, 0.8, 0>, <0.3, 1.2, 0>, 0.05}
		difference {
			torus {0.3, 0.05 rotate x*90}
			plane {y, 0}
			translate y*1.2
		}
		texture {My_gold}
	}
	union {
		cylinder {<0, 0.8, 0>, <0, 1.15, 0>, 0.06}
		torus {0.14, 0.05 translate y*1.15}
		sphere {0, 0.14 scale <1, 0.8, 1> translate y*1.15}
		texture {My_gold}
	}
	union {
		box {<-0.015, 0.4, -0.015>, <0.015, 0.6, 0.015> rotate y*45}
		box {<-0.015, 0.4, -0.015>, <0.015, 0.6, 0.015> rotate <0, 45, 90>}
		box {<-0.015, 0.4, -0.015>, <0.015, 0.6, 0.015> rotate <0, 45, 180>}
		box {<-0.015, 0.4, -0.015>, <0.015, 0.6, 0.015> rotate <0, 45, 270>}
		sphere {<0, 0.5, 0>, 0.03 scale <1, 1, 0.5> rotate z*30}
		sphere {<0, 0.5, 0>, 0.03 scale <1, 1, 0.5> rotate z*60}
		sphere {<0, 0.5, 0>, 0.03 scale <1, 1, 0.5> rotate z*120}
		sphere {<0, 0.5, 0>, 0.03 scale <1, 1, 0.5> rotate z*150}
		sphere {<0, 0.5, 0>, 0.03 scale <1, 1, 0.5> rotate z*210}
		sphere {<0, 0.5, 0>, 0.03 scale <1, 1, 0.5> rotate z*240}
		sphere {<0, 0.5, 0>, 0.03 scale <1, 1, 0.5> rotate z*300}
		sphere {<0, 0.5, 0>, 0.03 scale <1, 1, 0.5> rotate z*330}

		translate -z*0.3
		texture {My_gold}
	}
	union {
		cylinder {<0, 0, -0.3>, <0, 0, -0.325>, 0.05}
		cylinder {<0, 0, -0.31>, <0, 0, -0.32>, 0.05}
		box {<-0.015, 0, -0.31>, <0.015, 0.3, -0.32> rotate -z*20}
		box {<-0.015, 0, -0.31>, <0.015, 0.4, -0.32> rotate z*55}

		texture {My_gold}
	}
}

#declare Sc = 0.1

#declare Part1 = union {
	intersection {
		torus {0.5, 0.25 rotate x*90}
		plane {x, 0}
		translate -x*0.5
	}
	intersection {
		torus {0.5, 0.25 rotate x*90}
		plane {-x, 0}
		translate x*0.5
	}
	cylinder {<-0.5, 0.5, 0>, <0.5, 0.5, 0>, 0.25}
	cylinder {<-0.5, -0.5, 0>, <0.5, -0.5, 0>, 0.25}

	scale Sc

	texture {My_gold}
}

#declare Part2 = union {
	object {Part1}
	object {Part1 rotate x*90 translate x*1.5*Sc}
}

#declare Part4 = union {
	object {Part2}
	object {Part2 translate x*2*1.5*Sc}
}

#declare Part8 = union {
	object {Part4}
	object {Part4 translate x*4*1.5*Sc}
}

#declare Part16 = union {
	object {Part8}
	object {Part8 translate x*8*1.5*Sc}
}

#declare Part32 = union {
	object {Part16}
	object {Part16 translate x*16*1.5*Sc}
}

#declare Part64 = union {
	object {Part32}
	object {Part32 translate x*32*1.5*Sc}
}

#declare Part128 = union {
	object {Part64}
	object {Part64 translate x*64*1.5*Sc}
}

#declare Part256 = union {
	object {Part128}
	object {Part128 translate x*128*1.5*Sc}
}

#declare Chain1 = union {
	object {
		Part64
		rotate x*90
		translate -x*(65*1.5*Sc)
		translate <-0.35, 1.2, 0>
	}
	torus {0.2, 0.025		// left ring
		translate <-0.425, 1.2, 0>

		texture {My_gold}
	}
	object {
		Part256
		rotate -y*30
		rotate z*55
		translate -x*(65*1.5*Sc)
		translate <-0.35, 1.2, 0>
	}

	translate x*0.3
	rotate y*20
	translate -x*0.3

	translate -y*1.2
	rotate -z*60
	translate y*1.2
}

#declare Chain2 = union {
	difference {
		torus {0.2, 0.025		// right ring
			rotate x*90
		}
		intersection {
			plane {y, 0 rotate z*80}
			plane {y, 0 rotate -z*80}
			translate y*0.1
		}
	}
	union {
		object {Part8 rotate x*90}
		object {
			Part4
			rotate x*90 rotate -z*25
			translate x*8*1.5*Sc
		}
		object {
			Part4
			rotate x*90 rotate -z*15
			translate x*4*1.5*Sc
			rotate -z*25
			translate x*8*1.5*Sc
		}
		object {
			Part4
			rotate x*90  rotate -z*5
			translate x*4*1.5*Sc
			rotate -z*15
			translate x*4*1.5*Sc
			rotate -z*25
			translate x*8*1.5*Sc
		}
		object {
			Part4
			rotate x*90  rotate -z*18
			translate x*4*1.5*Sc
			rotate -z*5
			translate x*4*1.5*Sc
			rotate -z*15
			translate x*4*1.5*Sc
			rotate -z*25
			translate x*8*1.5*Sc
		}
		object {
			Part32
			rotate x*90 rotate -z*18
			translate x*4*1.5*Sc
			rotate -z*18
			translate x*4*1.5*Sc
			rotate -z*5
			translate x*4*1.5*Sc
			rotate -z*15
			translate x*4*1.5*Sc
			rotate -z*25
			translate x*8*1.5*Sc
		}

		translate x*0.25
		rotate z*90
		rotate -y*45
	}

	scale 1.5
	scale 0.045
	translate <0.26, 0.23, -0.25>

	texture {My_gold}
}

#declare Watch_chain = union {
	union {
		object {Watch}
		object {Chain1}
		scale 0.045
	}
	object {Chain2 translate <0.5, -0.4, 0.7>}
}