#declare Bld3_wall = texture {
	pigment {color rgb <0.43, 0.48, 0.4>}
	finish {ambient 0.12 diffuse 0.85 phong 0.1 phong_size 60}
}

#declare Bld3_gr = texture {
	pigment {color rgb <0.78, 0.83, 0.75>}
	finish {ambient 0.12 diffuse 0.8 phong 0.01 phong_size 85}
}

#declare Light_wind3 = texture {
	pigment {color rgb <0.6, 0.6, 0.55>}
	finish {ambient 1 diffuse 0.6}
}

#declare Frame_txt3 = texture {
	pigment {color rgb <0.2, 0.22, 0>}
	finish {ambient 0.12 diffuse 0.8 phong 0.4}
}

#declare Top_txt = texture {
	pigment {color rgb <0, 0.7, 0.54>}
	finish {metallic ambient 0.1 diffuse 0.8 phong 0.2}
}

#declare Door1 = union {
	box {<-0.1, 0, -0.81>, <0.1, 0.35, -0.8>}
	box {<-0.08, 0, -0.82>, <0.08, 0.32, -0.8>}
	union {		// frame
		// hor.
		box {<-0.05, 0, -0.825>, <0.05, 0.005, -0.8>}
		box {<-0.05, 0.295, -0.825>, <0.05, 0.3, -0.8>}
		box {<-0.05, 0.1-0.002, -0.825>, <0.05, 0.1+0.002, -0.8>}
		box {<-0.05, 0.2-0.002, -0.825>, <0.05, 0.2+0.002, -0.8>}
		// vert.
		box {<-0.05, 0, -0.825>, <-0.045, 0.3, -0.8>}
		box {<0.045, 0, -0.825>, <0.05, 0.3, -0.8>}
		box {<0-0.002, 0, -0.825>, <0+0.002, 0.3, -0.8>}
		box {<0.025-0.002, 0, -0.825>, <0.025+0.002, 0.3, -0.8>}
		box {<-0.025-0.002, 0, -0.825>, <-0.025+0.002, 0.3, -0.8>}
		texture {Frame_txt3}
	}
	// light
	box {<-0.0499, 0.001, -0.824>, <0.0499, 0.299, -0.8> texture {Light_wind3}}
	texture {Bld3_wall}
}

#declare Door2 = union {
	box {<-0.1, 0, -0.81>, <0.1, 0.3, -0.8>}
	box {<-0.08, 0, -0.82>, <0.08, 0.28, -0.8>}
	union {		// frame
		// hor.
		box {<-0.05, 0, -0.825>, <0.05, 0.005, -0.8>}
		box {<-0.05, 0.245, -0.825>, <0.05, 0.25, -0.8>}
		box {<-0.05, (0.25/3)-0.002, -0.825>, <0.05, (0.25/3)+0.002, -0.8>}
		box {<-0.05, 2*(0.25/3)-0.002, -0.825>, <0.05, 2*(0.25/3)+0.002, -0.8>}
		// vert.
		box {<-0.05, 0, -0.825>, <-0.045, 0.25, -0.8>}
		box {<0.045, 0, -0.825>, <0.05, 0.25, -0.8>}
		box {<0-0.002, 0, -0.825>, <0+0.002, 0.25, -0.8>}
		box {<0.025-0.002, 0, -0.825>, <0.025+0.002, 0.25, -0.8>}
		box {<-0.025-0.002, 0, -0.825>, <-0.025+0.002, 0.25, -0.8>}
		texture {Frame_txt3}
	}
	// light
	box {<-0.0499, 0.001, -0.824>, <0.0499, 0.249, -0.8> texture {Light_wind3}}
	texture {Bld3_wall}
}

#declare Window1 = union {
	box {<0, 0, -0.01>, <0.125, 0.28, 0>}
	box {<-0.005, 0.28, -0.015>, <0.13, 0.29, 0>}
	box {<-0.01, 0.29, -0.02>, <0.135, 0.3, 0>}
	union {		// frame
		// hor.
		box {<0.025, 0.05, -0.015>, <0.1, 0.055, 0>}
		box {<0.025, 0.245, -0.015>, <0.1, 0.25, 0>}
		box {<0.025, 0.1-0.002, -0.015>, <0.1, 0.1+0.002, 0>}
		box {<0.025, 0.15-0.002, -0.015>, <0.1, 0.15+0.002, 0>}
		box {<0.025, 0.2-0.002, -0.015>, <0.1, 0.2+0.002, 0>}
		// vert.
		box {<0.025, 0.05, -0.015>, <0.03, 0.25, 0>}
		box {<0.095, 0.05, -0.015>, <0.1, 0.25, 0>}
		box {<0.05-0.002, 0.05, -0.015>, <0.05+0.002, 0.25, 0>}
		box {<0.075-0.002, 0.05, -0.015>, <0.075+0.002, 0.25, 0>}
		texture {Frame_txt3}
	}
	// light
	box {<0.0252, 0.052, -0.012>, <0.099, 0.249, 0> texture {Light_wind3}}
	texture {Bld3_wall}
}

#declare Window2 = union {
	box {<0, 0, -0.01>, <0.125, 0.23, 0>}
	box {<-0.005, 0.23, -0.015>, <0.13, 0.24, 0>}
	box {<-0.01, 0.24, -0.02>, <0.135, 0.25, 0>}
	union {		// frame
		// hor.
		box {<0.025, 0.05, -0.015>, <0.1, 0.055, 0>}
		box {<0.025, 0.195, -0.015>, <0.1, 0.2, 0>}
		box {<0.025, 0.1-0.002, -0.015>, <0.1, 0.1+0.002, 0>}
		box {<0.025, 0.15-0.002, -0.015>, <0.1, 0.15+0.002, 0>}
		// vert.
		box {<0.025, 0.05, -0.015>, <0.03, 0.2, 0>}
		box {<0.095, 0.05, -0.015>, <0.1, 0.2, 0>}
		box {<0.05-0.002, 0.05, -0.015>, <0.05+0.002, 0.2, 0>}
		box {<0.075-0.002, 0.05, -0.015>, <0.075+0.002, 0.2, 0>}
		texture {Frame_txt3}
	}
	// light
	box {<0.0252, 0.052, -0.012>, <0.099, 0.199, 0> texture {Light_wind3}}

	texture {Bld3_wall}
}

#declare Column1 = union {
	cylinder {0, <0, 0.01, 0>, 0.04}
	cylinder {<0, 0.01, 0>, <0, 0.02, 0>, 0.035}
	cone {<0, 0.02, 0>, 0.03, <0, 0.33, 0>, 0.02}
	cylinder {<0, 0.33, 0>, <0, 0.34, 0>, 0.025}
	cylinder {<0, 0.34, 0>, <0, 0.35, 0>, 0.03}

	texture {Bld3_gr}
}

#declare Column2 = union {
	cylinder {0, <0, 0.01, 0>, 0.03}
	cylinder {<0, 0.01, 0>, <0, 0.02, 0>, 0.025}
	cone {<0, 0.02, 0>, 0.02, <0, 0.23, 0>, 0.015}
	cylinder {<0, 0.23, 0>, <0, 0.24, 0>, 0.02}
	cylinder {<0, 0.24, 0>, <0, 0.25, 0>, 0.025}

	texture {Bld3_gr}
}

#declare Column3 = union {
	cylinder {0, <0, 0.01, 0>, 0.03}
	cylinder {<0, 0.01, 0>, <0, 0.02, 0>, 0.025}
	cone {<0, 0.02, 0>, 0.02, <0, 0.28, 0>, 0.015}
	cylinder {<0, 0.28, 0>, <0, 0.29, 0>, 0.02}
	cylinder {<0, 0.29, 0>, <0, 0.3, 0>, 0.025}

	texture {Bld3_gr}
}

#declare Col_sm = union {
	cylinder {0, <0, 0.005, 0>, 0.01}
	sphere {<0, 0.025, 0>, 0.025 scale <0.4, 1, 0.4>}
	cylinder {<0, 0.045>, <0, 0.05, 0>, 0.01}

	texture {Bld3_gr}
}

#declare Tower1 = union {
	box {<-0.2, 0, -0.2>, <0.2, 0.8, 0.2> texture {Bld3_wall}}	// main block
	box {<-0.19, 0.8, -0.19>, <0.19, 1.05, 0.19> texture {Bld3_wall}}
	union {			// corners
		box {<-0.21, 0, -0.21>, <-0.15, 0.8, -0.15>}
		box {<-0.21, 0, -0.21>, <-0.15, 0.8, -0.15> rotate y*90}
		box {<-0.21, 0, -0.21>, <-0.15, 0.8, -0.15> rotate y*180}
		box {<-0.21, 0, -0.21>, <-0.15, 0.8, -0.15> rotate y*270}
	}
	box {<-0.21, 0, -0.21>, <0.21, 0.05, 0.21>}	// base
	box {<-0.21, 0.35, -0.24>, <0.24, 0.4, 0.21>}	// fronton
	box {<-0.21, 0.65, -0.24>, <0.24, 0.69, 0.21>}	// fronton
	box {<-0.215, 0.69, -0.245>, <0.245, 0.7, 0.215>}	// fronton
	box {<-0.21, 0.77, -0.21>, <0.21, 0.79, 0.21>}	// fronton
	box {<-0.22, 0.79, -0.22>, <0.22, 0.8, 0.22>}	// fronton
	box {<-0.22, 1.05, -0.22>, <0.22, 1.09, 0.22>}	// fronton
	box {<-0.23, 1.09, -0.23>, <0.23, 1.1, 0.23>}	// fronton
	// columns
	object {Column1 translate <-0.15, 0, -0.21>}
	object {Column1 translate <0.15, 0, -0.21>}
	object {Column1 translate <0.21, 0, -0.15>}
	object {Column1 translate <0.21, 0, 0.15>}

	object {Column2 translate <-0.15, 0.4, -0.21>}
	object {Column2 translate <0.15, 0.4, -0.21>}
	object {Column2 translate <0.21, 0.4, -0.15>}
	object {Column2 translate <0.21, 0.4, 0.15>}

	#declare Cycle = 0
	#while (Cycle < 4)
		union {
			object {Column2 translate <-0.16, 0.8, -0.19>}
			object {Column2 translate <-0.1, 0.8, -0.19>}
			object {Column2 translate <0.16, 0.8, -0.19>}
			object {Column2 translate <0.1, 0.8, -0.19>}
			object {Window2 translate <-0.125/2, 0.8, -0.19> rotate -y*90}
			rotate y*90*Cycle
		}
	#declare Cycle = Cycle + 1
	#end

	// windows
	object {Window2 translate <-0.125/2, 0.05, -0.2>}
	object {Window2 translate <-0.125/2, 0.05, -0.2> rotate -y*90}
	object {Window2 translate <-0.125/2, 0.4, -0.2>}
	object {Window2 translate <-0.125/2, 0.4, -0.2> rotate -y*90}

	// dom
	intersection {
		cylinder {<-1, 0, 0>, <1, 0, 0>, 0.21}
		cylinder {<-1, 0, 0>, <1, 0, 0>, 0.21 rotate y*90}
		plane {-y, 0}
		scale <1, 1.3, 1>
		translate y*1.1
    	texture {Top_txt}
	}
	cylinder {<0, 1.1, 0>, <0, 1.1+0.21*1.3+0.04, 0>, 0.08 texture {Bld3_wall}}
	cylinder {<0, 1.1+0.21*1.3+0.04, 0>, <0, 1.1+0.21*1.3+0.06, 0>, 0.09 texture {Bld3_gr}}
	cylinder {<0, 1.1+0.21*1.3+0.06, 0>, <0, 1.1+0.21*1.3+0.07, 0>, 0.1 texture {Bld3_gr}}
	difference {
		sphere {0, 0.11}
		plane {y, 0}
		scale <1, 0.5, 1>
		translate y*(1.1+0.21*1.3+0.07)
		texture {Top_txt}
	}
	union {
		sphere {0, 0.09}
		sphere {<0, 0.09+0.03, 0>, 0.03}
		cone {<0, 0.09+0.03, 0>, 0.015 <0, 0.09+0.03+0.3, 0>, 0}
		sphere {<0, 0.09+0.03+0.3, 0>, 0.015}
		cylinder {<0, -0.005, 0>, <0, 0.005, 0>, 0.095}

		translate y*(1.1+0.21*1.3+0.19)
		texture {Top_txt}
	}

	texture {Bld3_gr}
}

#declare Dom_section = difference {
	sphere {0, 0.41}
	plane {x, -0.001}
	plane {x, 0.001 inverse}
	plane {y, 0}
	scale <1, 1.2, 1>
	translate y*1.25
	texture {Top_txt}
}

#declare Tower2 = union {
	cylinder {0, <0, 0.85, 0>, 0.42}	// main 1
	intersection {
		plane {z, 0 rotate y*360/8 translate z*0.5 rotate y*360/8*0}
		plane {z, 0 rotate y*360/8 translate z*0.5 rotate y*360/8*1}
		plane {z, 0 rotate y*360/8 translate z*0.5 rotate y*360/8*2}
		plane {z, 0 rotate y*360/8 translate z*0.5 rotate y*360/8*3}
		plane {z, 0 rotate y*360/8 translate z*0.5 rotate y*360/8*4}
		plane {z, 0 rotate y*360/8 translate z*0.5 rotate y*360/8*5}
		plane {z, 0 rotate y*360/8 translate z*0.5 rotate y*360/8*6}
		plane {z, 0 rotate y*360/8 translate z*0.5 rotate y*360/8*7}
		plane {y, 0.85 inverse}
		plane {y, 1.2}
		rotate y*360/8/2
	}
	cylinder {<0, 0.85, 0>, <0, 0.88, 0>, 0.425 texture {Bld3_gr}}	// fronton
	cylinder {<0, 0.88, 0>, <0, 0.9, 0>, 0.43 texture {Bld3_gr}}	// fronton
	cylinder {<0, 1.2, 0>, <0, 1.21, 0>, 0.43 texture {Bld3_gr}}	// fronton
	cylinder {<0, 1.21, 0>, <0, 1.24, 0>, 0.42 texture {Bld3_gr}}	// fronton
	cylinder {<0, 1.24, 0>, <0, 1.25, 0>, 0.43 texture {Bld3_gr}}	// fronton

	#declare Cycle = 0
	#while (Cycle < 8)
		object {Column3 translate <0, 0.9, -0.4> rotate y*Cycle*(360/8)}
	#declare Cycle = Cycle + 1
	#end

	// dom
	difference {
		sphere {0, 0.4}
		plane {y, 0}
		scale <1, 1.2, 1>
		translate y*1.25
		texture {Top_txt}
	}
	#declare Cycle = 0
	#while (Cycle < 8)
		object {Dom_section rotate y*Cycle*(360/8)/2}
	#declare Cycle = Cycle + 1
	#end

	//windows
	union {
		#declare Cycle = 0
		#while (Cycle < 8)
			object {Window2 translate <-0.125/2, 0.9, -0.37> rotate y*Cycle*360/8}
		#declare Cycle = Cycle + 1
		#end
		rotate y*360/8/2
	}

	difference {
		cylinder {0, <0, 0.005, 0>, 0.41}
		cylinder {<0, -0.1, 0>, <0, 0.1, 0>, 0.39}
		translate y*0.95
		texture {Bld3_gr}
	}
	#declare Cycle = 0
	#while (Cycle < 72)
		object {Col_sm translate <0, 0.9, -0.4> rotate y*Cycle*360/72}
	#declare Cycle = Cycle + 1
	#end

	// top
	cylinder {<0, 1.6, 0>, <0, 1.78, 0>, 0.12}
	cylinder {<0, 1.78, 0>, <0, 1.79, 0>, 0.125 texture {Bld3_gr}}
	cylinder {<0, 1.79, 0>, <0, 1.8, 0>, 0.13 texture {Bld3_gr}}

	#declare Cycle = 0
	#while (Cycle < 10)
		object {Column2 scale 0.5 translate <0, 1.8, -0.11> rotate y*Cycle*360/10}
	#declare Cycle = Cycle + 1
	#end

	cylinder {<0, 1.925, 0>, <0, 1.96, 0>, 0.13 texture {Bld3_gr}}
	cylinder {<0, 1.96, 0>, <0, 1.97, 0>, 0.135 texture {Bld3_gr}}
	union {
		difference {
			sphere {0, 0.13}
			plane {y, 0}
		}
		sphere {<0, 0.13+0.04-0.01, 0>, 0.04}
		cone {<0, 0.13+0.04-0.01, 0>, 0.02, <0, 0.13+0.3, 0>, 0}
		sphere {<0, 0.13+0.3, 0>, 0.015}

		light_source {<0.2, 0.13+0.3+0.3, 0> color rgb <0.6, 0.7, 0.65>
			fade_distance 1
			fade_power 2
		}

		translate y*1.97
		texture {Top_txt}
	}

	texture {Bld3_wall}
}

#declare Front_part = union {
	box {<-0.8, 0, -0.8>, <0.8, 0.65, -0.45>}	// main block
	union {
		box {<-0.8, 0, -0.82>, <0.8, 0.05, -0.45>}	// base
		box {<-0.8, 0.35, -0.82>, <0.8, 0.4, -0.45>}	// fronton
		box {<-0.8, 0.65, -0.82>, <0.8, 0.69, -0.45>}	// fronton
		box {<-0.8, 0.69, -0.83>, <0.8, 0.7, -0.45>}	// fronton
		box {<0.275, 0, -0.81>, <0.325, 0.65, -0.8>}	// vert.
		box {<0.275, 0, -0.81>, <0.325, 0.65, -0.8> translate -x*0.6} // vert.
		union {				// balc.
			box{<-0.325, 0.35, -0.95>, <0.325, 0.39, -0.8>}
			box{<-0.326, 0.39, -0.96>, <0.326, 0.4, -0.8>}
			difference {
				box{<-0.326, 0.45, -0.96>, <0.326, 0.46, -0.8>}
				box{<-0.306, 0.4, -0.94>, <0.306, 0.6, -0.6>}
			}
			object {Column1 translate <0.325-0.03, 0, -0.95+0.03>}
			object {Column1 translate <-0.325+0.03, 0, -0.95+0.03>}
			object {Column2 translate <0.3, 0.4, -0.81>}
			object {Column2 translate <-0.3, 0.4, -0.81>}
			#declare Cycle = 0
			#while (Cycle < 13)
				object {Col_sm translate <0.3-Cycle*0.05, 0.4, -0.95>}
			#declare Cycle = Cycle + 1
			#end
			object {Col_sm translate <0.3, 0.4, -0.9>}
			object {Col_sm translate <0.3, 0.4, -0.85>}
			object {Col_sm translate <-0.3, 0.4, -0.9>}
			object {Col_sm translate <-0.3, 0.4, -0.85>}
		}
		union {				// top center
			box {<-0.325, 0.65, -0.85>, <0.325, 0.69, -0.8>}
			box {<-0.326, 0.69, -0.86>, <0.326, 0.7, -0.8>}
			difference {	// roof
				intersection {
					plane {x, 0 rotate z*(degrees(acos(1/sqrt(1+pow(3.5, 2)))))	translate x*0.35}
					plane {-x, 0 rotate -z*(degrees(acos(1/sqrt(1+pow(3.5, 2))))) translate -x*0.35}
					plane {-y, 0}
					plane {z, -0.8+0.175}
					plane {z, -0.88 inverse}
					translate y*0.7
					texture {Top_txt}
				}
				intersection {
					plane {x, 0 rotate z*(degrees(acos(1/sqrt(1+pow(3.5, 2)))))	translate x*0.35}
					plane {-x, 0 rotate -z*(degrees(acos(1/sqrt(1+pow(3.5, 2))))) translate -x*0.35}
					plane {-y, 0}
					plane {z, -0.87}
					plane {z, -1 inverse}
					translate y*0.69
					texture {Bld3_gr}
				}
			}
			#declare Cycle = 0
			#while (Cycle < 13)
				box {0, 0.025 translate <0.3-0.0125-Cycle*0.05, 0.675, -0.86>}
			#declare Cycle = Cycle + 1
			#end
		}
		texture {Bld3_wall}
	}
	intersection {	// roof
		plane {-z, 0 rotate x*(degrees(acos(2/sqrt(4+pow(4.1, 2)))))}
		plane {z, 0 rotate -x*(degrees(acos(2/sqrt(4+pow(4.1, 2)))))
			translate z*0.41
		}
		plane {-y, 0}
		plane {x, 0.8}
		plane {x, -0.8 inverse}
		translate <0, 0.7, -0.83>
		texture {Top_txt}
	}
	// windows 1fl.
	object {Window1 translate <-0.6-0.125, 0.05, -0.8>}
	object {Window1 translate <-0.4-0.125, 0.05, -0.8>}
	object {Window1 translate <-0.125-0.125, 0.05, -0.8>}
	object {Window1 translate <0.125, 0.05, -0.8>}
	object {Window1 translate <0.4, 0.05, -0.8>}
	object {Window1 translate <0.6, 0.05, -0.8>}

	// windows 2fl.
	object {Window2 translate <-0.6-0.125, 0.4, -0.8>}
	object {Window2 translate <-0.4-0.125, 0.4, -0.8>}
	object {Window2 translate <-0.125-0.125, 0.4, -0.8>}
	object {Window2 translate <0.125, 0.4, -0.8>}
	object {Window2 translate <0.4, 0.4, -0.8>}
	object {Window2 translate <0.6, 0.4, -0.8>}
	object {Door1}
	object {Door2 translate y*0.35}

	texture {Bld3_gr}
}

#declare Bld3 = union {
	object {Front_part rotate y*0}
	object {Front_part translate -z*0.35 rotate y*270}
	object {Tower1 translate <1, 0, -0.8+0.175>}
	object {Tower1 translate <1, 0, -0.8+0.175> rotate y*180}
	object {Tower1 rotate y*90 translate <-1, 0, -0.8+0.175>}
	object {Tower1 rotate y*90 translate <-1, 0, -0.8+0.175> rotate y*180}
	object {Tower2 translate y*0.05}
}