#declare T_wall = texture {
	pigment {
		brick
		pigment {color rgb 0.45}, pigment {color rgb <0.4, 0, 0>}
		brick_size <1, 0.6, 0.8>
		mortar 0.1
	}
	normal {
		brick
		normal {bumps 0.2 scale 0.01}, normal {bumps 0.1 scale 0.01}
		brick_size <1, 0.6, 0.8>
		mortar 0.1
	}
	finish {ambient 0.12 diffuse 0.8 phong 0.1 phong_size 85}
	scale 0.025
}

#declare T_base = texture {
	pigment {
		brick
		pigment {color rgb 0.7}, pigment {color rgb 0.6}
		brick_size <1, 0.7, 0.8>
		mortar 0.05
	}
	normal {
		brick
		normal {bumps 0.2 scale 0.01}, normal {bumps 0.1 scale 0.01}
		brick_size <1, 0.7, 0.8>
		mortar 0.05
	}
	finish {ambient 0.12 diffuse 0.8 phong 0.1 phong_size 85}
	scale 0.03
}

#declare T_gr = texture {
	pigment {color rgb 0.6}
	finish {ambient 0.12 diffuse 0.8 phong 0.01 phong_size 85}
	normal {bumps 0.01 scale 0.002}
}

#declare T_light = texture {
	pigment {color rgb <0.7, 0.65, 0.6>}
	finish {ambient 1}
}

#declare T_frame = texture {
	pigment {color rgb <0.15, 0, 0.02>}
	finish {ambient 0.12 diffuse 0.8 phong 0.4}
}

#declare T_top = texture {
	pigment {color rgb <0.1, 0.25, 0>}
	finish {metallic ambient 0.14 diffuse 0.85 phong 0.8}
	normal {radial 0.1 frequency 25}
}

#declare T_top_1 = texture {
	pigment {color rgb <0.1, 0.25, 0>}
	finish {metallic ambient 0.14 diffuse 0.85 phong 0.8}
	normal {quilted -2 control0 0 control1 0
		scale <0.02, 0.04, 0.02>
	}
}

#declare Clock_bright = texture {
	pigment {color rgb <0.85, 0.82, 0.7>}
	finish {metallic ambient 0.12 diffuse 0.85 phong 1}
}

#declare Clock_dark = texture {
	pigment {color rgb <0.25, 0.04, 0>}
	finish {metallic ambient 0.12 diffuse 0.85 phong 0.2}
}

#declare T_window = union {
	intersection {
		plane {-y, -0.1}
		union {
			difference {
				union {
					cylinder {<0, 0.14, -0.2>, <0, 0.14, 0.2>, 0.04}
					box {<-0.04, 0.1, -0.2>, <0.04, 0.14, 0.2>}
				}
				union {
					cylinder {<0, 0.14, -0.2>, <0, 0.14, 0.2>, 0.03}
					box {<-0.03, 0.1, -0.2>, <0.03, 0.14, 0.2>}
				}
			}
			box {<-0.002, 0.1, -0.2>, <0.002, 0.18, 0.2>}
			box {<-0.04, 0.12, -0.2>, <0.04, 0.124, 0.2>}
			box {<-0.04, 0.145, -0.2>, <0.04, 0.149, 0.2>}
		}
		cylinder {<0, 0, 0>, <0, 0.2, 0>, 0.12}
		texture {T_frame}
	}
	intersection {
		plane {-y, -0.1}
		union {
			cylinder {<0, 0.14, -0.2>, <0, 0.14, 0.2>, 0.03}
			box {<-0.03, 0.1, -0.2>, <0.03, 0.14, 0.2>}
		}
		cylinder {<0, 0, 0>, <0, 0.2, 0>, 0.115}
		texture {T_light}
	}
}

#declare Column = union {
	cylinder {<0, 0.35, 0>, <0, 0.355, 0>, 0.013}
	cylinder {<0, 0.355, 0>, <0, 0.36, 0>, 0.012}
	cylinder {<0, 0.36, 0>, <0, 0.42, 0>, 0.01}
	cylinder {<0, 0.42, 0>, <0, 0.425, 0>, 0.012}
	cylinder {<0, 0.425, 0>, <0, 0.43, 0>, 0.013}
	texture {T_gr}
	translate z*0.07
	rotate y*22.5
}

#declare Tower_small = union {
	intersection {
		plane {z, 0.11 rotate y*0 texture {T_base}}
		plane {z, 0.11 rotate y*45 texture {T_base}}
		plane {z, 0.11 rotate y*90 texture {T_base}}
		plane {z, 0.11 rotate y*135 texture {T_base}}
		plane {z, 0.11 rotate y*180 texture {T_base}}
		plane {z, 0.11 rotate y*225 texture {T_base}}
		plane {z, 0.11 rotate y*270 texture {T_base}}
		plane {z, 0.11 rotate y*315 texture {T_base}}
		plane {-y, 0 texture {T_base}}
		plane {y, 0.1 texture {T_base}}
	}
	intersection {
		plane {z, 0.1 texture {T_wall} rotate y*0}
		plane {z, 0.1 texture {T_wall} rotate y*45}
		plane {z, 0.1 texture {T_wall} rotate y*90}
		plane {z, 0.1 texture {T_wall} rotate y*135}
		plane {z, 0.1 texture {T_wall} rotate y*180}
		plane {z, 0.1 texture {T_wall} rotate y*225}
		plane {z, 0.1 texture {T_wall} rotate y*270}
		plane {z, 0.1 texture {T_wall} rotate y*315}
		plane {-y, -0.05}
		plane {y, 0.65}
	}
	union {
		cylinder {<0, 0.00, 0>, <0, 0.01, 0>, 0.11 texture {T_gr}}
		cylinder {<0, 0.01, 0>, <0, 0.02, 0>, 0.12 texture {T_gr}}
		cylinder {<0, 0.02, 0>, <0, 0.03, 0>, 0.13 texture {T_gr}}
		cylinder {<0, 0.03, 0>, <0, 0.1, 0>, 0.12  texture {T_wall}}

		cylinder {<0, 0.1, 0>, <0, 0.2, 0>, 0.11 texture {T_wall}}
		cylinder {<0, 0.08, 0>, <0, 0.09, 0>, 0.125 texture {T_gr}}
		cylinder {<0, 0.18, 0>, <0, 0.19, 0>, 0.13 texture {T_gr}}
		cylinder {<0, 0.19, 0>, <0, 0.20, 0>, 0.14 texture {T_gr}}
		object {T_window}
		object {T_window rotate y*45}
		object {T_window rotate y*90}
		object {T_window rotate y*135}
		cone {<0, 0.2, 0>, 0.17, <0, 0.3, 0>, 0.08 texture {T_top}}
		cylinder {<0, 0.3, 0>, <0, 0.33, 0>, 0.08 texture {T_wall}}
		cylinder {<0, 0.33, 0>, <0, 0.35, 0>, 0.09 texture {T_gr}}
		object {Column rotate y*0}
		object {Column rotate y*45}
		object {Column rotate y*90}
		object {Column rotate y*135}
		object {Column rotate y*180}
		object {Column rotate y*225}
		object {Column rotate y*270}
		object {Column rotate y*315}
		cylinder {<0, 0.43, 0>, <0, 0.45, 0>, 0.09 texture {T_gr}}
		cone {<0, 0.45, 0>, 0.13, <0, 0.5, 0>, 0.07 texture {T_top}}
		cone {<0, 0.5, 0>, 0.07, <0, 0.95, 0>, 0 texture {T_top}}
		sphere {<0, 0.95, 0>, 0.015 texture {T_top}}
		cylinder {<0, 0.95, 0>, <0, 1.1, 0>, 0.002 texture {T_top}}
		sphere {<0, 1.1, 0>, 0.005 texture {T_top}}
		translate y*0.6
	}
}

#declare Window = union {
	difference {
		intersection {
			cylinder {<0, 0, -0.01>, <0, 0, 0.01>, 0.15}
			plane {-y, 0}
			scale <0.25, 1, 1>
		}
		intersection {
			cylinder {<0, 0, -0.02>, <0, 0, -0.005>, 0.14}
			plane {-y, -0.01}
			scale <0.25, 1, 1>
			texture {T_light}
		}
	}
	box {<-0.04, -0.01, -0.02>, <0.04, 0, 0.01> texture {T_gr}}
	box {<-0.035, -0.015, -0.016>, <0.035, -0.01, 0.01> texture {T_gr}}
	box {<-0.03, -0.02, -0.012>, <0.03, -0.015, 0.01> texture {T_gr}}

	box {<-0.002, 0, -0.008>, <0.002, 0.145, 0.008>}
	difference {
		union {
			box {<-0.035, 0.048, -0.008>, <0.035, 0.052, 0.008>}
			box {<-0.035, 0.098, -0.008>, <0.035, 0.102, 0.008>}
		}
		cylinder {<0, 0, -0.02>, <0, 0, -0.005>, 0.145 scale <0.25, 1, 1>
			inverse
		}
	}
	texture {T_frame}
	translate -z*0.1
}

#declare Tower_1 = union {
	object {Tower_small}
	object {Window translate y*0.15}
	object {Window translate y*0.4}
	object {Window translate y*0.15 rotate y*90}
	object {Window translate y*0.4 rotate y*90}

	texture {T_gr}
}

#declare Inbetween_1 = union {
	box {<-0.45, 0, -0.08>, <0.45, 0.05, 0.08> texture {T_gr}}
	box {<-0.45, 0.05, -0.06>, <0.45, 0.28, 0.06> texture {T_wall}}
	box {<-0.45, 0.28, -0.07>, <0.45, 0.3, 0.07> texture {T_gr}}
	difference {
		intersection {
			plane {y, 0
				rotate -x*74 translate -z*0.18
			}
			plane {y, 0
				rotate x*74 translate z*0.18
			}
		}
		plane {y, 0.5 inverse}
		plane {y, 0.3}
		plane {x, 0.45 inverse}
		plane {x, -0.45}

		texture {T_top_1 rotate -x*74}
	}
	union {
		box {<-0.45, 0.5, -0.01>, <0.45, 0.51, 0.01>}
		box {<-0.45, 0.54, -0.01>, <0.45, 0.55, 0.01>}
		#declare Cycle = 0
		#while (Cycle < 17)
			sphere {<0, 0.525, 0>, 0.0225 scale <0.4, 1, 0.4> translate -x*(0.4-Cycle*0.05)}
			#declare Cycle = Cycle + 1
		#end
		texture {T_gr}
	}
	object {Window translate <-0.32, 0.1, 0.04>}
	object {Window translate <0.32, 0.1, 0.04>}
}

#declare Half_tower_5 = union {
	difference {
		box {<-0.15, 0.3, -0.17>, <0.15, 1.7, 0.17> texture {T_gr}}
		plane {-y, 0 texture {T_top_1 rotate <0, 90, -90>} rotate z*65
			translate y*1.7
		}
		plane {-y, 0 texture {T_top_1 rotate <0, 90, -90>} rotate -z*65
			translate y*1.7
		}
		difference {
			box {<-0.2, 0.28, -0.2>, <0.2, 1.7, -0.16> texture {T_wall}}
			plane {-y, 0 rotate z*65 translate y*1.68 texture {T_gr}}
			plane {-y, 0 rotate -z*65 translate y*1.68 texture {T_gr}}
		}
		difference {
			box {<-0.2, 0.28, -0.2>, <0.2, 1.7, -0.16> texture {T_wall}}
			plane {-y, 0 rotate z*65 translate y*1.68 texture {T_gr}}
			plane {-y, 0 rotate -z*65 translate y*1.68 texture {T_gr}}
			rotate y*180
		}
	}
	// clock
	union {
		difference {
			union {
				cylinder {<0, 1.3, -0.16>, <0, 1.3, 0.16>, 0.12}
				cylinder {<0, 1.3, -0.17>, <0, 1.3, 0.17>, 0.11}
			}
			cylinder {<0, 1.3, -0.2>, <0, 1.3, -0.162>, 0.10 texture {Clock_dark}}
			cylinder {<0, 1.3, 0.162>, <0, 1.3, 0.2>, 0.10 texture {Clock_dark}}
		}
		#declare Cycle = 0
		#while (Cycle < 12)
			cylinder {<0, 0.085, -0.165>, <0, 0.085, 0.165>, 0.011
				rotate -z*Cycle*30
				translate y*1.3
			}
			#declare Cycle = Cycle + 1
		#end
		cylinder {	// hour hand
			<0, 0.025, -0.165>, <0, 0.025, 0.165>, 0.025
			scale <0.2, 1, 1>
			rotate z*60
			translate y*1.3
		}
		cylinder { // min. hand
			<0, 0.035, -0.165>, <0, 0.035, 0.165>, 0.035
			scale <0.15, 1, 1>
			translate y*1.3
		}
		cylinder { // center
			<0, 0, -0.165>, <0, 0, 0.165>, 0.01
			translate y*1.3
		}
		scale <1, 1, 1.05>
		texture {Clock_bright}
	}
}

#declare Tower_5 = union {
	object {Half_tower_5}
	object {Half_tower_5 rotate y*90}
	intersection {
		plane {z, 0.1 texture {T_wall} rotate y*0}
		plane {z, 0.1 texture {T_wall} rotate y*45}
		plane {z, 0.1 texture {T_wall} rotate y*90}
		plane {z, 0.1 texture {T_wall} rotate y*135}
		plane {z, 0.1 texture {T_wall} rotate y*180}
		plane {z, 0.1 texture {T_wall} rotate y*225}
		plane {z, 0.1 texture {T_wall} rotate y*270}
		plane {z, 0.1 texture {T_wall} rotate y*315}
		plane {-y, -1.3 texture {T_wall}}
		plane {y, 1.7 texture {T_wall}}
	}
	union {
		cylinder {<0, 0.00, 0>, <0, 0.01, 0>, 0.11 texture {T_gr}}
		cylinder {<0, 0.01, 0>, <0, 0.02, 0>, 0.12 texture {T_gr}}
		cylinder {<0, 0.02, 0>, <0, 0.03, 0>, 0.13 texture {T_gr}}
		cylinder {<0, 0.03, 0>, <0, 0.1, 0>, 0.12 texture {T_wall}}

		cylinder {<0, 0.1, 0>, <0, 0.2, 0>, 0.11 texture {T_wall}}
		cylinder {<0, 0.08, 0>, <0, 0.09, 0>, 0.125 texture {T_gr}}
		cylinder {<0, 0.18, 0>, <0, 0.19, 0>, 0.13 texture {T_gr}}
		cylinder {<0, 0.19, 0>, <0, 0.20, 0>, 0.14 texture {T_gr}}
		object {T_window}
		object {T_window rotate y*45}
		object {T_window rotate y*90}
		object {T_window rotate y*135}
		union {
			cone {<0, 0.2, 0>, 0.17, <0, 0.3, 0>, 0.08}
			cone {<0, 0.3, 0>, 0.08, <0, 0.75, 0>, 0}
			sphere {<0, 0.75, 0>, 0.015}
			cylinder {<0, 0.75, 0>, <0, 0.9, 0>, 0.002}
			sphere {<0, 0.9, 0>, 0.005}
			texture {T_top}
		}
		light_source {<0.3, 0.9+0.2, -0.2> color rgb <2, 3, 2.5>
			fade_distance 0.5
			fade_power 2
		}
		translate y*1.7
	}
}

#declare Bld4 = union {
	object {Tower_1 translate -x*0.5}
	object {Tower_1	rotate -y*90 translate x*0.5}
	object {Tower_5	translate -y*0.4}
	object {Inbetween_1}
}


