#declare Bridge_light = texture {
	pigment {color rgb <1, 1, 0.9>}
	finish {ambient 1 diffuse 0.8 phong 1}
}

#declare Light_under = light_source{
	0
	color rgb <0.5, 0.7, 0.8>
	looks_like {
		sphere {0, 0.02 scale <0.5, 1, 1>
			pigment {color rgb <0.7, 0.8, 1>}
			finish {ambient 1 diffuse 0.7}
		}
	}
	fade_distance 0.25
	fade_power 2
}

#declare Section1 = union {
	union {
		cylinder {<0.6, -0.21, 3>, <0.6, 0.4, 3>, 0.1}
		cylinder {<0.6, -0.21, 3.4>, <0.6, 0.4, 3.4>, 0.1}
		box {<0.5, -0.21, 3>, <0.7, 0.4, 3.4>}
		object {Light_under translate <0.48, 0.3, 3.2>}
		object {Light_under translate <0.72, 0.3, 3.2>}

		texture {My_wall}
	}
	union {
		cylinder {<0.6, 0.4, 3>, <0.6, 0.41, 3>, 0.11}
		cylinder {<0.6, 0.4, 3.4>, <0.6, 0.41, 3.4>, 0.11}
		box {<0.49, 0.4, 3>, <0.71, 0.41, 3.4>}

		cylinder {<0.6, 0.41, 3>, <0.6, 0.42, 3>, 0.12}
		cylinder {<0.6, 0.41, 3.4>, <0.6, 0.42, 3.4>, 0.12}
		box {<0.48, 0.41, 3>, <0.72, 0.42, 3.4>}

		cylinder {<0.6, 0.42, 3>, <0.6, 0.43, 3>, 0.13}
		cylinder {<0.6, 0.42, 3.4>, <0.6, 0.43, 3.4>, 0.13}
		box {<0.47, 0.42, 3>, <0.73, 0.43, 3.4>}

		box {<-1.7, 0.43, 2.87>, <0.6, 0.46, 3.53>}

		texture {My_gr}
	}
	cylinder {<-1.7, 0.47, 2.87>, <0.6, 0.47, 2.87>, 0.002}
	cylinder {<-1.7, 0.5, 2.87>, <0.6, 0.5, 2.87>, 0.002}
	cylinder {<-1.7, 0.51, 2.87>, <0.6, 0.51, 2.87>, 0.002}
	cylinder {<-1.7, 0.41, 2.87>, <0.6, 0.41, 2.87>, 0.002}

	cylinder {<-1.7, 0.47, 3.53>, <0.6, 0.47, 3.53>, 0.002}
	cylinder {<-1.7, 0.5, 3.53>, <0.6, 0.5, 3.53>, 0.002}
	cylinder {<-1.7, 0.51, 3.53>, <0.6, 0.51, 3.53>, 0.002}
	cylinder {<-1.7, 0.41, 3.53>, <0.6, 0.41, 3.53>, 0.002}

	#declare Cycle = 0
	#while (Cycle < 5)
		cylinder {<0.6-(1.7/5)*Cycle, 0.41, 2.87>,
			<0.6-(1.7/5)*Cycle, 0.58, 2.87>, 0.004
			texture {My_metal}
		}
		sphere {<0.6-(1.7/5)*Cycle, 0.58, 2.87>, 0.012 texture {Bridge_light}}
		sphere {<0.6-(1.7/5)*Cycle, 0.58, 3.53>, 0.012 texture {Bridge_light}}
		cylinder {<0.6-(1.7/5)*Cycle, 0.41, 3.53>,
			<0.6-(1.7/5)*Cycle, 0.58, 3.53>, 0.004
			texture {My_metal}
		}
		#declare Cycle = Cycle + 1
	#end

	#declare Cycle = 0
	#while (Cycle < 120)
		cylinder {
			<0.6-(1.7/120)*Cycle, 0.47, 2.87>,
			<0.6-(1.7/120)*Cycle, 0.5, 2.87>, 0.001
			texture {My_metal}
		}
		#declare Cycle = Cycle + 1
	#end
	texture {My_metal}
}

#declare Bridge = union {
	object {Section1}
	object {Section1 translate -x*1.7}
	object {Section1 translate x*1.7}
}
