//
//   This is include file for gveyard.pov scene file.
//   By: Timo Ettanen tket@spider.compart.fi
//

#version 3.0

#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"

#include "smoochar.inc"            // smooth character set


#declare Cross1 =
union{
   box{<-3,0,0><3,80,1>}
   box{<-20,57,0><20,63,1>}
   cylinder{<0,80,0><0,80,1>,3}
   cylinder{<-20,60,0><-20,60,1>,3}
   cylinder{< 20,60,0>< 20,60,1>,3}
   pigment{Red}
}


#declare Cross2 =
union{
   box{<-3,0,0><3,80,1>}
   box{<-20,57,0><20,63,1>}
   cylinder{<0,80,0><0,80,1>,3}
   cylinder{<-20,60,0><-20,60,1>,3}
   cylinder{< 20,60,0>< 20,60,1>,3}
   torus{2.5,0.5 rotate x*90 clipped_by{plane{y,0 inverse}} translate y*80 }
   torus{2.5,0.5 rotate x*90 clipped_by{plane{x,0 inverse}} translate<20,60,0>}
   torus{2.5,0.5 rotate x*90 clipped_by{plane{x,0 }} translate<-20,60,0>}
   cylinder{<-20,62.5,0><-2.5,62.5,0>,0.5}
   cylinder{<-2.5,62.5,0><-2.5,79.5,0>,0.5}
   cylinder{< 2.5,62.5,0>< 2.5,79.5,0>,0.5}
   cylinder{< 20,62.5,0>< 2.5,62.5,0>,0.5}
   cylinder{< 20,57.5,0>< 2.5,57.5,0>,0.5}
   cylinder{< 2.5,57.5,0>< 2.5,0,0>,0.5}
   cylinder{<-2.5,57.5,0><-2.5,0,0>,0.5}
   cylinder{<-20,57.5,0><-2.5,57.5,0>,0.5}
   sphere{<-2.5,62.5,0>,0.5}
   sphere{< 2.5,62.5,0>,0.5}
   sphere{<-2.5,57.5,0>,0.5}
   sphere{< 2.5,57.5,0>,0.5}
   torus{7,1 rotate x*90 scale<1,1,0.6> translate<0,60,0.3> }
   sphere{0,2 scale<1,1,0.2> translate<-10,60,0> }
   sphere{0,2 scale<1,1,0.2> translate< 10,60,0> }
   sphere{0,2 scale<1,1,0.2> translate< 0,70,0> }
   sphere{0,2 scale<1,1,0.2> translate< 0,40,0> }
   cylinder{<-10,60,0><10,60,0>,2 scale<1,1,0.2>}
   cylinder{< 0,70,0><0,40,0>,2 scale<1,1,0.2>}

}


#declare CrossPlatform =
union{
   union{
      difference{
         box{<-7,0,-7><7,4.5,7>}
         cylinder{<-7,4.5,-7><7,4.5,-7>,1.5}
         cylinder{<-7,4.5,-7><7,4.5,-7>,1.5 rotate y*90}
         cylinder{<-7,4.5,-7><7,4.5,-7>,1.5 rotate y*180}
         cylinder{<-7,4.5,-7><7,4.5,-7>,1.5 rotate y*270}

      }
      cylinder{<-7,1.5,-7><7,1.5,-7>,1.5}
      cylinder{<-7,1.5,-7><7,1.5,-7>,1.5 rotate y*90}
      cylinder{<-7,1.5,-7><7,1.5,-7>,1.5 rotate y*180}
      cylinder{<-7,1.5,-7><7,1.5,-7>,1.5 rotate y*270}
      sphere{<-7,1.5,-7>,1.5}
      sphere{< 7,1.5, 7>,1.5}
      sphere{< 7,1.5,-7>,1.5}
      sphere{<-7,1.5, 7>,1.5}
      box{<-5.5,4,-5.5><5.5,5.5,5.5>}

      translate y*25
   }
   difference{
      box{<-10,0,-10><10,20,10>}
      plane{x,0 rotate z*45 translate<10,19,0> inverse}
      plane{x,0 rotate z*45 translate<10,19,0> rotate y*90 inverse}
      plane{x,0 rotate z*45 translate<10,19,0> rotate y*180 inverse}
      plane{x,0 rotate z*45 translate<10,19,0> rotate y*270 inverse}
      plane{x,0 translate x*-13.5 rotate y*45 }
      plane{x,0 translate x*-13.5 rotate y*135}
      plane{x,0 translate x*-13.5 rotate y*225}
      plane{x,0 translate x*-13.5 rotate y*315}
      box{<-6,4,-10.5>< 6,16,-9.5>}
      box{<-6,4,-10.5>< 6,16,-9.5> rotate y*90}
      box{<-6,4,-10.5>< 6,16,-9.5> rotate y*180}
      box{<-6,4,-10.5>< 6,16,-9.5> rotate y*270}

      translate y*5
   }
   box{<-13,0,-13><13,5,13>}

}


#declare Clipper =
height_field{
   gif "stonemap.gif"
   scale <40,1,40>
}


#declare GraveTexture1 =                     // to sidestone
texture{
   pigment{
      granite
      color_map{
         [0.0 color rgb<0.4,0.4,0.4>]
         [0.2 color rgb<0.3,0.3,0.3>]
         [0.5 color rgb<0.5,0.5,0.5>]
         [1.0 color rgb<0.4,0.4,0.4>]
      }
   }
   scale 2

   finish{ specular 0.45 roughness 0.05}
}


#declare GraveTexture2 =                   //to gravestone 1
texture{
   pigment{
      agate
      color_map{
         [0.0 color rgb<0.5,0.4,0.4>]
         [0.5 color rgb<0.6,0.5,0.5>]
         [1.0 color rgb<0.7,0.6,0.6>]
      }
   }
   finish{ specular 0.8 roughness 0.001 }
}


#declare GraveTexture3 =                     // Shiny black
texture{
   pigment{
      granite
      color_map{
         [0.0 color rgb<0.1,0.1,0.1>]
         [0.5 color rgb<0.3,0.3,0.35>]
         [1.0 color rgb<0.2,0.2,0.2>]
      }
   }
   scale 2

   finish{ specular 0.4 roughness 0.005 }
}


#declare GrassTexture1 =
texture{
   pigment{
      bozo
      color_map{
         [0.0 color rgb<0.0,1.0,0.0>]
         [0.6 color rgb<0.35,1.0,0.1>]
         [0.7 color rgb<0.7,1.0,0.2>]
         [1.0 color rgb<0.85,1.0,0.2>]
      }
      turbulence 0.15
      scale 3
   }
   finish{ specular 0.5 roughness 0.05}
}


#declare GroundTexture =
texture {
  pigment{
    granite
    color_map{
       [0.0   color rgb <0.38, 0.27, 0.22>]
       [0.2   color rgb <0.40, 0.28, 0.22>]
       [0.7   color rgb <0.58, 0.40, 0.32>]
       [0.8   color rgb <0.60, 0.55, 0.40>]
       [1.0   color rgb <0.50, 0.40, 0.30>]
    }
  }
  scale 1.25
}
texture {
  pigment{
    bozo
    turbulence 0.8
    color_map{
       [0.0   color rgbf <0.15, 0.15, 0.15, 0.5>]
       [0.1   color rgbf <0.32, 0.22, 0.22, 0.5>]
       [0.2   color rgbf <0.50, 0.50, 0.50, 0.95>]
       [0.7   color rgbf <0.50, 0.50, 0.50, 0.95>]
       [0.8   color rgbf <0.70, 0.60, 0.55, 0.5>]
       [1.0   color rgbf <0.89, 0.59, 0.50, 0.3>]
    }
  }
  scale 0.05 rotate <0, 0,-30>
}


#declare TempleTexture =                 // old marble to temple-grave
texture{
   pigment{
      crackle
      color_map {
         [0.0  color rgb <0.6, 0.6, 0.6>]
         [0.05 color rgb <0.9, 0.9, 0.9>]
         [0.2  color rgb <0.8, 0.8, 0.8>]
         [0.4  color rgb <0.95, 0.95, 0.95>]
         [0.6  color rgb <0.6, 0.6, 0.6>]
         [1.0  color rgb <0.9, 0.9, 0.9>]
      }
      turbulence 0.8
   }
   scale <4,6,4> rotate z*-30

   finish{ specular 0.6 roughness 0.008 ambient 0.2}
}


#declare RustLines =                   //transparent rustlines
texture{
   pigment{
      bozo
      color_map {
         [0.0  color rgbt <1.0, 1.0, 1.0, 1.0>]
         [0.8  color rgbt <1.0, 1.0, 1.0, 1.0>]
         [0.85 color rgbt <0.8, 0.7, 0.1, 0.7>]
         [1.0  color rgbt <0.8, 0.7, 0.1, 0.4>]
      }
      octaves 5
      turbulence 0.5
   }
   scale <0.7,50,0.7> translate z*10

   finish{ specular 0.6 roughness 0.008 }
}


#declare GrasSpot =                    // Small grass area
intersection{
   height_field{
      tga "grasmap.tga"
      scale<10,40,10>
      translate y*-20
   }
   height_field{
      tga "grasmap.tga"
   }
   scale<40,3,40>
   texture{GrassTexture1}
}


#declare Sidestone =                    // sidestone
difference{
   box{<0,0,0><20,5,5>}
   object{Clipper scale<1,0.5,1> rotate z*90 translate <0.5,-7,-6> inverse}
   object{Clipper scale<1,0.5,1> rotate z*90 translate <19.5,-6,-7>}
   object{Clipper scale<1,0.5,1> rotate x*-90 translate <-6,-7,0.5> inverse}
   object{Clipper scale<1,0.5,1> rotate x*-90 translate <-7,-6,4.5>}
   object{Clipper scale<1,0.5,1> translate <-7,4.5,-6> inverse}

   bounded_by{box{<0,0,0><20,5,5>}}
}


#declare GraveStone1 =
difference{
   box{<-10,0,-5><10,30,4>}
   object{Clipper rotate z*100 translate <10,0,-10>}
   object{Clipper rotate z*80 translate <-10,0,-10> inverse}
   object{Clipper scale<1,2,1> translate <-11,28,-11> inverse}

}


#declare GraveStone2 =
union{
   box{<-6,0,0><6,10,3>}
   cylinder{<0,0,0><0,0,3>,5 scale<1,0.65,1> translate y*10}
   cylinder{<-5,10,0><-5,10,3>,1}
   cylinder{< 5,10,0>< 5,10,3>,1}
}


#declare GraveStone3 =                        // simple obelisk
union{
   difference{
      box{<-10,0,0><10,50,5>}
      plane{x,0 rotate z*-3.5 translate x*-10}
      plane{x,0 rotate z* 3.5 translate x*10 inverse}
      plane{y,0 rotate z* 40 translate y*50 inverse}
      plane{y,0 rotate z*-40 translate y*50 inverse}
      translate y*5
   }
   box{<-12,0,-1><12,5,6>}

}


#declare Pot =                        //part of GraveStone4
union{
   sor {
     8,
       <0.10, 0.00>
       <2.00, 0.10>
       <0.90, 1.30>
       <2.22, 5.54>
       <2.24, 8.02>
       <1.05, 9.50>
       <1.55, 11.5>
       <1.10, 12.0>
     open
   }
   torus{1.54,0.05 translate y*11.5}
}


#declare GraveStone4 =                     // temple looking gravestone
union{
   difference{
      box{<-11,40,-2><11,50,7>}
      plane{y,0 rotate z* 25 translate y*50 inverse}
      plane{y,0 rotate z*-25 translate y*50 inverse}
      texture{TempleTexture scale 2}
      texture{RustLines}
   }
   union{
      box{<-13,-1.5,-3.5><0,0,8.5>}
      cylinder{<-13,-0.75,-3.5><-13,-0.75,8.5>,0.75}
      rotate z*25 translate y*49.5
   }
   union{
      box{<0,-1.5,-3.5><13,0,8.5>}
      cylinder{<13,-0.75,-3.5><13,-0.75,8.5>,0.75}
      rotate z*-25 translate y*49.5
   }
   union{
      box{<-10,0,-1><-8,40,6>}
      box{< 8,0,-1><10,40,6>}
      difference{                                    // name
         box{< -9,0,0><9,40,5>}
         union{
            object{Schar_S translate<-6,40,0>}
            object{Schar_O translate< 0,40,0>}
            object{Schar_R translate< 6,40,0>}
            scale<0.55,0.84,0.6>
            texture{Gold_Metal}
         }
         union{                                     // years
            object{Schar_1 translate<-8.5,37,0>}
            object{Schar_7 translate<-4.5,37,0>}
            object{Schar_5 translate< 0.5,37,0>}
            object{Schar_7 translate< 5.5,37,0>}
            object{Schar_minus translate<10.5,37,0>}
            object{Schar_1 translate<-8.5,31,0>}
            object{Schar_8 translate<-4.5,31,0>}
            object{Schar_1 translate< 0.5,31,0>}
            object{Schar_0 translate< 5.5,31,0>}

            scale<0.45,0.74,0.6>
            texture{Gold_Metal}
         }
      }
      cylinder{<-8,0,0><-8,40,0>,1}
      cylinder{< 8,0,0>< 8,40,0>,1}
      cylinder{<-10,0,-0.5><-10,40,-0.5>,0.5}
      cylinder{< 10,0,-0.5>< 10,40,-0.5>,0.5}
      cylinder{<-10,0,5.5><-10,40,5.5>,0.5}
      cylinder{< 10,0,5.5>< 10,40,5.5>,0.5}
      box{<-10.5,0,-0.5><-9,40,5.5>}
      box{< 9,0,-0.5><10.5,40,5.5>}
      box{< -9,0,-1>< 9,5,6>}
      cylinder{< -9,5,0>< 9,5,0>,1}
      texture{TempleTexture scale 2 translate x*5}
      texture{RustLines}
   }
   union{
      box{<-13,-1.5,-3><0,0,8>}
      cylinder{<-13,-0.75,-3><-13,-0.75,8>,0.75}
      rotate z*25 translate <-9.5,15,0>
   }
   union{
      box{<0,-1.5,-3><13,0,8>}
      cylinder{<13,-0.75,-3><13,-0.75,8>,0.75}
      rotate z*-25 translate < 9.5,15,0>
   }
   difference{
      box{<0,-4.5,-1><11,10,6>}
      plane{y,0 rotate z*-25 translate y*10 inverse}
      translate <9.5,4.5,0>
   }
   difference{
      box{<-11,-4.5,-1><0,10,6>}
      plane{y,0 rotate z*25 translate y*10 inverse}
      translate <-9.5,4.5,0>
   }
   union{
      box{<-20,0,-10><-9.5,2,6>}
      box{< 9.5,0,-10><20,2,6>}
      box{< -9,0,-9.5><9,1,6>}
      cylinder{<-20,2,-1><-9.5,2,-1>,4}
      cylinder{< 20,2,-1>< 9.5,2,-1>,4}
      texture{TempleTexture translate z*5 scale 2
         finish{specular 0.2 roughness 0.005}
         normal{bumps 0.3 scale 0.4}
      }
   }
   object{ Pot scale 2 translate <0,1,-5>}        // the pot

   texture{ TempleTexture scale 2}
}


#declare GraveStone5 =
difference{
   box{<-8,0,0><8,30,5>}
   object{Clipper rotate z*97 translate <8,0,-10>}
   object{Clipper rotate z*83 translate <-8,0,-10> inverse}
   object{Clipper rotate z*15 translate <-11,25,-11> inverse}

}


#declare Grave1 =
union{
   object{ Sidestone
      texture{GraveTexture1}
      texture{                                  //some dirt
         pigment{
            gradient y
            color_map{
               [0.0 color rgbf<0.4,0.3,0.1,0>]
               [0.14 color rgbf<1,1,1,1>]
               [1.0 color rgbf<1,1,1,1>]
            }
            turbulence 0.012
         }
         scale 0.5
         scale<1,45,1>
         translate y*1.2
      }
   }
   object{ Sidestone rotate <2,-90,0> translate<4,0,4.5>}
   object{ Sidestone rotate y*-90 translate <20,0,4.5>}
   object{ Sidestone rotate y*-90 translate <4,0,24>}
   object{ Sidestone rotate <-2,-90,0> translate <20,0,24>}
   difference{
      object{ GraveStone1}
      union{
         object{Schar_J translate<-10,0,0>}
         object{Schar_U translate< -5,0,0>}
         object{Schar_L translate<  0,0,0>}
         object{Schar_I translate<  5,0,0>}
         object{Schar_A translate< 10,0,0>}

         scale<0.3,0.55,0.4>
         translate<-1,22.5,-5>
         texture{Gold_Metal}
      }
      union{
         object{Schar_L translate<-15,0,0>}
         object{Schar_A translate<-10,0,0>}
         object{Schar_T translate< -5,0,0>}
         object{Schar_C translate<  0,0,0>}
         object{Schar_A translate<  5,0,0>}
         object{Schar_R translate< 10,0,0>}
         object{Schar_F translate< 15,0,0>}

         scale<0.3,0.55,0.4>
         translate<-1,19,-5>
         texture{Gold_Metal}
      }
      union{
         object{Schar_6 translate<-20,0,0>}
         object{Schar_dot translate<-15,0,0>}
         object{Schar_3 translate<-10,0,0>}
         object{Schar_dot translate< -5,0,0>}
         object{Schar_1 translate<  0,0,0>}
         object{Schar_7 translate<  5,0,0>}
         object{Schar_8 translate< 10,0,0>}
         object{Schar_8 translate< 15,0,0>}
         object{Schar_minus translate< 20,0,0>}

         scale<0.2,0.4,0.3>
         translate<-1,16,-5>
         texture{Gold_Metal}
      }
      union{
         object{Schar_7 translate<-20,0,0>}
         object{Schar_dot translate<-15,0,0>}
         object{Schar_1 translate<-10,0,0>}
         object{Schar_0 translate< -5,0,0>}
         object{Schar_dot translate<  0,0,0>}
         object{Schar_1 translate<  5,0,0>}
         object{Schar_8 translate< 10,0,0>}
         object{Schar_5 translate< 15,0,0>}
         object{Schar_3 translate< 20,0,0>}

         scale<0.2,0.4,0.3>
         translate<-1,13,-5>
         texture{Gold_Metal}
      }
      texture{GraveTexture2}
      texture{RustLines}
      translate<10,0,50>
   }
   intersection{
      height_field{
         tga "grasmap.tga"
         scale <45,3,45>
      }
      box{<0,0,0><11.6,10,40>}
      texture{GrassTexture1}
      translate<4,4,4.4>
   }
   texture{GraveTexture1}
   scale 3.8
   translate y*-3
}


#declare Grave1b =
union{
   object{ Sidestone}
   object{ Sidestone rotate <2,-90,0> translate<4,0,4.5>}
   object{ Sidestone rotate y*-90 translate <20,0,4.5>}
   object{ Sidestone rotate y*-90 translate <4,0,24>}
   object{ Sidestone rotate <-2,-90,0> translate <20,0,24>}
   object{ GraveStone1
      texture{GraveTexture2}
      texture{RustLines}
      translate<10,0,50>
   }
   intersection{
      height_field{
         tga "grasmap.tga"
         scale <45,3,45>
      }
      box{<0,0,0><11.6,10,40>}
      texture{GrassTexture1}
      translate<4,4,4.4>
   }
   texture{GraveTexture1}
   scale 3.8
   translate y*-3
}


#declare Grave2 =
union{
   difference{
      union{
         sphere{<1 ,2, 1>,1}
         sphere{<20,2, 1>,1}
         sphere{<1 ,2,35>,1}
         sphere{<20,2,35>,1}
         cylinder{<1,2,1><20,2,1>,1}
         cylinder{<1,2,35><20,2,35>,1}
         cylinder{<1,2,1><1,2,35>,1}
         cylinder{<20,2,1><20,2,35>,1}
         cylinder{<1,2,1><1,0,1>,1}
         cylinder{<20,2,1><20,0,1>,1}
         cylinder{<20,2,35><20,0,35>,1}
         cylinder{<1,2,35><1,0,35>,1}
         box{<1,0,0><20,2,36>}
         box{<0,0,1><21,2,35>}
         box{<1,0,1><20,3,35>}
      }
      box{<3,-1,3><18,4,33>}
   }
   object{ GraveStone2 texture{GraveTexture3} rotate x*5 translate<11,0,30> }
   intersection{
      height_field{
         gif "gndmap.gif"
         scale <40,4,40>
      }
      box{<3,-1,3><18,4,33>}
      texture{GroundTexture}
      finish{specular 0.2 roughness 0.005}
      translate<0,2,0>
   }
   texture{GraveTexture1}
   scale 4
}


#declare Obelisk =
union{
   difference{
      box{<-5,0,-5><5,40,5>}
      plane{x,0 rotate z*3 translate x*5 inverse}
      plane{x,0 rotate z*45 translate y*40 inverse}
      plane{x,0 rotate z*3 translate x*5 rotate y*90 inverse}
      plane{x,0 rotate z*45 translate y*40 rotate y*90 inverse}
      plane{x,0 rotate z*3 translate x*5 rotate y*180 inverse}
      plane{x,0 rotate z*45 translate y*40 rotate y*180 inverse}
      plane{x,0 rotate z*3 translate x*5 rotate y*270 inverse}
      plane{x,0 rotate z*45 translate y*40 rotate y*270 inverse}

      translate y*30
   }
   difference{
      box{<-7.5,0,-7.5><7.5,5,7.5>}
      cylinder{<-7.5,5,-7.5><7.5,5,-7.5>,1.5}
      cylinder{<-7.5,5,-7.5><7.5,5,-7.5>,1.5 rotate y*90}
      cylinder{<-7.5,5,-7.5><7.5,5,-7.5>,1.5 rotate y*180}
      cylinder{<-7.5,5,-7.5><7.5,5,-7.5>,1.5 rotate y*270}

      translate y*25
   }
   difference{
      box{<-10,0,-10><10,20,10>}
      plane{x,0 rotate z*45 translate<10,19,0> inverse}
      plane{x,0 rotate z*45 translate<10,19,0> rotate y*90 inverse}
      plane{x,0 rotate z*45 translate<10,19,0> rotate y*180 inverse}
      plane{x,0 rotate z*45 translate<10,19,0> rotate y*270 inverse}
      plane{x,0 translate x*-13.5 rotate y*45 }
      plane{x,0 translate x*-13.5 rotate y*135}
      plane{x,0 translate x*-13.5 rotate y*225}
      plane{x,0 translate x*-13.5 rotate y*315}
      union{
         object{Schar_1}                       // year
         object{Schar_8 translate<4,0,0>}
         object{Schar_7 translate<9,0,0>}
         object{Schar_5 translate<14,0,0>}
         object{Schar_minus translate<19,0,0>}
         object{Schar_1 translate<24,0,0>}
         object{Schar_9 translate<28,0,0>}
         object{Schar_0 translate<33,0,0>}
         object{Schar_2 translate<38,0,0>}

         scale <0.8,1.3,1>
         scale 0.5
         translate<-8,10,-10>
      }
      union{
         object{Schar_L translate<5,6,0>}       // name
         object{Schar_E translate<10,6,0>}
         object{Schar_D translate<15,6,0>}
         object{Schar_N translate<20,6,0>}
         object{Schar_A translate<25,6,0>}
         object{Schar_M translate<30,6,0>}

         scale <1,1.3,1>
         scale 0.5
         translate<-9.0,10,-10>
      }
      translate y*5
   }
   box{<-13,0,-13><13,5,13>}

}


#declare ChainTexture =
texture{
   pigment{ color rgb<0.5,0.35,0.35>}
   finish{ specular 0.3 roughness 0.008 }
   normal{ bumps 0.5 scale 0.2}
}


#declare GraveGranite =
texture{
   pigment {
      granite
      color_map {
         [0.0, 0.35  color rgb <0.2, 0.2, 0.2>
                     color rgb <0.25, 0.25, 0.25>]
         [0.35, 0.45 color rgb <0.85, 0.85, 0.95>
                     color rgb <0.85, 0.85, 0.95>]
         [0.45, 0.5  color rgb <0.85, 0.85, 0.95>
                     color rgb <0.75, 0.75, 0.75>]
         [0.5,  0.55 color rgb <0.75, 0.75, 0.75>
                     color rgb <0.82, 0.57, 0.46>]
         [0.55, 0.8  color rgb <0.82, 0.57, 0.46>
                     color rgb <0.85, 0.57, 0.46>]
         [0.8,  1.0  color rgb <0.85, 0.57, 0.46>
                     color rgb <1.0, 0.5, 0.1> ]
      }
   }
}


#declare ChainPart =
union{
   torus{1,0.5 clipped_by{ plane{x,0} }}
   torus{1,0.5 clipped_by{ plane{x,0 inverse }} translate <1,0,0>}
   cylinder{<0,0,-1><1,0,-1>,0.5}
   cylinder{<0,0,1><1,0,1>,0.5}

}


#declare chaincount =20
#declare rotdeg = 3.2

#declare Chain =
union{
   #declare j = chaincount
   #while (j >= 0)
      object{ChainPart
         #if (j/2=int(j/2))
            rotate x*90
         #end
         translate<0,-35,0>
         rotate z*(j*rotdeg)
      }
      #declare j=j-1
   #end
   rotate z*-((chaincount/2)*rotdeg)
   translate<0,35,0>

   texture{ChainTexture}
}


#declare CornerPilar =
union{
   intersection{
      box{<0,0,0><12,30,12>}
      sphere{0,34 scale<0.26,1,0.26> translate<6,5,6>}
   }
   sphere{<6,30,6>,5}
   box{<0,-5,0><12,5,12>}
   union{
      object{ ChainPart scale 1.85 translate<12,20,6>}
      object{ ChainPart scale 1.85 rotate y*-90 translate<6,20,12>}
      texture{ChainTexture}
   }
}


#declare MiddlePilar =
union{
   intersection{
      box{<0,0,0><12,30,12>}
      sphere{0,34 scale<0.26,1,0.26> translate<6,5,6>}
   }
   sphere{<6,30,6>,5}
   box{<0,-5,0><12,5,12>}
   union{
      object{ ChainPart scale 1.85 rotate y*-90 translate<6,20,12>}
      object{ ChainPart scale 1.85 rotate y*90 translate<6,20,0>}
      texture{ChainTexture}
   }
}


#declare Grave3 =
union{
   difference{
      box{<0,0,0.5><100,5,44.5>}
      box{<-0.5,-0.5,-0.5><12.5,5.5,12.5>}
      box{<87.5,-0.5,-0.5><100.5,5.5,12.5>}
   }
   box{<0,0,45.5><100,5,89.5>}
   box{<0,0,90.5><100,5,134.5>}
   box{<0,0,135.5><100,5,179.5>}
   box{<20,5,20><80,10,170> }
   object{CornerPilar translate<0,5,0>}
   object{MiddlePilar translate<0,5,84>}
   object{CornerPilar rotate y*90 translate<0,5,180>}
   object{CornerPilar rotate y*-90 translate<100,5,0>}
   object{MiddlePilar translate<88,5,84>}
   object{CornerPilar rotate y*180 translate<100,5,180>}
   object{Chain scale 1.80 translate<49.4,14.8,6>}
   object{Chain scale 1.80 translate<49.4,14.8,174>}
   object{Chain scale<1.76,1.8,1.78>  rotate y*90 translate<6,15,49>}
   object{Chain scale<1.76,1.8,1.78>  rotate y*90 translate<94,15,49>}
   object{Chain scale<1.76,1.8,1.78>  rotate y*90 translate<6,15,132>}
   object{Chain scale<1.76,1.8,1.78>  rotate y*90 translate<94,15,132>}
   object{Obelisk scale 2 translate<50,5,130>
       texture{GraveGranite scale 2.5}
       texture{RustLines scale 2}
   }
   texture{GraveGranite scale 2.5}
   texture{                                  //some dirt
      pigment{
         gradient y
         color_map{
            [0.0 color rgbf<0.4,0.3,0.1,0>]
            [0.135 color rgbf<1,1,1,1>]
            [1.0 color rgbf<1,1,1,1>]
         }
         turbulence 0.012
      }
      scale<1,45,1>
   }
   finish{ specular 0.2 roughness 0.01 ambient 0.25}
   normal{ bumps 0.3 scale 0.1}

   scale 1.2
}


#declare Grave4 =                      //temple looking grave
union{
   difference{
      box{<0,0,0><40,2,66>}
      box{<10,-0.5,10><30,2.5,50>}
   }
   object{ GraveStone4 translate<20,2,60> }
   intersection{
      height_field{
         tga "grasmap.tga"
         scale <45,3,55>
      }
      box{<0,0,0><20,10,40>}
      texture{GrassTexture1}
      translate<10,1.5,10>
   }
   texture{GraveGranite
      normal{ bumps 0.3 scale 0.1}
   }
   scale 2

}


#declare Grave5 =
union{
   difference{
      union{
         sphere{<1 ,2, 1>,1}
         sphere{<20,2, 1>,1}
         sphere{<1 ,2,40>,1}
         sphere{<20,2,40>,1}
         cylinder{<1,2,1><20,2,1>,1}
         cylinder{<1,2,40><20,2,40>,1}
         cylinder{<1,2,1><1,2,40>,1}
         cylinder{<20,2,1><20,2,40>,1}
         cylinder{<1,2,1><1,0,1>,1}
         cylinder{<20,2,1><20,0,1>,1}
         cylinder{<20,2,40><20,0,40>,1}
         cylinder{<1,2,40><1,0,40>,1}
         box{<1,0,0><20,2,41>}
         box{<0,0,1><21,2,40>}
         box{<1,0,1><20,3,40>}
      }
      box{<3,-1,3><18,4,38>}
   }
   object{ GraveStone3
         texture{T_Stone10 scale 3}
         texture{RustLines}
         scale 0.5
         translate<11,2,35>
   }
   intersection{
      height_field{
         gif "gndmap.gif"
         scale <40,4,40>
      }
      box{<3,-1,3><18,4,38>}
      texture{GrassTexture1}
      finish{specular 0.2 roughness 0.005}
      translate<0,2,0>
   }
   texture{GraveTexture1
      normal{bumps 0.2 scale 0.1}
   }
   scale 4
}


#declare Grave6 =                      //stone cross grave
union{
   difference{
      box{<0,0,0><40,2,58>}
      box{<10,-0.5,10><30,2.5,40>}
   }
   object{ CrossPlatform                      //platform
      texture{GraveTexture3}
      texture{RustLines}
      translate<20,2,44>
   }
   union{                                      //cross
      box{<-4,0,-4><4,24,4>}
      box{<-10,10,-4><10,18,4>}
      texture{GraveTexture3}
      texture{RustLines}
      translate<20,30,44>
   }
   intersection{
      height_field{
         gif "gndmap.gif"
         scale <45,3,45>
      }
      box{<0,0,0><20,10,30>}
      texture{GroundTexture}
      translate<10,1.5,10>
   }
   texture{GraveTexture3
      normal{ bumps 0.3 scale 0.1}
   }
   scale 2

}


#declare Grave7 =
union{
   difference{
      union{
         sphere{<1 ,2, 1>,1}
         sphere{<20,2, 1>,1}
         sphere{<1 ,2,35>,1}
         sphere{<20,2,35>,1}
         cylinder{<1,2,1><20,2,1>,1}
         cylinder{<1,2,35><20,2,35>,1}
         cylinder{<1,2,1><1,2,35>,1}
         cylinder{<20,2,1><20,2,35>,1}
         cylinder{<1,2,1><1,0,1>,1}
         cylinder{<20,2,1><20,0,1>,1}
         cylinder{<20,2,35><20,0,35>,1}
         cylinder{<1,2,35><1,0,35>,1}
         box{<1,0,0><20,2,36>}
         box{<0,0,1><21,2,35>}
         box{<1,0,1><20,3,35>}
      }
      box{<3,-1,3><18,4,33>}
   }
   object{ Obelisk
      rotate y*90
      scale 0.5
      texture{T_Stone10 scale 2}
      translate<11,0,30>
   }
   object{GraveStone2
      rotate x*70
      scale 0.95
      texture{T_Stone10 scale 2}
      translate<11,1,14>
   }
   intersection{
      height_field{
         gif "gndmap.gif"
         scale <40,4,40>
      }
      box{<3,-1,3><18,4,33>}
      texture{GroundTexture}
      finish{specular 0.2 roughness 0.005}
      translate<0,2,0>
   }
   texture{GraveTexture3}
   scale 4
}


#declare Grave8 =
union{
   difference{
      union{
         sphere{<1 ,2, 1>,1}
         sphere{<20,2, 1>,1}
         sphere{<1 ,2,35>,1}
         sphere{<20,2,35>,1}
         cylinder{<1,2,1><20,2,1>,1}
         cylinder{<1,2,35><20,2,35>,1}
         cylinder{<1,2,1><1,2,35>,1}
         cylinder{<20,2,1><20,2,35>,1}
         cylinder{<1,2,1><1,0,1>,1}
         cylinder{<20,2,1><20,0,1>,1}
         cylinder{<20,2,35><20,0,35>,1}
         cylinder{<1,2,35><1,0,35>,1}
         box{<1,0,0><20,2,36>}
         box{<0,0,1><21,2,35>}
         box{<1,0,1><20,3,35>}
      }
      box{<3,-1,3><18,4,33>}
   }
   object{ GraveStone5
      scale 0.7
      texture{GraveTexture3 }
      translate<11,0,30>
   }
   intersection{
      height_field{
         gif "gndmap.gif"
         scale <40,4,40>
      }
      box{<3,-1,3><18,4,33>}
      texture{GroundTexture}
      finish{specular 0.2 roughness 0.005}
      translate<0,2,0>
   }
   texture{GraveGranite}
   scale 4
}


#declare Grave9 =                         // Chainsided grave  # 2
union{
   box{<0,0,0.5><100,5,44.5>}
   box{<0,0,45.5><100,5,89.5>}
   box{<0,0,90.5><100,5,134.5>}
   box{<0,0,135.5><100,5,179.5>}
   box{<20,5,20><80,10,170> }
   object{CornerPilar translate<0,5,0>}
   object{MiddlePilar translate<0,5,84>}
   object{CornerPilar rotate y*90 translate<0,5,180>}
   object{CornerPilar rotate y*-90 translate<100,5,0>}
   object{MiddlePilar translate<88,5,84>}
   object{CornerPilar rotate y*180 translate<100,5,180>}
   object{Chain scale 1.80 translate<49.4,14.8,6>}
   object{Chain scale 1.80 translate<49.4,14.8,174>}
   object{Chain scale<1.76,1.8,1.78>  rotate y*90 translate<6,15,49>}
   object{Chain scale<1.76,1.8,1.78>  rotate y*90 translate<94,15,49>}
   object{Chain scale<1.76,1.8,1.78>  rotate y*90 translate<6,15,132>}
   object{Chain scale<1.76,1.8,1.78>  rotate y*90 translate<94,15,132>}
   object{GraveStone1 scale 2.2 translate<50,5,130>
       texture{ GraveTexture1 finish {specular 0.2}}
       texture{RustLines scale 2}
   }
   texture{GraveTexture1}
   finish{ specular 0.2 roughness 0.01 ambient 0.25}
   normal{ bumps 0.3 scale 0.1}

   scale 1.2
}


#declare Grave10 =                      // Iron cross on a platform
union{
   object{CrossPlatform scale 1.5 texture{GraveGranite scale 2.5}}
   object{Cross2 translate y*20 texture{ChainTexture}}
}

