// Persistence Of Vision raytracer version 3.0 sample file.
// Render this file to create CRAT_DAT.TGA and then render CRATER.POV
// Use special 16-bit gray output

#version 3.0
global_settings { assumed_gamma 2.2 hf_gray_16 }

#include "colors.inc"

// a wrinkle colored plane

plane {z,10
  texture {
    pigment{ wrinkles
      color_map {
        [ 0.000  color rgb<0.000, 0.000, 0.000> ]
        [ 0.396  color rgb<0.500, 0.500, 0.500> ]
        [ 0.935  color rgb<0.750, 0.750, 0.750> ]
        [ 1.000  color rgb<1.000, 1.000, 1.000> ]
      }
    }
  }
}

// Main spotlight creates crater mountain
light_source {0 color 1  spotlight point_at z*10
  radius 7 falloff 11
}

// Dim spotlight softens outer edges further
light_source {0 color .25  spotlight point_at z*10
  radius 2 falloff 15
}

// Narrow spotlight creates central peak
light_source {0 color .1  spotlight point_at z*10
  radius 0 falloff 1.3
}

// Negative spotlight cuts out crater insides
light_source {0 color -0.9  spotlight point_at z*10
  radius 5 falloff 9.5
}

// Dim negative spotlight counteracts dim positive light in center
light_source {0 color -.25  spotlight point_at z*10
  radius 3 falloff 8
}

