#include "colors.inc"
//#include "textures.inc"
#include "stones.inc"

#version 3.0
global_settings { assumed_gamma 2.2 }


camera {
   location <0.0, 0.75, -1.0>
//   location <0.5, 0.85, -0.75>
   direction <0,0,0.6873>
   right <1.3333,0,0>
   look_at <0.0000,0.500,0.0000>
} 

/* camera {
   location <0.0, 2, 0>
   direction <0,0,0.6873>
   right <1.3333,0,0>
   look_at <0.0000,0.000,0.0000>
} */


//light_source{<2.50, 5, 150> colour White}
#declare Dist=80.0
light_source {< 2.5, 5, 150> color White
   fade_distance Dist fade_power 2
   area_light <-40, 0, -40>, <40, 0, 40>, 3, 3
   adaptive 1
   jitter
}  

light_source{<0, 1, -10> color White }

light_source{<0, 100, 0> colour Gray40}

//light_source{<-20,100,-100> colour White}
light_source{<-10, 40, 100> colour Orange}

sky_sphere {
    pigment { 
        gradient y
        color_map {
            [0.0 Orange ]
//            [0.0 color LightSteelBlue * 1.25]
            [0.2 SteelBlue ]
            [0.6 MidnightBlue ]
        }
    }
   pigment {
      bozo
      turbulence 1.0
      colour_map {
         [0.0 0.4 colour Orange filter 0.8
                  colour Orange * 0.75 filter 0.9]
         [0.4 0.9 colour Orange * 0.75 filter 1.0
                  colour Orange * 1.2]
         [0.9 1.0 colour Orange * 1.2
                  colour Orange]
      }
//      scale <12.0, 3.0, 12.0> / 40
        scale 0.75
      translate <100, 60, 30>
      rotate <120.0, -40.0, 45.0>
   }
}



#declare Orig_Fog = 1    
#declare Ground_Mist= 2
#declare YZ_Fog1 = 3

fog{ 
//    fog_type YZ_Fog1
    fog_type Ground_Mist
    fog_alt 0.5
    fog_offset 0
    distance 2
    color Orange * 1.2
//    color Orange
    turbulence 0.5
    omega 0.25
    lambda 2.5
    octaves 6
}    

#declare Default = texture {
   pigment { color rgb <1,1,1> }
   finish { phong 1.0 }
}

// Object 00001: Play0000

plane {
   <0,1,0>,0
   texture {
        T_Grnt25
        normal {wrinkles 0.6}
   }
   translate <0, 0.52, 0>
}

// Object 00002: HFld0000

object {
   height_field {
      tga
      "HF.TGA"
      smooth
   }
   texture {
      T_Grnt25
      scale 0.5
//      normal {wrinkles 0.6}
   }
   scale <5, 0.65, 5>
   translate <-2.5, 0.5, -2.5>
}

cylinder {<-0.1, 0.580, -0.1>, <0, -1, 0>, 0.58
  texture {
    pigment {
      average
      pigment_map {
        [
          image_map { tga "CLOCK.TGA" }
          translate <0.61, 0.3, 0.68>
          rotate x * 90 
          translate <0.02, 0., 0.1>
        ]
        [ color rgbf <0.2, 0.2, 0.3, 0.7>]
      }
    }

    normal {
        ripples 0.6
        frequency 3
        turbulence 0.5
        scale 0.1
    }
    finish {
        reflection 0.3
        refraction 0.5
        ior 1.33
    }
  }
}


sphere {<-0.6, 0.85, 0>, 0.15
  pigment {
    crackle
    turbulence 0.5
    colour_map {
      [0.15 color rgb <.35, 0, 0>]
      [0.30 color Gray05 ]
      [0.50 color Gray10 ]
      [1.00 color Gray20]
    }
    scale 0.125 / 2
  }
  normal { crackle 0.6 scale 0.125 turbulence 0.5}
  finish {
      crand 0.08
      ambient 0.6
      diffuse 0.7
  }
}

sphere {<-0.6, 0.85, 0>, 0.151
   pigment {
      bozo
      turbulence 1.0
      colour_map {
         [0.0 0.4 colour red 0.5 green 0.5 blue 0.5 filter 0.8
                  colour red 0.5 green 0.5 blue 0.5 filter 0.9]
         [0.4 0.9 colour red 0.5 green 0.5 blue 0.5 filter 1.0
                  colour red 0.5 green 0.5 blue 0.5]
         [0.9 1.0 colour red 0.5 green 0.5 blue 0.5
                  colour red 0.5 green 0.5 blue 0.5]
      }
      scale <12.0, 3.0, 12.0> / 40 /2
      translate <100, 60, 30>
      rotate <120.0, -40.0, 45.0>
   }
   finish {
      ambient 0.5
      diffuse 0.8
   }
}

sphere {<-0.6, 0.85, 0>, 0.1501
  pigment {
      dents
      turbulence 1
      colour_map {
         [0.0 0.98 colour red 1.0 green 1.0 blue 1.0 filter 1.0
                  colour red 1.0 green 0.75 blue 0.25 filter 1.0]
         [0.98 1.0 colour red 1.0 green 0.25 blue 0.25 filter 1.0
                  colour red 1.0 green 0.5 blue 0.25]
      }
      scale <12.0, 3.0, 12.0> / 40 /3
      translate <10, 20, 70>
      rotate <0.0, -40.0, 45.0>
   }
  
   finish {
      ambient 1.0
      diffuse 1.0
   }
}



sphere {<0.0, 0.9, 0>, 0.15
   pigment {
      bozo
      turbulence 0.5
      colour_map {
         [0.0 0.9  colour red 0.0 green 0.3 blue 0.5
                   colour red 0.0 green 0.3 blue 0.8]
         [0.9 1.0  colour red 0.0 green 0.4 blue 0.0
                   colour red 0.4 green 0.2 blue 0.1]
         [1.0 1.01 colour red 0.4 green 0.2 blue 0.1
                   colour red 0.5 green 0.3 blue 0.3]
      }
      scale 0.125
      translate <59.75, 190.75, 10>
   }
   finish {
      ambient 0.5
      diffuse 0.8
   }

}


sphere {<0.0, 0.9, 0>, 0.151
   pigment {
      bozo
      turbulence 0.75
      colour_map {
         [0.0 0.3 colour red 1.0 green 1.0 blue 1.0 filter 1.0
                  colour red 1.0 green 1.0 blue 1.0 filter 1.0]
         [0.3 0.9 colour red 1.0 green 1.0 blue 1.0 filter 1.0
                  colour red 1.0 green 1.0 blue 1.0]
         [0.9 1.0 colour red 1.0 green 1.0 blue 1.0
                  colour red 1.0 green 1.0 blue 1.0]
      }
      scale <12.0, 4.0, 12.0> / 12 /4
      rotate <80.0, 150.0, 25.0>
      translate x*30
   }
   finish {
      ambient 0.8
      diffuse 0.7
   }
}



sphere {<0.6, 0.84, 0>, 0.15
   pigment {
      bozo
      turbulence 0.3
      colour_map {
         [0.0 0.4  colour red 0.0 green 0.2 blue 0.6
                   colour red 0.0 green 0.3 blue 0.8]
         [0.4 0.7  colour red 0.0 green 0.3 blue 0.8
                   colour red 0.0 green 0.3 blue 0.8]
         [0.7 1.0  colour red 0.0 green 0.5 blue 0.0
                   colour red 0.6 green 0.6 blue 0.0]
         [1.0 1.01 colour red 0.6 green 0.6 blue 0.0
                   colour red 0.7 green 0.3 blue 0.3]
      }
      scale 0.25
      translate <97, 800, 70>
//      rotate <0, 12, 29>
   }
  
   finish {
      crand 0.08
      ambient 0.2
      diffuse 0.8
   }
}

sphere { <0.6, 0.84, 0>, 0.151
   pigment {
      dents
      turbulence 1
      colour_map {
         [0.0 0.98 colour red 1.0 green 1.0 blue 1.0 filter 1.0
                  colour red 1.0 green 1.0 blue 0.75 filter 1.0]
         [0.98 1.0 colour red 1.0 green 1.0 blue 0.75 filter 1.0
                  colour red 1.0 green 1.0 blue 0.75]
      }
      scale <12.0, 3.0, 12.0> / 40 /3
      translate <10, 20, 70>
      rotate <0.0, -40.0, 45.0>
   }
  
   finish {
      crand 0.08
      ambient 1.0
      diffuse 0.8
   }
}


sphere { <0.6, 0.84, 0>, 0.152
   pigment {
      bozo
      turbulence 0.85
      colour_map {
         [0.0 0.4 colour red 1.0 green 1.0 blue 1.0 filter 1.0
                  colour red 1.0 green 1.0 blue 1.0 filter 1.0]
         [0.4 0.9 colour red 1.0 green 1.0 blue 1.0 filter 1.0
                  colour red 1.0 green 1.0 blue 1.0]
         [0.9 1.0 colour red 1.0 green 1.0 blue 1.0
                  colour red 1.0 green 1.0 blue 1.0]
      }
      scale <12.0, 3.0, 12.0> / 30 /2
      rotate <160.0, 10.0, 145.0>
   }
   finish {
      ambient 0.0
      diffuse 1.0
   }
}





