// This is the file that contains everything for the top of the clock that 
// varies with time. (i.e. the hands) v1.0
//   Created by: Ryan Wellman (firestar@eskimo.com)
// Copyright 1996, Ryan Wellman

#declare clock_top_hands = union {
  cylinder {
    < 0, 0, -.0125 >,
    < 0, 0,  .0000 >,
    .0125/3
  }
  sphere {
    < 0, 0, -0.125 >,
    .0125/3
  }
  object {
    clock_top_sec_hand
    rotate (-360 * SECONDS / 60 ) * z
    translate < 0, 0, -.0125 >
  }
  object {
    clock_top_min_hand
    rotate (-360 * SECONDS / 3600 ) * z
    translate < 0, 0, -.0125 * 2 / 3 >
  }
  object {
    clock_top_hour_hand
    rotate (-360 * SECONDS / 43200 ) * z
    translate < 0, 0, -.0125 / 3 >
  }
}

#declare clock_top = union {
  object {
    clock_vtop
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
  }
  object {
    clock_top_box
    translate < 0, -.05, 0 >
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
  }

  // The Face of the clock.
  cylinder {
    < .4, .4, .025>,
    < .4, .4, Clock_Total_Depth - .1 >,
    .4
    pigment {
      image_map {
        tga "clockfce.tga"
      }
      scale .8
    }
    translate < -.4, -.95, 0 >
  }

  // The Hands of the Clock.
  object {
    clock_top_hands
    translate < 0, -.55, .025 >
    texture {
      pigment { Black }
      finish { Shiny }
    }
  }

  // The brass ring around the clock face.
  difference {
    torus {
      .4, .012
      rotate x*90
      translate < 0, -.55, .025 >
    }
    sphere {
      < 0, -.55, 3.125 >,
      3.125
    }
    texture { T_Brass_5E }
  }

  // The Glass face on the clock.
  intersection {
    difference {
      sphere {
        < 0, -.55, 3.125 >,
        3.125
      }
      sphere {
        < 0, -.55, 3.125 >,
        3.123
      }
    }
    box {
      < -.475, -1.025, -.1 >
      <  .475, -0.075, .026 >
    }

    texture { T_Glass3 }
  }

  // The four Pillars.
  object {
    clock_top_pillar
    translate < -.6, -.05, .05 >
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
  }
  object {
    clock_top_pillar
    translate < .6, -.05, .05 >
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
  }
  object {
    clock_top_pillar
    translate < -.6, -.05, Clock_Total_Depth - .1 >
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
  }
  object {
    clock_top_pillar
    translate < .6, -.05, Clock_Total_Depth - .1 >
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
  }

  // The base of the top of the clock.
  difference {
    box {
      < -.7, -.05, -.05 >,
      <  .7,  .00, Clock_Total_Depth >
    }
    box {
      < 0, 0, -.06 >,
      < .1, .1, Clock_Total_Depth + .01 >
      rotate -135*z
      translate < -.7, 0, 0 >
    }
    box {
      < 0, 0, -.06 >,
      < .1, .1, Clock_Total_Depth + .01 >
      rotate -135*z
      translate < -.7, 0, 0 >
    }
    box {
      < -.71, 0, -.1 >,
      <  .71, .1, 0 >
      rotate -135*x
      translate < 0, 0, -.05 >
    }

    translate < 0, -1.05, 0 >
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
  }
  translate < 0, 1.1, 0 >
}
