// This is the invariant part of the main clock body.  All the variable
// parts are declared in "clockvar.inc"
//   Created by: Ryan Wellman (firestar@eskimo.com)
// Copyright 1996, Ryan Wellman

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "glass.inc"      // The glass texture include
#include "metals.inc"     // The metal texture include
#include "textures.inc"	  // Standard Texture definitions
#include "woods.inc"      // The wood includes

#declare Clock_Wood_Type = texture { T_Wood34 }
#declare Clock_Wood_Type2 = texture { T_Wood32 }

#declare Texture_Scale_Base = .02
#declare Texture_Var = .5
#declare Texture_Seed = seed(314)

#include "clocktop.inc"

#declare Clock_Body_Height = 3.7
#declare Clock_Mid_Height = 3.7 * 17/24
#declare Clock_Base_Height = 3.7 * 7/24

#declare Clock_Pendulum_Length = Clock_Mid_Height * .8

#declare clock_box = difference {
  union {
    box {
      < -.5, -Clock_Mid_Height, 0 >,
      <  .5,  0.0, Clock_Total_Depth >
    }
    box {
      < -.65, -Clock_Body_Height,        -.15 >
      <  .65, -Clock_Mid_Height, Clock_Total_Depth >
    }
  }
  // Cut out the inside.
  box {
    < -.45, -Clock_Mid_Height, .05 >,
    <  .45, -.05, Clock_Total_Depth - .05 >
  }
  // Cut out the opening for the door.
  box {
    < -.3, -(Clock_Mid_Height - .15), -.01 >,
    <  .3, -.15, .06 >
  }
  // Angle down the base.
  box {
    < 0, 0, -.16 >,
    < .3, .3, Clock_Total_Depth + .01 >
    rotate -degrees(atan2(2, 1.5)) * z
    translate < .5, -Clock_Mid_Height, 0 >
  }
  box {
    < -.3, 0, -.16 >,
    < 0, .3, Clock_Total_Depth + .01 >
    rotate degrees(atan2(2, 1.5)) * z
    translate < -.5, -Clock_Mid_Height, 0 >
  }
  box {
    < -.7, 0, -.3 >,
    <  .7, .3,  0 >
    rotate -degrees(atan2(2, 1.5)) * x
    translate < 0, -Clock_Mid_Height, 0 >
  }
}

#declare pendulum = union {
  // Cylinder at the top.
  cylinder {
    <0, 0, -.05>,
    <0, 0,  .05>,
    .05
  }
  // The Shaft
  cylinder {
    <0, -Clock_Pendulum_Length, 0>,
    <0, 0, 0>,
    .025
  }
  // The Bottom of the Pendulum.
  intersection {
    cylinder {
      <0, -Clock_Pendulum_Length, -.051 >,
      <0, -Clock_Pendulum_Length,  .025 >,
      .15
    }
    sphere {
      <0, -Clock_Pendulum_Length, .4125 >,
      .4625
    }
  }
}

#declare clock_door_edge_top = difference {
  union {
    box {
      < -.4, .000, -.05 >,
      <  .4, .075,  .00 >
    }
    intersection {
      cylinder {
        < -.4, .075, 0 >,
        <  .4, .075, 0 >
        .025
      }
      box {
        < -.41, .075, -.05 >,
        <  .41, .100,  .00 >
      }
    }
  }
  cylinder {
    < -.41, .075, -.05 >,
    <  .41, .075, -.05 >
    .025
  }
  box {
    < -.2, .0, -.06 >,
    <  .0, .2,  .01 >
    rotate 45*z
    translate < -.3, 0, 0 >
  }
  box {
    <  0,  0, -.06 >,
    < .2, .2,  .01 >
    rotate -45*z
    translate < .3, 0, 0 >
  }
  difference {
    box {
      < -.41, -.1, -.1 >,
      <  .41,  .0,  .0 >
    }
    box {
      < -.41, -.1, -.1 >,
      <  .41,  .0,  .0 >
      rotate degrees(atan2(2,4)) * x
    }
    translate < 0, .05, -.05/4 >
  }
}

#declare clock_door_edge_side = difference {
  union {
    box {
      <0, -(Clock_Mid_Height - .2), -.05>,
      <.075, 0, 0>
    }
    intersection {
      cylinder {
        <.075, -(Clock_Mid_Height - .2), 0>,
        <.075, 0, 0>,
        .025
      }
      box {
        <  .075, -(Clock_Mid_Height - .1), -.026>,
        < 1.000, .1, 0>
      }
    }
  }
  cylinder {
    <.075, -(Clock_Mid_Height - .1), -.05>,
    <.075, .1, -.05>,
    .025
  }
  box {
    < 0,  0, -.06>,
    <.2, .2,  .01>
    rotate 45*z
    translate < 0, -.1, 0 >
  }
  box {
    < 0,  -.2, -.06>,
    <.2, 0,  .01>
    rotate -45*z
    translate < 0, -(Clock_Mid_Height - .3), 0 >
  }
  difference {
    box {
      <-.1, -(Clock_Mid_Height - .1), -.1>,
      <0, .1, 0 >
    }
    box {
      <-.1, -(Clock_Mid_Height - .1), -.1>,
      <0, .1, 0 >
      rotate -degrees(atan2(2,4)) * y
    }
    translate <.05, 0, -.05/4 >
  }
}


#declare clock_door_knob = union {
  cylinder {
    < 0, 0, 0 >,
    < 0, 0, -.03 >,
    .0075
  }
  intersection {
    union {
      sphere {
        < 0, 0, .01 >,
        sqrt( .04*.04 + .035*.035 )
      }
      sphere {
        < 0, 0, -.03 >
        sqrt( .02*.02 + .01*.01 )
      }
    }
    box {
      < -.035, -.035, -.0524 >,
      <  .035,  .035, -.0300 >
    }
  }
}

#declare clock_door_keyhole = union {
  cylinder {
    < 0, .01, 0 >,
    < 0, .01, -.052 >,
    .005
  }
  prism {
    linear_spline
    0, .052,
    4
    <-.005, -.015>, < .005, -.015>, < .000, .015 >, <-.005, -.015>
    rotate -90*x
  }
}

#declare clock_door_keyplate = union {
  difference {
    box {
      < -.02, -.025, -.001 >,
      <  .02,  .025,  .000 >
    }
    cylinder {
      < -.02, -.025, -.0011 >,
      < -.02, -.025,  .0001 >,
      .01
    }
    cylinder {
      < .02, -.025, -.0011 >,
      < .02, -.025,  .0001 >,
      .01
    }
    cylinder {
      < -.02, .025, -.0011 >,
      < -.02, .025,  .0001 >,
      .01
    }
    cylinder {
      < .02, .025, -.0011 >,
      < .02, .025,  .0001 >,
      .01
    }
  }

  // --------------------------
  //  The eight little rivets.
  // --------------------------
  sphere {
    < -.0075,  .0225, -.001 >,
    .001
  }
  sphere {
    <  .0075,  .0225, -.001 >,
    .001
  }
  sphere {
    < -.0075, -.0225, -.001 >,
    .001
  }
  sphere {
    <  .0075, -.0225, -.001 >,
    .001
  }

  sphere {
    < -.0175,  .0125, -.001 >,
    .001
  }
  sphere {
    < -.0175, -.0125, -.001 >,
    .001
  }
  sphere {
    <  .0175,  .0125, -.001 >,
    .001
  }
  sphere {
    <  .0175, -.0125, -.001 >,
    .001
  }
}

#declare clock_door = union {
  object {
    clock_door_edge_top
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
    translate <0, -.2, 0 >
  }
  difference {
    union {
      object {
        clock_door_edge_side
        translate < .3, -.1, 0 >
        texture {
          Clock_Wood_Type
          // Scale the texture to the texture base by +- Texture_Var%
          scale Texture_Scale_Base *
                    ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
        }
      }
      object {
        clock_door_keyplate
        translate < .325, -(Clock_Mid_Height / 2 + .05), -.05 >
        texture { T_Brass_5E }
      }
    }
    object {
      clock_door_keyhole
      translate < .325, -(Clock_Mid_Height / 2 + .05), .001 >
    }
  }
  object {
    clock_door_knob
    texture { T_Brass_5E }
    translate < .325, -(Clock_Mid_Height / 2 - .05), -.05 >
  }
  object {
    clock_door_edge_side
    scale < -1, 1, 1 >
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
    translate < -.3, -.1, 0 >
  }
  object {
    clock_door_edge_top
    scale < 1, -1, 1 >
    translate < 0, -(Clock_Mid_Height - .3) - .1, 0 >
    texture {
      Clock_Wood_Type
      // Scale the texture to the texture base by +- Texture_Var%
      scale Texture_Scale_Base *
                ( 1 + 2*(rand(Texture_Seed) - .5)*Texture_Var )
    }
  }

  // The Glass in the window.
  difference {
    box {
      < -.35, -(Clock_Mid_Height - .15), 0 >,
      <  .35, -.15, -.05 >
    }
    box {
      < -.36, -.2, -.2 >,
      <  .36,  .0,  .0 >
      rotate degrees(atan2(2,4))*x
      translate < 0, -.15, 0 >
    }
    box {
      < -.36, .0, -.2 >,
      <  .36, .2,  .0 >
      rotate -degrees(atan2(2,4))*x
      translate < 0, -(Clock_Mid_Height - .15), 0 >
    }
    box {
      < .0, -(Clock_Mid_Height - .14), -.2 >,
      < .2, -.14, 0 >
      rotate degrees(atan2(2,4)) * y
      translate < -.35, 0, 0 >
    }
    box {
      < -.2, -(Clock_Mid_Height - .14), -.2 >,
      <  .0, -.14, 0>
      rotate -degrees(atan2(2,4)) * y
      translate < .35, 0, 0 >
    }
    translate < 0, 0, .05/4 >
    texture { T_Glass3 }
  }
}
