// Title: Lost Time
// Author: Ryan N. Wellman
// Email: firestar@eskimo.com
//   Copyright (c) 1996, Ryan Wellman

// The standard include files.
#include "colors.inc"
#include "textures.inc"

// The main clock include file.
#include "Clock.inc"
#declare TimeRand = seed( 2412 )

// set viewer's position in the scene
camera {
  location  < 0, 0, -3.5 >     // position of camera <X Y Z>
  look_at   <0, 0,  0>         // point center of view at this point <X Y Z>

// (focal blur extras)
  aperture 0.112             // 0...N (bigger is narrower depth of field)
  blur_samples 20            // # of rays per pixel
  focal_point <0,0,.1>       // x,y,z point that is in focus
}

// create a regular point light source
light_source {
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  fade_distance 45
  fade_power 2
  translate <-20, 40, -20>
}

// create a regular point light source
light_source {
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  fade_distance 20
  fade_power 2
  translate <10, 8, -20>
}

light_source {
  0*x
  color rgb< .4, .4, .4 >
  translate < 10, 8, -19.9 >
}

// The big face of the clock in the background.
#declare SECONDS = 86400 * rand( TimeRand )
#include "clcktvar.inc"
object {
  clock_top
  translate < 0, -.66, .2 >
  scale 44.61
  translate < 0, 0, 52 >
}

// The main clock in the front of the spiral.
#declare SECONDS = 28946
#include "clockvar.inc"
object {
  grandfather_clock
  scale .55
  translate < .25, 0, 0 >
}

// Position the spiral of clocks.
#declare CLOCKS = 0
#while( CLOCKS < (3*8) )
  #declare SECONDS = 86400.0 * rand( TimeRand )
  #include "clockvar.inc"
  object {
    grandfather_clock
    scale .55
//    rotate (180*(-CLOCKS * 2*pi/(3*8/1.5) - 5*pi/8)/pi + pi)*z
    rotate 180*((-CLOCKS * 2/(3*8/1.5) - 5/8) + 1)*z
    translate < (2.25-.35*CLOCKS/(3*8)) * cos(-CLOCKS*2*pi/(3*8/1.5)-5*pi/8 ),
                (2.25-.35*CLOCKS/(3*8)) * sin(-CLOCKS*2*pi/(3*8/1.5)-5*pi/8 )
                    - 7.1376*CLOCKS/(3*8),
                (16/8) * (CLOCKS + 1) >
  }
#declare CLOCKS = CLOCKS + 1
#end
