/* File         : Steps.inc
 *
 * Purpose      : The steps leading up to the house
 * Author       : (C)1996 Matthew Hunter
 * Version      : 0.02  (06 May 1996)
 *                0.05  (28 June 1996)
 */

// include the standard textures
#include "GTexts.inc"

// base step object
#declare Object_Step = union {
  box {
    <-5,0.0,-5>
    < 5,0.5, 5>
  }
  #declare Rounded_Size = 10
  #declare Rounded_Width = 10
  #declare Rounded_Height = 0.2
  object {
    #include "Rounded.inc"
    translate <0.0,0.5,0.0>
  }
  texture { TSteps }
}

// **************************************************************************
// The flight of stairs up to the 'terrace'
object {
  Object_Step
  translate <0,0,15>
}
object {
  Object_Step
  translate <0,0.7,16>
}
object {
  Object_Step
  translate <0,1.4,17>
}
object {
  Object_Step
  translate <0,2.1,18>
}
object {
  Object_Step
  translate <0,2.8,19>
}

// **************************************************************************
// The 'terrace' area
union {
  difference {
    union {
      box {
        <-50,0.0, -25>
        < 50,0.5,  25>
      }
      #declare Rounded_Size = 50
      #declare Rounded_Width = 100
      #declare Rounded_Height = 0.2
      object {
        #include "Rounded.inc"
        translate <0.0,0.5,0.0>
      }
    }
    box {
      <-48,0.25,-24>
      < 48,1.00, 24>
    }
    texture { TSteps }
  }
  box {
    <-48,0.25,-24>
    < 48,0.45, 24>
    texture { TGravel }
  }
  translate <0,3.5,40>
}

// **************************************************************************
// The bannister
#declare Object_Thick_Pillar = object {
  lathe {
    cubic_spline
    8
    <0,0> <0.5,0> <0.7,0.5> <0.5,1.0> <0.6,1.4> <0.5,1.8> <0,1.8> <0,0>
  }
}

#declare Object_Thin_Pillar = object {
  lathe {
    cubic_spline
    8
    <0,0> <0.15,0> <0.25,0.5> <0.15,1.0> <0.2,1.3> <0.15,1.6> <0,1.6> <0,0>
  }
}


#declare Object_Bannister = union {
union {         // The pillar at the bottom of the steps
  box {
    <-0.75,0.0,-0.75>
    < 0.75,2.0, 0.75>
  }
  #declare Rounded_Size = 1.3
  #declare Rounded_Width = 1.3
  #declare Rounded_Height = 0.1
  object {
    #include "Rounded.inc"
    translate <0,2.0,0>
  }
  object {
    sphere {
      <0,2.85,0>
      0.75
    }
  }
  translate <-5,0,10>
  texture { TSteps }
}

union {         // The pillar at the top of the steps
  box {
    <-0.75,0.0,-0.75>
    < 0.75,7.0, 0.75>
  }
  #declare Rounded_Size = 1.3
  #declare Rounded_Width = 1.3
  #declare Rounded_Height = 0.1
  object {
    #include "Rounded.inc"
    translate <0,7.0,0>
  }
  object {
    sphere {
      <0,7.85,0>
      0.75
    }
  }
  translate <-5,0,15>
  texture { TSteps }
}

union {         // The pillar at the end of the terrace
  box {
    <-0.75,0.0,-0.75>
    < 0.75,7.0, 0.75>
  }
  #declare Rounded_Size = 1.3
  #declare Rounded_Width = 1.3
  #declare Rounded_Height = 0.1
  object {
    #include "Rounded.inc"
    translate <0,7.0,0>
  }
  object {
    sphere {
      <0,7.85,0>
      0.75
    }
  }
  translate <-50,0,15>
  texture { TSteps }
}

union {         // The pillar at the join with the wings
  box {
    <-0.75,0.0,-0.75>
    < 0.75,7.0, 0.75>
  }
  #declare Rounded_Size = 1.3
  #declare Rounded_Width = 1.3
  #declare Rounded_Height = 0.1
  object {
    #include "Rounded.inc"
    translate <0,7.0,0>
  }
  object {
    sphere {
      <0,7.85,0>
      0.75
    }
  }
  translate <-50,0,34.25>
  texture { TSteps }
}

union {         // The base of the wall next to the steps
  box {
    <-0.5,0.0,-2.5>
    < 0.5,1.0, 2.5>
  }
  #declare Rounded_Size = 4.8
  #declare Rounded_Height = 0.1
  #declare Rounded_Width = 0.8
  object {
    #include "Rounded.inc"
    translate <0,1,0>
  }
  translate <-5,0,12.5>
  texture { TSteps }
}

union {         // The base of the wall, under the 'terrace'
  box {
    <-22.5,0.0,-0.5>
    < 22.5,1.0, 0.5>
  }
  #declare Rounded_Size = 0.8
  #declare Rounded_Height = 0.1
  #declare Rounded_Width = 44.8
  object {
    #include "Rounded.inc"
    translate <0,1,0>
  }
  translate <-27.5,0,15>
  texture { TSteps }
}

union {         // The base of the wall, towards the wing
  box {
    <-0.5,0.0,-10>
    < 0.5,1.0, 10>
  }
  #declare Rounded_Size = 19.8
  #declare Rounded_Height = 0.1
  #declare Rounded_Width = 0.8
  object {
    #include "Rounded.inc"
    translate <0,1,0>
  }
  translate <-50,0,25>
  texture { TSteps }
}

union {         // The upper edge of the wall, by the stairs
  #declare SLength = 5.5
  #declare SLength2 = SLength/2
  box {
    <-0.5, 0.0,-SLength2>
    < 0.5, 0.5, SLength2>
  }
  #declare Rounded_Size = SLength-0.2
  #declare Rounded_Height = 0.1
  #declare Rounded_Width = 0.8
  object {
    #include "Rounded.inc"
    translate <0,0.5,0>
  }
  object {
    #include "Rounded.inc"
    translate <0,-0.1,0>
  }
  translate <0,0,SLength2>
  rotate <-30,0,0>
  translate <-5,1,10.5>
  texture { TSteps }
}

union {         // The upper edge of the wall, under the 'terrace'
  union {       // The lower level / edge of the terrace area
    box {
      <-22.5,0.0,-0.5>
      < 22.5,1, 0.5>
    }
    #declare Rounded_Size = 0.8
    #declare Rounded_Height = 0.1
    #declare Rounded_Width = 44.8
    object {
      #include "Rounded.inc"
      translate <0,1,0>
    }
    object {
      #include "Rounded.inc"
      translate <0,-0.1,0>
    }
  }
  union {       // The upper level / top railing
    box {
      <-22.5,0.0,-0.5>
      < 22.5,0.25, 0.5>
    }
    #declare Rounded_Size = 0.8
    #declare Rounded_Height = 0.1
    #declare Rounded_Width = 44.8
    object {
      #include "Rounded.inc"
      translate <0,0.25,0>
    }
    object {
      #include "Rounded.inc"
      translate <0,-0.1,0>
    }
    translate <0,2.8,0>
  }
  union {       // Supports for the upper level
    #declare Count = 21
    #while (Count > -21)
      object {
        Object_Thin_Pillar
        translate <Count,1.1,0>
      }
      #declare Count = Count - 1
    #end
  }
  translate <-27.5,3.5,15>
  texture { TSteps }
}

union {         // The upper edge of the wall, towards the wing
  union {       // The lower level / edge of the terrace area
    box {
      <-0.5,0.0,-10>
      < 0.5,1,  10>
    }
    #declare Rounded_Size = 19.8
    #declare Rounded_Height = 0.1
    #declare Rounded_Width = 0.8
    object {
      #include "Rounded.inc"
      translate <0,1,0>
    }
    object {
      #include "Rounded.inc"
      translate <0,-0.1,0>
    }
  }
  union {       // The upper level / top railing
    box {
      <-0.5,0.0,-10>
      < 0.5,0.25,10>
    }
    #declare Rounded_Size = 19.8
    #declare Rounded_Height = 0.1
    #declare Rounded_Width = 0.8
    object {
      #include "Rounded.inc"
      translate <0,0.25,0>
    }
    object {
      #include "Rounded.inc"
      translate <0,-0.1,0>
    }
    translate <0,2.8,0>
  }
  union {       // Supports for the upper level
    #declare Count = 9
    #while (Count > -9)
      object {
        Object_Thin_Pillar
        translate <0,1.1,Count>
      }
      #declare Count = Count - 1
    #end
  }
  translate <-50,3.5,25>
  texture { TSteps }
}

union {   // The brick facing on the terrace
  box {
    <-22.5,0.0,-0.25>
    < 22.5,2.5, 0.25>
    texture { TBrick_Wall }
    // texture { TCracks }
  }
  box {
    <-22.5,0.0,-0.20>
    < 22.5,2.5, 0.20>
    texture { TMortar }
  }
  translate <-27.5,1,15>
}

union {   // The brick facing on the terrace end
  box {
    <-0.25,0.0,-10>
    < 0.25,2.5, 10>
    texture { TBrick_Wall }
    // texture { TCracks }
  }
  box {
    <-0.20,0.0,-10>
    < 0.20,2.5, 10>
    texture { TMortar }
  }
  translate <-50,1,25>
}

difference {
  union {
    box {
      <-2.5,0.0,-0.25>
      < 2.5,2.5, 0.25>
      texture { TBrick_Wall }
      // texture { TCracks }
    }
    box {
      <-2.5,0.0,-0.20>
      < 2.5,2.5, 0.20>
      texture { TMortar }
    }
    rotate <0,90,0>
    translate <0,0,2.5>
  }
  box {
    <-1,0,-3>
    < 1,8, 0>
    rotate <60,0,0>
    translate <0,0.5,0>
  }
  translate <-5,1,11>
}
}

object {
  Object_Bannister
}

object {
  Object_Bannister
  scale <-1,1,1>
}

