/* File		: time.pov
 *
 * Purpose	: Top level file for the 'time' image
 * Author	: (C)1996 Matthew Hunter
 * Version	: 0.02	(06 May 1996)
 *            0.05  (28 June 1996)
 *              Release version. Added various cameras, some of which are
 *              'Widescreen' ratio, (right <2.35,0,0>) so set the width and
 *              height appropriately, e.g 470x200, 704x300 etc.
 */

// **************************************************************************
// Select which of the multiple cameras to use.
#declare Use_Camera = int(clock)

// make sure a valid camera is used by defaulting to camera 1
#if (Use_Camera=0)
#declare Use_Camera = 1
#end

// **************************************************************************
// define a visible default texture.
#default {
  texture {
    pigment {
      colour rgbf <1.0,1.0,1.0,0.0>
    }
    finish {
      ambient 0.3
      diffuse 0.6
      phong 0
      specular 0
      reflection 0
      refraction 0
      ior 1
    }
  }
}

// **************************************************************************
// The camera block
// Use of the case statement allows several different cameras to be used simply
// to obtain different views of the same scene file.
#switch (Use_Camera)
  #case (1)
    // This is looking directly at the Sundial
    camera
    {
      location  <5.0, 6.0, -15.0>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <0.0, 3.0,  0.0>
    }
  #break
  #case (2)
    // This is looking directly at the Sundial Face
    camera
    {
      location  <5.0, 6.0, -3.0>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <0.0, 4.0,  0.0>
    }
  #break
  #case (3)
    // This is looking directly at the Sundial Face in closeup
    camera
    {
      location  <-2.5, 6.0, -1.5>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <0.0, 3.5,  0.0>
    }
  #break
  #case (4)
    // This is looking at the bannister
    camera
    {
      location  <-20, 6.0, -5>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <0.0, 3.5,  20.0>
    }
  #break
  #case (5)
    // This is looking at the bannister
    camera
    {
      location  <-20, 6.0, 15>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <0.0, 0.5, 15.0>
    }
  #break
  #case (6)
    // This is looking at the sun
    // Don't try this at home kids, remember looking into the
    // sun can seriously damage your eyesight :)
    camera
    {
      location  <-20, 6.0, 15>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <-10000, 5000, -20000>
    }
  #break
  #case (7)
    // This is looking at the west end of the terrace
    camera
    {
      location  <-20, 6.0, -15>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <-50, 5, 40>
    }
  #break
  #case (8)
    // This is at the centre of the house looking towards the west wing
    camera
    {
      location  <20, 10.0, 115>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <-75, 8, 65>
    }
  #break
  #case (9)
    // This is looking directly at the Sundial
    camera
    {
      location  <5.0, 6.0, -15.0>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <-15, 8.0,  65>
    }
  #break
  #case (10)
    // This is looking directly at the west wing
    camera
    {
      location  <45.0, 10.0, 20.0>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <-45, 8.0,  35>
    }
  #break
  #case (11)
    // This is looking at the west end of the terrace
    camera
    {
      location  <-80, 6.0, -15>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <-50, 5, 40>
    }
  #break
  #case (12)
    // This is looking along the avenue towards the rear of the house
    camera
    {
      location  < 0, 6.0, -300>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   < 0, 8, 40>
    }
  #break
  #case (13)
    // This is at the centre of the house looking towards the west wing
    // on the first floor
    camera
    {
      location  <20, 23.0, 115>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   <5,17, 115>
    }
  #break
  #case (14)
    // This is looking across the avenue & sundial
    camera
    {
      location  < -10, 6.2, -8>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   < 50, 8, 45>
    }
  #break
  #case (15)
    // This is looking across the avenue & sundial
    camera
    {
      location  < -25, 6.2, -23>
      direction 2.0*z
      up        y
      right     4/3*x
      look_at   < 50, 8, 45>
    }
  #break
  #case (16)
    // This is looking across the avenue & sundial
    // Widescreen ratio, so make sure you adjust the image size
    // acordingly width = 2.35xheight (I use 470 x 200)
    camera
    {
      location  < -5, 6.2, -23>
      direction 2.0*z
      up        y
      right     <2.35,0,0>
      look_at   < 14, 8, 45>
    }
  #break
  #case (17)
    // This is looking along the avenue towards the rear of the house
    // Widescreen ratio
    camera
    {
      location  < 0, 6.0, -300>
      direction 2.0*z
      up        y
      right     <2.35,0,0>
      look_at   < 0, 8, 40>
    }
  #break
#end

// **************************************************************************
// The lightsource
// Define the sun, a long way away
// create a regular point light source
light_source
{
  0*x
  color red 1.0  green 1.0  blue 1.0
  translate <-20000, 5000, -15000>
}

// **************************************************************************
// The sky
#include "Sky.inc"

// **************************************************************************
// Include the Sundial which is stored in a separate file for reuse
#include "Sundial.inc"

object {
  Object_Sundial
}

// **************************************************************************
// Include the Garden which is stored in a separate file for reuse
#include "Gardens.inc"

// **************************************************************************
// Include the Steps which is stored in a separate file for reuse
#include "Steps.inc"

// **************************************************************************
// Include the house which is stored in a separate file for reuse
#include "House.inc"
