#include "Colors.inc"
#include "Textures.inc"

#declare Glas_Finish=
  finish
   {Shiny
    ambient 0.2
    diffuse 0.2
    reflection 0.2
    refraction 0.9
    ior 1.5
    caustics 0.01
   }

#declare fltr=1

#declare onderglas=
texture
{
  pigment {rgb <1 1 1> filter fltr}
  normal{
     quilted 0.7
     control0 0 control1 1
     scale 0.08
  }
  finish {Glas_Finish}
}

#declare bovenglas=
texture
{
  pigment {rgb <1 1 1> filter fltr}
  finish {Glas_Finish}
}

#declare Glas_Texture=
texture
{
  gradient y
  texture_map
  {
    [0.5 onderglas]
    [0.5 bovenglas]
  }
}



#declare Glas =
object
{
 merge
 {
        difference
        {
           cylinder {<0 1 0> <0 80 0> ,30}
           cylinder {<0 8 0> <0 81 0> ,29}
        }
        object {torus { 29.5, .5 } scale <1, 0.6, 1> translate < 0, 80, 0 >} //Top-rim
        object {torus { 29.5, .5 } translate < 0, 1, 0 >}
 }
 texture { Glas_Texture scale 81}
}


#declare Whisky_Finish=
  finish
   {Shiny
    ambient 0.3
    diffuse 0.8
    reflection 0.2
    refraction 0.9
    ior 1.9
    caustics 0.01
   }


#declare Whisky =
object
{
 cylinder {<0 8.001 0> <0 25 0> ,28.9999}
 texture {pigment {rgb <0.8 0.7 0.2> filter 0.9} finish {Whisky_Finish}}
}

#declare WhiskyGlas =
object
{
  merge
  {
    object {Glas}
    object {Whisky}
  }
}


