#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

camera {
  location <-8, -25, 15>
  sky <0,0,1>
  direction <0,0,1.5>
  right <0, 1.33, 0>
  look_at <4, 0, 3>
 }

light_source {<-20,-10,20> color rgb <0.8,0.7,0.4>
  spotlight
  point_at <0,0,4.0>
  radius 10
  falloff 20
  tightness 0.5}


plane {z, 0 texture {Grnt19 scale 2.5 
                     finish {ambient 0 reflection 0.1}}}

#declare Size = 0.03
#declare Pos = 4.5
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10
sphere {<0,0,Pos> Size pigment {color Brown}}
#declare Pos = Pos - Size*3 - (4.5 - Pos)/10

#declare SColumn =
lathe 
   {cubic_spline
    10,
    <0.4, 0.0>,
    <0.4, 0.1>,
    <0.4, 0.5>,
    <0.2, 1.0>,
    <0.35, 1.4>,
    <0.35, 1.6>,
    <0.2, 2>,
    <0.4, 2.5>,
    <0.4, 3.0>
    <0.4, 3.0>
rotate x*90
scale <1,1,3>
}

#declare GColumn =
lathe 
   {cubic_spline
    10,
    <0.8, 0.0>,
    <0.8, 0.1>,
    <0.8, 0.5>,
    <0.4, 1.0>,
    <0.1, 1.3>,
    <0.1, 1.7>,
    <0.4, 2>,
    <0.8, 2.5>,
    <0.8, 3.0>
    <0.8, 3.0>
rotate x*90
scale <2.5,2.5,3>
}

#declare SColumn1 =
lathe 
   {cubic_spline
    6,
    <0.75, 0.0>,
    <0.75, 0.1>,
    <0.75, 0.5>,
    <0.3, 0.7>,
    <0.0, 1.0>,
    <0.0, 1.0>
rotate x*90
scale <2.5,2.5,3>
}

#declare SColumn2 =
lathe 
   {cubic_spline
    6,
    <0.0, 1.4>,
    <0.0, 1.4>,
    <0.1, 1.7>,
    <0.35, 2>,
    <0.0, 1.7>,
    <0.0, 1.7>
rotate x*90
scale <2.5,2.5,3>
}

#declare Tex1 = texture {DMFDarkOak finish {ambient 0.1} rotate x*10}


#declare Top = union {
  torus {1, 0.1 rotate x*90}
  cylinder {<0,0,-0.1> <0,0,0>, 1}
  cylinder {<0,0,0> <0,0,0.1>, 1.1}
  texture {Tex1 rotate x*20}
scale <3.2, 3.2, 2>
}

object {Top translate z*9}
object {Top scale <1,1,-1> translate z*0.1}


object {SColumn translate < 2, 2,0> texture {Tex1}}
object {SColumn translate < 2,-2,0> texture {Tex1}}
object {SColumn translate <-2,-2,0> texture {Tex1}}  
object {SColumn translate <-2, 2,0> texture {Tex1}}

object {GColumn texture {Glass3 finish {ior 1.00}}}

#declare TSand = texture {pigment {Brown} finish {crand 0.5 ambient 0.1}}

object {SColumn1 texture {TSand}}
object {SColumn2 texture {TSand}}


#declare Textur =
texture {
   pigment {colour Clear}
   halo {
      linear
      max_value 1.0
      spherical_mapping
      emitting
      turbulence 0.3
      colour_map {
         [0.0,1.0 color rgbt <0.6,0.0,0.0,1.0>
                  color rgbt <1.0,1.0,0.0,0.0>]
      }
      samples 10
   }
}


#declare Flame =
lathe 
   {cubic_spline
    5,
    <0.0, 1.4>,
    <0.1, 1.7>,
    <0.35, 2>,
    <0.0, 3>,
    <0.0, 3>
  rotate x*90 
  hollow
  texture {Textur scale <0.3, 0.3, 1> translate z*2}
scale 1.5
translate z*-1.3
}

declare Candle = union {
object {Flame scale 3 translate z*-1.01 no_shadow}
light_source {<0, 0, 8> color rgb <0.6, 0.6, 0.4>}
light_source {<1, 1, 8> color rgb <0.3, 0.25, 0.2>}
light_source {<-1, -0.5, 8> color rgb <0.3, 0.25, 0.2>}
light_source {<-1, 1, 8> color rgb <0.3, 0.25, 0.2>}
difference {
  cylinder {<0,0,0> <0,0,1.3> 0.9}
  sphere   {<0,0,1.4> 0.5 scale <1.7,1.7,1>}
  pigment {color Red}
  finish {ambient 0.3}
  normal {bumps 1.0}
  scale 3.01}
}

#declare Halter =
lathe 
   {cubic_spline
    10,
    <0.00, 1.0>,
    <0.50, 1.0>,
    <0.75, 1.3>,
    <0.75, 1.35>,
    <0.40, 0.8>
    <0.35, 0.75>
    <0.35, 0.2>
    <0.40, 0.15>
    <0.9, 0>
    <0.9, 0>
  texture {pigment {DMFDarkOak} finish {ambient 0.3}}
  rotate x*90
  scale 3
}

union {
  object {Candle translate z*3}
  object {Halter scale <2,2,1>}
scale 0.7
translate <20, 5, 0>
}