// A clock
// Square, with rounded corners. Could also be used as a picture frame.
// Uses external files: penc_w.gif, clklog.gif, clpovlog.gif

// By Mario Becroft

#include "colors.inc"
#include "textures.inc"

// Camera
camera {
	location  < 0,0,-300 >
	look_at   < 0,0,0 >
}

// Light Source(s)
light_source { < 97,95,-100 > color White }



// Ground plane
/*
plane { y,0
	pigment { Green }
	finish { brilliance 0.4 }
}
*/

// Some Textures

#declare Mygold = texture {
	pigment { color rgb  < 0.93 , 0.745 , 0.56 > }
	finish {
		reflection 0.5
		ambient 0.0
		diffuse 0.5
		metallic
		//specular 1.5 roughness 0.01
		phong 1.0 phong_size 200
	}
}

#declare Mysilver = texture {
	pigment { color rgb < 0.42 , 0.42 , 0.46 > }
	finish {
		reflection 0.5
		ambient 0.05
		diffuse 0.65
		metallic
		phong 1.0 phong_size 200
	}
}

// Objects

// Wall that clock hangs on
plane {-z,-0.1
	texture {
		pigment {
			image_map { gif "penc_w.gif"
			interpolate 2
			}
		}
		finish { brilliance 0.2 ambient 0.3 }
		scale <1,1.3,1> // Correct aspect ratio for picture
	}
	// Another layer on top, almost clear, to dull the picture a little
	texture {
		pigment { color White filter 0.8 }
		finish { brilliance 0.2 ambient 0.3 }
	}
	scale 60 // Make the whole thing much bigger
}

// White plane to reflect in gold frame of clock
plane {z,-310 pigment { color White } finish { ambient 0.2 }}

// Gold coloured frame. Rounded (torus) corners, cylinder sides. Ranges from
// -11 to +11 on x and y planes, -1 to +1 on z plane.
#declare frame = union {
	cylinder { < -6 , 10 , 0 >,< 6 , 10 , 0 >,1 } //Top
	cylinder { < -6 , -10 , 0 >,< 6 , -10 , 0 >,1 } //Bottom
	cylinder { < -10 , 6 , 0 >,< -10 , -6 , 0 >,1 } //Left
	cylinder { < 10 , 6 , 0 >,< 10 , -6 , 0 >,1 } //Right

	// Now the rounded corners...
	// Top Left Corner
	// Defined at zero then translated
	intersection {
		torus { 4,1 rotate < 90 , 0 , 0 > }
		plane { -y,0 } // Cut off the torus to make an elbow
		plane { x,0 } // Cut off the torus to make an elbow
		translate < -6 , 6 , 0 >
	}
	// Top Right Corner
	intersection {
		torus { 4,1 rotate < 90 , 0 , 0 > }
		plane { -y,0 } // Cut off the torus to make an elbow
		plane { -x,0 } // Cut off the torus to make an elbow
		translate < 6 , 6 , 0 >
	}
	// Bottom Left Corner
	intersection {
		torus { 4,1 rotate < 90 , 0 , 0 > }
		plane { y,0 } // Cut off the torus to make an elbow
		plane { x,0 } // Cut off the torus to make an elbow
		translate < -6 , -6 , 0 >
	}
	// Bottom Right Corner
	intersection {
		torus { 4,1 rotate < 90 , 0 , 0 > }
		plane { y,0 } // Cut off the torus to make an elbow
		plane { -x,0 } // Cut off the torus to make an elbow
		translate < 6 , -6 , 0 >
	}

	texture { Mygold } // Mysilver and Mygold work well. Needs back wall.
	//pigment { color Yellow }
	//finish { ambient 0.3 }
}

#declare majormarkings = union {
	// 12,3,6,9 o'clock markings, 0.8 radius, blue-green colour
	sphere { <0,7,0>,0.8 } //Top 12 o'clock
	sphere { <7,0,0>,0.8 } //Right 3 o'clock
	sphere { <0,-7,0>,0.8 } //Bottom 6 o'clock
	sphere { <-7,0,0>,0.8 } //Left 9 o'clock
	scale <1,1,0.1> // Make them flat
	pigment { color rgb <0,0.25,1> }
	finish { ambient 0.3 }
}

#declare minormarkings = union {
	// 1,2,4,5,7,8,10,11 markings, 0.5 radius, red colour
	sphere { <3.7,6,0>,0.5 } // Top Right
	sphere { <6,3.7,0>,0.5 }
	sphere { <3.7,-6,0>,0.5 } // Bottom Right
	sphere { <6,-3.7,0>,0.5 }
	sphere { <-3.7,-6,0>,0.5 } // Bottom Left
	sphere { <-6,-3.7,0>,0.5 }
	sphere { <-3.7,6,0>,0.5 } // Top Left
	sphere { <-6,3.7,0>,0.5 }
	scale <1,1,0.1> // Make them flat
	pigment { color rgb <1,0.25,0> }
	finish { ambient 0.3 }
}

// Hands. Already translated to about z-0.3. Hour hand just behind minute hand.
// All pointing straight up in the 12 o'clock direction, so rotate on z axis.

#declare handtex = texture { pigment { color Yellow } finish { phong 0.7 phong_size 20 } }

// Hour Hand (Shortest)
#declare hour_hand = union {
	cone { //Top half
		<0,6,0>,0.07
		<0,2.5,0>,0.3
	}
	cone { // Bottom half
		<0,2.5,0>,0.3
		<0,0,0>,0.1
	}
	// sphere { <0,0,0>,0.1 } // Rounds off bottom of hand, not needed but or v. high rez.
	scale <1,1,0.4> // Flatish hands
	translate <0,0,-0.26> // So that they are sitting out in front of the clock backing
	texture { handtex
	pigment { color Green }
	}
}

// Minute Hand (Middle Size)
#declare minute_hand = union {
	cone { //Top half
		<0,7.2,0>,0.07
		<0,3,0>,0.3
	}
	cone { // Bottom half
		<0,3,0>,0.3
		<0,0,0>,0.1
	}
	// sphere { <0,0,0>,0.1 } // Rounds off bottom of hand, not needed but or v. high rez.
	scale <1,1,0.4> // Flatish hands
	translate <0,0,-0.28> // Inbetween hour hand and second hand
	texture { handtex
		pigment { color rgb <0,0.4,1> }
	}
}

// Second Hand (Long - just a thin cylinder, with a wider bit hanging off the back)
#declare second_hand = union {
	cylinder { <0,8,0>,<0,-0.5,0>,0.07 } // Long top of hand
	cylinder { <0,-0.5,0>,<0,-2,0>,0.3 } // Thick bit "hanging over" back
	scale <1,1,0.4> // Flatish hands
	translate <0,0,-0.3> // Frontmost hand.
	texture { handtex
		pigment { color Red }
	}
}

// The little clock logo in the centre bottom sort of area.
#declare logoslab = box { <0,0,0>,<1,1,0>
	pigment {
		image_map { gif "clklog.gif" once filter 0,1
			interpolate 2
		}
	}
	translate <-0.5,-0.5,0> //So that centre is around 0,0,0, so that it scales evenly
	scale <1,0.327,1> //Correct Aspect Ratio
	scale 3.2 // Make the whole thing a little bigger
	translate <0,-4,-0.0001> // Somewhere a little below centre of clock face
}

// The little POV-Ray logo in the centre top sort of area
#declare povlogoslab = box { <0,0,0>,<1,1,0>
	pigment {
		image_map { gif "clpovlog.gif" once filter 0,1
			interpolate 2
		}
	}
	translate <-0.5,-0.5,0> //So that centre is around 0,0,0, so that it scales evenly
	scale <1,0.242,1> //Correct Aspect Ratio
	scale 5.5 // Make the whole thing a little bigger
	translate <0,4,-0.0001> // Somewhere a little below centre of clock face
}

// Declare the entire clock
#declare myclock = union {
	object { frame }

	// Backing
	difference {
		box { < -9 , 9 , 0 >,< 9 , -9 , 1 > } //1 thick so cone can cut out of it
		cone { // Depression in centre of backing (where hands come out)
			<0,0,0.1>,1.5
			<0,0,-0.3>,1.0
			pigment { color Gray90 }
			finish { brilliance 0.2 ambient 0.3 }
		}
		pigment { color Gray85 }
		finish { brilliance 0.2 ambient 0.3 }
	}

	object { logoslab } // The "Clock" text
	object { povlogoslab } // The "POV-Ray" text

	object { majormarkings }
	object { minormarkings }

	// The hands
	object { hour_hand rotate <0,0,-97> } // Just past 3 o'clock
	object { minute_hand rotate <0,0,-46> } // about 8 past
	object { second_hand rotate <0,0,25> } // and about 55 seconds or so
}

// Put down the clock
object { myclock scale 12 }
