// 'Precision'
global_settings { assumed_gamma 2.3 }
#include "w_tex.inc"
#include "w_tools.inc"
#include "w_screw.inc"
#include "w_gears.inc"
#include "w_plates.inc"
#include "w_desk.inc"
#include "w_handle.inc"

#declare Look_st =
camera {
 right      < 1.33, 0, 0 >
 up         < 0, 1, 0 >
 direction  < 0, 0, 1.3 >
    location <2.5, 0.75, -3>
    look_at  <0, -1  , 0> }
#declare Look_dn =
camera {
 right      < 1.33, 0, 0 >
 up         < 0, 1, 0 >
 direction  < 0, 0, 1.2 >
    location <1, 10, -1.5>
    look_at  <1, 0  -1.5> }
#declare Look_lf =
camera {
 right      < 1.33, 0, 0 >
 up         < 0, 1, 0 >
 direction  < 0, 0, 1.2 >
    location <-1.5,3,0.5>
    look_at  < 0, 2  0.5> }

camera { Look_st }

light_source { <2.5,0.5,-0.5>  // <2.5,0.5,-0.5>
  color rgb <0.8,0.8,0.8>
  spotlight
  point_at  <0,-1,-1>
  radius 20
  tightness 40
  falloff 25 }

 light_source { < 3.0,0.75,0 > color rgb <0.5,0.5,0.5> } //< 3.0,0.75,0 >
 light_source { < 0.5,1,-3 > color rgb <0.5,0.5,0.5> }  //< 0.5,1,-3 >

/*
// To position lights
 sphere { <0,0,0> 0.5 translate <2.5,0.5,-0.5> pigment { colour red 1 } }
 sphere { <0,0,0> 0.5 translate < -0.9,2,2 > pigment { colour red 1 } }
 sphere { <0,0,0> 0.5 translate < 0.5,1,-3 > pigment { colour red 1 } }
*/

plane { <0, 1, 0>, 20
  pigment { checker
    pigment { colour rgb <1,1,1>}, pigment {colour rgb <0.94,0.94,0.94>}
        scale <3,1,6> }
  finish  { ambient 0.4 diffuse 0.3  } }
plane { <0, 0, 1>, 1000
  pigment { colour <0,0.2,0> }
  finish  { ambient 0.1 diffuse 0.3  } }


// Watch union
#declare Watch =
union {

 object { W_plates }

// Lid assembly
 object { W_lid rotate z*86 translate <-0.934,1.05,0>} // -1.07,1.05,0
 object { W_hinge1 scale 0.6
        rotate <0,-90,-2> translate <-1.02,-0.01,0> }
 object { W_hinge2
        rotate <0,-90,-2> translate <-1.04,0,0> }

// Elements on Top Plate
 object { Gear1 rotate x*90 translate <0.3,0.02,0.4> }
 object { Gear2 rotate <90,7,0> translate <0.50,0.02,-0.05> }
 object { Gear3 rotate x*90 translate <0.28,-0.07,0.38> }

 object { Gear4 rotate x*90 translate < 0,   -0.025,0> }
 object { Jewel1 scale 0.04 	translate < 0,0.021,0> }

 object { Gear4 scale 0.7 rotate x*90 translate <-0.2,-0.07,0.2> }
 object { Jewel1 scale 0.03 	translate <-0.2,0.021,0.2> }

 object { Gear4 scale 0.7 rotate x*90 translate <-0.50,-0.025, 0.3> }
 object { Jewel1 scale 0.03 	translate <-0.50,0.021,0.3> }

 object { RndPlate scale <0.07,0.07,0.07> translate <-0.62,0.03, 0.2> }
 cylinder { < 0, 0, -1>, < 0, 0, 1>, 1 scale <0.03,0.03,0.5>
	  rotate -y*49 translate <0.5,-0.05,0.48>
	  texture { T_Chrome_2C } }

// Spring Assembly
 object { RndPlate scale <0.2,0.1,0.2> translate <-0.40,0.03,-0.25> }
 cylinder { < 0, 0, -1>, < 0, 0, 1>, 1 scale <0.01,0.01,0.13>
	  translate <-0.40,0.02,-0.45>
	  texture { T_Chrome_2C } }
 object { Spring translate <-0.45,-0.15,-0.20> }  // <-0.40,-0.15,-0.25>
 object { Gear5 rotate x*90 translate <-0.40,-0.1,-0.25> }

// Handle
 object { Handle translate <2.5,-0.15,0> scale 0.5 }


} // end of 'Watch'

 union {
  object { Watch
        rotate <0,0,0>   // was <0,75,10>
        translate <0.85,-0.81,-0.95>  // was <0.83,-0.8,-1>
        scale 0.85 }
  object { W_box  rotate <0,90,0> translate <-0.5,0,0.5> }
       }

#declare PCol = <0.8,0.8,0.1>
object { Pencil
  pigment {
        onion
        colour_map {
        [0.0 0.175 color rgb <0.91,0.76,0.65>
                  color rgb <0.91,0.76,0.65> ]
        [0.175 1.0 color rgb PCol
                  color rgb PCol ] }
        scale <30,2,2> translate <-38.5,0,0> }
   normal { bumps 0.22 scale <2, 0.05, 0.05> }
   scale <0.1,0.075,0.075>
   rotate y*20 translate <1,-1,3.4> }

object { Sheet
         texture { pigment {
	  image_map {
		gif "watdrw.gif"
		map_type 0
                once
		interpolate 2 }
                rotate <90,-80,0> scale <2,1,3>
                translate <0,0,0.25>
		}
         normal { bumps 0.01 scale <0.005, 0.005, 0.005> }
        }
        rotate y*57
        translate <-1,-0.75,-0.75>
        scale <1.5,1.5,3>
 }


#declare PCol = <0.2,0.2,0.4>
object { Pencil
  pigment {
        onion
        colour_map {
        [0.0 0.175 color rgb <0.91,0.76,0.65>
                  color rgb <0.91,0.76,0.65> ]
        [0.175 1.0 color rgb PCol
                  color rgb PCol ] }
        scale <30,2,2> translate <-38.5,0,0> }
   normal { bumps 0.25 scale <2, 0.05, 0.05> }
   scale <0.1,0.075,0.075>
   rotate -y*140 translate <-0.8,-1,3.2> }

#declare PCol = <0.5,0.1,0.1>
object { Pencil
  pigment {
        onion
        colour_map {
        [0.0 0.175 color rgb <0.91,0.76,0.65>
                  color rgb <0.91,0.76,0.65> ]
        [0.175 1.0 color rgb PCol
                  color rgb PCol ] }
        scale <30,2,2> translate <-38.5,0,0> }
   normal { bumps 0.25 scale <2, 0.05, 0.05> }
   scale <0.1,0.075,0.075>
   rotate y*104 translate <-0.8,-1,1.5> }

#declare PCol = <0.1,0.5,0.1>
object { Pencil
  pigment {
        onion
        colour_map {
        [0.0 0.175 color rgb <0.91,0.76,0.65>
                  color rgb <0.91,0.76,0.65> ]
        [0.175 1.0 color rgb PCol
                  color rgb PCol ] }
        scale <30,2,2> translate <-38.5,0,0> }
   normal { bumps 0.25 scale <2, 0.05, 0.05> }
   scale <0.1,0.075,0.075>
   rotate y*100 translate <-1.3,-1,1.5> }

object { W_desk rotate -y*35 scale <2,1,3> translate <-2,-0.625,2> }
