// Desk top
#declare W_deskt =
union {
// Top
box { < 0, -10, -15>, < 10, -1, 6 > }
cylinder { < 0, 0, -15>, < 0, 0, 6>, 0.5
                translate <0,-1.5,0> }
cylinder { < 0, 0, 0>, < 10, 0, 0>, 0.5
                translate <0,-1.5,6> }
sphere {  < 0, -1.5, 6 >, 0.5  }
 }

// Drawer
#declare W_deskd =
union {
 union {
  box { < -2.3, -4, 0>, < -2, -2, 5 > }
  cylinder { < 0, 0, 0>, < 0, 0, 5>, 0.2
                 translate <-2.2,-2,0> }
   }
 union {
box { < -2.1, -4, 4.65>, < 0, -2.2, 4.8 > }
box { < -2.1, -4, 0.2>, < 0, -2.2, 0.35 > }
box { < -2.1, -4, 0.2>, < 0, -3.9, 4.8 > }
 }
 }

// Desk together
#declare W_desk =
union {
 object { W_deskt texture { Woodtex }} // was scale <2,1,1> } }
 object { W_deskd texture { Woodtex }}
  texture { Woodtex } scale 0.5  }

#declare Inlay1 =
 box { < 0.2,  -0.75, 2.55 >, < 2.55, -0.6999, 2.70 >
  texture {
    material_map {
      gif "inlay2.gif"
        texture {
         pigment { colour rgbf <1.0,0.85,0.55, 0.00> }
         finish {
          reflection 0.1
          diffuse 0.38
          brilliance 0.4
          metallic
          specular 1.5
          roughness 0.01    } }
      texture { pigment { colour rgbt <1,1,1,1> } }
             }
    rotate x*90 scale <0.3,1,0.15>  }
 }

#declare Inlay2 =
 box { < 0.05,  -0.75, 2.55 >, < 0.2, -0.6999, 2.70 >
  texture {
    material_map {
      gif "inlay3.gif"
        texture {
         pigment { colour rgbf <1.0,0.85,0.55, 0.00> }
         finish {
          reflection 0.1
          diffuse 0.38
          brilliance 0.4
          metallic
          specular 1.5
          roughness 0.01    } }
      texture { pigment { colour rgbt <1,1,1,1> } }
             }
    rotate x*90 scale <0.15,1,0.15> translate x*0.05 }

 }

// Wooden box case
#declare W_boxb =
union {
 difference {
 box { < 0.0,  -1,    0.0 >, < 2.75, -0.7, 2.75 > }
 box { < 0.25, -0.99, 0.25>, < 2.5, 0, 2.5 > }

  texture { T_Wood24 }
    finish {
       reflection 0.05   // was 0.1
       diffuse 0.5
       specular 0.5
       roughness 0.01    // was 0.01
        ambient 0.2
   } }
 object { Inlay1 }
 object { Inlay1 rotate -y*90  translate <2.75,0,0>}
 object { Inlay1 rotate  y*90  translate <0,0,2.75>}
 object { Inlay1 rotate  y*180 translate <2.75,0,2.75>}
 object { Inlay2 }
 object { Inlay2 translate x*2.5 }
 object { Inlay2 translate -z*2.5 }
 object { Inlay2 translate <2.5,0,-2.5> }
}


#declare Inner =
sphere { <0,0,0>, 1
texture { Silktex } }

// The complete box
#declare W_box =
union {
 object { W_boxb }
// lock hole
 cylinder { < 0, -0.5, 0>, < 0, -0.199, 0>, 0.05
  pigment {
        onion
        colour_map {
        [0.0 color rgbf <1.0,0.85,0.55, 0.00> ]
        [0.4  color rgbf <0,0,0,0> ] }
        scale 0.05 rotate z*90 }
        translate <1.375,-0.5,2.625> }
 object { W_boxb rotate x*90 translate <0,2.055,0.69>} // was <0,2.5,0.75>
// hinge
 cylinder { < 0.75,0,0>, <2.25,0,0>, 0.025
  translate <0,-0.70,-0.025>    // <0,-0.65,-0.025>
  texture { T_Chrome_3B } }

 intersection {
  object { Inner
        scale <2,0.2,2>  //  <1.55,0.35,1.55>
       translate < 1.4,-1,1.45> }
  box { < 0.25, -2, 0.25>, < 2.5, 2, 2.5 > }
               }
 }

// Pencils
#declare PCol = <1,1,0>
#declare Pencil =
difference {
  intersection {
   plane { z, 1 rotate <  0, 0, 0>}
   plane { z, 1 rotate < 72, 0, 0>}
   plane { z, 1 rotate <144, 0, 0>}
   plane { z, 1 rotate <216, 0, 0>}
   plane { z, 1 rotate <288, 0, 0>}
    plane { x, 1 translate <  16,0,0>
        pigment { colour rgb <0.91,0.76,0.65> }}
    plane {-x, 1 translate < -10,0,0> }
                }
  difference {
   box { < -3, -2, -2>, < 2, 2, 2 > }
   cone {x,1,-x,0  scale <3,1.5,1.5> }
                translate <-9.2,0,0> }
}

// Paper
#declare Sheet =
box { < -1.9, -0.001, 0.5>, < 0, 0.001, 3.5 >
        pigment { colour rgb <1,1,1> } }

// Bookcase
#declare Bookcase =
union {
 box { < -5, -5, 0.4>, < 5, 5, 2.5 >
   pigment { colour red 0.35 green 0.16 blue 0.14 } }
        // horizontal
 box { <-5,-5,  -0.5>, < 5,-4.5,2.5 > }
 box { <-5,-1.5,-0.5>, < 5,-1.3,2.5 >  }
 box { <-5, 1.7,-0.5>, < 5, 1.9,2.5 >  }
        // vertical
 box { <-5,  -5,-0.5>, <-4.8,5, 2.5 > }
 box { < 4.8,-5,-0.5>, < 5,  5, 2.5 > }
      pigment { colour red 0.35 green 0.16 blue 0.14 }
}
