// A sort of burr texture for the table
#declare M_WoodSA =
color_map {
    [0.00 0.10 color rgb < 0.80, 0.232, 0.115 >
               color rgb < 0.80, 0.232, 0.115 >]
    [0.10 0.90 color rgb < 0.80, 0.232, 0.115 >
               color rgb < 0.45, 0.115, 0.060 >]
    [0.90 1.0  color rgb < 0.45, 0.115, 0.060 >
               color rgb < 0.45, 0.115, 0.060 >] }
#declare M_WoodSB =
color_map {
    [0.00 0.10 color rgbf < 0.70, 0.232, 0.115, 0.5 >
               color rgbf < 0.70, 0.232, 0.115, 0.7 >]
    [0.10 0.15 color rgbf < 0.70, 0.232, 0.115, 0.7 >
               color rgbf < 0.35, 0.115, 0.060, 0.9 >]
    [0.15 0.20 color rgbf < 0.70, 0.232, 0.115, 0.9 >
               color rgbf < 0.35, 0.115, 0.060, 0.7 >]
    [0.20 1.0  color rgbf < 0.35, 0.115, 0.060, 0.7 >
               color rgbf < 0.35, 0.115, 0.060, 0.5 >] }
#declare P_WoodGrainSA =
 pigment {
    wood
    turbulence 0.5
    octaves 4
    lambda 3
    scale <4.1,4.1,4.1>   // was <3.01,2.01,3.01>
    rotate <0.125, 0.125, 0> }
#declare P_WoodGrainSB =
 pigment {
    spotted
    turbulence 0.6      // was 0.5
    octaves 3           // was 4 - from wavy (1) to jaggy (6)
    lambda 3            // was 3 - how 'swirly' (1) straightens octaves
    rotate <0.125, 0.125, 0> }
#declare Woodtex =
    texture { pigment { P_WoodGrainSA  color_map { M_WoodSA }}}
    texture { pigment { P_WoodGrainSB  color_map { M_WoodSB }}}


// From woods.inc for the box
#declare M_Wood14A =
 colour_map {
    [0.00 0.10 color rgb < 0.80, 0.232, 0.115 >
               color rgb < 0.80, 0.232, 0.115 >]
    [0.10 0.90 color rgb < 0.80, 0.232, 0.115 >
               color rgb < 0.45, 0.115, 0.060 >]
    [0.90 1.0  color rgb < 0.45, 0.115, 0.060 >
               color rgb < 0.45, 0.115, 0.060 >] }
#declare M_Wood14B =
 colour_map {
    [0.00 0.10 color rgbf < 0.70, 0.232, 0.115, 0.5 >
               color rgbf < 0.70, 0.232, 0.115, 0.7 >]
    [0.10 0.15 color rgbf < 0.70, 0.232, 0.115, 0.7 >
               color rgbf < 0.35, 0.115, 0.060, 0.9 >]
    [0.15 0.20 color rgbf < 0.70, 0.232, 0.115, 0.9 >
               color rgbf < 0.35, 0.115, 0.060, 0.7 >]
    [0.20 1.0  color rgbf < 0.35, 0.115, 0.060, 0.7 >
               color rgbf < 0.35, 0.115, 0.060, 0.5 >] }
#declare P_WoodGrain1A =
 pigment {
    wood
    turbulence 0.1  // was 0.04
    octaves 3
    scale <0.05, .05, 1> }
#declare P_WoodGrain1B =
 pigment {
    wood
    turbulence <0.1, 0.5, 1>
    octaves 5
    lambda 3.25
    scale <0.15, .5, 1>
    rotate <5, 10, 5>
    translate -x*2 }
#declare T_Wood24 =
    texture {  pigment{ P_WoodGrain1A color_map { M_Wood14A }}}
    texture {  pigment{ P_WoodGrain1B color_map { M_Wood14B }}}

// Based on metals.inc, mostly for screws & hinges
#declare P_Chrome3 = color rgb <0.60, 0.60, 0.60>
#declare F_MetalB  =
finish {
    ambient 0.30
    brilliance 3
    diffuse 0.4
    metallic
    specular 0.70
    roughness 0.02
    reflection 0.25 }
#declare T_Chrome_3B =
texture { pigment { P_Chrome3 } finish { F_MetalB  } }

// Based on metals.inc mainly for the gear wheels
#declare P_Chrome2 = color rgb <0.69,0.71,0.73>  // <0.39, 0.41, 0.43>
#declare F_MetalC  =
finish {
    ambient 0.25
    brilliance 6   // was 4
    diffuse 0.5
    specular 0.995  // was 0.8
    roughness 0.001 // was 0.01
    reflection 0.6
    metallic }
#declare T_Chrome_2C = texture { pigment { P_Chrome2 } finish { F_MetalC  } }

// From colors.inc
#declare Scarlet = color red 0.55 green 0.09 blue 0.09
#declare Clear = rgbf 1
#declare Black = rgb 0


// Gold textures
// For the outer case
#declare Outertex =
texture {
  pigment
    { colour rgbf <1.0,0.85,0.55, 0.00> }
    finish {
       reflection 0.1   // was 0.1
       diffuse 0.38     // 0.38
       brilliance 0.4   // 0.4
       metallic
       specular 0.99     // 1.5
       roughness 0.01    // was 0.01
  } }

// For the watch back
#declare Lidtex =
texture {
  pigment
    { colour rgbf <1.0,0.85,0.55, 0.00> }
    finish {
       reflection 0.1   // was 0.2
       diffuse 0.38
       brilliance 0.4
       metallic
       specular 0.99
       roughness 0.01    } // was 0.01
  }

// For the inner wheel colour
#declare Washrtex =
texture  {
    pigment { color rgb  <0.96,0.745,0.54> }
    finish {
       reflection 0.2   // was 0.5
       diffuse 0.38
       brilliance 0.5
       specular 1
       roughness 0.01    // was 0.01
       metallic
} }

// For the other watch plates
#declare Innertex =
texture  {
  pigment { color rgb  <1.0,0.85,0.55> }
    finish {
       reflection 0.2   // was 0.5
       diffuse 0.38       // was 0.5
       brilliance 0.5
       metallic
       specular 1    // was 1.1
       roughness 0.03    // was 0.03
} }

// For the top engraved plate
#declare Toptex =
  texture {
   pigment { color rgb  <1.0,0.85,0.55> }
// was  pigment { color rgb  <0.90 0.70 0.50> }
    finish {
       reflection 0.1   // was 0.5
       diffuse 0.38       // was 0.5
       brilliance 0.5
       metallic on
       specular 1     // was 1.1
       roughness 0.02 }   // was 0.03
   normal {
	bump_map {
	gif "engrave5.gif"
	map_type 0
	interpolate 2
	bump_size -0.75 }
	rotate x*90
	scale 0.25 }
}

// For the spring
#declare Sprtex =
texture {
    pigment {
    wood
    color_map {
        [0,    0.3 color Clear color Clear ]
        [0.30, 0.36 color Black color Black ]
        [0.36, 0.46 color Clear color Clear ]
        [0.46, 0.52 color Black color Black ]
        [0.52, 0.62 color Clear color Clear ]
        [0.62  0.68 color Black color Black ]
        [0.68, 0.78 color Clear color Clear ]
        [0.78, 0.84 color Black color Black ]
        [0.84, 0.94 color Clear color Clear ]
        [0.94, 1    color Black color Black ]
   } }
    finish { ambient 0.8 } }

// Silk for box interior
#declare Silktex =
texture {
  pigment { colour Scarlet }
    normal {
        bumps -0.1
        scale <1, 0.001, 0.001>    }
  finish  {
    ambient 0.5 	//was 0.25
    brilliance 1        //was 4
    diffuse 0.2         //was 0.4
    roughness 0.11      // was 0.01
    specular 0.1
    reflection 0.05  }   // was 0.12
}

// Pencil colour
#declare PCol = <0.1,0.1,0.1>

/*
// Temporary redefinition for testing
#declare Toptex =
texture { pigment { colour rgb <0.6,0.6,0.6> } }
#declare Innertex =
texture { pigment { colour rgb <0.55,0.55,0.55> }}
#declare Washrtex =
texture { pigment { colour rgb <0.8,0.8,0.8> }}
#declare Lidtex =
texture { pigment { colour rgb <0.65,0.65,0.65> }}
#declare Outertex =
texture { pigment { colour rgb <0.65,0.65,0.65> }}
*/

