
#declare SC2    =  4.78

#declare R36    =  4.0283
#declare ThTH36 =  5.9866
#declare ThTC36 =  4.0134
#declare D36    =  4.0228
#declare TD36   = (R36 + TH - SC2)
#declare Rot36  = (ThTC36 + ThTH36)

#declare R12    =  1.2141
#declare ThTH12 = 20.2231
#declare ThTC12 =  9.7769
#declare D12    =  1.1952
#declare TD12   = (R12 + TH - SC2)
#declare Rot12  = (ThTC12 + ThTH12)

#declare Bound_Box36 =
box
   {
   <-One,    D36, -One>
   < One, R36+TH,  One>
   }

#declare Bound_Box12 =
box
   {
   <-One,    D12, -One>
   < One, R12+TH,  One>
   }

#declare Tooth36 =
difference
   {
   box
      {
      <-sqrt(2)/2, -sqrt(2)/2, -1> <sqrt(2)/2, sqrt(2)/2, 1> rotate z*45
      scale <1, SC2, 1-.01>
      translate <0, TD36+TC, 0>
      }
   object { Bound_Box36 inverse }
   bounded_by { Bound_Box36 }
   }

#declare Tooth12 =
difference
   {
   box
      {
      <-sqrt(2)/2, -sqrt(2)/2, -1> <sqrt(2)/2, sqrt(2)/2, 1> rotate z*45
      scale <1, SC2, 1-.01>
      translate <0, TD12+TC, 0>
      }
   object { Bound_Box12 inverse }
   bounded_by { Bound_Box12 }
   }

#declare Teeth36 =
difference
   {
   union
      {
      #declare Count = 0
      #while ( Count < 36 )
         object { Tooth36 rotate z*Count*Rot36 }
      #declare Count = Count + 1
      #end
      }
   cylinder { <0, 0, -One> <0, 0, One> R36 }
   bounded_by { cylinder { <0, 0, -One> <0, 0, One> R36+TH } }
   }

#declare Teeth12 =
difference
   {
   union
      {
      #declare Count = 0
      #while ( Count < 12 )
         object { Tooth12 rotate z*Count*Rot12 }
      #declare Count = Count + 1
      #end
      }
   cylinder { <0, 0, -One> <0, 0, One> R12 }
   bounded_by { cylinder { <0, 0, -One> <0, 0, One> R12+TH } }
   }

#declare Gear36 =
union
   {
   union
      {
      object { Teeth36 }
      difference
         {
         cylinder { <0, 0, -1> <0, 0, 1> R36 }
         cylinder { <0, 0, -One> <0, 0, One> 4*R36/5 }
         }
      bounded_by { cylinder { <0, 0, -One> <0, 0, One> R36+TH } }
      }
   object { Gear_Big_Center scale <R36, R36, 1> }
//   pigment { quick_color Green }
   }

#declare Gear12 =
union
   {
   union
      {
      object { Teeth12 }
      difference
         {
         cylinder { <0, 0, -1> <0, 0, 1> R12 }
         cylinder { <0, 0, -One> <0, 0, One> 4*R12/5 }
         }
      bounded_by { cylinder { <0, 0, -One> <0, 0, One> R12+TH } }
      }
   object { Gear_Big_Center scale <R12, R12, 1> }
//   pigment { quick_color White }
   }
