#include "colors.inc"
#include "textures.inc"
#include "gnomon.inc"
#include "hills.inc"

// *********** Camera ************
/*
camera {
	location  < 0.5,200,0.5 >
	look_at   < 0,40,0 >
}
*/
// *********** Camera ************

camera {
	location  < -70,90,-110 >
	look_at   < 0,40,0 >
}

// *********** Light Source(s) ************
light_source { < 300,300,-200 > color White }
light_source { < -80,0,-60 > color Gray20 }

background { color SkyBlue }

/**** Ground plane ****/

plane { y,-50
	//pigment { White }
	texture {
		pigment { color rgb<0.18,0.7,0.18> }

		normal { ripples 1.0
			frequency 2000.0
			scale 280000.0
		}

		finish {
			brilliance 0.5
			//brilliance 0.05
			ambient 0.3
			diffuse 0.7
			crand 0.05
		}
	}
}

/**** Pillar which sundial is on ****/

// Pillar extends from y-50 to y+50
#declare pilflute = object {
	cylinder { <-42.2,35,0>,<-42.2,-35,0>,5 }
}

#declare pilround = union {	// Use on top and bottom of pil.top to round off
	sphere { <50,0,50> , 1 }	// Spheres in each corner
	sphere { <50,0,-50> , 1 }
	sphere { <-50,0,50> , 1 }
	sphere { <-50,0,-50> , 1 }
	cylinder { <-50,0,50>,<50,0,50> , 1 }	// Cylinders joining them all up
	cylinder { <50,0,50>,<50,0,-50> , 1}
	cylinder { <50,0,-50>,<-50,0,-50> , 1 }
	cylinder { <-50,0,-50>,<-50,0,50> , 1 }
}

#declare pillar = union {	// Just a plain old pillar

	difference {
		cylinder { < 0.0,-40,0.0 >,< 0.0,40,0.0 >,40 }	// Column
		object { pilflute rotate <0,18,0> }
		object { pilflute rotate <0,0,0> }
		object { pilflute rotate <0,-18,0> }
		object { pilflute rotate <0,-36,0> }
		object { pilflute rotate <0,-54,0> }
		object { pilflute rotate <0,-72,0> }
		object { pilflute rotate <0,-90,0> }
		object { pilflute rotate <0,-108,0> }
		object { pilflute rotate <0,-126,0> }
		object { pilflute rotate <0,-144,0> }
		object { pilflute rotate <0,-162,0> }
	}

	difference {
		box { < -50,40,-50 >,< 50,50,50 > }	// Top box
		torus { 48 , 1.1 translate <0,50.5,0> }
	}

	// Now to round off the top box
	// two boxes, to make it wider out the sides
	box { <-51,41,-50>,<51,49,50> }	// Sticks out left and right
	box { <-50,41,-51>,<50,49,51> }	// Sticks out +z and -z
	object { pilround translate <0,49,0> }
	object { pilround translate <0,41,0> }
	cylinder { <50,41,50>,<50,49,50>,1 }	// Round off vertical corners
	cylinder { <-50,41,50>,<-50,49,50>,1 }
	cylinder { <50,41,-50>,<50,49,-50>,1 }
	cylinder { <-50,41,-50>,<-50,49,-50>,1 }

	box { < -50,-50,-50 >,< 50,-40,50 > }	// Bottom box
}

#declare PaleStone = pigment {
	marble
	turbulence 1.4
	color_map {
		[0.0 0.2 color rgb<0.95,0.95,0.95> color White]
		[0.2 0.6 color White color White]
		[0.6 0.8 color White color rgb<0.9,0.9,0.9>]
		[0.8 1.0 color rgb<0.95,0.95,0.95> color rgb<0.85,0.85,0.85>]
	}
	scale 16.0
}

object { pillar

	pigment { PaleStone }	// Defined just above

	finish {
		ambient 0.3
		diffuse 0.72
		//reflection 0.1	// Reflection looks bad for this situation
	}
}

/**** Clockface plate and gnomon ****/

// Plate with numerals on it
#declare plate = difference {
	cylinder { <0,50.5,0>,<0,45,0>,47 }
	torus { 47 , 0.6 translate <0,50.5,0> }	// Round groove around edge of plate
}

// Quick version of the above plate
#declare qplate = object {
	cylinder { <0,50.5,0>,<0,45,0>,47 }
}

union {

	object { plate }

	height_field { tga "sdface.tga" water_level 0.1
		//smooth	// With the big height_field, smoothing pushes RAM to the limit
		translate <-0.5,0,-0.5>	// Put it centred around xz0,0
		rotate <0,90,0>	// So that 12oclock is at top not side!
		scale <89,1.2,89>	// Make it the size of the plate (almost)
		translate <0,49.8,0>
	}

	object { gnomon
		translate <0,51.2,0>	// Put base at y=0
		scale 0.6	// Scale
		scale <1,1,0.3>	// Make thinner
		translate <3,52,0>	// Put on top of plate
	}

	// Flange under the gnomon, which is "screwed" into the plate
	difference {
		box { <-33,51,4>,<17,50,-4> } // The flange
		// Cut out the rounded bits in edges
		cylinder { <-33,51,4>,<17,51,4>,0.55 }
		cylinder { <-33,51,-4>,<17,51,-4>,0.55 }
		cylinder { <-33,51,4>,<-33,51,-4>,0.55 }
		cylinder { <17,51,4>,<17,51,-4>,0.55 }
		translate <3,1.1,0>	// Move it above top of height field
	}

	texture {
		//pigment { color rgb<0.93,0.745,0.56> }
		pigment { color rgb<0.99,0.88,0.47> }
		finish {
			ambient 0.3
			diffuse 0.7
			reflection 0.05
			metallic
			phong 1.0 phong_size 120
			crand 0.08
		}
	}
}

/**** Snow-Capped Mountains in Distance ****/

#declare hgreen = color rgb<0.18,0.7,0.18>

object { hills
	translate <0,17.92,0>	// Put base at y=0
	pigment {
		gradient y
		color_map {
			//[0.0 0.25 color rgb<0.18,0.7,0.18> color ForestGreen]
			//[0.25 0.45 color ForestGreen color ForestGreen]
			[0.00 0.45 color rgb<0.11,0.41,0.11> color hgreen]
			[0.45 0.9 color hgreen color rgb<1.5,1.5,1.5>]
			[0.9 1.0 color rgb<1.5,1.5,1.5> color rgb<1.5,1.5,1.5>]
		}
		scale <1,16,1>
		turbulence 0.1
	}
	finish { ambient 0.3 }
	scale <50,24,38>	// Scale
	scale 1.8	// Scale uniformally bigger
	translate <0,0,5000>	// Put in distance
	rotate <0,20,0>	// Rotate into view
	translate <0,-50,0>	// Put down to ground level
}
