// Persistence of Vision Ray Tracer Scene Description File
// File: tardis.pov
// Vers: 3
// Desc: TARDIS object
// Date: 07 Jun 96
// Auth: Tim Redman

#debug "\nIncluding TARDIS.POV..."

#declare Tardis_Wood =
pigment {
    wood
    turbulence 0.2
    scale .01
    color_map {
        [0.0, 0.8 color rgb <0,0,1>
                  color rgb <0,0,1>]
        [0.8, 1.0 color rgb <0,0,.8>
                  color rgb <0,0,.6>]
    }
}

#declare beacon =
object {
   union {
      cylinder { <0,0,0>, <0,.25,0>, 1 pigment { Gray20 } }
      union {
         cylinder { <0,.25,0>, <0,1,0>, .5 texture { Glass } hollow }
         sphere { < 0,1,0 >, .5 texture { Glass } hollow }
      }
      sphere { < 0,1,0 >, 1
         pigment { color rgbt <1, 1, 1, 1> }
         halo {
            emitting
            spherical_mapping
            linear
            color_map { [ 0 color rgbt <1, 1, 1, 1> ] [ 1 color rgbt <.5, .5, .5, -1> ] }
            samples 10
         }
         hollow
         scale 2
      }
      sphere { < 0,.5,0 >, 1
         pigment { color rgbt <1, 1, 1, 1> }
         halo {
            emitting
            spherical_mapping
            linear
            color_map { [ 0 color rgbt <1, 1, 1, 1> ] [ 1 color rgbt <.5, .5, .5, -1> ] }
            samples 10
         }
         hollow
         scale 2
      }
      torus { 1,.05 pigment { Gray20 } translate <0,.5,0> }
      torus { 1,.05 pigment { Gray20 } translate <0,1,0> }
      cylinder { <-1,0,0>, <-1,1,0>, .05 pigment { Gray20 } }
      cylinder { <1,0,0>, <1,1,0>, .05 pigment { Gray20 } }
      cylinder { <.5,0,.866>, <.5,1,.866>, .05 pigment { Gray20 } }
      cylinder { <-.5,0,.866>, <-.5,1,.866>, .05 pigment { Gray20 } }
      cylinder { <.5,0,-.866>, <.5,1,-.866>, .05 pigment { Gray20 } }
      cylinder { <-.5,0,-.866>, <-.5,1,-.866>, .05 pigment { Gray20 } }
      torus { 1,.05 pigment { Gray20 } rotate <90,0,0> translate <0,1,0>
         clipped_by { plane { -y,-1 } } }
      torus { 1,.05 pigment { Gray20 } rotate <90,60,0> translate <0,1,0>
         clipped_by { plane { -y,-1 } } }
      torus { 1,.05 pigment { Gray20 } rotate <90,-60,0> translate <0,1,0>
         clipped_by { plane { -y,-1 } } }
   }
}

#declare tardis =
object {
   union {
      difference {
         // main body
         box { <-5,-8,-5>, <5,9,5> pigment { Tardis_Wood } }
         // doorways
         box { <-4,-8,-6>, <4,6.5,-4.5> pigment { Tardis_Wood } }
         box { <-4,-8,4.5>, <4,6.5,6> pigment { Tardis_Wood } }
         box { <-6,-8,-4>, <-4.5,6.5,4> pigment { Tardis_Wood } }
         box { <4.5,-8,-4>, <6,6.5,4> pigment { Tardis_Wood } }
         // above sign
         box { <-4,8,-6>, <4,10,-4.5> pigment { Tardis_Wood } }
         box { <-4,8,4.5>, <4,10,6> pigment { Tardis_Wood } }
         box { <-6,8,-4>, <-4.5,10,4> pigment { Tardis_Wood } }
         box { <4.5,8,-4>, <6,10,4> pigment { Tardis_Wood } }
         // front panels
         box { <-3.75,-.5,-5>, <-.25,2.625,-4.25> pigment { Gray20 } }
         box { <-3.75,-4.125,-5>, <-.25,-1,-4.25> pigment { Tardis_Wood } }
         box { <-3.75,-7.75,-5>, <-.25,-4.625,-4.25> pigment { Tardis_Wood } }
         box { <.25,-.5,-5>, <3.75,2.625,-4.25> pigment { Tardis_Wood } }
         box { <.25,-4.125,-5>, <3.75,-1,-4.25> pigment { Tardis_Wood } }
         box { <.25,-7.75,-5>, <3.75,-4.625,-4.25> pigment { Tardis_Wood } }
         // front windows
         box { <-3.5,4.8125,-5>, <-2.667,6.25,-3> pigment { Tardis_Wood } }
         box { <-2.417,4.8125,-5>, <-1.584,6.25,-3> pigment { Tardis_Wood } }
         box { <-1.334,4.8125,-5>, <-.5,6.25,-3> pigment { Tardis_Wood } }
         box { <-3.5,3.125,-5>, <-2.667,4.5625,-3> pigment { Tardis_Wood } }
         box { <-2.417,3.125,-5>, <-1.584,4.5625,-3> pigment { Tardis_Wood } }
         box { <-1.334,3.125,-5>, <-.5,4.5625,-3> pigment { Tardis_Wood } }
         box { <2.667,4.8125,-5>, <3.5,6.25,-3> pigment { Tardis_Wood } }
         box { <1.584,4.8125,-5>, <2.417,6.25,-3> pigment { Tardis_Wood } }
         box { <.5,4.8125,-5>, <1.334,6.25,-3> pigment { Tardis_Wood } }
         box { <2.667,3.125,-5>, <3.5,4.5625,-3> pigment { Tardis_Wood } }
         box { <1.584,3.125,-5>, <2.417,4.5625,-3> pigment { Tardis_Wood } }
         box { <.5,3.125,-5>, <1.334,4.5625,-3> pigment { Tardis_Wood } }
         // side panels
         box { <-5,-.5,-3.75>, <-4.25,2.625,-.25> pigment { Tardis_Wood } }
         box { <-5,-4.125,-3.75>, <-4.25,-1,-.25> pigment { Tardis_Wood } }
         box { <-5,-7.75,-3.75>, <-4.25,-4.625,-.25> pigment { Tardis_Wood } }
         box { <-5,-.5,.25>, <-4.25,2.625,3.75> pigment { Tardis_Wood } }
         box { <-5,-4.125,.25>, <-4.25,-1,3.75> pigment { Tardis_Wood } }
         box { <-5,-7.75,.25>, <-4.25,-4.625,3.75> pigment { Tardis_Wood } }
         // side windows
         box { <-5,4.8125,-3.5>, <-3,6.25,-2.667> pigment { Tardis_Wood } }
         box { <-5,4.8125,-2.417>, <-3,6.25,-1.584> pigment { Tardis_Wood } }
         box { <-5,4.8125,-1.334>, <-3,6.25,-.5> pigment { Tardis_Wood } }
         box { <-5,3.125,-3.5>, <-3,4.5625,-2.667> pigment { Tardis_Wood } }
         box { <-5,3.125,-2.417>, <-3,4.5625,-1.584> pigment { Tardis_Wood } }
         box { <-5,3.125,-1.334>, <-3,4.5625,-.5> pigment { Tardis_Wood } }
         box { <-5,4.8125,2.667>, <-3,6.25,3.5> pigment { Tardis_Wood } }
         box { <-5,4.8125,1.584>, <-3,6.25,2.417> pigment { Tardis_Wood } }
         box { <-5,4.8125,.5>, <-3,6.25,1.334> pigment { Tardis_Wood } }
         box { <-5,3.125,2.667>, <-3,4.5625,3.5> pigment { Tardis_Wood } }
         box { <-5,3.125,1.584>, <-3,4.5625,2.417> pigment { Tardis_Wood } }
         box { <-5,3.125,.5>, <-3,4.5625,1.334> pigment { Tardis_Wood } }
         // back panels
         box { <-3.75,-.5,4.25>, <-.25,2.625,5> pigment { Tardis_Wood } }
         box { <-3.75,-4.125,4.25>, <-.25,-1,5> pigment { Tardis_Wood } }
         box { <-3.75,-7.75,4.25>, <-.25,-4.625,5> pigment { Tardis_Wood } }
         box { <.25,-.5,4.25>, <3.75,2.625,5> pigment { Tardis_Wood } }
         box { <.25,-4.125,4.25>, <3.75,-1,5> pigment { Tardis_Wood } }
         box { <.25,-7.75,4.25>, <3.75,-4.625,5> pigment { Tardis_Wood } }
         // back windows
         box { <-3.5,4.8125,3>, <-2.667,6.25,5> pigment { Tardis_Wood } }
         box { <-2.417,4.8125,3>, <-1.584,6.25,5> pigment { Tardis_Wood } }
         box { <-1.334,4.8125,3>, <-.5,6.25,5> pigment { Tardis_Wood } }
         box { <-3.5,3.125,3>, <-2.667,4.5625,5> pigment { Tardis_Wood } }
         box { <-2.417,3.125,3>, <-1.584,4.5625,5> pigment { Tardis_Wood } }
         box { <-1.334,3.125,3>, <-.5,4.5625,5> pigment { Tardis_Wood } }
         box { <2.667,4.8125,3>, <3.5,6.25,5> pigment { Tardis_Wood } }
         box { <1.584,4.8125,3>, <2.417,6.25,5> pigment { Tardis_Wood } }
         box { <.5,4.8125,3>, <1.334,6.25,5> pigment { Tardis_Wood } }
         box { <2.667,3.125,3>, <3.5,4.5625,5> pigment { Tardis_Wood } }
         box { <1.584,3.125,3>, <2.417,4.5625,5> pigment { Tardis_Wood } }
         box { <.5,3.125,3>, <1.334,4.5625,5> pigment { Tardis_Wood } }
         // side panels
         box { <4.25,-.5,-3.75>, <5,2.625,-.25> pigment { Tardis_Wood } }
         box { <4.25,-4.125,-3.75>, <5,-1,-.25> pigment { Tardis_Wood } }
         box { <4.25,-7.75,-3.75>, <5,-4.625,-.25> pigment { Tardis_Wood } }
         box { <4.25,-.5,.25>, <5,2.625,3.75> pigment { Tardis_Wood } }
         box { <4.25,-4.125,.25>, <5,-1,3.75> pigment { Tardis_Wood } }
         box { <4.25,-7.75,.25>, <5,-4.625,3.75> pigment { Tardis_Wood } }
         // side windows
         box { <3,4.8125,-3.5>, <5,6.25,-2.667> pigment { Tardis_Wood } }
         box { <3,4.8125,-2.417>, <5,6.25,-1.584> pigment { Tardis_Wood } }
         box { <3,4.8125,-1.334>, <5,6.25,-.5> pigment { Tardis_Wood } }
         box { <3,3.125,-3.5>, <5,4.5625,-2.667> pigment { Tardis_Wood } }
         box { <3,3.125,-2.417>, <5,4.5625,-1.584> pigment { Tardis_Wood } }
         box { <3,3.125,-1.334>, <5,4.5625,-.5> pigment { Tardis_Wood } }
         box { <3,4.8125,2.667>, <5,6.25,3.5> pigment { Tardis_Wood } }
         box { <3,4.8125,1.584>, <5,6.25,2.417> pigment { Tardis_Wood } }
         box { <3,4.8125,.5>, <5,6.25,1.334> pigment { Tardis_Wood } }
         box { <3,3.125,2.667>, <5,4.5625,3.5> pigment { Tardis_Wood } }
         box { <3,3.125,1.584>, <5,4.5625,2.417> pigment { Tardis_Wood } }
         box { <3,3.125,.5>, <5,4.5625,1.334> pigment { Tardis_Wood } }
         // hollow behind windows
         box { <-4,3,-4>, <4,7,4> pigment { Tardis_Wood } }
      }
      box { <-5.5,-8.5,-5.5>, <5.5,-8,5.5> pigment { Tardis_Wood } }
      box { <-4,9,-4>, <4,9.5,4> pigment { Tardis_Wood } }
      box { <-4,3,-4.25>, <4,7,4.25> pigment { Gray80 } }
      object { beacon translate <0,9.5,0> }
      box { <-4,6.6,-5.01>, <4,7.9,-5.01> pigment { Gray20 } }
      box { <-4,6.6,5.01>, <4,7.9,5.01> pigment { Gray20 } }
      box { <-5.01,6.6,-4>, <-5.01,7.9,4> pigment { Gray20 } }
      box { <5.01,6.6,-4>, <5.01,7.9,4> pigment { Gray20 } }
      text { ttf "c:\windows\fonts\arial.ttf","POLICE",.01,0 pigment { White } scale <.8,.8,1>
         translate <-3.5,7,-5.02> }
      text { ttf "c:\windows\fonts\arial.ttf","POLICE",.01,0 pigment { White } scale <.8,.8,1>
         translate <-3.5,7,-5.02> rotate <0,90,0> }
      text { ttf "c:\windows\fonts\arial.ttf","POLICE",.01,0 pigment { White } scale <.8,.8,1>
         translate <-3.5,7,-5.02> rotate <0,180,0> }
      text { ttf "c:\windows\fonts\arial.ttf","POLICE",.01,0 pigment { White } scale <.8,.8,1>
         translate <-3.5,7,-5.02> rotate <0,270,0> }
      text { ttf "c:\windows\fonts\arial.ttf","BOX",.01,0 pigment { White } scale <.8,.8,1>
         translate <2,7,-5.02> }
      text { ttf "c:\windows\fonts\arial.ttf","BOX",.01,0 pigment { White } scale <.8,.8,1>
         translate <2,7,-5.02> rotate <0,90,0> }
      text { ttf "c:\windows\fonts\arial.ttf","BOX",.01,0 pigment { White } scale <.8,.8,1>
         translate <2,7,-5.02> rotate <0,180,0> }
      text { ttf "c:\windows\fonts\arial.ttf","BOX",.01,0 pigment { White } scale <.8,.8,1>
         translate <2,7,-5.02> rotate <0,270,0> }
      text { ttf "c:\windows\fonts\arial.ttf","PUBLIC",.01,0 pigment { White }
         scale <.3,.3,1> translate <.25,7.3,-5.02> }
      text { ttf "c:\windows\fonts\arial.ttf","CALL",.01,0 pigment { White }
         scale <.3,.3,1> translate <.35,7,-5.02> }
      text { ttf "c:\windows\fonts\arial.ttf","PUBLIC",.01,0 pigment { White }
         scale <.3,.3,1> translate <.25,7.3,-5.02> rotate <0,90,0> }
      text { ttf "c:\windows\fonts\arial.ttf","CALL",.01,0 pigment { White }
         scale <.3,.3,1> translate <.35,7,-5.02> rotate <0,90,0> }
      text { ttf "c:\windows\fonts\arial.ttf","PUBLIC",.01,0 pigment { White }
         scale <.3,.3,1> translate <.25,7.3,-5.02> rotate <0,180,0> }
      text { ttf "c:\windows\fonts\arial.ttf","CALL",.01,0 pigment { White }
         scale <.3,.3,1> translate <.35,7,-5.02> rotate <0,180,0> }
      text { ttf "c:\windows\fonts\arial.ttf","PUBLIC",.01,0 pigment { White }
         scale <.3,.3,1> translate <.25,7.3,-5.02> rotate <0,270,0> }
      text { ttf "c:\windows\fonts\arial.ttf","CALL",.01,0 pigment { White }
         scale <.3,.3,1> translate <.35,7,-5.02> rotate <0,270,0> }
   }
}
