//persistence of Vision Raytracer
// Terry Lyons Sr.
// 06/23/96

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

global_settings
   {
   max_trace_level 14
   }

camera
   {
   location <-22.0, 55.0, 2220.0>
   look_at <10,0,50>
   }

light_source
   {
   <0,0,10>
   color White
   }
  
#declare Count = 1
#declare Mn = 1
#declare Hr = 1
    

#while ( Count < 505 )
   #declare Myobject = union
      {
         torus
            {
            40,5
            rotate x*90
            texture { Lightening1 scale 10 }
            }
          cone
            {
            <0,0,0>,40,< 800,0,0>0
            pigment { color Clear }
            hollow scale <1,1,.125>
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*1
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*2
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*3
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*4
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*5
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*6
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*7
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*8
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*9
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*10
            }
          sphere
            {
            <0,0,0>,1
            translate <0,30,0>
            pigment { color Orange }
            finish { Luminous }
            rotate z*(360/12)*11
            }
          sphere
          {
          <0,0,0>,1
          translate <0,30,0>
          pigment { color Orange }
          finish { Luminous }
          rotate z*(360/12)*12
          }

          cone
            {
            <0,23,0>,0,<0,15,0>,3
            pigment { color Red }
            finish { Luminous }
            rotate z*(360/12)*Mn
            }
          cone
            {
            <0,15,0>,0,<0,0,0>,1
            pigment { color Red }
            finish { Luminous }
            rotate z*(360/12)*Mn
            }
          cone
            {
            <0,14.5,0>,0,<0,10,0>,3
            pigment { color Blue }
            finish { Luminous }
            rotate z*(360/12)*Hr
            }
          cone
            {
            <0,10,0>,0,<0,0,0>,1
            pigment { color Blue }
            finish { Luminous }
            rotate z*(360/12)*Hr
            }

          disc
            {
            <0,0,0>,y,45
            pigment { White }
            rotate x*90
            finish { Luminous }
            }
      }
   object
      {
      Myobject
      hollow
      scale .001*Count
      rotate y*90
      translate x*3*Count
      translate z*1*Count
      rotate y*(360/60)*Mn
      scale .003*Count
      }
   #declare Mn=Mn+1
   #declare Hr=Mn/60
   #declare Count=Count+1
#end

#declare Textur = texture
   {
   pigment { colour Clear }
   halo
      {
      poly
      max_value 52
      box_mapping
      emitting
      frequency 2
      turbulence <1.059,2.13,1.023>
      octaves .99
      lambda .059
      colour_map
         {
            [0    color rgbt <    0,   0, .00  ,1    >]
            [0.12 color rgbt < .002,   0, .00  , .51 >]
            [0.24 color rgbt < .001,.001, .00  , .61 >]
            [0.35 color rgbt <    0,  00, .00  , .71 >] 
            [0.49 color rgbt < .001,.001, .001 , .81 >]
            [0.5  color rgbt < .002,   0, .00  , .91 >]
            [0.65 color rgbt <    0,   0, .00  , .1  >] 
            [0.89 color rgbt <  .00,  .0, .0001, .21 >]
            [1    color rgbt <    0,   0, .00  ,1    >] 
         }
      samples 90
      scale 2999
      }
   }

sphere
   {
   0,6000
   hollow
   texture { Textur }
   }

torus
   {
   2620,2619
   pigment { color Clear }
   scale <.70,.5,.70>
   }
sphere
   {
   0,29000
   texture { Starfield scale 29000 }
   hollow
   }
   // That's all folks!
 
