// This is a Persistence of Vision Ray Tracer (POV-Ray) Version 2.2 Scene file
//             POV-Ray is (Copyrighted) 1994-95, POV-Ray Team
//
// This file was generated using "Mid Night Modeller" Version 2.10
//             MNM is (Copyright) 1994-95, David R.Taylor
//
//
//******************************** HEADER *************************************
#include "colors.inc"
#include "textures.inc"

// User defined include files

#include "stones.inc"
#include "mnm.inc"

#default{finish{ambient 0.5}}

#max_trace_level 5
#max_intersections 100

fog {
    color rgb<0.5, 0.5, 0.5>
    distance 1000
}

background { color rgb<1, 1, 1> }


//****************** CAMERA **********************

camera {
    location <20, 30, -40>
   direction <0, 0, 2.25535>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <0, 5, 0>
}


//****************** TEXTURES ********************


#declare Plane_White = texture {
    pigment { color rgbf<1, 1, 1, 0>
    }
}

#declare CheckerFloor = texture {
    pigment { checker color rgbf<1, 1, 1, 0> color rgbf<0, 0, 0, 0>
    }
    normal {
        waves 1
    }
    finish {
        reflection 0.2
        phong 0  phong_size 40
    }
}

#declare bigsky = texture {
    pigment { granite
        color_map {
            [0  color rgbf<0.3, 0.3, 1, 0>]
            [0.4  color rgbf<0.3, 0.3, 1, 0>]
            [0.7  color rgbf<0.7, 0.7, 0.7, 0>]
            [0.99  color rgbf<0.95, 0.95, 1, 0>]
        }
        turbulence 0.2
        octaves 6
        omega 0.7
        lambda 2
    }
    finish {
        ambient 1
    }
}

#declare Fire1 = texture {
    pigment { granite
        color_map {
            [0  color rgbf<1, 1, 1, 0>]
            [0.1  color rgbf<0.556863, 0.137255, 0.137255, 0>]
            [0.9  color rgbf<1, 1, 0, 0>]
            [0.9  color rgbf<1, 1, 1, 1>]
            [1  color rgbf<1, 1, 1, 1>]
        }
        scale <2, 6, 2>
    }
    normal {
        waves 0.9
        turbulence 1
        octaves 6
        omega 0.5
        lambda 2
    }
    finish {
        ambient 1
    }
    scale <2, 6, 2>
}

#declare Plane_Black = texture {
    pigment { color rgbf<0.05, 0.05, 0.05, 0>
    }
    finish {
        diffuse 0.5
        specular 1  roughness 0.03
        metallic
    }
}

#declare Rok = texture {
    pigment { onion
        color_map {
            [0  color rgbf<0.4, 0.6, 0.3, 0>]
            [0.3  color rgbf<0.6, 0.6, 0.6, 0>]
            [0.5  color rgbf<0.6, 0.6, 0.6, 0>]
            [0.6  color rgbf<0.45, 0.3, 0.6, 0>]
            [0.75  color rgbf<0.3, 0.5, 0.2, 0>]
            [0.9  color rgbf<0.7, 0.87, 0.7, 0>]
            [0.99  color rgbf<0.6, 0.8, 0.6, 0>]
        }
        turbulence 1
        octaves 4
        omega 0.5
        lambda 2
    }
    normal {
        wrinkles 0.7
        turbulence 0.3
        octaves 6
        omega 0.5
        lambda 2
        scale <0.6, 0.6, 0.6>
    }
}

#declare Shuttle_iron = texture {
    pigment { bozo
        color_map {
            [0  color rgbf<0.2, 0.2, 0.2, 0>]
            [0.3  color rgbf<0.3, 0.3, 0.3, 0>]
            [0.35  color rgbf<0.4, 0.4, 0.4, 0>]
        }
        turbulence 0.1
        octaves 6
        omega 0.5
        lambda 2
        scale <0.2, 1, 0.2>
    }
    finish {
        specular 0.5  roughness 0.05
        metallic
    }
}

#declare Green_iron = texture {
    pigment { marble
        color_map {
            [0  color rgbf<0.2, 0.4, 0.1, 0>]
            [0  color rgbf<0.1, 0.3, 0.05, 0>]
        }
        scale <0.1, 0.1, 0.1>
    }
    finish {
        diffuse 0.6
        ambient 0.5
        phong 1  phong_size 150
        specular 2  roughness 0.05
        metallic
    }
}

#declare Semi_smooth_steel = texture {
    pigment { color rgbf<0.5, 0.5, 0.5, 0>
    }
    normal {
        dents 0.25
    }
    finish {
        reflection 0.5
        specular 1  roughness 0.001
        metallic
    }
    rotate <90, 90, 0>
}

#declare Red_clear_plastic = texture {
    pigment { color rgbf<1, 0, 0.4, 0.7>
    }
    finish {
        diffuse 0.5
    }
}


//****************** BLOCK LAYERS ****************



//****************** ACTION **********************


union {  // Layer name: waterclock
    cone { <0.0, 0.0, 0.0>, 0.1, <0.0, 1, 0.0>, 0.1  
        texture { Red_clear_plastic }
        rotate <.0, .0, -90>
        translate <-30, -14, 27.5>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 17, 0.0>, 0.25  
        texture { Cork }
        translate <-30, -29, 27.5>
    }
    cone { <0.0, 0.0, 0.0>, 1.5, <0.0, 2, 0.0>, 1.5  
        texture { Cork }
        translate <-30, -30.5, 27.5>
    }
    union { // Surface of Revolution
        smooth_triangle {<-31.9989, -24.0012, 27.4995>, <0.00149482, -0.00597929, -0.000297338>,
                         <-31.884, -23.9701, 27.4519>, <0.00334088, -0.00600302, -0.000862767>,
                         <-31.8744, -23.9701, 27.5>, <0.00341674, -0.00600302, 0.000481406> }
        smooth_triangle {<-31.8744, -23.9701, 27.5>, <0.00256611, -0.0045165, 0.000360346>,
                         <-31.9988, -24.0012, 27.5>, <0.00075453, -0.00301812, 0.000147253>,
                         <-31.9989, -24.0012, 27.4995>, <0.00075453, -0.00301812, -0.000150085> }
        smooth_triangle {<-31.884, -23.9701, 27.4519>, <0.00334088, -0.00600302, -0.000862767>,
                         <-31.8121, -23.8768, 27.4222>, <0.00843914, -0.00552136, -0.00264146>,
                         <-31.7967, -23.8768, 27.5>, <0.0088076, -0.00552136, 0.000789128> }
        smooth_triangle {<-31.7967, -23.8768, 27.5>, <0.00772681, -0.00507528, 0.000368842>,
                         <-31.8744, -23.9701, 27.5>, <0.00368367, -0.00543653, 0.00013805>,
                         <-31.884, -23.9701, 27.4519>, <0.00362678, -0.00543653, -0.00087008> }
        smooth_triangle {<-31.8121, -23.8768, 27.4222>, <0.00843914, -0.00552136, -0.00264146>,
                         <-31.769, -23.7524, 27.4043>, <0.0125315, -0.00622606, -0.00407092>,
                         <-31.75, -23.7524, 27.5>, <0.0131355, -0.00622606, 0.00103455> }
        smooth_triangle {<-31.75, -23.7524, 27.5>, <0.0122718, -0.00557712, 0.000294507>,
                         <-31.7967, -23.8768, 27.5>, <0.00902589, -0.00504859, 0.00011044>,
                         <-31.8121, -23.8768, 27.4222>, <0.00874955, -0.00504859, -0.0024625> }
        smooth_triangle {<-31.769, -23.7524, 27.4043>, <0.0125315, -0.00622606, -0.00407092>,
                         <-31.6972, -23.628, 27.3746>, <0.0127043, -0.00959535, -0.00459614>,
                         <-31.6722, -23.628, 27.5>, <0.0134961, -0.00959535, 0.000615444> }
        smooth_triangle {<-31.6722, -23.628, 27.5>, <0.0130975, -0.00905614, -0.000130263>,
                         <-31.75, -23.7524, 27.5>, <0.012827, -0.00652918, 0.000184067>,
                         <-31.769, -23.7524, 27.4043>, <0.012374, -0.00652918, -0.00364504> }
        smooth_triangle {<-31.6972, -23.628, 27.3746>, <0.0127043, -0.00959535, -0.00459614>,
                         <-31.6397, -23.5658, 27.3508>, <0.0110984, -0.00977567, -0.0034385>,
                         <-31.61, -23.5658, 27.5>, <0.0115695, -0.00977567, 0.00107042> }
        smooth_triangle {<-31.61, -23.5658, 27.5>, <0.0106275, -0.00928214, 0.000414859>,
                         <-31.6722, -23.628, 27.5>, <0.0120725, -0.0091469, 7.36267e-05>,
                         <-31.6972, -23.628, 27.3746>, <0.0114786, -0.0091469, -0.00383506> }
        smooth_triangle {<-31.6397, -23.5658, 27.3508>, <0.0110984, -0.00977567, -0.0034385>,
                         <-31.5823, -23.4725, 27.327>, <0.0119223, -0.0101434, -0.00451234>,
                         <-31.5478, -23.4725, 27.5>, <0.0127416, -0.0101434, 0.00039362> }
        smooth_triangle {<-31.5478, -23.4725, 27.5>, <0.013037, -0.00992812, -0.00039716>,
                         <-31.61, -23.5658, 27.5>, <0.0121579, -0.00965229, 0.00011044>,
                         <-31.6397, -23.5658, 27.3508>, <0.0118046, -0.00965229, -0.00327125> }
        smooth_triangle {<-31.5823, -23.4725, 27.327>, <0.0119223, -0.0101434, -0.00451234>,
                         <-31.5392, -23.4414, 27.3091>, <0.00548469, -0.00890488, -0.00227183>,
                         <-31.5012, -23.4414, 27.5>, <0.00593659, -0.00890488, 2.80808e-17> }
        smooth_triangle {<-31.5012, -23.4414, 27.5>, <0.00575151, -0.00862727, -0.000356806>,
                         <-31.5478, -23.4725, 27.5>, <0.0109015, -0.0096256, 2.761e-05>,
                         <-31.5823, -23.4725, 27.327>, <0.0102871, -0.0096256, -0.00365186> }
        smooth_triangle {<-31.9992, -24.0012, 27.4992>, <0.00126725, -0.00597929, -0.000846747>,
                         <-31.9112, -23.9701, 27.4112>, <0.00275641, -0.00600302, -0.00207559>,
                         <-31.884, -23.9701, 27.4519>, <0.00334088, -0.00600302, -0.000862767> }
        smooth_triangle {<-31.884, -23.9701, 27.4519>, <0.00250868, -0.0045165, -0.000649092>,
                         <-31.9989, -24.0012, 27.4995>, <0.000753446, -0.00301812, -0.000152701>,
                         <-31.9992, -24.0012, 27.4992>, <0.00063966, -0.00301812, -0.000427406> }
        smooth_triangle {<-31.9112, -23.9701, 27.4112>, <0.00275641, -0.00600302, -0.00207559>,
                         <-31.8562, -23.8768, 27.3562>, <0.00678591, -0.00552136, -0.00566991>,
                         <-31.8121, -23.8768, 27.4222>, <0.00843914, -0.00552136, -0.00264146> }
        smooth_triangle {<-31.8121, -23.8768, 27.4222>, <0.0072798, -0.00507528, -0.00261616>,
                         <-31.884, -23.9701, 27.4519>, <0.0034561, -0.00543653, -0.00128214>,
                         <-31.9112, -23.9701, 27.4112>, <0.00301774, -0.00543653, -0.00219176> }
        smooth_triangle {<-31.8562, -23.8768, 27.3562>, <0.00678591, -0.00552136, -0.00566991>,
                         <-31.8232, -23.7524, 27.3232>, <0.0100197, -0.00622606, -0.00855664>,
                         <-31.769, -23.7524, 27.4043>, <0.0125315, -0.00622606, -0.00407092> }
        smooth_triangle {<-31.769, -23.7524, 27.4043>, <0.0114504, -0.00557712, -0.00442412>,
                         <-31.8121, -23.8768, 27.4222>, <0.0083811, -0.00504859, -0.00335202>,
                         <-31.8562, -23.8768, 27.3562>, <0.00714117, -0.00504859, -0.00562336> }
        smooth_triangle {<-31.8232, -23.7524, 27.3232>, <0.0100197, -0.00622606, -0.00855664>,
                         <-31.7682, -23.628, 27.2682>, <0.00997839, -0.00959535, -0.00910801>,
                         <-31.6972, -23.628, 27.3746>, <0.0127043, -0.00959535, -0.00459614> }
        smooth_triangle {<-31.6972, -23.628, 27.3746>, <0.0120507, -0.00905614, -0.00513254>,
                         <-31.769, -23.7524, 27.4043>, <0.0119211, -0.00652918, -0.00473863>,
                         <-31.8232, -23.7524, 27.3232>, <0.0100372, -0.00652918, -0.00810291> }
        smooth_triangle {<-31.7682, -23.628, 27.2682>, <0.00997839, -0.00959535, -0.00910801>,
                         <-31.7243, -23.5658, 27.2243>, <0.00893775, -0.00977568, -0.00742394>,
                         <-31.6397, -23.5658, 27.3508>, <0.0110984, -0.00977567, -0.0034385> }
        smooth_triangle {<-31.6397, -23.5658, 27.3508>, <0.00997728, -0.00928214, -0.00368368>,
                         <-31.6972, -23.628, 27.3746>, <0.0111817, -0.0091469, -0.00455191>,
                         <-31.7682, -23.628, 27.2682>, <0.00913725, -0.0091469, -0.00793582> }
        smooth_triangle {<-31.7243, -23.5658, 27.2243>, <0.00893775, -0.00977568, -0.00742394>,
                         <-31.6803, -23.4725, 27.1803>, <0.009288, -0.0101434, -0.00873133>,
                         <-31.5823, -23.4725, 27.327>, <0.0119223, -0.0101434, -0.00451234> }
        smooth_triangle {<-31.5823, -23.4725, 27.327>, <0.0118926, -0.00992812, -0.00535597>,
                         <-31.6397, -23.5658, 27.3508>, <0.0112747, -0.00965229, -0.00455059>,
                         <-31.7243, -23.5658, 27.2243>, <0.00965419, -0.00965229, -0.00753967> }
        smooth_triangle {<-31.6803, -23.4725, 27.1803>, <0.009288, -0.0101434, -0.00873133>,
                         <-31.6473, -23.4414, 27.1473>, <0.0041978, -0.00890488, -0.0041978>,
                         <-31.5392, -23.4414, 27.3091>, <0.00548469, -0.00890488, -0.00227183> }
        smooth_triangle {<-31.5392, -23.4414, 27.3091>, <0.00517716, -0.00862727, -0.00253065>,
                         <-31.5823, -23.4725, 27.327>, <0.0100823, -0.0096256, -0.00414633>,
                         <-31.6803, -23.4725, 27.1803>, <0.00810653, -0.0096256, -0.00731057> }
        smooth_triangle {<-31.9995, -24.0012, 27.4989>, <0.000846751, -0.00597929, -0.00126725>,
                         <-31.9519, -23.9701, 27.384>, <0.00175229, -0.00600302, -0.00297243>,
                         <-31.9112, -23.9701, 27.4112>, <0.00275641, -0.00600302, -0.00207559> }
        smooth_triangle {<-31.9112, -23.9701, 27.4112>, <0.00206932, -0.0045165, -0.00155971>,
                         <-31.9992, -24.0012, 27.4992>, <0.000637657, -0.00301812, -0.000429408>,
                         <-31.9995, -24.0012, 27.4989>, <0.000427408, -0.00301812, -0.000639658> }
        smooth_triangle {<-31.9519, -23.9701, 27.384>, <0.00175229, -0.00600302, -0.00297243>,
                         <-31.9222, -23.8768, 27.3121>, <0.00409958, -0.00552136, -0.00783517>,
                         <-31.8562, -23.8768, 27.3562>, <0.00678591, -0.00552136, -0.00566991> }
        smooth_triangle {<-31.8562, -23.8768, 27.3562>, <0.00572449, -0.00507528, -0.00520287>,
                         <-31.9112, -23.9701, 27.4112>, <0.00270237, -0.00543653, -0.00250713>,
                         <-31.9519, -23.9701, 27.384>, <0.00194928, -0.00543653, -0.00317976> }
        smooth_triangle {<-31.9222, -23.8768, 27.3121>, <0.00409958, -0.00552136, -0.00783517>,
                         <-31.9043, -23.7524, 27.269>, <0.00598253, -0.00622606, -0.0117397>,
                         <-31.8232, -23.7524, 27.3232>, <0.0100197, -0.00622606, -0.00855664> }
        smooth_triangle {<-31.8232, -23.7524, 27.3232>, <0.00888572, -0.00557712, -0.00846922>,
                         <-31.8562, -23.8768, 27.3562>, <0.00646036, -0.00504859, -0.00630417>,
                         <-31.9222, -23.8768, 27.3121>, <0.00444561, -0.00504859, -0.00792811> }
        smooth_triangle {<-31.9043, -23.7524, 27.269>, <0.00598253, -0.00622606, -0.0117397>,
                         <-31.8746, -23.628, 27.1972>, <0.00573334, -0.00959535, -0.0122333>,
                         <-31.7682, -23.628, 27.2682>, <0.00997839, -0.00959535, -0.00910801> }
        smooth_triangle {<-31.7682, -23.628, 27.2682>, <0.00916923, -0.00905614, -0.00935344>,
                         <-31.8232, -23.7524, 27.3232>, <0.00920022, -0.00652918, -0.00893991>,
                         <-31.9043, -23.7524, 27.269>, <0.00617233, -0.00652918, -0.0113272> }
        smooth_triangle {<-31.8746, -23.628, 27.1972>, <0.00573334, -0.00959535, -0.0122333>,
                         <-31.8508, -23.5658, 27.1397>, <0.00541638, -0.00977568, -0.0102792>,
                         <-31.7243, -23.5658, 27.2243>, <0.00893775, -0.00977568, -0.00742394> }
        smooth_triangle {<-31.7243, -23.5658, 27.2243>, <0.00780812, -0.00928215, -0.00722141>,
                         <-31.7682, -23.628, 27.2682>, <0.0085886, -0.0091469, -0.00848447>,
                         <-31.8746, -23.628, 27.1972>, <0.00540481, -0.0091469, -0.0108284> }
        smooth_triangle {<-31.8508, -23.5658, 27.1397>, <0.00541638, -0.00977568, -0.0102792>,
                         <-31.827, -23.4725, 27.0823>, <0.00523966, -0.0101435, -0.0116211>,
                         <-31.6803, -23.4725, 27.1803>, <0.009288, -0.0101434, -0.00873133> }
        smooth_triangle {<-31.6803, -23.4725, 27.1803>, <0.00893772, -0.00992812, -0.00949938>,
                         <-31.7243, -23.5658, 27.2243>, <0.00867503, -0.00965229, -0.00851884>,
                         <-31.8508, -23.5658, 27.1397>, <0.00603401, -0.00965229, -0.0106602> }
        smooth_triangle {<-31.827, -23.4725, 27.0823>, <0.00523966, -0.0101435, -0.0116211>,
                         <-31.8091, -23.4414, 27.0392>, <0.00227184, -0.00890488, -0.00548469>,
                         <-31.6473, -23.4414, 27.1473>, <0.0041978, -0.00890488, -0.0041978> }
        smooth_triangle {<-31.6473, -23.4414, 27.1473>, <0.00381463, -0.00862727, -0.00431923>,
                         <-31.6803, -23.4725, 27.1803>, <0.00772808, -0.0096256, -0.00768902>,
                         <-31.827, -23.4725, 27.0823>, <0.00469182, -0.0096256, -0.00985632> }
        smooth_triangle {<-32, -24.0012, 27.4988>, <0.000297341, -0.00597929, -0.00149482>,
                         <-32, -23.9701, 27.3744>, <0.000481409, -0.00600302, -0.00341674>,
                         <-31.9519, -23.9701, 27.384>, <0.00175229, -0.00600302, -0.00297243> }
        smooth_triangle {<-31.9519, -23.9701, 27.384>, <0.00131493, -0.0045165, -0.00223288>,
                         <-31.9995, -24.0012, 27.4989>, <0.000424791, -0.00301812, -0.000640742>,
                         <-32, -24.0012, 27.4988>, <0.000150087, -0.00301812, -0.000754528> }
        smooth_triangle {<-32, -23.9701, 27.3744>, <0.000481409, -0.00600302, -0.00341674>,
                         <-32, -23.8768, 27.2967>, <0.000789131, -0.00552136, -0.00880759>,
                         <-31.9222, -23.8768, 27.3121>, <0.00409958, -0.00552136, -0.00783517> }
        smooth_triangle {<-31.9222, -23.8768, 27.3121>, <0.00329769, -0.00507528, -0.00699749>,
                         <-31.9519, -23.9701, 27.384>, <0.00153722, -0.00543653, -0.00335044>,
                         <-32, -23.9701, 27.3744>, <0.000584061, -0.00543653, -0.00368367> }
        smooth_triangle {<-32, -23.8768, 27.2967>, <0.000789131, -0.00552136, -0.00880759>,
                         <-32, -23.7524, 27.25>, <0.00103455, -0.00622607, -0.0131355>,
                         <-31.9043, -23.7524, 27.269>, <0.00598253, -0.00622606, -0.0117397> }
        smooth_triangle {<-31.9043, -23.7524, 27.269>, <0.0049683, -0.00557712, -0.011225>,
                         <-31.9222, -23.8768, 27.3121>, <0.00355609, -0.00504859, -0.00829657>,
                         <-32, -23.8768, 27.2967>, <0.00107325, -0.00504859, -0.00902588> }
        smooth_triangle {<-32, -23.7524, 27.25>, <0.00103455, -0.00622607, -0.0131355>,
                         <-32, -23.628, 27.1722>, <0.000615449, -0.00959535, -0.0134961>,
                         <-31.8746, -23.628, 27.1972>, <0.00573334, -0.00959535, -0.0122333> }
        smooth_triangle {<-31.8746, -23.628, 27.1972>, <0.00489185, -0.00905615, -0.0121504>,
                         <-31.9043, -23.7524, 27.269>, <0.00507874, -0.00652918, -0.0117802>,
                         <-32, -23.7524, 27.25>, <0.00136776, -0.00652918, -0.012827> }
        smooth_triangle {<-32, -23.628, 27.1722>, <0.000615449, -0.00959535, -0.0134961>,
                         <-32, -23.5658, 27.11>, <0.00107043, -0.00977568, -0.0115695>,
                         <-31.8508, -23.5658, 27.1397>, <0.00541638, -0.00977568, -0.0102792> }
        smooth_triangle {<-31.8508, -23.5658, 27.1397>, <0.00445025, -0.00928215, -0.00965975>,
                         <-31.8746, -23.628, 27.1972>, <0.00468796, -0.0091469, -0.0111253>,
                         <-32, -23.628, 27.1722>, <0.000849545, -0.0091469, -0.0120725> }
        smooth_triangle {<-32, -23.5658, 27.11>, <0.00107043, -0.00977568, -0.0115695>,
                         <-32, -23.4725, 27.0478>, <0.000393626, -0.0101435, -0.0127416>,
                         <-31.827, -23.4725, 27.0823>, <0.00523966, -0.0101435, -0.0116211> }
        smooth_triangle {<-31.827, -23.4725, 27.0823>, <0.00462212, -0.00992813, -0.0121966>,
                         <-31.8508, -23.5658, 27.1397>, <0.00475466, -0.0096523, -0.0111902>,
                         <-32, -23.5658, 27.11>, <0.0014952, -0.0096523, -0.0121579> }
        smooth_triangle {<-32, -23.4725, 27.0478>, <0.000393626, -0.0101435, -0.0127416>,
                         <-32, -23.4414, 27.0012>, <5.00152e-09, -0.00890488, -0.00593658>,
                         <-31.8091, -23.4414, 27.0392>, <0.00227184, -0.00890488, -0.00548469> }
        smooth_triangle {<-31.8091, -23.4414, 27.0392>, <0.00187137, -0.00862727, -0.00545024>,
                         <-31.827, -23.4725, 27.0823>, <0.00419735, -0.0096256, -0.0100611>,
                         <-32, -23.4725, 27.0478>, <0.000562825, -0.0096256, -0.0109015> }
        smooth_triangle {<-32.0005, -24.0012, 27.4989>, <-0.000297335, -0.00597929, -0.00149482>,
                         <-32.0481, -23.9701, 27.384>, <-0.000862764, -0.00600302, -0.00334088>,
                         <-32, -23.9701, 27.3744>, <0.000481409, -0.00600302, -0.00341674> }
        smooth_triangle {<-32, -23.9701, 27.3744>, <0.000360349, -0.0045165, -0.00256611>,
                         <-32, -24.0012, 27.4988>, <0.000147255, -0.00301812, -0.000754528>,
                         <-32.0005, -24.0012, 27.4989>, <-0.000150083, -0.00301812, -0.000754528> }
        smooth_triangle {<-32.0481, -23.9701, 27.384>, <-0.000862764, -0.00600302, -0.00334088>,
                         <-32.0778, -23.8768, 27.3121>, <-0.00264146, -0.00552136, -0.00843914>,
                         <-32, -23.8768, 27.2967>, <0.000789131, -0.00552136, -0.00880759> }
        smooth_triangle {<-32, -23.8768, 27.2967>, <0.000368845, -0.00507529, -0.00772681>,
                         <-32, -23.9701, 27.3744>, <0.000138053, -0.00543653, -0.00368367>,
                         <-32.0481, -23.9701, 27.384>, <-0.000870077, -0.00543653, -0.00362678> }
        smooth_triangle {<-32.0778, -23.8768, 27.3121>, <-0.00264146, -0.00552136, -0.00843914>,
                         <-32.0957, -23.7524, 27.269>, <-0.00407092, -0.00622607, -0.0125315>,
                         <-32, -23.7524, 27.25>, <0.00103455, -0.00622607, -0.0131355> }
        smooth_triangle {<-32, -23.7524, 27.25>, <0.00029451, -0.00557712, -0.0122718>,
                         <-32, -23.8768, 27.2967>, <0.000110443, -0.00504859, -0.00902588>,
                         <-32.0778, -23.8768, 27.3121>, <-0.0024625, -0.00504859, -0.00874955> }
        smooth_triangle {<-32.0957, -23.7524, 27.269>, <-0.00407092, -0.00622607, -0.0125315>,
                         <-32.1254, -23.628, 27.1972>, <-0.00459614, -0.00959536, -0.0127043>,
                         <-32, -23.628, 27.1722>, <0.000615449, -0.00959535, -0.0134961> }
        smooth_triangle {<-32, -23.628, 27.1722>, <-0.000130258, -0.00905615, -0.0130975>,
                         <-32, -23.7524, 27.25>, <0.000184071, -0.00652918, -0.012827>,
                         <-32.0957, -23.7524, 27.269>, <-0.00364504, -0.00652919, -0.012374> }
        smooth_triangle {<-32.1254, -23.628, 27.1972>, <-0.00459614, -0.00959536, -0.0127043>,
                         <-32.1492, -23.5658, 27.1397>, <-0.00343849, -0.00977568, -0.0110984>,
                         <-32, -23.5658, 27.11>, <0.00107043, -0.00977568, -0.0115695> }
        smooth_triangle {<-32, -23.5658, 27.11>, <0.000414864, -0.00928215, -0.0106275>,
                         <-32, -23.628, 27.1722>, <7.36319e-05, -0.00914691, -0.0120725>,
                         <-32.1254, -23.628, 27.1972>, <-0.00383506, -0.00914691, -0.0114786> }
        smooth_triangle {<-32.1492, -23.5658, 27.1397>, <-0.00343849, -0.00977568, -0.0110984>,
                         <-32.173, -23.4725, 27.0823>, <-0.00451233, -0.0101435, -0.0119223>,
                         <-32, -23.4725, 27.0478>, <0.000393626, -0.0101435, -0.0127416> }
        smooth_triangle {<-32, -23.4725, 27.0478>, <-0.000397154, -0.00992813, -0.013037>,
                         <-32, -23.5658, 27.11>, <0.000110446, -0.0096523, -0.0121579>,
                         <-32.1492, -23.5658, 27.1397>, <-0.00327124, -0.0096523, -0.0118046> }
        smooth_triangle {<-32.173, -23.4725, 27.0823>, <-0.00451233, -0.0101435, -0.0119223>,
                         <-32.1909, -23.4414, 27.0392>, <-0.00227183, -0.00890488, -0.00548469>,
                         <-32, -23.4414, 27.0012>, <5.00152e-09, -0.00890488, -0.00593658> }
        smooth_triangle {<-32, -23.4414, 27.0012>, <-0.000356802, -0.00862727, -0.00575151>,
                         <-32, -23.4725, 27.0478>, <2.76154e-05, -0.0096256, -0.0109015>,
                         <-32.173, -23.4725, 27.0823>, <-0.00365185, -0.00962561, -0.0102871> }
        smooth_triangle {<-32.0008, -24.0012, 27.4992>, <-0.000846744, -0.00597929, -0.00126725>,
                         <-32.0888, -23.9701, 27.4112>, <-0.00207559, -0.00600302, -0.0027564>,
                         <-32.0481, -23.9701, 27.384>, <-0.000862764, -0.00600302, -0.00334088> }
        smooth_triangle {<-32.0481, -23.9701, 27.384>, <-0.000649089, -0.0045165, -0.00250868>,
                         <-32.0005, -24.0012, 27.4989>, <-0.0001527, -0.00301812, -0.000753444>,
                         <-32.0008, -24.0012, 27.4992>, <-0.000427404, -0.00301812, -0.000639658> }
        smooth_triangle {<-32.0888, -23.9701, 27.4112>, <-0.00207559, -0.00600302, -0.0027564>,
                         <-32.1438, -23.8768, 27.3562>, <-0.00566991, -0.00552136, -0.00678591>,
                         <-32.0778, -23.8768, 27.3121>, <-0.00264146, -0.00552136, -0.00843914> }
        smooth_triangle {<-32.0778, -23.8768, 27.3121>, <-0.00261615, -0.00507529, -0.00727979>,
                         <-32.0481, -23.9701, 27.384>, <-0.00128213, -0.00543653, -0.0034561>,
                         <-32.0888, -23.9701, 27.4112>, <-0.00219175, -0.00543653, -0.00301774> }
        smooth_triangle {<-32.1438, -23.8768, 27.3562>, <-0.00566991, -0.00552136, -0.00678591>,
                         <-32.1768, -23.7524, 27.3232>, <-0.00855663, -0.00622607, -0.0100197>,
                         <-32.0957, -23.7524, 27.269>, <-0.00407092, -0.00622607, -0.0125315> }
        smooth_triangle {<-32.0957, -23.7524, 27.269>, <-0.00442412, -0.00557713, -0.0114504>,
                         <-32.0778, -23.8768, 27.3121>, <-0.00335202, -0.0050486, -0.00838109>,
                         <-32.1438, -23.8768, 27.3562>, <-0.00562336, -0.0050486, -0.00714117> }
        smooth_triangle {<-32.1768, -23.7524, 27.3232>, <-0.00855663, -0.00622607, -0.0100197>,
                         <-32.2318, -23.628, 27.2682>, <-0.00910801, -0.00959536, -0.00997838>,
                         <-32.1254, -23.628, 27.1972>, <-0.00459614, -0.00959536, -0.0127043> }
        smooth_triangle {<-32.1254, -23.628, 27.1972>, <-0.00513254, -0.00905615, -0.0120507>,
                         <-32.0957, -23.7524, 27.269>, <-0.00473862, -0.00652919, -0.011921>,
                         <-32.1768, -23.7524, 27.3232>, <-0.00810291, -0.00652919, -0.0100372> }
        smooth_triangle {<-32.2318, -23.628, 27.2682>, <-0.00910801, -0.00959536, -0.00997838>,
                         <-32.2757, -23.5658, 27.2243>, <-0.00742393, -0.00977568, -0.00893774>,
                         <-32.1492, -23.5658, 27.1397>, <-0.00343849, -0.00977568, -0.0110984> }
        smooth_triangle {<-32.1492, -23.5658, 27.1397>, <-0.00368368, -0.00928215, -0.00997727>,
                         <-32.1254, -23.628, 27.1972>, <-0.00455191, -0.00914691, -0.0111817>,
                         <-32.2318, -23.628, 27.2682>, <-0.00793581, -0.00914691, -0.00913725> }
        smooth_triangle {<-32.2757, -23.5658, 27.2243>, <-0.00742393, -0.00977568, -0.00893774>,
                         <-32.3197, -23.4725, 27.1803>, <-0.00873133, -0.0101435, -0.00928799>,
                         <-32.173, -23.4725, 27.0823>, <-0.00451233, -0.0101435, -0.0119223> }
        smooth_triangle {<-32.173, -23.4725, 27.0823>, <-0.00535596, -0.00992813, -0.0118926>,
                         <-32.1492, -23.5658, 27.1397>, <-0.00455059, -0.0096523, -0.0112747>,
                         <-32.2757, -23.5658, 27.2243>, <-0.00753967, -0.0096523, -0.00965419> }
        smooth_triangle {<-32.3197, -23.4725, 27.1803>, <-0.00873133, -0.0101435, -0.00928799>,
                         <-32.3527, -23.4414, 27.1473>, <-0.00419779, -0.00890489, -0.0041978>,
                         <-32.1909, -23.4414, 27.0392>, <-0.00227183, -0.00890488, -0.00548469> }
        smooth_triangle {<-32.1909, -23.4414, 27.0392>, <-0.00253065, -0.00862727, -0.00517716>,
                         <-32.173, -23.4725, 27.0823>, <-0.00414632, -0.00962561, -0.0100823>,
                         <-32.3197, -23.4725, 27.1803>, <-0.00731057, -0.00962561, -0.00810652> }
        smooth_triangle {<-32.0011, -24.0012, 27.4995>, <-0.00126724, -0.00597929, -0.000846747>,
                         <-32.116, -23.9701, 27.4519>, <-0.00297242, -0.00600302, -0.00175229>,
                         <-32.0888, -23.9701, 27.4112>, <-0.00207559, -0.00600302, -0.0027564> }
        smooth_triangle {<-32.0888, -23.9701, 27.4112>, <-0.00155971, -0.0045165, -0.00206932>,
                         <-32.0008, -24.0012, 27.4992>, <-0.000429407, -0.00301812, -0.000637656>,
                         <-32.0011, -24.0012, 27.4995>, <-0.000639656, -0.00301812, -0.000427406> }
        smooth_triangle {<-32.116, -23.9701, 27.4519>, <-0.00297242, -0.00600302, -0.00175229>,
                         <-32.1879, -23.8768, 27.4222>, <-0.00783517, -0.00552137, -0.00409958>,
                         <-32.1438, -23.8768, 27.3562>, <-0.00566991, -0.00552136, -0.00678591> }
        smooth_triangle {<-32.1438, -23.8768, 27.3562>, <-0.00520287, -0.00507529, -0.00572449>,
                         <-32.0888, -23.9701, 27.4112>, <-0.00250713, -0.00543653, -0.00270236>,
                         <-32.116, -23.9701, 27.4519>, <-0.00317975, -0.00543653, -0.00194928> }
        smooth_triangle {<-32.1879, -23.8768, 27.4222>, <-0.00783517, -0.00552137, -0.00409958>,
                         <-32.231, -23.7524, 27.4043>, <-0.0117397, -0.00622607, -0.00598252>,
                         <-32.1768, -23.7524, 27.3232>, <-0.00855663, -0.00622607, -0.0100197> }
        smooth_triangle {<-32.1768, -23.7524, 27.3232>, <-0.00846921, -0.00557713, -0.00888571>,
                         <-32.1438, -23.8768, 27.3562>, <-0.00630417, -0.0050486, -0.00646036>,
                         <-32.1879, -23.8768, 27.4222>, <-0.00792811, -0.0050486, -0.00444561> }
        smooth_triangle {<-32.231, -23.7524, 27.4043>, <-0.0117397, -0.00622607, -0.00598252>,
                         <-32.3028, -23.628, 27.3746>, <-0.0122333, -0.00959536, -0.00573334>,
                         <-32.2318, -23.628, 27.2682>, <-0.00910801, -0.00959536, -0.00997838> }
        smooth_triangle {<-32.2318, -23.628, 27.2682>, <-0.00935344, -0.00905615, -0.00916922>,
                         <-32.1768, -23.7524, 27.3232>, <-0.00893991, -0.00652919, -0.00920022>,
                         <-32.231, -23.7524, 27.4043>, <-0.0113272, -0.00652919, -0.00617233> }
        smooth_triangle {<-32.3028, -23.628, 27.3746>, <-0.0122333, -0.00959536, -0.00573334>,
                         <-32.3603, -23.5658, 27.3508>, <-0.0102791, -0.00977569, -0.00541638>,
                         <-32.2757, -23.5658, 27.2243>, <-0.00742393, -0.00977568, -0.00893774> }
        smooth_triangle {<-32.2757, -23.5658, 27.2243>, <-0.00722141, -0.00928215, -0.00780811>,
                         <-32.2318, -23.628, 27.2682>, <-0.00848446, -0.00914691, -0.00858859>,
                         <-32.3028, -23.628, 27.3746>, <-0.0108284, -0.00914691, -0.00540481> }
        smooth_triangle {<-32.3603, -23.5658, 27.3508>, <-0.0102791, -0.00977569, -0.00541638>,
                         <-32.4177, -23.4725, 27.327>, <-0.0116211, -0.0101435, -0.00523965>,
                         <-32.3197, -23.4725, 27.1803>, <-0.00873133, -0.0101435, -0.00928799> }
        smooth_triangle {<-32.3197, -23.4725, 27.1803>, <-0.00949938, -0.00992813, -0.00893771>,
                         <-32.2757, -23.5658, 27.2243>, <-0.00851883, -0.0096523, -0.00867502>,
                         <-32.3603, -23.5658, 27.3508>, <-0.0106602, -0.0096523, -0.006034> }
        smooth_triangle {<-32.4177, -23.4725, 27.327>, <-0.0116211, -0.0101435, -0.00523965>,
                         <-32.4608, -23.4414, 27.3091>, <-0.00548468, -0.00890489, -0.00227183>,
                         <-32.3527, -23.4414, 27.1473>, <-0.00419779, -0.00890489, -0.0041978> }
        smooth_triangle {<-32.3527, -23.4414, 27.1473>, <-0.00431923, -0.00862727, -0.00381463>,
                         <-32.3197, -23.4725, 27.1803>, <-0.00768902, -0.00962561, -0.00772807>,
                         <-32.4177, -23.4725, 27.327>, <-0.00985631, -0.00962561, -0.00469181> }
        smooth_triangle {<-32.0012, -24.0012, 27.5>, <-0.00149482, -0.00597929, -0.000297338>,
                         <-32.1256, -23.9701, 27.5>, <-0.00341673, -0.00600302, -0.000481406>,
                         <-32.116, -23.9701, 27.4519>, <-0.00297242, -0.00600302, -0.00175229> }
        smooth_triangle {<-32.116, -23.9701, 27.4519>, <-0.00223288, -0.0045165, -0.00131492>,
                         <-32.0011, -24.0012, 27.4995>, <-0.00064074, -0.00301812, -0.00042479>,
                         <-32.0012, -24.0012, 27.5>, <-0.000754526, -0.00301812, -0.000150085> }
        smooth_triangle {<-32.1256, -23.9701, 27.5>, <-0.00341673, -0.00600302, -0.000481406>,
                         <-32.2033, -23.8768, 27.5>, <-0.00880759, -0.00552137, -0.000789128>,
                         <-32.1879, -23.8768, 27.4222>, <-0.00783517, -0.00552137, -0.00409958> }
        smooth_triangle {<-32.1879, -23.8768, 27.4222>, <-0.00699749, -0.00507529, -0.00329769>,
                         <-32.116, -23.9701, 27.4519>, <-0.00335043, -0.00543653, -0.00153722>,
                         <-32.1256, -23.9701, 27.5>, <-0.00368367, -0.00543653, -0.000584058> }
        smooth_triangle {<-32.2033, -23.8768, 27.5>, <-0.00880759, -0.00552137, -0.000789128>,
                         <-32.25, -23.7524, 27.5>, <-0.0131355, -0.00622607, -0.00103455>,
                         <-32.231, -23.7524, 27.4043>, <-0.0117397, -0.00622607, -0.00598252> }
        smooth_triangle {<-32.231, -23.7524, 27.4043>, <-0.0112249, -0.00557713, -0.0049683>,
                         <-32.1879, -23.8768, 27.4222>, <-0.00829656, -0.0050486, -0.00355609>,
                         <-32.2033, -23.8768, 27.5>, <-0.00902588, -0.0050486, -0.00107325> }
        smooth_triangle {<-32.25, -23.7524, 27.5>, <-0.0131355, -0.00622607, -0.00103455>,
                         <-32.3278, -23.628, 27.5>, <-0.0134961, -0.00959536, -0.000615444>,
                         <-32.3028, -23.628, 27.3746>, <-0.0122333, -0.00959536, -0.00573334> }
        smooth_triangle {<-32.3028, -23.628, 27.3746>, <-0.0121504, -0.00905616, -0.00489185>,
                         <-32.231, -23.7524, 27.4043>, <-0.0117802, -0.00652919, -0.00507874>,
                         <-32.25, -23.7524, 27.5>, <-0.012827, -0.00652919, -0.00136776> }
        smooth_triangle {<-32.3278, -23.628, 27.5>, <-0.0134961, -0.00959536, -0.000615444>,
                         <-32.39, -23.5658, 27.5>, <-0.0115695, -0.00977569, -0.00107042>,
                         <-32.3603, -23.5658, 27.3508>, <-0.0102791, -0.00977569, -0.00541638> }
        smooth_triangle {<-32.3603, -23.5658, 27.3508>, <-0.00965975, -0.00928216, -0.00445024>,
                         <-32.3028, -23.628, 27.3746>, <-0.0111253, -0.00914691, -0.00468796>,
                         <-32.3278, -23.628, 27.5>, <-0.0120725, -0.00914691, -0.000849539> }
        smooth_triangle {<-32.39, -23.5658, 27.5>, <-0.0115695, -0.00977569, -0.00107042>,
                         <-32.4522, -23.4725, 27.5>, <-0.0127416, -0.0101435, -0.00039362>,
                         <-32.4177, -23.4725, 27.327>, <-0.0116211, -0.0101435, -0.00523965> }
        smooth_triangle {<-32.4177, -23.4725, 27.327>, <-0.0121966, -0.00992814, -0.00462211>,
                         <-32.3603, -23.5658, 27.3508>, <-0.0111902, -0.0096523, -0.00475466>,
                         <-32.39, -23.5658, 27.5>, <-0.0121579, -0.00965231, -0.00149519> }
        smooth_triangle {<-32.4522, -23.4725, 27.5>, <-0.0127416, -0.0101435, -0.00039362>,
                         <-32.4988, -23.4414, 27.5>, <-0.00593658, -0.00890489, 2.80808e-17>,
                         <-32.4608, -23.4414, 27.3091>, <-0.00548468, -0.00890489, -0.00227183> }
        smooth_triangle {<-32.4608, -23.4414, 27.3091>, <-0.00545024, -0.00862728, -0.00187136>,
                         <-32.4177, -23.4725, 27.327>, <-0.0100611, -0.00962561, -0.00419734>,
                         <-32.4522, -23.4725, 27.5>, <-0.0109015, -0.00962561, -0.00056282> }
        smooth_triangle {<-32.0011, -24.0012, 27.5005>, <-0.00149482, -0.00597929, 0.000297338>,
                         <-32.116, -23.9701, 27.5481>, <-0.00334087, -0.00600302, 0.000862767>,
                         <-32.1256, -23.9701, 27.5>, <-0.00341673, -0.00600302, -0.000481406> }
        smooth_triangle {<-32.1256, -23.9701, 27.5>, <-0.00256611, -0.0045165, -0.000360346>,
                         <-32.0012, -24.0012, 27.5>, <-0.000754526, -0.00301812, -0.000147253>,
                         <-32.0011, -24.0012, 27.5005>, <-0.000754526, -0.00301812, 0.000150085> }
        smooth_triangle {<-32.116, -23.9701, 27.5481>, <-0.00334087, -0.00600302, 0.000862767>,
                         <-32.1879, -23.8768, 27.5778>, <-0.00843914, -0.00552137, 0.00264146>,
                         <-32.2033, -23.8768, 27.5>, <-0.00880759, -0.00552137, -0.000789128> }
        smooth_triangle {<-32.2033, -23.8768, 27.5>, <-0.00772681, -0.00507529, -0.000368842>,
                         <-32.1256, -23.9701, 27.5>, <-0.00368367, -0.00543653, -0.00013805>,
                         <-32.116, -23.9701, 27.5481>, <-0.00362677, -0.00543653, 0.00087008> }
        smooth_triangle {<-32.1879, -23.8768, 27.5778>, <-0.00843914, -0.00552137, 0.00264146>,
                         <-32.231, -23.7524, 27.5957>, <-0.0125315, -0.00622607, 0.00407092>,
                         <-32.25, -23.7524, 27.5>, <-0.0131355, -0.00622607, -0.00103455> }
        smooth_triangle {<-32.25, -23.7524, 27.5>, <-0.0122718, -0.00557713, -0.000294507>,
                         <-32.2033, -23.8768, 27.5>, <-0.00902588, -0.0050486, -0.00011044>,
                         <-32.1879, -23.8768, 27.5778>, <-0.00874954, -0.0050486, 0.0024625> }
        smooth_triangle {<-32.231, -23.7524, 27.5957>, <-0.0125315, -0.00622607, 0.00407092>,
                         <-32.3028, -23.628, 27.6254>, <-0.0127043, -0.00959536, 0.00459614>,
                         <-32.3278, -23.628, 27.5>, <-0.0134961, -0.00959536, -0.000615444> }
        smooth_triangle {<-32.3278, -23.628, 27.5>, <-0.0130975, -0.00905616, 0.000130263>,
                         <-32.25, -23.7524, 27.5>, <-0.012827, -0.00652919, -0.000184067>,
                         <-32.231, -23.7524, 27.5957>, <-0.012374, -0.00652919, 0.00364504> }
        smooth_triangle {<-32.3028, -23.628, 27.6254>, <-0.0127043, -0.00959536, 0.00459614>,
                         <-32.3603, -23.5658, 27.6492>, <-0.0110984, -0.00977569, 0.0034385>,
                         <-32.39, -23.5658, 27.5>, <-0.0115695, -0.00977569, -0.00107042> }
        smooth_triangle {<-32.39, -23.5658, 27.5>, <-0.0106275, -0.00928216, -0.000414859>,
                         <-32.3278, -23.628, 27.5>, <-0.0120725, -0.00914691, -7.36267e-05>,
                         <-32.3028, -23.628, 27.6254>, <-0.0114786, -0.00914691, 0.00383506> }
        smooth_triangle {<-32.3603, -23.5658, 27.6492>, <-0.0110984, -0.00977569, 0.0034385>,
                         <-32.4177, -23.4725, 27.673>, <-0.0119223, -0.0101435, 0.00451234>,
                         <-32.4522, -23.4725, 27.5>, <-0.0127416, -0.0101435, -0.00039362> }
        smooth_triangle {<-32.4522, -23.4725, 27.5>, <-0.013037, -0.00992814, 0.00039716>,
                         <-32.39, -23.5658, 27.5>, <-0.0121579, -0.00965231, -0.00011044>,
                         <-32.3603, -23.5658, 27.6492>, <-0.0118046, -0.0096523, 0.00327125> }
        smooth_triangle {<-32.4177, -23.4725, 27.673>, <-0.0119223, -0.0101435, 0.00451234>,
                         <-32.4608, -23.4414, 27.6909>, <-0.00548468, -0.00890489, 0.00227183>,
                         <-32.4988, -23.4414, 27.5>, <-0.00593658, -0.00890489, 2.80808e-17> }
        smooth_triangle {<-32.4988, -23.4414, 27.5>, <-0.0057515, -0.00862728, 0.000356806>,
                         <-32.4522, -23.4725, 27.5>, <-0.0109015, -0.00962561, -2.761e-05>,
                         <-32.4177, -23.4725, 27.673>, <-0.0102871, -0.00962561, 0.00365186> }
        smooth_triangle {<-32.0008, -24.0012, 27.5008>, <-0.00126724, -0.00597929, 0.000846747>,
                         <-32.0888, -23.9701, 27.5888>, <-0.0027564, -0.00600302, 0.00207559>,
                         <-32.116, -23.9701, 27.5481>, <-0.00334087, -0.00600302, 0.000862767> }
        smooth_triangle {<-32.116, -23.9701, 27.5481>, <-0.00250867, -0.0045165, 0.000649092>,
                         <-32.0011, -24.0012, 27.5005>, <-0.000753443, -0.00301812, 0.000152701>,
                         <-32.0008, -24.0012, 27.5008>, <-0.000639656, -0.00301812, 0.000427406> }
        smooth_triangle {<-32.0888, -23.9701, 27.5888>, <-0.0027564, -0.00600302, 0.00207559>,
                         <-32.1438, -23.8768, 27.6438>, <-0.0067859, -0.00552136, 0.00566991>,
                         <-32.1879, -23.8768, 27.5778>, <-0.00843914, -0.00552137, 0.00264146> }
        smooth_triangle {<-32.1879, -23.8768, 27.5778>, <-0.00727979, -0.00507529, 0.00261616>,
                         <-32.116, -23.9701, 27.5481>, <-0.00345609, -0.00543653, 0.00128214>,
                         <-32.0888, -23.9701, 27.5888>, <-0.00301774, -0.00543653, 0.00219176> }
        smooth_triangle {<-32.1438, -23.8768, 27.6438>, <-0.0067859, -0.00552136, 0.00566991>,
                         <-32.1768, -23.7524, 27.6768>, <-0.0100197, -0.00622607, 0.00855664>,
                         <-32.231, -23.7524, 27.5957>, <-0.0125315, -0.00622607, 0.00407092> }
        smooth_triangle {<-32.231, -23.7524, 27.5957>, <-0.0114504, -0.00557713, 0.00442412>,
                         <-32.1879, -23.8768, 27.5778>, <-0.00838109, -0.0050486, 0.00335202>,
                         <-32.1438, -23.8768, 27.6438>, <-0.00714116, -0.0050486, 0.00562336> }
        smooth_triangle {<-32.1768, -23.7524, 27.6768>, <-0.0100197, -0.00622607, 0.00855664>,
                         <-32.2318, -23.628, 27.7318>, <-0.00997838, -0.00959536, 0.00910801>,
                         <-32.3028, -23.628, 27.6254>, <-0.0127043, -0.00959536, 0.00459614> }
        smooth_triangle {<-32.3028, -23.628, 27.6254>, <-0.0120507, -0.00905616, 0.00513254>,
                         <-32.231, -23.7524, 27.5957>, <-0.011921, -0.00652919, 0.00473863>,
                         <-32.1768, -23.7524, 27.6768>, <-0.0100372, -0.00652919, 0.00810291> }
        smooth_triangle {<-32.2318, -23.628, 27.7318>, <-0.00997838, -0.00959536, 0.00910801>,
                         <-32.2757, -23.5658, 27.7757>, <-0.00893774, -0.00977569, 0.00742394>,
                         <-32.3603, -23.5658, 27.6492>, <-0.0110984, -0.00977569, 0.0034385> }
        smooth_triangle {<-32.3603, -23.5658, 27.6492>, <-0.00997727, -0.00928216, 0.00368368>,
                         <-32.3028, -23.628, 27.6254>, <-0.0111817, -0.00914691, 0.00455191>,
                         <-32.2318, -23.628, 27.7318>, <-0.00913724, -0.00914691, 0.00793582> }
        smooth_triangle {<-32.2757, -23.5658, 27.7757>, <-0.00893774, -0.00977569, 0.00742394>,
                         <-32.3197, -23.4725, 27.8197>, <-0.00935954, -0.00983382, 0.00625385>,
                         <-32.4177, -23.4725, 27.673>, <-0.0119223, -0.0101435, 0.00451234> }
        smooth_triangle {<-32.4177, -23.4725, 27.673>, <-0.0118926, -0.00992814, 0.00535597>,
                         <-32.3603, -23.5658, 27.6492>, <-0.0112747, -0.0096523, 0.00455059>,
                         <-32.2757, -23.5658, 27.7757>, <-0.00965418, -0.0096523, 0.00753967> }
        smooth_triangle {<-32.3197, -23.4725, 27.8197>, <-0.00935954, -0.00983382, 0.00625385>,
                         <-32.3527, -23.4414, 27.8527>, <-0.00419779, -0.00890489, 0.0041978>,
                         <-32.4608, -23.4414, 27.6909>, <-0.00548468, -0.00890489, 0.00227183> }
        smooth_triangle {<-32.4608, -23.4414, 27.6909>, <-0.00517715, -0.00862728, 0.00253065>,
                         <-32.4177, -23.4725, 27.673>, <-0.0100823, -0.00962561, 0.00414633>,
                         <-32.3197, -23.4725, 27.8197>, <-0.00776039, -0.00924656, 0.00518533> }
        smooth_triangle {<-32.0005, -24.0012, 27.5011>, <-0.000846744, -0.00597929, 0.00126725>,
                         <-32.0481, -23.9701, 27.616>, <-0.00175229, -0.00600302, 0.00297243>,
                         <-32.0888, -23.9701, 27.5888>, <-0.0027564, -0.00600302, 0.00207559> }
        smooth_triangle {<-32.0888, -23.9701, 27.5888>, <-0.00206932, -0.0045165, 0.00155971>,
                         <-32.0008, -24.0012, 27.5008>, <-0.000637654, -0.00301812, 0.000429408>,
                         <-32.0005, -24.0012, 27.5011>, <-0.000427404, -0.00301812, 0.000639658> }
        smooth_triangle {<-32.0481, -23.9701, 27.616>, <-0.00175229, -0.00600302, 0.00297243>,
                         <-32.0778, -23.8768, 27.6879>, <-0.00409958, -0.00552136, 0.00783517>,
                         <-32.1438, -23.8768, 27.6438>, <-0.0067859, -0.00552136, 0.00566991> }
        smooth_triangle {<-32.1438, -23.8768, 27.6438>, <-0.00572449, -0.00507529, 0.00520287>,
                         <-32.0888, -23.9701, 27.5888>, <-0.00270236, -0.00543653, 0.00250713>,
                         <-32.0481, -23.9701, 27.616>, <-0.00194928, -0.00543653, 0.00317976> }
        smooth_triangle {<-32.0778, -23.8768, 27.6879>, <-0.00409958, -0.00552136, 0.00783517>,
                         <-32.0957, -23.7524, 27.731>, <-0.00598252, -0.00622607, 0.0117397>,
                         <-32.1768, -23.7524, 27.6768>, <-0.0100197, -0.00622607, 0.00855664> }
        smooth_triangle {<-32.1768, -23.7524, 27.6768>, <-0.00888571, -0.00557713, 0.00846922>,
                         <-32.1438, -23.8768, 27.6438>, <-0.00646035, -0.0050486, 0.00630417>,
                         <-32.0778, -23.8768, 27.6879>, <-0.00444561, -0.0050486, 0.00792811> }
        smooth_triangle {<-32.0957, -23.7524, 27.731>, <-0.00598252, -0.00622607, 0.0117397>,
                         <-32.1254, -23.628, 27.8028>, <-0.00573333, -0.00959536, 0.0122333>,
                         <-32.2318, -23.628, 27.7318>, <-0.00997838, -0.00959536, 0.00910801> }
        smooth_triangle {<-32.2318, -23.628, 27.7318>, <-0.00916922, -0.00905615, 0.00935344>,
                         <-32.1768, -23.7524, 27.6768>, <-0.00920022, -0.00652919, 0.00893991>,
                         <-32.0957, -23.7524, 27.731>, <-0.00617232, -0.00652919, 0.0113272> }
        smooth_triangle {<-32.1254, -23.628, 27.8028>, <-0.00573333, -0.00959536, 0.0122333>,
                         <-32.1492, -23.5658, 27.8603>, <-0.00541637, -0.00977568, 0.0102792>,
                         <-32.2757, -23.5658, 27.7757>, <-0.00893774, -0.00977569, 0.00742394> }
        smooth_triangle {<-32.2757, -23.5658, 27.7757>, <-0.00780811, -0.00928215, 0.00722141>,
                         <-32.2318, -23.628, 27.7318>, <-0.00858859, -0.00914691, 0.00848447>,
                         <-32.1254, -23.628, 27.8028>, <-0.0054048, -0.00914691, 0.0108284> }
        smooth_triangle {<-32.1492, -23.5658, 27.8603>, <-0.00541637, -0.00977568, 0.0102792>,
                         <-32.173, -23.4725, 27.9177>, <-0.00523965, -0.0101435, 0.0116211>,
                         <-32.3197, -23.4725, 27.8197>, <-0.00914489, -0.0107627, 0.0136863> }
        smooth_triangle {<-32.3197, -23.4725, 27.8197>, <-0.00851587, -0.0100225, 0.0127449>,
                         <-32.2757, -23.5658, 27.7757>, <-0.00867502, -0.0096523, 0.00851884>,
                         <-32.1492, -23.5658, 27.8603>, <-0.00603399, -0.0096523, 0.0106602> }
        smooth_triangle {<-32.173, -23.4725, 27.9177>, <-0.00523965, -0.0101435, 0.0116211>,
                         <-32.1909, -23.4414, 27.9608>, <-0.00227183, -0.00890488, 0.00548469>,
                         <-32.3527, -23.4414, 27.8527>, <-0.00419779, -0.00890489, 0.0041978> }
        smooth_triangle {<-32.3527, -23.4414, 27.8527>, <-0.00381463, -0.00862727, 0.00431923>,
                         <-32.3197, -23.4725, 27.8197>, <-0.00609659, -0.0094174, 0.0091242>,
                         <-32.173, -23.4725, 27.9177>, <-0.00469181, -0.00962561, 0.00985632> }
        smooth_triangle {<-32, -24.0012, 27.5012>, <-0.000297335, -0.00597929, 0.00149482>,
                         <-32, -23.9701, 27.6256>, <-0.000481402, -0.00600302, 0.00341674>,
                         <-32.0481, -23.9701, 27.616>, <-0.00175229, -0.00600302, 0.00297243> }
        smooth_triangle {<-32.0481, -23.9701, 27.616>, <-0.00131492, -0.0045165, 0.00223288>,
                         <-32.0005, -24.0012, 27.5011>, <-0.000424788, -0.00301812, 0.000640742>,
                         <-32, -24.0012, 27.5012>, <-0.000150083, -0.00301812, 0.000754528> }
        smooth_triangle {<-32, -23.9701, 27.6256>, <-0.000481402, -0.00600302, 0.00341674>,
                         <-32, -23.8768, 27.7033>, <-0.000789125, -0.00552136, 0.00880759>,
                         <-32.0778, -23.8768, 27.6879>, <-0.00409958, -0.00552136, 0.00783517> }
        smooth_triangle {<-32.0778, -23.8768, 27.6879>, <-0.00329769, -0.00507529, 0.00699749>,
                         <-32.0481, -23.9701, 27.616>, <-0.00153722, -0.00543653, 0.00335044>,
                         <-32, -23.9701, 27.6256>, <-0.000584055, -0.00543653, 0.00368367> }
        smooth_triangle {<-32, -23.8768, 27.7033>, <-0.000789125, -0.00552136, 0.00880759>,
                         <-32, -23.7524, 27.75>, <-0.00103455, -0.00622607, 0.0131355>,
                         <-32.0957, -23.7524, 27.731>, <-0.00598252, -0.00622607, 0.0117397> }
        smooth_triangle {<-32.0957, -23.7524, 27.731>, <-0.0049683, -0.00557713, 0.011225>,
                         <-32.0778, -23.8768, 27.6879>, <-0.00355609, -0.0050486, 0.00829657>,
                         <-32, -23.8768, 27.7033>, <-0.00107325, -0.00504859, 0.00902588> }
        smooth_triangle {<-32, -23.7524, 27.75>, <-0.00103455, -0.00622607, 0.0131355>,
                         <-32, -23.628, 27.8278>, <-0.000615439, -0.00959535, 0.0134961>,
                         <-32.1254, -23.628, 27.8028>, <-0.00573333, -0.00959536, 0.0122333> }
        smooth_triangle {<-32.1254, -23.628, 27.8028>, <-0.00489184, -0.00905615, 0.0121504>,
                         <-32.0957, -23.7524, 27.731>, <-0.00507874, -0.00652919, 0.0117802>,
                         <-32, -23.7524, 27.75>, <-0.00136776, -0.00652918, 0.012827> }
        smooth_triangle {<-32, -23.628, 27.8278>, <-0.000615439, -0.00959535, 0.0134961>,
                         <-32, -23.5658, 27.89>, <-0.00107041, -0.00977568, 0.0115695>,
                         <-32.1492, -23.5658, 27.8603>, <-0.00541637, -0.00977568, 0.0102792> }
        smooth_triangle {<-32.1492, -23.5658, 27.8603>, <-0.00445023, -0.00928215, 0.00965975>,
                         <-32.1254, -23.628, 27.8028>, <-0.00468795, -0.00914691, 0.0111253>,
                         <-32, -23.628, 27.8278>, <-0.000849534, -0.00914691, 0.0120725> }
        smooth_triangle {<-32, -23.5658, 27.89>, <-0.00107041, -0.00977568, 0.0115695>,
                         <-32, -23.4725, 27.9522>, <-0.000393614, -0.0101435, 0.0127416>,
                         <-32.173, -23.4725, 27.9177>, <-0.00523965, -0.0101435, 0.0116211> }
        smooth_triangle {<-32.173, -23.4725, 27.9177>, <-0.00462211, -0.00992813, 0.0121966>,
                         <-32.1492, -23.5658, 27.8603>, <-0.00475465, -0.0096523, 0.0111902>,
                         <-32, -23.5658, 27.89>, <-0.00149518, -0.0096523, 0.0121579> }
        smooth_triangle {<-32, -23.4725, 27.9522>, <-0.000393614, -0.0101435, 0.0127416>,
                         <-32, -23.4414, 27.9988>, <5.00152e-09, -0.00890488, 0.00593658>,
                         <-32.1909, -23.4414, 27.9608>, <-0.00227183, -0.00890488, 0.00548469> }
        smooth_triangle {<-32.1909, -23.4414, 27.9608>, <-0.00187136, -0.00862727, 0.00545024>,
                         <-32.173, -23.4725, 27.9177>, <-0.00419734, -0.00962561, 0.0100611>,
                         <-32, -23.4725, 27.9522>, <-0.000562814, -0.0096256, 0.0109015> }
        smooth_triangle {<-31.9995, -24.0012, 27.5011>, <0.000297341, -0.00597929, 0.00149482>,
                         <-31.9519, -23.9701, 27.616>, <0.000862771, -0.00600302, 0.00334088>,
                         <-32, -23.9701, 27.6256>, <-0.000481402, -0.00600302, 0.00341674> }
        smooth_triangle {<-32, -23.9701, 27.6256>, <-0.000360344, -0.0045165, 0.00256611>,
                         <-32, -24.0012, 27.5012>, <-0.000147251, -0.00301812, 0.000754528>,
                         <-31.9995, -24.0012, 27.5011>, <0.000150087, -0.00301812, 0.000754528> }
        smooth_triangle {<-31.9519, -23.9701, 27.616>, <0.000862771, -0.00600302, 0.00334088>,
                         <-31.9222, -23.8768, 27.6879>, <0.00264146, -0.00552136, 0.00843914>,
                         <-32, -23.8768, 27.7033>, <-0.000789125, -0.00552136, 0.00880759> }
        smooth_triangle {<-32, -23.8768, 27.7033>, <-0.000368839, -0.00507529, 0.00772681>,
                         <-32, -23.9701, 27.6256>, <-0.000138047, -0.00543653, 0.00368367>,
                         <-31.9519, -23.9701, 27.616>, <0.000870083, -0.00543653, 0.00362678> }
        smooth_triangle {<-31.9222, -23.8768, 27.6879>, <0.00264146, -0.00552136, 0.00843914>,
                         <-31.9043, -23.7524, 27.731>, <0.00407093, -0.00622606, 0.0125315>,
                         <-32, -23.7524, 27.75>, <-0.00103455, -0.00622607, 0.0131355> }
        smooth_triangle {<-32, -23.7524, 27.75>, <-0.000294504, -0.00557712, 0.0122718>,
                         <-32, -23.8768, 27.7033>, <-0.000110437, -0.00504859, 0.00902588>,
                         <-31.9222, -23.8768, 27.6879>, <0.0024625, -0.00504859, 0.00874955> }
        smooth_triangle {<-31.9043, -23.7524, 27.731>, <0.00407093, -0.00622606, 0.0125315>,
                         <-31.8746, -23.628, 27.8028>, <0.00459615, -0.00959535, 0.0127043>,
                         <-32, -23.628, 27.8278>, <-0.000615439, -0.00959535, 0.0134961> }
        smooth_triangle {<-32, -23.628, 27.8278>, <0.000130268, -0.00905615, 0.0130975>,
                         <-32, -23.7524, 27.75>, <-0.000184063, -0.00652918, 0.012827>,
                         <-31.9043, -23.7524, 27.731>, <0.00364504, -0.00652918, 0.012374> }
        smooth_triangle {<-31.8746, -23.628, 27.8028>, <0.00459615, -0.00959535, 0.0127043>,
                         <-31.8508, -23.5658, 27.8603>, <0.00343851, -0.00977568, 0.0110984>,
                         <-32, -23.5658, 27.89>, <-0.00107041, -0.00977568, 0.0115695> }
        smooth_triangle {<-32, -23.5658, 27.89>, <-0.000414853, -0.00928215, 0.0106275>,
                         <-32, -23.628, 27.8278>, <-7.36216e-05, -0.00914691, 0.0120725>,
                         <-31.8746, -23.628, 27.8028>, <0.00383507, -0.0091469, 0.0114786> }
        smooth_triangle {<-31.8508, -23.5658, 27.8603>, <0.00343851, -0.00977568, 0.0110984>,
                         <-31.827, -23.4725, 27.9177>, <0.00451234, -0.0101435, 0.0119223>,
                         <-32, -23.4725, 27.9522>, <-0.000393614, -0.0101435, 0.0127416> }
        smooth_triangle {<-32, -23.4725, 27.9522>, <0.000397165, -0.00992813, 0.013037>,
                         <-32, -23.5658, 27.89>, <-0.000110435, -0.0096523, 0.0121579>,
                         <-31.8508, -23.5658, 27.8603>, <0.00327126, -0.0096523, 0.0118046> }
        smooth_triangle {<-31.827, -23.4725, 27.9177>, <0.00451234, -0.0101435, 0.0119223>,
                         <-31.8091, -23.4414, 27.9608>, <0.00227184, -0.00890488, 0.00548469>,
                         <-32, -23.4414, 27.9988>, <5.00152e-09, -0.00890488, 0.00593658> }
        smooth_triangle {<-32, -23.4414, 27.9988>, <0.000356811, -0.00862727, 0.00575151>,
                         <-32, -23.4725, 27.9522>, <-2.76046e-05, -0.0096256, 0.0109015>,
                         <-31.827, -23.4725, 27.9177>, <0.00365186, -0.0096256, 0.0102871> }
        smooth_triangle {<-31.9992, -24.0012, 27.5008>, <0.000846751, -0.00597929, 0.00126725>,
                         <-31.9112, -23.9701, 27.5888>, <0.0020756, -0.00600302, 0.0027564>,
                         <-31.9519, -23.9701, 27.616>, <0.000862771, -0.00600302, 0.00334088> }
        smooth_triangle {<-31.9519, -23.9701, 27.616>, <0.000649094, -0.0045165, 0.00250868>,
                         <-31.9995, -24.0012, 27.5011>, <0.000152703, -0.00301812, 0.000753444>,
                         <-31.9992, -24.0012, 27.5008>, <0.000427408, -0.00301812, 0.000639658> }
        smooth_triangle {<-31.9112, -23.9701, 27.5888>, <0.0020756, -0.00600302, 0.0027564>,
                         <-31.8562, -23.8768, 27.6438>, <0.00566991, -0.00552136, 0.00678591>,
                         <-31.9222, -23.8768, 27.6879>, <0.00264146, -0.00552136, 0.00843914> }
        smooth_triangle {<-31.9222, -23.8768, 27.6879>, <0.00261616, -0.00507528, 0.00727979>,
                         <-31.9519, -23.9701, 27.616>, <0.00128214, -0.00543653, 0.0034561>,
                         <-31.9112, -23.9701, 27.5888>, <0.00219176, -0.00543653, 0.00301774> }
        smooth_triangle {<-31.8562, -23.8768, 27.6438>, <0.00566991, -0.00552136, 0.00678591>,
                         <-31.8232, -23.7524, 27.6768>, <0.00855664, -0.00622606, 0.0100197>,
                         <-31.9043, -23.7524, 27.731>, <0.00407093, -0.00622606, 0.0125315> }
        smooth_triangle {<-31.9043, -23.7524, 27.731>, <0.00442412, -0.00557712, 0.0114504>,
                         <-31.9222, -23.8768, 27.6879>, <0.00335203, -0.00504859, 0.00838109>,
                         <-31.8562, -23.8768, 27.6438>, <0.00562336, -0.00504859, 0.00714117> }
        smooth_triangle {<-31.8232, -23.7524, 27.6768>, <0.00855664, -0.00622606, 0.0100197>,
                         <-31.7682, -23.628, 27.7318>, <0.00910802, -0.00959535, 0.00997838>,
                         <-31.8746, -23.628, 27.8028>, <0.00459615, -0.00959535, 0.0127043> }
        smooth_triangle {<-31.8746, -23.628, 27.8028>, <0.00513255, -0.00905615, 0.0120507>,
                         <-31.9043, -23.7524, 27.731>, <0.00473863, -0.00652918, 0.011921>,
                         <-31.8232, -23.7524, 27.6768>, <0.00810292, -0.00652918, 0.0100372> }
        smooth_triangle {<-31.7682, -23.628, 27.7318>, <0.00910802, -0.00959535, 0.00997838>,
                         <-31.7243, -23.5658, 27.7757>, <0.00742395, -0.00977568, 0.00893774>,
                         <-31.8508, -23.5658, 27.8603>, <0.00343851, -0.00977568, 0.0110984> }
        smooth_triangle {<-31.8508, -23.5658, 27.8603>, <0.00368369, -0.00928215, 0.00997727>,
                         <-31.8746, -23.628, 27.8028>, <0.00455192, -0.0091469, 0.0111817>,
                         <-31.7682, -23.628, 27.7318>, <0.00793582, -0.0091469, 0.00913725> }
        smooth_triangle {<-31.7243, -23.5658, 27.7757>, <0.00742395, -0.00977568, 0.00893774>,
                         <-31.6803, -23.4725, 27.8197>, <0.00873134, -0.0101435, 0.00928799>,
                         <-31.827, -23.4725, 27.9177>, <0.00451234, -0.0101435, 0.0119223> }
        smooth_triangle {<-31.827, -23.4725, 27.9177>, <0.00535598, -0.00992813, 0.0118926>,
                         <-31.8508, -23.5658, 27.8603>, <0.0045506, -0.0096523, 0.0112747>,
                         <-31.7243, -23.5658, 27.7757>, <0.00753968, -0.00965229, 0.00965419> }
        smooth_triangle {<-31.6803, -23.4725, 27.8197>, <0.00873134, -0.0101435, 0.00928799>,
                         <-31.6473, -23.4414, 27.8527>, <0.0041978, -0.00890488, 0.0041978>,
                         <-31.8091, -23.4414, 27.9608>, <0.00227184, -0.00890488, 0.00548469> }
        smooth_triangle {<-31.8091, -23.4414, 27.9608>, <0.00253066, -0.00862727, 0.00517716>,
                         <-31.827, -23.4725, 27.9177>, <0.00414633, -0.0096256, 0.0100823>,
                         <-31.6803, -23.4725, 27.8197>, <0.00731058, -0.0096256, 0.00810652> }
        smooth_triangle {<-31.9989, -24.0012, 27.5005>, <0.00126725, -0.00597929, 0.000846747>,
                         <-31.884, -23.9701, 27.5481>, <0.00297243, -0.00600302, 0.00175229>,
                         <-31.9112, -23.9701, 27.5888>, <0.0020756, -0.00600302, 0.0027564> }
        smooth_triangle {<-31.9112, -23.9701, 27.5888>, <0.00155971, -0.0045165, 0.00206932>,
                         <-31.9992, -24.0012, 27.5008>, <0.00042941, -0.00301812, 0.000637656>,
                         <-31.9989, -24.0012, 27.5005>, <0.00063966, -0.00301812, 0.000427406> }
        smooth_triangle {<-31.884, -23.9701, 27.5481>, <0.00297243, -0.00600302, 0.00175229>,
                         <-31.8121, -23.8768, 27.5778>, <0.00783517, -0.00552136, 0.00409958>,
                         <-31.8562, -23.8768, 27.6438>, <0.00566991, -0.00552136, 0.00678591> }
        smooth_triangle {<-31.8562, -23.8768, 27.6438>, <0.00520287, -0.00507528, 0.00572449>,
                         <-31.9112, -23.9701, 27.5888>, <0.00250713, -0.00543653, 0.00270236>,
                         <-31.884, -23.9701, 27.5481>, <0.00317976, -0.00543653, 0.00194928> }
        smooth_triangle {<-31.8121, -23.8768, 27.5778>, <0.00783517, -0.00552136, 0.00409958>,
                         <-31.769, -23.7524, 27.5957>, <0.0117397, -0.00622606, 0.00598252>,
                         <-31.8232, -23.7524, 27.6768>, <0.00855664, -0.00622606, 0.0100197> }
        smooth_triangle {<-31.8232, -23.7524, 27.6768>, <0.00846922, -0.00557712, 0.00888571>,
                         <-31.8562, -23.8768, 27.6438>, <0.00630417, -0.00504859, 0.00646036>,
                         <-31.8121, -23.8768, 27.5778>, <0.00792812, -0.00504859, 0.00444561> }
        smooth_triangle {<-31.769, -23.7524, 27.5957>, <0.0117397, -0.00622606, 0.00598252>,
                         <-31.6972, -23.628, 27.6254>, <0.0122333, -0.00959535, 0.00573334>,
                         <-31.7682, -23.628, 27.7318>, <0.00910802, -0.00959535, 0.00997838> }
        smooth_triangle {<-31.7682, -23.628, 27.7318>, <0.00935345, -0.00905614, 0.00916922>,
                         <-31.8232, -23.7524, 27.6768>, <0.00893991, -0.00652918, 0.00920022>,
                         <-31.769, -23.7524, 27.5957>, <0.0113272, -0.00652918, 0.00617233> }
        smooth_triangle {<-31.6972, -23.628, 27.6254>, <0.0122333, -0.00959535, 0.00573334>,
                         <-31.6397, -23.5658, 27.6492>, <0.0102792, -0.00977567, 0.00541638>,
                         <-31.7243, -23.5658, 27.7757>, <0.00742395, -0.00977568, 0.00893774> }
        smooth_triangle {<-31.7243, -23.5658, 27.7757>, <0.00722142, -0.00928215, 0.00780811>,
                         <-31.7682, -23.628, 27.7318>, <0.00848447, -0.0091469, 0.00858859>,
                         <-31.6972, -23.628, 27.6254>, <0.0108284, -0.0091469, 0.00540481> }
        smooth_triangle {<-31.6397, -23.5658, 27.6492>, <0.0102792, -0.00977567, 0.00541638>,
                         <-31.5823, -23.4725, 27.673>, <0.0116211, -0.0101434, 0.00523965>,
                         <-31.6803, -23.4725, 27.8197>, <0.00873134, -0.0101435, 0.00928799> }
        smooth_triangle {<-31.6803, -23.4725, 27.8197>, <0.00949939, -0.00992812, 0.00893771>,
                         <-31.7243, -23.5658, 27.7757>, <0.00851884, -0.00965229, 0.00867502>,
                         <-31.6397, -23.5658, 27.6492>, <0.0106603, -0.00965229, 0.006034> }
        smooth_triangle {<-31.5823, -23.4725, 27.673>, <0.0116211, -0.0101434, 0.00523965>,
                         <-31.5392, -23.4414, 27.6909>, <0.00548469, -0.00890488, 0.00227183>,
                         <-31.6473, -23.4414, 27.8527>, <0.0041978, -0.00890488, 0.0041978> }
        smooth_triangle {<-31.6473, -23.4414, 27.8527>, <0.00431924, -0.00862727, 0.00381463>,
                         <-31.6803, -23.4725, 27.8197>, <0.00768903, -0.0096256, 0.00772807>,
                         <-31.5823, -23.4725, 27.673>, <0.00985633, -0.0096256, 0.00469181> }
        smooth_triangle {<-31.9988, -24.0012, 27.5>, <0.00149482, -0.00597929, 0.000297338>,
                         <-31.8744, -23.9701, 27.5>, <0.00341674, -0.00600302, 0.000481406>,
                         <-31.884, -23.9701, 27.5481>, <0.00297243, -0.00600302, 0.00175229> }
        smooth_triangle {<-31.884, -23.9701, 27.5481>, <0.00223288, -0.0045165, 0.00131492>,
                         <-31.9989, -24.0012, 27.5005>, <0.000640743, -0.00301812, 0.00042479>,
                         <-31.9988, -24.0012, 27.5>, <0.00075453, -0.00301812, 0.000150085> }
        smooth_triangle {<-31.8744, -23.9701, 27.5>, <0.00341674, -0.00600302, 0.000481406>,
                         <-31.7967, -23.8768, 27.5>, <0.0088076, -0.00552136, 0.000789128>,
                         <-31.8121, -23.8768, 27.5778>, <0.00783517, -0.00552136, 0.00409958> }
        smooth_triangle {<-31.8121, -23.8768, 27.5778>, <0.0069975, -0.00507528, 0.00329769>,
                         <-31.884, -23.9701, 27.5481>, <0.00335044, -0.00543653, 0.00153722>,
                         <-31.8744, -23.9701, 27.5>, <0.00368367, -0.00543653, 0.000584058> }
        smooth_triangle {<-31.7967, -23.8768, 27.5>, <0.0088076, -0.00552136, 0.000789128>,
                         <-31.75, -23.7524, 27.5>, <0.0131355, -0.00622606, 0.00103455>,
                         <-31.769, -23.7524, 27.5957>, <0.0117397, -0.00622606, 0.00598252> }
        smooth_triangle {<-31.769, -23.7524, 27.5957>, <0.011225, -0.00557712, 0.0049683>,
                         <-31.8121, -23.8768, 27.5778>, <0.00829657, -0.00504859, 0.00355609>,
                         <-31.7967, -23.8768, 27.5>, <0.00902589, -0.00504859, 0.00107325> }
        smooth_triangle {<-31.75, -23.7524, 27.5>, <0.0131355, -0.00622606, 0.00103455>,
                         <-31.6722, -23.628, 27.5>, <0.0134961, -0.00959535, 0.000615444>,
                         <-31.6972, -23.628, 27.6254>, <0.0122333, -0.00959535, 0.00573334> }
        smooth_triangle {<-31.6972, -23.628, 27.6254>, <0.0121504, -0.00905614, 0.00489185>,
                         <-31.769, -23.7524, 27.5957>, <0.0117802, -0.00652918, 0.00507874>,
                         <-31.75, -23.7524, 27.5>, <0.012827, -0.00652918, 0.00136776> }
        smooth_triangle {<-31.6722, -23.628, 27.5>, <0.0134961, -0.00959535, 0.000615444>,
                         <-31.61, -23.5658, 27.5>, <0.0115695, -0.00977567, 0.00107042>,
                         <-31.6397, -23.5658, 27.6492>, <0.0102792, -0.00977567, 0.00541638> }
        smooth_triangle {<-31.6397, -23.5658, 27.6492>, <0.00965976, -0.00928215, 0.00445024>,
                         <-31.6972, -23.628, 27.6254>, <0.0111253, -0.0091469, 0.00468796>,
                         <-31.6722, -23.628, 27.5>, <0.0120725, -0.0091469, 0.000849539> }
        smooth_triangle {<-31.61, -23.5658, 27.5>, <0.0115695, -0.00977567, 0.00107042>,
                         <-31.5478, -23.4725, 27.5>, <0.0127416, -0.0101434, 0.00039362>,
                         <-31.5823, -23.4725, 27.673>, <0.0116211, -0.0101434, 0.00523965> }
        smooth_triangle {<-31.5823, -23.4725, 27.673>, <0.0121966, -0.00992812, 0.00462211>,
                         <-31.6397, -23.5658, 27.6492>, <0.0111902, -0.00965229, 0.00475466>,
                         <-31.61, -23.5658, 27.5>, <0.0121579, -0.00965229, 0.00149519> }
        smooth_triangle {<-31.5478, -23.4725, 27.5>, <0.0127416, -0.0101434, 0.00039362>,
                         <-31.5012, -23.4414, 27.5>, <0.00593659, -0.00890488, 2.80808e-17>,
                         <-31.5392, -23.4414, 27.6909>, <0.00548469, -0.00890488, 0.00227183> }
        smooth_triangle {<-31.5392, -23.4414, 27.6909>, <0.00545025, -0.00862727, 0.00187136>,
                         <-31.5823, -23.4725, 27.673>, <0.0100611, -0.0096256, 0.00419734>,
                         <-31.5478, -23.4725, 27.5>, <0.0109015, -0.0096256, 0.00056282> }
        texture { Water }
    }
    sphere { <0.0, 0.0, 0.0>, 0.25 
        texture { Water }
        translate <-32, -26, 27.5>
    }
    cone { <0.0, 0.0, 0.0>, 0.499, <0.0, 2, 0.0>, 1.99  
        texture { Water }
        translate <-39, -17.5, 27.5>
    }
    cone { <0.0, 0.0, 0.0>, 2.99, <0.0, 6, 0.0>, 2.99  
        texture { Water }
        translate <-30, -35, 27.5>
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 3, 0 
        texture { Glass }
        translate <-30, -35, 27.5>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 12, 0.0>, 3 open 
        texture { Glass }
        translate <-30, -35, 27.5>
    }
    merge { // Poly_Pipe
        cone { <-39, -17, 27.5>, 0.5, <-38.8318, -17.6122, 27.5>, 0.5 }
        sphere { <-38.8318, -17.6122, 27.5>, 0.5 }
        cone { <-38.8318, -17.6122, 27.5>, 0.5, <-38.5909, -18.1988, 27.5>, 0.5 }
        sphere { <-38.5909, -18.1988, 27.5>, 0.5 }
        cone { <-38.5909, -18.1988, 27.5>, 0.5, <-38.2135, -18.7065, 27.5>, 0.5 }
        sphere { <-38.2135, -18.7065, 27.5>, 0.5 }
        cone { <-38.2135, -18.7065, 27.5>, 0.5, <-37.7138, -19.0951, 27.5>, 0.5 }
        sphere { <-37.7138, -19.0951, 27.5>, 0.5 }
        cone { <-37.7138, -19.0951, 27.5>, 0.5, <-37.1539, -19.3936, 27.5>, 0.5 }
        sphere { <-37.1539, -19.3936, 27.5>, 0.5 }
        cone { <-37.1539, -19.3936, 27.5>, 0.5, <-36.5709, -19.6452, 27.5>, 0.5 }
        sphere { <-36.5709, -19.6452, 27.5>, 0.5 }
        cone { <-36.5709, -19.6452, 27.5>, 0.5, <-35.9797, -19.8771, 27.5>, 0.5 }
        sphere { <-35.9797, -19.8771, 27.5>, 0.5 }
        cone { <-35.9797, -19.8771, 27.5>, 0.5, <-35.3903, -20.1135, 27.5>, 0.5 }
        sphere { <-35.3903, -20.1135, 27.5>, 0.5 }
        cone { <-35.3903, -20.1135, 27.5>, 0.5, <-34.8104, -20.3723, 27.5>, 0.5 }
        sphere { <-34.8104, -20.3723, 27.5>, 0.5 }
        cone { <-34.8104, -20.3723, 27.5>, 0.5, <-34.2465, -20.6642, 27.5>, 0.5 }
        sphere { <-34.2465, -20.6642, 27.5>, 0.5 }
        cone { <-34.2465, -20.6642, 27.5>, 0.5, <-33.7069, -20.9987, 27.5>, 0.5 }
        sphere { <-33.7069, -20.9987, 27.5>, 0.5 }
        cone { <-33.7069, -20.9987, 27.5>, 0.5, <-33.1995, -21.3801, 27.5>, 0.5 }
        sphere { <-33.1995, -21.3801, 27.5>, 0.5 }
        cone { <-33.1995, -21.3801, 27.5>, 0.5, <-32.7335, -21.811, 27.5>, 0.5 }
        sphere { <-32.7335, -21.811, 27.5>, 0.5 }
        cone { <-32.7335, -21.811, 27.5>, 0.5, <-32.3278, -22.2984, 27.5>, 0.5 }
        sphere { <-32.3278, -22.2984, 27.5>, 0.5 }
        cone { <-32.3278, -22.2984, 27.5>, 0.5, <-32.0578, -22.8694, 27.5>, 0.5 }
        sphere { <-32.0578, -22.8694, 27.5>, 0.5 }
        cone { <-32.0578, -22.8694, 27.5>, 0.5, <-32, -23.5, 27.5>, 0.5 }
        texture { Green_iron }
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 5, 0.0>, 4 open 
        texture { Glass }
        translate <-39, -17.5, 27.5>
    }
}

union {  // Layer name: mecoparts
    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 0.5, 0.0>, 2.5  
        texture { Polished_Brass }
        translate <6, 2.5, 51.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        translate <8, 2.5, 51.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 336.038, .0>
        translate <7.82762, 2.5, 52.3123>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 291.038, .0>
        translate <6.71796, 2.5, 53.3667>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 315, .0>
        translate <7.41421, 2.5, 52.9142>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 225, .0>
        translate <4.58579, 2.5, 52.9142>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 201.038, .0>
        translate <4.13331, 2.5, 52.218>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 246.038, .0>
        translate <5.18772, 2.5, 53.3276>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 270, .0>
        translate <6, 2.5, 53.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 90, .0>
        translate <6, 2.5, 49.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 66.0375, .0>
        translate <6.81228, 2.5, 49.6724>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 21.0375, .0>
        translate <7.86669, 2.5, 50.782>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 45, .0>
        translate <7.41421, 2.5, 50.0858>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 135, .0>
        translate <4.58579, 2.5, 50.0858>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 111.038, .0>
        translate <5.28204, 2.5, 49.6333>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 156.038, .0>
        translate <4.17238, 2.5, 50.6877>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 180, .0>
        translate <4, 2.5, 51.5>
    }
    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 0.5, 0.0>, 2.5  
        texture { Polished_Brass }
        translate <-4, 2.5, 43>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        translate <-2, 2.5, 43>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 336.038, .0>
        translate <-2.17238, 2.5, 43.8123>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 291.038, .0>
        translate <-3.28204, 2.5, 44.8667>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 315, .0>
        translate <-2.58579, 2.5, 44.4142>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 225, .0>
        translate <-5.41421, 2.5, 44.4142>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 201.038, .0>
        translate <-5.86669, 2.5, 43.718>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 246.038, .0>
        translate <-4.81228, 2.5, 44.8276>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 270, .0>
        translate <-4, 2.5, 45>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 90, .0>
        translate <-4, 2.5, 41>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 66.0375, .0>
        translate <-3.18772, 2.5, 41.1724>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 21.0375, .0>
        translate <-2.13331, 2.5, 42.282>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 45, .0>
        translate <-2.58579, 2.5, 41.5858>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 135, .0>
        translate <-5.41421, 2.5, 41.5858>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 111.038, .0>
        translate <-4.71796, 2.5, 41.1333>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 156.038, .0>
        translate <-5.82762, 2.5, 42.1877>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 180, .0>
        translate <-6, 2.5, 43>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 180, .0>
        translate <1, 10.5, 30.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 156.038, .0>
        translate <1.08619, 10.5, 30.0939>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 111.038, .0>
        translate <1.64102, 10.5, 29.5667>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 135, .0>
        translate <1.29289, 10.5, 29.7929>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 45, .0>
        translate <2.70711, 10.5, 29.7929>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 21.0375, .0>
        translate <2.93335, 10.5, 30.141>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 66.0375, .0>
        translate <2.40614, 10.5, 29.5862>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 90, .0>
        translate <2, 10.5, 29.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 270, .0>
        translate <2, 10.5, 31.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 246.038, .0>
        translate <1.59386, 10.5, 31.4138>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 201.038, .0>
        translate <1.06665, 10.5, 30.859>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 225, .0>
        translate <1.29289, 10.5, 31.2071>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 315, .0>
        translate <2.70711, 10.5, 31.2071>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 291.038, .0>
        translate <2.35898, 10.5, 31.4333>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 336.038, .0>
        translate <2.91381, 10.5, 30.9061>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        translate <3, 10.5, 30.5>
    }
    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 0.5, 0.0>, 2.5  
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        translate <2, 10.5, 30.5>
    }
    merge { // Poly_Pipe
        cone { <-21.1228, -2.41832, 18.5>, 0.5, <-21.1732, -2.2995, 19.0787>, 0.5 }
        cone { <-21.1732, -2.2995, 19.0787>, 0.5, <-21.3668, -2.14705, 19.618>, 0.5 }
        sphere { <-21.1732, -2.2995, 19.0787>, 0.5 }
        cone { <-21.3668, -2.14705, 19.618>, 0.5, <-21.689, -1.96445, 20.0811>, 0.5 }
        sphere { <-21.3668, -2.14705, 19.618>, 0.5 }
        cone { <-21.689, -1.96445, 20.0811>, 0.5, <-22.116, -1.75723, 20.4365>, 0.5 }
        sphere { <-21.689, -1.96445, 20.0811>, 0.5 }
        cone { <-22.116, -1.75723, 20.4365>, 0.5, <-22.6173, -1.53259, 20.6599>, 0.5 }
        sphere { <-22.116, -1.75723, 20.4365>, 0.5 }
        cone { <-22.6173, -1.53259, 20.6599>, 0.5, <-23.1569, -1.29895, 20.7361>, 0.5 }
        sphere { <-22.6173, -1.53259, 20.6599>, 0.5 }
        cone { <-23.1569, -1.29895, 20.7361>, 0.5, <-23.6965, -1.0653, 20.6599>, 0.5 }
        sphere { <-23.1569, -1.29895, 20.7361>, 0.5 }
        cone { <-23.6965, -1.0653, 20.6599>, 0.5, <-24.1978, -0.840671, 20.4365>, 0.5 }
        sphere { <-23.6965, -1.0653, 20.6599>, 0.5 }
        cone { <-24.1978, -0.840671, 20.4365>, 0.5, <-24.6248, -0.633448, 20.0811>, 0.5 }
        sphere { <-24.1978, -0.840671, 20.4365>, 0.5 }
        cone { <-24.6248, -0.633448, 20.0811>, 0.5, <-24.947, -0.450843, 19.618>, 0.5 }
        sphere { <-24.6248, -0.633448, 20.0811>, 0.5 }
        cone { <-24.947, -0.450843, 19.618>, 0.5, <-25.1406, -0.298392, 19.0787>, 0.5 }
        sphere { <-24.947, -0.450843, 19.618>, 0.5 }
        cone { <-25.1406, -0.298392, 19.0787>, 0.5, <-25.191, -0.179572, 18.5>, 0.5 }
        sphere { <-25.1406, -0.298392, 19.0787>, 0.5 }
        cone { <-25.191, -0.179572, 18.5>, 0.5, <-25.093, -0.0955697, 17.9213>, 0.5 }
        sphere { <-25.191, -0.179572, 18.5>, 0.5 }
        cone { <-25.093, -0.0955697, 17.9213>, 0.5, <-24.8518, -0.0451986, 17.382>, 0.5 }
        sphere { <-25.093, -0.0955697, 17.9213>, 0.5 }
        cone { <-24.8518, -0.0451986, 17.382>, 0.5, <-24.482, -0.0249804, 16.9189>, 0.5 }
        sphere { <-24.8518, -0.0451986, 17.382>, 0.5 }
        cone { <-24.482, -0.0249804, 16.9189>, 0.5, <-24.0073, -0.0293821, 16.5635>, 0.5 }
        sphere { <-24.482, -0.0249804, 16.9189>, 0.5 }
        cone { <-24.0073, -0.0293821, 16.5635>, 0.5, <-23.4585, -0.0511925, 16.3401>, 0.5 }
        sphere { <-24.0073, -0.0293821, 16.5635>, 0.5 }
        cone { <-23.4585, -0.0511925, 16.3401>, 0.5, <-22.8713, -0.0820144, 16.2639>, 0.5 }
        sphere { <-23.4585, -0.0511925, 16.3401>, 0.5 }
        cone { <-22.8713, -0.0820144, 16.2639>, 0.5, <-22.2841, -0.112836, 16.3401>, 0.5 }
        sphere { <-22.8713, -0.0820144, 16.2639>, 0.5 }
        cone { <-22.2841, -0.112836, 16.3401>, 0.5, <-21.7352, -0.134647, 16.5635>, 0.5 }
        sphere { <-22.2841, -0.112836, 16.3401>, 0.5 }
        cone { <-21.7352, -0.134647, 16.5635>, 0.5, <-21.2606, -0.139048, 16.9189>, 0.5 }
        sphere { <-21.7352, -0.134647, 16.5635>, 0.5 }
        cone { <-21.2606, -0.139048, 16.9189>, 0.5, <-20.8908, -0.11883, 17.382>, 0.5 }
        sphere { <-21.2606, -0.139048, 16.9189>, 0.5 }
        cone { <-20.8908, -0.11883, 17.382>, 0.5, <-20.6495, -0.068459, 17.9213>, 0.5 }
        sphere { <-20.8908, -0.11883, 17.382>, 0.5 }
        cone { <-20.6495, -0.068459, 17.9213>, 0.5, <-20.5516, 0.0155434, 18.5>, 0.5 }
        sphere { <-20.6495, -0.068459, 17.9213>, 0.5 }
        cone { <-20.5516, 0.0155434, 18.5>, 0.5, <-20.6019, 0.134363, 19.0787>, 0.5 }
        sphere { <-20.5516, 0.0155434, 18.5>, 0.5 }
        cone { <-20.6019, 0.134363, 19.0787>, 0.5, <-20.7956, 0.286815, 19.618>, 0.5 }
        sphere { <-20.6019, 0.134363, 19.0787>, 0.5 }
        cone { <-20.7956, 0.286815, 19.618>, 0.5, <-21.1178, 0.469419, 20.0811>, 0.5 }
        sphere { <-20.7956, 0.286815, 19.618>, 0.5 }
        cone { <-21.1178, 0.469419, 20.0811>, 0.5, <-21.5448, 0.676643, 20.4365>, 0.5 }
        sphere { <-21.1178, 0.469419, 20.0811>, 0.5 }
        cone { <-21.5448, 0.676643, 20.4365>, 0.5, <-22.0461, 0.901276, 20.6599>, 0.5 }
        sphere { <-21.5448, 0.676643, 20.4365>, 0.5 }
        cone { <-22.0461, 0.901276, 20.6599>, 0.5, <-22.5857, 1.13492, 20.7361>, 0.5 }
        sphere { <-22.0461, 0.901276, 20.6599>, 0.5 }
        cone { <-22.5857, 1.13492, 20.7361>, 0.5, <-23.1253, 1.36856, 20.6599>, 0.5 }
        sphere { <-22.5857, 1.13492, 20.7361>, 0.5 }
        cone { <-23.1253, 1.36856, 20.6599>, 0.5, <-23.6265, 1.5932, 20.4365>, 0.5 }
        sphere { <-23.1253, 1.36856, 20.6599>, 0.5 }
        cone { <-23.6265, 1.5932, 20.4365>, 0.5, <-24.0536, 1.80042, 20.0811>, 0.5 }
        sphere { <-23.6265, 1.5932, 20.4365>, 0.5 }
        cone { <-24.0536, 1.80042, 20.0811>, 0.5, <-24.3757, 1.98302, 19.618>, 0.5 }
        sphere { <-24.0536, 1.80042, 20.0811>, 0.5 }
        cone { <-24.3757, 1.98302, 19.618>, 0.5, <-24.5694, 2.13548, 19.0787>, 0.5 }
        sphere { <-24.3757, 1.98302, 19.618>, 0.5 }
        cone { <-24.5694, 2.13548, 19.0787>, 0.5, <-24.6198, 2.2543, 18.5>, 0.5 }
        sphere { <-24.5694, 2.13548, 19.0787>, 0.5 }
        cone { <-24.6198, 2.2543, 18.5>, 0.5, <-24.5218, 2.3383, 17.9213>, 0.5 }
        sphere { <-24.6198, 2.2543, 18.5>, 0.5 }
        cone { <-24.5218, 2.3383, 17.9213>, 0.5, <-24.2805, 2.38867, 17.382>, 0.5 }
        sphere { <-24.5218, 2.3383, 17.9213>, 0.5 }
        cone { <-24.2805, 2.38867, 17.382>, 0.5, <-23.9108, 2.40889, 16.9189>, 0.5 }
        sphere { <-24.2805, 2.38867, 17.382>, 0.5 }
        cone { <-23.9108, 2.40889, 16.9189>, 0.5, <-23.4361, 2.40449, 16.5635>, 0.5 }
        sphere { <-23.9108, 2.40889, 16.9189>, 0.5 }
        cone { <-23.4361, 2.40449, 16.5635>, 0.5, <-22.8873, 2.38268, 16.3401>, 0.5 }
        sphere { <-23.4361, 2.40449, 16.5635>, 0.5 }
        cone { <-22.8873, 2.38268, 16.3401>, 0.5, <-22.3001, 2.35185, 16.2639>, 0.5 }
        sphere { <-22.8873, 2.38268, 16.3401>, 0.5 }
        cone { <-22.3001, 2.35185, 16.2639>, 0.5, <-21.7128, 2.32103, 16.3401>, 0.5 }
        sphere { <-22.3001, 2.35185, 16.2639>, 0.5 }
        cone { <-21.7128, 2.32103, 16.3401>, 0.5, <-21.164, 2.29922, 16.5635>, 0.5 }
        sphere { <-21.7128, 2.32103, 16.3401>, 0.5 }
        cone { <-21.164, 2.29922, 16.5635>, 0.5, <-20.6894, 2.29482, 16.9189>, 0.5 }
        sphere { <-21.164, 2.29922, 16.5635>, 0.5 }
        cone { <-20.6894, 2.29482, 16.9189>, 0.5, <-20.3196, 2.31504, 17.382>, 0.5 }
        sphere { <-20.6894, 2.29482, 16.9189>, 0.5 }
        cone { <-20.3196, 2.31504, 17.382>, 0.5, <-20.0783, 2.36541, 17.9213>, 0.5 }
        sphere { <-20.3196, 2.31504, 17.382>, 0.5 }
        cone { <-20.0783, 2.36541, 17.9213>, 0.5, <-19.9804, 2.44941, 18.5>, 0.5 }
        sphere { <-20.0783, 2.36541, 17.9213>, 0.5 }
        cone { <-19.9804, 2.44941, 18.5>, 0.5, <-20.0307, 2.56823, 19.0787>, 0.5 }
        sphere { <-19.9804, 2.44941, 18.5>, 0.5 }
        cone { <-20.0307, 2.56823, 19.0787>, 0.5, <-20.2244, 2.72068, 19.618>, 0.5 }
        sphere { <-20.0307, 2.56823, 19.0787>, 0.5 }
        cone { <-20.2244, 2.72068, 19.618>, 0.5, <-20.5466, 2.90329, 20.0811>, 0.5 }
        sphere { <-20.2244, 2.72068, 19.618>, 0.5 }
        cone { <-20.5466, 2.90329, 20.0811>, 0.5, <-20.9736, 3.11051, 20.4365>, 0.5 }
        sphere { <-20.5466, 2.90329, 20.0811>, 0.5 }
        cone { <-20.9736, 3.11051, 20.4365>, 0.5, <-21.4748, 3.33514, 20.6599>, 0.5 }
        sphere { <-20.9736, 3.11051, 20.4365>, 0.5 }
        cone { <-21.4748, 3.33514, 20.6599>, 0.5, <-22.0145, 3.56879, 20.7361>, 0.5 }
        sphere { <-21.4748, 3.33514, 20.6599>, 0.5 }
        cone { <-22.0145, 3.56879, 20.7361>, 0.5, <-22.5541, 3.80243, 20.6599>, 0.5 }
        sphere { <-22.0145, 3.56879, 20.7361>, 0.5 }
        cone { <-22.5541, 3.80243, 20.6599>, 0.5, <-23.0553, 4.02707, 20.4365>, 0.5 }
        sphere { <-22.5541, 3.80243, 20.6599>, 0.5 }
        cone { <-23.0553, 4.02707, 20.4365>, 0.5, <-23.4824, 4.23429, 20.0811>, 0.5 }
        sphere { <-23.0553, 4.02707, 20.4365>, 0.5 }
        cone { <-23.4824, 4.23429, 20.0811>, 0.5, <-23.8045, 4.41689, 19.618>, 0.5 }
        sphere { <-23.4824, 4.23429, 20.0811>, 0.5 }
        cone { <-23.8045, 4.41689, 19.618>, 0.5, <-23.9982, 4.56934, 19.0787>, 0.5 }
        sphere { <-23.8045, 4.41689, 19.618>, 0.5 }
        cone { <-23.9982, 4.56934, 19.0787>, 0.5, <-24.0486, 4.68816, 18.5>, 0.5 }
        sphere { <-23.9982, 4.56934, 19.0787>, 0.5 }
        cone { <-24.0486, 4.68816, 18.5>, 0.5, <-23.9506, 4.77217, 17.9213>, 0.5 }
        sphere { <-24.0486, 4.68816, 18.5>, 0.5 }
        cone { <-23.9506, 4.77217, 17.9213>, 0.5, <-23.7093, 4.82254, 17.382>, 0.5 }
        sphere { <-23.9506, 4.77217, 17.9213>, 0.5 }
        cone { <-23.7093, 4.82254, 17.382>, 0.5, <-23.3396, 4.84276, 16.9189>, 0.5 }
        sphere { <-23.7093, 4.82254, 17.382>, 0.5 }
        cone { <-23.3396, 4.84276, 16.9189>, 0.5, <-22.8649, 4.83835, 16.5635>, 0.5 }
        sphere { <-23.3396, 4.84276, 16.9189>, 0.5 }
        cone { <-22.8649, 4.83835, 16.5635>, 0.5, <-22.3161, 4.81654, 16.3401>, 0.5 }
        sphere { <-22.8649, 4.83835, 16.5635>, 0.5 }
        cone { <-22.3161, 4.81654, 16.3401>, 0.5, <-21.7289, 4.78572, 16.2639>, 0.5 }
        sphere { <-22.3161, 4.81654, 16.3401>, 0.5 }
        cone { <-21.7289, 4.78572, 16.2639>, 0.5, <-21.1416, 4.7549, 16.3401>, 0.5 }
        sphere { <-21.7289, 4.78572, 16.2639>, 0.5 }
        cone { <-21.1416, 4.7549, 16.3401>, 0.5, <-20.5928, 4.73309, 16.5635>, 0.5 }
        sphere { <-21.1416, 4.7549, 16.3401>, 0.5 }
        cone { <-20.5928, 4.73309, 16.5635>, 0.5, <-20.1181, 4.72869, 16.9189>, 0.5 }
        sphere { <-20.5928, 4.73309, 16.5635>, 0.5 }
        cone { <-20.1181, 4.72869, 16.9189>, 0.5, <-19.7484, 4.74891, 17.382>, 0.5 }
        sphere { <-20.1181, 4.72869, 16.9189>, 0.5 }
        cone { <-19.7484, 4.74891, 17.382>, 0.5, <-19.5071, 4.79928, 17.9213>, 0.5 }
        sphere { <-19.7484, 4.74891, 17.382>, 0.5 }
        texture { Shuttle_iron }
    }
    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 0.5, 0.0>, 2.5  
        texture { Polished_Brass }
        translate <1, 2.5, 19.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        translate <3, 2.5, 19.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 336.038, .0>
        translate <2.82762, 2.5, 20.3123>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 291.038, .0>
        translate <1.71796, 2.5, 21.3667>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 315, .0>
        translate <2.41421, 2.5, 20.9142>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 225, .0>
        translate <-0.414214, 2.5, 20.9142>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 201.038, .0>
        translate <-0.866691, 2.5, 20.218>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 246.038, .0>
        translate <0.187723, 2.5, 21.3276>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 270, .0>
        translate <1, 2.5, 21.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 90, .0>
        translate <1, 2.5, 17.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 66.0375, .0>
        translate <1.81228, 2.5, 17.6724>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 21.0375, .0>
        translate <2.86669, 2.5, 18.782>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 45, .0>
        translate <2.41421, 2.5, 18.0858>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 135, .0>
        translate <-0.414214, 2.5, 18.0858>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 111.038, .0>
        translate <0.282042, 2.5, 17.6333>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 156.038, .0>
        translate <-0.827623, 2.5, 18.6877>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 180, .0>
        translate <-1, 2.5, 19.5>
    }
    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 0.5, 0.0>, 2.5  
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        translate <9, 6.5, 21.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        translate <12, 6.5, 21.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 336.038, .0>
        translate <11.7414, 6.5, 22.7184>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 291.038, .0>
        translate <10.0769, 6.5, 24.3>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 315, .0>
        translate <11.1213, 6.5, 23.6213>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 225, .0>
        translate <6.87868, 6.5, 23.6213>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 201.038, .0>
        translate <6.19996, 6.5, 22.5769>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 246.038, .0>
        translate <7.78158, 6.5, 24.2414>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 270, .0>
        translate <9, 6.5, 24.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 90, .0>
        translate <9, 6.5, 18.5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 66.0375, .0>
        translate <10.2184, 6.5, 18.7586>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 21.0375, .0>
        translate <11.8, 6.5, 20.4231>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 45, .0>
        translate <11.1213, 6.5, 19.3787>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 135, .0>
        translate <6.87868, 6.5, 19.3787>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 111.038, .0>
        translate <7.92306, 6.5, 18.7>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 156.038, .0>
        translate <6.25857, 6.5, 20.2816>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <1.5, 1.5, 1.5>
        rotate <.0, 180, .0>
        translate <6, 6.5, 21.5>
    }
    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 0.5, 0.0>, 2.5  
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        translate <0.5, 10.5, 10>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        translate <1.5, 10.5, 10>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 336.038, .0>
        translate <1.41381, 10.5, 10.4061>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 291.038, .0>
        translate <0.858979, 10.5, 10.9333>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 315, .0>
        translate <1.20711, 10.5, 10.7071>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 225, .0>
        translate <-0.207107, 10.5, 10.7071>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 201.038, .0>
        translate <-0.433346, 10.5, 10.359>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 246.038, .0>
        translate <0.0938615, 10.5, 10.9138>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 270, .0>
        translate <0.5, 10.5, 11>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 90, .0>
        translate <0.5, 10.5, 9>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 66.0375, .0>
        translate <0.906138, 10.5, 9.08619>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 21.0375, .0>
        translate <1.43335, 10.5, 9.64102>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 45, .0>
        translate <1.20711, 10.5, 9.29289>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 135, .0>
        translate <-0.207107, 10.5, 9.29289>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 111.038, .0>
        translate <0.141021, 10.5, 9.06665>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 156.038, .0>
        translate <-0.413812, 10.5, 9.59386>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        scale <0.5, 0.5, 0.5>
        rotate <.0, 180, .0>
        translate <-0.5, 10.5, 10>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 180, .0>
        translate <9, 2.5, 3>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 156.038, .0>
        translate <9.17238, 2.5, 2.18772>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 111.038, .0>
        translate <10.282, 2.5, 1.13331>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 135, .0>
        translate <9.58579, 2.5, 1.58579>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 45, .0>
        translate <12.4142, 2.5, 1.58579>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 21.0375, .0>
        translate <12.8667, 2.5, 2.28204>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 66.0375, .0>
        translate <11.8123, 2.5, 1.17238>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 90, .0>
        translate <11, 2.5, 1>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 270, .0>
        translate <11, 2.5, 5>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 246.038, .0>
        translate <10.1877, 2.5, 4.82762>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 201.038, .0>
        translate <9.13331, 2.5, 3.71796>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 225, .0>
        translate <9.58579, 2.5, 4.41421>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 315, .0>
        translate <12.4142, 2.5, 4.41421>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 291.038, .0>
        translate <11.718, 2.5, 4.86669>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        rotate <.0, 336.038, .0>
        translate <12.8276, 2.5, 3.81228>
    }
    box { <0.0, 0.0, 0.0>, <1, 0.5, 0.5> 
        texture { Polished_Brass }
        translate <13, 2.5, 3>
    }
    cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 0.5, 0.0>, 2.5  
        texture { Polished_Brass }
        translate <11, 2.5, 3>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 15, 0.0>, 0.25  
        texture { Polished_Brass }
        rotate <.0, .0, -238.57>
        rotate <.0, 335.095, .0>
        translate <18.3606, 18.5663, 17.1589>
    }
    cone { <0.0, 0.0, 0.0>, 3, <0.0, 0.5, 0.0>, 3  
        texture { Polished_Brass }
        rotate <.0, .0, -328.57>
        rotate <.0, 335.095, .0>
        translate <5.33408, 9.31263, 11>
    }
}

union {  // Layer name: fireclock
    union { // Surface of Revolution
        smooth_triangle {<-15.2788, 3.46035, 14.75>, <0.00833959, 0.041907, 0.00391712>,
                         <-15.7383, 3.5677, 14.5796>, <0.0228785, 0.0789131, 0.0136639>,
                         <-15.7708, 3.55825, 14.75>, <0.022424, 0.0820576, -0.000999942> }
        smooth_triangle {<-15.7708, 3.55825, 14.75>, <0.0149493, 0.0547048, -0.000666647>,
                         <-15.2788, 3.46035, 14.75>, <-1.20808e-07, -6.07071e-07, 5.06695e-18>,
                         <-15.2788, 3.46035, 14.75>, <0.00555969, 0.0279378, 0.0026114> }
        smooth_triangle {<-15.7383, 3.5677, 14.5796>, <0.0228785, 0.0789131, 0.0136639>,
                         <-16.1799, 3.74168, 14.4241>, <0.0858868, 0.103008, 0.0422824>,
                         <-16.2421, 3.7236, 14.75>, <0.0538944, 0.153636, 0.0188156> }
        smooth_triangle {<-16.2421, 3.7236, 14.75>, <0.0410316, 0.116968, 0.014325>,
                         <-15.7708, 3.55825, 14.75>, <0.0243389, 0.0814719, 0.00261147>,
                         <-15.7383, 3.5677, 14.5796>, <0.0239365, 0.0791905, 0.012898> }
        smooth_triangle {<-16.1799, 3.74168, 14.4241>, <0.0858868, 0.103008, 0.0422824>,
                         <-16.4345, 4.15749, 14.3708>, <0.15149, 0.0712769, 0.0670531>,
                         <-16.5069, 4.13646, 14.75>, <0.156556, 0.100401, 0.0354741> }
        smooth_triangle {<-16.5069, 4.13646, 14.75>, <0.145562, 0.0933504, 0.0329831>,
                         <-16.2421, 3.7236, 14.75>, <0.0942317, 0.119968, 0.0246539>,
                         <-16.1799, 3.74168, 14.4241>, <0.0956233, 0.0996665, 0.0399244> }
        smooth_triangle {<-16.4345, 4.15749, 14.3708>, <0.15149, 0.0712769, 0.0670531>,
                         <-16.5822, 4.63689, 14.3674>, <0.169456, 0.0510013, 0.0732035>,
                         <-16.6552, 4.61567, 14.75>, <0.183336, 0.0567438, 0.0381687> }
        smooth_triangle {<-16.6552, 4.61567, 14.75>, <0.182527, 0.0564933, 0.0380002>,
                         <-16.5069, 4.13646, 14.75>, <0.169137, 0.0783216, 0.0366529>,
                         <-16.4345, 4.15749, 14.3708>, <0.157535, 0.0682701, 0.0612088> }
        smooth_triangle {<-16.5822, 4.63689, 14.3674>, <0.169456, 0.0510013, 0.0732035>,
                         <-16.7223, 5.1186, 14.3673>, <0.170313, 0.0494993, 0.0734622>,
                         <-16.7954, 5.09738, 14.75>, <0.184343, 0.0536264, 0.0381882> }
        smooth_triangle {<-16.7954, 5.09738, 14.75>, <0.184318, 0.0536192, 0.038183>,
                         <-16.6552, 4.61567, 14.75>, <0.183815, 0.0551779, 0.0381733>,
                         <-16.5822, 4.63689, 14.3674>, <0.172423, 0.0515234, 0.0661984> }
        smooth_triangle {<-16.7223, 5.1186, 14.3673>, <0.170313, 0.0494993, 0.0734622>,
                         <-16.8621, 5.60039, 14.3673>, <0.170338, 0.0494529, 0.0734695>,
                         <-16.9352, 5.57917, 14.75>, <0.184372, 0.0535274, 0.0381882> }
        smooth_triangle {<-16.9352, 5.57917, 14.75>, <0.184372, 0.0535274, 0.0381882>,
                         <-16.7954, 5.09738, 14.75>, <0.184358, 0.0535769, 0.0381882>,
                         <-16.7223, 5.1186, 14.3673>, <0.173125, 0.0503049, 0.0664074> }
        smooth_triangle {<-16.8621, 5.60039, 14.3673>, <0.170338, 0.0494529, 0.0734695>,
                         <-17.002, 6.08218, 14.3673>, <0.170338, 0.0494529, 0.0734695>,
                         <-17.0751, 6.06096, 14.75>, <0.184372, 0.0535274, 0.0381882> }
        smooth_triangle {<-17.0751, 6.06096, 14.75>, <0.184372, 0.0535274, 0.0381882>,
                         <-16.9352, 5.57917, 14.75>, <0.184372, 0.0535274, 0.0381882>,
                         <-16.8621, 5.60039, 14.3673>, <0.173145, 0.0502678, 0.0664133> }
        smooth_triangle {<-17.002, 6.08218, 14.3673>, <0.170338, 0.0494529, 0.0734695>,
                         <-17.1419, 6.56397, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.215, 6.54275, 14.75>, <0.184372, 0.0535274, 0.0381882> }
        smooth_triangle {<-17.215, 6.54275, 14.75>, <0.184372, 0.0535274, 0.0381882>,
                         <-17.0751, 6.06096, 14.75>, <0.184372, 0.0535274, 0.0381882>,
                         <-17.002, 6.08218, 14.3673>, <0.173145, 0.0502678, 0.0664133> }
        smooth_triangle {<-17.1419, 6.56397, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.2818, 7.04576, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.3549, 7.02454, 14.75>, <0.184372, 0.0535274, 0.0381882> }
        smooth_triangle {<-17.3549, 7.02454, 14.75>, <0.184372, 0.0535274, 0.0381882>,
                         <-17.215, 6.54275, 14.75>, <0.184372, 0.0535274, 0.0381882>,
                         <-17.1419, 6.56397, 14.3673>, <0.173145, 0.0502678, 0.0664133> }
        smooth_triangle {<-17.2818, 7.04576, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.4216, 7.52755, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.4947, 7.50633, 14.75>, <0.184372, 0.0535275, 0.0381883> }
        smooth_triangle {<-17.4947, 7.50633, 14.75>, <0.184372, 0.0535275, 0.0381882>,
                         <-17.3549, 7.02454, 14.75>, <0.184372, 0.0535274, 0.0381882>,
                         <-17.2818, 7.04576, 14.3673>, <0.173145, 0.0502678, 0.0664133> }
        smooth_triangle {<-17.4216, 7.52755, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.5615, 8.00934, 14.3673>, <0.17034, 0.0493998, 0.073467>,
                         <-17.6346, 7.98811, 14.75>, <0.184372, 0.0535275, 0.0381883> }
        smooth_triangle {<-17.6346, 7.98811, 14.75>, <0.184372, 0.0535275, 0.0381883>,
                         <-17.4947, 7.50633, 14.75>, <0.184372, 0.0535275, 0.0381883>,
                         <-17.4216, 7.52755, 14.3673>, <0.173145, 0.0502678, 0.0664133> }
        smooth_triangle {<-17.5615, 8.00934, 14.3673>, <0.17034, 0.0493998, 0.073467>,
                         <-17.7011, 8.4912, 14.3674>, <0.170358, 0.0476544, 0.0733641>,
                         <-17.7742, 8.46998, 14.75>, <0.184351, 0.053414, 0.038178> }
        smooth_triangle {<-17.7742, 8.46998, 14.75>, <0.184376, 0.0534212, 0.0381831>,
                         <-17.6346, 7.98811, 14.75>, <0.184387, 0.0534779, 0.0381883>,
                         <-17.5615, 8.00934, 14.3673>, <0.173152, 0.0502055, 0.0664113> }
        smooth_triangle {<-17.7011, 8.4912, 14.3674>, <0.170358, 0.0476544, 0.0733641>,
                         <-17.8332, 8.97514, 14.3708>, <0.16513, 0.0206449, 0.0695104>,
                         <-17.9056, 8.95411, 14.75>, <0.183585, 0.0498127, 0.0378318> }
        smooth_triangle {<-17.9056, 8.95411, 14.75>, <0.184402, 0.0500346, 0.0380003>,
                         <-17.7742, 8.46998, 14.75>, <0.184786, 0.0518353, 0.0381734>,
                         <-17.7011, 8.4912, 14.3674>, <0.173331, 0.0481748, 0.066325> }
        smooth_triangle {<-17.8332, 8.97514, 14.3708>, <0.16513, 0.0206449, 0.0695104>,
                         <-17.8408, 9.46265, 14.4241>, <0.12513, -0.0417453, 0.0487328>,
                         <-17.9031, 9.44457, 14.75>, <0.159863, -0.000820296, 0.0304922> }
        smooth_triangle {<-17.9031, 9.44457, 14.75>, <0.172922, -0.000887307, 0.0329832>,
                         <-17.9056, 8.95411, 14.75>, <0.184783, 0.0244292, 0.036653>,
                         <-17.8332, 8.97514, 14.3708>, <0.1693, 0.0163251, 0.0627031> }
        smooth_triangle {<-17.8408, 9.46265, 14.4241>, <0.12513, -0.0417453, 0.0487328>,
                         <-17.561, 9.84607, 14.5796>, <0.0732331, -0.0707534, 0.0233905>,
                         <-17.5935, 9.83662, 14.75>, <0.0615771, -0.0588123, 0.00327812> }
        smooth_triangle {<-17.5935, 9.83662, 14.75>, <0.0781302, -0.0693317, 0.00716252>,
                         <-17.9031, 9.44457, 14.75>, <0.143826, -0.0508551, 0.024654>,
                         <-17.8408, 9.46265, 14.4241>, <0.125662, -0.0535742, 0.0427494> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.92481e-17>,
                         <-17.5935, 9.83662, 14.75>, <0.0615771, -0.0588123, 0.00327812>,
                         <-17.561, 9.84607, 14.5796>, <0.0732331, -0.0707534, 0.0233905> }
        smooth_triangle {<-15.2788, 3.46035, 14.75>, <0.00364025, 0.0273806, 0.0074367>,
                         <-15.6456, 3.59461, 14.4352>, <0.00986133, 0.0586671, 0.0230574>,
                         <-15.7383, 3.5677, 14.5796>, <0.020487, 0.079559, 0.0153932> }
        smooth_triangle {<-15.7383, 3.5677, 14.5796>, <0.0228785, 0.0789131, 0.0136639>,
                         <-15.2788, 3.46035, 14.75>, <0.00833959, 0.041907, 0.00391712>,
                         <-15.2788, 3.46035, 14.75>, <-4.05663e-08, -5.83775e-07, -2.0172e-07> }
        smooth_triangle {<-15.6456, 3.59461, 14.4352>, <0.0171473, 0.0755367, 0.0308753>,
                         <-16.0026, 3.79315, 14.1477>, <0.0576375, 0.0928774, 0.0780717>,
                         <-16.1799, 3.74168, 14.4241>, <0.0767224, 0.112331, 0.0445424> }
        smooth_triangle {<-16.1799, 3.74168, 14.4241>, <0.0858868, 0.103008, 0.0422824>,
                         <-15.7383, 3.5677, 14.5796>, <0.0228785, 0.0789131, 0.0136639>,
                         <-15.6456, 3.59461, 14.4352>, <0.00950816, 0.0508419, 0.0233063> }
        smooth_triangle {<-16.0026, 3.79315, 14.1477>, <0.0802417, 0.0786798, 0.0899315>,
                         <-16.2282, 4.21737, 14.0493>, <0.114417, 0.060506, 0.124988>,
                         <-16.4345, 4.15749, 14.3708>, <0.147288, 0.0755877, 0.0738468> }
        smooth_triangle {<-16.4345, 4.15749, 14.3708>, <0.15149, 0.0712769, 0.0670531>,
                         <-16.1799, 3.74168, 14.4241>, <0.0858868, 0.103008, 0.0422824>,
                         <-16.0026, 3.79315, 14.1477>, <0.0634951, 0.0739628, 0.0862348> }
        smooth_triangle {<-16.2282, 4.21737, 14.0493>, <0.120617, 0.049448, 0.126906>,
                         <-16.374, 4.69731, 14.0431>, <0.129606, 0.0394322, 0.135342>,
                         <-16.5822, 4.63689, 14.3674>, <0.166621, 0.0505208, 0.0803018> }
        smooth_triangle {<-16.5822, 4.63689, 14.3674>, <0.169456, 0.0510013, 0.0732035>,
                         <-16.4345, 4.15749, 14.3708>, <0.15149, 0.0712769, 0.0670531>,
                         <-16.2282, 4.21737, 14.0493>, <0.109062, 0.0497311, 0.132977> }
        smooth_triangle {<-16.374, 4.69731, 14.0431>, <0.129854, 0.0386518, 0.135356>,
                         <-16.5141, 5.17904, 14.0429>, <0.130349, 0.0378971, 0.135743>,
                         <-16.7223, 5.1186, 14.3673>, <0.167505, 0.0486949, 0.0805199> }
        smooth_triangle {<-16.7223, 5.1186, 14.3673>, <0.170313, 0.0494993, 0.0734622>,
                         <-16.5822, 4.63689, 14.3674>, <0.169456, 0.0510013, 0.0732035>,
                         <-16.374, 4.69731, 14.0431>, <0.121048, 0.0363766, 0.144224> }
        smooth_triangle {<-16.5141, 5.17904, 14.0429>, <0.130357, 0.0378723, 0.135743>,
                         <-16.654, 5.66083, 14.0429>, <0.130371, 0.0378496, 0.135754>,
                         <-16.8621, 5.60039, 14.3673>, <0.167531, 0.048638, 0.0805258> }
        smooth_triangle {<-16.8621, 5.60039, 14.3673>, <0.170338, 0.0494529, 0.0734695>,
                         <-16.7223, 5.1186, 14.3673>, <0.170313, 0.0494993, 0.0734622>,
                         <-16.5141, 5.17904, 14.0429>, <0.121708, 0.0353703, 0.14474> }
        smooth_triangle {<-16.654, 5.66083, 14.0429>, <0.130371, 0.0378496, 0.135754>,
                         <-16.7938, 6.14262, 14.0429>, <0.130371, 0.0378496, 0.135754>,
                         <-17.002, 6.08218, 14.3673>, <0.167531, 0.048638, 0.0805258> }
        smooth_triangle {<-17.002, 6.08218, 14.3673>, <0.170338, 0.0494529, 0.0734695>,
                         <-16.8621, 5.60039, 14.3673>, <0.170338, 0.0494529, 0.0734695>,
                         <-16.654, 5.66083, 14.0429>, <0.121727, 0.03534, 0.144755> }
        smooth_triangle {<-16.7938, 6.14262, 14.0429>, <0.130371, 0.0378496, 0.135754>,
                         <-16.9337, 6.62441, 14.0429>, <0.130371, 0.0378496, 0.135754>,
                         <-17.1419, 6.56397, 14.3673>, <0.167531, 0.048638, 0.0805258> }
        smooth_triangle {<-17.1419, 6.56397, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.002, 6.08218, 14.3673>, <0.170338, 0.0494529, 0.0734695>,
                         <-16.7938, 6.14262, 14.0429>, <0.121727, 0.03534, 0.144755> }
        smooth_triangle {<-16.9337, 6.62441, 14.0429>, <0.130371, 0.0378496, 0.135754>,
                         <-17.0736, 7.1062, 14.0429>, <0.130371, 0.0378496, 0.135754>,
                         <-17.2818, 7.04576, 14.3673>, <0.167531, 0.048638, 0.0805258> }
        smooth_triangle {<-17.2818, 7.04576, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.1419, 6.56397, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-16.9337, 6.62441, 14.0429>, <0.121727, 0.0353401, 0.144755> }
        smooth_triangle {<-17.0736, 7.1062, 14.0429>, <0.130371, 0.0378496, 0.135754>,
                         <-17.2135, 7.58799, 14.0429>, <0.130371, 0.0378497, 0.135754>,
                         <-17.4216, 7.52755, 14.3673>, <0.167531, 0.048638, 0.0805259> }
        smooth_triangle {<-17.4216, 7.52755, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.2818, 7.04576, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.0736, 7.1062, 14.0429>, <0.121727, 0.0353401, 0.144755> }
        smooth_triangle {<-17.2135, 7.58799, 14.0429>, <0.130371, 0.0378497, 0.135754>,
                         <-17.3533, 8.06978, 14.0429>, <0.130385, 0.0378001, 0.135754>,
                         <-17.5615, 8.00934, 14.3673>, <0.167533, 0.0485955, 0.0805238> }
        smooth_triangle {<-17.5615, 8.00934, 14.3673>, <0.17034, 0.0493998, 0.073467>,
                         <-17.4216, 7.52755, 14.3673>, <0.170338, 0.0494529, 0.0734696>,
                         <-17.2135, 7.58799, 14.0429>, <0.121727, 0.0353401, 0.144755> }
        smooth_triangle {<-17.3533, 8.06978, 14.0429>, <0.130382, 0.0377723, 0.135747>,
                         <-17.493, 8.55162, 14.0431>, <0.130812, 0.0361656, 0.135712>,
                         <-17.7011, 8.4912, 14.3674>, <0.167545, 0.047177, 0.0804356> }
        smooth_triangle {<-17.7011, 8.4912, 14.3674>, <0.170358, 0.0476544, 0.0733641>,
                         <-17.5615, 8.00934, 14.3673>, <0.17034, 0.0493998, 0.073467>,
                         <-17.3533, 8.06978, 14.0429>, <0.121746, 0.035274, 0.144755> }
        smooth_triangle {<-17.493, 8.55162, 14.0431>, <0.130684, 0.0352837, 0.135466>,
                         <-17.6269, 9.03503, 14.0493>, <0.133185, 0.00944143, 0.130656>,
                         <-17.8332, 8.97514, 14.3708>, <0.16326, 0.0248639, 0.0771554> }
        smooth_triangle {<-17.8332, 8.97514, 14.3708>, <0.16513, 0.0206449, 0.0695104>,
                         <-17.7011, 8.4912, 14.3674>, <0.170358, 0.0476544, 0.0733641>,
                         <-17.493, 8.55162, 14.0431>, <0.12232, 0.0331317, 0.144709> }
        smooth_triangle {<-17.6269, 9.03503, 14.0493>, <0.128603, -0.00282528, 0.12543>,
                         <-17.6635, 9.51412, 14.1477>, <0.112886, -0.0617669, 0.0929498>,
                         <-17.8408, 9.46265, 14.4241>, <0.127594, -0.0348617, 0.0563531> }
        smooth_triangle {<-17.8408, 9.46265, 14.4241>, <0.12513, -0.0417453, 0.0487328>,
                         <-17.8332, 8.97514, 14.3708>, <0.16513, 0.0206449, 0.0695104>,
                         <-17.6269, 9.03503, 14.0493>, <0.125654, -0.00132467, 0.138295> }
        smooth_triangle {<-17.6635, 9.51412, 14.1477>, <0.0934141, -0.0736427, 0.0782427>,
                         <-17.4683, 9.87298, 14.4352>, <0.0609378, -0.074323, 0.0409748>,
                         <-17.561, 9.84607, 14.5796>, <0.0704991, -0.0675688, 0.0243136> }
        smooth_triangle {<-17.561, 9.84607, 14.5796>, <0.0732331, -0.0707534, 0.0233905>,
                         <-17.8408, 9.46265, 14.4241>, <0.12513, -0.0417453, 0.0487328>,
                         <-17.6635, 9.51412, 14.1477>, <0.104698, -0.0799135, 0.0949883> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.92481e-17>,
                         <-17.561, 9.84607, 14.5796>, <0.0732331, -0.0707534, 0.0233905>,
                         <-17.4683, 9.87298, 14.4352>, <0.061396, -0.0808206, 0.0452977> }
        smooth_triangle {<-15.2788, 3.46035, 14.75>, <9.35862e-05, 0.0263509, 0.0111298>,
                         <-15.5069, 3.63487, 14.3387>, <-0.000500471, 0.0556589, 0.0311859>,
                         <-15.6456, 3.59461, 14.4352>, <0.00720129, 0.0578948, 0.0258272> }
        smooth_triangle {<-15.6456, 3.59461, 14.4352>, <0.00950816, 0.0508419, 0.0233063>,
                         <-15.2788, 3.46035, 14.75>, <-4.05663e-08, -5.83775e-07, -2.0172e-07>,
                         <-15.2788, 3.46035, 14.75>, <4.83136e-08, -5.57971e-07, -2.6356e-07> }
        smooth_triangle {<-15.5069, 3.63487, 14.3387>, <0.00305697, 0.071446, 0.0428863>,
                         <-15.7372, 3.8702, 13.9631>, <0.0230061, 0.0828232, 0.103221>,
                         <-16.0026, 3.79315, 14.1477>, <0.0512489, 0.0910227, 0.084724> }
        smooth_triangle {<-16.0026, 3.79315, 14.1477>, <0.0634951, 0.0739628, 0.0862348>,
                         <-15.6456, 3.59461, 14.4352>, <0.00950816, 0.0508419, 0.0233063>,
                         <-15.5069, 3.63487, 14.3387>, <-0.000760849, 0.0478605, 0.0304512> }
        smooth_triangle {<-15.7372, 3.8702, 13.9631>, <0.0399543, 0.0669834, 0.12097>,
                         <-15.9195, 4.307, 13.8345>, <0.0592169, 0.0444803, 0.163979>,
                         <-16.2282, 4.21737, 14.0493>, <0.102372, 0.0570091, 0.13753> }
        smooth_triangle {<-16.2282, 4.21737, 14.0493>, <0.109062, 0.0497311, 0.132977>,
                         <-16.0026, 3.79315, 14.1477>, <0.0634951, 0.0739628, 0.0862348>,
                         <-15.7372, 3.8702, 13.9631>, <0.025838, 0.0630301, 0.110897> }
        smooth_triangle {<-15.9195, 4.307, 13.8345>, <0.064502, 0.0331567, 0.16685>,
                         <-16.0626, 4.78774, 13.8264>, <0.0699646, 0.0221168, 0.176878>,
                         <-16.374, 4.69731, 14.0431>, <0.116647, 0.0356697, 0.148837> }
        smooth_triangle {<-16.374, 4.69731, 14.0431>, <0.121048, 0.0363766, 0.144224>,
                         <-16.2282, 4.21737, 14.0493>, <0.109062, 0.0497311, 0.132977>,
                         <-15.9195, 4.307, 13.8345>, <0.0515215, 0.0330259, 0.168241> }
        smooth_triangle {<-16.0626, 4.78774, 13.8264>, <0.0702061, 0.0213345, 0.176899>,
                         <-16.2025, 5.2695, 13.8261>, <0.0705393, 0.0205329, 0.177358>,
                         <-16.5141, 5.17904, 14.0429>, <0.117383, 0.0341327, 0.149245> }
        smooth_triangle {<-16.5141, 5.17904, 14.0429>, <0.121708, 0.0353703, 0.14474>,
                         <-16.374, 4.69731, 14.0431>, <0.121048, 0.0363766, 0.144224>,
                         <-16.0626, 4.78774, 13.8264>, <0.0588049, 0.0183061, 0.181613> }
        smooth_triangle {<-16.2025, 5.2695, 13.8261>, <0.0705465, 0.0205081, 0.177358>,
                         <-16.3424, 5.75128, 13.8261>, <0.0705562, 0.0204841, 0.177371>,
                         <-16.654, 5.66083, 14.0429>, <0.117405, 0.0340852, 0.149256> }
        smooth_triangle {<-16.654, 5.66083, 14.0429>, <0.121727, 0.03534, 0.144755>,
                         <-16.5141, 5.17904, 14.0429>, <0.121708, 0.0353703, 0.14474>,
                         <-16.2025, 5.2695, 13.8261>, <0.0592492, 0.0172372, 0.182225> }
        smooth_triangle {<-16.3424, 5.75128, 13.8261>, <0.0705562, 0.0204841, 0.177371>,
                         <-16.4823, 6.23307, 13.8261>, <0.0705562, 0.0204841, 0.177371>,
                         <-16.7938, 6.14262, 14.0429>, <0.117405, 0.0340853, 0.149256> }
        smooth_triangle {<-16.7938, 6.14262, 14.0429>, <0.121727, 0.03534, 0.144755>,
                         <-16.654, 5.66083, 14.0429>, <0.121727, 0.03534, 0.144755>,
                         <-16.3424, 5.75128, 13.8261>, <0.0592621, 0.0172052, 0.182242> }
        smooth_triangle {<-16.4823, 6.23307, 13.8261>, <0.0705562, 0.0204841, 0.177371>,
                         <-16.6222, 6.71486, 13.8261>, <0.0705562, 0.0204841, 0.177371>,
                         <-16.9337, 6.62441, 14.0429>, <0.117405, 0.0340853, 0.149256> }
        smooth_triangle {<-16.9337, 6.62441, 14.0429>, <0.121727, 0.0353401, 0.144755>,
                         <-16.7938, 6.14262, 14.0429>, <0.121727, 0.03534, 0.144755>,
                         <-16.4823, 6.23307, 13.8261>, <0.0592621, 0.0172052, 0.182242> }
        smooth_triangle {<-16.6222, 6.71486, 13.8261>, <0.0705562, 0.0204841, 0.177371>,
                         <-16.762, 7.19665, 13.8261>, <0.0705562, 0.0204841, 0.177371>,
                         <-17.0736, 7.1062, 14.0429>, <0.117405, 0.0340853, 0.149256> }
        smooth_triangle {<-17.0736, 7.1062, 14.0429>, <0.121727, 0.0353401, 0.144755>,
                         <-16.9337, 6.62441, 14.0429>, <0.121727, 0.0353401, 0.144755>,
                         <-16.6222, 6.71486, 13.8261>, <0.0592621, 0.0172052, 0.182243> }
        smooth_triangle {<-16.762, 7.19665, 13.8261>, <0.0705562, 0.0204841, 0.177371>,
                         <-16.9019, 7.67844, 13.8261>, <0.0705562, 0.0204841, 0.177371>,
                         <-17.2135, 7.58799, 14.0429>, <0.117405, 0.0340853, 0.149256> }
        smooth_triangle {<-17.2135, 7.58799, 14.0429>, <0.121727, 0.0353401, 0.144755>,
                         <-17.0736, 7.1062, 14.0429>, <0.121727, 0.0353401, 0.144755>,
                         <-16.762, 7.19665, 13.8261>, <0.0592621, 0.0172052, 0.182243> }
        smooth_triangle {<-16.9019, 7.67844, 13.8261>, <0.0705562, 0.0204841, 0.177371>,
                         <-17.0418, 8.16023, 13.8261>, <0.0705706, 0.0204346, 0.177371>,
                         <-17.3533, 8.06978, 14.0429>, <0.117419, 0.0340358, 0.149256> }
        smooth_triangle {<-17.3533, 8.06978, 14.0429>, <0.121746, 0.035274, 0.144755>,
                         <-17.2135, 7.58799, 14.0429>, <0.121727, 0.0353401, 0.144755>,
                         <-16.9019, 7.67844, 13.8261>, <0.0592621, 0.0172052, 0.182243> }
        smooth_triangle {<-17.0418, 8.16023, 13.8261>, <0.0705708, 0.0204078, 0.17736>,
                         <-17.1816, 8.64205, 13.8264>, <0.0710165, 0.0188055, 0.177315>,
                         <-17.493, 8.55162, 14.0431>, <0.11785, 0.0324022, 0.14921> }
        smooth_triangle {<-17.493, 8.55162, 14.0431>, <0.12232, 0.0331317, 0.144709>,
                         <-17.3533, 8.06978, 14.0429>, <0.121746, 0.035274, 0.144755>,
                         <-17.0418, 8.16023, 13.8261>, <0.0592813, 0.0171392, 0.182243> }
        smooth_triangle {<-17.1816, 8.64205, 13.8264>, <0.0710059, 0.0179578, 0.176946>,
                         <-17.3181, 9.12466, 13.8345>, <0.0756258, -0.00726937, 0.170664>,
                         <-17.6269, 9.03503, 14.0493>, <0.12034, 0.0057122, 0.144031> }
        smooth_triangle {<-17.6269, 9.03503, 14.0493>, <0.125654, -0.00132467, 0.138295>,
                         <-17.493, 8.55162, 14.0431>, <0.12232, 0.0331317, 0.144709>,
                         <-17.1816, 8.64205, 13.8264>, <0.0598756, 0.0150028, 0.182182> }
        smooth_triangle {<-17.3181, 9.12466, 13.8345>, <0.073536, -0.0188126, 0.162844>,
                         <-17.3981, 9.59116, 13.9631>, <0.0720601, -0.0736196, 0.120771>,
                         <-17.6635, 9.51412, 14.1477>, <0.102533, -0.0647726, 0.10373> }
        smooth_triangle {<-17.6635, 9.51412, 14.1477>, <0.104698, -0.0799135, 0.0949883>,
                         <-17.6269, 9.03503, 14.0493>, <0.125654, -0.00132467, 0.138295>,
                         <-17.3181, 9.12466, 13.8345>, <0.0660354, -0.0186334, 0.173806> }
        smooth_triangle {<-17.3981, 9.59116, 13.9631>, <0.0596023, -0.0834591, 0.0987599>,
                         <-17.3296, 9.91325, 14.3387>, <0.043116, -0.0794971, 0.0523209>,
                         <-17.4683, 9.87298, 14.4352>, <0.0575987, -0.0752924, 0.0444517> }
        smooth_triangle {<-17.4683, 9.87298, 14.4352>, <0.061396, -0.0808206, 0.0452977>,
                         <-17.6635, 9.51412, 14.1477>, <0.104698, -0.0799135, 0.0949883>,
                         <-17.3981, 9.59116, 13.9631>, <0.0640675, -0.0917094, 0.117709> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.92481e-17>,
                         <-17.4683, 9.87298, 14.4352>, <0.061396, -0.0808206, 0.0452977>,
                         <-17.3296, 9.91325, 14.3387>, <0.0420858, -0.0864268, 0.05579> }
        smooth_triangle {<-15.2788, 3.46035, 14.75>, <-0.00454037, 0.0250056, 0.0131285>,
                         <-15.3433, 3.68237, 14.3048>, <-0.0130608, 0.0520123, 0.0345666>,
                         <-15.5069, 3.63487, 14.3387>, <-0.00397599, 0.0546498, 0.0326849> }
        smooth_triangle {<-15.5069, 3.63487, 14.3387>, <-0.000760849, 0.0478605, 0.0304512>,
                         <-15.2788, 3.46035, 14.75>, <4.83136e-08, -5.57971e-07, -2.6356e-07>,
                         <-15.2788, 3.46035, 14.75>, <1.53155e-07, -5.27533e-07, -2.85275e-07> }
        smooth_triangle {<-15.3433, 3.68237, 14.3048>, <-0.0143749, 0.0663851, 0.0483682>,
                         <-15.4242, 3.96107, 13.8983>, <-0.0182315, 0.070851, 0.112655>,
                         <-15.7372, 3.8702, 13.9631>, <0.0146591, 0.0803998, 0.106821> }
        smooth_triangle {<-15.7372, 3.8702, 13.9631>, <0.025838, 0.0630301, 0.110897>,
                         <-15.5069, 3.63487, 14.3387>, <-0.000760849, 0.0478605, 0.0304512>,
                         <-15.3433, 3.68237, 14.3048>, <-0.012874, 0.0443438, 0.0329601> }
        smooth_triangle {<-15.4242, 3.96107, 13.8983>, <-0.00867346, 0.0528657, 0.133592>,
                         <-15.5553, 4.41273, 13.7591>, <-0.00611045, 0.0255143, 0.178005>,
                         <-15.9195, 4.307, 13.8345>, <0.0434798, 0.0399114, 0.170766> }
        smooth_triangle {<-15.9195, 4.307, 13.8345>, <0.0515215, 0.0330259, 0.168241>,
                         <-15.7372, 3.8702, 13.9631>, <0.025838, 0.0630301, 0.110897>,
                         <-15.4242, 3.96107, 13.8983>, <-0.0180162, 0.0502983, 0.118676> }
        smooth_triangle {<-15.5553, 4.41273, 13.7591>, <-0.00202073, 0.0138437, 0.181392>,
                         <-15.6952, 4.8944, 13.7503>, <-0.000402252, 0.00168778, 0.191487>,
                         <-16.0626, 4.78774, 13.8264>, <0.0530321, 0.0172009, 0.184182> }
        smooth_triangle {<-16.0626, 4.78774, 13.8264>, <0.0588049, 0.0183061, 0.181613>,
                         <-15.9195, 4.307, 13.8345>, <0.0515215, 0.0330259, 0.168241>,
                         <-15.5553, 4.41273, 13.7591>, <-0.0145988, 0.0138297, 0.177893> }
        smooth_triangle {<-15.6952, 4.8944, 13.7503>, <-0.000169342, 0.000902977, 0.191511>,
                         <-15.835, 5.37619, 13.75>, <-1.19283e-05, 5.03239e-05, 0.191972>,
                         <-16.2025, 5.2695, 13.8261>, <0.0535982, 0.0156145, 0.184665> }
        smooth_triangle {<-16.2025, 5.2695, 13.8261>, <0.0592492, 0.0172372, 0.182225>,
                         <-16.0626, 4.78774, 13.8264>, <0.0588049, 0.0183061, 0.181613>,
                         <-15.6952, 4.8944, 13.7503>, <-0.0124408, -0.00237816, 0.191353> }
        smooth_triangle {<-15.835, 5.37619, 13.75>, <-4.73416e-06, 2.55614e-05, 0.191972>,
                         <-15.9749, 5.85798, 13.75>, <-2.25375e-08, 8.55423e-08, 0.191985>,
                         <-16.3424, 5.75128, 13.8261>, <0.053615, 0.0155657, 0.184678> }
        smooth_triangle {<-16.3424, 5.75128, 13.8261>, <0.0592621, 0.0172052, 0.182242>,
                         <-16.2025, 5.2695, 13.8261>, <0.0592492, 0.0172372, 0.182225>,
                         <-15.835, 5.37619, 13.75>, <-0.0122309, -0.00351503, 0.191968> }
        smooth_triangle {<-15.9749, 5.85798, 13.75>, <-2.04188e-08, 8.61574e-08, 0.191985>,
                         <-16.1148, 6.33977, 13.75>, <-2.25375e-08, 8.55423e-08, 0.191985>,
                         <-16.4823, 6.23307, 13.8261>, <0.053615, 0.0155657, 0.184678> }
        smooth_triangle {<-16.4823, 6.23307, 13.8261>, <0.0592621, 0.0172052, 0.182242>,
                         <-16.3424, 5.75128, 13.8261>, <0.0592621, 0.0172052, 0.182242>,
                         <-15.9749, 5.85798, 13.75>, <-0.0122247, -0.003549, 0.191985> }
        smooth_triangle {<-16.1148, 6.33977, 13.75>, <-2.04188e-08, 8.61574e-08, 0.191985>,
                         <-16.2546, 6.82156, 13.75>, <-2.25375e-08, 8.55423e-08, 0.191985>,
                         <-16.6222, 6.71486, 13.8261>, <0.0536151, 0.0155657, 0.184678> }
        smooth_triangle {<-16.6222, 6.71486, 13.8261>, <0.0592621, 0.0172052, 0.182243>,
                         <-16.4823, 6.23307, 13.8261>, <0.0592621, 0.0172052, 0.182242>,
                         <-16.1148, 6.33977, 13.75>, <-0.0122247, -0.003549, 0.191985> }
        smooth_triangle {<-16.2546, 6.82156, 13.75>, <-2.04188e-08, 8.61575e-08, 0.191985>,
                         <-16.3945, 7.30335, 13.75>, <-2.25375e-08, 8.55424e-08, 0.191985>,
                         <-16.762, 7.19665, 13.8261>, <0.0536151, 0.0155657, 0.184678> }
        smooth_triangle {<-16.762, 7.19665, 13.8261>, <0.0592621, 0.0172052, 0.182243>,
                         <-16.6222, 6.71486, 13.8261>, <0.0592621, 0.0172052, 0.182243>,
                         <-16.2546, 6.82156, 13.75>, <-0.0122247, -0.003549, 0.191985> }
        smooth_triangle {<-16.3945, 7.30335, 13.75>, <-2.04188e-08, 8.61575e-08, 0.191985>,
                         <-16.5344, 7.78513, 13.75>, <-2.25375e-08, 8.55424e-08, 0.191985>,
                         <-16.9019, 7.67844, 13.8261>, <0.0536151, 0.0155657, 0.184678> }
        smooth_triangle {<-16.9019, 7.67844, 13.8261>, <0.0592621, 0.0172052, 0.182243>,
                         <-16.762, 7.19665, 13.8261>, <0.0592621, 0.0172052, 0.182243>,
                         <-16.3945, 7.30335, 13.75>, <-0.0122247, -0.003549, 0.191985> }
        smooth_triangle {<-16.5344, 7.78513, 13.75>, <-2.04188e-08, 8.61575e-08, 0.191985>,
                         <-16.6743, 8.26692, 13.75>, <1.43564e-05, -4.94421e-05, 0.191985>,
                         <-17.0418, 8.16023, 13.8261>, <0.0536295, 0.0155162, 0.184678> }
        smooth_triangle {<-17.0418, 8.16023, 13.8261>, <0.0592813, 0.0171392, 0.182243>,
                         <-16.9019, 7.67844, 13.8261>, <0.0592621, 0.0172052, 0.182243>,
                         <-16.5344, 7.78513, 13.75>, <-0.0122247, -0.003549, 0.191985> }
        smooth_triangle {<-16.6743, 8.26692, 13.75>, <1.90723e-05, -7.49168e-05, 0.191972>,
                         <-16.8141, 8.74871, 13.7503>, <0.000482743, -0.00167201, 0.191924>,
                         <-17.1816, 8.64205, 13.8264>, <0.0540799, 0.0138884, 0.18462> }
        smooth_triangle {<-17.1816, 8.64205, 13.8264>, <0.0598756, 0.0150028, 0.182182>,
                         <-17.0418, 8.16023, 13.8261>, <0.0592813, 0.0171392, 0.182243>,
                         <-16.6743, 8.26692, 13.75>, <-0.0122055, -0.00361504, 0.191985> }
        smooth_triangle {<-16.8141, 8.74871, 13.7503>, <0.000625787, -0.00247515, 0.191488>,
                         <-16.954, 9.23039, 13.7591>, <0.00774424, -0.0269769, 0.184691>,
                         <-17.3181, 9.12466, 13.8345>, <0.0588428, -0.0121418, 0.177903> }
        smooth_triangle {<-17.3181, 9.12466, 13.8345>, <0.0660354, -0.0186334, 0.173806>,
                         <-17.1816, 8.64205, 13.8264>, <0.0598756, 0.0150028, 0.182182>,
                         <-16.8141, 8.74871, 13.7503>, <-0.0115873, -0.00574449, 0.19192> }
        smooth_triangle {<-16.954, 9.23039, 13.7591>, <0.00891041, -0.0375748, 0.175466>,
                         <-17.0851, 9.68204, 13.8983>, <0.0241174, -0.0875384, 0.130205>,
                         <-17.3981, 9.59116, 13.9631>, <0.058533, -0.0775468, 0.126605> }
        smooth_triangle {<-17.3981, 9.59116, 13.9631>, <0.0640675, -0.0917094, 0.117709>,
                         <-17.3181, 9.12466, 13.8345>, <0.0660354, -0.0186334, 0.173806>,
                         <-16.954, 9.23039, 13.7591>, <-0.002096, -0.0384135, 0.182856> }
        smooth_triangle {<-17.0851, 9.68204, 13.8983>, <0.0208239, -0.0947173, 0.104242>,
                         <-17.166, 9.96074, 14.3048>, <0.022481, -0.0854879, 0.0557017>,
                         <-17.3296, 9.91325, 14.3387>, <0.0387532, -0.0807637, 0.0542027> }
        smooth_triangle {<-17.3296, 9.91325, 14.3387>, <0.0420858, -0.0864268, 0.05579>,
                         <-17.3981, 9.59116, 13.9631>, <0.0640675, -0.0917094, 0.117709>,
                         <-17.0851, 9.68204, 13.8983>, <0.01818, -0.105032, 0.122509> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.75134e-17>,
                         <-17.3296, 9.91325, 14.3387>, <0.0420858, -0.0864268, 0.05579>,
                         <-17.166, 9.96074, 14.3048>, <0.0203894, -0.0927257, 0.0577887> }
        smooth_triangle {<-15.2788, 3.46034, 14.75>, <-0.00955612, 0.0235494, 0.0131286>,
                         <-15.1797, 3.72987, 14.3387>, <-0.0259075, 0.0482826, 0.0326849>,
                         <-15.3433, 3.68237, 14.3048>, <-0.0168227, 0.0509201, 0.0345666> }
        smooth_triangle {<-15.3433, 3.68237, 14.3048>, <-0.012874, 0.0443438, 0.0329601>,
                         <-15.2788, 3.46035, 14.75>, <1.53155e-07, -5.27533e-07, -2.85275e-07>,
                         <-15.2788, 3.46034, 14.75>, <2.57996e-07, -4.97096e-07, -2.6356e-07> }
        smooth_triangle {<-15.1797, 3.72987, 14.3387>, <-0.0324945, 0.0611246, 0.0464865>,
                         <-15.1112, 4.05195, 13.9631>, <-0.0597975, 0.0587834, 0.104939>,
                         <-15.4242, 3.96107, 13.8983>, <-0.0272663, 0.068228, 0.112655> }
        smooth_triangle {<-15.4242, 3.96107, 13.8983>, <-0.0180162, 0.0502983, 0.118676>,
                         <-15.3433, 3.68237, 14.3048>, <-0.012874, 0.0443438, 0.0329601>,
                         <-15.1797, 3.72987, 14.3387>, <-0.0249871, 0.0408271, 0.0304512> }
        smooth_triangle {<-15.1112, 4.05195, 13.9631>, <-0.0582384, 0.0384759, 0.125876>,
                         <-15.1911, 4.51845, 13.8345>, <-0.0716199, 0.00649547, 0.164932>,
                         <-15.5553, 4.41273, 13.7591>, <-0.0231442, 0.020569, 0.178005> }
        smooth_triangle {<-15.5553, 4.41273, 13.7591>, <-0.0145988, 0.0138297, 0.177893>,
                         <-15.4242, 3.96107, 13.8983>, <-0.0180162, 0.0502983, 0.118676>,
                         <-15.1112, 4.05195, 13.9631>, <-0.0613911, 0.0377056, 0.108388> }
        smooth_triangle {<-15.1911, 4.51845, 13.8345>, <-0.068824, -0.00555078, 0.168319>,
                         <-15.3277, 5.00107, 13.8264>, <-0.0707814, -0.0187448, 0.176943>,
                         <-15.6952, 4.8944, 13.7503>, <-0.0187299, -0.00363313, 0.191487> }
        smooth_triangle {<-15.6952, 4.8944, 13.7503>, <-0.0124408, -0.00237816, 0.191353>,
                         <-15.5553, 4.41273, 13.7591>, <-0.0145988, 0.0138297, 0.177893>,
                         <-15.1911, 4.51845, 13.8345>, <-0.0792331, -0.00493504, 0.160462> }
        smooth_triangle {<-15.3277, 5.00107, 13.8264>, <-0.0705578, -0.0195324, 0.176967>,
                         <-15.4675, 5.48289, 13.8261>, <-0.0705635, -0.0204324, 0.17736>,
                         <-15.835, 5.37619, 13.75>, <-0.0183489, -0.0052733, 0.191972> }
        smooth_triangle {<-15.835, 5.37619, 13.75>, <-0.0122309, -0.00351503, 0.191968>,
                         <-15.6952, 4.8944, 13.7503>, <-0.0124408, -0.00237816, 0.191353>,
                         <-15.3277, 5.00107, 13.8264>, <-0.0818429, -0.0225271, 0.171961> }
        smooth_triangle {<-15.4675, 5.48289, 13.8261>, <-0.0705563, -0.0204571, 0.17736>,
                         <-15.6074, 5.96468, 13.8261>, <-0.0705562, -0.0204839, 0.177371>,
                         <-15.9749, 5.85798, 13.75>, <-0.018337, -0.00532354, 0.191985> }
        smooth_triangle {<-15.9749, 5.85798, 13.75>, <-0.0122247, -0.003549, 0.191985>,
                         <-15.835, 5.37619, 13.75>, <-0.0122309, -0.00351503, 0.191968>,
                         <-15.4675, 5.48289, 13.8261>, <-0.0818505, -0.0237271, 0.172485> }
        smooth_triangle {<-15.6074, 5.96468, 13.8261>, <-0.0705562, -0.0204839, 0.177371>,
                         <-15.7473, 6.44646, 13.8261>, <-0.0705562, -0.0204839, 0.177371>,
                         <-16.1148, 6.33977, 13.75>, <-0.018337, -0.00532354, 0.191985> }
        smooth_triangle {<-16.1148, 6.33977, 13.75>, <-0.0122247, -0.003549, 0.191985>,
                         <-15.9749, 5.85798, 13.75>, <-0.0122247, -0.003549, 0.191985>,
                         <-15.6074, 5.96468, 13.8261>, <-0.0818503, -0.0237629, 0.1725> }
        smooth_triangle {<-15.7473, 6.44646, 13.8261>, <-0.0705562, -0.0204839, 0.177371>,
                         <-15.8871, 6.92825, 13.8261>, <-0.0705562, -0.0204839, 0.177371>,
                         <-16.2546, 6.82156, 13.75>, <-0.018337, -0.00532354, 0.191985> }
        smooth_triangle {<-16.2546, 6.82156, 13.75>, <-0.0122247, -0.003549, 0.191985>,
                         <-16.1148, 6.33977, 13.75>, <-0.0122247, -0.003549, 0.191985>,
                         <-15.7473, 6.44646, 13.8261>, <-0.0818503, -0.0237629, 0.1725> }
        smooth_triangle {<-15.8871, 6.92825, 13.8261>, <-0.0705562, -0.0204839, 0.177371>,
                         <-16.027, 7.41004, 13.8261>, <-0.0705563, -0.0204839, 0.177371>,
                         <-16.3945, 7.30335, 13.75>, <-0.018337, -0.00532354, 0.191985> }
        smooth_triangle {<-16.3945, 7.30335, 13.75>, <-0.0122247, -0.003549, 0.191985>,
                         <-16.2546, 6.82156, 13.75>, <-0.0122247, -0.003549, 0.191985>,
                         <-15.8871, 6.92825, 13.8261>, <-0.0818503, -0.0237629, 0.1725> }
        smooth_triangle {<-16.027, 7.41004, 13.8261>, <-0.0705563, -0.0204839, 0.177371>,
                         <-16.1669, 7.89183, 13.8261>, <-0.0705563, -0.020484, 0.177371>,
                         <-16.5344, 7.78513, 13.75>, <-0.018337, -0.00532354, 0.191985> }
        smooth_triangle {<-16.5344, 7.78513, 13.75>, <-0.0122247, -0.003549, 0.191985>,
                         <-16.3945, 7.30335, 13.75>, <-0.0122247, -0.003549, 0.191985>,
                         <-16.027, 7.41004, 13.8261>, <-0.0818504, -0.0237629, 0.1725> }
        smooth_triangle {<-16.1669, 7.89183, 13.8261>, <-0.0705563, -0.020484, 0.177371>,
                         <-16.3068, 8.37362, 13.8261>, <-0.0705419, -0.0205335, 0.177371>,
                         <-16.6743, 8.26692, 13.75>, <-0.0183226, -0.00537307, 0.191985> }
        smooth_triangle {<-16.6743, 8.26692, 13.75>, <-0.0122055, -0.00361504, 0.191985>,
                         <-16.5344, 7.78513, 13.75>, <-0.0122247, -0.003549, 0.191985>,
                         <-16.1669, 7.89183, 13.8261>, <-0.0818504, -0.0237629, 0.1725> }
        smooth_triangle {<-16.3068, 8.37362, 13.8261>, <-0.0705322, -0.0205575, 0.177358>,
                         <-16.4467, 8.85538, 13.8264>, <-0.0700506, -0.0221494, 0.177313>,
                         <-16.8141, 8.74871, 13.7503>, <-0.0178493, -0.0069942, 0.191924> }
        smooth_triangle {<-16.8141, 8.74871, 13.7503>, <-0.0115873, -0.00574449, 0.19192>,
                         <-16.6743, 8.26692, 13.75>, <-0.0122055, -0.00361504, 0.191985>,
                         <-16.3068, 8.37362, 13.8261>, <-0.0818312, -0.0238289, 0.1725> }
        smooth_triangle {<-16.4467, 8.85538, 13.8264>, <-0.0697413, -0.0229043, 0.176878>,
                         <-16.5898, 9.33611, 13.8345>, <-0.060125, -0.0466808, 0.1706>,
                         <-16.954, 9.23039, 13.7591>, <-0.0104216, -0.0322508, 0.184691> }
        smooth_triangle {<-16.954, 9.23039, 13.7591>, <-0.002096, -0.0384135, 0.182856>,
                         <-16.8141, 8.74871, 13.7503>, <-0.0115873, -0.00574449, 0.19192>,
                         <-16.4467, 8.85538, 13.8264>, <-0.081189, -0.0259514, 0.17244> }
        smooth_triangle {<-16.5898, 9.33611, 13.8345>, <-0.0554346, -0.0562556, 0.161375>,
                         <-16.7721, 9.77292, 13.9631>, <-0.0236432, -0.101404, 0.119817>,
                         <-17.0851, 9.68204, 13.8983>, <0.00947586, -0.0917891, 0.130205> }
        smooth_triangle {<-17.0851, 9.68204, 13.8983>, <0.01818, -0.105032, 0.122509>,
                         <-16.954, 9.23039, 13.7591>, <-0.002096, -0.0384135, 0.182856>,
                         <-16.5898, 9.33611, 13.8345>, <-0.0683672, -0.0576535, 0.164068> }
        smooth_triangle {<-16.7721, 9.77292, 13.9631>, <-0.0170173, -0.105703, 0.093854>,
                         <-17.0024, 10.0082, 14.3387>, <0.00217425, -0.0913834, 0.0506024>,
                         <-17.166, 9.96074, 14.3048>, <0.0177588, -0.0868588, 0.0557017> }
        smooth_triangle {<-17.166, 9.96074, 14.3048>, <0.0203894, -0.0927257, 0.0577887>,
                         <-17.0851, 9.68204, 13.8983>, <0.01818, -0.105032, 0.122509>,
                         <-16.7721, 9.77292, 13.9631>, <-0.0259787, -0.117852, 0.108658> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.92481e-17>,
                         <-17.166, 9.96074, 14.3048>, <0.0203894, -0.0927257, 0.0577887>,
                         <-17.0024, 10.0082, 14.3387>, <-0.000389931, -0.0987584, 0.0509897> }
        smooth_triangle {<-15.2788, 3.46034, 14.75>, <-0.0141901, 0.022204, 0.0111299>,
                         <-15.041, 3.77014, 14.4352>, <-0.0370848, 0.0450376, 0.0258273>,
                         <-15.1797, 3.72987, 14.3387>, <-0.0293831, 0.0472736, 0.0311859> }
        smooth_triangle {<-15.1797, 3.72987, 14.3387>, <-0.0249871, 0.0408271, 0.0304512>,
                         <-15.2788, 3.46034, 14.75>, <2.57996e-07, -4.97096e-07, -2.6356e-07>,
                         <-15.2788, 3.46034, 14.75>, <3.46875e-07, -4.71292e-07, -2.0172e-07> }
        smooth_triangle {<-15.041, 3.77014, 14.4352>, <-0.0485433, 0.0564653, 0.0375277>,
                         <-14.8458, 4.12899, 14.1477>, <-0.0953637, 0.0484578, 0.0812471>,
                         <-15.1112, 4.05195, 13.9631>, <-0.0681446, 0.0563601, 0.101339> }
        smooth_triangle {<-15.1112, 4.05195, 13.9631>, <-0.0613911, 0.0377056, 0.108388>,
                         <-15.1797, 3.72987, 14.3387>, <-0.0249871, 0.0408271, 0.0304512>,
                         <-15.041, 3.77014, 14.4352>, <-0.0352561, 0.0378458, 0.0233063> }
        smooth_triangle {<-14.8458, 4.12899, 14.1477>, <-0.101195, 0.0260048, 0.0989965>,
                         <-14.8824, 4.60808, 14.0493>, <-0.127338, -0.00968078, 0.126749>,
                         <-15.1911, 4.51845, 13.8345>, <-0.087357, 0.00192664, 0.158144> }
        smooth_triangle {<-15.1911, 4.51845, 13.8345>, <-0.0792331, -0.00493504, 0.160462>,
                         <-15.1112, 4.05195, 13.9631>, <-0.0613911, 0.0377056, 0.108388>,
                         <-14.8458, 4.12899, 14.1477>, <-0.0976833, 0.0271692, 0.0815989> }
        smooth_triangle {<-14.8824, 4.60808, 14.0493>, <-0.125738, -0.0220741, 0.12962>,
                         <-15.0163, 5.0915, 14.0431>, <-0.130458, -0.0360703, 0.135461>,
                         <-15.3277, 5.00107, 13.8264>, <-0.0877139, -0.0236607, 0.16964> }
        smooth_triangle {<-15.3277, 5.00107, 13.8264>, <-0.0818429, -0.0225271, 0.171961>,
                         <-15.1911, 4.51845, 13.8345>, <-0.0792331, -0.00493504, 0.160462>,
                         <-14.8824, 4.60808, 14.0493>, <-0.132541, -0.0204116, 0.118602> }
        smooth_triangle {<-15.0163, 5.0915, 14.0431>, <-0.130243, -0.0368604, 0.135482>,
                         <-15.156, 5.57334, 14.0429>, <-0.130375, -0.0377969, 0.135747>,
                         <-15.4675, 5.48289, 13.8261>, <-0.0875047, -0.0253507, 0.170053> }
        smooth_triangle {<-15.4675, 5.48289, 13.8261>, <-0.0818505, -0.0237271, 0.172485>,
                         <-15.3277, 5.00107, 13.8264>, <-0.0818429, -0.0225271, 0.171961>,
                         <-15.0163, 5.0915, 14.0431>, <-0.138835, -0.0390733, 0.12639> }
        smooth_triangle {<-15.156, 5.57334, 14.0429>, <-0.130367, -0.0378216, 0.135747>,
                         <-15.2958, 6.05513, 14.0429>, <-0.130371, -0.0378494, 0.135754>,
                         <-15.6074, 5.96468, 13.8261>, <-0.0874973, -0.0254023, 0.170064> }
        smooth_triangle {<-15.6074, 5.96468, 13.8261>, <-0.0818503, -0.0237629, 0.1725>,
                         <-15.4675, 5.48289, 13.8261>, <-0.0818505, -0.0237271, 0.172485>,
                         <-15.156, 5.57334, 14.0429>, <-0.13901, -0.0403219, 0.126743> }
        smooth_triangle {<-15.2958, 6.05513, 14.0429>, <-0.130371, -0.0378494, 0.135754>,
                         <-15.4357, 6.53692, 14.0429>, <-0.130371, -0.0378495, 0.135754>,
                         <-15.7473, 6.44646, 13.8261>, <-0.0874974, -0.0254023, 0.170064> }
        smooth_triangle {<-15.7473, 6.44646, 13.8261>, <-0.0818503, -0.0237629, 0.1725>,
                         <-15.6074, 5.96468, 13.8261>, <-0.0818503, -0.0237629, 0.1725>,
                         <-15.2958, 6.05513, 14.0429>, <-0.139015, -0.040359, 0.126753> }
        smooth_triangle {<-15.4357, 6.53692, 14.0429>, <-0.130371, -0.0378495, 0.135754>,
                         <-15.5756, 7.01871, 14.0429>, <-0.130371, -0.0378495, 0.135754>,
                         <-15.8871, 6.92825, 13.8261>, <-0.0874974, -0.0254023, 0.170064> }
        smooth_triangle {<-15.8871, 6.92825, 13.8261>, <-0.0818503, -0.0237629, 0.1725>,
                         <-15.7473, 6.44646, 13.8261>, <-0.0818503, -0.0237629, 0.1725>,
                         <-15.4357, 6.53692, 14.0429>, <-0.139015, -0.040359, 0.126753> }
        smooth_triangle {<-15.5756, 7.01871, 14.0429>, <-0.130371, -0.0378495, 0.135754>,
                         <-15.7155, 7.50049, 14.0429>, <-0.130371, -0.0378495, 0.135754>,
                         <-16.027, 7.41004, 13.8261>, <-0.0874974, -0.0254023, 0.170064> }
        smooth_triangle {<-16.027, 7.41004, 13.8261>, <-0.0818504, -0.0237629, 0.1725>,
                         <-15.8871, 6.92825, 13.8261>, <-0.0818503, -0.0237629, 0.1725>,
                         <-15.5756, 7.01871, 14.0429>, <-0.139015, -0.040359, 0.126753> }
        smooth_triangle {<-15.7155, 7.50049, 14.0429>, <-0.130371, -0.0378495, 0.135754>,
                         <-15.8553, 7.98228, 14.0429>, <-0.130371, -0.0378495, 0.135754>,
                         <-16.1669, 7.89183, 13.8261>, <-0.0874974, -0.0254023, 0.170064> }
        smooth_triangle {<-16.1669, 7.89183, 13.8261>, <-0.0818504, -0.0237629, 0.1725>,
                         <-16.027, 7.41004, 13.8261>, <-0.0818504, -0.0237629, 0.1725>,
                         <-15.7155, 7.50049, 14.0429>, <-0.139015, -0.0403591, 0.126753> }
        smooth_triangle {<-15.8553, 7.98228, 14.0429>, <-0.130371, -0.0378495, 0.135754>,
                         <-15.9952, 8.46407, 14.0429>, <-0.130357, -0.037899, 0.135754>,
                         <-16.3068, 8.37362, 13.8261>, <-0.0874831, -0.0254519, 0.170064> }
        smooth_triangle {<-16.3068, 8.37362, 13.8261>, <-0.0818312, -0.0238289, 0.1725>,
                         <-16.1669, 7.89183, 13.8261>, <-0.0818504, -0.0237629, 0.1725>,
                         <-15.8553, 7.98228, 14.0429>, <-0.139015, -0.0403591, 0.126753> }
        smooth_triangle {<-15.9952, 8.46407, 14.0429>, <-0.130342, -0.0379217, 0.135743>,
                         <-16.1353, 8.94581, 14.0431>, <-0.129846, -0.0395092, 0.135709>,
                         <-16.4467, 8.85538, 13.8264>, <-0.0869872, -0.0270665, 0.170008> }
        smooth_triangle {<-16.4467, 8.85538, 13.8264>, <-0.081189, -0.0259514, 0.17244>,
                         <-16.3068, 8.37362, 13.8261>, <-0.0818312, -0.0238289, 0.1725>,
                         <-15.9952, 8.46407, 14.0429>, <-0.138996, -0.0404251, 0.126753> }
        smooth_triangle {<-16.1353, 8.94581, 14.0431>, <-0.129383, -0.0402195, 0.13534>,
                         <-16.2811, 9.42574, 14.0493>, <-0.117649, -0.0633814, 0.130536>,
                         <-16.5898, 9.33611, 13.8345>, <-0.076908, -0.0515533, 0.163361> }
        smooth_triangle {<-16.5898, 9.33611, 13.8345>, <-0.0683672, -0.0576535, 0.164068>,
                         <-16.4467, 8.85538, 13.8264>, <-0.081189, -0.0259514, 0.17244>,
                         <-16.1353, 8.94581, 14.0431>, <-0.138333, -0.0425417, 0.126707> }
        smooth_triangle {<-16.2811, 9.42574, 14.0493>, <-0.109703, -0.0720109, 0.122716>,
                         <-16.5067, 9.84996, 14.1477>, <-0.0639505, -0.113106, 0.0911884>,
                         <-16.7721, 9.77292, 13.9631>, <-0.0371702, -0.105332, 0.113983> }
        smooth_triangle {<-16.7721, 9.77292, 13.9631>, <-0.0259787, -0.117852, 0.108658>,
                         <-16.5898, 9.33611, 13.8345>, <-0.0683672, -0.0576535, 0.164068>,
                         <-16.2811, 9.42574, 14.0493>, <-0.122689, -0.0734243, 0.120303> }
        smooth_triangle {<-16.5067, 9.84996, 14.1477>, <-0.0481604, -0.114745, 0.0691776>,
                         <-16.8637, 10.0485, 14.4352>, <-0.0147127, -0.096286, 0.0377994>,
                         <-17.0024, 10.0082, 14.3387>, <-0.0021885, -0.09265, 0.0487207> }
        smooth_triangle {<-17.0024, 10.0082, 14.3387>, <-0.000389931, -0.0987584, 0.0509897>,
                         <-16.7721, 9.77292, 13.9631>, <-0.0259787, -0.117852, 0.108658>,
                         <-16.5067, 9.84996, 14.1477>, <-0.0616858, -0.128218, 0.0782656> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.75134e-17>,
                         <-17.0024, 10.0082, 14.3387>, <-0.000389931, -0.0987584, 0.0509897>,
                         <-16.8637, 10.0485, 14.4352>, <-0.0170888, -0.103606, 0.0364279> }
        smooth_triangle {<-15.2788, 3.46034, 14.75>, <-0.0177368, 0.0211743, 0.00743676>,
                         <-14.9483, 3.79704, 14.5796>, <-0.044891, 0.0427713, 0.0150376>,
                         <-15.041, 3.77014, 14.4352>, <-0.0397449, 0.0442653, 0.0230574> }
        smooth_triangle {<-15.041, 3.77014, 14.4352>, <-0.0352561, 0.0378458, 0.0233063>,
                         <-15.2788, 3.46034, 14.75>, <3.46875e-07, -4.71292e-07, -2.0172e-07>,
                         <-15.2788, 3.46034, 14.75>, <4.06263e-07, -4.5405e-07, -1.0917e-07> }
        smooth_triangle {<-14.9483, 3.79704, 14.5796>, <-0.060078, 0.0531165, 0.0228556>,
                         <-14.6685, 4.18047, 14.4241>, <-0.119516, 0.041446, 0.0451858>,
                         <-14.8458, 4.12899, 14.1477>, <-0.101752, 0.0466031, 0.0745947> }
        smooth_triangle {<-14.8458, 4.12899, 14.1477>, <-0.0976833, 0.0271692, 0.0815989>,
                         <-15.041, 3.77014, 14.4352>, <-0.0352561, 0.0378458, 0.0233063>,
                         <-14.9483, 3.79704, 14.5796>, <-0.0421177, 0.0358537, 0.0126133> }
        smooth_triangle {<-14.6685, 4.18047, 14.4241>, <-0.131003, 0.0173509, 0.0570456>,
                         <-14.6761, 4.66797, 14.3708>, <-0.164783, -0.0205518, 0.0692702>,
                         <-14.8824, 4.60808, 14.0493>, <-0.139383, -0.0131776, 0.114207> }
        smooth_triangle {<-14.8824, 4.60808, 14.0493>, <-0.132541, -0.0204116, 0.118602>,
                         <-14.8458, 4.12899, 14.1477>, <-0.0976833, 0.0271692, 0.0815989>,
                         <-14.6685, 4.18047, 14.4241>, <-0.121368, 0.0202931, 0.0423869> }
        smooth_triangle {<-14.6761, 4.66797, 14.3708>, <-0.164097, -0.0332107, 0.0711887>,
                         <-14.8081, 5.15192, 14.3674>, <-0.170348, -0.0476511, 0.0733566>,
                         <-15.0163, 5.0915, 14.0431>, <-0.143418, -0.0398328, 0.121966> }
        smooth_triangle {<-15.0163, 5.0915, 14.0431>, <-0.138835, -0.0390733, 0.12639>,
                         <-14.8824, 4.60808, 14.0493>, <-0.132541, -0.0204116, 0.118602>,
                         <-14.6761, 4.66797, 14.3708>, <-0.166408, -0.0302438, 0.0586864> }
        smooth_triangle {<-14.8081, 5.15192, 14.3674>, <-0.170139, -0.048443, 0.0733704>,
                         <-14.9478, 5.63378, 14.3673>, <-0.17034, -0.0493996, 0.0734669>,
                         <-15.156, 5.57334, 14.0429>, <-0.143341, -0.0415612, 0.122245> }
        smooth_triangle {<-15.156, 5.57334, 14.0429>, <-0.13901, -0.0403219, 0.126743>,
                         <-15.0163, 5.0915, 14.0431>, <-0.138835, -0.0390733, 0.12639>,
                         <-14.8081, 5.15192, 14.3674>, <-0.174742, -0.0494977, 0.061577> }
        smooth_triangle {<-14.9478, 5.63378, 14.3673>, <-0.170332, -0.0494243, 0.0734669>,
                         <-15.0877, 6.11557, 14.3673>, <-0.170338, -0.0494527, 0.0734695>,
                         <-15.2958, 6.05513, 14.0429>, <-0.143337, -0.0416138, 0.122252> }
        smooth_triangle {<-15.2958, 6.05513, 14.0429>, <-0.139015, -0.040359, 0.126753>,
                         <-15.156, 5.57334, 14.0429>, <-0.13901, -0.0403219, 0.126743>,
                         <-14.9478, 5.63378, 14.3673>, <-0.175009, -0.0507731, 0.0617056> }
        smooth_triangle {<-15.0877, 6.11557, 14.3673>, <-0.170338, -0.0494527, 0.0734695>,
                         <-15.2275, 6.59735, 14.3673>, <-0.170338, -0.0494527, 0.0734695>,
                         <-15.4357, 6.53692, 14.0429>, <-0.143337, -0.0416138, 0.122252> }
        smooth_triangle {<-15.4357, 6.53692, 14.0429>, <-0.139015, -0.040359, 0.126753>,
                         <-15.2958, 6.05513, 14.0429>, <-0.139015, -0.040359, 0.126753>,
                         <-15.0877, 6.11557, 14.3673>, <-0.175016, -0.0508109, 0.0617091> }
        smooth_triangle {<-15.2275, 6.59735, 14.3673>, <-0.170338, -0.0494527, 0.0734695>,
                         <-15.3674, 7.07914, 14.3673>, <-0.170338, -0.0494527, 0.0734696>,
                         <-15.5756, 7.01871, 14.0429>, <-0.143337, -0.0416138, 0.122252> }
        smooth_triangle {<-15.5756, 7.01871, 14.0429>, <-0.139015, -0.040359, 0.126753>,
                         <-15.4357, 6.53692, 14.0429>, <-0.139015, -0.040359, 0.126753>,
                         <-15.2275, 6.59735, 14.3673>, <-0.175016, -0.0508109, 0.0617091> }
        smooth_triangle {<-15.3674, 7.07914, 14.3673>, <-0.170338, -0.0494527, 0.0734696>,
                         <-15.5073, 7.56093, 14.3673>, <-0.170338, -0.0494527, 0.0734696>,
                         <-15.7155, 7.50049, 14.0429>, <-0.143337, -0.0416138, 0.122252> }
        smooth_triangle {<-15.7155, 7.50049, 14.0429>, <-0.139015, -0.0403591, 0.126753>,
                         <-15.5756, 7.01871, 14.0429>, <-0.139015, -0.040359, 0.126753>,
                         <-15.3674, 7.07914, 14.3673>, <-0.175016, -0.0508109, 0.0617091> }
        smooth_triangle {<-15.5073, 7.56093, 14.3673>, <-0.170338, -0.0494527, 0.0734696>,
                         <-15.6472, 8.04272, 14.3673>, <-0.170338, -0.0494528, 0.0734696>,
                         <-15.8553, 7.98228, 14.0429>, <-0.143337, -0.0416139, 0.122253> }
        smooth_triangle {<-15.8553, 7.98228, 14.0429>, <-0.139015, -0.0403591, 0.126753>,
                         <-15.7155, 7.50049, 14.0429>, <-0.139015, -0.0403591, 0.126753>,
                         <-15.5073, 7.56093, 14.3673>, <-0.175016, -0.0508109, 0.0617091> }
        smooth_triangle {<-15.6472, 8.04272, 14.3673>, <-0.170338, -0.0494528, 0.0734696>,
                         <-15.787, 8.52451, 14.3673>, <-0.170324, -0.0495023, 0.0734696>,
                         <-15.9952, 8.46407, 14.0429>, <-0.143323, -0.0416634, 0.122253> }
        smooth_triangle {<-15.9952, 8.46407, 14.0429>, <-0.138996, -0.0404251, 0.126753>,
                         <-15.8553, 7.98228, 14.0429>, <-0.139015, -0.0403591, 0.126753>,
                         <-15.6472, 8.04272, 14.3673>, <-0.175016, -0.0508109, 0.0617091> }
        smooth_triangle {<-15.787, 8.52451, 14.3673>, <-0.170306, -0.049524, 0.0734623>,
                         <-15.9271, 9.00623, 14.3674>, <-0.169799, -0.0511085, 0.0734436>,
                         <-16.1353, 8.94581, 14.0431>, <-0.142808, -0.0432725, 0.122211> }
        smooth_triangle {<-16.1353, 8.94581, 14.0431>, <-0.138333, -0.0425417, 0.126707>,
                         <-15.9952, 8.46407, 14.0429>, <-0.138996, -0.0404251, 0.126753>,
                         <-15.787, 8.52451, 14.3673>, <-0.174997, -0.050877, 0.0617091> }
        smooth_triangle {<-15.9271, 9.00623, 14.3674>, <-0.169218, -0.0517847, 0.0731971>,
                         <-16.0748, 9.48563, 14.3708>, <-0.156071, -0.0745362, 0.0706002>,
                         <-16.2811, 9.42574, 14.0493>, <-0.130495, -0.0671106, 0.117161> }
        smooth_triangle {<-16.2811, 9.42574, 14.0493>, <-0.122689, -0.0734243, 0.120303>,
                         <-16.1353, 8.94581, 14.0431>, <-0.138333, -0.0425417, 0.126707>,
                         <-15.9271, 9.00623, 14.3674>, <-0.174321, -0.0529896, 0.0616842> }
        smooth_triangle {<-16.0748, 9.48563, 14.3708>, <-0.145633, -0.0824422, 0.0653749>,
                         <-16.3294, 9.90144, 14.4241>, <-0.0906682, -0.120863, 0.0486768>,
                         <-16.5067, 9.84996, 14.1477>, <-0.0743037, -0.116112, 0.0804078> }
        smooth_triangle {<-16.5067, 9.84996, 14.1477>, <-0.0616858, -0.128218, 0.0782656>,
                         <-16.2811, 9.42574, 14.0493>, <-0.122689, -0.0734243, 0.120303>,
                         <-16.0748, 9.48563, 14.3708>, <-0.156792, -0.083325, 0.0582216> }
        smooth_triangle {<-16.3294, 9.90144, 14.4241>, <-0.0678641, -0.120465, 0.0339696>,
                         <-16.771, 10.0754, 14.5796>, <-0.0256089, -0.0994494, 0.0192417>,
                         <-16.8637, 10.0485, 14.4352>, <-0.0180518, -0.0972554, 0.0343224> }
        smooth_triangle {<-16.8637, 10.0485, 14.4352>, <-0.0170888, -0.103606, 0.0364279>,
                         <-16.5067, 9.84996, 14.1477>, <-0.0616858, -0.128218, 0.0782656>,
                         <-16.3294, 9.90144, 14.4241>, <-0.0835052, -0.134553, 0.0359575> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.75134e-17>,
                         <-16.8637, 10.0485, 14.4352>, <-0.0170888, -0.103606, 0.0364279>,
                         <-16.771, 10.0754, 14.5796>, <-0.0271651, -0.106532, 0.0163203> }
        smooth_triangle {<-15.2788, 3.46034, 14.75>, <-0.0196562, 0.0206171, 0.00261147>,
                         <-14.9158, 3.80649, 14.75>, <-0.0481377, 0.0418287, 0.00195862>,
                         <-14.9483, 3.79704, 14.5796>, <-0.0463306, 0.0423533, 0.0114186> }
        smooth_triangle {<-14.9483, 3.79704, 14.5796>, <-0.0421177, 0.0358537, 0.0126133>,
                         <-15.2788, 3.46034, 14.75>, <4.06263e-07, -4.5405e-07, -1.0917e-07>,
                         <-15.2788, 3.46034, 14.75>, <4.27117e-07, -4.47996e-07, -9.38851e-18> }
        smooth_triangle {<-14.9158, 3.80649, 14.75>, <-0.0653426, 0.0515881, 0.00470392>,
                         <-14.6062, 4.19855, 14.75>, <-0.128576, 0.0388155, 0.00224534>,
                         <-14.6685, 4.18047, 14.4241>, <-0.122973, 0.0404422, 0.0364941> }
        smooth_triangle {<-14.6685, 4.18047, 14.4241>, <-0.121368, 0.0202931, 0.0423869>,
                         <-14.9483, 3.79704, 14.5796>, <-0.0421177, 0.0358537, 0.0126133>,
                         <-14.9158, 3.80649, 14.75>, <-0.0445271, 0.0351542, 1.89149e-08> }
        smooth_triangle {<-14.6062, 4.19855, 14.75>, <-0.143124, 0.0138317, 0.00640995>,
                         <-14.6037, 4.689, 14.75>, <-0.178253, -0.0244625, 0.00124549>,
                         <-14.6761, 4.66797, 14.3708>, <-0.171301, -0.0224442, 0.0528833> }
        smooth_triangle {<-14.6761, 4.66797, 14.3708>, <-0.166408, -0.0302438, 0.0586864>,
                         <-14.6685, 4.18047, 14.4241>, <-0.121368, 0.0202931, 0.0423869>,
                         <-14.6062, 4.19855, 14.75>, <-0.128838, 0.0181241, -0.0032781> }
        smooth_triangle {<-14.6037, 4.689, 14.75>, <-0.178063, -0.0372652, 0.00191915>,
                         <-14.7351, 5.17314, 14.75>, <-0.184377, -0.051724, 8.42692e-05>,
                         <-14.8081, 5.15192, 14.3674>, <-0.177361, -0.0496873, 0.0557249> }
        smooth_triangle {<-14.8081, 5.15192, 14.3674>, <-0.174742, -0.0494977, 0.061577>,
                         <-14.6761, 4.66797, 14.3708>, <-0.166408, -0.0302438, 0.0586864>,
                         <-14.6037, 4.689, 14.75>, <-0.175677, -0.0329348, -0.010164> }
        smooth_triangle {<-14.7351, 5.17314, 14.75>, <-0.184172, -0.052517, 8.91321e-05>,
                         <-14.8747, 5.655, 14.75>, <-0.184374, -0.0534741, 2.57545e-06>,
                         <-14.9478, 5.63378, 14.3673>, <-0.177357, -0.0514368, 0.0558263> }
        smooth_triangle {<-14.9478, 5.63378, 14.3673>, <-0.175009, -0.0507731, 0.0617056>,
                         <-14.8081, 5.15192, 14.3674>, <-0.174742, -0.0494977, 0.061577>,
                         <-14.7351, 5.17314, 14.75>, <-0.184096, -0.0522133, -0.0126106> }
        smooth_triangle {<-14.8747, 5.655, 14.75>, <-0.184367, -0.0534989, 2.58035e-06>,
                         <-15.0146, 6.13679, 14.75>, <-0.184372, -0.0535272, 2.20623e-09>,
                         <-15.0877, 6.11557, 14.3673>, <-0.177355, -0.05149, 0.0558289> }
        smooth_triangle {<-15.0877, 6.11557, 14.3673>, <-0.175016, -0.0508109, 0.0617091>,
                         <-14.9478, 5.63378, 14.3673>, <-0.175009, -0.0507731, 0.0617056>,
                         <-14.8747, 5.655, 14.75>, <-0.184365, -0.0534894, -0.012726> }
        smooth_triangle {<-15.0146, 6.13679, 14.75>, <-0.184372, -0.0535272, 4.41246e-09>,
                         <-15.1544, 6.61858, 14.75>, <-0.184372, -0.0535272, 2.20623e-09>,
                         <-15.2275, 6.59735, 14.3673>, <-0.177355, -0.05149, 0.0558289> }
        smooth_triangle {<-15.2275, 6.59735, 14.3673>, <-0.175016, -0.0508109, 0.0617091>,
                         <-15.0877, 6.11557, 14.3673>, <-0.175016, -0.0508109, 0.0617091>,
                         <-15.0146, 6.13679, 14.75>, <-0.184372, -0.0535272, -0.0127294> }
        smooth_triangle {<-15.1544, 6.61858, 14.75>, <-0.184372, -0.0535273, 4.41246e-09>,
                         <-15.2943, 7.10037, 14.75>, <-0.184372, -0.0535273, 2.20623e-09>,
                         <-15.3674, 7.07914, 14.3673>, <-0.177355, -0.05149, 0.0558289> }
        smooth_triangle {<-15.3674, 7.07914, 14.3673>, <-0.175016, -0.0508109, 0.0617091>,
                         <-15.2275, 6.59735, 14.3673>, <-0.175016, -0.0508109, 0.0617091>,
                         <-15.1544, 6.61858, 14.75>, <-0.184372, -0.0535272, -0.0127294> }
        smooth_triangle {<-15.2943, 7.10037, 14.75>, <-0.184372, -0.0535273, 4.41246e-09>,
                         <-15.4342, 7.58216, 14.75>, <-0.184372, -0.0535273, 2.20623e-09>,
                         <-15.5073, 7.56093, 14.3673>, <-0.177355, -0.05149, 0.0558289> }
        smooth_triangle {<-15.5073, 7.56093, 14.3673>, <-0.175016, -0.0508109, 0.0617091>,
                         <-15.3674, 7.07914, 14.3673>, <-0.175016, -0.0508109, 0.0617091>,
                         <-15.2943, 7.10037, 14.75>, <-0.184372, -0.0535273, -0.0127294> }
        smooth_triangle {<-15.4342, 7.58216, 14.75>, <-0.184372, -0.0535273, 4.41246e-09>,
                         <-15.574, 8.06394, 14.75>, <-0.184372, -0.0535273, 2.20623e-09>,
                         <-15.6472, 8.04272, 14.3673>, <-0.177355, -0.05149, 0.0558289> }
        smooth_triangle {<-15.6472, 8.04272, 14.3673>, <-0.175016, -0.0508109, 0.0617091>,
                         <-15.5073, 7.56093, 14.3673>, <-0.175016, -0.0508109, 0.0617091>,
                         <-15.4342, 7.58216, 14.75>, <-0.184372, -0.0535273, -0.0127294> }
        smooth_triangle {<-15.574, 8.06394, 14.75>, <-0.184372, -0.0535273, 4.41246e-09>,
                         <-15.7139, 8.54573, 14.75>, <-0.184358, -0.0535768, 2.20623e-09>,
                         <-15.787, 8.52451, 14.3673>, <-0.177341, -0.0515396, 0.0558289> }
        smooth_triangle {<-15.787, 8.52451, 14.3673>, <-0.174997, -0.050877, 0.0617091>,
                         <-15.6472, 8.04272, 14.3673>, <-0.175016, -0.0508109, 0.0617091>,
                         <-15.574, 8.06394, 14.75>, <-0.184372, -0.0535273, -0.0127294> }
        smooth_triangle {<-15.7139, 8.54573, 14.75>, <-0.184338, -0.053598, -2.57152e-06>,
                         <-15.8541, 9.02745, 14.75>, <-0.183828, -0.0551814, -2.57104e-06>,
                         <-15.9271, 9.00623, 14.3674>, <-0.176814, -0.0531452, 0.0558077> }
        smooth_triangle {<-15.9271, 9.00623, 14.3674>, <-0.174321, -0.0529896, 0.0616842>,
                         <-15.787, 8.52451, 14.3673>, <-0.174997, -0.050877, 0.0617091>,
                         <-15.7139, 8.54573, 14.75>, <-0.184353, -0.0535933, -0.0127294> }
        smooth_triangle {<-15.8541, 9.02745, 14.75>, <-0.183184, -0.0558391, -8.91231e-05>,
                         <-16.0024, 9.50666, 14.75>, <-0.169542, -0.0784469, -8.42648e-05>,
                         <-16.0748, 9.48563, 14.3708>, <-0.163023, -0.0765544, 0.0531242> }
        smooth_triangle {<-16.0748, 9.48563, 14.3708>, <-0.156792, -0.083325, 0.0582216>,
                         <-15.9271, 9.00623, 14.3674>, <-0.174321, -0.0529896, 0.0616842>,
                         <-15.8541, 9.02745, 14.75>, <-0.183672, -0.0557046, -0.0127294> }
        smooth_triangle {<-16.0024, 9.50666, 14.75>, <-0.157755, -0.0859614, -0.00191914>,
                         <-16.2671, 9.91952, 14.75>, <-0.0997288, -0.123494, -0.00124549>,
                         <-16.3294, 9.90144, 14.4241>, <-0.0962713, -0.12249, 0.0345912> }
        smooth_triangle {<-16.3294, 9.90144, 14.4241>, <-0.0835052, -0.134553, 0.0359575>,
                         <-16.0748, 9.48563, 14.3708>, <-0.156792, -0.083325, 0.0582216>,
                         <-16.0024, 9.50666, 14.75>, <-0.165483, -0.0858483, -0.0127229> }
        smooth_triangle {<-16.2671, 9.91952, 14.75>, <-0.0731286, -0.121994, -0.00640995>,
                         <-16.7385, 10.0849, 14.75>, <-0.0288557, -0.100392, -0.00224534>,
                         <-16.771, 10.0754, 14.5796>, <-0.027416, -0.0999741, 0.0146988> }
        smooth_triangle {<-16.771, 10.0754, 14.5796>, <-0.0271651, -0.106532, 0.0163203>,
                         <-16.3294, 9.90144, 14.4241>, <-0.0835052, -0.134553, 0.0359575>,
                         <-16.2671, 9.91952, 14.75>, <-0.0881152, -0.135891, -0.0118247> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.92481e-17>,
                         <-16.771, 10.0754, 14.5796>, <-0.0271651, -0.106532, 0.0163203>,
                         <-16.7385, 10.0849, 14.75>, <-0.0290845, -0.107089, -0.00627191> }
        smooth_triangle {<-15.2788, 3.46034, 14.75>, <-0.0196562, 0.0206171, -0.0026114>,
                         <-14.9483, 3.79704, 14.9204>, <-0.0463306, 0.0423533, -0.0114186>,
                         <-14.9158, 3.80649, 14.75>, <-0.0481377, 0.0418287, -0.00195859> }
        smooth_triangle {<-14.9158, 3.80649, 14.75>, <-0.0445271, 0.0351542, 1.89149e-08>,
                         <-15.2788, 3.46034, 14.75>, <4.27117e-07, -4.47996e-07, -9.38851e-18>,
                         <-15.2788, 3.46034, 14.75>, <4.06263e-07, -4.5405e-07, 1.0917e-07> }
        smooth_triangle {<-14.9483, 3.79704, 14.9204>, <-0.0635355, 0.0521127, -0.0141639>,
                         <-14.6685, 4.18047, 15.0759>, <-0.121166, 0.0409669, -0.0410369>,
                         <-14.6062, 4.19855, 14.75>, <-0.128576, 0.0388155, -0.00716248> }
        smooth_triangle {<-14.6062, 4.19855, 14.75>, <-0.128838, 0.0181241, -0.0032781>,
                         <-14.9158, 3.80649, 14.75>, <-0.0445271, 0.0351542, 1.89149e-08>,
                         <-14.9483, 3.79704, 14.9204>, <-0.0421177, 0.0358537, -0.0126133> }
        smooth_triangle {<-14.6685, 4.18047, 15.0759>, <-0.135714, 0.0159831, -0.0452015>,
                         <-14.6761, 4.66797, 15.1292>, <-0.165698, -0.0208175, -0.0669689>,
                         <-14.6037, 4.689, 14.75>, <-0.178253, -0.0244625, -0.0164916> }
        smooth_triangle {<-14.6037, 4.689, 14.75>, <-0.175677, -0.0329348, -0.010164>,
                         <-14.6062, 4.19855, 14.75>, <-0.128838, 0.0181241, -0.0032781>,
                         <-14.6685, 4.18047, 15.0759>, <-0.118958, 0.0209926, -0.048444> }
        smooth_triangle {<-14.6761, 4.66797, 15.1292>, <-0.165508, -0.0336202, -0.0676425>,
                         <-14.8081, 5.15192, 15.1326>, <-0.17041, -0.0476691, -0.0732009>,
                         <-14.7351, 5.17314, 14.75>, <-0.184377, -0.051724, -0.0190001> }
        smooth_triangle {<-14.7351, 5.17314, 14.75>, <-0.184096, -0.0522133, -0.0126106>,
                         <-14.6037, 4.689, 14.75>, <-0.175677, -0.0329348, -0.010164>,
                         <-14.6761, 4.66797, 15.1292>, <-0.158937, -0.0280749, -0.0774671> }
        smooth_triangle {<-14.8081, 5.15192, 15.1326>, <-0.170205, -0.0484621, -0.0732058>,
                         <-14.9478, 5.63378, 15.1327>, <-0.170342, -0.0494001, -0.0734622>,
                         <-14.8747, 5.655, 14.75>, <-0.184374, -0.0534741, -0.0190915> }
        smooth_triangle {<-14.8747, 5.655, 14.75>, <-0.184365, -0.0534894, -0.012726>,
                         <-14.7351, 5.17314, 14.75>, <-0.184096, -0.0522133, -0.0126106>,
                         <-14.8081, 5.15192, 15.1326>, <-0.165473, -0.0468067, -0.0848783> }
        smooth_triangle {<-14.9478, 5.63378, 15.1327>, <-0.170334, -0.0494249, -0.0734622>,
                         <-15.0877, 6.11557, 15.1327>, <-0.170338, -0.0494527, -0.0734695>,
                         <-15.0146, 6.13679, 14.75>, <-0.184372, -0.0535272, -0.0190941> }
        smooth_triangle {<-15.0146, 6.13679, 14.75>, <-0.184372, -0.0535272, -0.0127294>,
                         <-14.8747, 5.655, 14.75>, <-0.184365, -0.0534894, -0.012726>,
                         <-14.9478, 5.63378, 15.1327>, <-0.165655, -0.0480574, -0.0852202> }
        smooth_triangle {<-15.0877, 6.11557, 15.1327>, <-0.170338, -0.0494527, -0.0734695>,
                         <-15.2275, 6.59735, 15.1327>, <-0.170338, -0.0494527, -0.0734695>,
                         <-15.1544, 6.61858, 14.75>, <-0.184372, -0.0535272, -0.0190941> }
        smooth_triangle {<-15.1544, 6.61858, 14.75>, <-0.184372, -0.0535272, -0.0127294>,
                         <-15.0146, 6.13679, 14.75>, <-0.184372, -0.0535272, -0.0127294>,
                         <-15.0877, 6.11557, 15.1327>, <-0.16566, -0.0480945, -0.08523> }
        smooth_triangle {<-15.2275, 6.59735, 15.1327>, <-0.170338, -0.0494527, -0.0734695>,
                         <-15.3674, 7.07914, 15.1327>, <-0.170338, -0.0494527, -0.0734696>,
                         <-15.2943, 7.10037, 14.75>, <-0.184372, -0.0535273, -0.0190941> }
        smooth_triangle {<-15.2943, 7.10037, 14.75>, <-0.184372, -0.0535273, -0.0127294>,
                         <-15.1544, 6.61858, 14.75>, <-0.184372, -0.0535272, -0.0127294>,
                         <-15.2275, 6.59735, 15.1327>, <-0.16566, -0.0480945, -0.08523> }
        smooth_triangle {<-15.3674, 7.07914, 15.1327>, <-0.170338, -0.0494527, -0.0734696>,
                         <-15.5073, 7.56093, 15.1327>, <-0.170338, -0.0494527, -0.0734696>,
                         <-15.4342, 7.58216, 14.75>, <-0.184372, -0.0535273, -0.0190941> }
        smooth_triangle {<-15.4342, 7.58216, 14.75>, <-0.184372, -0.0535273, -0.0127294>,
                         <-15.2943, 7.10037, 14.75>, <-0.184372, -0.0535273, -0.0127294>,
                         <-15.3674, 7.07914, 15.1327>, <-0.16566, -0.0480946, -0.08523> }
        smooth_triangle {<-15.5073, 7.56093, 15.1327>, <-0.170338, -0.0494527, -0.0734696>,
                         <-15.6472, 8.04272, 15.1327>, <-0.170338, -0.0494528, -0.0734696>,
                         <-15.574, 8.06394, 14.75>, <-0.184372, -0.0535273, -0.0190941> }
        smooth_triangle {<-15.574, 8.06394, 14.75>, <-0.184372, -0.0535273, -0.0127294>,
                         <-15.4342, 7.58216, 14.75>, <-0.184372, -0.0535273, -0.0127294>,
                         <-15.5073, 7.56093, 15.1327>, <-0.16566, -0.0480946, -0.08523> }
        smooth_triangle {<-15.6472, 8.04272, 15.1327>, <-0.170338, -0.0494528, -0.0734696>,
                         <-15.787, 8.52451, 15.1327>, <-0.170324, -0.0495023, -0.0734696>,
                         <-15.7139, 8.54573, 14.75>, <-0.184358, -0.0535768, -0.0190941> }
        smooth_triangle {<-15.7139, 8.54573, 14.75>, <-0.184353, -0.0535933, -0.0127294>,
                         <-15.574, 8.06394, 14.75>, <-0.184372, -0.0535273, -0.0127294>,
                         <-15.6472, 8.04272, 15.1327>, <-0.16566, -0.0480946, -0.08523> }
        smooth_triangle {<-15.787, 8.52451, 15.1327>, <-0.170304, -0.0495234, -0.073467>,
                         <-15.9271, 9.00623, 15.1326>, <-0.169797, -0.0511079, -0.0734483>,
                         <-15.8541, 9.02745, 14.75>, <-0.183828, -0.0551814, -0.0190916> }
        smooth_triangle {<-15.8541, 9.02745, 14.75>, <-0.183672, -0.0557046, -0.0127294>,
                         <-15.7139, 8.54573, 14.75>, <-0.184353, -0.0535933, -0.0127294>,
                         <-15.787, 8.52451, 15.1327>, <-0.165641, -0.0481606, -0.08523> }
        smooth_triangle {<-15.9271, 9.00623, 15.1326>, <-0.169153, -0.0517656, -0.0733618>,
                         <-16.0748, 9.48563, 15.1292>, <-0.15601, -0.0745182, -0.0707559>,
                         <-16.0024, 9.50666, 14.75>, <-0.169542, -0.0784469, -0.0190001> }
        smooth_triangle {<-16.0024, 9.50666, 14.75>, <-0.165483, -0.0858483, -0.0127229>,
                         <-15.8541, 9.02745, 14.75>, <-0.183672, -0.0557046, -0.0127294>,
                         <-15.9271, 9.00623, 15.1326>, <-0.164965, -0.0502733, -0.0852051> }
        smooth_triangle {<-16.0748, 9.48563, 15.1292>, <-0.144222, -0.0820327, -0.068921>,
                         <-16.3294, 9.90144, 15.0759>, <-0.0897528, -0.120597, -0.0509781>,
                         <-16.2671, 9.91952, 14.75>, <-0.0997288, -0.123494, -0.0164916> }
        smooth_triangle {<-16.2671, 9.91952, 14.75>, <-0.0881152, -0.135891, -0.0118247>,
                         <-16.0024, 9.50666, 14.75>, <-0.165483, -0.0858483, -0.0127229>,
                         <-16.0748, 9.48563, 15.1292>, <-0.14744, -0.0806101, -0.0817306> }
        smooth_triangle {<-16.3294, 9.90144, 15.0759>, <-0.0631526, -0.119098, -0.0458137>,
                         <-16.771, 10.0754, 14.9204>, <-0.0239586, -0.0989703, -0.0233905>,
                         <-16.7385, 10.0849, 14.75>, <-0.0288557, -0.100392, -0.00716252> }
        smooth_triangle {<-16.7385, 10.0849, 14.75>, <-0.0290845, -0.107089, -0.00627191>,
                         <-16.2671, 9.91952, 14.75>, <-0.0881152, -0.135891, -0.0118247>,
                         <-16.3294, 9.90144, 15.0759>, <-0.0748138, -0.13203, -0.0578068> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.75134e-17>,
                         <-16.7385, 10.0849, 14.75>, <-0.0290845, -0.107089, -0.00627191>,
                         <-16.771, 10.0754, 14.9204>, <-0.0225551, -0.105193, -0.0279093> }
        smooth_triangle {<-15.2788, 3.46034, 14.75>, <-0.0177368, 0.0211743, -0.0074367>,
                         <-15.041, 3.77014, 15.0648>, <-0.0397449, 0.0442653, -0.0230574>,
                         <-14.9483, 3.79704, 14.9204>, <-0.044891, 0.0427713, -0.0150376> }
        smooth_triangle {<-14.9483, 3.79704, 14.9204>, <-0.0421177, 0.0358537, -0.0126133>,
                         <-15.2788, 3.46034, 14.75>, <4.06263e-07, -4.5405e-07, 1.0917e-07>,
                         <-15.2788, 3.46034, 14.75>, <3.46875e-07, -4.71292e-07, 2.0172e-07> }
        smooth_triangle {<-15.041, 3.77014, 15.0648>, <-0.0549319, 0.0546105, -0.0308753>,
                         <-14.8458, 4.12899, 15.3523>, <-0.0984132, 0.0475725, -0.0780717>,
                         <-14.6685, 4.18047, 15.0759>, <-0.117708, 0.0419706, -0.0497286> }
        smooth_triangle {<-14.6685, 4.18047, 15.0759>, <-0.118958, 0.0209926, -0.048444>,
                         <-14.9483, 3.79704, 14.9204>, <-0.0421177, 0.0358537, -0.0126133>,
                         <-15.041, 3.77014, 15.0648>, <-0.0352561, 0.0378458, -0.0233063> }
        smooth_triangle {<-14.8458, 4.12899, 15.3523>, <-0.1099, 0.0234774, -0.0899315>,
                         <-14.8824, 4.60808, 15.4507>, <-0.157842, -0.0166075, -0.104379>,
                         <-14.6761, 4.66797, 15.1292>, <-0.15918, -0.0189251, -0.0833558> }
        smooth_triangle {<-14.6761, 4.66797, 15.1292>, <-0.158937, -0.0280749, -0.0774671>,
                         <-14.6685, 4.18047, 15.0759>, <-0.118958, 0.0209926, -0.048444>,
                         <-14.8458, 4.12899, 15.3523>, <-0.0932312, 0.0284617, -0.0862348> }
        smooth_triangle {<-14.8824, 4.60808, 15.4507>, <-0.156471, -0.0419254, -0.108215>,
                         <-15.0163, 5.0915, 15.4569>, <-0.156728, -0.0436891, -0.108708>,
                         <-14.8081, 5.15192, 15.1326>, <-0.163396, -0.0456329, -0.0908326> }
        smooth_triangle {<-14.8081, 5.15192, 15.1326>, <-0.165473, -0.0468067, -0.0848783>,
                         <-14.6761, 4.66797, 15.1292>, <-0.158937, -0.0280749, -0.0774671>,
                         <-14.8824, 4.60808, 15.4507>, <-0.155777, -0.0417395, -0.107735> }
        smooth_triangle {<-15.0163, 5.0915, 15.4569>, <-0.156311, -0.045273, -0.108736>,
                         <-15.156, 5.57334, 15.4571>, <-0.130378, -0.0377979, -0.135743>,
                         <-14.9478, 5.63378, 15.1327>, <-0.163324, -0.0473629, -0.0911028> }
        smooth_triangle {<-14.9478, 5.63378, 15.1327>, <-0.165655, -0.0480574, -0.0852202>,
                         <-14.8081, 5.15192, 15.1326>, <-0.165473, -0.0468067, -0.0848783>,
                         <-15.0163, 5.0915, 15.4569>, <-0.15629, -0.0452669, -0.108721> }
        smooth_triangle {<-15.156, 5.57334, 15.4571>, <-0.130371, -0.0378226, -0.135743>,
                         <-15.2958, 6.05513, 15.4571>, <-0.156303, -0.0453782, -0.108751>,
                         <-15.0877, 6.11557, 15.1327>, <-0.16332, -0.0474154, -0.0911102> }
        smooth_triangle {<-15.0877, 6.11557, 15.1327>, <-0.16566, -0.0480945, -0.08523>,
                         <-14.9478, 5.63378, 15.1327>, <-0.165655, -0.0480574, -0.0852202>,
                         <-15.156, 5.57334, 15.4571>, <-0.121727, -0.0353041, -0.14474> }
        smooth_triangle {<-15.2958, 6.05513, 15.4571>, <-0.156303, -0.0453782, -0.108751>,
                         <-15.4357, 6.53692, 15.4571>, <-0.130371, -0.0378495, -0.135754>,
                         <-15.2275, 6.59735, 15.1327>, <-0.163321, -0.0474155, -0.0911102> }
        smooth_triangle {<-15.2275, 6.59735, 15.1327>, <-0.16566, -0.0480945, -0.08523>,
                         <-15.0877, 6.11557, 15.1327>, <-0.16566, -0.0480945, -0.08523>,
                         <-15.2958, 6.05513, 15.4571>, <-0.156303, -0.0453782, -0.108751> }
        smooth_triangle {<-15.4357, 6.53692, 15.4571>, <-0.130371, -0.0378495, -0.135754>,
                         <-15.5756, 7.01871, 15.4571>, <-0.130371, -0.0378495, -0.135754>,
                         <-15.3674, 7.07914, 15.1327>, <-0.163321, -0.0474155, -0.0911102> }
        smooth_triangle {<-15.3674, 7.07914, 15.1327>, <-0.16566, -0.0480946, -0.08523>,
                         <-15.2275, 6.59735, 15.1327>, <-0.16566, -0.0480945, -0.08523>,
                         <-15.4357, 6.53692, 15.4571>, <-0.121727, -0.0353399, -0.144755> }
        smooth_triangle {<-15.5756, 7.01871, 15.4571>, <-0.130371, -0.0378495, -0.135754>,
                         <-15.7155, 7.50049, 15.4571>, <-0.130371, -0.0378495, -0.135754>,
                         <-15.5073, 7.56093, 15.1327>, <-0.163321, -0.0474155, -0.0911102> }
        smooth_triangle {<-15.5073, 7.56093, 15.1327>, <-0.16566, -0.0480946, -0.08523>,
                         <-15.3674, 7.07914, 15.1327>, <-0.16566, -0.0480946, -0.08523>,
                         <-15.5756, 7.01871, 15.4571>, <-0.121727, -0.0353399, -0.144755> }
        smooth_triangle {<-15.7155, 7.50049, 15.4571>, <-0.130371, -0.0378495, -0.135754>,
                         <-15.8553, 7.98228, 15.4571>, <-0.130371, -0.0378495, -0.135754>,
                         <-15.6472, 8.04272, 15.1327>, <-0.163321, -0.0474155, -0.0911103> }
        smooth_triangle {<-15.6472, 8.04272, 15.1327>, <-0.16566, -0.0480946, -0.08523>,
                         <-15.5073, 7.56093, 15.1327>, <-0.16566, -0.0480946, -0.08523>,
                         <-15.7155, 7.50049, 15.4571>, <-0.121727, -0.0353399, -0.144755> }
        smooth_triangle {<-15.8553, 7.98228, 15.4571>, <-0.130371, -0.0378495, -0.135754>,
                         <-15.9952, 8.46407, 15.4571>, <-0.156289, -0.0454278, -0.108751>,
                         <-15.787, 8.52451, 15.1327>, <-0.163306, -0.047465, -0.0911103> }
        smooth_triangle {<-15.787, 8.52451, 15.1327>, <-0.165641, -0.0481606, -0.08523>,
                         <-15.6472, 8.04272, 15.1327>, <-0.16566, -0.0480946, -0.08523>,
                         <-15.8553, 7.98228, 15.4571>, <-0.121727, -0.0353399, -0.144755> }
        smooth_triangle {<-15.9952, 8.46407, 15.4571>, <-0.156254, -0.0454712, -0.108736>,
                         <-16.1353, 8.94581, 15.4569>, <-0.155757, -0.0470319, -0.108709>,
                         <-15.9271, 9.00623, 15.1326>, <-0.162782, -0.0490712, -0.0910842> }
        smooth_triangle {<-15.9271, 9.00623, 15.1326>, <-0.164965, -0.0502733, -0.0852051>,
                         <-15.787, 8.52451, 15.1327>, <-0.165641, -0.0481606, -0.08523>,
                         <-15.9952, 8.46407, 15.4571>, <-0.156275, -0.0454773, -0.108751> }
        smooth_triangle {<-16.1353, 8.94581, 15.4569>, <-0.154596, -0.0483843, -0.108216>,
                         <-16.2811, 9.42574, 15.4507>, <-0.142196, -0.0705002, -0.104379>,
                         <-16.0748, 9.48563, 15.1292>, <-0.149058, -0.0725, -0.0882319> }
        smooth_triangle {<-16.0748, 9.48563, 15.1292>, <-0.14744, -0.0806101, -0.0817306>,
                         <-15.9271, 9.00623, 15.1326>, <-0.164965, -0.0502733, -0.0852051>,
                         <-16.1353, 8.94581, 15.4569>, <-0.155282, -0.0485988, -0.108696> }
        smooth_triangle {<-16.2811, 9.42574, 15.4507>, <-0.12132, -0.0863122, -0.0939282>,
                         <-16.5067, 9.84996, 15.3523>, <-0.062259, -0.112615, -0.0929498>,
                         <-16.3294, 9.90144, 15.0759>, <-0.0841497, -0.118971, -0.0650637> }
        smooth_triangle {<-16.3294, 9.90144, 15.0759>, <-0.0748138, -0.13203, -0.0578068>,
                         <-16.0748, 9.48563, 15.1292>, <-0.14744, -0.0806101, -0.0817306>,
                         <-16.2811, 9.42574, 15.4507>, <-0.130482, -0.0928307, -0.101022> }
        smooth_triangle {<-16.5067, 9.84996, 15.3523>, <-0.0394548, -0.112218, -0.0782427>,
                         <-16.8637, 10.0485, 15.0648>, <-0.0159308, -0.0801729, -0.0251583>,
                         <-16.771, 10.0754, 14.9204>, <-0.0221515, -0.0984457, -0.0279334> }
        smooth_triangle {<-16.771, 10.0754, 14.9204>, <-0.0225551, -0.105193, -0.0279093>,
                         <-16.3294, 9.90144, 15.0759>, <-0.0748138, -0.13203, -0.0578068>,
                         <-16.5067, 9.84996, 15.3523>, <-0.0456262, -0.123556, -0.0949883> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.92481e-17>,
                         <-16.771, 10.0754, 14.9204>, <-0.0225551, -0.105193, -0.0279093>,
                         <-16.8637, 10.0485, 15.0648>, <-0.010921, -0.0821434, -0.0223107> }
        smooth_triangle {<-15.2788, 3.46034, 14.75>, <-0.0141901, 0.022204, -0.0111298>,
                         <-15.1797, 3.72987, 15.1613>, <-0.0293831, 0.0472736, -0.0311859>,
                         <-15.041, 3.77014, 15.0648>, <-0.0370848, 0.0450376, -0.0258272> }
        smooth_triangle {<-15.041, 3.77014, 15.0648>, <-0.0352561, 0.0378458, -0.0233063>,
                         <-15.2788, 3.46034, 14.75>, <3.46875e-07, -4.71292e-07, 2.0172e-07>,
                         <-15.2788, 3.46034, 14.75>, <2.57996e-07, -4.97096e-07, 2.6356e-07> }
        smooth_triangle {<-15.1797, 3.72987, 15.1613>, <-0.0408416, 0.0587013, -0.0428863>,
                         <-15.1112, 4.05195, 15.5369>, <-0.0637818, 0.0576267, -0.103221>,
                         <-14.8458, 4.12899, 15.3523>, <-0.0920246, 0.0494272, -0.084724> }
        smooth_triangle {<-14.8458, 4.12899, 15.3523>, <-0.0932312, 0.0284617, -0.0862348>,
                         <-15.041, 3.77014, 15.0648>, <-0.0352561, 0.0378458, -0.0233063>,
                         <-15.1797, 3.72987, 15.1613>, <-0.0249871, 0.0408271, -0.0304512> }
        smooth_triangle {<-15.1112, 4.05195, 15.5369>, <-0.0696128, 0.0351737, -0.12097>,
                         <-15.1911, 4.51845, 15.6655>, <-0.07383, 0.00585383, -0.163979>,
                         <-14.8824, 4.60808, 15.4507>, <-0.104054, 0.00501309, -0.147461> }
        smooth_triangle {<-14.8824, 4.60808, 15.4507>, <-0.100217, -0.0037362, -0.145597>,
                         <-14.8458, 4.12899, 15.3523>, <-0.0932312, 0.0284617, -0.0862348>,
                         <-15.1112, 4.05195, 15.5369>, <-0.0555741, 0.0393944, -0.110897> }
        smooth_triangle {<-15.1911, 4.51845, 15.6655>, <-0.0722296, -0.00653948, -0.16685>,
                         <-15.3277, 5.00107, 15.6736>, <-0.0709309, -0.0187882, -0.176878>,
                         <-15.0163, 5.0915, 15.4569>, <-0.104721, -0.0280325, -0.162208> }
        smooth_triangle {<-15.0163, 5.0915, 15.4569>, <-0.104418, -0.028518, -0.161975>,
                         <-14.8824, 4.60808, 15.4507>, <-0.100217, -0.0037362, -0.145597>,
                         <-15.1911, 4.51845, 15.6655>, <-0.0611971, 0.000301208, -0.168241> }
        smooth_triangle {<-15.3277, 5.00107, 15.6736>, <-0.070716, -0.0195783, -0.176899>,
                         <-15.4675, 5.48289, 15.6739>, <-0.0705681, -0.0204337, -0.177358>,
                         <-15.156, 5.57334, 15.4571>, <-0.117412, -0.0340335, -0.149245> }
        smooth_triangle {<-15.156, 5.57334, 15.4571>, <-0.121727, -0.0353041, -0.14474>,
                         <-15.0163, 5.0915, 15.4569>, <-0.104418, -0.028518, -0.161975>,
                         <-15.3277, 5.00107, 15.6736>, <-0.0594656, -0.0160305, -0.181613> }
        smooth_triangle {<-15.4675, 5.48289, 15.6739>, <-0.0705609, -0.0204585, -0.177358>,
                         <-15.6074, 5.96468, 15.6739>, <-0.0705562, -0.0204839, -0.177371>,
                         <-15.2958, 6.05513, 15.4571>, <-0.104438, -0.0303207, -0.162757> }
        smooth_triangle {<-15.2958, 6.05513, 15.4571>, <-0.104438, -0.0303207, -0.162757>,
                         <-15.156, 5.57334, 15.4571>, <-0.121727, -0.0353041, -0.14474>,
                         <-15.4675, 5.48289, 15.6739>, <-0.0592684, -0.017171, -0.182225> }
        smooth_triangle {<-15.6074, 5.96468, 15.6739>, <-0.0705562, -0.0204839, -0.177371>,
                         <-15.7473, 6.44646, 15.6739>, <-0.0705562, -0.0204839, -0.177371>,
                         <-15.4357, 6.53692, 15.4571>, <-0.117405, -0.0340851, -0.149256> }
        smooth_triangle {<-15.4357, 6.53692, 15.4571>, <-0.121727, -0.0353399, -0.144755>,
                         <-15.2958, 6.05513, 15.4571>, <-0.104438, -0.0303207, -0.162757>,
                         <-15.6074, 5.96468, 15.6739>, <-0.0592621, -0.017205, -0.182242> }
        smooth_triangle {<-15.7473, 6.44646, 15.6739>, <-0.0705562, -0.0204839, -0.177371>,
                         <-15.8871, 6.92825, 15.6739>, <-0.0705562, -0.0204839, -0.177371>,
                         <-15.5756, 7.01871, 15.4571>, <-0.117405, -0.0340851, -0.149256> }
        smooth_triangle {<-15.5756, 7.01871, 15.4571>, <-0.121727, -0.0353399, -0.144755>,
                         <-15.4357, 6.53692, 15.4571>, <-0.121727, -0.0353399, -0.144755>,
                         <-15.7473, 6.44646, 15.6739>, <-0.0592621, -0.017205, -0.182242> }
        smooth_triangle {<-15.8871, 6.92825, 15.6739>, <-0.0705563, -0.0204839, -0.177371>,
                         <-16.027, 7.41004, 15.6739>, <-0.0705563, -0.0204839, -0.177371>,
                         <-15.7155, 7.50049, 15.4571>, <-0.117405, -0.0340851, -0.149256> }
        smooth_triangle {<-15.7155, 7.50049, 15.4571>, <-0.121727, -0.0353399, -0.144755>,
                         <-15.5756, 7.01871, 15.4571>, <-0.121727, -0.0353399, -0.144755>,
                         <-15.8871, 6.92825, 15.6739>, <-0.0592621, -0.017205, -0.182243> }
        smooth_triangle {<-16.027, 7.41004, 15.6739>, <-0.0705563, -0.020484, -0.177371>,
                         <-16.1669, 7.89183, 15.6739>, <-0.0705563, -0.020484, -0.177371>,
                         <-15.8553, 7.98228, 15.4571>, <-0.117405, -0.0340851, -0.149256> }
        smooth_triangle {<-15.8553, 7.98228, 15.4571>, <-0.121727, -0.0353399, -0.144755>,
                         <-15.7155, 7.50049, 15.4571>, <-0.121727, -0.0353399, -0.144755>,
                         <-16.027, 7.41004, 15.6739>, <-0.0592622, -0.017205, -0.182243> }
        smooth_triangle {<-16.1669, 7.89183, 15.6739>, <-0.0705563, -0.020484, -0.177371>,
                         <-16.3068, 8.37362, 15.6739>, <-0.0705419, -0.0205335, -0.177371>,
                         <-15.9952, 8.46407, 15.4571>, <-0.104429, -0.0303538, -0.162757> }
        smooth_triangle {<-15.9952, 8.46407, 15.4571>, <-0.104424, -0.0303703, -0.162757>,
                         <-15.8553, 7.98228, 15.4571>, <-0.121727, -0.0353399, -0.144755>,
                         <-16.1669, 7.89183, 15.6739>, <-0.0592622, -0.017205, -0.182243> }
        smooth_triangle {<-16.3068, 8.37362, 15.6739>, <-0.0705277, -0.0205562, -0.17736>,
                         <-16.4467, 8.85538, 15.6736>, <-0.0700461, -0.0221481, -0.177315>,
                         <-16.1353, 8.94581, 15.4569>, <-0.104078, -0.0314601, -0.162715> }
        smooth_triangle {<-16.1353, 8.94581, 15.4569>, <-0.103927, -0.0319844, -0.162716>,
                         <-15.9952, 8.46407, 15.4571>, <-0.104424, -0.0303703, -0.162757>,
                         <-16.3068, 8.37362, 15.6739>, <-0.059243, -0.0172711, -0.182243> }
        smooth_triangle {<-16.4467, 8.85538, 15.6736>, <-0.0695832, -0.0228584, -0.176946>,
                         <-16.5898, 9.33611, 15.6655>, <-0.0599754, -0.0466374, -0.170664>,
                         <-16.2811, 9.42574, 15.4507>, <-0.0960924, -0.0485484, -0.158367> }
        smooth_triangle {<-16.2811, 9.42574, 15.4507>, <-0.0928735, -0.0561962, -0.156932>,
                         <-16.1353, 8.94581, 15.4569>, <-0.103927, -0.0319844, -0.162716>,
                         <-16.4467, 8.85538, 15.6736>, <-0.0586008, -0.0193936, -0.182182> }
        smooth_triangle {<-16.5898, 9.33611, 15.6655>, <-0.0520291, -0.0552669, -0.162844>,
                         <-16.7721, 9.77292, 15.5369>, <-0.0214331, -0.100763, -0.120771>,
                         <-16.5067, 9.84996, 15.3523>, <-0.0519058, -0.10961, -0.10373> }
        smooth_triangle {<-16.5067, 9.84996, 15.3523>, <-0.0456262, -0.123556, -0.0949883>,
                         <-16.2811, 9.42574, 15.4507>, <-0.0928735, -0.0561962, -0.156932>,
                         <-16.5898, 9.33611, 15.6655>, <-0.0457905, -0.0510989, -0.173806> }
        smooth_triangle {<-16.7721, 9.77292, 15.5369>, <-0.00564293, -0.102401, -0.0987599>,
                         <-17.0024, 10.0082, 15.1613>, <0.00615858, -0.0902266, -0.0523209>,
                         <-16.8637, 10.0485, 15.0648>, <-0.00745849, -0.0985272, -0.0518321> }
        smooth_triangle {<-16.8637, 10.0485, 15.0648>, <-0.00739563, -0.110628, -0.0567912>,
                         <-16.5067, 9.84996, 15.3523>, <-0.0456262, -0.123556, -0.0949883>,
                         <-16.7721, 9.77292, 15.5369>, <-0.00499584, -0.11176, -0.117709> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.92481e-17>,
                         <-16.8637, 10.0485, 15.0648>, <-0.00739563, -0.110628, -0.0567912>,
                         <-17.0024, 10.0082, 15.1613>, <0.0107395, -0.0955273, -0.05579> }
        smooth_triangle {<-15.2788, 3.46035, 14.75>, <-0.00955619, 0.0235493, -0.0131285>,
                         <-15.3433, 3.68237, 15.1952>, <-0.0168227, 0.0509201, -0.0345666>,
                         <-15.1797, 3.72987, 15.1613>, <-0.0259076, 0.0482826, -0.0326849> }
        smooth_triangle {<-15.1797, 3.72987, 15.1613>, <-0.0249871, 0.0408271, -0.0304512>,
                         <-15.2788, 3.46034, 14.75>, <2.57996e-07, -4.97096e-07, 2.6356e-07>,
                         <-15.2788, 3.46035, 14.75>, <1.53155e-07, -5.27533e-07, 2.85275e-07> }
        smooth_triangle {<-15.3433, 3.68237, 15.1952>, <-0.0234097, 0.0637621, -0.0483682>,
                         <-15.4242, 3.96107, 15.6017>, <-0.0225442, 0.0695989, -0.112655>,
                         <-15.1112, 4.05195, 15.5369>, <-0.0554348, 0.06005, -0.106821> }
        smooth_triangle {<-15.1112, 4.05195, 15.5369>, <-0.0555741, 0.0393944, -0.110897>,
                         <-15.1797, 3.72987, 15.1613>, <-0.0249871, 0.0408271, -0.0304512>,
                         <-15.3433, 3.68237, 15.1952>, <-0.012874, 0.0443438, -0.0329601> }
        smooth_triangle {<-15.4242, 3.96107, 15.6017>, <-0.020985, 0.0492914, -0.133592>,
                         <-15.5553, 4.41273, 15.7409>, <-0.00850265, 0.0248198, -0.178005>,
                         <-15.1911, 4.51845, 15.6655>, <-0.0580929, 0.0104227, -0.170766> }
        smooth_triangle {<-15.1911, 4.51845, 15.6655>, <-0.0611971, 0.000301208, -0.168241>,
                         <-15.1112, 4.05195, 15.5369>, <-0.0555741, 0.0393944, -0.110897>,
                         <-15.4242, 3.96107, 15.6017>, <-0.0117199, 0.0521262, -0.118676> }
        smooth_triangle {<-15.5553, 4.41273, 15.7409>, <-0.00570684, 0.0127735, -0.181392>,
                         <-15.6952, 4.8944, 15.7497>, <-0.000564107, 0.00164079, -0.191487>,
                         <-15.3277, 5.00107, 15.6736>, <-0.0539984, -0.0138724, -0.184182> }
        smooth_triangle {<-15.3277, 5.00107, 15.6736>, <-0.0594656, -0.0160305, -0.181613>,
                         <-15.1911, 4.51845, 15.6655>, <-0.0611971, 0.000301208, -0.168241>,
                         <-15.5553, 4.41273, 15.7409>, <0.0049232, 0.0194974, -0.177893> }
        smooth_triangle {<-15.6952, 4.8944, 15.7497>, <-0.000340537, 0.000853276, -0.191511>,
                         <-15.835, 5.37619, 15.75>, <-1.6875e-05, 4.88877e-05, -0.191972>,
                         <-15.4675, 5.48289, 15.6739>, <-0.053627, -0.0155153, -0.184665> }
        smooth_triangle {<-15.4675, 5.48289, 15.6739>, <-0.0592684, -0.017171, -0.182225>,
                         <-15.3277, 5.00107, 15.6736>, <-0.0594656, -0.0160305, -0.181613>,
                         <-15.6952, 4.8944, 15.7497>, <0.0117802, 0.00465373, -0.191353> }
        smooth_triangle {<-15.835, 5.37619, 15.75>, <-9.69022e-06, 2.41226e-05, -0.191972>,
                         <-15.9749, 5.85798, 15.75>, <-2.6775e-08, 8.43121e-08, -0.191985>,
                         <-15.6074, 5.96468, 15.6739>, <-0.0536151, -0.0155655, -0.184678> }
        smooth_triangle {<-15.6074, 5.96468, 15.6739>, <-0.0592621, -0.017205, -0.182242>,
                         <-15.4675, 5.48289, 15.6739>, <-0.0592684, -0.017171, -0.182225>,
                         <-15.835, 5.37619, 15.75>, <0.0122117, 0.00358122, -0.191968> }
        smooth_triangle {<-15.9749, 5.85798, 15.75>, <-2.88937e-08, 8.36969e-08, -0.191985>,
                         <-16.1148, 6.33977, 15.75>, <-2.6775e-08, 8.43121e-08, -0.191985>,
                         <-15.7473, 6.44646, 15.6739>, <-0.0536151, -0.0155656, -0.184678> }
        smooth_triangle {<-15.7473, 6.44646, 15.6739>, <-0.0592621, -0.017205, -0.182242>,
                         <-15.6074, 5.96468, 15.6739>, <-0.0592621, -0.017205, -0.182242>,
                         <-15.9749, 5.85798, 15.75>, <0.0122246, 0.00354917, -0.191985> }
        smooth_triangle {<-16.1148, 6.33977, 15.75>, <-2.88937e-08, 8.3697e-08, -0.191985>,
                         <-16.2546, 6.82156, 15.75>, <-2.6775e-08, 8.43121e-08, -0.191985>,
                         <-15.8871, 6.92825, 15.6739>, <-0.0536151, -0.0155656, -0.184678> }
        smooth_triangle {<-15.8871, 6.92825, 15.6739>, <-0.0592621, -0.017205, -0.182243>,
                         <-15.7473, 6.44646, 15.6739>, <-0.0592621, -0.017205, -0.182242>,
                         <-16.1148, 6.33977, 15.75>, <0.0122246, 0.00354917, -0.191985> }
        smooth_triangle {<-16.2546, 6.82156, 15.75>, <-2.88937e-08, 8.3697e-08, -0.191985>,
                         <-16.3945, 7.30335, 15.75>, <-2.6775e-08, 8.43121e-08, -0.191985>,
                         <-16.027, 7.41004, 15.6739>, <-0.0536151, -0.0155656, -0.184678> }
        smooth_triangle {<-16.027, 7.41004, 15.6739>, <-0.0592622, -0.017205, -0.182243>,
                         <-15.8871, 6.92825, 15.6739>, <-0.0592621, -0.017205, -0.182243>,
                         <-16.2546, 6.82156, 15.75>, <0.0122246, 0.00354917, -0.191985> }
        smooth_triangle {<-16.3945, 7.30335, 15.75>, <-2.88937e-08, 8.3697e-08, -0.191985>,
                         <-16.5344, 7.78513, 15.75>, <-2.6775e-08, 8.43121e-08, -0.191985>,
                         <-16.1669, 7.89183, 15.6739>, <-0.0536151, -0.0155656, -0.184678> }
        smooth_triangle {<-16.1669, 7.89183, 15.6739>, <-0.0592622, -0.017205, -0.182243>,
                         <-16.027, 7.41004, 15.6739>, <-0.0592622, -0.017205, -0.182243>,
                         <-16.3945, 7.30335, 15.75>, <0.0122246, 0.00354917, -0.191985> }
        smooth_triangle {<-16.5344, 7.78513, 15.75>, <-2.88937e-08, 8.3697e-08, -0.191985>,
                         <-16.6743, 8.26692, 15.75>, <1.43522e-05, -4.94433e-05, -0.191985>,
                         <-16.3068, 8.37362, 15.6739>, <-0.0536007, -0.0156151, -0.184678> }
        smooth_triangle {<-16.3068, 8.37362, 15.6739>, <-0.059243, -0.0172711, -0.182243>,
                         <-16.1669, 7.89183, 15.6739>, <-0.0592622, -0.017205, -0.182243>,
                         <-16.5344, 7.78513, 15.75>, <0.0122246, 0.00354917, -0.191985> }
        smooth_triangle {<-16.6743, 8.26692, 15.75>, <2.40114e-05, -7.34829e-05, -0.191972>,
                         <-16.8141, 8.74871, 15.7497>, <0.000487681, -0.00167057, -0.191924>,
                         <-16.4467, 8.85538, 15.6736>, <-0.0531095, -0.017231, -0.18462> }
        smooth_triangle {<-16.4467, 8.85538, 15.6736>, <-0.0586008, -0.0193936, -0.182182>,
                         <-16.3068, 8.37362, 15.6739>, <-0.059243, -0.0172711, -0.182243>,
                         <-16.6743, 8.26692, 15.75>, <0.0122438, 0.00348313, -0.191985> }
        smooth_triangle {<-16.8141, 8.74871, 15.7497>, <0.000796965, -0.00242545, -0.191488>,
                         <-16.954, 9.23039, 15.7409>, <0.00790609, -0.0269299, -0.184691>,
                         <-16.5898, 9.33611, 15.6655>, <-0.0431924, -0.0417649, -0.177903> }
        smooth_triangle {<-16.5898, 9.33611, 15.6655>, <-0.0457905, -0.0510989, -0.173806>,
                         <-16.4467, 8.85538, 15.6736>, <-0.0586008, -0.0193936, -0.182182>,
                         <-16.8141, 8.74871, 15.7497>, <0.012862, 0.00135368, -0.19192> }
        smooth_triangle {<-16.954, 9.23039, 15.7409>, <0.0125965, -0.0365047, -0.175466>,
                         <-17.0851, 9.68204, 15.6017>, <0.0265096, -0.0868439, -0.130205>,
                         <-16.7721, 9.77292, 15.5369>, <-0.00790602, -0.0968355, -0.126605> }
        smooth_triangle {<-16.7721, 9.77292, 15.5369>, <-0.00499584, -0.11176, -0.117709>,
                         <-16.5898, 9.33611, 15.6655>, <-0.0457905, -0.0510989, -0.173806>,
                         <-16.954, 9.23039, 15.7409>, <0.0223409, -0.0313189, -0.182856> }
        smooth_triangle {<-17.0851, 9.68204, 15.6017>, <0.0331354, -0.091143, -0.104242>,
                         <-17.166, 9.96074, 15.1952>, <0.0267936, -0.0842358, -0.0557017>,
                         <-17.0024, 10.0082, 15.1613>, <0.0105213, -0.08896, -0.0542027> }
        smooth_triangle {<-17.0024, 10.0082, 15.1613>, <0.0107395, -0.0955273, -0.05579>,
                         <-16.7721, 9.77292, 15.5369>, <-0.00499584, -0.11176, -0.117709>,
                         <-17.0851, 9.68204, 15.6017>, <0.0408917, -0.0984379, -0.122509> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.75134e-17>,
                         <-17.0024, 10.0082, 15.1613>, <0.0107395, -0.0955273, -0.05579>,
                         <-17.166, 9.96074, 15.1952>, <0.0324358, -0.0892283, -0.0577887> }
        smooth_triangle {<-15.2788, 3.46035, 14.75>, <-0.00454044, 0.0250055, -0.0131286>,
                         <-15.5069, 3.63487, 15.1613>, <-0.00397601, 0.0546498, -0.0326849>,
                         <-15.3433, 3.68237, 15.1952>, <-0.0130609, 0.0520123, -0.0345666> }
        smooth_triangle {<-15.3433, 3.68237, 15.1952>, <-0.012874, 0.0443438, -0.0329601>,
                         <-15.2788, 3.46035, 14.75>, <1.53155e-07, -5.27533e-07, 2.85275e-07>,
                         <-15.2788, 3.46035, 14.75>, <4.83136e-08, -5.57971e-07, 2.6356e-07> }
        smooth_triangle {<-15.5069, 3.63487, 15.1613>, <-0.00529009, 0.0690226, -0.0464865>,
                         <-15.7372, 3.8702, 15.5369>, <0.0190218, 0.0816664, -0.104939>,
                         <-15.4242, 3.96107, 15.6017>, <-0.0135094, 0.0722219, -0.112655> }
        smooth_triangle {<-15.4242, 3.96107, 15.6017>, <-0.0117199, 0.0521262, -0.118676>,
                         <-15.3433, 3.68237, 15.1952>, <-0.012874, 0.0443438, -0.0329601>,
                         <-15.5069, 3.63487, 15.1613>, <-0.000760882, 0.0478605, -0.0304512> }
        smooth_triangle {<-15.7372, 3.8702, 15.5369>, <0.0285799, 0.0636812, -0.125876>,
                         <-15.9195, 4.307, 15.6655>, <0.0570068, 0.0438386, -0.164932>,
                         <-15.5553, 4.41273, 15.7409>, <0.00853106, 0.029765, -0.178005> }
        smooth_triangle {<-15.5553, 4.41273, 15.7409>, <0.0049232, 0.0194974, -0.177893>,
                         <-15.4242, 3.96107, 15.6017>, <-0.0117199, 0.0521262, -0.118676>,
                         <-15.7372, 3.8702, 15.5369>, <0.031655, 0.0647189, -0.108388> }
        smooth_triangle {<-15.9195, 4.307, 15.6655>, <0.0610965, 0.032168, -0.168319>,
                         <-16.0626, 4.78774, 15.6736>, <0.069815, 0.0220734, -0.176943>,
                         <-15.6952, 4.8944, 15.7497>, <0.0177635, 0.0069617, -0.191487> }
        smooth_triangle {<-15.6952, 4.8944, 15.7497>, <0.0117802, 0.00465373, -0.191353>,
                         <-15.5553, 4.41273, 15.7409>, <0.0049232, 0.0194974, -0.177893>,
                         <-15.9195, 4.307, 15.6655>, <0.0695575, 0.0382621, -0.160462> }
        smooth_triangle {<-16.0626, 4.78774, 15.6736>, <0.0700479, 0.0212886, -0.176967>,
                         <-16.2025, 5.2695, 15.6739>, <0.0705347, 0.0205316, -0.17736>,
                         <-15.835, 5.37619, 15.75>, <0.0183201, 0.00537251, -0.191972> }
        smooth_triangle {<-15.835, 5.37619, 15.75>, <0.0122117, 0.00358122, -0.191968>,
                         <-15.6952, 4.8944, 15.7497>, <0.0117802, 0.00465373, -0.191353>,
                         <-16.0626, 4.78774, 15.6736>, <0.0811822, 0.0248027, -0.171961> }
        smooth_triangle {<-16.2025, 5.2695, 15.6739>, <0.0705419, 0.0205068, -0.17736>,
                         <-16.3424, 5.75128, 15.6739>, <0.0705562, 0.0204841, -0.177371>,
                         <-15.9749, 5.85798, 15.75>, <0.0183369, 0.00532371, -0.191985> }
        smooth_triangle {<-15.9749, 5.85798, 15.75>, <0.0122246, 0.00354917, -0.191985>,
                         <-15.835, 5.37619, 15.75>, <0.0122117, 0.00358122, -0.191968>,
                         <-16.2025, 5.2695, 15.6739>, <0.0818313, 0.0237933, -0.172485> }
        smooth_triangle {<-16.3424, 5.75128, 15.6739>, <0.0705562, 0.0204841, -0.177371>,
                         <-16.4823, 6.23307, 15.6739>, <0.0705562, 0.0204841, -0.177371>,
                         <-16.1148, 6.33977, 15.75>, <0.0183369, 0.00532371, -0.191985> }
        smooth_triangle {<-16.1148, 6.33977, 15.75>, <0.0122246, 0.00354917, -0.191985>,
                         <-15.9749, 5.85798, 15.75>, <0.0122246, 0.00354917, -0.191985>,
                         <-16.3424, 5.75128, 15.6739>, <0.0818503, 0.023763, -0.1725> }
        smooth_triangle {<-16.4823, 6.23307, 15.6739>, <0.0705562, 0.0204841, -0.177371>,
                         <-16.6222, 6.71486, 15.6739>, <0.0705562, 0.0204841, -0.177371>,
                         <-16.2546, 6.82156, 15.75>, <0.0183369, 0.00532371, -0.191985> }
        smooth_triangle {<-16.2546, 6.82156, 15.75>, <0.0122246, 0.00354917, -0.191985>,
                         <-16.1148, 6.33977, 15.75>, <0.0122246, 0.00354917, -0.191985>,
                         <-16.4823, 6.23307, 15.6739>, <0.0818503, 0.023763, -0.1725> }
        smooth_triangle {<-16.6222, 6.71486, 15.6739>, <0.0705562, 0.0204841, -0.177371>,
                         <-16.762, 7.19665, 15.6739>, <0.0705562, 0.0204841, -0.177371>,
                         <-16.3945, 7.30335, 15.75>, <0.0183369, 0.00532371, -0.191985> }
        smooth_triangle {<-16.3945, 7.30335, 15.75>, <0.0122246, 0.00354917, -0.191985>,
                         <-16.2546, 6.82156, 15.75>, <0.0122246, 0.00354917, -0.191985>,
                         <-16.6222, 6.71486, 15.6739>, <0.0818503, 0.023763, -0.1725> }
        smooth_triangle {<-16.762, 7.19665, 15.6739>, <0.0705562, 0.0204841, -0.177371>,
                         <-16.9019, 7.67844, 15.6739>, <0.0705562, 0.0204841, -0.177371>,
                         <-16.5344, 7.78513, 15.75>, <0.0183369, 0.00532371, -0.191985> }
        smooth_triangle {<-16.5344, 7.78513, 15.75>, <0.0122246, 0.00354917, -0.191985>,
                         <-16.3945, 7.30335, 15.75>, <0.0122246, 0.00354917, -0.191985>,
                         <-16.762, 7.19665, 15.6739>, <0.0818503, 0.023763, -0.1725> }
        smooth_triangle {<-16.9019, 7.67844, 15.6739>, <0.0705562, 0.0204841, -0.177371>,
                         <-17.0418, 8.16023, 15.6739>, <0.0705706, 0.0204346, -0.177371>,
                         <-16.6743, 8.26692, 15.75>, <0.0183513, 0.00527419, -0.191985> }
        smooth_triangle {<-16.6743, 8.26692, 15.75>, <0.0122438, 0.00348313, -0.191985>,
                         <-16.5344, 7.78513, 15.75>, <0.0122246, 0.00354917, -0.191985>,
                         <-16.9019, 7.67844, 15.6739>, <0.0818503, 0.023763, -0.1725> }
        smooth_triangle {<-17.0418, 8.16023, 15.6739>, <0.0705753, 0.0204091, -0.177358>,
                         <-17.1816, 8.64205, 15.6736>, <0.071021, 0.0188068, -0.177313>,
                         <-16.8141, 8.74871, 15.7497>, <0.0188197, 0.00365162, -0.191924> }
        smooth_triangle {<-16.8141, 8.74871, 15.7497>, <0.012862, 0.00135368, -0.19192>,
                         <-16.6743, 8.26692, 15.75>, <0.0122438, 0.00348313, -0.191985>,
                         <-17.0418, 8.16023, 15.6739>, <0.0818695, 0.023697, -0.1725> }
        smooth_triangle {<-17.1816, 8.64205, 15.6736>, <0.0711641, 0.0180037, -0.176878>,
                         <-17.3181, 9.12466, 15.6655>, <0.0757753, -0.00722596, -0.1706>,
                         <-16.954, 9.23039, 15.7409>, <0.0260719, -0.021656, -0.184691> }
        smooth_triangle {<-16.954, 9.23039, 15.7409>, <0.0223409, -0.0313189, -0.182856>,
                         <-16.8141, 8.74871, 15.7497>, <0.012862, 0.00135368, -0.19192>,
                         <-17.1816, 8.64205, 15.6736>, <0.0824638, 0.0215606, -0.17244> }
        smooth_triangle {<-17.3181, 9.12466, 15.6655>, <0.0769415, -0.0178239, -0.161375>,
                         <-17.3981, 9.59116, 15.5369>, <0.0742702, -0.0729779, -0.119817>,
                         <-17.0851, 9.68204, 15.6017>, <0.0411512, -0.0825931, -0.130205> }
        smooth_triangle {<-17.0851, 9.68204, 15.6017>, <0.0408917, -0.0984379, -0.122509>,
                         <-16.954, 9.23039, 15.7409>, <0.0223409, -0.0313189, -0.182856>,
                         <-17.3181, 9.12466, 15.6655>, <0.0886121, -0.0120789, -0.164068> }
        smooth_triangle {<-17.3981, 9.59116, 15.5369>, <0.0709767, -0.0801568, -0.093854>,
                         <-17.3296, 9.91325, 15.1613>, <0.0471003, -0.0783404, -0.0506024>,
                         <-17.166, 9.96074, 15.1952>, <0.0315158, -0.0828649, -0.0557017> }
        smooth_triangle {<-17.166, 9.96074, 15.1952>, <0.0324358, -0.0892283, -0.0577887>,
                         <-17.0851, 9.68204, 15.6017>, <0.0408917, -0.0984379, -0.122509>,
                         <-17.3981, 9.59116, 15.5369>, <0.0850503, -0.0856176, -0.108658> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.75134e-17>,
                         <-17.166, 9.96074, 15.1952>, <0.0324358, -0.0892283, -0.0577887>,
                         <-17.3296, 9.91325, 15.1613>, <0.0532152, -0.0831956, -0.0509897> }
        smooth_triangle {<-15.2788, 3.46035, 14.75>, <9.3527e-05, 0.0263509, -0.0111299>,
                         <-15.6456, 3.59461, 15.0648>, <0.00720127, 0.0578948, -0.0258273>,
                         <-15.5069, 3.63487, 15.1613>, <-0.000500496, 0.0556588, -0.0311859> }
        smooth_triangle {<-15.5069, 3.63487, 15.1613>, <-0.000760882, 0.0478605, -0.0304512>,
                         <-15.2788, 3.46035, 14.75>, <4.83136e-08, -5.57971e-07, 2.6356e-07>,
                         <-15.2788, 3.46035, 14.75>, <-4.05663e-08, -5.83775e-07, 2.0172e-07> }
        smooth_triangle {<-15.6456, 3.59461, 15.0648>, <0.0107587, 0.073682, -0.0375277>,
                         <-16.0026, 3.79315, 15.3523>, <0.054588, 0.0919921, -0.0812471>,
                         <-15.7372, 3.8702, 15.5369>, <0.0273688, 0.0840898, -0.101339> }
        smooth_triangle {<-15.7372, 3.8702, 15.5369>, <0.031655, 0.0647189, -0.108388>,
                         <-15.5069, 3.63487, 15.1613>, <-0.000760882, 0.0478605, -0.0304512>,
                         <-15.6456, 3.59461, 15.0648>, <0.00950813, 0.0508419, -0.0233063> }
        smooth_triangle {<-16.0026, 3.79315, 15.3523>, <0.0715362, 0.0761524, -0.0989965>,
                         <-16.2282, 4.21737, 15.4507>, <0.112725, 0.0600149, -0.126749>,
                         <-15.9195, 4.307, 15.6655>, <0.0727439, 0.0484074, -0.158144> }
        smooth_triangle {<-15.9195, 4.307, 15.6655>, <0.0695575, 0.0382621, -0.160462>,
                         <-15.7372, 3.8702, 15.5369>, <0.031655, 0.0647189, -0.108388>,
                         <-16.0026, 3.79315, 15.3523>, <0.0679472, 0.0752554, -0.0815989> }
        smooth_triangle {<-16.2282, 4.21737, 15.4507>, <0.11801, 0.0486913, -0.12962>,
                         <-16.374, 4.69731, 15.4569>, <0.129492, 0.0393989, -0.135461>,
                         <-16.0626, 4.78774, 15.6736>, <0.0867475, 0.0269893, -0.16964> }
        smooth_triangle {<-16.0626, 4.78774, 15.6736>, <0.0811822, 0.0248027, -0.171961>,
                         <-15.9195, 4.307, 15.6655>, <0.0695575, 0.0382621, -0.160462>,
                         <-16.2282, 4.21737, 15.4507>, <0.122866, 0.0537387, -0.118602> }
        smooth_triangle {<-16.374, 4.69731, 15.4569>, <0.129733, 0.0386166, -0.135482>,
                         <-16.5141, 5.17904, 15.4571>, <0.130346, 0.0378961, -0.135747>,
                         <-16.2025, 5.2695, 15.6739>, <0.0874759, 0.02545, -0.170053> }
        smooth_triangle {<-16.2025, 5.2695, 15.6739>, <0.0818313, 0.0237933, -0.172485>,
                         <-16.0626, 4.78774, 15.6736>, <0.0811822, 0.0248027, -0.171961>,
                         <-16.374, 4.69731, 15.4569>, <0.138175, 0.0413489, -0.12639> }
        smooth_triangle {<-16.5141, 5.17904, 15.4571>, <0.130353, 0.0378713, -0.135747>,
                         <-16.654, 5.66083, 15.4571>, <0.130371, 0.0378496, -0.135754>,
                         <-16.3424, 5.75128, 15.6739>, <0.0874973, 0.0254025, -0.170064> }
        smooth_triangle {<-16.3424, 5.75128, 15.6739>, <0.0818503, 0.023763, -0.1725>,
                         <-16.2025, 5.2695, 15.6739>, <0.0818313, 0.0237933, -0.172485>,
                         <-16.5141, 5.17904, 15.4571>, <0.138991, 0.0403881, -0.126743> }
        smooth_triangle {<-16.654, 5.66083, 15.4571>, <0.130371, 0.0378496, -0.135754>,
                         <-16.7938, 6.14262, 15.4571>, <0.130371, 0.0378496, -0.135754>,
                         <-16.4823, 6.23307, 15.6739>, <0.0874973, 0.0254025, -0.170064> }
        smooth_triangle {<-16.4823, 6.23307, 15.6739>, <0.0818503, 0.023763, -0.1725>,
                         <-16.3424, 5.75128, 15.6739>, <0.0818503, 0.023763, -0.1725>,
                         <-16.654, 5.66083, 15.4571>, <0.139015, 0.0403592, -0.126753> }
        smooth_triangle {<-16.7938, 6.14262, 15.4571>, <0.130371, 0.0378496, -0.135754>,
                         <-16.9337, 6.62441, 15.4571>, <0.130371, 0.0378496, -0.135754>,
                         <-16.6222, 6.71486, 15.6739>, <0.0874973, 0.0254025, -0.170064> }
        smooth_triangle {<-16.6222, 6.71486, 15.6739>, <0.0818503, 0.023763, -0.1725>,
                         <-16.4823, 6.23307, 15.6739>, <0.0818503, 0.023763, -0.1725>,
                         <-16.7938, 6.14262, 15.4571>, <0.139015, 0.0403592, -0.126753> }
        smooth_triangle {<-16.9337, 6.62441, 15.4571>, <0.130371, 0.0378496, -0.135754>,
                         <-17.0736, 7.1062, 15.4571>, <0.130371, 0.0378496, -0.135754>,
                         <-16.762, 7.19665, 15.6739>, <0.0874974, 0.0254025, -0.170064> }
        smooth_triangle {<-16.762, 7.19665, 15.6739>, <0.0818503, 0.023763, -0.1725>,
                         <-16.6222, 6.71486, 15.6739>, <0.0818503, 0.023763, -0.1725>,
                         <-16.9337, 6.62441, 15.4571>, <0.139015, 0.0403592, -0.126753> }
        smooth_triangle {<-17.0736, 7.1062, 15.4571>, <0.130371, 0.0378496, -0.135754>,
                         <-17.2135, 7.58799, 15.4571>, <0.130371, 0.0378497, -0.135754>,
                         <-16.9019, 7.67844, 15.6739>, <0.0874974, 0.0254025, -0.170064> }
        smooth_triangle {<-16.9019, 7.67844, 15.6739>, <0.0818503, 0.023763, -0.1725>,
                         <-16.762, 7.19665, 15.6739>, <0.0818503, 0.023763, -0.1725>,
                         <-17.0736, 7.1062, 15.4571>, <0.139015, 0.0403592, -0.126753> }
        smooth_triangle {<-17.2135, 7.58799, 15.4571>, <0.130371, 0.0378497, -0.135754>,
                         <-17.3533, 8.06978, 15.4571>, <0.130385, 0.0378001, -0.135754>,
                         <-17.0418, 8.16023, 15.6739>, <0.0875118, 0.025353, -0.170064> }
        smooth_triangle {<-17.0418, 8.16023, 15.6739>, <0.0818695, 0.023697, -0.1725>,
                         <-16.9019, 7.67844, 15.6739>, <0.0818503, 0.023763, -0.1725>,
                         <-17.2135, 7.58799, 15.4571>, <0.139015, 0.0403592, -0.126753> }
        smooth_triangle {<-17.3533, 8.06978, 15.4571>, <0.130385, 0.0377733, -0.135743>,
                         <-17.493, 8.55162, 15.4569>, <0.130816, 0.0361666, -0.135709>,
                         <-17.1816, 8.64205, 15.6736>, <0.0879576, 0.0237239, -0.170008> }
        smooth_triangle {<-17.1816, 8.64205, 15.6736>, <0.0824638, 0.0215606, -0.17244>,
                         <-17.0418, 8.16023, 15.6739>, <0.0818695, 0.023697, -0.1725>,
                         <-17.3533, 8.06978, 15.4571>, <0.139034, 0.0402932, -0.126753> }
        smooth_triangle {<-17.493, 8.55162, 15.4569>, <0.130805, 0.0353189, -0.13534>,
                         <-17.6269, 9.03503, 15.4507>, <0.1333, 0.00947465, -0.130536>,
                         <-17.3181, 9.12466, 15.6655>, <0.0925583, -0.00235348, -0.163361> }
        smooth_triangle {<-17.3181, 9.12466, 15.6655>, <0.0886121, -0.0120789, -0.164068>,
                         <-17.1816, 8.64205, 15.6736>, <0.0824638, 0.0215606, -0.17244>,
                         <-17.493, 8.55162, 15.4569>, <0.139608, 0.0381509, -0.126707> }
        smooth_triangle {<-17.6269, 9.03503, 15.4507>, <0.13121, -0.00206856, -0.122716>,
                         <-17.6635, 9.51412, 15.3523>, <0.114578, -0.0612758, -0.0911884>,
                         <-17.3981, 9.59116, 15.5369>, <0.0877972, -0.0690507, -0.113983> }
        smooth_triangle {<-17.3981, 9.59116, 15.5369>, <0.0850503, -0.0856176, -0.108658>,
                         <-17.3181, 9.12466, 15.6655>, <0.0886121, -0.0120789, -0.164068>,
                         <-17.6269, 9.03503, 15.4507>, <0.142934, 0.00369194, -0.120303> }
        smooth_triangle {<-17.6635, 9.51412, 15.3523>, <0.10212, -0.0711153, -0.0691776>,
                         <-17.4683, 9.87298, 15.0648>, <0.0639872, -0.0734377, -0.0377994>,
                         <-17.3296, 9.91325, 15.1613>, <0.051463, -0.0770738, -0.0487207> }
        smooth_triangle {<-17.3296, 9.91325, 15.1613>, <0.0532152, -0.0831956, -0.0509897>,
                         <-17.3981, 9.59116, 15.5369>, <0.0850503, -0.0856176, -0.108658>,
                         <-17.6635, 9.51412, 15.3523>, <0.120757, -0.0752511, -0.0782656> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.79471e-17>,
                         <-17.3296, 9.91325, 15.1613>, <0.0532152, -0.0831956, -0.0509897>,
                         <-17.4683, 9.87298, 15.0648>, <0.0699141, -0.0783476, -0.0364279> }
        smooth_triangle {<-15.2788, 3.46035, 14.75>, <0.00364021, 0.0273806, -0.00743676>,
                         <-15.7383, 3.5677, 14.9204>, <0.0150075, 0.0601611, -0.0150376>,
                         <-15.6456, 3.59461, 15.0648>, <0.00986131, 0.0586671, -0.0230574> }
        smooth_triangle {<-15.6456, 3.59461, 15.0648>, <0.00950813, 0.0508419, -0.0233063>,
                         <-15.2788, 3.46035, 14.75>, <-4.05663e-08, -5.83775e-07, 2.0172e-07>,
                         <-15.2788, 3.46035, 14.75>, <-9.9954e-08, -6.01016e-07, 1.0917e-07> }
        smooth_triangle {<-15.7383, 3.5677, 14.9204>, <0.0222934, 0.0770307, -0.0228556>,
                         <-16.1799, 3.74168, 15.0759>, <0.0787398, 0.0990039, -0.0451858>,
                         <-16.0026, 3.79315, 15.3523>, <0.0609766, 0.0938468, -0.0745947> }
        smooth_triangle {<-16.0026, 3.79315, 15.3523>, <0.0679472, 0.0752554, -0.0815989>,
                         <-15.6456, 3.59461, 15.0648>, <0.00950813, 0.0508419, -0.0233063>,
                         <-15.7383, 3.5677, 14.9204>, <0.0163697, 0.0528339, -0.0126133> }
        smooth_triangle {<-16.1799, 3.74168, 15.0759>, <0.101344, 0.0848062, -0.0570456>,
                         <-16.4345, 4.15749, 15.1292>, <0.15017, 0.0708859, -0.0692702>,
                         <-16.2282, 4.21737, 15.4507>, <0.12477, 0.0635117, -0.114207> }
        smooth_triangle {<-16.2282, 4.21737, 15.4507>, <0.122866, 0.0537387, -0.118602>,
                         <-16.0026, 3.79315, 15.3523>, <0.0679472, 0.0752554, -0.0815989>,
                         <-16.1799, 3.74168, 15.0759>, <0.0916316, 0.0821314, -0.0423869> }
        smooth_triangle {<-16.4345, 4.15749, 15.1292>, <0.15637, 0.0598279, -0.0711887>,
                         <-16.5822, 4.63689, 15.1326>, <0.169381, 0.0509797, -0.0733566>,
                         <-16.374, 4.69731, 15.4569>, <0.142451, 0.0431614, -0.121966> }
        smooth_triangle {<-16.374, 4.69731, 15.4569>, <0.138175, 0.0413489, -0.12639>,
                         <-16.2282, 4.21737, 15.4507>, <0.122866, 0.0537387, -0.118602>,
                         <-16.4345, 4.15749, 15.1292>, <0.156732, 0.0635709, -0.0586864> }
        smooth_triangle {<-16.5822, 4.63689, 15.1326>, <0.169629, 0.0501993, -0.0733704>,
                         <-16.7223, 5.1186, 15.1327>, <0.170311, 0.0494988, -0.0734669>,
                         <-16.5141, 5.17904, 15.4571>, <0.143312, 0.0416604, -0.122245> }
        smooth_triangle {<-16.5141, 5.17904, 15.4571>, <0.138991, 0.0403881, -0.126743>,
                         <-16.374, 4.69731, 15.4569>, <0.138175, 0.0413489, -0.12639>,
                         <-16.5822, 4.63689, 15.1326>, <0.174081, 0.0517733, -0.061577> }
        smooth_triangle {<-16.7223, 5.1186, 15.1327>, <0.170318, 0.049474, -0.0734669>,
                         <-16.8621, 5.60039, 15.1327>, <0.170338, 0.0494529, -0.0734695>,
                         <-16.654, 5.66083, 15.4571>, <0.143337, 0.041614, -0.122252> }
        smooth_triangle {<-16.654, 5.66083, 15.4571>, <0.139015, 0.0403592, -0.126753>,
                         <-16.5141, 5.17904, 15.4571>, <0.138991, 0.0403881, -0.126743>,
                         <-16.7223, 5.1186, 15.1327>, <0.17499, 0.0508392, -0.0617056> }
        smooth_triangle {<-16.8621, 5.60039, 15.1327>, <0.170338, 0.0494529, -0.0734695>,
                         <-17.002, 6.08218, 15.1327>, <0.170338, 0.0494529, -0.0734695>,
                         <-16.7938, 6.14262, 15.4571>, <0.143337, 0.041614, -0.122252> }
        smooth_triangle {<-16.7938, 6.14262, 15.4571>, <0.139015, 0.0403592, -0.126753>,
                         <-16.654, 5.66083, 15.4571>, <0.139015, 0.0403592, -0.126753>,
                         <-16.8621, 5.60039, 15.1327>, <0.175016, 0.0508111, -0.0617091> }
        smooth_triangle {<-17.002, 6.08218, 15.1327>, <0.170338, 0.0494529, -0.0734695>,
                         <-17.1419, 6.56397, 15.1327>, <0.170338, 0.0494529, -0.0734696>,
                         <-16.9337, 6.62441, 15.4571>, <0.143337, 0.041614, -0.122252> }
        smooth_triangle {<-16.9337, 6.62441, 15.4571>, <0.139015, 0.0403592, -0.126753>,
                         <-16.7938, 6.14262, 15.4571>, <0.139015, 0.0403592, -0.126753>,
                         <-17.002, 6.08218, 15.1327>, <0.175016, 0.0508111, -0.0617091> }
        smooth_triangle {<-17.1419, 6.56397, 15.1327>, <0.170338, 0.0494529, -0.0734696>,
                         <-17.2818, 7.04576, 15.1327>, <0.170338, 0.0494529, -0.0734696>,
                         <-17.0736, 7.1062, 15.4571>, <0.143337, 0.041614, -0.122252> }
        smooth_triangle {<-17.0736, 7.1062, 15.4571>, <0.139015, 0.0403592, -0.126753>,
                         <-16.9337, 6.62441, 15.4571>, <0.139015, 0.0403592, -0.126753>,
                         <-17.1419, 6.56397, 15.1327>, <0.175016, 0.0508111, -0.0617091> }
        smooth_triangle {<-17.2818, 7.04576, 15.1327>, <0.170338, 0.0494529, -0.0734696>,
                         <-17.4216, 7.52755, 15.1327>, <0.170338, 0.0494529, -0.0734696>,
                         <-17.2135, 7.58799, 15.4571>, <0.143337, 0.041614, -0.122253> }
        smooth_triangle {<-17.2135, 7.58799, 15.4571>, <0.139015, 0.0403592, -0.126753>,
                         <-17.0736, 7.1062, 15.4571>, <0.139015, 0.0403592, -0.126753>,
                         <-17.2818, 7.04576, 15.1327>, <0.175016, 0.0508111, -0.0617091> }
        smooth_triangle {<-17.4216, 7.52755, 15.1327>, <0.170338, 0.0494529, -0.0734696>,
                         <-17.5615, 8.00934, 15.1327>, <0.170352, 0.0494034, -0.0734696>,
                         <-17.3533, 8.06978, 15.4571>, <0.143352, 0.0415645, -0.122253> }
        smooth_triangle {<-17.3533, 8.06978, 15.4571>, <0.139034, 0.0402932, -0.126753>,
                         <-17.2135, 7.58799, 15.4571>, <0.139015, 0.0403592, -0.126753>,
                         <-17.4216, 7.52755, 15.1327>, <0.175016, 0.0508111, -0.0617091> }
        smooth_triangle {<-17.5615, 8.00934, 15.1327>, <0.170349, 0.0493756, -0.0734623>,
                         <-17.7011, 8.4912, 15.1326>, <0.170769, 0.0477659, -0.0734436>,
                         <-17.493, 8.55162, 15.4569>, <0.143779, 0.03993, -0.122211> }
        smooth_triangle {<-17.493, 8.55162, 15.4569>, <0.139608, 0.0381509, -0.126707>,
                         <-17.3533, 8.06978, 15.4571>, <0.139034, 0.0402932, -0.126753>,
                         <-17.5615, 8.00934, 15.1327>, <0.175035, 0.0507451, -0.0617091> }
        smooth_triangle {<-17.7011, 8.4912, 15.1326>, <0.170641, 0.0468841, -0.0731971>,
                         <-17.8332, 8.97514, 15.1292>, <0.171722, 0.0206294, -0.0706002>,
                         <-17.6269, 9.03503, 15.4507>, <0.146145, 0.0132039, -0.117161> }
        smooth_triangle {<-17.6269, 9.03503, 15.4507>, <0.142934, 0.00369194, -0.120303>,
                         <-17.493, 8.55162, 15.4569>, <0.139608, 0.0381509, -0.126707>,
                         <-17.7011, 8.4912, 15.1326>, <0.175596, 0.0485988, -0.0616842> }
        smooth_triangle {<-17.8332, 8.97514, 15.1292>, <0.16714, 0.00836272, -0.0653749>,
                         <-17.8408, 9.46265, 15.0759>, <0.141295, -0.0535191, -0.0486768>,
                         <-17.6635, 9.51412, 15.3523>, <0.124931, -0.0582701, -0.0804078> }
        smooth_triangle {<-17.6635, 9.51412, 15.3523>, <0.120757, -0.0752511, -0.0782656>,
                         <-17.6269, 9.03503, 15.4507>, <0.142934, 0.00369194, -0.120303>,
                         <-17.8332, 8.97514, 15.1292>, <0.177036, 0.0135927, -0.0582216> }
        smooth_triangle {<-17.8408, 9.46265, 15.0759>, <0.121823, -0.0653949, -0.0339696>,
                         <-17.561, 9.84607, 14.9204>, <0.0748835, -0.0702743, -0.0192417>,
                         <-17.4683, 9.87298, 15.0648>, <0.0673263, -0.0724683, -0.0343224> }
        smooth_triangle {<-17.4683, 9.87298, 15.0648>, <0.0699141, -0.0783476, -0.0364279>,
                         <-17.6635, 9.51412, 15.3523>, <0.120757, -0.0752511, -0.0782656>,
                         <-17.8408, 9.46265, 15.0759>, <0.142577, -0.0689164, -0.0359575> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.83808e-17>,
                         <-17.4683, 9.87298, 15.0648>, <0.0699141, -0.0783476, -0.0364279>,
                         <-17.561, 9.84607, 14.9204>, <0.0799903, -0.0754222, -0.0163203> }
        smooth_triangle {<-15.2788, 3.46035, 14.75>, <0.00833957, 0.041907, -0.00391717>,
                         <-15.7708, 3.55825, 14.75>, <0.0205091, 0.0826433, -0.0032781>,
                         <-15.7383, 3.5677, 14.9204>, <0.0164471, 0.0605791, -0.0114186> }
        smooth_triangle {<-15.7383, 3.5677, 14.9204>, <0.0163697, 0.0528339, -0.0126133>,
                         <-15.2788, 3.46035, 14.75>, <-9.9954e-08, -6.01016e-07, 1.0917e-07>,
                         <-15.2788, 3.46035, 14.75>, <-1.20808e-07, -6.07071e-07, 5.67447e-08> }
        smooth_triangle {<-15.7708, 3.55825, 14.75>, <0.0329141, 0.105917, -0.00693851>,
                         <-16.2421, 3.7236, 14.75>, <0.0942317, 0.119968, -0.0246539>,
                         <-16.1799, 3.74168, 15.0759>, <0.0821973, 0.100008, -0.0364941> }
        smooth_triangle {<-16.1799, 3.74168, 15.0759>, <0.0916316, 0.0821314, -0.0423869>,
                         <-15.7383, 3.5677, 14.9204>, <0.0163697, 0.0528339, -0.0126133>,
                         <-15.7708, 3.55825, 14.75>, <0.022424, 0.0820576, -0.000999942> }
        smooth_triangle {<-16.2421, 3.7236, 14.75>, <0.145562, 0.0933504, -0.0329831>,
                         <-16.5069, 4.13646, 14.75>, <0.169137, 0.0783216, -0.0366529>,
                         <-16.4345, 4.15749, 15.1292>, <0.156688, 0.0727783, -0.0528833> }
        smooth_triangle {<-16.4345, 4.15749, 15.1292>, <0.156732, 0.0635709, -0.0586864>,
                         <-16.1799, 3.74168, 15.0759>, <0.0916316, 0.0821314, -0.0423869>,
                         <-16.2421, 3.7236, 14.75>, <0.134569, 0.0863003, -0.0304921> }
        smooth_triangle {<-16.5069, 4.13646, 14.75>, <0.182527, 0.0564933, -0.0380002>,
                         <-16.6552, 4.61567, 14.75>, <0.183815, 0.0551779, -0.0381733>,
                         <-16.5822, 4.63689, 15.1326>, <0.176395, 0.0530159, -0.0557249> }
        smooth_triangle {<-16.5822, 4.63689, 15.1326>, <0.174081, 0.0517733, -0.061577>,
                         <-16.4345, 4.15749, 15.1292>, <0.156732, 0.0635709, -0.0586864>,
                         <-16.5069, 4.13646, 14.75>, <0.181717, 0.0562427, -0.0378317> }
        smooth_triangle {<-16.6552, 4.61567, 14.75>, <0.184318, 0.0536192, -0.038183>,
                         <-16.7954, 5.09738, 14.75>, <0.184358, 0.0535769, -0.0381882>,
                         <-16.7223, 5.1186, 15.1327>, <0.177328, 0.051536, -0.0558263> }
        smooth_triangle {<-16.7223, 5.1186, 15.1327>, <0.17499, 0.0508392, -0.0617056>,
                         <-16.5822, 4.63689, 15.1326>, <0.174081, 0.0517733, -0.061577>,
                         <-16.6552, 4.61567, 14.75>, <0.184294, 0.053612, -0.0381779> }
        smooth_triangle {<-16.7954, 5.09738, 14.75>, <0.184372, 0.0535274, -0.0381882>,
                         <-16.9352, 5.57917, 14.75>, <0.184372, 0.0535274, -0.0381882>,
                         <-16.8621, 5.60039, 15.1327>, <0.177355, 0.0514901, -0.0558289> }
        smooth_triangle {<-16.8621, 5.60039, 15.1327>, <0.175016, 0.0508111, -0.0617091>,
                         <-16.7223, 5.1186, 15.1327>, <0.17499, 0.0508392, -0.0617056>,
                         <-16.7954, 5.09738, 14.75>, <0.184372, 0.0535274, -0.0381882> }
        smooth_triangle {<-16.9352, 5.57917, 14.75>, <0.184372, 0.0535274, -0.0381882>,
                         <-17.0751, 6.06096, 14.75>, <0.184372, 0.0535274, -0.0381882>,
                         <-17.002, 6.08218, 15.1327>, <0.177355, 0.0514902, -0.0558289> }
        smooth_triangle {<-17.002, 6.08218, 15.1327>, <0.175016, 0.0508111, -0.0617091>,
                         <-16.8621, 5.60039, 15.1327>, <0.175016, 0.0508111, -0.0617091>,
                         <-16.9352, 5.57917, 14.75>, <0.184372, 0.0535274, -0.0381882> }
        smooth_triangle {<-17.0751, 6.06096, 14.75>, <0.184372, 0.0535274, -0.0381882>,
                         <-17.215, 6.54275, 14.75>, <0.184372, 0.0535274, -0.0381882>,
                         <-17.1419, 6.56397, 15.1327>, <0.177355, 0.0514902, -0.0558289> }
        smooth_triangle {<-17.1419, 6.56397, 15.1327>, <0.175016, 0.0508111, -0.0617091>,
                         <-17.002, 6.08218, 15.1327>, <0.175016, 0.0508111, -0.0617091>,
                         <-17.0751, 6.06096, 14.75>, <0.184372, 0.0535274, -0.0381882> }
        smooth_triangle {<-17.215, 6.54275, 14.75>, <0.184372, 0.0535274, -0.0381882>,
                         <-17.3549, 7.02454, 14.75>, <0.184372, 0.0535274, -0.0381882>,
                         <-17.2818, 7.04576, 15.1327>, <0.177355, 0.0514902, -0.0558289> }
        smooth_triangle {<-17.2818, 7.04576, 15.1327>, <0.175016, 0.0508111, -0.0617091>,
                         <-17.1419, 6.56397, 15.1327>, <0.175016, 0.0508111, -0.0617091>,
                         <-17.215, 6.54275, 14.75>, <0.184372, 0.0535274, -0.0381882> }
        smooth_triangle {<-17.3549, 7.02454, 14.75>, <0.184372, 0.0535275, -0.0381882>,
                         <-17.4947, 7.50633, 14.75>, <0.184372, 0.0535275, -0.0381883>,
                         <-17.4216, 7.52755, 15.1327>, <0.177355, 0.0514902, -0.0558289> }
        smooth_triangle {<-17.4216, 7.52755, 15.1327>, <0.175016, 0.0508111, -0.0617091>,
                         <-17.2818, 7.04576, 15.1327>, <0.175016, 0.0508111, -0.0617091>,
                         <-17.3549, 7.02454, 14.75>, <0.184372, 0.0535274, -0.0381882> }
        smooth_triangle {<-17.4947, 7.50633, 14.75>, <0.184372, 0.0535275, -0.0381883>,
                         <-17.6346, 7.98811, 14.75>, <0.184387, 0.0534779, -0.0381883>,
                         <-17.5615, 8.00934, 15.1327>, <0.177369, 0.0514407, -0.0558289> }
        smooth_triangle {<-17.5615, 8.00934, 15.1327>, <0.175035, 0.0507451, -0.0617091>,
                         <-17.4216, 7.52755, 15.1327>, <0.175016, 0.0508111, -0.0617091>,
                         <-17.4947, 7.50633, 14.75>, <0.184372, 0.0535275, -0.0381883> }
        smooth_triangle {<-17.6346, 7.98811, 14.75>, <0.184376, 0.0534212, -0.0381831>,
                         <-17.7742, 8.46998, 14.75>, <0.184786, 0.0518353, -0.0381734>,
                         <-17.7011, 8.4912, 15.1326>, <0.177785, 0.0498026, -0.0558077> }
        smooth_triangle {<-17.7011, 8.4912, 15.1326>, <0.175596, 0.0485988, -0.0616842>,
                         <-17.5615, 8.00934, 15.1327>, <0.175035, 0.0507451, -0.0617091>,
                         <-17.6346, 7.98811, 14.75>, <0.184401, 0.0534284, -0.0381882> }
        smooth_triangle {<-17.7742, 8.46998, 14.75>, <0.184402, 0.0500346, -0.0380003>,
                         <-17.9056, 8.95411, 14.75>, <0.184783, 0.0244292, -0.036653>,
                         <-17.8332, 8.97514, 15.1292>, <0.178674, 0.0226477, -0.0531242> }
        smooth_triangle {<-17.8332, 8.97514, 15.1292>, <0.177036, 0.0135927, -0.0582216>,
                         <-17.7011, 8.4912, 15.1326>, <0.175596, 0.0485988, -0.0616842>,
                         <-17.7742, 8.46998, 14.75>, <0.18522, 0.0502565, -0.0381688> }
        smooth_triangle {<-17.9056, 8.95411, 14.75>, <0.172922, -0.000887307, -0.0329832>,
                         <-17.9031, 9.44457, 14.75>, <0.143826, -0.0508551, -0.024654>,
                         <-17.8408, 9.46265, 15.0759>, <0.146898, -0.0518924, -0.0345912> }
        smooth_triangle {<-17.8408, 9.46265, 15.0759>, <0.142577, -0.0689164, -0.0359575>,
                         <-17.8332, 8.97514, 15.1292>, <0.177036, 0.0135927, -0.0582216>,
                         <-17.9056, 8.95411, 14.75>, <0.185982, -0.000954319, -0.0354742> }
        smooth_triangle {<-17.9031, 9.44457, 14.75>, <0.0972904, -0.0768109, -0.014325>,
                         <-17.5935, 9.83662, 14.75>, <0.0628807, -0.0572922, 9.54098e-18>,
                         <-17.561, 9.84607, 14.9204>, <0.0766906, -0.0697496, -0.0146988> }
        smooth_triangle {<-17.561, 9.84607, 14.9204>, <0.0799903, -0.0754222, -0.0163203>,
                         <-17.8408, 9.46265, 15.0759>, <0.142577, -0.0689164, -0.0359575>,
                         <-17.9031, 9.44457, 14.75>, <0.127789, -0.10089, -0.0188157> }
        smooth_triangle {<-17.2305, 10.1828, 14.75>, <0.0211453, -0.0728339, -3.85976e-17>,
                         <-17.561, 9.84607, 14.9204>, <0.0799903, -0.0754222, -0.0163203>,
                         <-17.5935, 9.83662, 14.75>, <0.0615771, -0.0588123, 0.00327812> }
        texture { Glass }
    }
    union { // Surface of Revolution
        smooth_triangle {<-9.6218, 5.1027, 14.7047>, <0.00306641, 0.00688956, 0.000967846>,
                         <-9.70828, 5.14534, 14.6752>, <0.00371346, 0.00723093, 0.00175561>,
                         <-9.72257, 5.14119, 14.75>, <0.00395058, 0.00729977, -0.000514264> }
        smooth_triangle {<-9.72257, 5.14119, 14.75>, <0.00342741, 0.0065184, -0.000239097>,
                         <-9.63046, 5.10019, 14.75>, <0.00246215, 0.00553193, -0.00019072>,
                         <-9.6218, 5.1027, 14.7047>, <0.00246215, 0.00553193, 0.000777126> }
        smooth_triangle {<-9.70828, 5.14534, 14.6752>, <0.00371346, 0.00723093, 0.00175561>,
                         <-9.78587, 5.20454, 14.6512>, <0.00645591, 0.00753042, 0.0026794>,
                         <-9.80474, 5.19906, 14.75>, <0.00683391, 0.00764016, -0.000700631> }
        smooth_triangle {<-9.80474, 5.19906, 14.75>, <0.00620758, 0.00726664, -0.000233542>,
                         <-9.72257, 5.14119, 14.75>, <0.00404509, 0.00701135, -9.37677e-05>,
                         <-9.70828, 5.14534, 14.6752>, <0.00386724, 0.00695972, 0.00160864> }
        smooth_triangle {<-9.78587, 5.20454, 14.6512>, <0.00645591, 0.00753042, 0.0026794>,
                         <-9.84292, 5.28614, 14.6379>, <0.00913917, 0.00572837, 0.00346476>,
                         <-9.86434, 5.27992, 14.75>, <0.00965415, 0.00587787, -0.0007689> }
        smooth_triangle {<-9.86434, 5.27992, 14.75>, <0.00923825, 0.00588067, -0.000113428>,
                         <-9.80474, 5.19906, 14.75>, <0.00712306, 0.00720238, -6.22256e-05>,
                         <-9.78587, 5.20454, 14.6512>, <0.00683957, 0.00712008, 0.00247279> }
        smooth_triangle {<-9.84292, 5.28614, 14.6379>, <0.00913917, 0.00572837, 0.00346476>,
                         <-9.87918, 5.38, 14.6343>, <0.0103619, 0.00344376, 0.00370817>,
                         <-9.90128, 5.37358, 14.75>, <0.0109271, 0.00360784, -0.00074963> }
        smooth_triangle {<-9.90128, 5.37358, 14.75>, <0.0108201, 0.00374114, -3.41089e-06>,
                         <-9.86434, 5.27992, 14.75>, <0.00986539, 0.00544367, -1.78634e-05>,
                         <-9.84292, 5.28614, 14.6379>, <0.00947916, 0.00533154, 0.00315738> }
        smooth_triangle {<-9.87918, 5.38, 14.6343>, <0.0103619, 0.00344376, 0.00370817>,
                         <-9.9, 5.47853, 14.6374>, <0.010341, 0.00154725, 0.00356046>,
                         <-9.9215, 5.47229, 14.75>, <0.010892, 0.00170721, -0.000676063> }
        smooth_triangle {<-9.9215, 5.47229, 14.75>, <0.0110234, 0.00186524, 7.06523e-05>,
                         <-9.90128, 5.37358, 14.75>, <0.0110497, 0.00329071, 1.54773e-05>,
                         <-9.87918, 5.38, 14.6343>, <0.0106259, 0.00316766, 0.00335883> }
        smooth_triangle {<-9.9, 5.47853, 14.6374>, <0.010341, 0.00154725, 0.00356046>,
                         <-9.90714, 5.5787, 14.6462>, <0.00954074, 9.39415e-05, 0.00317985>,
                         <-9.92697, 5.57294, 14.75>, <0.0100377, 0.000238208, -0.000578525> }
        smooth_triangle {<-9.92697, 5.57294, 14.75>, <0.010361, 0.000332675, 0.000115767>,
                         <-9.9215, 5.47229, 14.75>, <0.0110017, 0.00143443, 4.26131e-05>,
                         <-9.9, 5.47853, 14.6374>, <0.0105885, 0.00131446, 0.00322001> }
        smooth_triangle {<-9.90714, 5.5787, 14.6462>, <0.00954074, 9.39415e-05, 0.00317985>,
                         <-9.9049, 5.67875, 14.6586>, <0.00829249, -0.000658129, 0.00270462>,
                         <-9.92236, 5.67368, 14.75>, <0.00871772, -0.000534677, -0.000478598> }
        smooth_triangle {<-9.92236, 5.67368, 14.75>, <0.00915376, -0.000520874, 0.000134023>,
                         <-9.92697, 5.57294, 14.75>, <0.0101437, 5.87897e-05, 5.90775e-05>,
                         <-9.90714, 5.5787, 14.6462>, <0.00977102, -4.941e-05, 0.00287786> }
        smooth_triangle {<-9.9049, 5.67875, 14.6586>, <0.00829249, -0.000658129, 0.00270462>,
                         <-9.89777, 5.77834, 14.6729>, <0.00688801, -0.000839378, 0.00222643>,
                         <-9.9125, 5.77407, 14.75>, <0.00723979, -0.000737249, -0.000384897> }
        smooth_triangle {<-9.9125, 5.77407, 14.75>, <0.00772385, -0.000778284, 0.000137042>,
                         <-9.92236, 5.67368, 14.75>, <0.0088323, -0.000626354, 6.67665e-05>,
                         <-9.9049, 5.67875, 14.6586>, <0.00851338, -0.000718944, 0.00245418> }
        smooth_triangle {<-9.89777, 5.77834, 14.6729>, <0.00688801, -0.000839378, 0.00222643>,
                         <-9.88949, 5.87779, 14.6877>, <0.00549377, -0.000691834, 0.00178087>,
                         <-9.90139, 5.87433, 14.75>, <0.00577667, -0.0006097, -0.000299881> }
        smooth_triangle {<-9.90139, 5.87433, 14.75>, <0.00626434, -0.000671231, 0.000132252>,
                         <-9.9125, 5.77407, 14.75>, <0.00736168, -0.000766893, 6.84901e-05>,
                         <-9.89777, 5.77834, 14.6729>, <0.00709784, -0.00084349, 0.00202698> }
        smooth_triangle {<-9.88949, 5.87779, 14.6877>, <0.00549377, -0.000691834, 0.00178087>,
                         <-9.88294, 5.97745, 14.7018>, <0.00418424, -0.00043463, 0.00137495>,
                         <-9.89214, 5.97478, 14.75>, <0.00440466, -0.000370638, -0.000221083> }
        smooth_triangle {<-9.89214, 5.97478, 14.75>, <0.00486777, -0.000422052, 0.000125012>,
                         <-9.90139, 5.87433, 14.75>, <0.00589677, -0.000601349, 6.59137e-05>,
                         <-9.88949, 5.87779, 14.6877>, <0.00568459, -0.000662949, 0.00162648> }
        smooth_triangle {<-9.88294, 5.97745, 14.7018>, <0.00418424, -0.00043463, 0.00137495>,
                         <-9.87915, 6.07741, 14.7149>, <0.002983, -0.000213714, 0.00100014>,
                         <-9.88586, 6.07546, 14.75>, <0.0031455, -0.000166537, -0.000149467> }
        smooth_triangle {<-9.88586, 6.07546, 14.75>, <0.0035716, -0.000200527, 0.000115318>,
                         <-9.89214, 5.97478, 14.75>, <0.00451597, -0.000353603, 6.16061e-05>,
                         <-9.88294, 5.97745, 14.7018>, <0.00435065, -0.000401597, 0.00125863> }
        smooth_triangle {<-9.87915, 6.07741, 14.7149>, <0.002983, -0.000213714, 0.00100014>,
                         <-9.87889, 6.1776, 14.7266>, <0.00192325, -5.97378e-05, 0.00066301>,
                         <-9.88337, 6.1763, 14.75>, <0.00203311, -2.78427e-05, -8.78968e-05> }
        smooth_triangle {<-9.88337, 6.1763, 14.75>, <0.00241026, -4.27915e-05, 0.000102001>,
                         <-9.88586, 6.07546, 14.75>, <0.00324455, -0.000146812, 5.58229e-05>,
                         <-9.87915, 6.07741, 14.7149>, <0.00312268, -0.000182195, 0.000918028> }
        smooth_triangle {<-9.87889, 6.1776, 14.7266>, <0.00192325, -5.97378e-05, 0.00066301>,
                         <-9.88323, 6.27788, 14.7364>, <0.00104539, 1.94298e-05, 0.000376566>,
                         <-9.88583, 6.27713, 14.75>, <0.00110999, 3.81862e-05, -3.83606e-05> }
        smooth_triangle {<-9.88583, 6.27713, 14.75>, <0.00142354, 4.30764e-05, 8.49338e-05>,
                         <-9.88337, 6.1763, 14.75>, <0.00211588, -6.4453e-06, 4.77817e-05>,
                         <-9.87889, 6.1776, 14.7266>, <0.00203348, -3.03666e-05, 0.000610962> }
        smooth_triangle {<-9.88323, 6.27788, 14.7364>, <0.00104539, 1.94298e-05, 0.000376566>,
                         <-9.89284, 6.37799, 14.7441>, <0.000362277, 2.32948e-05, 0.000147217>,
                         <-9.89396, 6.37766, 14.75>, <0.000390473, 3.14806e-05, 3.85327e-07> }
        smooth_triangle {<-9.89396, 6.37766, 14.75>, <0.000634523, 5.12391e-05, 6.70884e-05>,
                         <-9.88583, 6.27713, 14.75>, <0.00117416, 5.62683e-05, 3.80289e-05>,
                         <-9.88323, 6.27788, 14.7364>, <0.00112571, 4.2201e-05, 0.000349224> }
        smooth_triangle {<-9.89284, 6.37799, 14.7441>, <0.000362277, 2.32948e-05, 0.000147217>,
                         <-9.90692, 6.4777, 14.7501>, <-0.000170936, -2.62708e-05, -3.48806e-05>,
                         <-9.90691, 6.4777, 14.75>, <-0.000171219, -2.6353e-05, 3.3398e-05> }
        smooth_triangle {<-9.90691, 6.4777, 14.75>, <1.80123e-05, -8.04995e-07, 5.40711e-05>,
                         <-9.89396, 6.37766, 14.75>, <0.000439281, 4.25702e-05, 2.93116e-05>,
                         <-9.89284, 6.37799, 14.7441>, <0.000418134, 3.64309e-05, 0.000139435> }
        smooth_triangle {<-9.90692, 6.4777, 14.7501>, <-0.000170936, -2.62708e-05, -3.48806e-05>,
                         <-9.92327, 6.57712, 14.755>, <-0.000465171, -6.68584e-05, -0.000192761>,
                         <-9.92231, 6.5774, 14.75>, <-0.000501993, -7.75487e-05, 0> }
        smooth_triangle {<-9.92231, 6.5774, 14.75>, <-0.000336599, -5.19984e-05, -3.86693e-07>,
                         <-9.90691, 6.4777, 14.75>, <-0.000129867, -1.99892e-05, 2.47584e-05>,
                         <-9.90692, 6.4777, 14.7501>, <-0.000129655, -1.99276e-05, -2.64505e-05> }
        smooth_triangle {<-9.59715, 5.10986, 14.6663>, <0.00235503, 0.00668303, 0.00275619>,
                         <-9.66759, 5.15715, 14.6118>, <0.00266018, 0.00692514, 0.00375821>,
                         <-9.70828, 5.14534, 14.6752>, <0.00371346, 0.00723093, 0.00175561> }
        smooth_triangle {<-9.70828, 5.14534, 14.6752>, <0.00314181, 0.00643549, 0.00173419>,
                         <-9.6218, 5.1027, 14.7047>, <0.00224664, 0.00546936, 0.00131889>,
                         <-9.59715, 5.10986, 14.6663>, <0.00189095, 0.0053661, 0.00221307> }
        smooth_triangle {<-9.66759, 5.15715, 14.6118>, <0.00266018, 0.00692514, 0.00375821>,
                         <-9.73211, 5.22015, 14.5674>, <0.00486451, 0.0070684, 0.00565151>,
                         <-9.78587, 5.20454, 14.6512>, <0.00645591, 0.00753042, 0.0026794> }
        smooth_triangle {<-9.78587, 5.20454, 14.6512>, <0.00570951, 0.00712204, 0.00284089>,
                         <-9.70828, 5.14534, 14.6752>, <0.00365267, 0.00689742, 0.00214806>,
                         <-9.66759, 5.15715, 14.6118>, <0.00286271, 0.00666808, 0.00365001> }
        smooth_triangle {<-9.73211, 5.22015, 14.5674>, <0.00486451, 0.0070684, 0.00565151>,
                         <-9.78195, 5.30384, 14.5429>, <0.00710749, 0.00513852, 0.00717094>,
                         <-9.84292, 5.28614, 14.6379>, <0.00913917, 0.00572837, 0.00346476> }
        smooth_triangle {<-9.84292, 5.28614, 14.6379>, <0.00851152, 0.00566968, 0.00391778>,
                         <-9.78587, 5.20454, 14.6512>, <0.00649907, 0.00702122, 0.00332876>,
                         <-9.73211, 5.22015, 14.5674>, <0.00530552, 0.00667471, 0.00555785> }
        smooth_triangle {<-9.78195, 5.30384, 14.5429>, <0.00710749, 0.00513852, 0.00717094>,
                         <-9.81625, 5.39827, 14.5363>, <0.00820152, 0.00281654, 0.00760144>,
                         <-9.87918, 5.38, 14.6343>, <0.0103619, 0.00344376, 0.00370817> }
        smooth_triangle {<-9.87918, 5.38, 14.6343>, <0.00998549, 0.00349884, 0.00437249>,
                         <-9.84292, 5.28614, 14.6379>, <0.00906842, 0.00521229, 0.00418993>,
                         <-9.78195, 5.30384, 14.5429>, <0.00754466, 0.00476991, 0.00696956> }
        smooth_triangle {<-9.81625, 5.39827, 14.5363>, <0.00820152, 0.00281654, 0.00760144>,
                         <-9.83876, 5.49631, 14.542>, <0.00827501, 0.00094744, 0.00725493>,
                         <-9.9, 5.47853, 14.6374>, <0.010341, 0.00154725, 0.00356046> }
        smooth_triangle {<-9.9, 5.47853, 14.6374>, <0.0101856, 0.00162199, 0.00431549>,
                         <-9.87918, 5.38, 14.6343>, <0.0102013, 0.00304438, 0.00442628>,
                         <-9.81625, 5.39827, 14.5363>, <0.00858094, 0.00257397, 0.00734623> }
        smooth_triangle {<-9.83876, 5.49631, 14.542>, <0.00827501, 0.00094744, 0.00725493>,
                         <-9.85064, 5.5951, 14.5581>, <0.00770041, -0.000440347, 0.00645413>,
                         <-9.90714, 5.5787, 14.6462>, <0.00954074, 9.39415e-05, 0.00317985> }
        smooth_triangle {<-9.90714, 5.5787, 14.6462>, <0.00958426, 0.000107182, 0.00395019>,
                         <-9.9, 5.47853, 14.6374>, <0.0101845, 0.00119716, 0.00423565>,
                         <-9.83876, 5.49631, 14.542>, <0.00863496, 0.000747306, 0.0070065> }
        smooth_triangle {<-9.85064, 5.5951, 14.5581>, <0.00770041, -0.000440347, 0.00645413>,
                         <-9.85517, 5.69318, 14.5811>, <0.00672977, -0.00111182, 0.00547609>,
                         <-9.9049, 5.67875, 14.6586>, <0.00829249, -0.000658129, 0.00270462> }
        smooth_triangle {<-9.9049, 5.67875, 14.6586>, <0.00847249, -0.000718659, 0.00343233>,
                         <-9.90714, 5.5787, 14.6462>, <0.00940868, -0.000154606, 0.00378875>,
                         <-9.85064, 5.5951, 14.5581>, <0.00802843, -0.000555322, 0.00624446> }
        smooth_triangle {<-9.85517, 5.69318, 14.5811>, <0.00672977, -0.00111182, 0.00547609>,
                         <-9.85585, 5.79051, 14.6076>, <0.00560333, -0.00121235, 0.0044988>,
                         <-9.89777, 5.77834, 14.6729>, <0.00688801, -0.000839378, 0.00222643> }
        smooth_triangle {<-9.89777, 5.77834, 14.6729>, <0.00714711, -0.000945724, 0.00288215>,
                         <-9.9049, 5.67875, 14.6586>, <0.00820047, -0.000809788, 0.0032408>,
                         <-9.85517, 5.69318, 14.5811>, <0.00702843, -0.00115006, 0.0053194> }
        smooth_triangle {<-9.85585, 5.79051, 14.6076>, <0.00560333, -0.00121235, 0.0044988>,
                         <-9.85561, 5.88762, 14.6349>, <0.0044677, -0.000989723, 0.0035905>,
                         <-9.88949, 5.87779, 14.6877>, <0.00549377, -0.000691834, 0.00178087> }
        smooth_triangle {<-9.88949, 5.87779, 14.6877>, <0.00578964, -0.000809047, 0.00235277>,
                         <-9.89777, 5.77834, 14.6729>, <0.00683532, -0.000919705, 0.00268693>,
                         <-9.85585, 5.79051, 14.6076>, <0.00587181, -0.00119943, 0.00439121> }
        smooth_triangle {<-9.85561, 5.88762, 14.6349>, <0.0044677, -0.000989723, 0.0035905>,
                         <-9.85673, 5.98506, 14.661>, <0.00339405, -0.000664041, 0.00276166>,
                         <-9.88294, 5.97745, 14.7018>, <0.00418424, -0.00043463, 0.00137495> }
        smooth_triangle {<-9.88294, 5.97745, 14.7018>, <0.00448869, -0.000532105, 0.00185941>,
                         <-9.88949, 5.87779, 14.6877>, <0.00547083, -0.000725009, 0.00216385>,
                         <-9.85561, 5.88762, 14.6349>, <0.00470129, -0.000948426, 0.00352107> }
        smooth_triangle {<-9.85673, 5.98506, 14.661>, <0.00339405, -0.000664041, 0.00276166>,
                         <-9.86004, 6.08295, 14.6851>, <0.00241038, -0.000379958, 0.00199749>,
                         <-9.87915, 6.07741, 14.7149>, <0.002983, -0.000213714, 0.00100014> }
        smooth_triangle {<-9.87915, 6.07741, 14.7149>, <0.00328257, -0.000284439, 0.00139774>,
                         <-9.88294, 5.97745, 14.7018>, <0.0041835, -0.000450126, 0.00167885>,
                         <-9.85673, 5.98506, 14.661>, <0.00359085, -0.000622184, 0.00271888> }
        smooth_triangle {<-9.86004, 6.08295, 14.6851>, <0.00241038, -0.000379958, 0.00199749>,
                         <-9.86613, 6.1813, 14.7067>, <0.00154579, -0.000169324, 0.00131298>,
                         <-9.87889, 6.1776, 14.7266>, <0.00192325, -5.97378e-05, 0.00066301> }
        smooth_triangle {<-9.87889, 6.1776, 14.7266>, <0.00220444, -0.000102546, 0.000975463>,
                         <-9.87915, 6.07741, 14.7149>, <0.00299925, -0.000218028, 0.00122831>,
                         <-9.86004, 6.08295, 14.6851>, <0.00256978, -0.000342712, 0.00197632> }
        smooth_triangle {<-9.86613, 6.1813, 14.7067>, <0.00154579, -0.000169324, 0.00131298>,
                         <-9.87584, 6.28003, 14.7249>, <0.000833211, -4.21699e-05, 0.000734164>,
                         <-9.88323, 6.27788, 14.7364>, <0.00104539, 1.94298e-05, 0.000376566> }
        smooth_triangle {<-9.88323, 6.27788, 14.7364>, <0.00129151, 4.74555e-06, 0.000606227>,
                         <-9.87889, 6.1776, 14.7266>, <0.00194991, -5.46301e-05, 0.00082106>,
                         <-9.86613, 6.1813, 14.7067>, <0.00166681, -0.00013682, 0.00130854> }
        smooth_triangle {<-9.87584, 6.28003, 14.7249>, <0.000833211, -4.21699e-05, 0.000734164>,
                         <-9.88965, 6.37891, 14.7392>, <0.000282266, 6.57382e-08, 0.000271636>,
                         <-9.89284, 6.37799, 14.7441>, <0.000362277, 2.32948e-05, 0.000147217> }
        smooth_triangle {<-9.89284, 6.37799, 14.7441>, <0.000564278, 3.08453e-05, 0.000300641>,
                         <-9.88323, 6.27788, 14.7364>, <0.00107661, 2.79465e-05, 0.000472653>,
                         <-9.87584, 6.28003, 14.7249>, <0.000917478, -1.82532e-05, 0.000740852> }
        smooth_triangle {<-9.88965, 6.37891, 14.7392>, <0.000282266, 6.57382e-08, 0.000271636>,
                         <-9.90695, 6.47769, 14.7501>, <-0.000145581, -1.89098e-05, -9.78489e-05>,
                         <-9.90692, 6.4777, 14.7501>, <-0.000170936, -2.62708e-05, -3.48806e-05> }
        smooth_triangle {<-9.90692, 6.4777, 14.7501>, <-3.10743e-06, -6.93651e-06, 5.64889e-05>,
                         <-9.89284, 6.37799, 14.7441>, <0.000396802, 3.02377e-05, 0.000193062>,
                         <-9.88965, 6.37891, 14.7392>, <0.000336794, 1.28159e-05, 0.000286376> }
        smooth_triangle {<-9.90695, 6.47769, 14.7501>, <-0.000145581, -1.89098e-05, -9.78489e-05>,
                         <-9.92601, 6.57632, 14.7593>, <-0.00036031, -3.64151e-05, -0.000356176>,
                         <-9.92327, 6.57712, 14.755>, <-0.000465171, -6.68584e-05, -0.000192761> }
        smooth_triangle {<-9.92327, 6.57712, 14.755>, <-0.000311767, -4.47891e-05, -0.000129608>,
                         <-9.90692, 6.4777, 14.7501>, <-0.000129442, -1.98657e-05, -2.69864e-05>,
                         <-9.90695, 6.47769, 14.7501>, <-0.000110426, -1.43449e-05, -7.42126e-05> }
        smooth_triangle {<-9.56025, 5.12057, 14.6406>, <0.00104056, 0.00630142, 0.00412494>,
                         <-9.6067, 5.17483, 14.5694>, <0.000951106, 0.00642896, 0.00518866>,
                         <-9.66759, 5.15715, 14.6118>, <0.00266018, 0.00692514, 0.00375821> }
        smooth_triangle {<-9.66759, 5.15715, 14.6118>, <0.00215275, 0.00614834, 0.00344347>,
                         <-9.59715, 5.10986, 14.6663>, <0.00149274, 0.00525049, 0.00262772>,
                         <-9.56025, 5.12057, 14.6406>, <0.000835511, 0.00505968, 0.00331209> }
        smooth_triangle {<-9.6067, 5.17483, 14.5694>, <0.000951106, 0.00642896, 0.00518866>,
                         <-9.65166, 5.2435, 14.5114>, <0.00230196, 0.00632443, 0.00776323>,
                         <-9.73211, 5.22015, 14.5674>, <0.00486451, 0.0070684, 0.00565151> }
        smooth_triangle {<-9.73211, 5.22015, 14.5674>, <0.00411947, 0.00666041, 0.00548283>,
                         <-9.66759, 5.15715, 14.6118>, <0.00246623, 0.00655297, 0.00406286>,
                         <-9.6067, 5.17483, 14.5694>, <0.00118442, 0.00618083, 0.00513569> }
        smooth_triangle {<-9.65166, 5.2435, 14.5114>, <0.00230196, 0.00632443, 0.00776323>,
                         <-9.69069, 5.33033, 14.4794>, <0.00386841, 0.00419815, 0.00978541>,
                         <-9.78195, 5.30384, 14.5429>, <0.00710749, 0.00513852, 0.00717094> }
        smooth_triangle {<-9.78195, 5.30384, 14.5429>, <0.00635861, 0.00504465, 0.00735255>,
                         <-9.73211, 5.22015, 14.5674>, <0.00467637, 0.00649205, 0.00621298>,
                         <-9.65166, 5.2435, 14.5114>, <0.00275446, 0.00593408, 0.00779677> }
        smooth_triangle {<-9.69069, 5.33033, 14.4794>, <0.00386841, 0.00419815, 0.00978541>,
                         <-9.72208, 5.42561, 14.4707>, <0.00477474, 0.00182168, 0.0103375>,
                         <-9.81625, 5.39827, 14.5363>, <0.00820152, 0.00281654, 0.00760144> }
        smooth_triangle {<-9.81625, 5.39827, 14.5363>, <0.00760624, 0.00280809, 0.00808272>,
                         <-9.78195, 5.30384, 14.5429>, <0.00678572, 0.00454957, 0.00775984>,
                         <-9.69069, 5.33033, 14.4794>, <0.00435641, 0.00384429, 0.0097207> }
        smooth_triangle {<-9.72208, 5.42561, 14.4707>, <0.00477474, 0.00182168, 0.0103375>,
                         <-9.7471, 5.52292, 14.4782>, <0.00500852, -8.95028e-07, 0.00984491>,
                         <-9.83876, 5.49631, 14.542>, <0.00827501, 0.00094744, 0.00725493> }
        smooth_triangle {<-9.83876, 5.49631, 14.542>, <0.00785147, 0.000944353, 0.00790334>,
                         <-9.81625, 5.39827, 14.5363>, <0.00779635, 0.00234618, 0.00816322>,
                         <-9.72208, 5.42561, 14.4707>, <0.00522627, 0.00160003, 0.0102152> }
        smooth_triangle {<-9.7471, 5.52292, 14.4782>, <0.00500852, -8.95028e-07, 0.00984491>,
                         <-9.76609, 5.61964, 14.4993>, <0.00479684, -0.00128332, 0.00874582>,
                         <-9.85064, 5.5951, 14.5581>, <0.00770041, -0.000440347, 0.00645413> }
        smooth_triangle {<-9.85064, 5.5951, 14.5581>, <0.0074575, -0.000510263, 0.00718323>,
                         <-9.83876, 5.49631, 14.542>, <0.00788845, 0.000530577, 0.00778384>,
                         <-9.7471, 5.52292, 14.4782>, <0.00543858, -0.000180674, 0.00972632> }
        smooth_triangle {<-9.76609, 5.61964, 14.4993>, <0.00479684, -0.00128332, 0.00874582>,
                         <-9.78076, 5.71479, 14.5293>, <0.00426747, -0.00182668, 0.00741387>,
                         <-9.85517, 5.69318, 14.5811>, <0.00672977, -0.00111182, 0.00547609> }
        smooth_triangle {<-9.85517, 5.69318, 14.5811>, <0.00663093, -0.0012533, 0.0062081>,
                         <-9.85064, 5.5951, 14.5581>, <0.00735891, -0.000749699, 0.00694163>,
                         <-9.76609, 5.61964, 14.4993>, <0.00518123, -0.00138193, 0.0086604> }
        smooth_triangle {<-9.78076, 5.71479, 14.5293>, <0.00426747, -0.00182668, 0.00741387>,
                         <-9.7931, 5.80873, 14.5639>, <0.00358132, -0.00179938, 0.00608626>,
                         <-9.85585, 5.79051, 14.6076>, <0.00560333, -0.00121235, 0.0044988> }
        smooth_triangle {<-9.85585, 5.79051, 14.6076>, <0.00560542, -0.00139331, 0.00518848>,
                         <-9.85517, 5.69318, 14.5811>, <0.00645025, -0.00131791, 0.00592145>,
                         <-9.78076, 5.71479, 14.5293>, <0.00460353, -0.00185406, 0.00737479> }
        smooth_triangle {<-9.7931, 5.80873, 14.5639>, <0.00358132, -0.00179938, 0.00608626>,
                         <-9.80489, 5.90235, 14.5996>, <0.00285469, -0.00145802, 0.00485351>,
                         <-9.85561, 5.88762, 14.6349>, <0.0044677, -0.000989723, 0.0035905> }
        smooth_triangle {<-9.85561, 5.88762, 14.6349>, <0.00453502, -0.00117329, 0.00421509>,
                         <-9.85585, 5.79051, 14.6076>, <0.00538674, -0.00134026, 0.00489631>,
                         <-9.7931, 5.80873, 14.5639>, <0.00387023, -0.00178054, 0.00608692> }
        smooth_triangle {<-9.80489, 5.90235, 14.5996>, <0.00285469, -0.00145802, 0.00485351>,
                         <-9.81751, 5.99645, 14.6337>, <0.00215437, -0.00102395, 0.00372793>,
                         <-9.85673, 5.98506, 14.661>, <0.00339405, -0.000664041, 0.00276166> }
        smooth_triangle {<-9.85673, 5.98506, 14.661>, <0.00350107, -0.000818835, 0.00331073>,
                         <-9.85561, 5.88762, 14.6349>, <0.00430631, -0.0010631, 0.00393236>,
                         <-9.80489, 5.90235, 14.5996>, <0.00309655, -0.00141432, 0.00487962> }
        smooth_triangle {<-9.81751, 5.99645, 14.6337>, <0.00215437, -0.00102395, 0.00372793>,
                         <-9.83145, 6.09126, 14.6652>, <0.00151481, -0.000639961, 0.00269073>,
                         <-9.86004, 6.08295, 14.6851>, <0.00241038, -0.000379958, 0.00199749> }
        smooth_triangle {<-9.86004, 6.08295, 14.6851>, <0.00254424, -0.000498793, 0.00246736>,
                         <-9.85673, 5.98506, 14.661>, <0.00328199, -0.000711855, 0.0030405>,
                         <-9.81751, 5.99645, 14.6337>, <0.00235223, -0.000981783, 0.0037652> }
        smooth_triangle {<-9.83145, 6.09126, 14.6652>, <0.00151481, -0.000639961, 0.00269073>,
                         <-9.84704, 6.18684, 14.6934>, <0.00095819, -0.000339917, 0.00176306>,
                         <-9.86613, 6.1813, 14.7067>, <0.00154579, -0.000169324, 0.00131298> }
        smooth_triangle {<-9.86613, 6.1813, 14.7067>, <0.00169328, -0.000250947, 0.00170042>,
                         <-9.86004, 6.08295, 14.6851>, <0.00234172, -0.000408923, 0.0022138>,
                         <-9.83145, 6.09126, 14.6652>, <0.00167005, -0.000603925, 0.00273373> }
        smooth_triangle {<-9.84704, 6.18684, 14.6934>, <0.00095819, -0.000339917, 0.00176306>,
                         <-9.86477, 6.28324, 14.7172>, <0.000505765, -0.000137235, 0.000979992>,
                         <-9.87584, 6.28003, 14.7249>, <0.000833211, -4.21699e-05, 0.000734164> }
        smooth_triangle {<-9.87584, 6.28003, 14.7249>, <0.00097795, -8.62874e-05, 0.00103523>,
                         <-9.86613, 6.1813, 14.7067>, <0.00151238, -0.000181653, 0.00146934>,
                         <-9.84704, 6.18684, 14.6934>, <0.00107168, -0.000309598, 0.0018069> }
        smooth_triangle {<-9.86477, 6.28324, 14.7172>, <0.000505765, -0.000137235, 0.000979992>,
                         <-9.88489, 6.3803, 14.7359>, <0.00016262, -3.46701e-05, 0.000354701>,
                         <-9.88965, 6.37891, 14.7392>, <0.000282266, 6.57382e-08, 0.000271636> }
        smooth_triangle {<-9.88965, 6.37891, 14.7392>, <0.000413546, -1.29153e-05, 0.000488424>,
                         <-9.87584, 6.28003, 14.7249>, <0.000826756, -4.4592e-05, 0.00083532>,
                         <-9.86477, 6.28324, 14.7172>, <0.000581171, -0.000115891, 0.00101969> }
        smooth_triangle {<-9.88489, 6.3803, 14.7359>, <0.00016262, -3.46701e-05, 0.000354701>,
                         <-9.907, 6.47767, 14.7501>, <-9.90153e-05, -5.39065e-06, -0.000145921>,
                         <-9.90695, 6.47769, 14.7501>, <-0.000145581, -1.89098e-05, -9.78489e-05> }
        smooth_triangle {<-9.90695, 6.47769, 14.7501>, <-2.35081e-05, -1.28593e-05, 5.03069e-05>,
                         <-9.88965, 6.37891, 14.7392>, <0.000297377, 1.37238e-06, 0.000327421>,
                         <-9.88489, 6.3803, 14.7359>, <0.000207643, -2.46795e-05, 0.000389719> }
        smooth_triangle {<-9.907, 6.47767, 14.7501>, <-9.90153e-05, -5.39065e-06, -0.000145921>,
                         <-9.93011, 6.57513, 14.7622>, <-0.000203376, 9.14652e-06, -0.000465366>,
                         <-9.92601, 6.57632, 14.7593>, <-0.00036031, -3.64151e-05, -0.000356176> }
        smooth_triangle {<-9.92601, 6.57632, 14.7593>, <-0.000241335, -2.43411e-05, -0.000239099>,
                         <-9.90695, 6.47769, 14.7501>, <-0.000110032, -1.42306e-05, -7.46227e-05>,
                         <-9.907, 6.47767, 14.7501>, <-7.51075e-05, -4.09122e-06, -0.000110676> }
        smooth_triangle {<-9.51673, 5.13321, 14.6316>, <-0.000676873, 0.00580281, 0.00486569>,
                         <-9.53487, 5.19568, 14.5546>, <-0.00115357, 0.00581792, 0.00582918>,
                         <-9.6067, 5.17483, 14.5694>, <0.000951106, 0.00642896, 0.00518866> }
        smooth_triangle {<-9.6067, 5.17483, 14.5694>, <0.000610802, 0.00570068, 0.00462851>,
                         <-9.56025, 5.12057, 14.6406>, <0.000315225, 0.00490863, 0.0035365>,
                         <-9.51673, 5.13321, 14.6316>, <-0.000543491, 0.00465933, 0.00390688> }
        smooth_triangle {<-9.53487, 5.19568, 14.5546>, <-0.00115357, 0.00581792, 0.00582918>,
                         <-9.55675, 5.27106, 14.4918>, <-0.000841601, 0.00541179, 0.00869307>,
                         <-9.65166, 5.2435, 14.5114>, <0.00230196, 0.00632443, 0.00776323> }
        smooth_triangle {<-9.65166, 5.2435, 14.5114>, <0.00167954, 0.00595205, 0.00729006>,
                         <-9.6067, 5.17483, 14.5694>, <0.000666396, 0.00603044, 0.00535913>,
                         <-9.53487, 5.19568, 14.5546>, <-0.000912114, 0.00557216, 0.00583952> }
        smooth_triangle {<-9.55675, 5.27106, 14.4918>, <-0.000841601, 0.00541179, 0.00869307>,
                         <-9.58304, 5.36159, 14.4571>, <-8.49494e-05, 0.0030504, 0.0109101>,
                         <-9.69069, 5.33033, 14.4794>, <0.00386841, 0.00419815, 0.00978541> }
        smooth_triangle {<-9.69069, 5.33033, 14.4794>, <0.00310727, 0.00410071, 0.00966796>,
                         <-9.65166, 5.2435, 14.5114>, <0.00193243, 0.00569543, 0.00815132>,
                         <-9.55675, 5.27106, 14.4918>, <-0.000425242, 0.00501094, 0.0088487> }
        smooth_triangle {<-9.58304, 5.36159, 14.4571>, <-8.49494e-05, 0.0030504, 0.0109101>,
                         <-9.61099, 5.45786, 14.4477>, <0.000603307, 0.000610617, 0.0114997>,
                         <-9.72208, 5.42561, 14.4707>, <0.00477474, 0.00182168, 0.0103375> }
        smooth_triangle {<-9.72208, 5.42561, 14.4707>, <0.00404455, 0.00177405, 0.0105624>,
                         <-9.69069, 5.33033, 14.4794>, <0.0033648, 0.0035564, 0.0101484>,
                         <-9.58304, 5.36159, 14.4571>, <0.000399782, 0.00269559, 0.0109919> }
        smooth_triangle {<-9.61099, 5.45786, 14.4477>, <0.000603307, 0.000610617, 0.0114997>,
                         <-9.63899, 5.55431, 14.4558>, <0.00103883, -0.00115338, 0.0109361>,
                         <-9.7471, 5.52292, 14.4782>, <0.00500852, -8.95028e-07, 0.00984491> }
        smooth_triangle {<-9.7471, 5.52292, 14.4782>, <0.00437648, -6.45143e-05, 0.010288>,
                         <-9.72208, 5.42561, 14.4707>, <0.00420115, 0.00130241, 0.0106574>,
                         <-9.61099, 5.45786, 14.4477>, <0.00107257, 0.00039412, 0.0115291> }
        smooth_triangle {<-9.63899, 5.55431, 14.4558>, <0.00103883, -0.00115338, 0.0109361>,
                         <-9.66636, 5.6486, 14.4786>, <0.00127208, -0.00230663, 0.00970604>,
                         <-9.76609, 5.61964, 14.4993>, <0.00479684, -0.00128332, 0.00874582> }
        smooth_triangle {<-9.76609, 5.61964, 14.4993>, <0.00430446, -0.00142566, 0.0093227>,
                         <-9.7471, 5.52292, 14.4782>, <0.00446321, -0.000463845, 0.010147>,
                         <-9.63899, 5.55431, 14.4558>, <0.00148595, -0.00132821, 0.0109654> }
        smooth_triangle {<-9.66636, 5.6486, 14.4786>, <0.00127208, -0.00230663, 0.00970604>,
                         <-9.69298, 5.74027, 14.5111>, <0.00128045, -0.00269388, 0.00822296>,
                         <-9.78076, 5.71479, 14.5293>, <0.00426747, -0.00182668, 0.00741387> }
        smooth_triangle {<-9.78076, 5.71479, 14.5293>, <0.00390944, -0.00204342, 0.00803874>,
                         <-9.76609, 5.61964, 14.4993>, <0.00430646, -0.00163589, 0.0090377>,
                         <-9.66636, 5.6486, 14.4786>, <0.00166289, -0.00240338, 0.00975786> }
        smooth_triangle {<-9.69298, 5.74027, 14.5111>, <0.00128045, -0.00269388, 0.00822296>,
                         <-9.71909, 5.83022, 14.5486>, <0.00112982, -0.00251111, 0.00674715>,
                         <-9.7931, 5.80873, 14.5639>, <0.00358132, -0.00179938, 0.00608626> }
        smooth_triangle {<-9.7931, 5.80873, 14.5639>, <0.00333349, -0.0020529, 0.00670491>,
                         <-9.78076, 5.71479, 14.5293>, <0.0038481, -0.00207338, 0.00770062>,
                         <-9.69298, 5.74027, 14.5111>, <0.00160783, -0.00272378, 0.00830743> }
        smooth_triangle {<-9.71909, 5.83022, 14.5486>, <0.00112982, -0.00251111, 0.00674715>,
                         <-9.74507, 5.91971, 14.5872>, <0.000900288, -0.00202542, 0.00537762>,
                         <-9.80489, 5.90235, 14.5996>, <0.00285469, -0.00145802, 0.00485351> }
        smooth_triangle {<-9.80489, 5.90235, 14.5996>, <0.00269147, -0.00170851, 0.00543571>,
                         <-9.7931, 5.80873, 14.5639>, <0.00323645, -0.00196454, 0.00636028>,
                         <-9.71909, 5.83022, 14.5486>, <0.00139782, -0.00249833, 0.00685594> }
        smooth_triangle {<-9.74507, 5.91971, 14.5872>, <0.000900288, -0.00202542, 0.00537762>,
                         <-9.77125, 6.00988, 14.6241>, <0.000653952, -0.00145955, 0.00412666>,
                         <-9.81751, 5.99645, 14.6337>, <0.00215437, -0.00102395, 0.00372793> }
        smooth_triangle {<-9.81751, 5.99645, 14.6337>, <0.00205525, -0.00123859, 0.00425802>,
                         <-9.80489, 5.90235, 14.5996>, <0.00258048, -0.00156414, 0.0051022>,
                         <-9.74507, 5.91971, 14.5872>, <0.00111468, -0.0019897, 0.00549528> }
        smooth_triangle {<-9.77125, 6.00988, 14.6241>, <0.000653952, -0.00145955, 0.00412666>,
                         <-9.79772, 6.10105, 14.6582>, <0.000432646, -0.000954138, 0.00297434>,
                         <-9.83145, 6.09126, 14.6652>, <0.00151481, -0.000639961, 0.00269073> }
        smooth_triangle {<-9.83145, 6.09126, 14.6652>, <0.00146901, -0.000810954, 0.00316136>,
                         <-9.81751, 5.99645, 14.6337>, <0.00194868, -0.00109894, 0.00393926>,
                         <-9.77125, 6.00988, 14.6241>, <0.000823364, -0.00142565, 0.00423831> }
        smooth_triangle {<-9.79772, 6.10105, 14.6582>, <0.000432646, -0.000954138, 0.00297434>,
                         <-9.82452, 6.19338, 14.6887>, <0.00024991, -0.000545546, 0.00194473>,
                         <-9.84704, 6.18684, 14.6934>, <0.00095819, -0.000339917, 0.00176306> }
        smooth_triangle {<-9.84704, 6.18684, 14.6934>, <0.000954602, -0.000465402, 0.0021665>,
                         <-9.83145, 6.09126, 14.6652>, <0.00137207, -0.000690435, 0.00286226>,
                         <-9.79772, 6.10105, 14.6582>, <0.000560444, -0.000926068, 0.00307496> }
        smooth_triangle {<-9.82452, 6.19338, 14.6887>, <0.00024991, -0.000545546, 0.00194473>,
                         <-9.85171, 6.28703, 14.7145>, <0.0001129, -0.000251292, 0.00107663>,
                         <-9.86477, 6.28324, 14.7172>, <0.000505765, -0.000137235, 0.000979992> }
        smooth_triangle {<-9.86477, 6.28324, 14.7172>, <0.000530598, -0.000216163, 0.00130662>,
                         <-9.84704, 6.18684, 14.6934>, <0.000869917, -0.000368175, 0.00189393>,
                         <-9.82452, 6.19338, 14.6887>, <0.000338707, -0.000522397, 0.00203018> }
        smooth_triangle {<-9.85171, 6.28703, 14.7145>, <0.0001129, -0.000251292, 0.00107663>,
                         <-9.87927, 6.38193, 14.7347>, <2.15542e-05, -7.56246e-05, 0.000383766>,
                         <-9.88489, 6.3803, 14.7359>, <0.00016262, -3.46701e-05, 0.000354701> }
        smooth_triangle {<-9.88489, 6.3803, 14.7359>, <0.000205277, -7.33804e-05, 0.000601849>,
                         <-9.86477, 6.28324, 14.7172>, <0.000462636, -0.000150304, 0.00107082>,
                         <-9.85171, 6.28703, 14.7145>, <0.000167988, -0.000235847, 0.00114329> }
        smooth_triangle {<-9.87927, 6.38193, 14.7347>, <2.15542e-05, -7.56246e-05, 0.000383766>,
                         <-9.90706, 6.47766, 14.7502>, <-3.83272e-05, 1.22285e-05, -0.000171777>,
                         <-9.907, 6.47767, 14.7501>, <-9.90153e-05, -5.39065e-06, -0.000145921> }
        smooth_triangle {<-9.907, 6.47767, 14.7501>, <-4.00838e-05, -1.76716e-05, 3.6466e-05>,
                         <-9.88489, 6.3803, 14.7359>, <0.000156143, -3.96312e-05, 0.000411932>,
                         <-9.87927, 6.38193, 14.7347>, <5.03433e-05, -7.0347e-05, 0.000433731> }
        smooth_triangle {<-9.90706, 6.47766, 14.7502>, <-3.83272e-05, 1.22285e-05, -0.000171777>,
                         <-9.93495, 6.57373, 14.7632>, <-1.82584e-05, 6.28901e-05, -0.000503709>,
                         <-9.93011, 6.57513, 14.7622>, <-0.000203376, 9.14652e-06, -0.000465366> }
        smooth_triangle {<-9.93011, 6.57513, 14.7622>, <-0.000136026, 6.23259e-06, -0.000312188>,
                         <-9.907, 6.47767, 14.7501>, <-7.45929e-05, -3.94181e-06, -0.000110898>,
                         <-9.90706, 6.47766, 14.7502>, <-2.90768e-05, 9.27253e-06, -0.000130291> }
        smooth_triangle {<-9.47321, 5.14584, 14.6406>, <-0.00253581, 0.00526312, 0.00486569>,
                         <-9.46304, 5.21653, 14.5694>, <-0.00333344, 0.00518506, 0.00558226>,
                         <-9.53487, 5.19568, 14.5546>, <-0.00115357, 0.00581792, 0.00582918> }
        smooth_triangle {<-9.53487, 5.19568, 14.5546>, <-0.00124928, 0.00516066, 0.0051089>,
                         <-9.51673, 5.13321, 14.6316>, <-0.00110664, 0.00449583, 0.00390688>,
                         <-9.47321, 5.14584, 14.6406>, <-0.00203611, 0.00422599, 0.00390688> }
        smooth_triangle {<-9.46304, 5.21653, 14.5694>, <-0.00333344, 0.00518506, 0.00558226>,
                         <-9.46185, 5.29861, 14.5114>, <-0.0040876, 0.0044694, 0.00829947>,
                         <-9.55675, 5.27106, 14.4918>, <-0.000841601, 0.00541179, 0.00869307> }
        smooth_triangle {<-9.55675, 5.27106, 14.4918>, <-0.00123884, 0.00510478, 0.00798744>,
                         <-9.53487, 5.19568, 14.5546>, <-0.00147282, 0.00540938, 0.00583952>,
                         <-9.46304, 5.21653, 14.5694>, <-0.00310772, 0.00493473, 0.00565433> }
        smooth_triangle {<-9.46185, 5.29861, 14.5114>, <-0.0040876, 0.0044694, 0.00829947>,
                         <-9.47539, 5.39284, 14.4794>, <-0.00415073, 0.00187001, 0.0103739>,
                         <-9.58304, 5.36159, 14.4571>, <-8.49494e-05, 0.0030504, 0.0109101> }
        smooth_triangle {<-9.58304, 5.36159, 14.4571>, <-0.000747508, 0.00298158, 0.0105115>,
                         <-9.55675, 5.27106, 14.4918>, <-0.001315, 0.00475263, 0.0088487>,
                         <-9.46185, 5.29861, 14.5114>, <-0.00374949, 0.00404584, 0.0085535> }
        smooth_triangle {<-9.47539, 5.39284, 14.4794>, <-0.00415073, 0.00187001, 0.0103739>,
                         <-9.4999, 5.49011, 14.4707>, <-0.00367773, -0.000632262, 0.0109112>,
                         <-9.61099, 5.45786, 14.4477>, <0.000603307, 0.000610617, 0.0114997> }
        smooth_triangle {<-9.61099, 5.45786, 14.4477>, <-0.000157331, 0.000554153, 0.0114341>,
                         <-9.58304, 5.36159, 14.4571>, <-0.000673524, 0.00238399, 0.0109919>,
                         <-9.47539, 5.39284, 14.4794>, <-0.00372286, 0.0014987, 0.0105898> }
        smooth_triangle {<-9.4999, 5.49011, 14.4707>, <-0.00367773, -0.000632262, 0.0109112>,
                         <-9.53087, 5.5857, 14.4782>, <-0.0030297, -0.00233457, 0.0103623>,
                         <-9.63899, 5.55431, 14.4558>, <0.00103883, -0.00115338, 0.0109361> }
        smooth_triangle {<-9.63899, 5.55431, 14.4558>, <0.000289628, -0.00125102, 0.0111064>,
                         <-9.61099, 5.45786, 14.4477>, <-3.70146e-05, 7.19832e-05, 0.0115291>,
                         <-9.4999, 5.49011, 14.4707>, <-0.00324779, -0.000860176, 0.0110877> }
        smooth_triangle {<-9.53087, 5.5857, 14.4782>, <-0.0030297, -0.00233457, 0.0103623>,
                         <-9.56663, 5.67755, 14.4993>, <-0.00233727, -0.00335451, 0.0091886>,
                         <-9.66636, 5.6486, 14.4786>, <0.00127208, -0.00230663, 0.00970604> }
        smooth_triangle {<-9.66636, 5.6486, 14.4786>, <0.000605156, -0.00249965, 0.0100429>,
                         <-9.63899, 5.55431, 14.4558>, <0.00043022, -0.00163471, 0.0109654>,
                         <-9.53087, 5.5857, 14.4782>, <-0.00262118, -0.0025206, 0.0105351> }
        smooth_triangle {<-9.56663, 5.67755, 14.4993>, <-0.00233727, -0.00335451, 0.0091886>,
                         <-9.6052, 5.76576, 14.5293>, <-0.00177654, -0.00358139, 0.00778017>,
                         <-9.69298, 5.74027, 14.5111>, <0.00128045, -0.00269388, 0.00822296> }
        smooth_triangle {<-9.69298, 5.74027, 14.5111>, <0.000722324, -0.0029687, 0.00864555>,
                         <-9.66636, 5.6486, 14.4786>, <0.000716044, -0.00267827, 0.00975786>,
                         <-9.56663, 5.67755, 14.4993>, <-0.00199097, -0.00346417, 0.00936979> }
        smooth_triangle {<-9.6052, 5.76576, 14.5293>, <-0.00177654, -0.00358139, 0.00778017>,
                         <-9.64508, 5.8517, 14.5639>, <-0.00137795, -0.00323917, 0.00638085>,
                         <-9.71909, 5.83022, 14.5486>, <0.00112982, -0.00251111, 0.00674715> }
        smooth_triangle {<-9.71909, 5.83022, 14.5486>, <0.000677193, -0.00282408, 0.00720058>,
                         <-9.69298, 5.74027, 14.5111>, <0.000790167, -0.00296116, 0.00830743>,
                         <-9.6052, 5.76576, 14.5293>, <-0.00150258, -0.0036268, 0.00797534> }
        smooth_triangle {<-9.64508, 5.8517, 14.5639>, <-0.00137795, -0.00323917, 0.00638085>,
                         <-9.68525, 5.93708, 14.5996>, <-0.00109795, -0.00260556, 0.00508303>,
                         <-9.74507, 5.91971, 14.5872>, <0.000900288, -0.00202542, 0.00537762> }
        smooth_triangle {<-9.74507, 5.91971, 14.5872>, <0.000539675, -0.00233323, 0.00582879>,
                         <-9.71909, 5.83022, 14.5486>, <0.000711824, -0.00269749, 0.00685594>,
                         <-9.64508, 5.8517, 14.5639>, <-0.00116901, -0.00324354, 0.00658122> }
        smooth_triangle {<-9.68525, 5.93708, 14.5996>, <-0.00109795, -0.00260556, 0.00508303>,
                         <-9.72499, 6.02331, 14.6337>, <-0.000878794, -0.00190454, 0.00389714>,
                         <-9.77125, 6.00988, 14.6241>, <0.000653952, -0.00145955, 0.00412666> }
        smooth_triangle {<-9.77125, 6.00988, 14.6241>, <0.000371346, -0.00172746, 0.00455707>,
                         <-9.74507, 5.91971, 14.5872>, <0.000556099, -0.00215186, 0.00549528>,
                         <-9.68525, 5.93708, 14.5996>, <-0.000942583, -0.00258697, 0.00527434> }
        smooth_triangle {<-9.72499, 6.02331, 14.6337>, <-0.000878794, -0.00190454, 0.00389714>,
                         <-9.76399, 6.11084, 14.6652>, <-0.000671375, -0.00127466, 0.00280513>,
                         <-9.79772, 6.10105, 14.6582>, <0.000432646, -0.000954138, 0.00297434> }
        smooth_triangle {<-9.79772, 6.10105, 14.6582>, <0.000220585, -0.0011734, 0.00337406>,
                         <-9.77125, 6.00988, 14.6241>, <0.000386564, -0.00155246, 0.00423831>,
                         <-9.72499, 6.02331, 14.6337>, <-0.000762996, -0.0018862, 0.00406617> }
        smooth_triangle {<-9.76399, 6.11084, 14.6652>, <-0.000671375, -0.00127466, 0.00280513>,
                         <-9.80201, 6.19992, 14.6934>, <-0.000471221, -0.000754906, 0.00183033>,
                         <-9.82452, 6.19338, 14.6887>, <0.00024991, -0.000545546, 0.00194473> }
        smooth_triangle {<-9.82452, 6.19338, 14.6887>, <0.000100863, -0.000713261, 0.00230276>,
                         <-9.79772, 6.10105, 14.6582>, <0.000237915, -0.0010197, 0.00307496>,
                         <-9.76399, 6.11084, 14.6652>, <-0.000590101, -0.0012601, 0.00294805> }
        smooth_triangle {<-9.80201, 6.19992, 14.6934>, <-0.000471221, -0.000754906, 0.00183033>,
                         <-9.83866, 6.29082, 14.7172>, <-0.000285573, -0.000366978, 0.00100935>,
                         <-9.85171, 6.28703, 14.7145>, <0.0001129, -0.000251292, 0.00107663> }
        smooth_triangle {<-9.85171, 6.28703, 14.7145>, <1.75587e-05, -0.00036511, 0.0013791>,
                         <-9.82452, 6.19338, 14.6887>, <0.000120316, -0.000585801, 0.00203018>,
                         <-9.80201, 6.19992, 14.6934>, <-0.000420532, -0.000742821, 0.00194438> }
        smooth_triangle {<-9.83866, 6.29082, 14.7172>, <-0.000285573, -0.000366978, 0.00100935>,
                         <-9.87364, 6.38356, 14.7359>, <-0.000119455, -0.000116563, 0.000354406>,
                         <-9.87927, 6.38193, 14.7347>, <2.15542e-05, -7.56246e-05, 0.000383766> }
        smooth_triangle {<-9.87927, 6.38193, 14.7347>, <-2.8823e-05, -0.000141345, 0.000623648>,
                         <-9.85171, 6.28703, 14.7145>, <3.96865e-05, -0.000273096, 0.00114329>,
                         <-9.83866, 6.29082, 14.7172>, <-0.000259169, -0.00035986, 0.00109284> }
        smooth_triangle {<-9.87364, 6.38356, 14.7359>, <-0.000119455, -0.000116563, 0.000354406>,
                         <-9.90711, 6.47764, 14.7501>, <2.72439e-05, 3.12652e-05, -0.000171482>,
                         <-9.90706, 6.47766, 14.7502>, <-3.83272e-05, 1.22285e-05, -0.000171777> }
        smooth_triangle {<-9.90706, 6.47766, 14.7502>, <-5.03112e-05, -2.06408e-05, 1.70736e-05>,
                         <-9.87927, 6.38193, 14.7347>, <-5.40016e-06, -8.65306e-05, 0.000433731>,
                         <-9.87364, 6.38356, 14.7359>, <-0.000111157, -0.000117234, 0.000411711> }
        smooth_triangle {<-9.90711, 6.47764, 14.7501>, <2.72439e-05, 3.12652e-05, -0.000171482>,
                         <-9.93978, 6.57232, 14.7622>, <0.000166859, 0.000116634, -0.000465366>,
                         <-9.93495, 6.57373, 14.7632>, <-1.82584e-05, 6.28901e-05, -0.000503709> }
        smooth_triangle {<-9.93495, 6.57373, 14.7632>, <-1.18714e-05, 4.22773e-05, -0.00033775>,
                         <-9.90706, 6.47766, 14.7502>, <-2.85197e-05, 9.43425e-06, -0.000130291>,
                         <-9.90711, 6.47764, 14.7501>, <2.06586e-05, 2.37118e-05, -0.00013007> }
        smooth_triangle {<-9.43632, 5.15655, 14.6663>, <-0.00425324, 0.00476451, 0.00412494>,
                         <-9.40215, 5.23421, 14.6118>, <-0.00525663, 0.00462672, 0.00448549>,
                         <-9.46304, 5.21653, 14.5694>, <-0.00333344, 0.00518506, 0.00558226> }
        smooth_triangle {<-9.46304, 5.21653, 14.5694>, <-0.00314433, 0.00461048, 0.0048115>,
                         <-9.47321, 5.14584, 14.6406>, <-0.0025564, 0.00407494, 0.00368247>,
                         <-9.43632, 5.15655, 14.6663>, <-0.00341511, 0.00382563, 0.00331209> }
        smooth_triangle {<-9.40215, 5.23421, 14.6118>, <-0.00525663, 0.00462672, 0.00448549>,
                         <-9.3814, 5.32197, 14.5674>, <-0.00694185, 0.00364075, 0.00664235>,
                         <-9.46185, 5.29861, 14.5114>, <-0.0040876, 0.0044694, 0.00829947> }
        smooth_triangle {<-9.46185, 5.29861, 14.5114>, <-0.00419137, 0.00424759, 0.0074688>,
                         <-9.46304, 5.21653, 14.5694>, <-0.00362575, 0.00478434, 0.00543089>,
                         <-9.40215, 5.23421, 14.6118>, <-0.00506814, 0.00436558, 0.00460832> }
        smooth_triangle {<-9.3814, 5.32197, 14.5674>, <-0.00694185, 0.00364075, 0.00664235>,
                         <-9.38413, 5.41934, 14.5429>, <-0.00770994, 0.000836695, 0.00825833>,
                         <-9.47539, 5.39284, 14.4794>, <-0.00415073, 0.00187001, 0.0103739> }
        smooth_triangle {<-9.47539, 5.39284, 14.4794>, <-0.00461887, 0.00185764, 0.00975477>,
                         <-9.46185, 5.29861, 14.5114>, <-0.00457152, 0.00380719, 0.00819895>,
                         <-9.3814, 5.32197, 14.5674>, <-0.00671221, 0.00318569, 0.00695611> }
        smooth_triangle {<-9.38413, 5.41934, 14.5429>, <-0.00770994, 0.000836695, 0.00825833>,
                         <-9.40572, 5.51746, 14.5363>, <-0.00741661, -0.00171774, 0.00866158>,
                         <-9.4999, 5.49011, 14.4707>, <-0.00367773, -0.000632262, 0.0109112> }
        smooth_triangle {<-9.4999, 5.49011, 14.4707>, <-0.00435971, -0.000665891, 0.010565>,
                         <-9.47539, 5.39284, 14.4794>, <-0.00471446, 0.00121082, 0.0101621>,
                         <-9.38413, 5.41934, 14.5429>, <-0.00738387, 0.000435826, 0.00857538> }
        smooth_triangle {<-9.40572, 5.51746, 14.5363>, <-0.00741661, -0.00171774, 0.00866158>,
                         <-9.43922, 5.6123, 14.542>, <-0.00657767, -0.00336462, 0.00821103>,
                         <-9.53087, 5.5857, 14.4782>, <-0.0030297, -0.00233457, 0.0103623> }
        smooth_triangle {<-9.53087, 5.5857, 14.4782>, <-0.00378689, -0.00243452, 0.0102339>,
                         <-9.4999, 5.49011, 14.4707>, <-0.00427291, -0.00115779, 0.0106455>,
                         <-9.40572, 5.51746, 14.5363>, <-0.00707708, -0.0019719, 0.00895832> }
        smooth_triangle {<-9.43922, 5.6123, 14.542>, <-0.00657767, -0.00336462, 0.00821103>,
                         <-9.48208, 5.7021, 14.5581>, <-0.0054817, -0.00426741, 0.00727229>,
                         <-9.56663, 5.67755, 14.4993>, <-0.00233727, -0.00335451, 0.0091886> }
        smooth_triangle {<-9.56663, 5.67755, 14.4993>, <-0.00307722, -0.00356872, 0.00923409>,
                         <-9.53087, 5.5857, 14.4782>, <-0.00359654, -0.00280377, 0.0101144>,
                         <-9.43922, 5.6123, 14.542>, <-0.00625752, -0.00357631, 0.00850091> }
        smooth_triangle {<-9.48208, 5.7021, 14.5581>, <-0.0054817, -0.00426741, 0.00727229>,
                         <-9.53078, 5.78736, 14.5811>, <-0.00443811, -0.0043541, 0.00615293>,
                         <-9.6052, 5.76576, 14.5293>, <-0.00177654, -0.00358139, 0.00778017> }
        smooth_triangle {<-9.6052, 5.76576, 14.5293>, <-0.00244519, -0.0038883, 0.00793616>,
                         <-9.56663, 5.67755, 14.4993>, <-0.00286574, -0.00371814, 0.00899248>,
                         <-9.48208, 5.7021, 14.5581>, <-0.00522407, -0.00440281, 0.00755524> }
        smooth_triangle {<-9.53078, 5.78736, 14.5811>, <-0.00443811, -0.0043541, 0.00615293>,
                         <-9.58233, 5.86992, 14.6076>, <-0.00356022, -0.00387273, 0.00504312>,
                         <-9.64508, 5.8517, 14.5639>, <-0.00137795, -0.00323917, 0.00638085> }
        smooth_triangle {<-9.64508, 5.8517, 14.5639>, <-0.00195906, -0.00358945, 0.00660002>,
                         <-9.6052, 5.76576, 14.5293>, <-0.002258, -0.00384611, 0.00764951>,
                         <-9.53078, 5.78736, 14.5811>, <-0.00425418, -0.00442565, 0.00642908> }
        smooth_triangle {<-9.58233, 5.86992, 14.6076>, <-0.00356022, -0.00387273, 0.00504312>,
                         <-9.63454, 5.9518, 14.6349>, <-0.00283583, -0.0031101, 0.0040146>,
                         <-9.68525, 5.93708, 14.5996>, <-0.00109795, -0.00260556, 0.00508303> }
        smooth_triangle {<-9.68525, 5.93708, 14.5996>, <-0.00159279, -0.00295233, 0.00533449>,
                         <-9.64508, 5.8517, 14.5639>, <-0.00180279, -0.00342754, 0.00630786>,
                         <-9.58233, 5.86992, 14.6076>, <-0.00343948, -0.00390271, 0.00530456> }
        smooth_triangle {<-9.63454, 5.9518, 14.6349>, <-0.00283583, -0.0031101, 0.0040146>,
                         <-9.68577, 6.0347, 14.661>, <-0.00221052, -0.00229117, 0.00307432>,
                         <-9.72499, 6.02331, 14.6337>, <-0.000878794, -0.00190454, 0.00389714> }
        smooth_triangle {<-9.72499, 6.02331, 14.6337>, <-0.00129428, -0.00221103, 0.00416234>,
                         <-9.68525, 5.93708, 14.5996>, <-0.00145865, -0.00273679, 0.00505176>,
                         <-9.63454, 5.9518, 14.6349>, <-0.00276205, -0.0031152, 0.00425043> }
        smooth_triangle {<-9.68577, 6.0347, 14.661>, <-0.00221052, -0.00229117, 0.00307432>,
                         <-9.73539, 6.11914, 14.6851>, <-0.00162917, -0.00155273, 0.00220886>,
                         <-9.76399, 6.11084, 14.6652>, <-0.000671375, -0.00127466, 0.00280513> }
        smooth_triangle {<-9.76399, 6.11084, 14.6652>, <-0.00101098, -0.00153095, 0.0030731>,
                         <-9.72499, 6.02331, 14.6337>, <-0.00116655, -0.00200336, 0.00389211>,
                         <-9.68577, 6.0347, 14.661>, <-0.00216534, -0.00229333, 0.00327499> }
        smooth_triangle {<-9.73539, 6.11914, 14.6851>, <-0.00162917, -0.00155273, 0.00220886>,
                         <-9.78292, 6.20546, 14.7067>, <-0.00109542, -0.000936124, 0.00143728>,
                         <-9.80201, 6.19992, 14.6934>, <-0.000471221, -0.000754906, 0.00183033> }
        smooth_triangle {<-9.80201, 6.19992, 14.6934>, <-0.000737963, -0.000956791, 0.00208843>,
                         <-9.76399, 6.11084, 14.6652>, <-0.000888079, -0.00134661, 0.00281953>,
                         <-9.73539, 6.11914, 14.6851>, <-0.00160643, -0.00155516, 0.00237233> }
        smooth_triangle {<-9.78292, 6.20546, 14.7067>, <-0.00109542, -0.000936124, 0.00143728>,
                         <-9.82759, 6.29403, 14.7249>, <-0.000628991, -0.000466679, 0.000788414>,
                         <-9.83866, 6.29082, 14.7172>, <-0.000285573, -0.000366978, 0.00100935> }
        smooth_triangle {<-9.83866, 6.29082, 14.7172>, <-0.000483063, -0.000510452, 0.00124162>,
                         <-9.80201, 6.19992, 14.6934>, <-0.000622299, -0.000801398, 0.00185735>,
                         <-9.78292, 6.20546, 14.7067>, <-0.00109045, -0.000937312, 0.00156257> }
        smooth_triangle {<-9.82759, 6.29403, 14.7249>, <-0.000628991, -0.000466679, 0.000788414>,
                         <-9.86888, 6.38495, 14.7392>, <-0.00023894, -0.000151252, 0.000271091>,
                         <-9.87364, 6.38356, 14.7359>, <-0.000119455, -0.000116563, 0.000354406> }
        smooth_triangle {<-9.87364, 6.38356, 14.7359>, <-0.000253115, -0.000206462, 0.000550502>,
                         <-9.83866, 6.29082, 14.7172>, <-0.000377703, -0.000394273, 0.00104171>,
                         <-9.82759, 6.29403, 14.7249>, <-0.000635267, -0.000469049, 0.000876008> }
        smooth_triangle {<-9.86888, 6.38495, 14.7392>, <-0.00023894, -0.000151252, 0.000271091>,
                         <-9.90716, 6.47763, 14.7501>, <8.77153e-05, 4.88214e-05, -0.000145081>,
                         <-9.90711, 6.47764, 14.7501>, <2.72439e-05, 3.12652e-05, -0.000171482> }
        smooth_triangle {<-9.90711, 6.47764, 14.7501>, <-5.26332e-05, -2.13149e-05, -4.91817e-06>,
                         <-9.87364, 6.38356, 14.7359>, <-0.000162657, -0.000132186, 0.000389498>,
                         <-9.86888, 6.38495, 14.7392>, <-0.000252271, -0.000158203, 0.000327012> }
        smooth_triangle {<-9.90716, 6.47763, 14.7501>, <8.77153e-05, 4.88214e-05, -0.000145081>,
                         <-9.94388, 6.57113, 14.7593>, <0.000323794, 0.000162195, -0.000356176>,
                         <-9.93978, 6.57232, 14.7622>, <0.000166859, 0.000116634, -0.000465366> }
        smooth_triangle {<-9.93978, 6.57232, 14.7622>, <0.000112226, 7.83056e-05, -0.000311892>,
                         <-9.90711, 6.47764, 14.7501>, <2.11732e-05, 2.38612e-05, -0.000129848>,
                         <-9.90716, 6.47763, 14.7501>, <6.65267e-05, 3.70283e-05, -0.000110047> }
        smooth_triangle {<-9.41167, 5.16371, 14.7047>, <-0.00556771, 0.00438289, 0.00275619>,
                         <-9.36146, 5.24603, 14.6752>, <-0.00663035, 0.00422789, 0.00270585>,
                         <-9.40215, 5.23421, 14.6118>, <-0.00525663, 0.00462672, 0.00448549> }
        smooth_triangle {<-9.40215, 5.23421, 14.6118>, <-0.00478582, 0.00413392, 0.0037816>,
                         <-9.43632, 5.15655, 14.6663>, <-0.00381332, 0.00371002, 0.00289744>,
                         <-9.41167, 5.16371, 14.7047>, <-0.00447055, 0.00351921, 0.00221307> }
        smooth_triangle {<-9.36146, 5.24603, 14.6752>, <-0.00663035, 0.00422789, 0.00270585>,
                         <-9.32764, 5.33757, 14.6512>, <-0.00896984, 0.00305198, 0.00397399>,
                         <-9.3814, 5.32197, 14.5674>, <-0.00694185, 0.00364075, 0.00664235> }
        smooth_triangle {<-9.3814, 5.32197, 14.5674>, <-0.00672854, 0.003511, 0.00581311>,
                         <-9.40215, 5.23421, 14.6118>, <-0.00546462, 0.00425047, 0.00419547>,
                         <-9.36146, 5.24603, 14.6752>, <-0.00649491, 0.00395135, 0.00286073> }
        smooth_triangle {<-9.32764, 5.33757, 14.6512>, <-0.00896984, 0.00305198, 0.00397399>,
                         <-9.32315, 5.43704, 14.6379>, <-0.0102207, 0.000107755, 0.0048855>,
                         <-9.38413, 5.41934, 14.5429>, <-0.00770994, 0.000836695, 0.00825833> }
        smooth_triangle {<-9.38413, 5.41934, 14.5429>, <-0.00791743, 0.000899997, 0.00751296>,
                         <-9.3814, 5.32197, 14.5674>, <-0.00734137, 0.00300304, 0.00630098>,
                         <-9.32764, 5.33757, 14.6512>, <-0.00886235, 0.00256146, 0.00429971> }
        smooth_triangle {<-9.32315, 5.43704, 14.6379>, <-0.0102207, 0.000107755, 0.0048855>,
                         <-9.34279, 5.53572, 14.6343>, <-0.0100441, -0.00248057, 0.00509331>,
                         <-9.40572, 5.51746, 14.5363>, <-0.00741661, -0.00171774, 0.00866158> }
        smooth_triangle {<-9.40572, 5.51746, 14.5363>, <-0.00792282, -0.00170034, 0.00808754>,
                         <-9.38413, 5.41934, 14.5429>, <-0.00814282, 0.000215489, 0.00778511>,
                         <-9.32315, 5.43704, 14.6379>, <-0.0100259, -0.000331216, 0.00525549> }
        smooth_triangle {<-9.34279, 5.53572, 14.6343>, <-0.0100441, -0.00248057, 0.00509331>,
                         <-9.37798, 5.63008, 14.6374>, <-0.00906495, -0.00408673, 0.00480966>,
                         <-9.43922, 5.6123, 14.542>, <-0.00657767, -0.00336462, 0.00821103> }
        smooth_triangle {<-9.43922, 5.6123, 14.542>, <-0.00723247, -0.00343485, 0.00780342>,
                         <-9.40572, 5.51746, 14.5363>, <-0.00786167, -0.00219969, 0.00814133>,
                         <-9.34279, 5.53572, 14.6343>, <-0.00983231, -0.00277181, 0.00546513> }
        smooth_triangle {<-9.37798, 5.63008, 14.6374>, <-0.00906495, -0.00408673, 0.00480966>,
                         <-9.42559, 5.7185, 14.6462>, <-0.00768252, -0.00490635, 0.00424883>,
                         <-9.48208, 5.7021, 14.5581>, <-0.0054817, -0.00426741, 0.00727229> }
        smooth_triangle {<-9.48208, 5.7021, 14.5581>, <-0.00618206, -0.00447013, 0.00701952>,
                         <-9.43922, 5.6123, 14.542>, <-0.00700404, -0.00379304, 0.00772357>,
                         <-9.37798, 5.63008, 14.6374>, <-0.00886949, -0.00433462, 0.00517255> }
        smooth_triangle {<-9.42559, 5.7185, 14.6462>, <-0.00768252, -0.00490635, 0.00424883>,
                         <-9.48106, 5.8018, 14.6586>, <-0.00629905, -0.00489438, 0.00358896>,
                         <-9.53078, 5.78736, 14.5811>, <-0.00443811, -0.0043541, 0.00615293> }
        smooth_triangle {<-9.53078, 5.78736, 14.5811>, <-0.00511089, -0.00466222, 0.00601856>,
                         <-9.48208, 5.7021, 14.5581>, <-0.00589359, -0.00459719, 0.00685808>,
                         <-9.42559, 5.7185, 14.6462>, <-0.0075442, -0.0050764, 0.00459048> }
        smooth_triangle {<-9.48106, 5.8018, 14.6586>, <-0.00629905, -0.00489438, 0.00358896>,
                         <-9.54041, 5.88209, 14.6729>, <-0.00508474, -0.00431533, 0.00293762>,
                         <-9.58233, 5.86992, 14.6076>, <-0.00356022, -0.00387273, 0.00504312> }
        smooth_triangle {<-9.58233, 5.86992, 14.6076>, <-0.00417394, -0.00423247, 0.00499467>,
                         <-9.53078, 5.78736, 14.5811>, <-0.00483236, -0.00459351, 0.00582703>,
                         <-9.48106, 5.8018, 14.6586>, <-0.00622806, -0.00499871, 0.00390405> }
        smooth_triangle {<-9.54041, 5.88209, 14.6729>, <-0.00508474, -0.00431533, 0.00293762>,
                         <-9.60066, 5.96164, 14.6877>, <-0.00404875, -0.00346224, 0.00233498>,
                         <-9.63454, 5.9518, 14.6349>, <-0.00283583, -0.0031101, 0.0040146> }
        smooth_triangle {<-9.63454, 5.9518, 14.6349>, <-0.00338127, -0.00347156, 0.00402806>,
                         <-9.58233, 5.86992, 14.6076>, <-0.00392456, -0.00404354, 0.00479945>,
                         <-9.54041, 5.88209, 14.6729>, <-0.00506795, -0.00437549, 0.00322033> }
        smooth_triangle {<-9.60066, 5.96164, 14.6877>, <-0.00404875, -0.00346224, 0.00233498>,
                         <-9.65956, 6.0423, 14.7018>, <-0.00313847, -0.00256058, 0.00178346>,
                         <-9.68577, 6.0347, 14.661>, <-0.00221052, -0.00229117, 0.00307432> }
        smooth_triangle {<-9.68577, 6.0347, 14.661>, <-0.00268805, -0.00261567, 0.00313394>,
                         <-9.63454, 5.9518, 14.6349>, <-0.00315703, -0.00322987, 0.00383914>,
                         <-9.60066, 5.96164, 14.6877>, <-0.00406672, -0.00349397, 0.00257943> }
        smooth_triangle {<-9.65956, 6.0423, 14.7018>, <-0.00313847, -0.00256058, 0.00178346>,
                         <-9.71629, 6.12469, 14.7149>, <-0.00229493, -0.00174601, 0.00127632>,
                         <-9.73539, 6.11914, 14.6851>, <-0.00162917, -0.00155273, 0.00220886> }
        smooth_triangle {<-9.73539, 6.11914, 14.6851>, <-0.00203819, -0.00182917, 0.00230428>,
                         <-9.68577, 6.0347, 14.661>, <-0.0024742, -0.002383, 0.00295337>,
                         <-9.65956, 6.0423, 14.7018>, <-0.00317017, -0.00258506, 0.00198523> }
        smooth_triangle {<-9.71629, 6.12469, 14.7149>, <-0.00229493, -0.00174601, 0.00127632>,
                         <-9.77016, 6.20916, 14.7266>, <-0.00152765, -0.00106161, 0.000825422>,
                         <-9.78292, 6.20546, 14.7067>, <-0.00109542, -0.000936124, 0.00143728> }
        smooth_triangle {<-9.78292, 6.20546, 14.7067>, <-0.00143417, -0.00115892, 0.00155617>,
                         <-9.73539, 6.11914, 14.6851>, <-0.00183449, -0.00162137, 0.00213485>,
                         <-9.71629, 6.12469, 14.7149>, <-0.00233381, -0.00176633, 0.00143544> }
        smooth_triangle {<-9.77016, 6.20916, 14.7266>, <-0.00152765, -0.00106161, 0.000825422>,
                         <-9.8202, 6.29618, 14.7364>, <-0.000865071, -0.000535219, 0.000447447>,
                         <-9.82759, 6.29403, 14.7249>, <-0.000628991, -0.000466679, 0.000788414> }
        smooth_triangle {<-9.82759, 6.29403, 14.7249>, <-0.000895052, -0.000630061, 0.000915113>,
                         <-9.78292, 6.20546, 14.7067>, <-0.00124487, -0.000982145, 0.00140177>,
                         <-9.77016, 6.20916, 14.7266>, <-0.00156905, -0.00107626, 0.000942869> }
        smooth_triangle {<-9.8202, 6.29618, 14.7364>, <-0.000865071, -0.000535219, 0.000447447>,
                         <-9.86569, 6.38587, 14.7441>, <-0.000318712, -0.000174411, 0.000146505>,
                         <-9.86888, 6.38495, 14.7392>, <-0.00023894, -0.000151252, 0.000271091> }
        smooth_triangle {<-9.86888, 6.38495, 14.7392>, <-0.000433451, -0.000258817, 0.000393547>,
                         <-9.82759, 6.29403, 14.7249>, <-0.000725989, -0.000495388, 0.000781539>,
                         <-9.8202, 6.29618, 14.7364>, <-0.000903049, -0.000546793, 0.000525814> }
        smooth_triangle {<-9.86569, 6.38587, 14.7441>, <-0.000318712, -0.000174411, 0.000146505>,
                         <-9.90719, 6.47762, 14.7501>, <0.000133881, 6.22242e-05, -9.6592e-05>,
                         <-9.90716, 6.47763, 14.7501>, <8.77153e-05, 4.88214e-05, -0.000145081> }
        smooth_triangle {<-9.90716, 6.47763, 14.7501>, <-4.66963e-05, -1.95913e-05, -2.61612e-05>,
                         <-9.86888, 6.38495, 14.7392>, <-0.000291688, -0.000169646, 0.000285968>,
                         <-9.86569, 6.38587, 14.7441>, <-0.000351516, -0.000187016, 0.000192528> }
        smooth_triangle {<-9.90719, 6.47762, 14.7501>, <0.000133881, 6.22242e-05, -9.6592e-05>,
                         <-9.94662, 6.57034, 14.755>, <0.000428654, 0.000192639, -0.000192761>,
                         <-9.94388, 6.57113, 14.7593>, <0.000323794, 0.000162195, -0.000356176> }
        smooth_triangle {<-9.94388, 6.57113, 14.7593>, <0.000217375, 0.000108833, -0.000238552>,
                         <-9.90716, 6.47763, 14.7501>, <6.69206e-05, 3.71427e-05, -0.000109636>,
                         <-9.90719, 6.47762, 14.7501>, <0.000101545, 4.71948e-05, -7.32699e-05> }
        smooth_triangle {<-9.40301, 5.16622, 14.75>, <-0.00627909, 0.00417636, 0.000967846>,
                         <-9.34717, 5.25017, 14.75>, <-0.00724547, 0.00404931, 0.000514264>,
                         <-9.36146, 5.24603, 14.6752>, <-0.00663035, 0.00422789, 0.00270585> }
        smooth_triangle {<-9.36146, 5.24603, 14.6752>, <-0.00592387, 0.00380352, 0.00217599>,
                         <-9.41167, 5.16371, 14.7047>, <-0.00468606, 0.00345665, 0.0016713>,
                         <-9.40301, 5.16622, 14.75>, <-0.00504176, 0.00335338, 0.000777126> }
        smooth_triangle {<-9.34717, 5.25017, 14.75>, <-0.00724547, 0.00404931, 0.000514264>,
                         <-9.30877, 5.34305, 14.75>, <-0.00986281, 0.00279273, 0.000700631>,
                         <-9.32764, 5.33757, 14.6512>, <-0.00896984, 0.00305198, 0.00397399> }
        smooth_triangle {<-9.32764, 5.33757, 14.6512>, <-0.0084641, 0.00300712, 0.00327242>,
                         <-9.36146, 5.24603, 14.6752>, <-0.00670949, 0.00388906, 0.00232132>,
                         <-9.34717, 5.25017, 14.75>, <-0.00717083, 0.00375512, 0.000677629> }
        smooth_triangle {<-9.30877, 5.34305, 14.75>, <-0.00986281, 0.00279273, 0.000700631>,
                         <-9.30174, 5.44325, 14.75>, <-0.0113009, -0.000205831, 0.0007689>,
                         <-9.32315, 5.43704, 14.6379>, <-0.0102207, 0.000107755, 0.0048855> }
        smooth_triangle {<-9.32315, 5.43704, 14.6379>, <-0.010141, 0.000254439, 0.00412737>,
                         <-9.32764, 5.33757, 14.6512>, <-0.00920285, 0.00246261, 0.00344374>,
                         <-9.30877, 5.34305, 14.75>, <-0.00987258, 0.00226817, 0.00098872> }
        smooth_triangle {<-9.30174, 5.44325, 14.75>, <-0.0113009, -0.000205831, 0.0007689>,
                         <-9.3207, 5.54214, 14.75>, <-0.0111603, -0.00280461, 0.00074963>,
                         <-9.34279, 5.53572, 14.6343>, <-0.0100441, -0.00248057, 0.00509331> }
        smooth_triangle {<-9.34279, 5.53572, 14.6343>, <-0.0103042, -0.00239171, 0.00437879>,
                         <-9.32315, 5.43704, 14.6379>, <-0.0104366, -0.000450462, 0.00422294>,
                         <-9.30174, 5.44325, 14.75>, <-0.0112467, -0.000685651, 0.00113549> }
        smooth_triangle {<-9.3207, 5.54214, 14.75>, <-0.0111603, -0.00280461, 0.00074963>,
                         <-9.35647, 5.63633, 14.75>, <-0.0101129, -0.00439096, 0.000676063>,
                         <-9.37798, 5.63008, 14.6374>, <-0.00906495, -0.00408673, 0.00480966> }
        smooth_triangle {<-9.37798, 5.63008, 14.6374>, <-0.00952254, -0.00409971, 0.00418495>,
                         <-9.34279, 5.53572, 14.6343>, <-0.0102569, -0.00289508, 0.00439768>,
                         <-9.3207, 5.54214, 14.75>, <-0.011094, -0.00313812, 0.00113992> }
        smooth_triangle {<-9.35647, 5.63633, 14.75>, <-0.0101129, -0.00439096, 0.000676063>,
                         <-9.40575, 5.72426, 14.75>, <-0.00860467, -0.00517407, 0.000578525>,
                         <-9.42559, 5.7185, 14.6462>, <-0.00768252, -0.00490635, 0.00424883> }
        smooth_triangle {<-9.42559, 5.7185, 14.6462>, <-0.00823668, -0.00506663, 0.00373628>,
                         <-9.37798, 5.63008, 14.6374>, <-0.0092735, -0.00445192, 0.00415691>,
                         <-9.35647, 5.63633, 14.75>, <-0.0100594, -0.00468009, 0.00105671> }
        smooth_triangle {<-9.40575, 5.72426, 14.75>, <-0.00860467, -0.00517407, 0.000578525>,
                         <-9.4636, 5.80687, 14.75>, <-0.00707605, -0.00511996, 0.000478598>,
                         <-9.48106, 5.8018, 14.6586>, <-0.00629905, -0.00489438, 0.00358896> }
        smooth_triangle {<-9.48106, 5.8018, 14.6586>, <-0.00686894, -0.00517262, 0.00318469>,
                         <-9.42559, 5.7185, 14.6462>, <-0.00790654, -0.0051816, 0.00367959>,
                         <-9.40575, 5.72426, 14.75>, <-0.00859815, -0.00538239, 0.000926865> }
        smooth_triangle {<-9.4636, 5.80687, 14.75>, <-0.00707605, -0.00511996, 0.000478598>,
                         <-9.52569, 5.88637, 14.75>, <-0.00571942, -0.00449959, 0.000384897>,
                         <-9.54041, 5.88209, 14.6729>, <-0.00508474, -0.00431533, 0.00293762> }
        smooth_triangle {<-9.54041, 5.88209, 14.6729>, <-0.00563024, -0.00465527, 0.00262893>,
                         <-9.48106, 5.8018, 14.6586>, <-0.00654097, -0.00508955, 0.00311743>,
                         <-9.4636, 5.80687, 14.75>, <-0.00712372, -0.00525874, 0.000784663> }
        smooth_triangle {<-9.52569, 5.88637, 14.75>, <-0.00571942, -0.00449959, 0.000384897>,
                         <-9.58876, 5.9651, 14.75>, <-0.00455208, -0.00360836, 0.000299881>,
                         <-9.60066, 5.96164, 14.6877>, <-0.00404875, -0.00346224, 0.00233498> }
        smooth_triangle {<-9.60066, 5.96164, 14.6877>, <-0.00455348, -0.00381188, 0.0021084>,
                         <-9.54041, 5.88209, 14.6729>, <-0.00533047, -0.0044517, 0.00256038>,
                         <-9.52569, 5.88637, 14.75>, <-0.00580648, -0.0045899, 0.000645835> }
        smooth_triangle {<-9.58876, 5.9651, 14.75>, <-0.00455208, -0.00360836, 0.000299881>,
                         <-9.65036, 6.04498, 14.75>, <-0.00352139, -0.00267175, 0.000221083>,
                         <-9.65956, 6.0423, 14.7018>, <-0.00313847, -0.00256058, 0.00178346> }
        smooth_triangle {<-9.65956, 6.0423, 14.7018>, <-0.00359778, -0.00287979, 0.00162842>,
                         <-9.60066, 5.96164, 14.6877>, <-0.00428048, -0.00355603, 0.00204206>,
                         <-9.58876, 5.9651, 14.75>, <-0.00465798, -0.00366563, 0.000515735> }
        smooth_triangle {<-9.65036, 6.04498, 14.75>, <-0.00352139, -0.00267175, 0.000221083>,
                         <-9.70958, 6.12664, 14.75>, <-0.00256729, -0.00182509, 0.000149467>,
                         <-9.71629, 6.12469, 14.7149>, <-0.00229493, -0.00174601, 0.00127632> }
        smooth_triangle {<-9.71629, 6.12469, 14.7149>, <-0.00270467, -0.00202267, 0.00118466>,
                         <-9.65956, 6.0423, 14.7018>, <-0.00333733, -0.00263359, 0.00156501>,
                         <-9.65036, 6.04498, 14.75>, <-0.00362451, -0.00271696, 0.00039323> }
        smooth_triangle {<-9.70958, 6.12664, 14.75>, <-0.00256729, -0.00182509, 0.000149467>,
                         <-9.76568, 6.21046, 14.75>, <-0.00170212, -0.00111226, 8.78968e-05>,
                         <-9.77016, 6.20916, 14.7266>, <-0.00152765, -0.00106161, 0.000825422> }
        smooth_triangle {<-9.77016, 6.20916, 14.7266>, <-0.00188177, -0.00128886, 0.00078699>,
                         <-9.71629, 6.12469, 14.7149>, <-0.00245723, -0.00180217, 0.00112516>,
                         <-9.70958, 6.12664, 14.75>, <-0.0026615, -0.00186147, 0.000280024> }
        smooth_triangle {<-9.76568, 6.21046, 14.75>, <-0.00170212, -0.00111226, 8.78968e-05>,
                         <-9.8176, 6.29694, 14.75>, <-0.000957872, -0.000562161, 3.83606e-05>,
                         <-9.8202, 6.29618, 14.7364>, <-0.000865071, -0.000535219, 0.000447447> }
        smooth_triangle {<-9.8202, 6.29618, 14.7364>, <-0.00115569, -0.000705729, 0.00044929>,
                         <-9.77016, 6.20916, 14.7266>, <-0.00165262, -0.00110052, 0.000732771>,
                         <-9.76568, 6.21046, 14.75>, <-0.00178347, -0.00113851, 0.000179627> }
        smooth_triangle {<-9.8176, 6.29694, 14.75>, <-0.000957872, -0.000562161, 3.83606e-05>,
                         <-9.86457, 6.38619, 14.75>, <-0.000346624, -0.000182515, -3.85327e-07>,
                         <-9.86569, 6.38587, 14.7441>, <-0.000318712, -0.000174411, 0.000146505> }
        smooth_triangle {<-9.86569, 6.38587, 14.7441>, <-0.000542378, -0.000290441, 0.000176678>,
                         <-9.8202, 6.29618, 14.7364>, <-0.000952148, -0.000561047, 0.000402385>,
                         <-9.8176, 6.29694, 14.75>, <-0.00102175, -0.000581254, 9.55698e-05> }
        smooth_triangle {<-9.86457, 6.38619, 14.75>, <-0.000346624, -0.000182515, -3.85327e-07>,
                         <-9.9072, 6.47762, 14.75>, <0.000158712, 6.94333e-05, -3.3398e-05>,
                         <-9.90719, 6.47762, 14.7501>, <0.000133881, 6.22242e-05, -9.6592e-05> }
        smooth_triangle {<-9.90719, 6.47762, 14.7501>, <-3.34043e-05, -1.57324e-05, -4.34214e-05>,
                         <-9.86569, 6.38587, 14.7441>, <-0.000372849, -0.000193209, 0.000138901>,
                         <-9.86457, 6.38619, 14.75>, <-0.000393783, -0.000199287, 2.87336e-05> }
        smooth_triangle {<-9.9072, 6.47762, 14.75>, <0.000158712, 6.94333e-05, -3.3398e-05>,
                         <-9.94758, 6.57006, 14.75>, <0.000465476, 0.000203329, 2.43945e-19>,
                         <-9.94662, 6.57034, 14.755>, <0.000428654, 0.000192639, -0.000192761> }
        smooth_triangle {<-9.94662, 6.57034, 14.755>, <0.000287566, 0.000129211, -0.000128894>,
                         <-9.90719, 6.47762, 14.7501>, <0.000101758, 4.72567e-05, -7.2734e-05>,
                         <-9.9072, 6.47762, 14.75>, <0.000120381, 5.26635e-05, -2.53385e-05> }
        smooth_triangle {<-9.41167, 5.16371, 14.7953>, <-0.00627909, 0.00417636, -0.000967846>,
                         <-9.36146, 5.24603, 14.8248>, <-0.00700834, 0.00411815, -0.00175561>,
                         <-9.34717, 5.25017, 14.75>, <-0.00724547, 0.00404931, 0.000514264> }
        smooth_triangle {<-9.34717, 5.25017, 14.75>, <-0.00638521, 0.00366958, 0.000239097>,
                         <-9.40301, 5.16622, 14.75>, <-0.00504176, 0.00335338, 0.00019072>,
                         <-9.41167, 5.16371, 14.7953>, <-0.00504176, 0.00335338, -0.000777126> }
        smooth_triangle {<-9.36146, 5.24603, 14.8248>, <-0.00700834, 0.00411815, -0.00175561>,
                         <-9.32764, 5.33757, 14.8488>, <-0.00948481, 0.00290247, -0.0026794>,
                         <-9.30877, 5.34305, 14.75>, <-0.00986281, 0.00279273, 0.000700631> }
        smooth_triangle {<-9.30877, 5.34305, 14.75>, <-0.00913383, 0.00281269, 0.000233542>,
                         <-9.34717, 5.25017, 14.75>, <-0.00717083, 0.00375512, 9.37677e-05>,
                         <-9.36146, 5.24603, 14.8248>, <-0.00699298, 0.00380675, -0.00160864> }
        smooth_triangle {<-9.32764, 5.33757, 14.8488>, <-0.00948481, 0.00290247, -0.0026794>,
                         <-9.32315, 5.43704, 14.8621>, <-0.0107859, -5.63218e-05, -0.00346476>,
                         <-9.30174, 5.44325, 14.75>, <-0.0113009, -0.000205831, 0.0007689> }
        smooth_triangle {<-9.30174, 5.44325, 14.75>, <-0.0109511, 1.92494e-05, 0.000113428>,
                         <-9.30877, 5.34305, 14.75>, <-0.00987258, 0.00226817, 6.22256e-05>,
                         <-9.32764, 5.33757, 14.8488>, <-0.00958908, 0.00235048, -0.00247279> }
        smooth_triangle {<-9.32315, 5.43704, 14.8621>, <-0.0107859, -5.63218e-05, -0.00346476>,
                         <-9.34279, 5.53572, 14.8657>, <-0.0105951, -0.00264054, -0.00370817>,
                         <-9.3207, 5.54214, 14.75>, <-0.0111603, -0.00280461, 0.00074963> }
        smooth_triangle {<-9.3207, 5.54214, 14.75>, <-0.0111413, -0.00263474, 3.41089e-06>,
                         <-9.30174, 5.44325, 14.75>, <-0.0112467, -0.000685651, 1.78634e-05>,
                         <-9.32315, 5.43704, 14.8621>, <-0.0108605, -0.000573519, -0.00315738> }
        smooth_triangle {<-9.34279, 5.53572, 14.8657>, <-0.0105951, -0.00264054, -0.00370817>,
                         <-9.37798, 5.63008, 14.8626>, <-0.00956187, -0.004231, -0.00356046>,
                         <-9.35647, 5.63633, 14.75>, <-0.0101129, -0.00439096, 0.000676063> }
        smooth_triangle {<-9.35647, 5.63633, 14.75>, <-0.0103085, -0.00432788, -7.06523e-05>,
                         <-9.3207, 5.54214, 14.75>, <-0.011094, -0.00313812, -1.54773e-05>,
                         <-9.34279, 5.53572, 14.8657>, <-0.0106702, -0.00301506, -0.00335883> }
        smooth_triangle {<-9.37798, 5.63008, 14.8626>, <-0.00956187, -0.004231, -0.00356046>,
                         <-9.42559, 5.7185, 14.8538>, <-0.00810775, -0.0050298, -0.00317985>,
                         <-9.40575, 5.72426, 14.75>, <-0.00860467, -0.00517407, 0.000578525> }
        smooth_triangle {<-9.40575, 5.72426, 14.75>, <-0.00892829, -0.00526742, -0.000115767>,
                         <-9.35647, 5.63633, 14.75>, <-0.0100594, -0.00468009, -4.26131e-05>,
                         <-9.37798, 5.63008, 14.8626>, <-0.00964619, -0.00456012, -0.00322001> }
        smooth_triangle {<-9.42559, 5.7185, 14.8538>, <-0.00810775, -0.0050298, -0.00317985>,
                         <-9.48106, 5.8018, 14.8414>, <-0.00665083, -0.00499651, -0.00270462>,
                         <-9.4636, 5.80687, 14.75>, <-0.00707605, -0.00511996, 0.000478598> }
        smooth_triangle {<-9.4636, 5.80687, 14.75>, <-0.00745169, -0.0053418, -0.000134023>,
                         <-9.40575, 5.72426, 14.75>, <-0.00859815, -0.00538239, -5.90775e-05>,
                         <-9.42559, 5.7185, 14.8538>, <-0.00822546, -0.00527419, -0.00287786> }
        smooth_triangle {<-9.48106, 5.8018, 14.8414>, <-0.00665083, -0.00499651, -0.00270462>,
                         <-9.54041, 5.88209, 14.8271>, <-0.00536764, -0.00439747, -0.00222643>,
                         <-9.52569, 5.88637, 14.75>, <-0.00571942, -0.00449959, 0.000384897> }
        smooth_triangle {<-9.52569, 5.88637, 14.75>, <-0.00610625, -0.00479347, -0.000137042>,
                         <-9.4636, 5.80687, 14.75>, <-0.00712372, -0.00525874, -6.67665e-05>,
                         <-9.48106, 5.8018, 14.8414>, <-0.0068048, -0.00516615, -0.00245418> }
        smooth_triangle {<-9.54041, 5.88209, 14.8271>, <-0.00536764, -0.00439747, -0.00222643>,
                         <-9.60066, 5.96164, 14.8123>, <-0.00426917, -0.00352623, -0.00178087>,
                         <-9.58876, 5.9651, 14.75>, <-0.00455208, -0.00360836, 0.000299881> }
        smooth_triangle {<-9.58876, 5.9651, 14.75>, <-0.00493097, -0.00392148, -0.000132252>,
                         <-9.52569, 5.88637, 14.75>, <-0.00580648, -0.0045899, -6.84901e-05>,
                         <-9.54041, 5.88209, 14.8271>, <-0.00554265, -0.0045133, -0.00202698> }
        smooth_triangle {<-9.60066, 5.96164, 14.8123>, <-0.00426917, -0.00352623, -0.00178087>,
                         <-9.65956, 6.0423, 14.7982>, <-0.00330097, -0.00260775, -0.00137495>,
                         <-9.65036, 6.04498, 14.75>, <-0.00352139, -0.00267175, 0.000221083> }
        smooth_triangle {<-9.65036, 6.04498, 14.75>, <-0.00388496, -0.00296316, -0.000125012>,
                         <-9.58876, 5.9651, 14.75>, <-0.00465798, -0.00366563, -6.59137e-05>,
                         <-9.60066, 5.96164, 14.8123>, <-0.0044458, -0.00360403, -0.00162648> }
        smooth_triangle {<-9.65956, 6.0423, 14.7982>, <-0.00330097, -0.00260775, -0.00137495>,
                         <-9.71629, 6.12469, 14.7851>, <-0.00240479, -0.00177791, -0.00100014>,
                         <-9.70958, 6.12664, 14.75>, <-0.00256729, -0.00182509, 0.000149467> }
        smooth_triangle {<-9.70958, 6.12664, 14.75>, <-0.00290894, -0.00208197, -0.000115318>,
                         <-9.65036, 6.04498, 14.75>, <-0.00362451, -0.00271696, -6.16061e-05>,
                         <-9.65956, 6.0423, 14.7982>, <-0.0034592, -0.00266897, -0.00125863> }
        smooth_triangle {<-9.71629, 6.12469, 14.7851>, <-0.00240479, -0.00177791, -0.00100014>,
                         <-9.77016, 6.20916, 14.7734>, <-0.00159226, -0.00108037, -0.00066301>,
                         <-9.76568, 6.21046, 14.75>, <-0.00170212, -0.00111226, 8.78968e-05> }
        smooth_triangle {<-9.76568, 6.21046, 14.75>, <-0.00201262, -0.00132685, -0.000102001>,
                         <-9.70958, 6.12664, 14.75>, <-0.0026615, -0.00186147, -5.58229e-05>,
                         <-9.71629, 6.12469, 14.7851>, <-0.00253963, -0.00182609, -0.000918028> }
        smooth_triangle {<-9.77016, 6.20916, 14.7734>, <-0.00159226, -0.00108037, -0.00066301>,
                         <-9.8202, 6.29618, 14.7636>, <-0.000893267, -0.000543405, -0.000376566>,
                         <-9.8176, 6.29694, 14.75>, <-0.000957872, -0.000562161, 3.83606e-05> }
        smooth_triangle {<-9.8176, 6.29694, 14.75>, <-0.00122529, -0.000725936, -8.49338e-05>,
                         <-9.76568, 6.21046, 14.75>, <-0.00178347, -0.00113851, -4.77817e-05>,
                         <-9.77016, 6.20916, 14.7734>, <-0.00170108, -0.00111459, -0.000610962> }
        smooth_triangle {<-9.8202, 6.29618, 14.7636>, <-0.000893267, -0.000543405, -0.000376566>,
                         <-9.86569, 6.38587, 14.7559>, <-0.000318428, -0.000174329, -0.000147217>,
                         <-9.86457, 6.38619, 14.75>, <-0.000346624, -0.000182515, -3.85327e-07> }
        smooth_triangle {<-9.86457, 6.38619, 14.75>, <-0.000563313, -0.000296519, -6.70884e-05>,
                         <-9.8176, 6.29694, 14.75>, <-0.00102175, -0.000581254, -3.80289e-05>,
                         <-9.8202, 6.29618, 14.7636>, <-0.000973295, -0.000567186, -0.000349224> }
        smooth_triangle {<-9.86569, 6.38587, 14.7559>, <-0.000318428, -0.000174329, -0.000147217>,
                         <-9.90719, 6.47762, 14.7499>, <0.000158429, 6.93511e-05, 3.48806e-05>,
                         <-9.9072, 6.47762, 14.75>, <0.000158712, 6.94333e-05, -3.3398e-05> }
        smooth_triangle {<-9.9072, 6.47762, 14.75>, <-1.47808e-05, -1.03256e-05, -5.40711e-05>,
                         <-9.86457, 6.38619, 14.75>, <-0.000393783, -0.000199287, -2.93116e-05>,
                         <-9.86569, 6.38587, 14.7559>, <-0.000372636, -0.000193147, -0.000139435> }
        smooth_triangle {<-9.90719, 6.47762, 14.7499>, <0.000158429, 6.93511e-05, 3.48806e-05>,
                         <-9.94662, 6.57034, 14.745>, <0.000428654, 0.000192639, 0.000192761>,
                         <-9.94758, 6.57006, 14.75>, <0.000465476, 0.000203329, 2.43945e-19> }
        smooth_triangle {<-9.94758, 6.57006, 14.75>, <0.000312114, 0.000136337, 3.86693e-07>,
                         <-9.9072, 6.47762, 14.75>, <0.000120381, 5.26635e-05, -2.47584e-05>,
                         <-9.90719, 6.47762, 14.7499>, <0.000120169, 5.26019e-05, 2.64505e-05> }
        smooth_triangle {<-9.43632, 5.15655, 14.8337>, <-0.00556771, 0.00438289, -0.00275619>,
                         <-9.40215, 5.23421, 14.8882>, <-0.00595507, 0.00442394, -0.00375821>,
                         <-9.36146, 5.24603, 14.8248>, <-0.00700834, 0.00411815, -0.00175561> }
        smooth_triangle {<-9.36146, 5.24603, 14.8248>, <-0.00609961, 0.0037525, -0.00173419>,
                         <-9.41167, 5.16371, 14.7953>, <-0.00482625, 0.00341595, -0.00131889>,
                         <-9.43632, 5.15655, 14.8337>, <-0.00447055, 0.00351921, -0.00221307> }
        smooth_triangle {<-9.40215, 5.23421, 14.8882>, <-0.00595507, 0.00442394, -0.00375821>,
                         <-9.3814, 5.32197, 14.9326>, <-0.0078934, 0.00336449, -0.00565151>,
                         <-9.32764, 5.33757, 14.8488>, <-0.00948481, 0.00290247, -0.0026794> }
        smooth_triangle {<-9.32764, 5.33757, 14.8488>, <-0.00863576, 0.00295729, -0.00284089>,
                         <-9.36146, 5.24603, 14.8248>, <-0.00677841, 0.00386905, -0.00214806>,
                         <-9.40215, 5.23421, 14.8882>, <-0.00598845, 0.00409839, -0.00365001> }
        smooth_triangle {<-9.3814, 5.32197, 14.9326>, <-0.0078934, 0.00336449, -0.00565151>,
                         <-9.38413, 5.41934, 14.9571>, <-0.00875421, 0.00053352, -0.00717094>,
                         <-9.32315, 5.43704, 14.8621>, <-0.0107859, -5.63218e-05, -0.00346476> }
        smooth_triangle {<-9.32315, 5.43704, 14.8621>, <-0.0102244, 0.000230234, -0.00391778>,
                         <-9.32764, 5.33757, 14.8488>, <-0.00924859, 0.00244933, -0.00332876>,
                         <-9.3814, 5.32197, 14.9326>, <-0.00805503, 0.00279585, -0.00555785> }
        smooth_triangle {<-9.38413, 5.41934, 14.9571>, <-0.00875421, 0.00053352, -0.00717094>,
                         <-9.40572, 5.51746, 14.9637>, <-0.00843471, -0.00201332, -0.00760144>,
                         <-9.34279, 5.53572, 14.8657>, <-0.0105951, -0.00264054, -0.00370817> }
        smooth_triangle {<-9.34279, 5.53572, 14.8657>, <-0.0103067, -0.00239243, -0.00437249>,
                         <-9.32315, 5.43704, 14.8621>, <-0.0104498, -0.000454274, -0.00418993>,
                         <-9.38413, 5.41934, 14.9571>, <-0.00892602, -1.18921e-05, -0.00696956> }
        smooth_triangle {<-9.40572, 5.51746, 14.9637>, <-0.00843471, -0.00201332, -0.00760144>,
                         <-9.43922, 5.6123, 14.958>, <-0.00749586, -0.00363119, -0.00725493>,
                         <-9.37798, 5.63008, 14.8626>, <-0.00956187, -0.004231, -0.00356046> }
        smooth_triangle {<-9.37798, 5.63008, 14.8626>, <-0.00947061, -0.00408463, -0.00431549>,
                         <-9.34279, 5.53572, 14.8657>, <-0.0102456, -0.00289178, -0.00442628>,
                         <-9.40572, 5.51746, 14.9637>, <-0.00862524, -0.00242137, -0.00734623> }
        smooth_triangle {<-9.43922, 5.6123, 14.958>, <-0.00749586, -0.00363119, -0.00725493>,
                         <-9.48208, 5.7021, 14.9419>, <-0.00626742, -0.00449552, -0.00645413>,
                         <-9.42559, 5.7185, 14.8538>, <-0.00810775, -0.0050298, -0.00317985> }
        smooth_triangle {<-9.42559, 5.7185, 14.8538>, <-0.00815159, -0.00504193, -0.00395019>,
                         <-9.37798, 5.63008, 14.8626>, <-0.00924218, -0.00444282, -0.00423565>,
                         <-9.43922, 5.6123, 14.958>, <-0.00769268, -0.00399297, -0.0070065> }
        smooth_triangle {<-9.48208, 5.7021, 14.9419>, <-0.00626742, -0.00449552, -0.00645413>,
                         <-9.53078, 5.78736, 14.9189>, <-0.00508811, -0.00454281, -0.00547609>,
                         <-9.48106, 5.8018, 14.8414>, <-0.00665083, -0.00499651, -0.00270462> }
        smooth_triangle {<-9.48106, 5.8018, 14.8414>, <-0.00677043, -0.00514402, -0.00343233>,
                         <-9.42559, 5.7185, 14.8538>, <-0.00786312, -0.00516899, -0.00378875>,
                         <-9.48208, 5.7021, 14.9419>, <-0.00648287, -0.00476827, -0.00624446> }
        smooth_triangle {<-9.53078, 5.78736, 14.9189>, <-0.00508811, -0.00454281, -0.00547609>,
                         <-9.58233, 5.86992, 14.8924>, <-0.00408296, -0.00402449, -0.0044988>,
                         <-9.54041, 5.88209, 14.8271>, <-0.00536764, -0.00439747, -0.00222643> }
        smooth_triangle {<-9.54041, 5.88209, 14.8271>, <-0.00552951, -0.00462603, -0.00288215>,
                         <-9.48106, 5.8018, 14.8414>, <-0.0064919, -0.00507531, -0.0032408>,
                         <-9.53078, 5.78736, 14.9189>, <-0.00531986, -0.00473504, -0.0053194> }
        smooth_triangle {<-9.58233, 5.86992, 14.8924>, <-0.00408296, -0.00402449, -0.0044988>,
                         <-9.63454, 5.9518, 14.8651>, <-0.0032431, -0.00322834, -0.0035905>,
                         <-9.60066, 5.96164, 14.8123>, <-0.00426917, -0.00352623, -0.00178087> }
        smooth_triangle {<-9.60066, 5.96164, 14.8123>, <-0.00445627, -0.00378366, -0.00235277>,
                         <-9.54041, 5.88209, 14.8271>, <-0.00528013, -0.00443709, -0.00268693>,
                         <-9.58233, 5.86992, 14.8924>, <-0.00431662, -0.00415736, -0.00439121> }
        smooth_triangle {<-9.63454, 5.9518, 14.8651>, <-0.0032431, -0.00322834, -0.0035905>,
                         <-9.68577, 6.0347, 14.839>, <-0.00251078, -0.00237834, -0.00276166>,
                         <-9.65956, 6.0423, 14.7982>, <-0.00330097, -0.00260775, -0.00137495> }
        smooth_triangle {<-9.65956, 6.0423, 14.7982>, <-0.00350589, -0.00285311, -0.00185941>,
                         <-9.60066, 5.96164, 14.8123>, <-0.00423204, -0.00354197, -0.00216385>,
                         <-9.63454, 5.9518, 14.8651>, <-0.00346249, -0.00331855, -0.00352107> }
        smooth_triangle {<-9.68577, 6.0347, 14.839>, <-0.00251078, -0.00237834, -0.00276166>,
                         <-9.73539, 6.11914, 14.8149>, <-0.00183217, -0.00161166, -0.00199749>,
                         <-9.71629, 6.12469, 14.7851>, <-0.00240479, -0.00177791, -0.00100014> }
        smooth_triangle {<-9.71629, 6.12469, 14.7851>, <-0.00261991, -0.00199806, -0.00139774>,
                         <-9.65956, 6.0423, 14.7982>, <-0.00329204, -0.00262044, -0.00167885>,
                         <-9.68577, 6.0347, 14.839>, <-0.0026994, -0.00244838, -0.00271888> }
        smooth_triangle {<-9.73539, 6.11914, 14.8149>, <-0.00183217, -0.00161166, -0.00199749>,
                         <-9.78292, 6.20546, 14.7933>, <-0.00121479, -0.000970782, -0.00131298>,
                         <-9.77016, 6.20916, 14.7734>, <-0.00159226, -0.00108037, -0.00066301> }
        smooth_triangle {<-9.77016, 6.20916, 14.7734>, <-0.0018068, -0.0012671, -0.000975463>,
                         <-9.71629, 6.12469, 14.7851>, <-0.0024162, -0.00179025, -0.00122831>,
                         <-9.73539, 6.11914, 14.8149>, <-0.00198674, -0.00166557, -0.00197632> }
        smooth_triangle {<-9.78292, 6.20546, 14.7933>, <-0.00121479, -0.000970782, -0.00131298>,
                         <-9.82759, 6.29403, 14.7751>, <-0.00068109, -0.000481805, -0.000734164>,
                         <-9.8202, 6.29618, 14.7636>, <-0.000893267, -0.000543405, -0.000376566> }
        smooth_triangle {<-9.8202, 6.29618, 14.7636>, <-0.00109326, -0.000687605, -0.000606227>,
                         <-9.77016, 6.20916, 14.7734>, <-0.0016175, -0.00109033, -0.00082106>,
                         <-9.78292, 6.20546, 14.7933>, <-0.0013344, -0.00100814, -0.00130854> }
        smooth_triangle {<-9.82759, 6.29403, 14.7751>, <-0.00068109, -0.000481805, -0.000734164>,
                         <-9.86888, 6.38495, 14.7608>, <-0.000238417, -0.0001511, -0.000271636>,
                         <-9.86569, 6.38587, 14.7559>, <-0.000318428, -0.000174329, -0.000147217> }
        smooth_triangle {<-9.86569, 6.38587, 14.7559>, <-0.000493067, -0.000276125, -0.000300641>,
                         <-9.8202, 6.29618, 14.7636>, <-0.000924196, -0.000552932, -0.000472653>,
                         <-9.82759, 6.29403, 14.7751>, <-0.000765063, -0.000506732, -0.000740852> }
        smooth_triangle {<-9.86888, 6.38495, 14.7608>, <-0.000238417, -0.0001511, -0.000271636>,
                         <-9.90716, 6.47763, 14.7499>, <0.000133074, 6.19901e-05, 9.78489e-05>,
                         <-9.90719, 6.47762, 14.7499>, <0.000158429, 6.93511e-05, 3.48806e-05> }
        smooth_triangle {<-9.90719, 6.47762, 14.7499>, <6.33887e-06, -4.19404e-06, -5.64889e-05>,
                         <-9.86569, 6.38587, 14.7559>, <-0.000351304, -0.000186954, -0.000193062>,
                         <-9.86888, 6.38495, 14.7608>, <-0.000291296, -0.000169532, -0.000286376> }
        smooth_triangle {<-9.90716, 6.47763, 14.7499>, <0.000133074, 6.19901e-05, 9.78489e-05>,
                         <-9.94388, 6.57113, 14.7407>, <0.000323794, 0.000162195, 0.000356176>,
                         <-9.94662, 6.57034, 14.745>, <0.000428654, 0.000192639, 0.000192761> }
        smooth_triangle {<-9.94662, 6.57034, 14.745>, <0.000287282, 0.000129128, 0.000129608>,
                         <-9.90719, 6.47762, 14.7499>, <0.000119956, 5.254e-05, 2.69864e-05>,
                         <-9.90716, 6.47763, 14.7499>, <0.00010094, 4.70192e-05, 7.42126e-05> }
        smooth_triangle {<-9.47321, 5.14584, 14.8594>, <-0.00425324, 0.00476451, -0.00412494>,
                         <-9.46304, 5.21653, 14.9306>, <-0.004246, 0.00492012, -0.00518866>,
                         <-9.40215, 5.23421, 14.8882>, <-0.00595507, 0.00442394, -0.00375821> }
        smooth_triangle {<-9.40215, 5.23421, 14.8882>, <-0.00511055, 0.00403965, -0.00344347>,
                         <-9.43632, 5.15655, 14.8337>, <-0.00407235, 0.00363482, -0.00262772>,
                         <-9.47321, 5.14584, 14.8594>, <-0.00341511, 0.00382563, -0.00331209> }
        smooth_triangle {<-9.46304, 5.21653, 14.9306>, <-0.004246, 0.00492012, -0.00518866>,
                         <-9.46185, 5.29861, 14.9886>, <-0.00533086, 0.00410846, -0.00776323>,
                         <-9.3814, 5.32197, 14.9326>, <-0.0078934, 0.00336449, -0.00565151> }
        smooth_triangle {<-9.3814, 5.32197, 14.9326>, <-0.00704572, 0.00341891, -0.00548283>,
                         <-9.40215, 5.23421, 14.8882>, <-0.00559197, 0.0042135, -0.00406286>,
                         <-9.46304, 5.21653, 14.9306>, <-0.00431017, 0.00458563, -0.00513569> }
        smooth_triangle {<-9.46185, 5.29861, 14.9886>, <-0.00533086, 0.00410846, -0.00776323>,
                         <-9.47539, 5.39284, 15.0206>, <-0.00551513, 0.0014739, -0.00978541>,
                         <-9.38413, 5.41934, 14.9571>, <-0.00875421, 0.00053352, -0.00717094> }
        smooth_triangle {<-9.38413, 5.41934, 14.9571>, <-0.00807148, 0.000855272, -0.00735255>,
                         <-9.3814, 5.32197, 14.9326>, <-0.00742588, 0.0029785, -0.00621298>,
                         <-9.46185, 5.29861, 14.9886>, <-0.00550397, 0.00353648, -0.00779677> }
        smooth_triangle {<-9.47539, 5.39284, 15.0206>, <-0.00551513, 0.0014739, -0.00978541>,
                         <-9.4999, 5.49011, 15.0293>, <-0.00500794, -0.00101845, -0.0103375>,
                         <-9.40572, 5.51746, 14.9637>, <-0.00843471, -0.00201332, -0.00760144> }
        smooth_triangle {<-9.40572, 5.51746, 14.9637>, <-0.00792745, -0.00170168, -0.00808272>,
                         <-9.38413, 5.41934, 14.9571>, <-0.00816708, 0.000208445, -0.00775984>,
                         <-9.47539, 5.39284, 15.0206>, <-0.00573777, 0.000913728, -0.0097207> }
        smooth_triangle {<-9.4999, 5.49011, 15.0293>, <-0.00500794, -0.00101845, -0.0103375>,
                         <-9.53087, 5.5857, 15.0218>, <-0.00422936, -0.00268286, -0.00984491>,
                         <-9.43922, 5.6123, 14.958>, <-0.00749586, -0.00363119, -0.00725493> }
        smooth_triangle {<-9.43922, 5.6123, 14.958>, <-0.00713651, -0.00340699, -0.00790334>,
                         <-9.40572, 5.51746, 14.9637>, <-0.00784065, -0.00219358, -0.00816322>,
                         <-9.4999, 5.49011, 15.0293>, <-0.00527057, -0.00144743, -0.0102152> }
        smooth_triangle {<-9.53087, 5.5857, 15.0218>, <-0.00422936, -0.00268286, -0.00984491>,
                         <-9.56663, 5.67755, 15.0007>, <-0.00336385, -0.00365255, -0.00874582>,
                         <-9.48208, 5.7021, 14.9419>, <-0.00626742, -0.00449552, -0.00645413> }
        smooth_triangle {<-9.48208, 5.7021, 14.9419>, <-0.00602483, -0.00442448, -0.00718323>,
                         <-9.43922, 5.6123, 14.958>, <-0.00694616, -0.00377624, -0.00778384>,
                         <-9.53087, 5.5857, 15.0218>, <-0.00449629, -0.00306499, -0.00972632> }
        smooth_triangle {<-9.56663, 5.67755, 15.0007>, <-0.00336385, -0.00365255, -0.00874582>,
                         <-9.6052, 5.76576, 14.9707>, <-0.00262581, -0.00382795, -0.00741387>,
                         <-9.53078, 5.78736, 14.9189>, <-0.00508811, -0.00454281, -0.00547609> }
        smooth_triangle {<-9.53078, 5.78736, 14.9189>, <-0.00492887, -0.00460937, -0.0062081>,
                         <-9.48208, 5.7021, 14.9419>, <-0.00581335, -0.0045739, -0.00694163>,
                         <-9.56663, 5.67755, 15.0007>, <-0.00363568, -0.00394167, -0.0086604> }
        smooth_triangle {<-9.6052, 5.76576, 14.9707>, <-0.00262581, -0.00382795, -0.00741387>,
                         <-9.64508, 5.8517, 14.9361>, <-0.00206095, -0.00343746, -0.00608626>,
                         <-9.58233, 5.86992, 14.8924>, <-0.00408296, -0.00402449, -0.0044988> }
        smooth_triangle {<-9.58233, 5.86992, 14.8924>, <-0.00398782, -0.00417844, -0.00518848>,
                         <-9.53078, 5.78736, 14.9189>, <-0.00474168, -0.00456718, -0.00592145>,
                         <-9.6052, 5.76576, 14.9707>, <-0.00289495, -0.00403103, -0.00737479> }
        smooth_triangle {<-9.64508, 5.8517, 14.9361>, <-0.00206095, -0.00343746, -0.00608626>,
                         <-9.68525, 5.93708, 14.9004>, <-0.00163009, -0.00276005, -0.00485351>,
                         <-9.63454, 5.9518, 14.8651>, <-0.0032431, -0.00322834, -0.0035905> }
        smooth_triangle {<-9.63454, 5.9518, 14.8651>, <-0.00320165, -0.00341942, -0.00421509>,
                         <-9.58233, 5.86992, 14.8924>, <-0.00383154, -0.00401653, -0.00489631>,
                         <-9.64508, 5.8517, 14.9361>, <-0.00231503, -0.00357626, -0.00608692> }
        smooth_triangle {<-9.68525, 5.93708, 14.9004>, <-0.00163009, -0.00276005, -0.00485351>,
                         <-9.72499, 6.02331, 14.8663>, <-0.0012711, -0.00201844, -0.00372793>,
                         <-9.68577, 6.0347, 14.839>, <-0.00251078, -0.00237834, -0.00276166> }
        smooth_triangle {<-9.68577, 6.0347, 14.839>, <-0.00251826, -0.00256638, -0.00331073>,
                         <-9.63454, 5.9518, 14.8651>, <-0.00306751, -0.00320388, -0.00393236>,
                         <-9.68525, 5.93708, 14.9004>, <-0.00185775, -0.00285266, -0.00487962> }
        smooth_triangle {<-9.72499, 6.02331, 14.8663>, <-0.0012711, -0.00201844, -0.00372793>,
                         <-9.76399, 6.11084, 14.8348>, <-0.000936603, -0.00135166, -0.00269073>,
                         <-9.73539, 6.11914, 14.8149>, <-0.00183217, -0.00161166, -0.00199749> }
        smooth_triangle {<-9.73539, 6.11914, 14.8149>, <-0.00188158, -0.0017837, -0.00246736>,
                         <-9.68577, 6.0347, 14.839>, <-0.00239053, -0.00235871, -0.0030405>,
                         <-9.72499, 6.02331, 14.8663>, <-0.00146078, -0.00208878, -0.0037652> }
        smooth_triangle {<-9.76399, 6.11084, 14.8348>, <-0.000936603, -0.00135166, -0.00269073>,
                         <-9.80201, 6.19992, 14.8066>, <-0.000627192, -0.000800188, -0.00176306>,
                         <-9.78292, 6.20546, 14.7933>, <-0.00121479, -0.000970782, -0.00131298> }
        smooth_triangle {<-9.78292, 6.20546, 14.7933>, <-0.00129564, -0.0011187, -0.00170042>,
                         <-9.73539, 6.11914, 14.8149>, <-0.00175867, -0.00159936, -0.0022138>,
                         <-9.76399, 6.11084, 14.8348>, <-0.001087, -0.00140436, -0.00273373> }
        smooth_triangle {<-9.80201, 6.19992, 14.8066>, <-0.000627192, -0.000800188, -0.00176306>,
                         <-9.83866, 6.29082, 14.7828>, <-0.000353644, -0.00038674, -0.000979992>,
                         <-9.82759, 6.29403, 14.7751>, <-0.00068109, -0.000481805, -0.000734164> }
        smooth_triangle {<-9.82759, 6.29403, 14.7751>, <-0.000779701, -0.000596572, -0.00103523>,
                         <-9.78292, 6.20546, 14.7933>, <-0.00117998, -0.000963305, -0.00146934>,
                         <-9.80201, 6.19992, 14.8066>, <-0.000739278, -0.00083536, -0.0018069> }
        smooth_triangle {<-9.83866, 6.29082, 14.7828>, <-0.000353644, -0.00038674, -0.000979992>,
                         <-9.87364, 6.38356, 14.7641>, <-0.000118771, -0.000116364, -0.000354701>,
                         <-9.86888, 6.38495, 14.7608>, <-0.000238417, -0.0001511, -0.000271636> }
        smooth_triangle {<-9.86888, 6.38495, 14.7608>, <-0.000342336, -0.000232365, -0.000488424>,
                         <-9.82759, 6.29403, 14.7751>, <-0.000674341, -0.000480393, -0.00083532>,
                         <-9.83866, 6.29082, 14.7828>, <-0.000428756, -0.000409095, -0.00101969> }
        smooth_triangle {<-9.87364, 6.38356, 14.7641>, <-0.000118771, -0.000116364, -0.000354701>,
                         <-9.90711, 6.47764, 14.7499>, <8.65082e-05, 4.84709e-05, 0.000145921>,
                         <-9.90716, 6.47763, 14.7499>, <0.000133074, 6.19901e-05, 9.78489e-05> }
        smooth_triangle {<-9.90716, 6.47763, 14.7499>, <2.67395e-05, 1.72872e-06, -5.03069e-05>,
                         <-9.86888, 6.38495, 14.7608>, <-0.000251879, -0.000158089, -0.000327421>,
                         <-9.87364, 6.38356, 14.7641>, <-0.000162145, -0.000132037, -0.000389719> }
        smooth_triangle {<-9.90711, 6.47764, 14.7499>, <8.65082e-05, 4.84709e-05, 0.000145921>,
                         <-9.93978, 6.57232, 14.7378>, <0.000166859, 0.000116634, 0.000465366>,
                         <-9.94388, 6.57113, 14.7407>, <0.000323794, 0.000162195, 0.000356176> }
        smooth_triangle {<-9.94388, 6.57113, 14.7407>, <0.00021685, 0.00010868, 0.000239099>,
                         <-9.90716, 6.47763, 14.7499>, <0.000100546, 4.69049e-05, 7.46227e-05>,
                         <-9.90711, 6.47764, 14.7499>, <6.56214e-05, 3.67655e-05, 0.000110676> }
        smooth_triangle {<-9.51673, 5.13321, 14.8684>, <-0.00253581, 0.00526312, -0.00486569>,
                         <-9.53487, 5.19568, 14.9454>, <-0.00214132, 0.00553116, -0.00582918>,
                         <-9.46304, 5.21653, 14.9306>, <-0.004246, 0.00492012, -0.00518866> }
        smooth_triangle {<-9.46304, 5.21653, 14.9306>, <-0.0035686, 0.00448731, -0.00462851>,
                         <-9.47321, 5.14584, 14.8594>, <-0.00289483, 0.00397668, -0.0035365>,
                         <-9.51673, 5.13321, 14.8684>, <-0.00203611, 0.00422599, -0.00390688> }
        smooth_triangle {<-9.53487, 5.19568, 14.9454>, <-0.00214132, 0.00553116, -0.00582918>,
                         <-9.55675, 5.27106, 15.0082>, <-0.0021873, 0.0050211, -0.00869307>,
                         <-9.46185, 5.29861, 14.9886>, <-0.00533086, 0.00410846, -0.00776323> }
        smooth_triangle {<-9.46185, 5.29861, 14.9886>, <-0.00460579, 0.00412728, -0.00729006>,
                         <-9.46304, 5.21653, 14.9306>, <-0.00379214, 0.00473603, -0.00535913>,
                         <-9.53487, 5.19568, 14.9454>, <-0.00221363, 0.0051943, -0.00583952> }
        smooth_triangle {<-9.55675, 5.27106, 15.0082>, <-0.0021873, 0.0050211, -0.00869307>,
                         <-9.58304, 5.36159, 15.0429>, <-0.00156177, 0.00262165, -0.0109101>,
                         <-9.47539, 5.39284, 15.0206>, <-0.00551513, 0.0014739, -0.00978541> }
        smooth_triangle {<-9.47539, 5.39284, 15.0206>, <-0.00482015, 0.00179921, -0.00966796>,
                         <-9.46185, 5.29861, 14.9886>, <-0.00468194, 0.00377513, -0.00815132>,
                         <-9.55675, 5.27106, 15.0082>, <-0.00232427, 0.00445961, -0.0088487> }
        smooth_triangle {<-9.58304, 5.36159, 15.0429>, <-0.00156177, 0.00262165, -0.0109101>,
                         <-9.61099, 5.45786, 15.0523>, <-0.000836502, 0.000192609, -0.0114997>,
                         <-9.4999, 5.49011, 15.0293>, <-0.00500794, -0.00101845, -0.0103375> }
        smooth_triangle {<-9.4999, 5.49011, 15.0293>, <-0.00436576, -0.000667648, -0.0105624>,
                         <-9.47539, 5.39284, 15.0206>, <-0.00474616, 0.00120161, -0.0101484>,
                         <-9.58304, 5.36159, 15.0429>, <-0.00178114, 0.00206242, -0.0109919> }
        smooth_triangle {<-9.61099, 5.45786, 15.0523>, <-0.000836502, 0.000192609, -0.0114997>,
                         <-9.63899, 5.55431, 15.0442>, <-0.000259679, -0.00153037, -0.0109361>,
                         <-9.53087, 5.5857, 15.0218>, <-0.00422936, -0.00268286, -0.00984491> }
        smooth_triangle {<-9.53087, 5.5857, 15.0218>, <-0.00366152, -0.00239812, -0.010288>,
                         <-9.4999, 5.49011, 15.0293>, <-0.00424545, -0.00114982, -0.0106574>,
                         <-9.61099, 5.45786, 15.0523>, <-0.00111687, -0.000241523, -0.0115291> }
        smooth_triangle {<-9.63899, 5.55431, 15.0442>, <-0.000259679, -0.00153037, -0.0109361>,
                         <-9.66636, 5.6486, 15.0214>, <0.000160911, -0.00262923, -0.00970604>,
                         <-9.56663, 5.67755, 15.0007>, <-0.00336385, -0.00365255, -0.00874582> }
        smooth_triangle {<-9.56663, 5.67755, 15.0007>, <-0.00287179, -0.00350908, -0.0093227>,
                         <-9.53087, 5.5857, 15.0218>, <-0.00352093, -0.00278182, -0.010147>,
                         <-9.63899, 5.55431, 15.0442>, <-0.000543662, -0.00191745, -0.0109654> }
        smooth_triangle {<-9.66636, 5.6486, 15.0214>, <0.000160911, -0.00262923, -0.00970604>,
                         <-9.69298, 5.74027, 14.9889>, <0.000361213, -0.00296075, -0.00822296>,
                         <-9.6052, 5.76576, 14.9707>, <-0.00262581, -0.00382795, -0.00741387> }
        smooth_triangle {<-9.6052, 5.76576, 14.9707>, <-0.00220737, -0.00381926, -0.00803874>,
                         <-9.56663, 5.67755, 15.0007>, <-0.0027609, -0.0036877, -0.0090377>,
                         <-9.66636, 5.6486, 15.0214>, <-0.000117333, -0.00292022, -0.00975786> }
        smooth_triangle {<-9.69298, 5.74027, 14.9889>, <0.000361213, -0.00296075, -0.00822296>,
                         <-9.71909, 5.83022, 14.9514>, <0.000390551, -0.00272573, -0.00674715>,
                         <-9.64508, 5.8517, 14.9361>, <-0.00206095, -0.00343746, -0.00608626> }
        smooth_triangle {<-9.64508, 5.8517, 14.9361>, <-0.00171588, -0.00351885, -0.00670491>,
                         <-9.6052, 5.76576, 14.9707>, <-0.00213953, -0.00381172, -0.00770062>,
                         <-9.69298, 5.74027, 14.9889>, <0.000100738, -0.00316132, -0.00830743> }
        smooth_triangle {<-9.71909, 5.83022, 14.9514>, <0.000390551, -0.00272573, -0.00674715>,
                         <-9.74507, 5.91971, 14.9128>, <0.000324309, -0.00219264, -0.00537762>,
                         <-9.68525, 5.93708, 14.9004>, <-0.00163009, -0.00276005, -0.00485351> }
        smooth_triangle {<-9.68525, 5.93708, 14.9004>, <-0.00135811, -0.0028842, -0.00543571>,
                         <-9.64508, 5.8517, 14.9361>, <-0.00168125, -0.00339226, -0.00636028>,
                         <-9.71909, 5.83022, 14.9514>, <0.000157372, -0.00285846, -0.00685594> }
        smooth_triangle {<-9.74507, 5.91971, 14.9128>, <0.000324309, -0.00219264, -0.00537762>,
                         <-9.77125, 6.00988, 14.8759>, <0.000229319, -0.00158283, -0.00412666>,
                         <-9.72499, 6.02331, 14.8663>, <-0.0012711, -0.00201844, -0.00372793> }
        smooth_triangle {<-9.72499, 6.02331, 14.8663>, <-0.00107244, -0.00214663, -0.00425802>,
                         <-9.68525, 5.93708, 14.9004>, <-0.00134168, -0.00270283, -0.0051022>,
                         <-9.74507, 5.91971, 14.9128>, <0.000124115, -0.00227728, -0.00549528> }
        smooth_triangle {<-9.77125, 6.00988, 14.8759>, <0.000229319, -0.00158283, -0.00412666>,
                         <-9.79772, 6.10105, 14.8418>, <0.000145566, -0.00103748, -0.00297434>,
                         <-9.76399, 6.11084, 14.8348>, <-0.000936603, -0.00135166, -0.00269073> }
        smooth_triangle {<-9.76399, 6.11084, 14.8348>, <-0.000806352, -0.00147154, -0.00316136>,
                         <-9.72499, 6.02331, 14.8663>, <-0.00105723, -0.00197162, -0.00393926>,
                         <-9.77125, 6.00988, 14.8759>, <6.80895e-05, -0.00164492, -0.00423831> }
        smooth_triangle {<-9.79772, 6.10105, 14.8418>, <0.000145566, -0.00103748, -0.00297434>,
                         <-9.82452, 6.19338, 14.8113>, <8.10875e-05, -0.000594559, -0.00194473>,
                         <-9.80201, 6.19992, 14.8066>, <-0.000627192, -0.000800188, -0.00176306> }
        smooth_triangle {<-9.80201, 6.19992, 14.8066>, <-0.000556964, -0.000904243, -0.0021665>,
                         <-9.76399, 6.11084, 14.8348>, <-0.000789022, -0.00131785, -0.00286226>,
                         <-9.79772, 6.10105, 14.8418>, <2.26047e-05, -0.00108221, -0.00307496> }
        smooth_triangle {<-9.82452, 6.19338, 14.8113>, <8.10875e-05, -0.000594559, -0.00194473>,
                         <-9.85171, 6.28703, 14.7855>, <3.92213e-05, -0.000272683, -0.00107663>,
                         <-9.83866, 6.29082, 14.7828>, <-0.000353644, -0.00038674, -0.000979992> }
        smooth_triangle {<-9.83866, 6.29082, 14.7828>, <-0.000332349, -0.000466696, -0.00130662>,
                         <-9.80201, 6.19992, 14.8066>, <-0.000537511, -0.000776782, -0.00189393>,
                         <-9.82452, 6.19338, 14.8113>, <-6.30073e-06, -0.00062256, -0.00203018> }
        smooth_triangle {<-9.85171, 6.28703, 14.7855>, <3.92213e-05, -0.000272683, -0.00107663>,
                         <-9.87927, 6.38193, 14.7653>, <2.22943e-05, -7.54097e-05, -0.000383766>,
                         <-9.87364, 6.38356, 14.7641>, <-0.000118771, -0.000116364, -0.000354701> }
        smooth_triangle {<-9.87364, 6.38356, 14.7641>, <-0.000134067, -0.0001719, -0.000601849>,
                         <-9.83866, 6.29082, 14.7828>, <-0.000310221, -0.000374681, -0.00107082>,
                         <-9.85171, 6.28703, 14.7855>, <-1.55727e-05, -0.000289138, -0.00114329> }
        smooth_triangle {<-9.87927, 6.38193, 14.7653>, <2.22943e-05, -7.54097e-05, -0.000383766>,
                         <-9.90706, 6.47766, 14.7498>, <2.582e-05, 3.08518e-05, 0.000171777>,
                         <-9.90711, 6.47764, 14.7499>, <8.65082e-05, 4.84709e-05, 0.000145921> }
        smooth_triangle {<-9.90711, 6.47764, 14.7499>, <4.33153e-05, 6.54103e-06, -3.6466e-05>,
                         <-9.87364, 6.38356, 14.7641>, <-0.000110644, -0.000117085, -0.000411932>,
                         <-9.87927, 6.38193, 14.7653>, <-4.84509e-06, -8.63694e-05, -0.000433731> }
        smooth_triangle {<-9.90706, 6.47766, 14.7498>, <2.582e-05, 3.08518e-05, 0.000171777>,
                         <-9.93495, 6.57373, 14.7368>, <-1.82584e-05, 6.28901e-05, 0.000503709>,
                         <-9.93978, 6.57232, 14.7378>, <0.000166859, 0.000116634, 0.000465366> }
        smooth_triangle {<-9.93978, 6.57232, 14.7378>, <0.00011154, 7.81064e-05, 0.000312188>,
                         <-9.90711, 6.47764, 14.7499>, <6.51068e-05, 3.66161e-05, 0.000110898>,
                         <-9.90706, 6.47766, 14.7498>, <1.95907e-05, 2.34018e-05, 0.000130291> }
        smooth_triangle {<-9.56025, 5.12057, 14.8594>, <-0.000676873, 0.00580281, -0.00486569>,
                         <-9.6067, 5.17483, 14.9306>, <3.855e-05, 0.00616402, -0.00558226>,
                         <-9.53487, 5.19568, 14.9454>, <-0.00214132, 0.00553116, -0.00582918> }
        smooth_triangle {<-9.53487, 5.19568, 14.9454>, <-0.00170851, 0.00502733, -0.0051089>,
                         <-9.51673, 5.13321, 14.8684>, <-0.00147296, 0.00438948, -0.00390688>,
                         <-9.56025, 5.12057, 14.8594>, <-0.000543491, 0.00465933, -0.00390688> }
        smooth_triangle {<-9.6067, 5.17483, 14.9306>, <3.855e-05, 0.00616402, -0.00558226>,
                         <-9.65166, 5.2435, 14.9886>, <0.0010587, 0.00596349, -0.00829947>,
                         <-9.55675, 5.27106, 15.0082>, <-0.0021873, 0.0050211, -0.00869307> }
        smooth_triangle {<-9.55675, 5.27106, 15.0082>, <-0.00168741, 0.00497455, -0.00798744>,
                         <-9.53487, 5.19568, 14.9454>, <-0.00165292, 0.00535709, -0.00583952>,
                         <-9.6067, 5.17483, 14.9306>, <-1.80215e-05, 0.00583174, -0.00565433> }
        smooth_triangle {<-9.65166, 5.2435, 14.9886>, <0.0010587, 0.00596349, -0.00829947>,
                         <-9.69069, 5.33033, 15.0206>, <0.00250401, 0.00380203, -0.0103739>,
                         <-9.58304, 5.36159, 15.0429>, <-0.00156177, 0.00262165, -0.0109101> }
        smooth_triangle {<-9.58304, 5.36159, 15.0429>, <-0.000965368, 0.00291833, -0.0105115>,
                         <-9.55675, 5.27106, 15.0082>, <-0.00143451, 0.00471793, -0.0088487>,
                         <-9.65166, 5.2435, 14.9886>, <0.000999983, 0.00542472, -0.0085535> }
        smooth_triangle {<-9.69069, 5.33033, 15.0206>, <0.00250401, 0.00380203, -0.0103739>,
                         <-9.72208, 5.42561, 15.0293>, <0.00344453, 0.00143549, -0.0109112>,
                         <-9.61099, 5.45786, 15.0523>, <-0.000836502, 0.000192609, -0.0114997> }
        smooth_triangle {<-9.61099, 5.45786, 15.0523>, <-0.000163882, 0.000552251, -0.0114341>,
                         <-9.58304, 5.36159, 15.0429>, <-0.000707834, 0.00237403, -0.0109919>,
                         <-9.69069, 5.33033, 15.0206>, <0.0023415, 0.00325932, -0.0105898> }
        smooth_triangle {<-9.72208, 5.42561, 15.0293>, <0.00344453, 0.00143549, -0.0109112>,
                         <-9.7471, 5.52292, 15.0218>, <0.00380885, -0.000349185, -0.0103623>,
                         <-9.63899, 5.55431, 15.0442>, <-0.000259679, -0.00153037, -0.0109361> }
        smooth_triangle {<-9.63899, 5.55431, 15.0442>, <0.00042533, -0.00121162, -0.0111064>,
                         <-9.61099, 5.45786, 15.0523>, <-7.28757e-06, 8.06136e-05, -0.0115291>,
                         <-9.72208, 5.42561, 15.0293>, <0.00320349, 0.00101277, -0.0110877> }
        smooth_triangle {<-9.7471, 5.52292, 15.0218>, <0.00380885, -0.000349185, -0.0103623>,
                         <-9.76609, 5.61964, 15.0007>, <0.00377026, -0.00158136, -0.0091886>,
                         <-9.66636, 5.6486, 15.0214>, <0.000160911, -0.00262923, -0.00970604> }
        smooth_triangle {<-9.66636, 5.6486, 15.0214>, <0.000827509, -0.0024351, -0.0100429>,
                         <-9.63899, 5.55431, 15.0442>, <0.000512067, -0.00161095, -0.0109654>,
                         <-9.7471, 5.52292, 15.0218>, <0.00356346, -0.000725062, -0.0105351> }
        smooth_triangle {<-9.76609, 5.61964, 15.0007>, <0.00377026, -0.00158136, -0.0091886>,
                         <-9.78076, 5.71479, 14.9707>, <0.00341821, -0.00207324, -0.00778017>,
                         <-9.69298, 5.74027, 14.9889>, <0.000361213, -0.00296075, -0.00822296> }
        smooth_triangle {<-9.69298, 5.74027, 14.9889>, <0.00097974, -0.00289397, -0.00864555>,
                         <-9.66636, 5.6486, 15.0214>, <0.000829514, -0.00264533, -0.00975786>,
                         <-9.76609, 5.61964, 15.0007>, <0.00353652, -0.00185942, -0.00936979> }
        smooth_triangle {<-9.78076, 5.71479, 14.9707>, <0.00341821, -0.00207324, -0.00778017>,
                         <-9.7931, 5.80873, 14.9361>, <0.00289833, -0.00199767, -0.00638085>,
                         <-9.71909, 5.83022, 14.9514>, <0.000390551, -0.00272573, -0.00674715> }
        smooth_triangle {<-9.71909, 5.83022, 14.9514>, <0.000940409, -0.00274767, -0.00720058>,
                         <-9.69298, 5.74027, 14.9889>, <0.000918405, -0.00292393, -0.00830743>,
                         <-9.78076, 5.71479, 14.9707>, <0.00321115, -0.0022583, -0.00797534> }
        smooth_triangle {<-9.7931, 5.80873, 14.9361>, <0.00289833, -0.00199767, -0.00638085>,
                         <-9.80489, 5.90235, 14.9004>, <0.00232255, -0.00161251, -0.00508303>,
                         <-9.74507, 5.91971, 14.9128>, <0.000324309, -0.00219264, -0.00537762> }
        smooth_triangle {<-9.74507, 5.91971, 14.9128>, <0.00079369, -0.00225948, -0.00582879>,
                         <-9.71909, 5.83022, 14.9514>, <0.000843372, -0.0026593, -0.00685594>,
                         <-9.7931, 5.80873, 14.9361>, <0.0027242, -0.00211325, -0.00658122> }
        smooth_triangle {<-9.80489, 5.90235, 14.9004>, <0.00232255, -0.00161251, -0.00508303>,
                         <-9.81751, 5.99645, 14.8663>, <0.00176207, -0.00113784, -0.00389714>,
                         <-9.77125, 6.00988, 14.8759>, <0.000229319, -0.00158283, -0.00412666> }
        smooth_triangle {<-9.77125, 6.00988, 14.8759>, <0.000611456, -0.00165775, -0.00455707>,
                         <-9.74507, 5.91971, 14.9128>, <0.000682698, -0.00211511, -0.00549528>,
                         <-9.80489, 5.90235, 14.9004>, <0.00218138, -0.00168001, -0.00527434> }
        smooth_triangle {<-9.81751, 5.99645, 14.8663>, <0.00176207, -0.00113784, -0.00389714>,
                         <-9.83145, 6.09126, 14.8348>, <0.00124959, -0.000716962, -0.00280513>,
                         <-9.79772, 6.10105, 14.8418>, <0.000145566, -0.00103748, -0.00297434> }
        smooth_triangle {<-9.79772, 6.10105, 14.8418>, <0.000442075, -0.0011091, -0.00337406>,
                         <-9.77125, 6.00988, 14.8759>, <0.00050489, -0.00151811, -0.00423831>,
                         <-9.81751, 5.99645, 14.8663>, <0.00165445, -0.00118436, -0.00406617> }
        smooth_triangle {<-9.83145, 6.09126, 14.8348>, <0.00124959, -0.000716962, -0.00280513>,
                         <-9.84704, 6.18684, 14.8066>, <0.000802218, -0.000385199, -0.00183033>,
                         <-9.82452, 6.19338, 14.8113>, <8.10875e-05, -0.000594559, -0.00194473> }
        smooth_triangle {<-9.82452, 6.19338, 14.8113>, <0.000296775, -0.000656383, -0.00230276>,
                         <-9.79772, 6.10105, 14.8418>, <0.000345134, -0.000988577, -0.00307496>,
                         <-9.83145, 6.09126, 14.8348>, <0.00117315, -0.000748186, -0.00294805> }
        smooth_triangle {<-9.84704, 6.18684, 14.8066>, <0.000802218, -0.000385199, -0.00183033>,
                         <-9.86477, 6.28324, 14.7828>, <0.000437695, -0.000156997, -0.00100935>,
                         <-9.85171, 6.28703, 14.7855>, <3.92213e-05, -0.000272683, -0.00107663> }
        smooth_triangle {<-9.85171, 6.28703, 14.7855>, <0.00018069, -0.000317749, -0.0013791>,
                         <-9.82452, 6.19338, 14.8113>, <0.00021209, -0.000559157, -0.00203018>,
                         <-9.84704, 6.18684, 14.8066>, <0.000752938, -0.000402137, -0.00194438> }
        smooth_triangle {<-9.86477, 6.28324, 14.7828>, <0.000437695, -0.000156997, -0.00100935>,
                         <-9.88489, 6.3803, 14.7641>, <0.000163304, -3.44716e-05, -0.000354406>,
                         <-9.87927, 6.38193, 14.7653>, <2.22943e-05, -7.54097e-05, -0.000383766> }
        smooth_triangle {<-9.87927, 6.38193, 14.7653>, <0.000100033, -0.000103935, -0.000623648>,
                         <-9.85171, 6.28703, 14.7855>, <0.000112728, -0.00025189, -0.00114329>,
                         <-9.86477, 6.28324, 14.7828>, <0.000411583, -0.000165126, -0.00109284> }
        smooth_triangle {<-9.88489, 6.3803, 14.7641>, <0.000163304, -3.44716e-05, -0.000354406>,
                         <-9.907, 6.47767, 14.7499>, <-3.9751e-05, 1.18151e-05, 0.000171482>,
                         <-9.90706, 6.47766, 14.7498>, <2.582e-05, 3.08518e-05, 0.000171777> }
        smooth_triangle {<-9.90706, 6.47766, 14.7498>, <5.35427e-05, 9.51027e-06, -1.70736e-05>,
                         <-9.87927, 6.38193, 14.7653>, <5.08984e-05, -7.01859e-05, -0.000433731>,
                         <-9.88489, 6.3803, 14.7641>, <0.000156655, -3.94823e-05, -0.000411711> }
        smooth_triangle {<-9.907, 6.47767, 14.7499>, <-3.9751e-05, 1.18151e-05, 0.000171482>,
                         <-9.93011, 6.57513, 14.7378>, <-0.000203376, 9.14652e-06, 0.000465366>,
                         <-9.93495, 6.57373, 14.7368>, <-1.82584e-05, 6.28901e-05, 0.000503709> }
        smooth_triangle {<-9.93495, 6.57373, 14.7368>, <-1.26141e-05, 4.20617e-05, 0.00033775>,
                         <-9.90706, 6.47766, 14.7498>, <1.90337e-05, 2.324e-05, 0.000130291>,
                         <-9.907, 6.47767, 14.7499>, <-3.01446e-05, 8.96249e-06, 0.00013007> }
        smooth_triangle {<-9.59715, 5.10986, 14.8337>, <0.00104056, 0.00630142, -0.00412494>,
                         <-9.66759, 5.15715, 14.8882>, <0.00196174, 0.00672237, -0.00448549>,
                         <-9.6067, 5.17483, 14.9306>, <3.855e-05, 0.00616402, -0.00558226> }
        smooth_triangle {<-9.6067, 5.17483, 14.9306>, <0.000186528, 0.0055775, -0.0048115>,
                         <-9.56025, 5.12057, 14.8594>, <-2.32058e-05, 0.00481038, -0.00368247>,
                         <-9.59715, 5.10986, 14.8337>, <0.000835511, 0.00505968, -0.00331209> }
        smooth_triangle {<-9.66759, 5.15715, 14.8882>, <0.00196174, 0.00672237, -0.00448549>,
                         <-9.73211, 5.22015, 14.9326>, <0.00391296, 0.00679214, -0.00664235>,
                         <-9.65166, 5.2435, 14.9886>, <0.0010587, 0.00596349, -0.00829947> }
        smooth_triangle {<-9.65166, 5.2435, 14.9886>, <0.00126512, 0.00583173, -0.0074688>,
                         <-9.6067, 5.17483, 14.9306>, <0.000500006, 0.00598213, -0.00543089>,
                         <-9.66759, 5.15715, 14.8882>, <0.0019424, 0.00640089, -0.00460832> }
        smooth_triangle {<-9.73211, 5.22015, 14.9326>, <0.00391296, 0.00679214, -0.00664235>,
                         <-9.78195, 5.30384, 14.9571>, <0.00606322, 0.00483535, -0.00825833>,
                         <-9.69069, 5.33033, 15.0206>, <0.00250401, 0.00380203, -0.0103739> }
        smooth_triangle {<-9.69069, 5.33033, 15.0206>, <0.00290599, 0.00404228, -0.00975477>,
                         <-9.65166, 5.2435, 14.9886>, <0.00182201, 0.00566337, -0.00819895>,
                         <-9.73211, 5.22015, 14.9326>, <0.0039627, 0.00628486, -0.00695611> }
        smooth_triangle {<-9.78195, 5.30384, 14.9571>, <0.00606322, 0.00483535, -0.00825833>,
                         <-9.81625, 5.39827, 14.9637>, <0.00718342, 0.00252097, -0.00866158>,
                         <-9.72208, 5.42561, 15.0293>, <0.00344453, 0.00143549, -0.0109112> }
        smooth_triangle {<-9.72208, 5.42561, 15.0293>, <0.0040385, 0.0017723, -0.010565>,
                         <-9.69069, 5.33033, 15.0206>, <0.0033331, 0.0035472, -0.0101621>,
                         <-9.78195, 5.30384, 14.9571>, <0.00600252, 0.00432219, -0.00857538> }
        smooth_triangle {<-9.81625, 5.39827, 14.9637>, <0.00718342, 0.00252097, -0.00866158>,
                         <-9.83876, 5.49631, 14.958>, <0.00735683, 0.000680871, -0.00821103>,
                         <-9.7471, 5.52292, 15.0218>, <0.00380885, -0.000349185, -0.0103623> }
        smooth_triangle {<-9.7471, 5.52292, 15.0218>, <0.00450185, -2.81161e-05, -0.0102339>,
                         <-9.72208, 5.42561, 15.0293>, <0.00422861, 0.00131039, -0.0106455>,
                         <-9.81625, 5.39827, 14.9637>, <0.00703277, 0.0021245, -0.00895832> }
        smooth_triangle {<-9.83876, 5.49631, 14.958>, <0.00735683, 0.000680871, -0.00821103>,
                         <-9.85064, 5.5951, 14.9419>, <0.00691469, -0.000668457, -0.00727229>,
                         <-9.76609, 5.61964, 15.0007>, <0.00377026, -0.00158136, -0.0091886> }
        smooth_triangle {<-9.76609, 5.61964, 15.0007>, <0.00450988, -0.00136602, -0.00923409>,
                         <-9.7471, 5.52292, 15.0218>, <0.00453883, -0.000441892, -0.0101144>,
                         <-9.83876, 5.49631, 14.958>, <0.00719981, 0.00033065, -0.00850091> }
        smooth_triangle {<-9.85064, 5.5951, 14.9419>, <0.00691469, -0.000668457, -0.00727229>,
                         <-9.85517, 5.69318, 14.9189>, <0.00607977, -0.00130053, -0.00615293>,
                         <-9.78076, 5.71479, 14.9707>, <0.00341821, -0.00207324, -0.00778017> }
        smooth_triangle {<-9.78076, 5.71479, 14.9707>, <0.00414726, -0.00197437, -0.00793616>,
                         <-9.76609, 5.61964, 15.0007>, <0.00441129, -0.00160546, -0.00899248>,
                         <-9.85064, 5.5951, 14.9419>, <0.00676962, -0.000920782, -0.00755524> }
        smooth_triangle {<-9.85517, 5.69318, 14.9189>, <0.00607977, -0.00130053, -0.00615293>,
                         <-9.85585, 5.79051, 14.8924>, <0.00508059, -0.00136411, -0.00504312>,
                         <-9.7931, 5.80873, 14.9361>, <0.00289833, -0.00199767, -0.00638085> }
        smooth_triangle {<-9.7931, 5.80873, 14.9361>, <0.00357667, -0.0019823, -0.00660002>,
                         <-9.78076, 5.71479, 14.9707>, <0.00396658, -0.00203898, -0.00764951>,
                         <-9.85517, 5.69318, 14.9189>, <0.00596275, -0.00145945, -0.00642908> }
        smooth_triangle {<-9.85585, 5.79051, 14.8924>, <0.00508059, -0.00136411, -0.00504312>,
                         <-9.85561, 5.88762, 14.8651>, <0.00406042, -0.00110797, -0.0040146>,
                         <-9.80489, 5.90235, 14.9004>, <0.00232255, -0.00161251, -0.00508303> }
        smooth_triangle {<-9.80489, 5.90235, 14.9004>, <0.00292615, -0.00164038, -0.00533449>,
                         <-9.7931, 5.80873, 14.9361>, <0.00335798, -0.00192925, -0.00630786>,
                         <-9.85585, 5.79051, 14.8924>, <0.00499468, -0.00145408, -0.00530456> }
        smooth_triangle {<-9.85561, 5.88762, 14.8651>, <0.00406042, -0.00110797, -0.0040146>,
                         <-9.85673, 5.98506, 14.839>, <0.00309379, -0.000751213, -0.00307432>,
                         <-9.81751, 5.99645, 14.8663>, <0.00176207, -0.00113784, -0.00389714> }
        smooth_triangle {<-9.81751, 5.99645, 14.8663>, <0.00227708, -0.00117419, -0.00416234>,
                         <-9.80489, 5.90235, 14.9004>, <0.00269744, -0.00153018, -0.00505176>,
                         <-9.85561, 5.88762, 14.8651>, <0.00400085, -0.00115178, -0.00425043> }
        smooth_triangle {<-9.85673, 5.98506, 14.839>, <0.00309379, -0.000751213, -0.00307432>,
                         <-9.86004, 6.08295, 14.8149>, <0.00220738, -0.000438893, -0.00220886>,
                         <-9.83145, 6.09126, 14.8348>, <0.00124959, -0.000716962, -0.00280513> }
        smooth_triangle {<-9.83145, 6.09126, 14.8348>, <0.00167364, -0.000751546, -0.0030731>,
                         <-9.81751, 5.99645, 14.8663>, <0.002058, -0.00106721, -0.00389211>,
                         <-9.85673, 5.98506, 14.839>, <0.00305679, -0.000777234, -0.00327499> }
        smooth_triangle {<-9.86004, 6.08295, 14.8149>, <0.00220738, -0.000438893, -0.00220886>,
                         <-9.86613, 6.1813, 14.7933>, <0.00142641, -0.000203981, -0.00143728>,
                         <-9.84704, 6.18684, 14.8066>, <0.000802218, -0.000385199, -0.00183033> }
        smooth_triangle {<-9.84704, 6.18684, 14.8066>, <0.0011356, -0.000412854, -0.00208843>,
                         <-9.83145, 6.09126, 14.8348>, <0.00147113, -0.000661676, -0.00281953>,
                         <-9.86004, 6.08295, 14.8149>, <0.00218948, -0.000453124, -0.00237233> }
        smooth_triangle {<-9.86613, 6.1813, 14.7933>, <0.00142641, -0.000203981, -0.00143728>,
                         <-9.87584, 6.28003, 14.7751>, <0.000781112, -5.72953e-05, -0.000788414>,
                         <-9.86477, 6.28324, 14.7828>, <0.000437695, -0.000156997, -0.00100935> }
        smooth_triangle {<-9.86477, 6.28324, 14.7828>, <0.000681312, -0.000172408, -0.00124162>,
                         <-9.84704, 6.18684, 14.8066>, <0.000954705, -0.000343559, -0.00185735>,
                         <-9.86613, 6.1813, 14.7933>, <0.00142285, -0.000207646, -0.00156257> }
        smooth_triangle {<-9.87584, 6.28003, 14.7751>, <0.000781112, -5.72953e-05, -0.000788414>,
                         <-9.88965, 6.37891, 14.7608>, <0.000282789, 2.17671e-07, -0.000271091>,
                         <-9.88489, 6.3803, 14.7641>, <0.000163304, -3.44716e-05, -0.000354406> }
        smooth_triangle {<-9.88489, 6.3803, 14.7641>, <0.000324325, -3.88183e-05, -0.000550502>,
                         <-9.86477, 6.28324, 14.7828>, <0.000530118, -0.000130712, -0.00104171>,
                         <-9.87584, 6.28003, 14.7751>, <0.000787682, -5.5936e-05, -0.000876008> }
        smooth_triangle {<-9.88965, 6.37891, 14.7608>, <0.000282789, 2.17671e-07, -0.000271091>,
                         <-9.90695, 6.47769, 14.7499>, <-0.000100222, -5.74109e-06, 0.000145081>,
                         <-9.907, 6.47767, 14.7499>, <-3.9751e-05, 1.18151e-05, 0.000171482> }
        smooth_triangle {<-9.907, 6.47767, 14.7499>, <5.58647e-05, 1.01844e-05, 4.91817e-06>,
                         <-9.88489, 6.3803, 14.7641>, <0.000208156, -2.45306e-05, -0.000389498>,
                         <-9.88965, 6.37891, 14.7608>, <0.00029777, 1.48633e-06, -0.000327012> }
        smooth_triangle {<-9.90695, 6.47769, 14.7499>, <-0.000100222, -5.74109e-06, 0.000145081>,
                         <-9.92601, 6.57632, 14.7407>, <-0.00036031, -3.64151e-05, 0.000356176>,
                         <-9.93011, 6.57513, 14.7378>, <-0.000203376, 9.14652e-06, 0.000465366> }
        smooth_triangle {<-9.93011, 6.57513, 14.7378>, <-0.000136712, 6.03338e-06, 0.000311892>,
                         <-9.907, 6.47767, 14.7499>, <-3.06593e-05, 8.81308e-06, 0.000129848>,
                         <-9.90695, 6.47769, 14.7499>, <-7.60128e-05, -4.35405e-06, 0.000110047> }
        smooth_triangle {<-9.6218, 5.1027, 14.7953>, <0.00235503, 0.00668303, -0.00275619>,
                         <-9.70828, 5.14534, 14.8248>, <0.00333546, 0.00712119, -0.00270585>,
                         <-9.66759, 5.15715, 14.8882>, <0.00196174, 0.00672237, -0.00448549> }
        smooth_triangle {<-9.66759, 5.15715, 14.8882>, <0.00182802, 0.00605407, -0.0037816>,
                         <-9.59715, 5.10986, 14.8337>, <0.00123372, 0.00517529, -0.00289744>,
                         <-9.6218, 5.1027, 14.7953>, <0.00189095, 0.0053661, -0.00221307> }
        smooth_triangle {<-9.70828, 5.14534, 14.8248>, <0.00333546, 0.00712119, -0.00270585>,
                         <-9.78587, 5.20454, 14.8488>, <0.00594094, 0.00738091, -0.00397399>,
                         <-9.73211, 5.22015, 14.9326>, <0.00391296, 0.00679214, -0.00664235> }
        smooth_triangle {<-9.73211, 5.22015, 14.9326>, <0.00380229, 0.00656833, -0.00581311>,
                         <-9.66759, 5.15715, 14.8882>, <0.00233888, 0.006516, -0.00419547>,
                         <-9.70828, 5.14534, 14.8248>, <0.00336917, 0.00681512, -0.00286073> }
        smooth_triangle {<-9.78587, 5.20454, 14.8488>, <0.00594094, 0.00738091, -0.00397399>,
                         <-9.84292, 5.28614, 14.8621>, <0.00857402, 0.00556429, -0.0048855>,
                         <-9.78195, 5.30384, 14.9571>, <0.00606322, 0.00483535, -0.00825833> }
        smooth_triangle {<-9.78195, 5.30384, 14.9571>, <0.00620456, 0.00499992, -0.00751296>,
                         <-9.73211, 5.22015, 14.9326>, <0.00459186, 0.00646752, -0.00630098>,
                         <-9.78587, 5.20454, 14.8488>, <0.00611284, 0.00690909, -0.00429971> }
        smooth_triangle {<-9.84292, 5.28614, 14.8621>, <0.00857402, 0.00556429, -0.0048855>,
                         <-9.87918, 5.38, 14.8657>, <0.00981094, 0.0032838, -0.00509331>,
                         <-9.81625, 5.39827, 14.9637>, <0.00718342, 0.00252097, -0.00866158> }
        smooth_triangle {<-9.81625, 5.39827, 14.9637>, <0.0076016, 0.00280674, -0.00808754>,
                         <-9.78195, 5.30384, 14.9571>, <0.00676146, 0.00454253, -0.00778511>,
                         <-9.84292, 5.28614, 14.8621>, <0.00864456, 0.00508923, -0.00525549> }
        smooth_triangle {<-9.87918, 5.38, 14.8657>, <0.00981094, 0.0032838, -0.00509331>,
                         <-9.9, 5.47853, 14.8626>, <0.0098441, 0.00140298, -0.00480966>,
                         <-9.83876, 5.49631, 14.958>, <0.00735683, 0.000680871, -0.00821103> }
        smooth_triangle {<-9.83876, 5.49631, 14.958>, <0.00794742, 0.000972211, -0.00780342>,
                         <-9.81625, 5.39827, 14.9637>, <0.00781737, 0.00235228, -0.00814133>,
                         <-9.87918, 5.38, 14.8657>, <0.00978801, 0.0029244, -0.00546513> }
        smooth_triangle {<-9.9, 5.47853, 14.8626>, <0.0098441, 0.00140298, -0.00480966>,
                         <-9.90714, 5.5787, 14.8538>, <0.00911551, -2.95109e-05, -0.00424883>,
                         <-9.85064, 5.5951, 14.9419>, <0.00691469, -0.000668457, -0.00727229> }
        smooth_triangle {<-9.85064, 5.5951, 14.9419>, <0.00761473, -0.000464617, -0.00701952>,
                         <-9.83876, 5.49631, 14.958>, <0.00794632, 0.000547379, -0.00772357>,
                         <-9.9, 5.47853, 14.8626>, <0.00981178, 0.00108896, -0.00517255> }
        smooth_triangle {<-9.90714, 5.5787, 14.8538>, <0.00911551, -2.95109e-05, -0.00424883>,
                         <-9.9049, 5.67875, 14.8414>, <0.00794072, -0.000760258, -0.00358896>,
                         <-9.85517, 5.69318, 14.9189>, <0.00607977, -0.00130053, -0.00615293> }
        smooth_triangle {<-9.85517, 5.69318, 14.9189>, <0.00681295, -0.00120046, -0.00601856>,
                         <-9.85064, 5.5951, 14.9419>, <0.00743914, -0.000726405, -0.00685808>,
                         <-9.90714, 5.5787, 14.8538>, <0.00908976, -0.000247195, -0.00459048> }
        smooth_triangle {<-9.9049, 5.67875, 14.8414>, <0.00794072, -0.000760258, -0.00358896>,
                         <-9.89777, 5.77834, 14.8271>, <0.00660511, -0.000921512, -0.00293762>,
                         <-9.85585, 5.79051, 14.8924>, <0.00508059, -0.00136411, -0.00504312> }
        smooth_triangle {<-9.85585, 5.79051, 14.8924>, <0.00579154, -0.00133928, -0.00499467>,
                         <-9.85517, 5.69318, 14.9189>, <0.00654093, -0.00129159, -0.00582703>,
                         <-9.9049, 5.67875, 14.8414>, <0.00793664, -0.000886384, -0.00390405> }
        smooth_triangle {<-9.89777, 5.77834, 14.8271>, <0.00660511, -0.000921512, -0.00293762>,
                         <-9.88949, 5.87779, 14.8123>, <0.00527335, -0.000755826, -0.00233498>,
                         <-9.85561, 5.88762, 14.8651>, <0.00406042, -0.00110797, -0.0040146> }
        smooth_triangle {<-9.85561, 5.88762, 14.8651>, <0.00471463, -0.00112115, -0.00402806>,
                         <-9.85585, 5.79051, 14.8924>, <0.00547975, -0.00131326, -0.00479945>,
                         <-9.89777, 5.77834, 14.8271>, <0.00662314, -0.000981306, -0.00322033> }
        smooth_triangle {<-9.88949, 5.87779, 14.8123>, <0.00527335, -0.000755826, -0.00233498>,
                         <-9.88294, 5.97745, 14.7982>, <0.00402174, -0.000481807, -0.00178346>,
                         <-9.85673, 5.98506, 14.839>, <0.00309379, -0.000751213, -0.00307432> }
        smooth_triangle {<-9.85673, 5.98506, 14.839>, <0.00367085, -0.000769543, -0.00313394>,
                         <-9.85561, 5.88762, 14.8651>, <0.00439583, -0.00103711, -0.00383914>,
                         <-9.88949, 5.87779, 14.8123>, <0.00530552, -0.000773003, -0.00257943> }
        smooth_triangle {<-9.88294, 5.97745, 14.7982>, <0.00402174, -0.000481807, -0.00178346>,
                         <-9.87915, 6.07741, 14.7851>, <0.00287314, -0.000245609, -0.00127632>,
                         <-9.86004, 6.08295, 14.8149>, <0.00220738, -0.000438893, -0.00220886> }
        smooth_triangle {<-9.86004, 6.08295, 14.8149>, <0.00270085, -0.000453323, -0.00230428>,
                         <-9.85673, 5.98506, 14.839>, <0.00336566, -0.000687564, -0.00295337>,
                         <-9.88294, 5.97745, 14.7982>, <0.00406162, -0.000485509, -0.00198523> }
        smooth_triangle {<-9.87915, 6.07741, 14.7851>, <0.00287314, -0.000245609, -0.00127632>,
                         <-9.87889, 6.1776, 14.7734>, <0.00185865, -7.84942e-05, -0.000825422>,
                         <-9.86613, 6.1813, 14.7933>, <0.00142641, -0.000203981, -0.00143728> }
        smooth_triangle {<-9.86613, 6.1813, 14.7933>, <0.00183181, -0.000210729, -0.00155617>,
                         <-9.86004, 6.08295, 14.8149>, <0.00241754, -0.000386912, -0.00213485>,
                         <-9.87915, 6.07741, 14.7851>, <0.00291685, -0.00024195, -0.00143544> }
        smooth_triangle {<-9.87889, 6.1776, 14.7734>, <0.00185865, -7.84942e-05, -0.000825422>,
                         <-9.88323, 6.27788, 14.7636>, <0.00101719, 1.1244e-05, -0.000447447>,
                         <-9.87584, 6.28003, 14.7751>, <0.000781112, -5.72953e-05, -0.000788414> }
        smooth_triangle {<-9.87584, 6.28003, 14.7751>, <0.0010933, -5.27983e-05, -0.000915113>,
                         <-9.86613, 6.1813, 14.7933>, <0.00157728, -0.000162813, -0.00140177>,
                         <-9.87889, 6.1776, 14.7734>, <0.00190145, -6.86975e-05, -0.000942869> }
        smooth_triangle {<-9.88323, 6.27788, 14.7636>, <0.00101719, 1.1244e-05, -0.000447447>,
                         <-9.89284, 6.37799, 14.7559>, <0.00036256, 2.3377e-05, -0.000146505>,
                         <-9.88965, 6.37891, 14.7608>, <0.000282789, 2.17671e-07, -0.000271091> }
        smooth_triangle {<-9.88965, 6.37891, 14.7608>, <0.000504662, 1.35375e-05, -0.000393547>,
                         <-9.87584, 6.28003, 14.7751>, <0.000878404, -2.95973e-05, -0.000781539>,
                         <-9.88323, 6.27788, 14.7636>, <0.00105546, 2.18072e-05, -0.000525814> }
        smooth_triangle {<-9.89284, 6.37799, 14.7559>, <0.00036256, 2.3377e-05, -0.000146505>,
                         <-9.90692, 6.4777, 14.7499>, <-0.000146388, -1.91439e-05, 9.6592e-05>,
                         <-9.90695, 6.47769, 14.7499>, <-0.000100222, -5.74109e-06, 0.000145081> }
        smooth_triangle {<-9.90695, 6.47769, 14.7499>, <4.99277e-05, 8.46077e-06, 2.61612e-05>,
                         <-9.88965, 6.37891, 14.7608>, <0.000337186, 1.29298e-05, -0.000285968>,
                         <-9.89284, 6.37799, 14.7559>, <0.000397015, 3.02993e-05, -0.000192528> }
        smooth_triangle {<-9.90692, 6.4777, 14.7499>, <-0.000146388, -1.91439e-05, 9.6592e-05>,
                         <-9.92327, 6.57712, 14.745>, <-0.000465171, -6.68584e-05, 0.000192761>,
                         <-9.92601, 6.57632, 14.7407>, <-0.00036031, -3.64151e-05, 0.000356176> }
        smooth_triangle {<-9.92601, 6.57632, 14.7407>, <-0.00024186, -2.44935e-05, 0.000238552>,
                         <-9.90695, 6.47769, 14.7499>, <-7.64067e-05, -4.4684e-06, 0.000109636>,
                         <-9.90692, 6.4777, 14.7499>, <-0.000111031, -1.45205e-05, 7.32699e-05> }
        smooth_triangle {<-9.63046, 5.10019, 14.75>, <0.00306641, 0.00688956, -0.000967846>,
                         <-9.72257, 5.14119, 14.75>, <0.00395058, 0.00729977, -0.000514264>,
                         <-9.70828, 5.14534, 14.8248>, <0.00333546, 0.00712119, -0.00270585> }
        smooth_triangle {<-9.70828, 5.14534, 14.8248>, <0.00296607, 0.00638447, -0.00217599>,
                         <-9.6218, 5.1027, 14.7953>, <0.00210646, 0.00542867, -0.0016713>,
                         <-9.63046, 5.10019, 14.75>, <0.00246215, 0.00553193, -0.000777126> }
        smooth_triangle {<-9.72257, 5.14119, 14.75>, <0.00395058, 0.00729977, -0.000514264>,
                         <-9.80474, 5.19906, 14.75>, <0.00683391, 0.00764016, -0.000700631>,
                         <-9.78587, 5.20454, 14.8488>, <0.00594094, 0.00738091, -0.00397399> }
        smooth_triangle {<-9.78587, 5.20454, 14.8488>, <0.00553785, 0.0070722, -0.00327242>,
                         <-9.70828, 5.14534, 14.8248>, <0.00358375, 0.00687741, -0.00232132>,
                         <-9.72257, 5.14119, 14.75>, <0.00404509, 0.00701135, -0.000677629> }
        smooth_triangle {<-9.80474, 5.19906, 14.75>, <0.00683391, 0.00764016, -0.000700631>,
                         <-9.86434, 5.27992, 14.75>, <0.00965415, 0.00587787, -0.0007689>,
                         <-9.84292, 5.28614, 14.8621>, <0.00857402, 0.00556429, -0.0048855> }
        smooth_triangle {<-9.84292, 5.28614, 14.8621>, <0.00842815, 0.00564548, -0.00412737>,
                         <-9.78587, 5.20454, 14.8488>, <0.00645334, 0.00700795, -0.00344374>,
                         <-9.80474, 5.19906, 14.75>, <0.00712306, 0.00720238, -0.00098872> }
        smooth_triangle {<-9.86434, 5.27992, 14.75>, <0.00965415, 0.00587787, -0.0007689>,
                         <-9.90128, 5.37358, 14.75>, <0.0109271, 0.00360784, -0.00074963>,
                         <-9.87918, 5.38, 14.8657>, <0.00981094, 0.0032838, -0.00509331> }
        smooth_triangle {<-9.87918, 5.38, 14.8657>, <0.00998298, 0.00349811, -0.00437879>,
                         <-9.84292, 5.28614, 14.8621>, <0.00905529, 0.00520848, -0.00422294>,
                         <-9.86434, 5.27992, 14.75>, <0.00986539, 0.00544367, -0.00113549> }
        smooth_triangle {<-9.90128, 5.37358, 14.75>, <0.0109271, 0.00360784, -0.00074963>,
                         <-9.9215, 5.47229, 14.75>, <0.010892, 0.00170721, -0.000676063>,
                         <-9.9, 5.47853, 14.8626>, <0.0098441, 0.00140298, -0.00480966> }
        smooth_triangle {<-9.9, 5.47853, 14.8626>, <0.0102375, 0.00163707, -0.00418495>,
                         <-9.87918, 5.38, 14.8657>, <0.0102126, 0.00304768, -0.00439768>,
                         <-9.90128, 5.37358, 14.75>, <0.0110497, 0.00329071, -0.00113992> }
        smooth_triangle {<-9.9215, 5.47229, 14.75>, <0.010892, 0.00170721, -0.000676063>,
                         <-9.92697, 5.57294, 14.75>, <0.0100377, 0.000238208, -0.000578525>,
                         <-9.90714, 5.5787, 14.8538>, <0.00911551, -2.95109e-05, -0.00424883> }
        smooth_triangle {<-9.90714, 5.5787, 14.8538>, <0.00966935, 0.000131886, -0.00373628>,
                         <-9.9, 5.47853, 14.8626>, <0.0102158, 0.00120626, -0.00415691>,
                         <-9.9215, 5.47229, 14.75>, <0.0110017, 0.00143443, -0.00105671> }
        smooth_triangle {<-9.92697, 5.57294, 14.75>, <0.0100377, 0.000238208, -0.000578525>,
                         <-9.92236, 5.67368, 14.75>, <0.00871772, -0.000534677, -0.000478598>,
                         <-9.9049, 5.67875, 14.8414>, <0.00794072, -0.000760258, -0.00358896> }
        smooth_triangle {<-9.9049, 5.67875, 14.8414>, <0.008571, -0.00069006, -0.00318469>,
                         <-9.90714, 5.5787, 14.8538>, <0.0094521, -0.000141999, -0.00367959>,
                         <-9.92697, 5.57294, 14.75>, <0.0101437, 5.87897e-05, -0.000926865> }
        smooth_triangle {<-9.92236, 5.67368, 14.75>, <0.00871772, -0.000534677, -0.000478598>,
                         <-9.9125, 5.77407, 14.75>, <0.00723979, -0.000737249, -0.000384897>,
                         <-9.89777, 5.77834, 14.8271>, <0.00660511, -0.000921512, -0.00293762> }
        smooth_triangle {<-9.89777, 5.77834, 14.8271>, <0.00724784, -0.000916481, -0.00262893>,
                         <-9.9049, 5.67875, 14.8414>, <0.00824954, -0.00079554, -0.00311743>,
                         <-9.92236, 5.67368, 14.75>, <0.0088323, -0.000626354, -0.000784663> }
        smooth_triangle {<-9.9125, 5.77407, 14.75>, <0.00723979, -0.000737249, -0.000384897>,
                         <-9.90139, 5.87433, 14.75>, <0.00577667, -0.0006097, -0.000299881>,
                         <-9.88949, 5.87779, 14.8123>, <0.00527335, -0.000755826, -0.00233498> }
        smooth_triangle {<-9.88949, 5.87779, 14.8123>, <0.00588685, -0.000780826, -0.0021084>,
                         <-9.89777, 5.77834, 14.8271>, <0.00688567, -0.00090509, -0.00256038>,
                         <-9.9125, 5.77407, 14.75>, <0.00736168, -0.000766893, -0.000645835> }
        smooth_triangle {<-9.90139, 5.87433, 14.75>, <0.00577667, -0.0006097, -0.000299881>,
                         <-9.89214, 5.97478, 14.75>, <0.00440466, -0.000370638, -0.000221083>,
                         <-9.88294, 5.97745, 14.7982>, <0.00402174, -0.000481807, -0.00178346> }
        smooth_triangle {<-9.88294, 5.97745, 14.7982>, <0.00458058, -0.000505429, -0.00162842>,
                         <-9.88949, 5.87779, 14.8123>, <0.00551928, -0.000710943, -0.00204206>,
                         <-9.90139, 5.87433, 14.75>, <0.00589677, -0.000601349, -0.000515735> }
        smooth_triangle {<-9.89214, 5.97478, 14.75>, <0.00440466, -0.000370638, -0.000221083>,
                         <-9.88586, 6.07546, 14.75>, <0.0031455, -0.000166537, -0.000149467>,
                         <-9.87915, 6.07741, 14.7851>, <0.00287314, -0.000245609, -0.00127632> }
        smooth_triangle {<-9.87915, 6.07741, 14.7851>, <0.00336733, -0.000259831, -0.00118466>,
                         <-9.88294, 5.97745, 14.7982>, <0.00422878, -0.00043698, -0.00156501>,
                         <-9.89214, 5.97478, 14.75>, <0.00451597, -0.000353603, -0.00039323> }
        smooth_triangle {<-9.88586, 6.07546, 14.75>, <0.0031455, -0.000166537, -0.000149467>,
                         <-9.88337, 6.1763, 14.75>, <0.00203311, -2.78427e-05, -8.78968e-05>,
                         <-9.87889, 6.1776, 14.7734>, <0.00185865, -7.84942e-05, -0.000825422> }
        smooth_triangle {<-9.87889, 6.1776, 14.7734>, <0.00227941, -8.07801e-05, -0.00078699>,
                         <-9.87915, 6.07741, 14.7851>, <0.00304028, -0.000206116, -0.00112516>,
                         <-9.88586, 6.07546, 14.75>, <0.00324455, -0.000146812, -0.000280024> }
        smooth_triangle {<-9.88337, 6.1763, 14.75>, <0.00203311, -2.78427e-05, -8.78968e-05>,
                         <-9.88583, 6.27713, 14.75>, <0.00110999, 3.81862e-05, -3.83606e-05>,
                         <-9.88323, 6.27788, 14.7636>, <0.00101719, 1.1244e-05, -0.000447447> }
        smooth_triangle {<-9.88323, 6.27788, 14.7636>, <0.00135394, 2.28697e-05, -0.00044929>,
                         <-9.87889, 6.1776, 14.7734>, <0.00198503, -4.44339e-05, -0.000732771>,
                         <-9.88337, 6.1763, 14.75>, <0.00211588, -6.4453e-06, -0.000179627> }
        smooth_triangle {<-9.88583, 6.27713, 14.75>, <0.00110999, 3.81862e-05, -3.83606e-05>,
                         <-9.89396, 6.37766, 14.75>, <0.000390473, 3.14806e-05, 3.85327e-07>,
                         <-9.89284, 6.37799, 14.7559>, <0.00036256, 2.3377e-05, -0.000146505> }
        smooth_triangle {<-9.89284, 6.37799, 14.7559>, <0.000613589, 4.51614e-05, -0.000176678>,
                         <-9.88323, 6.27788, 14.7636>, <0.00110456, 3.60616e-05, -0.000402385>,
                         <-9.88583, 6.27713, 14.75>, <0.00117416, 5.62683e-05, -9.55698e-05> }
        smooth_triangle {<-9.89396, 6.37766, 14.75>, <0.000390473, 3.14806e-05, 3.85327e-07>,
                         <-9.90691, 6.4777, 14.75>, <-0.000171219, -2.6353e-05, 3.3398e-05>,
                         <-9.90692, 6.4777, 14.7499>, <-0.000146388, -1.91439e-05, 9.6592e-05> }
        smooth_triangle {<-9.90692, 6.4777, 14.7499>, <3.66357e-05, 4.60181e-06, 4.34214e-05>,
                         <-9.89284, 6.37799, 14.7559>, <0.000418347, 3.64925e-05, -0.000138901>,
                         <-9.89396, 6.37766, 14.75>, <0.000439281, 4.25702e-05, -2.87336e-05> }
        smooth_triangle {<-9.90691, 6.4777, 14.75>, <-0.000171219, -2.6353e-05, 3.3398e-05>,
                         <-9.92231, 6.5774, 14.75>, <-0.000501993, -7.75487e-05, 0>,
                         <-9.92327, 6.57712, 14.745>, <-0.000465171, -6.68584e-05, 0.000192761> }
        smooth_triangle {<-9.92327, 6.57712, 14.745>, <-0.000312051, -4.48716e-05, 0.000128894>,
                         <-9.90692, 6.4777, 14.7499>, <-0.000111244, -1.45824e-05, 7.2734e-05>,
                         <-9.90691, 6.4777, 14.75>, <-0.000129867, -1.99892e-05, 2.53385e-05> }
        texture { Fire1 }
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 1, 0.0>, 0.25  
        texture { Semi_smooth_steel }
        rotate <.0, .0, -343.811>
        translate <-9.23792, 4.17286, 14.5>
    }
    sphere { <0.0, 0.0, 0.0>, 0.5 
        texture { Semi_smooth_steel }
        rotate <.0, .0, -343.811>
        translate <-8.27758, 4.45167, 14.5>
    }
    cone { <0.0, 0.0, 0.0>, 0.5, <0.0, 7, 0.0>, 0.5  
        texture { Semi_smooth_steel }
        rotate <.0, .0, -73.8108>
        translate <-15, 2.5, 14.5>
    }
    cone { <0.0, 0.0, 0.0>, 5, <0.0, 0.5, 0.0>, 5  
        texture { Semi_smooth_steel }
        rotate <.0, .0, -343.811>
        translate <-11.5149, -9.50433, 14.5>
    }
    cone { <0.0, 0.0, 0.0>, 4.5, <0.0, 0.5, 0.0>, 4.5  
        texture { Semi_smooth_steel }
        rotate <.0, .0, -343.811>
        translate <-11.6543, -9.02415, 14.5>
    }
    union { // Surface of Revolution
        smooth_triangle {<-15.3427, -9.57433, 12.9693>, <0.893491, -0.741603, 0.129551>,
                         <-14.7978, -8.86575, 13.2678>, <0.80122, -0.681376, 0.201632>,
                         <-15.0332, -8.93409, 14.5>, <0.893491, -0.741603, 0.129551> }
        smooth_triangle {<-15.0332, -8.93409, 14.5>, <1.00174, -0.831449, 0.145246>,
                         <-15.6351, -9.65922, 14.5>, <1.10999, -0.921296, 0.160941>,
                         <-15.3427, -9.57433, 12.9693>, <1.00174, -0.831449, 0.145246> }
        smooth_triangle {<-14.7978, -8.86575, 13.2678>, <0.80122, -0.681376, 0.201632>,
                         <-14.288, -8.12771, 13.5559>, <0.630195, -0.474053, 0.165036>,
                         <-14.4684, -8.18007, 14.5>, <0.7119, -0.533276, 0.106416> }
        smooth_triangle {<-14.4684, -8.18007, 14.5>, <0.82049, -0.614619, 0.122648>,
                         <-15.0332, -8.93409, 14.5>, <0.911285, -0.718783, 0.134215>,
                         <-14.7978, -8.86575, 13.2678>, <0.833185, -0.685022, 0.185944> }
        smooth_triangle {<-14.288, -8.12771, 13.5559>, <0.630195, -0.474053, 0.165036>,
                         <-13.8478, -7.3385, 13.8221>, <0.461945, -0.290102, 0.129252>,
                         <-13.9773, -7.37609, 14.5>, <0.545001, -0.332899, 0.0856466> }
        smooth_triangle {<-13.9773, -7.37609, 14.5>, <0.652034, -0.398277, 0.102467>,
                         <-14.4684, -8.18007, 14.5>, <0.735484, -0.498466, 0.112851>,
                         <-14.288, -8.12771, 13.5559>, <0.662413, -0.471454, 0.153599> }
        smooth_triangle {<-13.8478, -7.3385, 13.8221>, <0.461945, -0.290102, 0.129252>,
                         <-13.4615, -6.51647, 14.0707>, <0.323379, -0.130994, 0.0933145>,
                         <-13.5435, -6.54028, 14.5>, <0.358786, -0.186231, 0.0582088> }
        smooth_triangle {<-13.5435, -6.54028, 14.5>, <0.462684, -0.240161, 0.0750651>,
                         <-13.9773, -7.37609, 14.5>, <0.555792, -0.313495, 0.088784>,
                         <-13.8478, -7.3385, 13.8221>, <0.488105, -0.291099, 0.119919> }
        smooth_triangle {<-13.4615, -6.51647, 14.0707>, <0.323379, -0.130994, 0.0933145>,
                         <-13.4568, -5.60584, 14.1778>, <0.293363, 0.0511177, 0.096188>,
                         <-13.5183, -5.62371, 14.5>, <0.295351, -0.00809836, 0.0559702> }
        smooth_triangle {<-13.5183, -5.62371, 14.5>, <0.344401, -0.00944329, 0.0652654>,
                         <-13.5435, -6.54028, 14.5>, <0.376118, -0.0985098, 0.0663847>,
                         <-13.4615, -6.51647, 14.0707>, <0.340897, -0.100943, 0.088626> }
        smooth_triangle {<-13.4568, -5.60584, 14.1778>, <0.293363, 0.0511177, 0.096188>,
                         <-13.8947, -4.7766, 14.0993>, <0.330026, 0.170057, 0.121277>,
                         <-13.9713, -4.79882, 14.5>, <0.330526, 0.181494, 0.073204> }
        smooth_triangle {<-13.9713, -4.79882, 14.5>, <0.298169, 0.163726, 0.0660376>,
                         <-13.5183, -5.62371, 14.5>, <0.280581, 0.06893, 0.0574207>,
                         <-13.4568, -5.60584, 14.1778>, <0.286475, 0.0748279, 0.0868588> }
        smooth_triangle {<-13.8947, -4.7766, 14.0993>, <0.330026, 0.170057, 0.121277>,
                         <-14.2536, -3.91101, 14.0565>, <0.35206, 0.113253, 0.128306>,
                         <-14.3384, -3.9356, 14.5>, <0.382833, 0.162804, 0.0821594> }
        smooth_triangle {<-14.3384, -3.9356, 14.5>, <0.364356, 0.154947, 0.0781942>,
                         <-13.9713, -4.79882, 14.5>, <0.338203, 0.164292, 0.0737165>,
                         <-13.8947, -4.7766, 14.0993>, <0.33399, 0.164315, 0.109515> }
        smooth_triangle {<-14.2536, -3.91101, 14.0565>, <0.35206, 0.113253, 0.128306>,
                         <-14.3514, -2.97818, 14.1254>, <0.317045, 0.0302594, 0.1081>,
                         <-14.4229, -2.99896, 14.5>, <0.350903, 0.0316822, 0.0687882> }
        smooth_triangle {<-14.4229, -2.99896, 14.5>, <0.38315, 0.0345937, 0.0751097>,
                         <-14.3384, -3.9356, 14.5>, <0.399115, 0.100155, 0.0817952>,
                         <-14.2536, -3.91101, 14.0565>, <0.367894, 0.0943158, 0.116587> }
        smooth_triangle {<-14.3514, -2.97818, 14.1254>, <0.317045, 0.0302594, 0.1081>,
                         <-14.4912, -2.05417, 14.1764>, <0.29775, 0.112594, 0.102869>,
                         <-14.553, -2.07211, 14.5>, <0.29989, 0.0420926, 0.0596208> }
        smooth_triangle {<-14.553, -2.07211, 14.5>, <0.323562, 0.0454152, 0.064327>,
                         <-14.4229, -2.99896, 14.5>, <0.349068, 0.04021, 0.0689107>,
                         <-14.3514, -2.97818, 14.1254>, <0.324592, 0.034879, 0.0983336> }
        smooth_triangle {<-14.4912, -2.05417, 14.1764>, <0.29775, 0.112594, 0.102869>,
                         <-15.0462, -1.31108, 14.0415>, <0.332724, 0.196746, 0.127271>,
                         <-15.1338, -1.33651, 14.5>, <0.337293, 0.266318, 0.0792011> }
        smooth_triangle {<-15.1338, -1.33651, 14.5>, <0.287652, 0.227123, 0.0675446>,
                         <-14.553, -2.07211, 14.5>, <0.26895, 0.11501, 0.0577545>,
                         <-14.4912, -2.05417, 14.1764>, <0.282815, 0.131427, 0.0911239> }
        smooth_triangle {<-15.0462, -1.31108, 14.0415>, <0.332724, 0.196746, 0.127271>,
                         <-15.2266, -0.419235, 14.0727>, <0.321783, 0.0314816, 0.114591>,
                         <-15.3082, -0.442931, 14.5>, <0.381799, 0.0745035, 0.0770649> }
        smooth_triangle {<-15.3082, -0.442931, 14.5>, <0.395765, 0.0772288, 0.0798839>,
                         <-15.1338, -1.33651, 14.5>, <0.373512, 0.173136, 0.080952>,
                         <-15.0462, -1.31108, 14.0415>, <0.351976, 0.167548, 0.116129> }
        smooth_triangle {<-15.2266, -0.419235, 14.0727>, <0.321783, 0.0314816, 0.114591>,
                         <-15.1178, 0.504068, 14.2226>, <0.252573, 0.0198973, 0.0808486>,
                         <-15.1708, 0.488686, 14.5>, <0.258396, -0.0381171, 0.0472462> }
        smooth_triangle {<-15.1708, 0.488686, 14.5>, <0.328223, -0.0484176, 0.0600136>,
                         <-15.3082, -0.442931, 14.5>, <0.389925, 0.00789271, 0.074923>,
                         <-15.2266, -0.419235, 14.0727>, <0.34085, 0.00893169, 0.104139> }
        smooth_triangle {<-15.1178, 0.504068, 14.2226>, <0.252573, 0.0198973, 0.0808486>,
                         <-15.525, 1.30187, 14.1528>, <0.287382, 0.182395, 0.105515>,
                         <-15.5913, 1.28261, 14.5>, <0.275653, 0.146008, 0.060754> }
        smooth_triangle {<-15.5913, 1.28261, 14.5>, <0.24793, 0.131323, 0.0546437>,
                         <-15.1708, 0.488686, 14.5>, <0.239301, 0.0392609, 0.0478898>,
                         <-15.1178, 0.504068, 14.2226>, <0.244481, 0.0440827, 0.0727698> }
        smooth_triangle {<-15.525, 1.30187, 14.1528>, <0.287382, 0.182395, 0.105515>,
                         <-16.0653, 2.0576, 14.0252>, <0.345287, 0.190359, 0.131701>,
                         <-16.156, 2.03127, 14.5>, <0.355496, 0.268133, 0.0827789> }
        smooth_triangle {<-16.156, 2.03127, 14.5>, <0.307715, 0.232095, 0.0716529>,
                         <-15.5913, 1.28261, 14.5>, <0.267794, 0.171032, 0.0606405>,
                         <-15.525, 1.30187, 14.1528>, <0.28052, 0.18581, 0.0942681> }
        smooth_triangle {<-16.0653, 2.0576, 14.0252>, <0.345287, 0.190359, 0.131701>,
                         <-16.1992, 2.96623, 14.0768>, <0.293123, 0.00519628, 0.107342>,
                         <-16.28, 2.94276, 14.5>, <0.385713, 0.0524745, 0.0765908> }
        smooth_triangle {<-16.28, 2.94276, 14.5>, <0.409265, 0.0556788, 0.0812677>,
                         <-16.156, 2.03127, 14.5>, <0.394157, 0.163508, 0.0843617>,
                         <-16.0653, 2.0576, 14.0252>, <0.36717, 0.15749, 0.120262> }
        smooth_triangle {<-16.1992, 2.96623, 14.0768>, <0.293123, 0.00519628, 0.107342>,
                         <-15.8618, 3.81173, 14.3087>, <0.154197, -0.0759317, 0.0525687>,
                         <-15.8984, 3.80111, 14.5>, <0.164239, -0.0730163, 3.46945e-18> }
        smooth_triangle {<-15.8984, 3.80111, 14.5>, <0.230568, -0.102505, 0.0201433>,
                         <-16.28, 2.94276, 14.5>, <0.37447, -0.0545033, 0.0685103>,
                         <-16.1992, 2.96623, 14.0768>, <0.310649, -0.0364731, 0.0956143> }
        smooth_triangle {<-14.51, -9.33258, 11.6716>, <0.798269, -0.769248, 0.368929>,
                         <-14.1275, -8.67115, 12.2232>, <0.684758, -0.715187, 0.408039>,
                         <-14.7978, -8.86575, 13.2678>, <0.80122, -0.681376, 0.201632> }
        smooth_triangle {<-14.7978, -8.86575, 13.2678>, <0.848838, -0.749942, 0.265804>,
                         <-15.3427, -9.57433, 12.9693>, <0.942592, -0.848621, 0.293936>,
                         <-14.51, -9.33258, 11.6716>, <0.894981, -0.862444, 0.413625> }
        smooth_triangle {<-14.1275, -8.67115, 12.2232>, <0.684758, -0.715187, 0.408039>,
                         <-13.7744, -7.9786, 12.7555>, <0.534963, -0.501701, 0.333496>,
                         <-14.288, -8.12771, 13.5559>, <0.630195, -0.474053, 0.165036> }
        smooth_triangle {<-14.288, -8.12771, 13.5559>, <0.679396, -0.536939, 0.222651>,
                         <-14.7978, -8.86575, 13.2678>, <0.807665, -0.692431, 0.250098>,
                         <-14.1275, -8.67115, 12.2232>, <0.720318, -0.71779, 0.404903> }
        smooth_triangle {<-13.7744, -7.9786, 12.7555>, <0.534963, -0.501701, 0.333496>,
                         <-13.479, -7.23144, 13.2474>, <0.387927, -0.311591, 0.25823>,
                         <-13.8478, -7.3385, 13.8221>, <0.461945, -0.290102, 0.129252> }
        smooth_triangle {<-13.8478, -7.3385, 13.8221>, <0.514306, -0.339854, 0.181864>,
                         <-14.288, -8.12771, 13.5559>, <0.640493, -0.477817, 0.208702>,
                         <-13.7744, -7.9786, 12.7555>, <0.569069, -0.498553, 0.335047> }
        smooth_triangle {<-13.479, -7.23144, 13.2474>, <0.387927, -0.311591, 0.25823>,
                         <-13.2279, -6.44868, 13.7068>, <0.269053, -0.146766, 0.19108>,
                         <-13.4615, -6.51647, 14.0707>, <0.323379, -0.130994, 0.0933145> }
        smooth_triangle {<-13.4615, -6.51647, 14.0707>, <0.367289, -0.176672, 0.135428>,
                         <-13.8478, -7.3385, 13.8221>, <0.471214, -0.296003, 0.162382>,
                         <-13.479, -7.23144, 13.2474>, <0.4157, -0.31212, 0.259115> }
        smooth_triangle {<-13.2279, -6.44868, 13.7068>, <0.269053, -0.146766, 0.19108>,
                         <-13.2815, -5.55495, 13.9046>, <0.236376, 0.0345732, 0.202134>,
                         <-13.4568, -5.60584, 14.1778>, <0.293363, 0.0511177, 0.096188> }
        smooth_triangle {<-13.4568, -5.60584, 14.1778>, <0.304684, 0.0316636, 0.125224>,
                         <-13.4615, -6.51647, 14.0707>, <0.327196, -0.10492, 0.123069>,
                         <-13.2279, -6.44868, 13.7068>, <0.286452, -0.116749, 0.196392> }
        smooth_triangle {<-13.2815, -5.55495, 13.9046>, <0.236376, 0.0345732, 0.202134>,
                         <-13.6768, -4.71332, 13.7596>, <0.258821, 0.149384, 0.251477>,
                         <-13.8947, -4.7766, 14.0993>, <0.330026, 0.170057, 0.121277> }
        smooth_triangle {<-13.8947, -4.7766, 14.0993>, <0.303155, 0.160891, 0.13287>,
                         <-13.4568, -5.60584, 14.1778>, <0.275657, 0.0716873, 0.114054>,
                         <-13.2815, -5.55495, 13.9046>, <0.232917, 0.0592789, 0.193513> }
        smooth_triangle {<-13.6768, -4.71332, 13.7596>, <0.258821, 0.149384, 0.251477>,
                         <-14.0124, -3.84097, 13.6805>, <0.277882, 0.0917173, 0.260008>,
                         <-14.2536, -3.91101, 14.0565>, <0.35206, 0.113253, 0.128306> }
        smooth_triangle {<-14.2536, -3.91101, 14.0565>, <0.336875, 0.117752, 0.149076>,
                         <-13.8947, -4.7766, 14.0993>, <0.32035, 0.160355, 0.143804>,
                         <-13.6768, -4.71332, 13.7596>, <0.266946, 0.144851, 0.241454> }
        smooth_triangle {<-14.0124, -3.84097, 13.6805>, <0.277882, 0.0917173, 0.260008>,
                         <-14.1476, -2.91902, 13.8078>, <0.254443, 0.0120846, 0.219617>,
                         <-14.3514, -2.97818, 14.1254>, <0.317045, 0.0302594, 0.1081> }
        smooth_triangle {<-14.3514, -2.97818, 14.1254>, <0.32667, 0.0277267, 0.139049>,
                         <-14.2536, -3.91101, 14.0565>, <0.352931, 0.0899717, 0.154203>,
                         <-14.0124, -3.84097, 13.6805>, <0.297298, 0.0738201, 0.25298> }
        smooth_triangle {<-14.1476, -2.91902, 13.8078>, <0.254443, 0.0120846, 0.219617>,
                         <-14.3152, -2.00307, 13.9021>, <0.236747, 0.0948831, 0.216478>,
                         <-14.4912, -2.05417, 14.1764>, <0.29775, 0.112594, 0.102869> }
        smooth_triangle {<-14.4912, -2.05417, 14.1764>, <0.297436, 0.0929469, 0.126299>,
                         <-14.3514, -2.97818, 14.1254>, <0.311907, 0.0311963, 0.130223>,
                         <-14.1476, -2.91902, 13.8078>, <0.264955, 0.0175652, 0.21386> }
        smooth_triangle {<-14.3152, -2.00307, 13.9021>, <0.236747, 0.0948831, 0.216478>,
                         <-14.7968, -1.23867, 13.6528>, <0.258583, 0.175222, 0.260854>,
                         <-15.0462, -1.31108, 14.0415>, <0.332724, 0.196746, 0.127271> }
        smooth_triangle {<-15.0462, -1.31108, 14.0415>, <0.298776, 0.19156, 0.135242>,
                         <-14.4912, -2.05417, 14.1764>, <0.272546, 0.128446, 0.116941>,
                         <-14.3152, -2.00307, 13.9021>, <0.226793, 0.115163, 0.202147> }
        smooth_triangle {<-14.7968, -1.23867, 13.6528>, <0.258583, 0.175222, 0.260854>,
                         <-14.9942, -0.351755, 13.7105>, <0.256438, 0.0125105, 0.227486>,
                         <-15.2266, -0.419235, 14.0727>, <0.321783, 0.0314816, 0.114591> }
        smooth_triangle {<-15.2266, -0.419235, 14.0727>, <0.328573, 0.0391877, 0.144823>,
                         <-15.0462, -1.31108, 14.0415>, <0.336779, 0.163136, 0.154332>,
                         <-14.7968, -1.23867, 13.6528>, <0.281173, 0.146993, 0.25452> }
        smooth_triangle {<-14.9942, -0.351755, 13.7105>, <0.256438, 0.0125105, 0.227486>,
                         <-14.9669, 0.547873, 13.9875>, <0.204723, 0.00600548, 0.16964>,
                         <-15.1178, 0.504068, 14.2226>, <0.252573, 0.0198973, 0.0808486> }
        smooth_triangle {<-15.1178, 0.504068, 14.2226>, <0.275568, -0.00363929, 0.112452>,
                         <-15.2266, -0.419235, 14.0727>, <0.327476, 0.00504897, 0.137759>,
                         <-14.9942, -0.351755, 13.7105>, <0.278467, -0.00917937, 0.22243> }
        smooth_triangle {<-14.9669, 0.547873, 13.9875>, <0.204723, 0.00600548, 0.16964>,
                         <-15.3361, 1.3567, 13.8585>, <0.224712, 0.1642, 0.22256>,
                         <-15.525, 1.30187, 14.1528>, <0.287382, 0.182395, 0.105515> }
        smooth_triangle {<-15.525, 1.30187, 14.1528>, <0.26167, 0.163367, 0.113689>,
                         <-15.1178, 0.504068, 14.2226>, <0.235563, 0.0414935, 0.0951894>,
                         <-14.9669, 0.547873, 13.9875>, <0.199676, 0.0310747, 0.161783> }
        smooth_triangle {<-15.3361, 1.3567, 13.8585>, <0.224712, 0.1642, 0.22256>,
                         <-15.807, 2.1326, 13.6226>, <0.268766, 0.168143, 0.268883>,
                         <-16.0653, 2.0576, 14.0252>, <0.345287, 0.190359, 0.131701> }
        smooth_triangle {<-16.0653, 2.0576, 14.0252>, <0.312827, 0.188554, 0.141868>,
                         <-15.525, 1.30187, 14.1528>, <0.269398, 0.182581, 0.122228>,
                         <-15.3361, 1.3567, 13.8585>, <0.222396, 0.168935, 0.210011> }
        smooth_triangle {<-15.807, 2.1326, 13.6226>, <0.268766, 0.168143, 0.268883>,
                         <-15.969, 3.03306, 13.7181>, <0.23299, -0.0122618, 0.207451>,
                         <-16.1992, 2.96623, 14.0768>, <0.293123, 0.00519628, 0.107342> }
        smooth_triangle {<-16.1992, 2.96623, 14.0768>, <0.312254, 0.014033, 0.141694>,
                         <-16.0653, 2.0576, 14.0252>, <0.351377, 0.152905, 0.159963>,
                         <-15.807, 2.1326, 13.6226>, <0.293986, 0.136243, 0.262849> }
        smooth_triangle {<-15.969, 3.03306, 13.7181>, <0.23299, -0.0122618, 0.207451>,
                         <-15.7577, 3.84194, 14.1464>, <0.1256, -0.084234, 0.0971343>,
                         <-15.8618, 3.81173, 14.3087>, <0.154197, -0.0759317, 0.0525687> }
        smooth_triangle {<-15.8618, 3.81173, 14.3087>, <0.209068, -0.108747, 0.092409>,
                         <-16.1992, 2.96623, 14.0768>, <0.299545, -0.0396969, 0.123529>,
                         <-15.969, 3.03306, 13.7181>, <0.254445, -0.0527904, 0.198611> }
        smooth_triangle {<-13.2637, -8.97077, 10.8045>, <0.622322, -0.820329, 0.552141>,
                         <-13.1244, -8.37991, 11.5253>, <0.501305, -0.768448, 0.552326>,
                         <-14.1275, -8.67115, 12.2232>, <0.684758, -0.715187, 0.408039> }
        smooth_triangle {<-14.1275, -8.67115, 12.2232>, <0.706847, -0.791165, 0.477511>,
                         <-14.51, -9.33258, 11.6716>, <0.785691, -0.894173, 0.527428>,
                         <-13.2637, -8.97077, 10.8045>, <0.697718, -0.919714, 0.619034> }
        smooth_triangle {<-13.1244, -8.37991, 11.5253>, <0.501305, -0.768448, 0.552326>,
                         <-13.0057, -7.75544, 12.2206>, <0.385069, -0.545218, 0.451184>,
                         <-13.7744, -7.9786, 12.7555>, <0.534963, -0.501701, 0.333496> }
        smooth_triangle {<-13.7744, -7.9786, 12.7555>, <0.560818, -0.571365, 0.398098>,
                         <-14.1275, -8.67115, 12.2232>, <0.673164, -0.73148, 0.454005>,
                         <-13.1244, -8.37991, 11.5253>, <0.535574, -0.771425, 0.56222> }
        smooth_triangle {<-13.0057, -7.75544, 12.2206>, <0.385069, -0.545218, 0.451184>,
                         <-12.9271, -7.07121, 12.8634>, <0.272142, -0.345206, 0.347894>,
                         <-13.479, -7.23144, 13.2474>, <0.387927, -0.311591, 0.25823> }
        smooth_triangle {<-13.479, -7.23144, 13.2474>, <0.418291, -0.367729, 0.320772>,
                         <-13.7744, -7.9786, 12.7555>, <0.528567, -0.510312, 0.377221>,
                         <-13.0057, -7.75544, 12.2206>, <0.416147, -0.54295, 0.465488> }
        smooth_triangle {<-12.9271, -7.07121, 12.8634>, <0.272142, -0.345206, 0.347894>,
                         <-12.8784, -6.34722, 13.4637>, <0.182932, -0.171769, 0.259754>,
                         <-13.2279, -6.44868, 13.7068>, <0.269053, -0.146766, 0.19108> }
        smooth_triangle {<-13.2279, -6.44868, 13.7068>, <0.295334, -0.197562, 0.241251>,
                         <-13.479, -7.23144, 13.2474>, <0.384489, -0.321181, 0.291614>,
                         <-12.9271, -7.07121, 12.8634>, <0.297651, -0.346392, 0.358862> }
        smooth_triangle {<-12.8784, -6.34722, 13.4637>, <0.182932, -0.171769, 0.259754>,
                         <-13.0191, -5.47879, 13.7221>, <0.144791, 0.00798412, 0.277306>,
                         <-13.2815, -5.55495, 13.9046>, <0.236376, 0.0345732, 0.202134> }
        smooth_triangle {<-13.2815, -5.55495, 13.9046>, <0.236628, 0.0119055, 0.231044>,
                         <-13.2279, -6.44868, 13.7068>, <0.261136, -0.124099, 0.222753>,
                         <-12.8784, -6.34722, 13.4637>, <0.196545, -0.142851, 0.27426> }
        smooth_triangle {<-13.0191, -5.47879, 13.7221>, <0.144791, 0.00798412, 0.277306>,
                         <-13.3505, -4.61861, 13.5327>, <0.145186, 0.116394, 0.343392>,
                         <-13.6768, -4.71332, 13.7596>, <0.258821, 0.149384, 0.251477> }
        smooth_triangle {<-13.6768, -4.71332, 13.7596>, <0.229762, 0.139584, 0.251335>,
                         <-13.2815, -5.55495, 13.9046>, <0.212928, 0.0534757, 0.214327>,
                         <-13.0191, -5.47879, 13.7221>, <0.14424, 0.0335339, 0.270706> }
        smooth_triangle {<-13.3505, -4.61861, 13.5327>, <0.145186, 0.116394, 0.343392>,
                         <-13.6513, -3.73614, 13.4293>, <0.16095, 0.0577692, 0.352126>,
                         <-14.0124, -3.84097, 13.6805>, <0.277882, 0.0917173, 0.260008> }
        smooth_triangle {<-14.0124, -3.84097, 13.6805>, <0.256039, 0.0942833, 0.274096>,
                         <-13.6768, -4.71332, 13.7596>, <0.241742, 0.137533, 0.267698>,
                         <-13.3505, -4.61861, 13.5327>, <0.156516, 0.11279, 0.336635> }
        smooth_triangle {<-13.6513, -3.73614, 13.4293>, <0.16095, 0.0577692, 0.352126>,
                         <-13.8426, -2.83047, 13.5955>, <0.155623, -0.0166051, 0.297699>,
                         <-14.1476, -2.91902, 13.8078>, <0.254443, 0.0120846, 0.219617> }
        smooth_triangle {<-14.1476, -2.91902, 13.8078>, <0.25207, 0.00606861, 0.251477>,
                         <-14.0124, -3.84097, 13.6805>, <0.269649, 0.0657931, 0.28177>,
                         <-13.6513, -3.73614, 13.4293>, <0.181949, 0.040332, 0.350859> }
        smooth_triangle {<-13.8426, -2.83047, 13.5955>, <0.155623, -0.0166051, 0.297699>,
                         <-14.0518, -1.92659, 13.7189>, <0.138635, 0.0663991, 0.29713>,
                         <-14.3152, -2.00307, 13.9021>, <0.236747, 0.0948831, 0.216478> }
        smooth_triangle {<-14.3152, -2.00307, 13.9021>, <0.228245, 0.0728591, 0.235913>,
                         <-14.1476, -2.91902, 13.8078>, <0.241516, 0.0107603, 0.238267>,
                         <-13.8426, -2.83047, 13.5955>, <0.167401, -0.010757, 0.296829> }
        smooth_triangle {<-14.0518, -1.92659, 13.7189>, <0.138635, 0.0663991, 0.29713>,
                         <-14.4235, -1.13029, 13.393>, <0.140992, 0.141082, 0.354724>,
                         <-14.7968, -1.23867, 13.6528>, <0.258583, 0.175222, 0.260854> }
        smooth_triangle {<-14.7968, -1.23867, 13.6528>, <0.224194, 0.169907, 0.255189>,
                         <-14.3152, -2.00307, 13.9021>, <0.207817, 0.109653, 0.221907>,
                         <-14.0518, -1.92659, 13.7189>, <0.134234, 0.0882905, 0.282396> }
        smooth_triangle {<-14.4235, -1.13029, 13.393>, <0.140992, 0.141082, 0.354724>,
                         <-14.6463, -0.250764, 13.4685>, <0.154578, -0.0170619, 0.305747>,
                         <-14.9942, -0.351755, 13.7105>, <0.256438, 0.0125105, 0.227486> }
        smooth_triangle {<-14.9942, -0.351755, 13.7105>, <0.251484, 0.016807, 0.258734>,
                         <-14.7968, -1.23867, 13.6528>, <0.253092, 0.13884, 0.28376>,
                         <-14.4235, -1.13029, 13.393>, <0.164899, 0.113236, 0.354162> }
        smooth_triangle {<-14.6463, -0.250764, 13.4685>, <0.154578, -0.0170619, 0.305747>,
                         <-14.7411, 0.613431, 13.8304>, <0.127885, -0.0163025, 0.232605>,
                         <-14.9669, 0.547873, 13.9875>, <0.204723, 0.00600548, 0.16964> }
        smooth_triangle {<-14.9669, 0.547873, 13.9875>, <0.21497, -0.0212325, 0.204778>,
                         <-14.9942, -0.351755, 13.7105>, <0.253756, -0.0163537, 0.248162>,
                         <-14.6463, -0.250764, 13.4685>, <0.17736, -0.038533, 0.306858> }
        smooth_triangle {<-14.7411, 0.613431, 13.8304>, <0.127885, -0.0163025, 0.232605>,
                         <-15.0534, 1.43877, 13.6618>, <0.123797, 0.134903, 0.305721>,
                         <-15.3361, 1.3567, 13.8585>, <0.224712, 0.1642, 0.22256> }
        smooth_triangle {<-15.3361, 1.3567, 13.8585>, <0.198189, 0.144937, 0.218632>,
                         <-14.9669, 0.547873, 13.9875>, <0.183197, 0.0262905, 0.178942>,
                         <-14.7411, 0.613431, 13.8304>, <0.125568, 0.00955952, 0.226166> }
        smooth_triangle {<-15.0534, 1.43877, 13.6618>, <0.123797, 0.134903, 0.305721>,
                         <-15.4204, 2.24483, 13.3536>, <0.147654, 0.132982, 0.365129>,
                         <-15.807, 2.1326, 13.6226>, <0.268766, 0.168143, 0.268883> }
        smooth_triangle {<-15.807, 2.1326, 13.6226>, <0.234885, 0.165926, 0.266153>,
                         <-15.3361, 1.3567, 13.8585>, <0.201845, 0.162969, 0.231411>,
                         <-15.0534, 1.43877, 13.6618>, <0.126159, 0.140996, 0.293782> }
        smooth_triangle {<-15.4204, 2.24483, 13.3536>, <0.147654, 0.132982, 0.365129>,
                         <-15.6244, 3.13308, 13.4784>, <0.140643, -0.0390721, 0.275977>,
                         <-15.969, 3.03306, 13.7181>, <0.23299, -0.0122618, 0.207451> }
        smooth_triangle {<-15.969, 3.03306, 13.7181>, <0.237973, -0.00753245, 0.247162>,
                         <-15.807, 2.1326, 13.6226>, <0.264805, 0.127771, 0.293235>,
                         <-15.4204, 2.24483, 13.3536>, <0.173971, 0.1014, 0.36542> }
        smooth_triangle {<-15.6244, 3.13308, 13.4784>, <0.140643, -0.0390721, 0.275977>,
                         <-15.602, 3.88717, 14.0381>, <0.0828016, -0.0966594, 0.126912>,
                         <-15.7577, 3.84194, 14.1464>, <0.1256, -0.084234, 0.0971343> }
        smooth_triangle {<-15.7577, 3.84194, 14.1464>, <0.162646, -0.122224, 0.150606>,
                         <-15.969, 3.03306, 13.7181>, <0.233927, -0.0587472, 0.219976>,
                         <-15.6244, 3.13308, 13.4784>, <0.164667, -0.078855, 0.27137> }
        smooth_triangle {<-11.7937, -8.54399, 10.5>, <0.392436, -0.88707, 0.651295>,
                         <-11.9411, -8.03637, 11.2802>, <0.278789, -0.833049, 0.612526>,
                         <-13.1244, -8.37991, 11.5253>, <0.501305, -0.768448, 0.552326> }
        smooth_triangle {<-13.1244, -8.37991, 11.5253>, <0.49786, -0.851838, 0.616521>,
                         <-13.2637, -8.97077, 10.8045>, <0.554923, -0.96117, 0.680624>,
                         <-11.7937, -8.54399, 10.5>, <0.43998, -0.994541, 0.7302> }
        smooth_triangle {<-11.9411, -8.03637, 11.2802>, <0.278789, -0.833049, 0.612526>,
                         <-12.099, -7.4922, 12.0328>, <0.203334, -0.59798, 0.500184>,
                         <-13.0057, -7.75544, 12.2206>, <0.385069, -0.545218, 0.451184> }
        smooth_triangle {<-13.0057, -7.75544, 12.2206>, <0.386787, -0.62189, 0.512937>,
                         <-13.1244, -8.37991, 11.5253>, <0.473964, -0.789312, 0.588793>,
                         <-11.9411, -8.03637, 11.2802>, <0.307077, -0.837763, 0.633944> }
        smooth_triangle {<-12.099, -7.4922, 12.0328>, <0.203334, -0.59798, 0.500184>,
                         <-12.2761, -6.88221, 12.7286>, <0.132219, -0.385829, 0.384595>,
                         <-12.9271, -7.07121, 12.8634>, <0.272142, -0.345206, 0.347894> }
        smooth_triangle {<-12.9271, -7.07121, 12.8634>, <0.278534, -0.408304, 0.410845>,
                         <-13.0057, -7.75544, 12.2206>, <0.363229, -0.558313, 0.488312>,
                         <-12.099, -7.4922, 12.0328>, <0.226928, -0.597885, 0.525062> }
        smooth_triangle {<-12.2761, -6.88221, 12.7286>, <0.132219, -0.385829, 0.384595>,
                         <-12.4662, -6.22753, 13.3783>, <0.078129, -0.202196, 0.288884>,
                         <-12.8784, -6.34722, 13.4637>, <0.182932, -0.171769, 0.259754> }
        smooth_triangle {<-12.8784, -6.34722, 13.4637>, <0.189965, -0.228153, 0.310346>,
                         <-12.9271, -7.07121, 12.8634>, <0.256873, -0.358231, 0.376451>,
                         <-12.2761, -6.88221, 12.7286>, <0.15193, -0.388698, 0.403976> }
        smooth_triangle {<-12.4662, -6.22753, 13.3783>, <0.078129, -0.202196, 0.288884>,
                         <-12.7097, -5.38894, 13.658>, <0.0325513, -0.0246016, 0.310261>,
                         <-13.0191, -5.47879, 13.7221>, <0.144791, 0.00798412, 0.277306> }
        smooth_triangle {<-13.0191, -5.47879, 13.7221>, <0.134863, -0.0176393, 0.30169>,
                         <-12.8784, -6.34722, 13.4637>, <0.163469, -0.152454, 0.288526>,
                         <-12.4662, -6.22753, 13.3783>, <0.0848661, -0.175274, 0.310373> }
        smooth_triangle {<-12.7097, -5.38894, 13.658>, <0.0325513, -0.0246016, 0.310261>,
                         <-12.9657, -4.50689, 13.453>, <0.00642169, 0.0761072, 0.383029>,
                         <-13.3505, -4.61861, 13.5327>, <0.145186, 0.116394, 0.343392> }
        smooth_triangle {<-13.3505, -4.61861, 13.5327>, <0.118419, 0.107259, 0.331535>,
                         <-13.0191, -5.47879, 13.7221>, <0.118123, 0.0259516, 0.281971>,
                         <-12.7097, -5.38894, 13.658>, <0.0339431, 0.00151235, 0.306687> }
        smooth_triangle {<-12.9657, -4.50689, 13.453>, <0.00642169, 0.0761072, 0.383029>,
                         <-13.2254, -3.61249, 13.3411>, <0.0190636, 0.0165766, 0.390636>,
                         <-13.6513, -3.73614, 13.4293>, <0.16095, 0.0577692, 0.352126> }
        smooth_triangle {<-13.6513, -3.73614, 13.4293>, <0.135409, 0.059262, 0.357388>,
                         <-13.3505, -4.61861, 13.5327>, <0.123587, 0.10323, 0.350838>,
                         <-12.9657, -4.50689, 13.453>, <0.0195134, 0.0730155, 0.380565> }
        smooth_triangle {<-13.2254, -3.61249, 13.3411>, <0.0190636, 0.0165766, 0.390636>,
                         <-13.4828, -2.72601, 13.521>, <0.0356289, -0.0514419, 0.330459>,
                         <-13.8426, -2.83047, 13.5955>, <0.155623, -0.0166051, 0.297699> }
        smooth_triangle {<-13.8426, -2.83047, 13.5955>, <0.14183, -0.0259364, 0.32562>,
                         <-13.6513, -3.73614, 13.4293>, <0.145825, 0.0298442, 0.36644>,
                         <-13.2254, -3.61249, 13.3411>, <0.0394104, -0.00105023, 0.395322> }
        smooth_triangle {<-13.4828, -2.72601, 13.521>, <0.0356289, -0.0514419, 0.330459>,
                         <-13.7411, -1.83638, 13.6545>, <0.0183517, 0.0314781, 0.332546>,
                         <-14.0518, -1.92659, 13.7189>, <0.138635, 0.0663991, 0.29713> }
        smooth_triangle {<-14.0518, -1.92659, 13.7189>, <0.124036, 0.0426051, 0.309611>,
                         <-13.8426, -2.83047, 13.5955>, <0.136777, -0.019648, 0.310038>,
                         <-13.4828, -2.72601, 13.521>, <0.0467812, -0.0457756, 0.334608> }
        smooth_triangle {<-13.7411, -1.83638, 13.6545>, <0.0183517, 0.0314781, 0.332546>,
                         <-13.9832, -1.00244, 13.3018>, <-0.0021457, 0.0995264, 0.394591>,
                         <-14.4235, -1.13029, 13.393>, <0.140992, 0.141082, 0.354724> }
        smooth_triangle {<-14.4235, -1.13029, 13.393>, <0.111208, 0.137105, 0.336285>,
                         <-14.0518, -1.92659, 13.7189>, <0.10944, 0.0810924, 0.293089>,
                         <-13.7411, -1.83638, 13.6545>, <0.0192276, 0.0549017, 0.319652> }
        smooth_triangle {<-13.9832, -1.00244, 13.3018>, <-0.0021457, 0.0995264, 0.394591>,
                         <-14.236, -0.131638, 13.3835>, <0.0317087, -0.0527335, 0.337462>,
                         <-14.6463, -0.250764, 13.4685>, <0.154578, -0.0170619, 0.305747> }
        smooth_triangle {<-14.6463, -0.250764, 13.4685>, <0.1384, -0.0160239, 0.333254>,
                         <-14.4235, -1.13029, 13.393>, <0.12821, 0.102584, 0.369987>,
                         <-13.9832, -1.00244, 13.3018>, <0.0208572, 0.0714173, 0.399887> }
        smooth_triangle {<-14.236, -0.131638, 13.3835>, <0.0317087, -0.0527335, 0.337462>,
                         <-14.4747, 0.690763, 13.7752>, <0.0337544, -0.0436306, 0.260159>,
                         <-14.7411, 0.613431, 13.8304>, <0.127885, -0.0163025, 0.232605> }
        smooth_triangle {<-14.7411, 0.613431, 13.8304>, <0.125053, -0.0473372, 0.265928>,
                         <-14.6463, -0.250764, 13.4685>, <0.145073, -0.0479067, 0.320784>,
                         <-14.236, -0.131638, 13.3835>, <0.0529214, -0.0746604, 0.34457> }
        smooth_triangle {<-14.4747, 0.690763, 13.7752>, <0.0337544, -0.0436306, 0.260159>,
                         <-14.72, 1.53557, 13.5927>, <1.48178e-06, 0.0989619, 0.34234>,
                         <-15.0534, 1.43877, 13.6618>, <0.123797, 0.134903, 0.305721> }
        smooth_triangle {<-15.0534, 1.43877, 13.6618>, <0.100972, 0.116713, 0.29029>,
                         <-14.7411, 0.613431, 13.8304>, <0.104037, 0.00330873, 0.235453>,
                         <-14.4747, 0.690763, 13.7752>, <0.0334399, -0.0171873, 0.256118> }
        smooth_triangle {<-14.72, 1.53557, 13.5927>, <1.48178e-06, 0.0989619, 0.34234>,
                         <-14.9644, 2.37722, 13.2592>, <0.000389418, 0.0902275, 0.405788>,
                         <-15.4204, 2.24483, 13.3536>, <0.147654, 0.132982, 0.365129> }
        smooth_triangle {<-15.4204, 2.24483, 13.3536>, <0.1172, 0.131759, 0.349919>,
                         <-15.0534, 1.43877, 13.6618>, <0.0993074, 0.1332, 0.305363>,
                         <-14.72, 1.53557, 13.5927>, <0.00646064, 0.106245, 0.332827> }
        smooth_triangle {<-14.9644, 2.37722, 13.2592>, <0.000389418, 0.0902275, 0.405788>,
                         <-15.2181, 3.25106, 13.3942>, <0.0301415, -0.071153, 0.302488>,
                         <-15.6244, 3.13308, 13.4784>, <0.140643, -0.0390721, 0.275977> }
        smooth_triangle {<-15.6244, 3.13308, 13.4784>, <0.130586, -0.0387093, 0.315001>,
                         <-15.4204, 2.24483, 13.3536>, <0.135844, 0.0903309, 0.381865>,
                         <-14.9644, 2.37722, 13.2592>, <0.0253959, 0.0582654, 0.412359> }
        smooth_triangle {<-15.2181, 3.25106, 13.3942>, <0.0301415, -0.071153, 0.302488>,
                         <-15.4182, 3.94052, 14>, <0.0323175, -0.111316, 0.137369>,
                         <-15.602, 3.88717, 14.0381>, <0.0828016, -0.0966594, 0.126912> }
        smooth_triangle {<-15.602, 3.88717, 14.0381>, <0.0983698, -0.140885, 0.185875>,
                         <-15.6244, 3.13308, 13.4784>, <0.137859, -0.0866379, 0.282933>,
                         <-15.2181, 3.25106, 13.3942>, <0.0549827, -0.110699, 0.302817> }
        smooth_triangle {<-10.3237, -8.1172, 10.8045>, <0.143609, -0.95931, 0.651295>,
                         <-10.7577, -7.69283, 11.5253>, <0.0510874, -0.899156, 0.579475>,
                         <-11.9411, -8.03637, 11.2802>, <0.278789, -0.833049, 0.612526> }
        smooth_triangle {<-11.9411, -8.03637, 11.2802>, <0.253693, -0.922725, 0.661671>,
                         <-11.7937, -8.54399, 10.5>, <0.285421, -1.03941, 0.7302>,
                         <-10.3237, -8.1172, 10.8045>, <0.161008, -1.07553, 0.7302> }
        smooth_triangle {<-10.7577, -7.69283, 11.5253>, <0.0510874, -0.899156, 0.579475>,
                         <-11.1923, -7.22896, 12.2206>, <0.0174257, -0.651953, 0.473035>,
                         <-12.099, -7.4922, 12.0328>, <0.203334, -0.59798, 0.500184> }
        smooth_triangle {<-12.099, -7.4922, 12.0328>, <0.1838, -0.680822, 0.549687>,
                         <-11.9411, -8.03637, 11.2802>, <0.240391, -0.857124, 0.633944>,
                         <-10.7577, -7.69283, 11.5253>, <0.0696145, -0.906704, 0.609155> }
        smooth_triangle {<-11.1923, -7.22896, 12.2206>, <0.0174257, -0.651953, 0.473035>,
                         <-11.6251, -6.69321, 12.8634>, <-0.0105416, -0.427275, 0.362744>,
                         <-12.2761, -6.88221, 12.7286>, <0.132219, -0.385829, 0.384595> }
        smooth_triangle {<-12.2761, -6.88221, 12.7286>, <0.116313, -0.4554, 0.43837>,
                         <-12.099, -7.4922, 12.0328>, <0.16965, -0.614514, 0.525062>,
                         <-11.1923, -7.22896, 12.2206>, <0.030218, -0.654994, 0.5047> }
        smooth_triangle {<-11.6251, -6.69321, 12.8634>, <-0.0105416, -0.427275, 0.362744>,
                         <-12.054, -6.10785, 13.4637>, <-0.0294022, -0.233414, 0.274034>,
                         <-12.4662, -6.22753, 13.3783>, <0.078129, -0.202196, 0.288884> }
        smooth_triangle {<-12.4662, -6.22753, 13.3783>, <0.0672244, -0.263787, 0.332193>,
                         <-12.2761, -6.88221, 12.7286>, <0.107792, -0.401512, 0.403976>,
                         <-11.6251, -6.69321, 12.8634>, <0.000721466, -0.432597, 0.387588> }
        smooth_triangle {<-12.054, -6.10785, 13.4637>, <-0.0294022, -0.233414, 0.274034>,
                         <-12.4002, -5.2991, 13.7221>, <-0.0832562, -0.0582231, 0.295982>,
                         <-12.7097, -5.38894, 13.658>, <0.0325513, -0.0246016, 0.310261> }
        smooth_triangle {<-12.7097, -5.38894, 13.658>, <0.0148808, -0.0524727, 0.326406>,
                         <-12.4662, -6.22753, 13.3783>, <0.0490641, -0.185668, 0.310373>,
                         <-12.054, -6.10785, 13.4637>, <-0.0315843, -0.209082, 0.299236> }
        smooth_triangle {<-12.4002, -5.2991, 13.7221>, <-0.0832562, -0.0582231, 0.295982>,
                         <-12.5809, -4.39518, 13.5327>, <-0.136347, 0.0346583, 0.364353>,
                         <-12.9657, -4.50689, 13.453>, <0.00642169, 0.0761072, 0.383029> }
        smooth_triangle {<-12.9657, -4.50689, 13.453>, <-0.0139225, 0.068837, 0.361263>,
                         <-12.7097, -5.38894, 13.658>, <0.00567475, -0.00669459, 0.306687>,
                         <-12.4002, -5.2991, 13.7221>, <-0.0811809, -0.0319107, 0.295978> }
        smooth_triangle {<-12.5809, -4.39518, 13.5327>, <-0.136347, 0.0346583, 0.364353>,
                         <-12.7995, -3.48884, 13.4293>, <-0.126175, -0.0255893, 0.369675>,
                         <-13.2254, -3.61249, 13.3411>, <0.0190636, 0.0165766, 0.390636> }
        smooth_triangle {<-13.2254, -3.61249, 13.3411>, <-0.00664788, 0.0180197, 0.386271>,
                         <-12.9657, -4.50689, 13.453>, <-0.0161293, 0.0626676, 0.380565>,
                         <-12.5809, -4.39518, 13.5327>, <-0.123206, 0.031581, 0.366558> }
        smooth_triangle {<-12.7995, -3.48884, 13.4293>, <-0.126175, -0.0255893, 0.369675>,
                         <-13.123, -2.62156, 13.5955>, <-0.0872705, -0.0871223, 0.31291>,
                         <-13.4828, -2.72601, 13.521>, <0.0356289, -0.0514419, 0.330459> }
        smooth_triangle {<-13.4828, -2.72601, 13.521>, <0.0127333, -0.063416, 0.35019>,
                         <-13.2254, -3.61249, 13.3411>, <0.000309379, -0.0124021, 0.395322>,
                         <-12.7995, -3.48884, 13.4293>, <-0.108619, -0.0440265, 0.379602> }
        smooth_triangle {<-13.123, -2.62156, 13.5955>, <-0.0872705, -0.0871223, 0.31291>,
                         <-13.4303, -1.74617, 13.7189>, <-0.105792, -0.00456351, 0.317336>,
                         <-13.7411, -1.83638, 13.6545>, <0.0183517, 0.0314781, 0.332546> }
        smooth_triangle {<-13.7411, -1.83638, 13.6545>, <0.000675414, 0.00679079, 0.336173>,
                         <-13.4828, -2.72601, 13.521>, <0.0136333, -0.0553992, 0.334608>,
                         <-13.123, -2.62156, 13.5955>, <-0.0785412, -0.0821595, 0.321446> }
        smooth_triangle {<-13.4303, -1.74617, 13.7189>, <-0.105792, -0.00456351, 0.317336>,
                         <-13.5428, -0.874603, 13.393>, <-0.149039, 0.05688, 0.374385>,
                         <-13.9832, -1.00244, 13.3018>, <-0.0021457, 0.0995264, 0.394591> }
        smooth_triangle {<-13.9832, -1.00244, 13.3018>, <-0.0229814, 0.0981468, 0.366185>,
                         <-13.7411, -1.83638, 13.6545>, <-0.00760836, 0.0471106, 0.319652>,
                         <-13.4303, -1.74617, 13.7189>, <-0.100716, 0.0200794, 0.308244> }
        smooth_triangle {<-13.5428, -0.874603, 13.393>, <-0.149039, 0.05688, 0.374385>,
                         <-13.8257, -0.012511, 13.4685>, <-0.0934627, -0.0890735, 0.317801>,
                         <-14.236, -0.131638, 13.3835>, <0.0317087, -0.0527335, 0.337462> }
        smooth_triangle {<-14.236, -0.131638, 13.3835>, <0.00653626, -0.0543067, 0.35704>,
                         <-13.9832, -1.00244, 13.3018>, <-0.0188545, 0.0598881, 0.399887>,
                         <-13.5428, -0.874603, 13.393>, <-0.129025, 0.0279033, 0.384733> }
        smooth_triangle {<-13.8257, -0.012511, 13.4685>, <-0.0934627, -0.0890735, 0.317801>,
                         <-14.2084, 0.768095, 13.8304>, <-0.0633365, -0.0718182, 0.248105>,
                         <-14.4747, 0.690763, 13.7752>, <0.0337544, -0.0436306, 0.260159> }
        smooth_triangle {<-14.4747, 0.690763, 13.7752>, <0.0195082, -0.0779792, 0.286593>,
                         <-14.236, -0.131638, 13.3835>, <0.0179739, -0.0848064, 0.34457>,
                         <-13.8257, -0.012511, 13.4685>, <-0.0759047, -0.112061, 0.329824> }
        smooth_triangle {<-14.2084, 0.768095, 13.8304>, <-0.0633365, -0.0718182, 0.248105>,
                         <-14.3866, 1.63238, 13.6618>, <-0.127828, 0.06185, 0.32684>,
                         <-14.72, 1.53557, 13.5927>, <1.48178e-06, 0.0989619, 0.34234> }
        smooth_triangle {<-14.72, 1.53557, 13.5927>, <-0.0151793, 0.0829912, 0.317753>,
                         <-14.4747, 0.690763, 13.7752>, <0.0101354, -0.0239531, 0.256118>,
                         <-14.2084, 0.768095, 13.8304>, <-0.0626828, -0.0450939, 0.247077> }
        smooth_triangle {<-14.3866, 1.63238, 13.6618>, <-0.127828, 0.06185, 0.32684>,
                         <-14.5083, 2.50962, 13.3536>, <-0.150607, 0.0463898, 0.384669>,
                         <-14.9644, 2.37722, 13.2592>, <0.000389418, 0.0902275, 0.405788> }
        smooth_triangle {<-14.9644, 2.37722, 13.2592>, <-0.0223118, 0.091256, 0.380413>,
                         <-14.72, 1.53557, 13.5927>, <-0.0226028, 0.0978068, 0.332827>,
                         <-14.3866, 1.63238, 13.6618>, <-0.118475, 0.0699729, 0.321203> }
        smooth_triangle {<-14.5083, 2.50962, 13.3536>, <-0.150607, 0.0463898, 0.384669>,
                         <-14.8117, 3.36905, 13.4784>, <-0.0816914, -0.103621, 0.282948>,
                         <-15.2181, 3.25106, 13.3942>, <0.0301415, -0.071153, 0.302488> }
        smooth_triangle {<-15.2181, 3.25106, 13.3942>, <0.0064417, -0.0747511, 0.334884>,
                         <-14.9644, 2.37722, 13.2592>, <-0.0158723, 0.0462843, 0.412359>,
                         <-14.5083, 2.50962, 13.3536>, <-0.12912, 0.013406, 0.39652> }
        smooth_triangle {<-14.8117, 3.36905, 13.4784>, <-0.0816914, -0.103621, 0.282948>,
                         <-15.2345, 3.99387, 14.0381>, <-0.0181666, -0.125973, 0.126912>,
                         <-15.4182, 3.94052, 14>, <0.0323175, -0.111316, 0.137369> }
        smooth_triangle {<-15.4182, 3.94052, 14>, <0.0260247, -0.161888, 0.192846>,
                         <-15.2181, 3.25106, 13.3942>, <0.0259659, -0.119123, 0.302817>,
                         <-14.8117, 3.36905, 13.4784>, <-0.0579088, -0.143474, 0.288161> }
        smooth_triangle {<-9.07742, -7.75539, 11.6716>, <-0.086277, -1.02605, 0.552141>,
                         <-9.75459, -7.40159, 12.2232>, <-0.147135, -0.956704, 0.458204>,
                         <-10.7577, -7.69283, 11.5253>, <0.0510874, -0.899156, 0.579475> }
        smooth_triangle {<-10.7577, -7.69283, 11.5253>, <0.01152, -0.993034, 0.606088>,
                         <-10.3237, -8.1172, 10.8045>, <0.0182134, -1.11699, 0.668611>,
                         <-9.07742, -7.75539, 11.6716>, <-0.0967296, -1.15036, 0.619034> }
        smooth_triangle {<-9.75459, -7.40159, 12.2232>, <-0.147135, -0.956704, 0.458204>,
                         <-10.4237, -7.0058, 12.7555>, <-0.144354, -0.698922, 0.37387>,
                         <-11.1923, -7.22896, 12.2206>, <0.0174257, -0.651953, 0.473035> }
        smooth_triangle {<-11.1923, -7.22896, 12.2206>, <-0.017242, -0.739189, 0.502752>,
                         <-10.7577, -7.69283, 11.5253>, <0.00800428, -0.92459, 0.582582>,
                         <-9.75459, -7.40159, 12.2232>, <-0.140662, -0.967752, 0.491628> }
        smooth_triangle {<-10.4237, -7.0058, 12.7555>, <-0.144354, -0.698922, 0.37387>,
                         <-11.0732, -6.53298, 13.2474>, <-0.134405, -0.463235, 0.28567>,
                         <-11.6251, -6.69321, 12.8634>, <-0.0105416, -0.427275, 0.362744> }
        smooth_triangle {<-11.6251, -6.69321, 12.8634>, <-0.0436759, -0.501848, 0.399158>,
                         <-11.1923, -7.22896, 12.2206>, <-0.0227004, -0.670357, 0.481875>,
                         <-10.4237, -7.0058, 12.7555>, <-0.144035, -0.705583, 0.407502> }
        smooth_triangle {<-11.0732, -6.53298, 13.2474>, <-0.134405, -0.463235, 0.28567>,
                         <-11.7045, -6.00639, 13.7068>, <-0.12329, -0.260672, 0.217464>,
                         <-12.054, -6.10785, 13.4637>, <-0.0294022, -0.233414, 0.274034> }
        smooth_triangle {<-12.054, -6.10785, 13.4637>, <-0.0542024, -0.29904, 0.303467>,
                         <-11.6251, -6.69321, 12.8634>, <-0.0400569, -0.444436, 0.37>,
                         <-11.0732, -6.53298, 13.2474>, <-0.132954, -0.471406, 0.312194> }
        smooth_triangle {<-11.7045, -6.00639, 13.7068>, <-0.12329, -0.260672, 0.217464>,
                         <-12.1379, -5.22294, 13.9046>, <-0.185001, -0.0877617, 0.236642>,
                         <-12.4002, -5.2991, 13.7221>, <-0.0832562, -0.0582231, 0.295982> }
        smooth_triangle {<-12.4002, -5.2991, 13.7221>, <-0.105052, -0.0872917, 0.30143>,
                         <-12.054, -6.10785, 13.4637>, <-0.064661, -0.218685, 0.284969>,
                         <-11.7045, -6.00639, 13.7068>, <-0.135077, -0.239129, 0.242542> }
        smooth_triangle {<-12.1379, -5.22294, 13.9046>, <-0.185001, -0.0877617, 0.236642>,
                         <-12.2547, -4.30047, 13.7596>, <-0.261384, -0.00164272, 0.290207>,
                         <-12.5809, -4.39518, 13.5327>, <-0.136347, 0.0346583, 0.364353> }
        smooth_triangle {<-12.5809, -4.39518, 13.5327>, <-0.147115, 0.0301681, 0.335991>,
                         <-12.4002, -5.2991, 13.7221>, <-0.107297, -0.0394929, 0.284713>,
                         <-12.1379, -5.22294, 13.9046>, <-0.183606, -0.0616469, 0.240209> }
        smooth_triangle {<-12.2547, -4.30047, 13.7596>, <-0.261384, -0.00164272, 0.290207>,
                         <-12.4384, -3.38401, 13.6805>, <-0.252654, -0.0623091, 0.292435>,
                         <-12.7995, -3.48884, 13.4293>, <-0.126175, -0.0255893, 0.369675> }
        smooth_triangle {<-12.7995, -3.48884, 13.4293>, <-0.148506, -0.0231649, 0.356347>,
                         <-12.5809, -4.39518, 13.5327>, <-0.156135, 0.0220208, 0.352355>,
                         <-12.2547, -4.30047, 13.7596>, <-0.249913, -0.00520499, 0.296746> }
        smooth_triangle {<-12.4384, -3.38401, 13.6805>, <-0.252654, -0.0623091, 0.292435>,
                         <-12.818, -2.53301, 13.8078>, <-0.194365, -0.118214, 0.247723>,
                         <-13.123, -2.62156, 13.5955>, <-0.0872705, -0.0871223, 0.31291> }
        smooth_triangle {<-13.123, -2.62156, 13.5955>, <-0.115566, -0.100664, 0.321447>,
                         <-12.7995, -3.48884, 13.4293>, <-0.144744, -0.0545143, 0.364021>,
                         <-12.4384, -3.38401, 13.6805>, <-0.239604, -0.0820541, 0.30609> }
        smooth_triangle {<-12.818, -2.53301, 13.8078>, <-0.194365, -0.118214, 0.247723>,
                         <-13.1669, -1.66969, 13.9021>, <-0.214895, -0.0362387, 0.253814>,
                         <-13.4303, -1.74617, 13.7189>, <-0.105792, -0.00456351, 0.317336> }
        smooth_triangle {<-13.4303, -1.74617, 13.7189>, <-0.123057, -0.0291314, 0.311556>,
                         <-13.123, -2.62156, 13.5955>, <-0.109166, -0.0910505, 0.308237>,
                         <-12.818, -2.53301, 13.8078>, <-0.189487, -0.114369, 0.259346> }
        smooth_triangle {<-13.1669, -1.66969, 13.9021>, <-0.214895, -0.0362387, 0.253814>,
                         <-13.1695, -0.766224, 13.6528>, <-0.277325, 0.0196357, 0.297182>,
                         <-13.5428, -0.874603, 13.393>, <-0.149039, 0.05688, 0.374385> }
        smooth_triangle {<-13.5428, -0.874603, 13.393>, <-0.157945, 0.058964, 0.340337>,
                         <-13.4303, -1.74617, 13.7189>, <-0.125509, 0.0128814, 0.29755>,
                         <-13.1669, -1.66969, 13.9021>, <-0.207337, -0.010875, 0.249909> }
        smooth_triangle {<-13.1695, -0.766224, 13.6528>, <-0.277325, 0.0196357, 0.297182>,
                         <-13.4778, 0.0884797, 13.7105>, <-0.20188, -0.12055, 0.249758>,
                         <-13.8257, -0.012511, 13.4685>, <-0.0934627, -0.0890735, 0.317801> }
        smooth_triangle {<-13.8257, -0.012511, 13.4685>, <-0.124031, -0.0922133, 0.32647>,
                         <-13.5428, -0.874603, 13.393>, <-0.165713, 0.0172518, 0.368908>,
                         <-13.1695, -0.766224, 13.6528>, <-0.261928, -0.0106814, 0.311006> }
        smooth_triangle {<-13.4778, 0.0884797, 13.7105>, <-0.20188, -0.12055, 0.249758>,
                         <-13.9826, 0.833653, 13.9875>, <-0.148607, -0.0965742, 0.19828>,
                         <-14.2084, 0.768095, 13.8304>, <-0.0633365, -0.0718182, 0.248105> }
        smooth_triangle {<-14.2084, 0.768095, 13.8304>, <-0.0855973, -0.108494, 0.263626>,
                         <-13.8257, -0.012511, 13.4685>, <-0.108192, -0.121435, 0.315898>,
                         <-13.4778, 0.0884797, 13.7105>, <-0.189505, -0.145042, 0.264866> }
        smooth_triangle {<-13.9826, 0.833653, 13.9875>, <-0.148607, -0.0965742, 0.19828>,
                         <-14.1039, 1.71444, 13.8585>, <-0.240232, 0.0292169, 0.261582>,
                         <-14.3866, 1.63238, 13.6618>, <-0.127828, 0.06185, 0.32684> }
        smooth_triangle {<-14.3866, 1.63238, 13.6618>, <-0.132582, 0.0489066, 0.296842>,
                         <-14.2084, 0.768095, 13.8304>, <-0.0842134, -0.0513446, 0.237791>,
                         <-13.9826, 0.833653, 13.9875>, <-0.148166, -0.0699116, 0.200422> }
        smooth_triangle {<-14.1039, 1.71444, 13.8585>, <-0.240232, 0.0292169, 0.261582>,
                         <-14.1217, 2.62185, 13.6226>, <-0.282349, 0.00814228, 0.304988>,
                         <-14.5083, 2.50962, 13.3536>, <-0.150607, 0.0463898, 0.384669> }
        smooth_triangle {<-14.5083, 2.50962, 13.3536>, <-0.162411, 0.0505822, 0.352993>,
                         <-14.3866, 1.63238, 13.6618>, <-0.145326, 0.0621774, 0.309621>,
                         <-14.1039, 1.71444, 13.8585>, <-0.229629, 0.0377026, 0.260678> }
        smooth_triangle {<-14.1217, 2.62185, 13.6226>, <-0.282349, 0.00814228, 0.304988>,
                         <-14.4671, 3.46907, 13.7181>, <-0.17783, -0.131532, 0.220332>,
                         <-14.8117, 3.36905, 13.4784>, <-0.0816914, -0.103621, 0.282948> }
        smooth_triangle {<-14.8117, 3.36905, 13.4784>, <-0.11556, -0.110171, 0.303785>,
                         <-14.5083, 2.50962, 13.3536>, <-0.167247, 0.00233693, 0.380075>,
                         <-14.1217, 2.62185, 13.6226>, <-0.266053, -0.0263487, 0.320314> }
        smooth_triangle {<-14.4671, 3.46907, 13.7181>, <-0.17783, -0.131532, 0.220332>,
                         <-15.0787, 4.03909, 14.1464>, <-0.060965, -0.138398, 0.0971343>,
                         <-15.2345, 3.99387, 14.0381>, <-0.0181666, -0.125973, 0.126912> }
        smooth_triangle {<-15.2345, 3.99387, 14.0381>, <-0.0433754, -0.182037, 0.170458>,
                         <-14.8117, 3.36905, 13.4784>, <-0.0847168, -0.151256, 0.276599>,
                         <-14.4671, 3.46907, 13.7181>, <-0.156821, -0.17219, 0.229636> }
        smooth_triangle {<-8.24472, -7.51364, 12.9693>, <-0.262224, -1.07713, 0.368929>,
                         <-9.08429, -7.20699, 13.2678>, <-0.2857, -0.996933, 0.267175>,
                         <-9.75459, -7.40159, 12.2232>, <-0.147135, -0.956704, 0.458204> }
        smooth_triangle {<-9.75459, -7.40159, 12.2232>, <-0.191792, -1.05206, 0.458233>,
                         <-9.07742, -7.75539, 11.6716>, <-0.20602, -1.18209, 0.505231>,
                         <-8.24472, -7.51364, 12.9693>, <-0.293993, -1.20763, 0.413625> }
        smooth_triangle {<-9.08429, -7.20699, 13.2678>, <-0.2857, -0.996933, 0.267175>,
                         <-9.91007, -6.85669, 13.5559>, <-0.257375, -0.731734, 0.217788>,
                         <-10.4237, -7.0058, 12.7555>, <-0.144354, -0.698922, 0.37387> }
        smooth_triangle {<-10.4237, -7.0058, 12.7555>, <-0.185731, -0.788105, 0.379277>,
                         <-9.75459, -7.40159, 12.2232>, <-0.187817, -0.981442, 0.442527>,
                         <-9.08429, -7.20699, 13.2678>, <-0.291741, -1.01161, 0.299256> }
        smooth_triangle {<-9.91007, -6.85669, 13.5559>, <-0.257375, -0.731734, 0.217788>,
                         <-10.7045, -6.42592, 13.8221>, <-0.220514, -0.488235, 0.165104>,
                         <-11.0732, -6.53298, 13.2474>, <-0.134405, -0.463235, 0.28567> }
        smooth_triangle {<-11.0732, -6.53298, 13.2474>, <-0.177075, -0.540577, 0.299177>,
                         <-10.4237, -7.0058, 12.7555>, <-0.184537, -0.717342, 0.365328>,
                         <-9.91007, -6.85669, 13.5559>, <-0.269303, -0.741951, 0.248266> }
        smooth_triangle {<-10.7045, -6.42592, 13.8221>, <-0.220514, -0.488235, 0.165104>,
                         <-11.471, -5.93859, 14.0707>, <-0.189242, -0.279819, 0.127788>,
                         <-11.7045, -6.00639, 13.7068>, <-0.12329, -0.260672, 0.217464> }
        smooth_triangle {<-11.7045, -6.00639, 13.7068>, <-0.155829, -0.328545, 0.228541>,
                         <-11.0732, -6.53298, 13.2474>, <-0.164165, -0.480467, 0.279695>,
                         <-10.7045, -6.42592, 13.8221>, <-0.228746, -0.499217, 0.189271> }
        smooth_triangle {<-11.471, -5.93859, 14.0707>, <-0.189242, -0.279819, 0.127788>,
                         <-11.9626, -5.17205, 14.1778>, <-0.257192, -0.108721, 0.141276>,
                         <-12.1379, -5.22294, 13.9046>, <-0.185001, -0.0877617, 0.236642> }
        smooth_triangle {<-12.1379, -5.22294, 13.9046>, <-0.206676, -0.116795, 0.230564>,
                         <-11.7045, -6.00639, 13.7068>, <-0.160393, -0.246478, 0.216181>,
                         <-11.471, -5.93859, 14.0707>, <-0.209857, -0.260839, 0.148923> }
        smooth_triangle {<-11.9626, -5.17205, 14.1778>, <-0.257192, -0.108721, 0.141276>,
                         <-12.0368, -4.23719, 14.0993>, <-0.349654, -0.0272695, 0.171881>,
                         <-12.2547, -4.30047, 13.7596>, <-0.261384, -0.00164272, 0.290207> }
        smooth_triangle {<-12.2547, -4.30047, 13.7596>, <-0.260882, -0.00286083, 0.259568>,
                         <-12.1379, -5.22294, 13.9046>, <-0.203595, -0.0674501, 0.219394>,
                         <-11.9626, -5.17205, 14.1778>, <-0.257738, -0.0831692, 0.14787> }
        smooth_triangle {<-12.0368, -4.23719, 14.0993>, <-0.349654, -0.0272695, 0.171881>,
                         <-12.1972, -3.31397, 14.0565>, <-0.341119, -0.0879925, 0.170674>,
                         <-12.4384, -3.38401, 13.6805>, <-0.252654, -0.0623091, 0.292435> }
        smooth_triangle {<-12.4384, -3.38401, 13.6805>, <-0.268569, -0.0580218, 0.272173>,
                         <-12.2547, -4.30047, 13.7596>, <-0.275116, -0.0125221, 0.270502>,
                         <-12.0368, -4.23719, 14.0993>, <-0.341319, -0.0317422, 0.181757> }
        smooth_triangle {<-12.1972, -3.31397, 14.0565>, <-0.341119, -0.0879925, 0.170674>,
                         <-12.6142, -2.47384, 14.1254>, <-0.269351, -0.139984, 0.144822>,
                         <-12.818, -2.53301, 13.8078>, <-0.194365, -0.118214, 0.247723> }
        smooth_triangle {<-12.818, -2.53301, 13.8078>, <-0.223535, -0.13201, 0.243766>,
                         <-12.4384, -3.38401, 13.6805>, <-0.267252, -0.0900811, 0.2773>,
                         <-12.1972, -3.31397, 14.0565>, <-0.333601, -0.109344, 0.185979> }
        smooth_triangle {<-12.6142, -2.47384, 14.1254>, <-0.269351, -0.139984, 0.144822>,
                         <-12.9909, -1.61859, 14.1764>, <-0.292349, -0.0587252, 0.151651>,
                         <-13.1669, -1.66969, 13.9021>, <-0.214895, -0.0362387, 0.253814> }
        smooth_triangle {<-13.1669, -1.66969, 13.9021>, <-0.228324, -0.0596927, 0.239508>,
                         <-12.818, -2.53301, 13.8078>, <-0.212926, -0.121174, 0.234939>,
                         <-12.6142, -2.47384, 14.1254>, <-0.269165, -0.137502, 0.157764> }
        smooth_triangle {<-12.9909, -1.61859, 14.1764>, <-0.292349, -0.0587252, 0.151651>,
                         <-12.9201, -0.693808, 14.0415>, <-0.367473, -0.00653629, 0.174736>,
                         <-13.1695, -0.766224, 13.6528>, <-0.277325, 0.0196357, 0.297182> }
        smooth_triangle {<-13.1695, -0.766224, 13.6528>, <-0.273135, 0.0255217, 0.262676>,
                         <-13.1669, -1.66969, 13.9021>, <-0.226313, -0.0163841, 0.230149>,
                         <-12.9909, -1.61859, 14.1764>, <-0.284403, -0.033249, 0.153527> }
        smooth_triangle {<-12.9201, -0.693808, 14.0415>, <-0.367473, -0.00653629, 0.174736>,
                         <-13.2454, 0.155959, 14.0727>, <-0.277039, -0.14237, 0.143691>,
                         <-13.4778, 0.0884797, 13.7105>, <-0.20188, -0.12055, 0.249758> }
        smooth_triangle {<-13.4778, 0.0884797, 13.7105>, <-0.233425, -0.123973, 0.246198>,
                         <-13.1695, -0.766224, 13.6528>, <-0.290008, -0.0188338, 0.281766>,
                         <-12.9201, -0.693808, 14.0415>, <-0.357619, -0.0384628, 0.189932> }
        smooth_triangle {<-13.2454, 0.155959, 14.0727>, <-0.277039, -0.14237, 0.143691>,
                         <-13.8317, 0.877458, 14.2226>, <-0.209076, -0.114129, 0.118268>,
                         <-13.9826, 0.833653, 13.9875>, <-0.148607, -0.0965742, 0.19828> }
        smooth_triangle {<-13.9826, 0.833653, 13.9875>, <-0.174262, -0.134235, 0.200526>,
                         <-13.4778, 0.0884797, 13.7105>, <-0.214217, -0.152217, 0.239134>,
                         <-13.2454, 0.155959, 14.0727>, <-0.270586, -0.168582, 0.159584> }
        smooth_triangle {<-13.8317, 0.877458, 14.2226>, <-0.209076, -0.114129, 0.118268>,
                         <-13.915, 1.76928, 14.1528>, <-0.320096, 0.00603061, 0.1565>,
                         <-14.1039, 1.71444, 13.8585>, <-0.240232, 0.0292169, 0.261582> }
        smooth_triangle {<-14.1039, 1.71444, 13.8585>, <-0.233363, 0.0196476, 0.230739>,
                         <-13.9826, 0.833653, 13.9875>, <-0.164645, -0.0746957, 0.183263>,
                         <-13.8317, 0.877458, 14.2226>, <-0.209996, -0.0878622, 0.123254> }
        smooth_triangle {<-13.915, 1.76928, 14.1528>, <-0.320096, 0.00603061, 0.1565>,
                         <-13.8634, 2.69685, 14.0252>, <-0.374779, -0.0186921, 0.178875>,
                         <-14.1217, 2.62185, 13.6226>, <-0.282349, 0.00814228, 0.304988> }
        smooth_triangle {<-14.1217, 2.62185, 13.6226>, <-0.281768, 0.0159302, 0.271833>,
                         <-14.1039, 1.71444, 13.8585>, <-0.25018, 0.0317362, 0.239278>,
                         <-13.915, 1.76928, 14.1528>, <-0.310078, 0.0143465, 0.160467> }
        smooth_triangle {<-13.8634, 2.69685, 14.0252>, <-0.374779, -0.0186921, 0.178875>,
                         <-14.2369, 3.5359, 14.0768>, <-0.243639, -0.150638, 0.124172>,
                         <-14.4671, 3.46907, 13.7181>, <-0.17783, -0.131532, 0.220332> }
        smooth_triangle {<-14.4671, 3.46907, 13.7181>, <-0.216845, -0.139576, 0.226436>,
                         <-14.1217, 2.62185, 13.6226>, <-0.295234, -0.0348206, 0.289928>,
                         <-13.8634, 2.69685, 14.0252>, <-0.364557, -0.0549464, 0.195344> }
        smooth_triangle {<-14.2369, 3.5359, 14.0768>, <-0.243639, -0.150638, 0.124172>,
                         <-14.9746, 4.06931, 14.3087>, <-0.089562, -0.1467, 0.0525687>,
                         <-15.0787, 4.03909, 14.1464>, <-0.060965, -0.138398, 0.0971343> }
        smooth_triangle {<-15.0787, 4.03909, 14.1464>, <-0.099265, -0.198262, 0.122119>,
                         <-14.4671, 3.46907, 13.7181>, <-0.177339, -0.178147, 0.208271>,
                         <-14.2369, 3.5359, 14.0768>, <-0.226696, -0.192476, 0.136151> }
        smooth_triangle {<-7.95231, -7.42875, 14.5>, <-0.357446, -1.10478, 0.129551>,
                         <-8.84892, -7.13865, 14.5>, <-0.343513, -1.01372, 0.0354719>,
                         <-9.08429, -7.20699, 13.2678>, <-0.2857, -0.996933, 0.267175> }
        smooth_triangle {<-9.08429, -7.20699, 13.2678>, <-0.325289, -1.09082, 0.240617>,
                         <-8.24472, -7.51364, 12.9693>, <-0.35314, -1.2248, 0.264935>,
                         <-7.95231, -7.42875, 14.5>, <-0.400751, -1.23862, 0.145246> }
        smooth_triangle {<-8.84892, -7.13865, 14.5>, <-0.343513, -1.01372, 0.0354719>,
                         <-9.72972, -6.80433, 14.5>, <-0.304432, -0.745396, 0.0285489>,
                         <-9.91007, -6.85669, 13.5559>, <-0.257375, -0.731734, 0.217788> }
        smooth_triangle {<-9.91007, -6.85669, 13.5559>, <-0.296017, -0.820123, 0.198061>,
                         <-9.08429, -7.20699, 13.2678>, <-0.317261, -1.01902, 0.235101>,
                         <-8.84892, -7.13865, 14.5>, <-0.36062, -1.03161, 0.0613239> }
        smooth_triangle {<-9.72972, -6.80433, 14.5>, <-0.304432, -0.745396, 0.0285489>,
                         <-10.575, -6.38833, 14.5>, <-0.255759, -0.498467, 0.0194029>,
                         <-10.7045, -6.42592, 13.8221>, <-0.220514, -0.488235, 0.165104> }
        smooth_triangle {<-10.7045, -6.42592, 13.8221>, <-0.263576, -0.56569, 0.15365>,
                         <-9.91007, -6.85669, 13.5559>, <-0.291223, -0.748315, 0.193162>,
                         <-9.72972, -6.80433, 14.5>, <-0.326515, -0.758561, 0.0512334> }
        smooth_triangle {<-10.575, -6.38833, 14.5>, <-0.255759, -0.498467, 0.0194029>,
                         <-11.389, -5.91478, 14.5>, <-0.217217, -0.287941, 0.0186567>,
                         <-11.471, -5.93859, 14.0707>, <-0.189242, -0.279819, 0.127788> }
        smooth_triangle {<-11.471, -5.93859, 14.0707>, <-0.222184, -0.347809, 0.118821>,
                         <-10.7045, -6.42592, 13.8221>, <-0.245637, -0.50412, 0.146808>,
                         <-10.575, -6.38833, 14.5>, <-0.272071, -0.511795, 0.0375325> }
        smooth_triangle {<-11.389, -5.91478, 14.5>, <-0.217217, -0.287941, 0.0186567>,
                         <-11.901, -5.15417, 14.5>, <-0.288841, -0.117909, 0.0244013>,
                         <-11.9626, -5.17205, 14.1778>, <-0.257192, -0.108721, 0.141276> }
        smooth_triangle {<-11.9626, -5.17205, 14.1778>, <-0.27452, -0.136492, 0.124597>,
                         <-11.471, -5.93859, 14.0707>, <-0.223558, -0.264816, 0.114481>,
                         <-11.389, -5.91478, 14.5>, <-0.244538, -0.270908, 0.0326327> }
        smooth_triangle {<-11.901, -5.15417, 14.5>, <-0.288841, -0.117909, 0.0244013>,
                         <-11.9602, -4.21496, 14.5>, <-0.387719, -0.0383206, 0.0273865>,
                         <-12.0368, -4.23719, 14.0993>, <-0.349654, -0.0272695, 0.171881> }
        smooth_triangle {<-12.0368, -4.23719, 14.0993>, <-0.337903, -0.0252216, 0.143628>,
                         <-11.9626, -5.17205, 14.1778>, <-0.268556, -0.0863099, 0.120675>,
                         <-11.901, -5.15417, 14.5>, <-0.292292, -0.0932011, 0.0330188> }
        smooth_triangle {<-11.9602, -4.21496, 14.5>, <-0.387719, -0.0383206, 0.0273865>,
                         <-12.1125, -3.28937, 14.5>, <-0.378102, -0.0987295, 0.0229294>,
                         <-12.1972, -3.31397, 14.0565>, <-0.341119, -0.0879925, 0.170674> }
        smooth_triangle {<-12.1972, -3.31397, 14.0565>, <-0.348558, -0.0812444, 0.146563>,
                         <-12.0368, -4.23719, 14.0993>, <-0.354959, -0.0357021, 0.147468>,
                         <-11.9602, -4.21496, 14.5>, <-0.383508, -0.0439904, 0.0390971> }
        smooth_triangle {<-12.1125, -3.28937, 14.5>, <-0.378102, -0.0987295, 0.0229294>,
                         <-12.5426, -2.45306, 14.5>, <-0.300812, -0.149118, 0.0198736>,
                         <-12.6142, -2.47384, 14.1254>, <-0.269351, -0.139984, 0.144822> }
        smooth_triangle {<-12.6142, -2.47384, 14.1254>, <-0.294738, -0.152682, 0.128974>,
                         <-12.1972, -3.31397, 14.0565>, <-0.348564, -0.113688, 0.148363>,
                         <-12.1125, -3.28937, 14.5>, <-0.376302, -0.121741, 0.0375548> }
        smooth_triangle {<-12.5426, -2.45306, 14.5>, <-0.300812, -0.149118, 0.0198736>,
                         <-12.9291, -1.60065, 14.5>, <-0.326361, -0.0685997, 0.0264004>,
                         <-12.9909, -1.61859, 14.1764>, <-0.292349, -0.0587252, 0.151651> }
        smooth_triangle {<-12.9909, -1.61859, 14.1764>, <-0.299099, -0.0802404, 0.130996>,
                         <-12.6142, -2.47384, 14.1254>, <-0.28185, -0.141185, 0.125875>,
                         <-12.5426, -2.45306, 14.5>, <-0.305446, -0.148035, 0.0321635> }
        smooth_triangle {<-12.9291, -1.60065, 14.5>, <-0.326361, -0.0685997, 0.0264004>,
                         <-12.8325, -0.668378, 14.5>, <-0.405759, -0.0176516, 0.0256883>,
                         <-12.9201, -0.693808, 14.0415>, <-0.367473, -0.00653629, 0.174736> }
        smooth_triangle {<-12.9201, -0.693808, 14.0415>, <-0.351016, 0.00291118, 0.145024>,
                         <-12.9909, -1.61859, 14.1764>, <-0.294673, -0.0362305, 0.12771>,
                         <-12.9291, -1.60065, 14.5>, <-0.320182, -0.0436364, 0.0337723> }
        smooth_triangle {<-12.8325, -0.668378, 14.5>, <-0.405759, -0.0176516, 0.0256883>,
                         <-13.1637, 0.179655, 14.5>, <-0.307496, -0.151212, 0.0157487>,
                         <-13.2454, 0.155959, 14.0727>, <-0.277039, -0.14237, 0.143691> }
        smooth_triangle {<-13.2454, 0.155959, 14.0727>, <-0.304991, -0.14475, 0.128444>,
                         <-12.9201, -0.693808, 14.0415>, <-0.372816, -0.0428748, 0.151728>,
                         <-12.8325, -0.668378, 14.5>, <-0.401531, -0.0512113, 0.039942> }
        smooth_triangle {<-13.1637, 0.179655, 14.5>, <-0.307496, -0.151212, 0.0157487>,
                         <-13.7787, 0.89284, 14.5>, <-0.235536, -0.121812, 0.0202513>,
                         <-13.8317, 0.877458, 14.2226>, <-0.209076, -0.114129, 0.118268> }
        smooth_triangle {<-13.8317, 0.877458, 14.2226>, <-0.232987, -0.151284, 0.106896>,
                         <-13.2454, 0.155959, 14.0727>, <-0.28396, -0.172464, 0.125963>,
                         <-13.1637, 0.179655, 14.5>, <-0.306802, -0.179096, 0.0300068> }
        smooth_triangle {<-13.7787, 0.89284, 14.5>, <-0.235536, -0.121812, 0.0202513>,
                         <-13.8487, 1.78853, 14.5>, <-0.355262, -0.00417897, 0.027593>,
                         <-13.915, 1.76928, 14.1528>, <-0.320096, 0.00603061, 0.1565> }
        smooth_triangle {<-13.915, 1.76928, 14.1528>, <-0.30218, -0.000331322, 0.129509>,
                         <-13.8317, 0.877458, 14.2226>, <-0.218915, -0.0904514, 0.100835>,
                         <-13.7787, 0.89284, 14.5>, <-0.23876, -0.096213, 0.0273219> }
        smooth_triangle {<-13.8487, 1.78853, 14.5>, <-0.355262, -0.00417897, 0.027593>,
                         <-13.7727, 2.72318, 14.5>, <-0.413825, -0.0300282, 0.0255303>,
                         <-13.8634, 2.69685, 14.0252>, <-0.374779, -0.0186921, 0.178875> }
        smooth_triangle {<-13.8634, 2.69685, 14.0252>, <-0.362212, -0.00742459, 0.149288>,
                         <-13.915, 1.76928, 14.1528>, <-0.3212, 0.0111175, 0.132507>,
                         <-13.8487, 1.78853, 14.5>, <-0.347575, 0.0034603, 0.0358265> }
        smooth_triangle {<-13.7727, 2.72318, 14.5>, <-0.413825, -0.0300282, 0.0255303>,
                         <-14.1561, 3.55937, 14.5>, <-0.269099, -0.158029, 0.0091081>,
                         <-14.2369, 3.5359, 14.0768>, <-0.243639, -0.150638, 0.124172> }
        smooth_triangle {<-14.2369, 3.5359, 14.0768>, <-0.281994, -0.15849, 0.114615>,
                         <-13.8634, 2.69685, 14.0252>, <-0.380349, -0.0595314, 0.155643>,
                         <-13.7727, 2.72318, 14.5>, <-0.409634, -0.0680334, 0.0406339> }
        smooth_triangle {<-14.1561, 3.55937, 14.5>, <-0.269099, -0.158029, 0.0091081>,
                         <-14.938, 4.07992, 14.5>, <-0.0996039, -0.149616, 1.04083e-17>,
                         <-14.9746, 4.06931, 14.3087>, <-0.089562, -0.1467, 0.0525687> }
        smooth_triangle {<-14.9746, 4.06931, 14.3087>, <-0.133135, -0.208096, 0.0551891>,
                         <-14.2369, 3.5359, 14.0768>, <-0.2378, -0.1957, 0.108236>,
                         <-14.1561, 3.55937, 14.5>, <-0.256895, -0.201244, 0.0219385> }
        smooth_triangle {<-8.24472, -7.51364, 16.0307>, <-0.357446, -1.10478, -0.129551>,
                         <-9.08429, -7.20699, 15.7322>, <-0.311773, -1.0045, -0.201632>,
                         <-8.84892, -7.13865, 14.5>, <-0.343513, -1.01372, 0.0354719> }
        smooth_triangle {<-8.84892, -7.13865, 14.5>, <-0.368649, -1.10341, -0.0136314>,
                         <-7.95231, -7.42875, 14.5>, <-0.400751, -1.23862, -0.0156953>,
                         <-8.24472, -7.51364, 16.0307>, <-0.400751, -1.23862, -0.145246> }
        smooth_triangle {<-9.08429, -7.20699, 15.7322>, <-0.311773, -1.0045, -0.201632>,
                         <-9.91007, -6.85669, 15.4441>, <-0.278359, -0.737826, -0.165036>,
                         <-9.72972, -6.80433, 14.5>, <-0.304432, -0.745396, 0.0285489> }
        smooth_triangle {<-9.72972, -6.80433, 14.5>, <-0.331309, -0.83037, -0.0133083>,
                         <-8.84892, -7.13865, 14.5>, <-0.36062, -1.03161, -0.00811606>,
                         <-9.08429, -7.20699, 15.7322>, <-0.336815, -1.0247, -0.185944> }
        smooth_triangle {<-9.91007, -6.85669, 15.4441>, <-0.278359, -0.737826, -0.165036>,
                         <-10.7045, -6.42592, 15.1779>, <-0.234775, -0.492375, -0.129252>,
                         <-10.575, -6.38833, 14.5>, <-0.255759, -0.498467, 0.0194029> }
        smooth_triangle {<-10.575, -6.38833, 14.5>, <-0.29001, -0.573365, -0.0152695>,
                         <-9.72972, -6.80433, 14.5>, <-0.326515, -0.758561, -0.00841009>,
                         <-9.91007, -6.85669, 15.4441>, <-0.306961, -0.752884, -0.153599> }
        smooth_triangle {<-10.7045, -6.42592, 15.1779>, <-0.234775, -0.492375, -0.129252>,
                         <-11.471, -5.93859, 14.9293>, <-0.202955, -0.283801, -0.0933145>,
                         <-11.389, -5.91478, 14.5>, <-0.217217, -0.287941, 0.0186567> }
        smooth_triangle {<-11.389, -5.91478, 14.5>, <-0.243165, -0.3539, -0.00898779>,
                         <-10.575, -6.38833, 14.5>, <-0.272071, -0.511795, -0.00842814>,
                         <-10.7045, -6.42592, 15.1779>, <-0.256333, -0.507226, -0.119919> }
        smooth_triangle {<-11.471, -5.93859, 14.9293>, <-0.202955, -0.283801, -0.0933145>,
                         <-11.9626, -5.17205, 14.8222>, <-0.275128, -0.113928, -0.096188>,
                         <-11.901, -5.15417, 14.5>, <-0.288841, -0.117909, 0.0244013> }
        smooth_triangle {<-11.901, -5.15417, 14.5>, <-0.298257, -0.143383, -0.000339129>,
                         <-11.389, -5.91478, 14.5>, <-0.244538, -0.270908, -0.00464759>,
                         <-11.471, -5.93859, 14.9293>, <-0.233842, -0.267802, -0.088626> }
        smooth_triangle {<-11.9626, -5.17205, 14.8222>, <-0.275128, -0.113928, -0.096188>,
                         <-12.0368, -4.23719, 14.9007>, <-0.369784, -0.0331136, -0.121277>,
                         <-11.9602, -4.21496, 14.5>, <-0.387719, -0.0383206, 0.0273865> }
        smooth_triangle {<-11.9602, -4.21496, 14.5>, <-0.366451, -0.0335099, 0.00582204>,
                         <-11.901, -5.15417, 14.5>, <-0.292292, -0.0932011, 0.00358321>,
                         <-11.9626, -5.17205, 14.8222>, <-0.282008, -0.0902152, -0.0868588> }
        smooth_triangle {<-12.0368, -4.23719, 14.9007>, <-0.369784, -0.0331136, -0.121277>,
                         <-12.1972, -3.31397, 14.9435>, <-0.357973, -0.0928855, -0.128306>,
                         <-12.1125, -3.28937, 14.5>, <-0.378102, -0.0987295, 0.0229294> }
        smooth_triangle {<-12.1125, -3.28937, 14.5>, <-0.376295, -0.0892971, -0.0013602>,
                         <-11.9602, -4.21496, 14.5>, <-0.383508, -0.0439904, 0.00198259>,
                         <-12.0368, -4.23719, 14.9007>, <-0.370056, -0.0400852, -0.109515> }
        smooth_triangle {<-12.1972, -3.31397, 14.9435>, <-0.357973, -0.0928855, -0.128306>,
                         <-12.6142, -2.47384, 14.8746>, <-0.283958, -0.144225, -0.1081>,
                         <-12.5426, -2.45306, 14.5>, <-0.300812, -0.149118, 0.0198736> }
        smooth_triangle {<-12.5426, -2.45306, 14.5>, <-0.318334, -0.159532, -0.00545258>,
                         <-12.1125, -3.28937, 14.5>, <-0.376302, -0.121741, -0.00316072>,
                         <-12.1972, -3.31397, 14.9435>, <-0.361205, -0.117358, -0.116587> }
        smooth_triangle {<-12.6142, -2.47384, 14.8746>, <-0.283958, -0.144225, -0.1081>,
                         <-12.9909, -1.61859, 14.8236>, <-0.311754, -0.0643588, -0.102869>,
                         <-12.9291, -1.60065, 14.5>, <-0.326361, -0.0685997, 0.0264004> }
        smooth_triangle {<-12.9291, -1.60065, 14.5>, <-0.324608, -0.0876462, 0.00254197>,
                         <-12.5426, -2.45306, 14.5>, <-0.305446, -0.148035, -0.0023531>,
                         <-12.6142, -2.47384, 14.8746>, <-0.292806, -0.144365, -0.0983336> }
        smooth_triangle {<-12.9909, -1.61859, 14.8236>, <-0.311754, -0.0643588, -0.102869>,
                         <-12.9201, -0.693808, 14.9585>, <-0.386355, -0.012018, -0.127271>,
                         <-12.8325, -0.668378, 14.5>, <-0.405759, -0.0176516, 0.0256883> }
        smooth_triangle {<-12.8325, -0.668378, 14.5>, <-0.37973, -0.00542529, 0.0052942>,
                         <-12.9291, -1.60065, 14.5>, <-0.320182, -0.0436364, 0.00582824>,
                         <-12.9909, -1.61859, 14.8236>, <-0.309226, -0.0404557, -0.0911239> }
        smooth_triangle {<-12.9201, -0.693808, 14.9585>, <-0.386355, -0.012018, -0.127271>,
                         <-13.2454, 0.155959, 14.9273>, <-0.288614, -0.14573, -0.114591>,
                         <-13.1637, 0.179655, 14.5>, <-0.307496, -0.151212, 0.0157487> }
        smooth_triangle {<-13.1637, 0.179655, 14.5>, <-0.327833, -0.151382, -0.00886418>,
                         <-12.8325, -0.668378, 14.5>, <-0.401531, -0.0512113, -0.00140949>,
                         <-12.9201, -0.693808, 14.9585>, <-0.386978, -0.0469861, -0.116129> }
        smooth_triangle {<-13.2454, 0.155959, 14.9273>, <-0.288614, -0.14573, -0.114591>,
                         <-13.8317, 0.877458, 14.7774>, <-0.223961, -0.118451, -0.0808486>,
                         <-13.7787, 0.89284, 14.5>, <-0.235536, -0.121812, 0.0202513> }
        smooth_triangle {<-13.7787, 0.89284, 14.5>, <-0.252833, -0.157046, -0.00300676>,
                         <-13.1637, 0.179655, 14.5>, <-0.306802, -0.179096, -0.00638372>,
                         <-13.2454, 0.155959, 14.9273>, <-0.292641, -0.174985, -0.104139> }
        smooth_triangle {<-13.8317, 0.877458, 14.7774>, <-0.223961, -0.118451, -0.0808486>,
                         <-13.915, 1.76928, 14.8472>, <-0.340377, 0.0001425, -0.105515>,
                         <-13.8487, 1.78853, 14.5>, <-0.355262, -0.00417897, 0.027593> }
        smooth_triangle {<-13.8487, 1.78853, 14.5>, <-0.328555, -0.00798851, 0.00856135>,
                         <-13.7787, 0.89284, 14.5>, <-0.23876, -0.096213, 0.00305512>,
                         <-13.8317, 0.877458, 14.7774>, <-0.230078, -0.0936925, -0.0727698> }
        smooth_triangle {<-13.915, 1.76928, 14.8472>, <-0.340377, 0.0001425, -0.105515>,
                         <-13.8634, 2.69685, 14.9748>, <-0.393544, -0.0241401, -0.131701>,
                         <-13.7727, 2.72318, 14.5>, <-0.413825, -0.0300282, 0.0255303> }
        smooth_triangle {<-13.7727, 2.72318, 14.5>, <-0.391497, -0.0159266, 0.00401596>,
                         <-13.8487, 1.78853, 14.5>, <-0.347575, 0.0034603, 0.00556298>,
                         <-13.915, 1.76928, 14.8472>, <-0.336411, 0.0067014, -0.0942681> }
        smooth_triangle {<-13.8634, 2.69685, 14.9748>, <-0.393544, -0.0241401, -0.131701>,
                         <-14.2369, 3.5359, 14.9232>, <-0.250334, -0.152581, -0.107342>,
                         <-14.1561, 3.55937, 14.5>, <-0.269099, -0.158029, 0.0091081> }
        smooth_triangle {<-14.1561, 3.55937, 14.5>, <-0.301089, -0.164034, -0.0146551>,
                         <-13.7727, 2.72318, 14.5>, <-0.409634, -0.0680334, -0.00233844>,
                         <-13.8634, 2.69685, 14.9748>, <-0.394423, -0.0636173, -0.120262> }
        smooth_triangle {<-14.2369, 3.5359, 14.9232>, <-0.250334, -0.152581, -0.107342>,
                         <-14.9746, 4.06931, 14.6913>, <-0.089562, -0.1467, -0.0525687>,
                         <-14.938, 4.07992, 14.5>, <-0.0996039, -0.149616, 1.04083e-17> }
        smooth_triangle {<-14.938, 4.07992, 14.5>, <-0.13983, -0.210039, -0.0201433>,
                         <-14.1561, 3.55937, 14.5>, <-0.256895, -0.201244, -0.00827638>,
                         <-14.2369, 3.5359, 14.9232>, <-0.242821, -0.197158, -0.0956143> }
        smooth_triangle {<-9.07742, -7.75539, 17.3284>, <-0.262224, -1.07713, -0.368929>,
                         <-9.75459, -7.40159, 16.7768>, <-0.19531, -0.97069, -0.408039>,
                         <-9.08429, -7.20699, 15.7322>, <-0.311773, -1.0045, -0.201632> }
        smooth_triangle {<-9.08429, -7.20699, 15.7322>, <-0.31527, -1.08791, -0.265804>,
                         <-8.24472, -7.51364, 16.0307>, <-0.341604, -1.22145, -0.293936>,
                         <-9.07742, -7.75539, 17.3284>, <-0.293993, -1.20763, -0.413625> }
        smooth_triangle {<-9.75459, -7.40159, 16.7768>, <-0.19531, -0.97069, -0.408039>,
                         <-10.4237, -7.0058, 16.2445>, <-0.228239, -0.681803, -0.273474>,
                         <-9.91007, -6.85669, 15.4441>, <-0.278359, -0.737826, -0.165036> }
        smooth_triangle {<-9.91007, -6.85669, 15.4441>, <-0.286235, -0.817284, -0.222651>,
                         <-9.08429, -7.20699, 15.7322>, <-0.311295, -1.01729, -0.250098>,
                         <-9.75459, -7.40159, 16.7768>, <-0.223949, -0.991932, -0.404903> }
        smooth_triangle {<-10.4237, -7.0058, 16.2445>, <-0.228239, -0.681803, -0.273474>,
                         <-11.0732, -6.53298, 15.7526>, <-0.18977, -0.445854, -0.204833>,
                         <-10.7045, -6.42592, 15.1779>, <-0.234775, -0.492375, -0.129252> }
        smooth_triangle {<-10.7045, -6.42592, 15.1779>, <-0.252353, -0.562432, -0.181864>,
                         <-9.91007, -6.85669, 15.4441>, <-0.285041, -0.74652, -0.208702>,
                         <-10.4237, -7.0058, 16.2445>, <-0.253855, -0.71207, -0.295549> }
        smooth_triangle {<-11.0732, -6.53298, 15.7526>, <-0.18977, -0.445854, -0.204833>,
                         <-11.7045, -6.00639, 15.2932>, <-0.182225, -0.245024, -0.162577>,
                         <-11.471, -5.93859, 14.9293>, <-0.202955, -0.283801, -0.0933145> }
        smooth_triangle {<-11.471, -5.93859, 14.9293>, <-0.215577, -0.345891, -0.135428>,
                         <-10.7045, -6.42592, 15.1779>, <-0.239442, -0.502322, -0.162382>,
                         <-11.0732, -6.53298, 15.7526>, <-0.210995, -0.474624, -0.223812> }
        smooth_triangle {<-11.7045, -6.00639, 15.2932>, <-0.182225, -0.245024, -0.162577>,
                         <-12.1379, -5.22294, 15.0954>, <-0.218141, -0.0973831, -0.202134>,
                         <-11.9626, -5.17205, 14.8222>, <-0.275128, -0.113928, -0.096188> }
        smooth_triangle {<-11.9626, -5.17205, 14.8222>, <-0.274271, -0.13642, -0.125224>,
                         <-11.471, -5.93859, 14.9293>, <-0.220142, -0.263825, -0.123069>,
                         <-11.7045, -6.00639, 15.2932>, <-0.21205, -0.231315, -0.179162> }
        smooth_triangle {<-12.1379, -5.22294, 15.0954>, <-0.218141, -0.0973831, -0.202134>,
                         <-12.2547, -4.30047, 15.2404>, <-0.298578, -0.0124411, -0.251477>,
                         <-12.0368, -4.23719, 14.9007>, <-0.369784, -0.0331136, -0.121277> }
        smooth_triangle {<-12.0368, -4.23719, 14.9007>, <-0.342182, -0.026464, -0.13287>,
                         <-11.9626, -5.17205, 14.8222>, <-0.27119, -0.0870745, -0.114054>,
                         <-12.1379, -5.22294, 15.0954>, <-0.22845, -0.0746661, -0.193513> }
        smooth_triangle {<-12.2547, -4.30047, 15.2404>, <-0.298578, -0.0124411, -0.251477>,
                         <-12.4384, -3.38401, 15.3195>, <-0.283795, -0.0713501, -0.260008>,
                         <-12.1972, -3.31397, 14.9435>, <-0.357973, -0.0928855, -0.128306> }
        smooth_triangle {<-12.1972, -3.31397, 14.9435>, <-0.347558, -0.0809541, -0.149076>,
                         <-12.0368, -4.23719, 14.9007>, <-0.356416, -0.0361252, -0.143804>,
                         <-12.2547, -4.30047, 15.2404>, <-0.303012, -0.0206208, -0.241454> }
        smooth_triangle {<-12.4384, -3.38401, 15.3195>, <-0.283795, -0.0713501, -0.260008>,
                         <-12.818, -2.53301, 15.1922>, <-0.221356, -0.12605, -0.219617>,
                         <-12.6142, -2.47384, 14.8746>, <-0.283958, -0.144225, -0.1081> }
        smooth_triangle {<-12.6142, -2.47384, 14.8746>, <-0.29073, -0.151518, -0.139049>,
                         <-12.1972, -3.31397, 14.9435>, <-0.346241, -0.113013, -0.154203>,
                         <-12.4384, -3.38401, 15.3195>, <-0.290608, -0.0968619, -0.25298> }
        smooth_triangle {<-12.818, -2.53301, 15.1922>, <-0.221356, -0.12605, -0.219617>,
                         <-13.1669, -1.66969, 15.0979>, <-0.250751, -0.0466483, -0.216478>,
                         <-12.9909, -1.61859, 14.8236>, <-0.311754, -0.0643588, -0.102869> }
        smooth_triangle {<-12.9909, -1.61859, 14.8236>, <-0.300967, -0.0807828, -0.126299>,
                         <-12.6142, -2.47384, 14.8746>, <-0.280121, -0.140683, -0.130223>,
                         <-12.818, -2.53301, 15.1922>, <-0.233169, -0.127051, -0.21386> }
        smooth_triangle {<-13.1669, -1.66969, 15.0979>, <-0.250751, -0.0466483, -0.216478>,
                         <-13.1695, -0.766224, 15.3472>, <-0.337475, -0.0319497, -0.222504>,
                         <-12.9201, -0.693808, 14.9585>, <-0.386355, -0.012018, -0.127271> }
        smooth_triangle {<-12.9201, -0.693808, 14.9585>, <-0.354907, 0.00178144, -0.135242>,
                         <-12.9909, -1.61859, 14.8236>, <-0.298957, -0.0374742, -0.116941>,
                         <-13.1669, -1.66969, 15.0979>, <-0.253204, -0.0241913, -0.202147> }
        smooth_triangle {<-13.1695, -0.766224, 15.3472>, <-0.337475, -0.0319497, -0.222504>,
                         <-13.4778, 0.0884797, 15.2895>, <-0.223269, -0.126759, -0.227486>,
                         <-13.2454, 0.155959, 14.9273>, <-0.288614, -0.14573, -0.114591> }
        smooth_triangle {<-13.2454, 0.155959, 14.9273>, <-0.298475, -0.142858, -0.144823>,
                         <-12.9201, -0.693808, 14.9585>, <-0.371781, -0.0425741, -0.154332>,
                         <-13.1695, -0.766224, 15.3472>, <-0.334336, -0.0660473, -0.226842> }
        smooth_triangle {<-13.4778, 0.0884797, 15.2895>, <-0.223269, -0.126759, -0.227486>,
                         <-13.9826, 0.833653, 15.0125>, <-0.214708, -0.0859121, -0.153779>,
                         <-13.8317, 0.877458, 14.7774>, <-0.223961, -0.118451, -0.0808486> }
        smooth_triangle {<-13.8317, 0.877458, 14.7774>, <-0.230777, -0.150643, -0.112452>,
                         <-13.2454, 0.155959, 14.9273>, <-0.279267, -0.171102, -0.137759>,
                         <-13.4778, 0.0884797, 15.2895>, <-0.230259, -0.156874, -0.22243> }
        smooth_triangle {<-13.9826, 0.833653, 15.0125>, <-0.214708, -0.0859121, -0.153779>,
                         <-14.1039, 1.71444, 15.1415>, <-0.324651, 0.021199, -0.204374>,
                         <-13.915, 1.76928, 14.8472>, <-0.340377, 0.0001425, -0.105515> }
        smooth_triangle {<-13.915, 1.76928, 14.8472>, <-0.308473, -0.00215824, -0.113689>,
                         <-13.8317, 0.877458, 14.7774>, <-0.22116, -0.0911033, -0.0951894>,
                         <-13.9826, 0.833653, 15.0125>, <-0.214058, -0.0602949, -0.14859> }
        smooth_triangle {<-14.1039, 1.71444, 15.1415>, <-0.324651, 0.021199, -0.204374>,
                         <-14.1217, 2.62185, 15.3774>, <-0.317023, -0.00192422, -0.268883>,
                         <-13.8634, 2.69685, 14.9748>, <-0.393544, -0.0241401, -0.131701> }
        smooth_triangle {<-13.8634, 2.69685, 14.9748>, <-0.365164, -0.00828156, -0.141868>,
                         <-13.915, 1.76928, 14.8472>, <-0.325289, 0.00993039, -0.122228>,
                         <-14.1039, 1.71444, 15.1415>, <-0.309775, 0.0272307, -0.193704> }
        smooth_triangle {<-14.1217, 2.62185, 15.3774>, <-0.317023, -0.00192422, -0.268883>,
                         <-14.4671, 3.46907, 15.2819>, <-0.188536, -0.144838, -0.147963>,
                         <-14.2369, 3.5359, 14.9232>, <-0.250334, -0.152581, -0.107342> }
        smooth_triangle {<-14.2369, 3.5359, 14.9232>, <-0.271223, -0.155363, -0.141694>,
                         <-13.8634, 2.69685, 14.9748>, <-0.37863, -0.0590324, -0.159963>,
                         <-14.1217, 2.62185, 15.3774>, <-0.321239, -0.0423705, -0.262849> }
        smooth_triangle {<-14.4671, 3.46907, 15.2819>, <-0.188536, -0.144838, -0.147963>,
                         <-15.0787, 4.03909, 14.8536>, <-0.0795201, -0.143785, -0.0778131>,
                         <-14.9746, 4.06931, 14.6913>, <-0.089562, -0.1467, -0.0525687> }
        smooth_triangle {<-14.9746, 4.06931, 14.6913>, <-0.11833, -0.203797, -0.092409>,
                         <-14.2369, 3.5359, 14.9232>, <-0.231717, -0.193934, -0.123529>,
                         <-14.4671, 3.46907, 15.2819>, <-0.184312, -0.202556, -0.156005> }
        smooth_triangle {<-10.3237, -8.1172, 18.1955>, <-0.086277, -1.02605, -0.552141>,
                         <-10.7577, -7.69283, 17.4747>, <-0.0118571, -0.91743, -0.552326>,
                         <-9.75459, -7.40159, 16.7768>, <-0.19531, -0.97069, -0.408039> }
        smooth_triangle {<-9.75459, -7.40159, 16.7768>, <-0.173278, -1.04668, -0.477511>,
                         <-9.07742, -7.75539, 17.3284>, <-0.107182, -1.27467, -0.685927>,
                         <-10.3237, -8.1172, 18.1955>, <-0.0967296, -1.15036, -0.619034> }
        smooth_triangle {<-10.7577, -7.69283, 17.4747>, <-0.0118571, -0.91743, -0.552326>,
                         <-11.1923, -7.22896, 16.7794>, <-0.0332339, -0.666661, -0.451184>,
                         <-10.4237, -7.0058, 16.2445>, <-0.0929032, -0.766928, -0.453541> }
        smooth_triangle {<-10.4237, -7.0058, 16.2445>, <-0.107074, -0.883912, -0.522722>,
                         <-9.75459, -7.40159, 16.7768>, <-0.176794, -0.978242, -0.454005>,
                         <-10.7577, -7.69283, 17.4747>, <-0.0392041, -0.938296, -0.56222> }
        smooth_triangle {<-11.1923, -7.22896, 16.7794>, <-0.0332339, -0.666661, -0.451184>,
                         <-11.6251, -6.69321, 16.1366>, <-0.0449719, -0.437271, -0.347894>,
                         <-11.0732, -6.53298, 15.7526>, <-0.102729, -0.520949, -0.365023> }
        smooth_triangle {<-11.0732, -6.53298, 15.7526>, <-0.122904, -0.623259, -0.436711>,
                         <-10.4237, -7.0058, 16.2445>, <-0.117991, -0.746248, -0.480969>,
                         <-11.1923, -7.22896, 16.7794>, <-0.0606951, -0.681388, -0.465488> }
        smooth_triangle {<-11.6251, -6.69321, 16.1366>, <-0.0449719, -0.437271, -0.347894>,
                         <-12.054, -6.10785, 15.5363>, <-0.0625084, -0.243026, -0.259754>,
                         <-11.7045, -6.00639, 15.2932>, <-0.0814371, -0.314038, -0.248084> }
        smooth_triangle {<-11.7045, -6.00639, 15.2932>, <-0.10502, -0.404978, -0.319925>,
                         <-11.0732, -6.53298, 15.7526>, <-0.115666, -0.508434, -0.378395>,
                         <-11.6251, -6.69321, 16.1366>, <-0.0658796, -0.451933, -0.358862> }
        smooth_triangle {<-12.054, -6.10785, 15.5363>, <-0.0625084, -0.243026, -0.259754>,
                         <-12.4002, -5.2991, 15.2779>, <-0.126556, -0.070794, -0.277306>,
                         <-12.1379, -5.22294, 15.0954>, <-0.218141, -0.0973831, -0.202134> }
        smooth_triangle {<-12.1379, -5.22294, 15.0954>, <-0.206215, -0.116662, -0.231044>,
                         <-11.7045, -6.00639, 15.2932>, <-0.125937, -0.244268, -0.28293>,
                         <-12.054, -6.10785, 15.5363>, <-0.0894906, -0.225894, -0.27426> }
        smooth_triangle {<-12.4002, -5.2991, 15.2779>, <-0.126556, -0.070794, -0.277306>,
                         <-12.5809, -4.39518, 15.4673>, <-0.184944, 0.0205496, -0.343392>,
                         <-12.2547, -4.30047, 15.2404>, <-0.298578, -0.0124411, -0.251477> }
        smooth_triangle {<-12.2547, -4.30047, 15.2404>, <-0.268789, -0.00515644, -0.251335>,
                         <-12.1379, -5.22294, 15.0954>, <-0.208461, -0.0688629, -0.214327>,
                         <-12.4002, -5.2991, 15.2779>, <-0.139772, -0.0489211, -0.270706> }
        smooth_triangle {<-12.5809, -4.39518, 15.4673>, <-0.184944, 0.0205496, -0.343392>,
                         <-12.7995, -3.48884, 15.5707>, <-0.166863, -0.0374019, -0.352126>,
                         <-12.4384, -3.38401, 15.3195>, <-0.283795, -0.0713501, -0.260008> }
        smooth_triangle {<-12.4384, -3.38401, 15.3195>, <-0.266722, -0.0574855, -0.274096>,
                         <-12.2547, -4.30047, 15.2404>, <-0.277809, -0.0133038, -0.267698>,
                         <-12.5809, -4.39518, 15.4673>, <-0.192583, 0.0114392, -0.336635> }
        smooth_triangle {<-12.7995, -3.48884, 15.5707>, <-0.166863, -0.0374019, -0.352126>,
                         <-13.123, -2.62156, 15.4045>, <-0.122536, -0.0973606, -0.297699>,
                         <-12.818, -2.53301, 15.1922>, <-0.221356, -0.12605, -0.219617> }
        smooth_triangle {<-12.818, -2.53301, 15.1922>, <-0.21613, -0.12986, -0.251477>,
                         <-12.4384, -3.38401, 15.3195>, <-0.262959, -0.0888349, -0.28177>,
                         <-12.7995, -3.48884, 15.5707>, <-0.17526, -0.0633738, -0.350859> }
        smooth_triangle {<-13.123, -2.62156, 15.4045>, <-0.122536, -0.0973606, -0.297699>,
                         <-13.4303, -1.74617, 15.2811>, <-0.152639, -0.0181643, -0.29713>,
                         <-13.1669, -1.66969, 15.0979>, <-0.250751, -0.0466483, -0.216478> }
        smooth_triangle {<-13.1669, -1.66969, 15.0979>, <-0.231776, -0.060695, -0.235913>,
                         <-12.818, -2.53301, 15.1922>, <-0.20973, -0.120247, -0.238267>,
                         <-13.123, -2.62156, 15.4045>, <-0.135615, -0.0987293, -0.296829> }
        smooth_triangle {<-13.4303, -1.74617, 15.2811>, <-0.152639, -0.0181643, -0.29713>,
                         <-13.5428, -0.874603, 15.607>, <-0.194623, 0.043646, -0.354724>,
                         <-13.1695, -0.766224, 15.3472>, <-0.26169, 0.0924201, -0.337553> }
        smooth_triangle {<-13.1695, -0.766224, 15.3472>, <-0.223176, 0.0788181, -0.287873>,
                         <-13.1669, -1.66969, 15.0979>, <-0.234228, -0.0186822, -0.221907>,
                         <-13.4303, -1.74617, 15.2811>, <-0.160645, 0.00268083, -0.282396> }
        smooth_triangle {<-13.5428, -0.874603, 15.607>, <-0.194623, 0.043646, -0.354724>,
                         <-13.8257, -0.012511, 15.5315>, <-0.121409, -0.0971868, -0.305747>,
                         <-13.4778, 0.0884797, 15.2895>, <-0.223269, -0.126759, -0.227486> }
        smooth_triangle {<-13.4778, 0.0884797, 15.2895>, <-0.221386, -0.120478, -0.258734>,
                         <-13.1695, -0.766224, 15.3472>, <-0.238713, -0.00460637, -0.345015>,
                         <-13.5428, -0.874603, 15.607>, <-0.199901, 0.00732631, -0.354162> }
        smooth_triangle {<-13.8257, -0.012511, 15.5315>, <-0.121409, -0.0971868, -0.305747>,
                         <-14.2084, 0.768095, 15.1696>, <-0.0992723, -0.0822512, -0.232605>,
                         <-13.9826, 0.833653, 15.0125>, <-0.098918, -0.141853, -0.201362> }
        smooth_triangle {<-13.9826, 0.833653, 15.0125>, <-0.125649, -0.180187, -0.255776>,
                         <-13.4778, 0.0884797, 15.2895>, <-0.205547, -0.149699, -0.248162>,
                         <-13.8257, -0.012511, 15.5315>, <-0.129151, -0.12752, -0.306858> }
        smooth_triangle {<-14.2084, 0.768095, 15.1696>, <-0.0992723, -0.0822512, -0.232605>,
                         <-14.3866, 1.63238, 15.3382>, <-0.176792, 0.0476349, -0.305721>,
                         <-14.1039, 1.71444, 15.1415>, <-0.183818, 0.0126132, -0.258932> }
        smooth_triangle {<-14.1039, 1.71444, 15.1415>, <-0.165331, 0.0113447, -0.23289>,
                         <-13.9826, 0.833653, 15.0125>, <-0.122881, -0.0658886, -0.204105>,
                         <-14.2084, 0.768095, 15.1696>, <-0.111165, -0.0591694, -0.226166> }
        smooth_triangle {<-14.3866, 1.63238, 15.3382>, <-0.176792, 0.0476349, -0.305721>,
                         <-14.5083, 2.50962, 15.6464>, <-0.195911, 0.0332373, -0.365129>,
                         <-14.1217, 2.62185, 15.3774>, <-0.317023, -0.00192422, -0.268883> }
        smooth_triangle {<-14.1217, 2.62185, 15.3774>, <-0.287222, 0.0143467, -0.266153>,
                         <-14.1039, 1.71444, 15.1415>, <-0.190819, 0.0378864, -0.258448>,
                         <-14.3866, 1.63238, 15.3382>, <-0.182049, 0.0515161, -0.293782> }
        smooth_triangle {<-14.5083, 2.50962, 15.6464>, <-0.195911, 0.0332373, -0.365129>,
                         <-14.8117, 3.36905, 15.5216>, <-0.0978536, -0.108313, -0.275977>,
                         <-14.4671, 3.46907, 15.2819>, <-0.19353, -0.115692, -0.326428> }
        smooth_triangle {<-14.4671, 3.46907, 15.2819>, <-0.205348, -0.122757, -0.346361>,
                         <-14.1217, 2.62185, 15.3774>, <-0.292058, -0.0338986, -0.293235>,
                         <-14.5083, 2.50962, 15.6464>, <-0.201224, -0.00752745, -0.36542> }
        smooth_triangle {<-14.8117, 3.36905, 15.5216>, <-0.0978536, -0.108313, -0.275977>,
                         <-15.2345, 3.99387, 14.9619>, <-0.0181666, -0.125973, -0.126912>,
                         <-15.0787, 4.03909, 14.8536>, <-0.04241, -0.133011, -0.116455> }
        smooth_triangle {<-15.0787, 4.03909, 14.8536>, <-0.0681015, -0.213588, -0.187003>,
                         <-14.4671, 3.46907, 15.2819>, <-0.143662, -0.204928, -0.291989>,
                         <-14.8117, 3.36905, 15.5216>, <-0.0968385, -0.154776, -0.27137> }
        smooth_triangle {<-11.7937, -8.54399, 18.5>, <0.143609, -0.95931, -0.651295>,
                         <-11.9411, -8.03637, 17.7198>, <0.210658, -0.852829, -0.612526>,
                         <-10.7577, -7.69283, 17.4747>, <-0.0118571, -0.91743, -0.552326> }
        smooth_triangle {<-10.7577, -7.69283, 17.4747>, <0.0357087, -0.986011, -0.616521>,
                         <-10.3237, -8.1172, 18.1955>, <0.0460646, -1.1089, -0.680624>,
                         <-11.7937, -8.54399, 18.5>, <0.161008, -1.07553, -0.7302> }
        smooth_triangle {<-11.9411, -8.03637, 17.7198>, <0.210658, -0.852829, -0.612526>,
                         <-12.099, -7.4922, 16.9672>, <0.148501, -0.613899, -0.500184>,
                         <-11.1923, -7.22896, 16.7794>, <-0.0332339, -0.666661, -0.451184> }
        smooth_triangle {<-11.1923, -7.22896, 16.7794>, <0.0063735, -0.732333, -0.512937>,
                         <-10.7577, -7.69283, 17.4747>, <0.0224061, -0.920409, -0.588793>,
                         <-11.9411, -8.03637, 17.7198>, <0.189293, -0.871958, -0.633944> }
        smooth_triangle {<-12.099, -7.4922, 16.9672>, <0.148501, -0.613899, -0.500184>,
                         <-12.2761, -6.88221, 16.2714>, <0.0949516, -0.396648, -0.384595>,
                         <-11.6251, -6.69321, 16.1366>, <-0.0449719, -0.437271, -0.347894> }
        smooth_triangle {<-11.6251, -6.69321, 16.1366>, <-0.0165803, -0.493982, -0.410845>,
                         <-11.1923, -7.22896, 16.7794>, <-0.00777676, -0.666024, -0.488312>,
                         <-12.099, -7.4922, 16.9672>, <0.128524, -0.626453, -0.525062> }
        smooth_triangle {<-12.2761, -6.88221, 16.2714>, <0.0949516, -0.396648, -0.384595>,
                         <-12.4662, -6.22753, 15.6217>, <0.0422951, -0.212599, -0.288884>,
                         <-12.054, -6.10785, 15.5363>, <-0.0625084, -0.243026, -0.259754> }
        smooth_triangle {<-12.054, -6.10785, 15.5363>, <-0.0382536, -0.29441, -0.310346>,
                         <-11.6251, -6.69321, 16.1366>, <-0.0251012, -0.440094, -0.376451>,
                         <-12.2761, -6.88221, 16.2714>, <0.0798414, -0.409627, -0.403976> }
        smooth_triangle {<-12.4662, -6.22753, 15.6217>, <0.0422951, -0.212599, -0.288884>,
                         <-12.7097, -5.38894, 15.342>, <-0.0143162, -0.0382083, -0.310261>,
                         <-12.4002, -5.2991, 15.2779>, <-0.126556, -0.070794, -0.277306> }
        smooth_triangle {<-12.4002, -5.2991, 15.2779>, <-0.10445, -0.087117, -0.30169>,
                         <-12.054, -6.10785, 15.5363>, <-0.0564139, -0.216291, -0.288526>,
                         <-12.4662, -6.22753, 15.6217>, <0.0221887, -0.193471, -0.310373> }
        smooth_triangle {<-12.7097, -5.38894, 15.342>, <-0.0143162, -0.0382083, -0.310261>,
                         <-12.9657, -4.50689, 15.547>, <-0.0461793, 0.0608359, -0.383029>,
                         <-12.5809, -4.39518, 15.4673>, <-0.184944, 0.0205496, -0.343392> }
        smooth_triangle {<-12.5809, -4.39518, 15.4673>, <-0.157446, 0.0271688, -0.331535>,
                         <-12.4002, -5.2991, 15.2779>, <-0.113656, -0.0413389, -0.281971>,
                         <-12.7097, -5.38894, 15.342>, <-0.0294759, -0.0168996, -0.306687> }
        smooth_triangle {<-12.9657, -4.50689, 15.547>, <-0.0461793, 0.0608359, -0.383029>,
                         <-13.2254, -3.61249, 15.6589>, <-0.0249767, 0.00379068, -0.390636>,
                         <-12.7995, -3.48884, 15.5707>, <-0.166863, -0.0374019, -0.352126> }
        smooth_triangle {<-12.7995, -3.48884, 15.5707>, <-0.146093, -0.0224642, -0.357388>,
                         <-12.5809, -4.39518, 15.4673>, <-0.159653, 0.0209994, -0.350838>,
                         <-12.9657, -4.50689, 15.547>, <-0.0555801, 0.0512142, -0.380565> }
        smooth_triangle {<-13.2254, -3.61249, 15.6589>, <-0.0249767, 0.00379068, -0.390636>,
                         <-13.4828, -2.72601, 15.479>, <-0.00254215, -0.0625238, -0.330459>,
                         <-13.123, -2.62156, 15.4045>, <-0.122536, -0.0973606, -0.297699> }
        smooth_triangle {<-13.123, -2.62156, 15.4045>, <-0.10589, -0.097855, -0.32562>,
                         <-12.7995, -3.48884, 15.5707>, <-0.139135, -0.052886, -0.36644>,
                         <-13.2254, -3.61249, 15.6589>, <-0.0327209, -0.0219915, -0.395322> }
        smooth_triangle {<-13.4828, -2.72601, 15.479>, <-0.00254215, -0.0625238, -0.330459>,
                         <-13.7411, -1.83638, 15.3455>, <-0.0323553, 0.0167567, -0.332546>,
                         <-13.4303, -1.74617, 15.2811>, <-0.152639, -0.0181643, -0.29713> }
        smooth_triangle {<-13.4303, -1.74617, 15.2811>, <-0.127568, -0.030441, -0.309611>,
                         <-13.123, -2.62156, 15.4045>, <-0.10499, -0.0898383, -0.310038>,
                         <-13.4828, -2.72601, 15.479>, <-0.014995, -0.0637106, -0.334608> }
        smooth_triangle {<-13.7411, -1.83638, 15.3455>, <-0.0323553, 0.0167567, -0.332546>,
                         <-13.9832, -1.00244, 15.6982>, <-0.0514851, 0.0852021, -0.394591>,
                         <-13.5428, -0.874603, 15.607>, <-0.194623, 0.043646, -0.354724> }
        smooth_triangle {<-13.5428, -0.874603, 15.607>, <-0.167339, 0.0562366, -0.336285>,
                         <-13.4303, -1.74617, 15.2811>, <-0.135851, 0.00987885, -0.293089>,
                         <-13.7411, -1.83638, 15.3455>, <-0.0456386, 0.0360696, -0.319652> }
        smooth_triangle {<-13.9832, -1.00244, 15.6982>, <-0.0514851, 0.0852021, -0.394591>,
                         <-14.236, -0.131638, 15.6165>, <0.00146024, -0.0615153, -0.337462>,
                         <-13.8257, -0.012511, 15.5315>, <-0.121409, -0.0971868, -0.305747> }
        smooth_triangle {<-13.8257, -0.012511, 15.5315>, <-0.108302, -0.0876468, -0.333254>,
                         <-13.5428, -0.874603, 15.607>, <-0.163212, 0.0179779, -0.369987>,
                         <-13.9832, -1.00244, 15.6982>, <-0.0558591, 0.0491449, -0.399887> }
        smooth_triangle {<-14.236, -0.131638, 15.6165>, <0.00146024, -0.0615153, -0.337462>,
                         <-14.4747, 0.690763, 15.2248>, <-0.00514213, -0.0549231, -0.260159>,
                         <-14.2084, 0.768095, 15.1696>, <-0.0992723, -0.0822512, -0.232605> }
        smooth_triangle {<-14.2084, 0.768095, 15.1696>, <-0.0802618, -0.106945, -0.265928>,
                         <-13.8257, -0.012511, 15.5315>, <-0.0968641, -0.118146, -0.320784>,
                         <-14.236, -0.131638, 15.6165>, <-0.00471247, -0.0913928, -0.34457> }
        smooth_triangle {<-14.4747, 0.690763, 15.2248>, <-0.00514213, -0.0549231, -0.260159>,
                         <-14.72, 1.53557, 15.4073>, <-0.0529961, 0.0835755, -0.34234>,
                         <-14.3866, 1.63238, 15.3382>, <-0.176792, 0.0476349, -0.305721> }
        smooth_triangle {<-14.3866, 1.63238, 15.3382>, <-0.147774, 0.044496, -0.29029>,
                         <-14.2084, 0.768095, 15.1696>, <-0.0896346, -0.0529186, -0.235453>,
                         <-14.4747, 0.690763, 15.2248>, <-0.019037, -0.0324225, -0.256118> }
        smooth_triangle {<-14.72, 1.53557, 15.4073>, <-0.0529961, 0.0835755, -0.34234>,
                         <-14.9644, 2.37722, 15.7408>, <-0.0486464, 0.0759913, -0.405788>,
                         <-14.5083, 2.50962, 15.6464>, <-0.195911, 0.0332373, -0.365129> }
        smooth_triangle {<-14.5083, 2.50962, 15.6464>, <-0.169537, 0.0485133, -0.349919>,
                         <-14.3866, 1.63238, 15.3382>, <-0.155198, 0.0593115, -0.305363>,
                         <-14.72, 1.53557, 15.4073>, <-0.062351, 0.086267, -0.332827> }
        smooth_triangle {<-14.9644, 2.37722, 15.7408>, <-0.0486464, 0.0759913, -0.405788>,
                         <-15.2181, 3.25106, 15.6058>, <0.0126476, -0.0762319, -0.302488>,
                         <-14.8117, 3.36905, 15.5216>, <-0.0978536, -0.108313, -0.275977> }
        smooth_triangle {<-14.8117, 3.36905, 15.5216>, <-0.0895546, -0.102621, -0.315001>,
                         <-14.5083, 2.50962, 15.6464>, <-0.163097, 0.00354163, -0.381865>,
                         <-14.9644, 2.37722, 15.7408>, <-0.0526492, 0.0356072, -0.412359> }
        smooth_triangle {<-15.2181, 3.25106, 15.6058>, <0.0126476, -0.0762319, -0.302488>,
                         <-15.4182, 3.94052, 15>, <0.0323175, -0.111316, -0.137369>,
                         <-15.2345, 3.99387, 14.9619>, <-0.0181666, -0.125973, -0.126912> }
        smooth_triangle {<-15.2345, 3.99387, 14.9619>, <-0.00763141, -0.171659, -0.185875>,
                         <-14.8117, 3.36905, 15.5216>, <-0.0700304, -0.146993, -0.282933>,
                         <-15.2181, 3.25106, 15.6058>, <0.0128455, -0.122932, -0.302817> }
        smooth_triangle {<-13.2637, -8.97077, 18.1955>, <0.392436, -0.88707, -0.651295>,
                         <-13.1244, -8.37991, 17.4747>, <0.43836, -0.786722, -0.579475>,
                         <-11.9411, -8.03637, 17.7198>, <0.210658, -0.852829, -0.612526> }
        smooth_triangle {<-11.9411, -8.03637, 17.7198>, <0.279875, -0.915124, -0.661671>,
                         <-11.7937, -8.54399, 18.5>, <0.315567, -1.03066, -0.7302>,
                         <-13.2637, -8.97077, 18.1955>, <0.43998, -0.994541, -0.7302> }
        smooth_triangle {<-13.1244, -8.37991, 17.4747>, <0.43836, -0.786722, -0.579475>,
                         <-13.0057, -7.75544, 16.7794>, <0.33441, -0.559926, -0.473035>,
                         <-12.099, -7.4922, 16.9672>, <0.148501, -0.613899, -0.500184> }
        smooth_triangle {<-12.099, -7.4922, 16.9672>, <0.209361, -0.673401, -0.549687>,
                         <-11.9411, -8.03637, 17.7198>, <0.255979, -0.852598, -0.633944>,
                         <-13.1244, -8.37991, 17.4747>, <0.426755, -0.803018, -0.609155> }
        smooth_triangle {<-13.0057, -7.75544, 16.7794>, <0.33441, -0.559926, -0.473035>,
                         <-12.9271, -7.07121, 16.1366>, <0.237712, -0.355202, -0.362744>,
                         <-12.2761, -6.88221, 16.2714>, <0.0949516, -0.396648, -0.384595> }
        smooth_triangle {<-12.2761, -6.88221, 16.2714>, <0.145641, -0.446886, -0.43837>,
                         <-12.099, -7.4922, 16.9672>, <0.185803, -0.609824, -0.525062>,
                         <-13.0057, -7.75544, 16.7794>, <0.325234, -0.569344, -0.5047> }
        smooth_triangle {<-12.9271, -7.07121, 16.1366>, <0.237712, -0.355202, -0.362744>,
                         <-12.8784, -6.34722, 15.5363>, <0.149826, -0.18138, -0.274034>,
                         <-12.4662, -6.22753, 15.6217>, <0.0422951, -0.212599, -0.288884> }
        smooth_triangle {<-12.4662, -6.22753, 15.6217>, <0.0844872, -0.258776, -0.332193>,
                         <-12.2761, -6.88221, 16.2714>, <0.12398, -0.396812, -0.403976>,
                         <-12.9271, -7.07121, 16.1366>, <0.23105, -0.365728, -0.387588> }
        smooth_triangle {<-12.8784, -6.34722, 15.5363>, <0.149826, -0.18138, -0.274034>,
                         <-13.0191, -5.47879, 15.2779>, <0.101491, -0.0045868, -0.295982>,
                         <-12.7097, -5.38894, 15.342>, <-0.0143162, -0.0382083, -0.310261> }
        smooth_triangle {<-12.7097, -5.38894, 15.342>, <0.0155322, -0.0522836, -0.326406>,
                         <-12.4662, -6.22753, 15.6217>, <0.0579907, -0.183077, -0.310373>,
                         <-12.8784, -6.34722, 15.5363>, <0.138639, -0.159663, -0.299236> }
        smooth_triangle {<-13.0191, -5.47879, 15.2779>, <0.101491, -0.0045868, -0.295982>,
                         <-13.3505, -4.61861, 15.4673>, <0.0965891, 0.102285, -0.364353>,
                         <-12.9657, -4.50689, 15.547>, <-0.0461793, 0.0608359, -0.383029> }
        smooth_triangle {<-12.9657, -4.50689, 15.547>, <-0.0251048, 0.0655905, -0.361263>,
                         <-12.7097, -5.38894, 15.342>, <-0.00120749, -0.00869265, -0.306687>,
                         <-13.0191, -5.47879, 15.2779>, <0.0856481, 0.0165235, -0.295978> }
        smooth_triangle {<-13.3505, -4.61861, 15.4673>, <0.0965891, 0.102285, -0.364353>,
                         <-13.6513, -3.73614, 15.5707>, <0.120262, 0.0459566, -0.369675>,
                         <-13.2254, -3.61249, 15.6589>, <-0.0249767, 0.00379068, -0.390636> }
        smooth_triangle {<-13.2254, -3.61249, 15.6589>, <-0.00403535, 0.0187781, -0.386271>,
                         <-12.9657, -4.50689, 15.547>, <-0.0199373, 0.0615621, -0.380565>,
                         <-13.3505, -4.61861, 15.4673>, <0.087139, 0.0926487, -0.366558> }
        smooth_triangle {<-13.6513, -3.73614, 15.5707>, <0.120262, 0.0459566, -0.369675>,
                         <-13.8426, -2.83047, 15.4045>, <0.120357, -0.0268434, -0.31291>,
                         <-13.4828, -2.72601, 15.479>, <-0.00254215, -0.0625238, -0.330459> }
        smooth_triangle {<-13.4828, -2.72601, 15.479>, <0.0232061, -0.0603755, -0.35019>,
                         <-13.2254, -3.61249, 15.6589>, <0.00638015, -0.0106396, -0.395322>,
                         <-13.6513, -3.73614, 15.5707>, <0.115309, 0.0209848, -0.379602> }
        smooth_triangle {<-13.8426, -2.83047, 15.4045>, <0.120357, -0.0268434, -0.31291>,
                         <-14.0518, -1.92659, 15.2811>, <0.0917882, 0.0527983, -0.317336>,
                         <-13.7411, -1.83638, 15.3455>, <-0.0323553, 0.0167567, -0.332546> }
        smooth_triangle {<-13.7411, -1.83638, 15.3455>, <-0.00420693, 0.00537333, -0.336173>,
                         <-13.4828, -2.72601, 15.479>, <0.0181529, -0.0540871, -0.334608>,
                         <-13.8426, -2.83047, 15.4045>, <0.110327, -0.0273268, -0.321446> }
        smooth_triangle {<-14.0518, -1.92659, 15.2811>, <0.0917882, 0.0527983, -0.317336>,
                         <-14.4235, -1.13029, 15.607>, <0.0954084, 0.127848, -0.374385>,
                         <-13.9832, -1.00244, 15.6982>, <-0.0514851, 0.0852021, -0.394591> }
        smooth_triangle {<-13.9832, -1.00244, 15.6982>, <-0.0331499, 0.0951947, -0.366185>,
                         <-13.7411, -1.83638, 15.3455>, <-0.0188026, 0.0438607, -0.319652>,
                         <-14.0518, -1.92659, 15.2811>, <0.074305, 0.0708919, -0.308244> }
        smooth_triangle {<-14.4235, -1.13029, 15.607>, <0.0954084, 0.127848, -0.374385>,
                         <-14.6463, -0.250764, 15.5315>, <0.126632, -0.0251752, -0.317801>,
                         <-14.236, -0.131638, 15.6165>, <0.00146024, -0.0615153, -0.337462> }
        smooth_triangle {<-14.236, -0.131638, 15.6165>, <0.0235616, -0.0493639, -0.35704>,
                         <-13.9832, -1.00244, 15.6982>, <-0.0161473, 0.0606741, -0.399887>,
                         <-14.4235, -1.13029, 15.607>, <0.0940227, 0.0926589, -0.384733> }
        smooth_triangle {<-14.6463, -0.250764, 15.5315>, <0.126632, -0.0251752, -0.317801>,
                         <-14.7411, 0.613431, 15.1696>, <0.0919488, -0.0267355, -0.248105>,
                         <-14.4747, 0.690763, 15.2248>, <-0.00514213, -0.0549231, -0.260159> }
        smooth_triangle {<-14.4747, 0.690763, 15.2248>, <0.0252832, -0.0763026, -0.286593>,
                         <-14.236, -0.131638, 15.6165>, <0.030235, -0.0812467, -0.34457>,
                         <-14.6463, -0.250764, 15.5315>, <0.124114, -0.0539917, -0.329824> }
        smooth_triangle {<-14.7411, 0.613431, 15.1696>, <0.0919488, -0.0267355, -0.248105>,
                         <-15.0534, 1.43877, 15.3382>, <0.0748338, 0.120687, -0.32684>,
                         <-14.72, 1.53557, 15.4073>, <-0.0529961, 0.0835755, -0.34234> }
        smooth_triangle {<-14.72, 1.53557, 15.4073>, <-0.0316231, 0.0782173, -0.317753>,
                         <-14.4747, 0.690763, 15.2248>, <0.00426744, -0.0256567, -0.256118>,
                         <-14.7411, 0.613431, 15.1696>, <0.0770857, -0.00451598, -0.247077> }
        smooth_triangle {<-15.0534, 1.43877, 15.3382>, <0.0748338, 0.120687, -0.32684>,
                         <-15.4204, 2.24483, 15.6464>, <0.10235, 0.119829, -0.384669>,
                         <-14.9644, 2.37722, 15.7408>, <-0.0486464, 0.0759913, -0.405788> }
        smooth_triangle {<-14.9644, 2.37722, 15.7408>, <-0.0300253, 0.0890166, -0.380413>,
                         <-14.72, 1.53557, 15.4073>, <-0.0332876, 0.0947048, -0.332827>,
                         <-15.0534, 1.43877, 15.3382>, <0.0625849, 0.122539, -0.321203> }
        smooth_triangle {<-15.4204, 2.24483, 15.6464>, <0.10235, 0.119829, -0.384669>,
                         <-15.6244, 3.13308, 15.5216>, <0.12448, -0.0437643, -0.282948>,
                         <-15.2181, 3.25106, 15.6058>, <0.0126476, -0.0762319, -0.302488> }
        smooth_triangle {<-15.2181, 3.25106, 15.6058>, <0.0345896, -0.0665791, -0.334884>,
                         <-14.9644, 2.37722, 15.7408>, <-0.0113809, 0.0475883, -0.412359>,
                         <-15.4204, 2.24483, 15.6464>, <0.101867, 0.0804666, -0.39652> }
        smooth_triangle {<-15.6244, 3.13308, 15.5216>, <0.12448, -0.0437643, -0.282948>,
                         <-15.602, 3.88717, 14.9619>, <0.0828016, -0.0966594, -0.126912>,
                         <-15.4182, 3.94052, 15>, <0.0323175, -0.111316, -0.137369> }
        smooth_triangle {<-15.4182, 3.94052, 15>, <0.0647137, -0.150656, -0.192846>,
                         <-15.2181, 3.25106, 15.6058>, <0.0418623, -0.114508, -0.302817>,
                         <-15.6244, 3.13308, 15.5216>, <0.125737, -0.0901571, -0.288161> }
        smooth_triangle {<-14.51, -9.33258, 17.3284>, <0.622322, -0.820329, -0.552141>,
                         <-14.1275, -8.67115, 16.7768>, <0.636582, -0.729174, -0.458204>,
                         <-13.1244, -8.37991, 17.4747>, <0.43836, -0.786722, -0.579475> }
        smooth_triangle {<-13.1244, -8.37991, 17.4747>, <0.522048, -0.844816, -0.606088>,
                         <-13.2637, -8.97077, 18.1955>, <0.582775, -0.953084, -0.668611>,
                         <-14.51, -9.33258, 17.3284>, <0.697718, -0.919714, -0.619034> }
        smooth_triangle {<-14.1275, -8.67115, 16.7768>, <0.636582, -0.729174, -0.458204>,
                         <-13.7744, -7.9786, 16.2445>, <0.496189, -0.512958, -0.37387>,
                         <-13.0057, -7.75544, 16.7794>, <0.33441, -0.559926, -0.473035> }
        smooth_triangle {<-13.0057, -7.75544, 16.7794>, <0.410403, -0.615034, -0.502752>,
                         <-13.1244, -8.37991, 17.4747>, <0.488366, -0.785131, -0.582582>,
                         <-14.1275, -8.67115, 16.7768>, <0.637032, -0.74197, -0.491628> }
        smooth_triangle {<-13.7744, -7.9786, 16.2445>, <0.496189, -0.512958, -0.37387>,
                         <-13.479, -7.23144, 15.7526>, <0.361575, -0.319242, -0.28567>,
                         <-12.9271, -7.07121, 16.1366>, <0.237712, -0.355202, -0.362744> }
        smooth_triangle {<-12.9271, -7.07121, 16.1366>, <0.305629, -0.400437, -0.399158>,
                         <-13.0057, -7.75544, 16.7794>, <0.378153, -0.553981, -0.481875>,
                         <-13.7744, -7.9786, 16.2445>, <0.499487, -0.518754, -0.407502> }
        smooth_triangle {<-13.479, -7.23144, 15.7526>, <0.361575, -0.319242, -0.28567>,
                         <-13.2279, -6.44868, 15.2932>, <0.243715, -0.154123, -0.217464>,
                         <-12.8784, -6.34722, 15.5363>, <0.149826, -0.18138, -0.274034> }
        smooth_triangle {<-12.8784, -6.34722, 15.5363>, <0.205914, -0.223523, -0.303467>,
                         <-12.9271, -7.07121, 16.1366>, <0.271828, -0.353889, -0.37>,
                         <-13.479, -7.23144, 15.7526>, <0.364726, -0.326919, -0.312194> }
        smooth_triangle {<-13.2279, -6.44868, 15.2932>, <0.243715, -0.154123, -0.217464>,
                         <-13.2815, -5.55495, 15.0954>, <0.203236, 0.0249519, -0.236642>,
                         <-13.0191, -5.47879, 15.2779>, <0.101491, -0.0045868, -0.295982> }
        smooth_triangle {<-13.0191, -5.47879, 15.2779>, <0.135465, -0.0174645, -0.30143>,
                         <-12.8784, -6.34722, 15.5363>, <0.171716, -0.15006, -0.284969>,
                         <-13.2279, -6.44868, 15.2932>, <0.242132, -0.129616, -0.242542> }
        smooth_triangle {<-13.2815, -5.55495, 15.0954>, <0.203236, 0.0249519, -0.236642>,
                         <-13.6768, -4.71332, 15.2404>, <0.221626, 0.138586, -0.290207>,
                         <-13.3505, -4.61861, 15.4673>, <0.0965891, 0.102285, -0.364353> }
        smooth_triangle {<-13.3505, -4.61861, 15.4673>, <0.108088, 0.104259, -0.335991>,
                         <-13.0191, -5.47879, 15.2779>, <0.111765, 0.0241057, -0.284713>,
                         <-13.2815, -5.55495, 15.0954>, <0.188073, 0.0462597, -0.240209> }
        smooth_triangle {<-13.6768, -4.71332, 15.2404>, <0.221626, 0.138586, -0.290207>,
                         <-14.0124, -3.84097, 15.3195>, <0.246741, 0.0826763, -0.292435>,
                         <-13.6513, -3.73614, 15.5707>, <0.120262, 0.0459566, -0.369675> }
        smooth_triangle {<-13.6513, -3.73614, 15.5707>, <0.137823, 0.0599628, -0.356347>,
                         <-13.3505, -4.61861, 15.4673>, <0.120069, 0.102209, -0.352355>,
                         <-13.6768, -4.71332, 15.2404>, <0.213847, 0.129435, -0.296746> }
        smooth_triangle {<-14.0124, -3.84097, 15.3195>, <0.246741, 0.0826763, -0.292435>,
                         <-14.1476, -2.91902, 15.1922>, <0.227452, 0.00424854, -0.247723>,
                         <-13.8426, -2.83047, 15.4045>, <0.120357, -0.0268434, -0.31291> }
        smooth_triangle {<-13.8426, -2.83047, 15.4045>, <0.151505, -0.0231274, -0.321447>,
                         <-13.6513, -3.73614, 15.5707>, <0.151434, 0.0314726, -0.364021>,
                         <-14.0124, -3.84097, 15.3195>, <0.246293, 0.0590124, -0.30609> }
        smooth_triangle {<-14.1476, -2.91902, 15.1922>, <0.227452, 0.00424854, -0.247723>,
                         <-14.3152, -2.00307, 15.0979>, <0.200892, 0.0844735, -0.253814>,
                         <-14.0518, -1.92659, 15.2811>, <0.0917882, 0.0527983, -0.317336> }
        smooth_triangle {<-14.0518, -1.92659, 15.2811>, <0.119525, 0.0412955, -0.311556>,
                         <-13.8426, -2.83047, 15.4045>, <0.140952, -0.0184358, -0.308237>,
                         <-14.1476, -2.91902, 15.1922>, <0.221273, 0.0048832, -0.259346> }
        smooth_triangle {<-14.3152, -2.00307, 15.0979>, <0.200892, 0.0844735, -0.253814>,
                         <-14.7968, -1.23867, 15.3472>, <0.223694, 0.165093, -0.297182>,
                         <-14.4235, -1.13029, 15.607>, <0.0954084, 0.127848, -0.374385> }
        smooth_triangle {<-14.4235, -1.13029, 15.607>, <0.101813, 0.134378, -0.340337>,
                         <-14.0518, -1.92659, 15.2811>, <0.0990982, 0.0780899, -0.29755>,
                         <-14.3152, -2.00307, 15.0979>, <0.180926, 0.101846, -0.249909> }
        smooth_triangle {<-14.7968, -1.23867, 15.3472>, <0.223694, 0.165093, -0.297182>,
                         <-14.9942, -0.351755, 15.2895>, <0.235049, 0.00630082, -0.249758>,
                         <-14.6463, -0.250764, 15.5315>, <0.126632, -0.0251752, -0.317801> }
        smooth_triangle {<-14.6463, -0.250764, 15.5315>, <0.154129, -0.0114573, -0.32647>,
                         <-14.4235, -1.13029, 15.607>, <0.130712, 0.10331, -0.368908>,
                         <-14.7968, -1.23867, 15.3472>, <0.226926, 0.131244, -0.311006> }
        smooth_triangle {<-14.9942, -0.351755, 15.2895>, <0.235049, 0.00630082, -0.249758>,
                         <-14.9669, 0.547873, 15.0125>, <0.177219, -0.00197955, -0.19828>,
                         <-14.7411, 0.613431, 15.1696>, <0.0919488, -0.0267355, -0.248105> }
        smooth_triangle {<-14.7411, 0.613431, 15.1696>, <0.130389, -0.0457882, -0.263626>,
                         <-14.6463, -0.250764, 15.5315>, <0.156401, -0.044618, -0.315898>,
                         <-14.9942, -0.351755, 15.2895>, <0.237714, -0.0210109, -0.264866> }
        smooth_triangle {<-14.9669, 0.547873, 15.0125>, <0.177219, -0.00197955, -0.19828>,
                         <-15.3361, 1.3567, 15.1415>, <0.187237, 0.153321, -0.261582>,
                         <-15.0534, 1.43877, 15.3382>, <0.0748338, 0.120687, -0.32684> }
        smooth_triangle {<-15.0534, 1.43877, 15.3382>, <0.0857799, 0.112302, -0.296842>,
                         <-14.7411, 0.613431, 15.1696>, <0.0986162, 0.00173481, -0.237791>,
                         <-14.9669, 0.547873, 15.0125>, <0.162569, 0.0203018, -0.200422> }
        smooth_triangle {<-15.3361, 1.3567, 15.1415>, <0.187237, 0.153321, -0.261582>,
                         <-15.807, 2.1326, 15.3774>, <0.234092, 0.158077, -0.304988>,
                         <-15.4204, 2.24483, 15.6464>, <0.10235, 0.119829, -0.384669> }
        smooth_triangle {<-15.4204, 2.24483, 15.6464>, <0.110073, 0.12969, -0.352993>,
                         <-15.0534, 1.43877, 15.3382>, <0.089436, 0.130334, -0.309621>,
                         <-15.3361, 1.3567, 15.1415>, <0.173738, 0.154809, -0.260678> }
        smooth_triangle {<-15.807, 2.1326, 15.3774>, <0.234092, 0.158077, -0.304988>,
                         <-15.969, 3.03306, 15.2819>, <0.220619, -0.0158531, -0.220332>,
                         <-15.6244, 3.13308, 15.5216>, <0.12448, -0.0437643, -0.282948> }
        smooth_triangle {<-15.6244, 3.13308, 15.5216>, <0.156591, -0.0311594, -0.303785>,
                         <-15.4204, 2.24483, 15.6464>, <0.139994, 0.0915356, -0.380075>,
                         <-15.807, 2.1326, 15.3774>, <0.2388, 0.120221, -0.320314> }
        smooth_triangle {<-15.969, 3.03306, 15.2819>, <0.220619, -0.0158531, -0.220332>,
                         <-15.7577, 3.84194, 14.8536>, <0.1256, -0.084234, -0.0971343>,
                         <-15.602, 3.88717, 14.9619>, <0.0828016, -0.0966594, -0.126912> }
        smooth_triangle {<-15.602, 3.88717, 14.9619>, <0.134114, -0.130507, -0.170458>,
                         <-15.6244, 3.13308, 15.5216>, <0.152545, -0.0823742, -0.276599>,
                         <-15.969, 3.03306, 15.2819>, <0.224649, -0.0614407, -0.229636> }
        smooth_triangle {<-15.3427, -9.57433, 16.0307>, <0.798269, -0.769248, -0.368929>,
                         <-14.7978, -8.86575, 15.7322>, <0.775148, -0.688945, -0.267175>,
                         <-14.1275, -8.67115, 16.7768>, <0.636582, -0.729174, -0.458204> }
        smooth_triangle {<-14.1275, -8.67115, 16.7768>, <0.72536, -0.78579, -0.458233>,
                         <-14.51, -9.33258, 17.3284>, <0.807007, -0.887984, -0.505231>,
                         <-15.3427, -9.57433, 16.0307>, <0.894981, -0.862444, -0.413625> }
        smooth_triangle {<-14.7978, -8.86575, 15.7322>, <0.775148, -0.688945, -0.267175>,
                         <-14.288, -8.12771, 15.4441>, <0.609211, -0.480145, -0.217788>,
                         <-13.7744, -7.9786, 16.2445>, <0.496189, -0.512958, -0.37387> }
        smooth_triangle {<-13.7744, -7.9786, 16.2445>, <0.578892, -0.566118, -0.379277>,
                         <-14.1275, -8.67115, 16.7768>, <0.684187, -0.72828, -0.442527>,
                         <-14.7978, -8.86575, 15.7322>, <0.788111, -0.698108, -0.299256> }
        smooth_triangle {<-14.288, -8.12771, 15.4441>, <0.609211, -0.480145, -0.217788>,
                         <-13.8478, -7.3385, 15.1779>, <0.447684, -0.294242, -0.165104>,
                         <-13.479, -7.23144, 15.7526>, <0.361575, -0.319242, -0.28567> }
        smooth_triangle {<-13.479, -7.23144, 15.7526>, <0.439029, -0.361709, -0.299177>,
                         <-13.7744, -7.9786, 16.2445>, <0.539989, -0.506996, -0.365328>,
                         <-14.288, -8.12771, 15.4441>, <0.624755, -0.482386, -0.248266> }
        smooth_triangle {<-13.8478, -7.3385, 15.1779>, <0.447684, -0.294242, -0.165104>,
                         <-13.4615, -6.51647, 14.9293>, <0.309666, -0.134975, -0.127788>,
                         <-13.2279, -6.44868, 15.2932>, <0.243715, -0.154123, -0.217464> }
        smooth_triangle {<-13.2279, -6.44868, 15.2932>, <0.307541, -0.194018, -0.228541>,
                         <-13.479, -7.23144, 15.7526>, <0.395936, -0.317858, -0.279695>,
                         <-13.8478, -7.3385, 15.1779>, <0.460518, -0.299108, -0.189271> }
        smooth_triangle {<-13.4615, -6.51647, 14.9293>, <0.309666, -0.134975, -0.127788>,
                         <-13.4568, -5.60584, 14.8222>, <0.275427, 0.0459107, -0.141276>,
                         <-13.2815, -5.55495, 15.0954>, <0.203236, 0.0249519, -0.236642> }
        smooth_triangle {<-13.2815, -5.55495, 15.0954>, <0.237089, 0.0120392, -0.230564>,
                         <-13.2279, -6.44868, 15.2932>, <0.267448, -0.122267, -0.216181>,
                         <-13.4615, -6.51647, 14.9293>, <0.316912, -0.107906, -0.148923> }
        smooth_triangle {<-13.4568, -5.60584, 14.8222>, <0.275427, 0.0459107, -0.141276>,
                         <-13.8947, -4.7766, 14.9007>, <0.309897, 0.164213, -0.171881>,
                         <-13.6768, -4.71332, 15.2404>, <0.221626, 0.138586, -0.290207> }
        smooth_triangle {<-13.6768, -4.71332, 15.2404>, <0.221855, 0.137288, -0.259568>,
                         <-13.2815, -5.55495, 15.0954>, <0.208062, 0.0520628, -0.219394>,
                         <-13.4568, -5.60584, 14.8222>, <0.262206, 0.067782, -0.14787> }
        smooth_triangle {<-13.8947, -4.7766, 14.9007>, <0.309897, 0.164213, -0.171881>,
                         <-14.2536, -3.91101, 14.9435>, <0.335206, 0.10836, -0.170674>,
                         <-14.0124, -3.84097, 15.3195>, <0.246741, 0.0826763, -0.292435> }
        smooth_triangle {<-14.0124, -3.84097, 15.3195>, <0.257886, 0.0948197, -0.272173>,
                         <-13.6768, -4.71332, 15.2404>, <0.23905, 0.136752, -0.270502>,
                         <-13.8947, -4.7766, 14.9007>, <0.305252, 0.155972, -0.181757> }
        smooth_triangle {<-14.2536, -3.91101, 14.9435>, <0.335206, 0.10836, -0.170674>,
                         <-14.3514, -2.97818, 14.8746>, <0.302438, 0.0260186, -0.144822>,
                         <-14.1476, -2.91902, 15.1922>, <0.227452, 0.00424854, -0.247723> }
        smooth_triangle {<-14.1476, -2.91902, 15.1922>, <0.259475, 0.00821854, -0.243766>,
                         <-14.0124, -3.84097, 15.3195>, <0.273942, 0.0670394, -0.2773>,
                         <-14.2536, -3.91101, 14.9435>, <0.340291, 0.086302, -0.185979> }
        smooth_triangle {<-14.3514, -2.97818, 14.8746>, <0.302438, 0.0260186, -0.144822>,
                         <-14.4912, -2.05417, 14.8236>, <0.278346, 0.10696, -0.151651>,
                         <-14.3152, -2.00307, 15.0979>, <0.200892, 0.0844735, -0.253814> }
        smooth_triangle {<-14.3152, -2.00307, 15.0979>, <0.224792, 0.0718568, -0.239508>,
                         <-14.1476, -2.91902, 15.1922>, <0.244712, 0.0116881, -0.234939>,
                         <-14.3514, -2.97818, 14.8746>, <0.300952, 0.0280156, -0.157764> }
        smooth_triangle {<-14.4912, -2.05417, 14.8236>, <0.278346, 0.10696, -0.151651>,
                         <-15.0462, -1.31108, 14.9585>, <0.313843, 0.191265, -0.174736>,
                         <-14.7968, -1.23867, 15.3472>, <0.223694, 0.165093, -0.297182> }
        smooth_triangle {<-14.7968, -1.23867, 15.3472>, <0.217004, 0.16782, -0.262676>,
                         <-14.3152, -2.00307, 15.0979>, <0.199902, 0.107355, -0.230149>,
                         <-14.4912, -2.05417, 14.8236>, <0.257992, 0.12422, -0.153527> }
        smooth_triangle {<-15.0462, -1.31108, 14.9585>, <0.313843, 0.191265, -0.174736>,
                         <-15.2266, -0.419235, 14.9273>, <0.310208, 0.028121, -0.143691>,
                         <-14.9942, -0.351755, 15.2895>, <0.235049, 0.00630082, -0.249758> }
        smooth_triangle {<-14.9942, -0.351755, 15.2895>, <0.263523, 0.0203021, -0.246198>,
                         <-14.7968, -1.23867, 15.3472>, <0.255006, 0.139396, -0.281766>,
                         <-15.0462, -1.31108, 14.9585>, <0.322618, 0.159025, -0.189932> }
        smooth_triangle {<-15.2266, -0.419235, 14.9273>, <0.310208, 0.028121, -0.143691>,
                         <-15.1178, 0.504068, 14.7774>, <0.237688, 0.0155758, -0.118268>,
                         <-14.9669, 0.547873, 15.0125>, <0.177219, -0.00197955, -0.19828> }
        smooth_triangle {<-14.9669, 0.547873, 15.0125>, <0.219053, -0.0200469, -0.200526>,
                         <-14.9942, -0.351755, 15.2895>, <0.262426, -0.0138366, -0.239134>,
                         <-15.2266, -0.419235, 14.9273>, <0.318795, 0.00252849, -0.159584> }
        smooth_triangle {<-15.1178, 0.504068, 14.7774>, <0.237688, 0.0155758, -0.118268>,
                         <-15.525, 1.30187, 14.8472>, <0.267101, 0.176507, -0.1565>,
                         <-15.3361, 1.3567, 15.1415>, <0.187237, 0.153321, -0.261582> }
        smooth_triangle {<-15.3361, 1.3567, 15.1415>, <0.186561, 0.141561, -0.230739>,
                         <-14.9669, 0.547873, 15.0125>, <0.179048, 0.0250859, -0.183263>,
                         <-15.1178, 0.504068, 14.7774>, <0.224399, 0.0382524, -0.123254> }
        smooth_triangle {<-15.525, 1.30187, 14.8472>, <0.267101, 0.176507, -0.1565>,
                         <-16.0653, 2.0576, 14.9748>, <0.326522, 0.184911, -0.178875>,
                         <-15.807, 2.1326, 15.3774>, <0.234092, 0.158077, -0.304988> }
        smooth_triangle {<-15.807, 2.1326, 15.3774>, <0.229431, 0.164342, -0.271833>,
                         <-15.3361, 1.3567, 15.1415>, <0.194289, 0.160775, -0.239278>,
                         <-15.525, 1.30187, 14.8472>, <0.254187, 0.178165, -0.160467> }
        smooth_triangle {<-16.0653, 2.0576, 14.9748>, <0.326522, 0.184911, -0.178875>,
                         <-16.1992, 2.96623, 14.9232>, <0.286428, 0.00325268, -0.124172>,
                         <-15.969, 3.03306, 15.2819>, <0.220619, -0.0158531, -0.220332> }
        smooth_triangle {<-15.969, 3.03306, 15.2819>, <0.257876, -0.00175401, -0.226436>,
                         <-15.807, 2.1326, 15.3774>, <0.267981, 0.128693, -0.289928>,
                         <-16.0653, 2.0576, 14.9748>, <0.337303, 0.148819, -0.195344> }
        smooth_triangle {<-16.1992, 2.96623, 14.9232>, <0.286428, 0.00325268, -0.124172>,
                         <-15.8618, 3.81173, 14.6913>, <0.154197, -0.0759317, -0.0525687>,
                         <-15.7577, 3.84194, 14.8536>, <0.1256, -0.084234, -0.0971343> }
        smooth_triangle {<-15.7577, 3.84194, 14.8536>, <0.190003, -0.114282, -0.122119>,
                         <-15.969, 3.03306, 15.2819>, <0.245167, -0.0554839, -0.208271>,
                         <-16.1992, 2.96623, 14.9232>, <0.294524, -0.0411546, -0.136151> }
        smooth_triangle {<-15.6351, -9.65922, 14.5>, <0.893491, -0.741603, -0.129551>,
                         <-15.0332, -8.93409, 14.5>, <0.802696, -0.637439, -0.117983>,
                         <-14.7978, -8.86575, 15.7322>, <0.775148, -0.688945, -0.267175> }
        smooth_triangle {<-14.7978, -8.86575, 15.7322>, <0.858858, -0.747033, -0.240617>,
                         <-15.3427, -9.57433, 16.0307>, <0.954128, -0.845272, -0.264935>,
                         <-15.6351, -9.65922, 14.5>, <1.00174, -0.831449, -0.145246> }
        smooth_triangle {<-15.0332, -8.93409, 14.5>, <0.802696, -0.637439, -0.117983>,
                         <-14.4684, -8.18007, 14.5>, <0.628451, -0.433087, -0.0960312>,
                         <-14.288, -8.12771, 15.4441>, <0.609211, -0.480145, -0.217788> }
        smooth_triangle {<-14.288, -8.12771, 15.4441>, <0.689178, -0.5341, -0.198061>,
                         <-14.7978, -8.86575, 15.7322>, <0.813631, -0.690699, -0.235101>,
                         <-15.0332, -8.93409, 14.5>, <0.844823, -0.656947, -0.124949> }
        smooth_triangle {<-14.4684, -8.18007, 14.5>, <0.628451, -0.433087, -0.0960312>,
                         <-13.9773, -7.37609, 14.5>, <0.451893, -0.259565, -0.0719277>,
                         <-13.8478, -7.3385, 15.1779>, <0.447684, -0.294242, -0.165104> }
        smooth_triangle {<-13.8478, -7.3385, 15.1779>, <0.52553, -0.336595, -0.15365>,
                         <-14.288, -8.12771, 15.4441>, <0.646675, -0.476023, -0.193162>,
                         <-14.4684, -8.18007, 14.5>, <0.67199, -0.443277, -0.103783> }
        smooth_triangle {<-13.9773, -7.37609, 14.5>, <0.451893, -0.259565, -0.0719277>,
                         <-13.5435, -6.54028, 14.5>, <0.327068, -0.0971649, -0.0570895>,
                         <-13.4615, -6.51647, 14.9293>, <0.309666, -0.134975, -0.127788> }
        smooth_triangle {<-13.4615, -6.51647, 14.9293>, <0.373895, -0.174754, -0.118821>,
                         <-13.8478, -7.3385, 15.1779>, <0.477409, -0.294204, -0.146808>,
                         <-13.9773, -7.37609, 14.5>, <0.490123, -0.271074, -0.0785923> }
        smooth_triangle {<-13.5435, -6.54028, 14.5>, <0.327068, -0.0971649, -0.0570895>,
                         <-13.5183, -5.62371, 14.5>, <0.312938, 0.0866976, -0.0645871>,
                         <-13.4568, -5.60584, 14.8222>, <0.275427, 0.0459107, -0.141276> }
        smooth_triangle {<-13.4568, -5.60584, 14.8222>, <0.304933, 0.031736, -0.124597>,
                         <-13.4615, -6.51647, 14.9293>, <0.330612, -0.103929, -0.114481>,
                         <-13.5435, -6.54028, 14.5>, <0.349196, -0.0683727, -0.0629132> }
        smooth_triangle {<-13.5183, -5.62371, 14.5>, <0.312938, 0.0866976, -0.0645871>,
                         <-13.9713, -4.79882, 14.5>, <0.356679, 0.172149, -0.0776817>,
                         <-13.8947, -4.7766, 14.9007>, <0.309897, 0.164213, -0.171881> }
        smooth_triangle {<-13.8947, -4.7766, 14.9007>, <0.298875, 0.159649, -0.143628>,
                         <-13.4568, -5.60584, 14.8222>, <0.273023, 0.0709226, -0.120675>,
                         <-13.5183, -5.62371, 14.5>, <0.297229, 0.106451, -0.0626818> }
        smooth_triangle {<-13.9713, -4.79882, 14.5>, <0.356679, 0.172149, -0.0776817>,
                         <-14.3384, -3.9356, 14.5>, <0.366868, 0.0972431, -0.0754738>,
                         <-14.2536, -3.91101, 14.9435>, <0.335206, 0.10836, -0.170674> }
        smooth_triangle {<-14.2536, -3.91101, 14.9435>, <0.337875, 0.118042, -0.146563>,
                         <-13.8947, -4.7766, 14.9007>, <0.318892, 0.159932, -0.147468>,
                         <-13.9713, -4.79882, 14.5>, <0.353079, 0.163796, -0.0765308> }
        smooth_triangle {<-14.3384, -3.9356, 14.5>, <0.366868, 0.0972431, -0.0754738>,
                         <-14.4229, -2.99896, 14.5>, <0.325396, 0.0368874, -0.0642045>,
                         <-14.3514, -2.97818, 14.8746>, <0.302438, 0.0260186, -0.144822> }
        smooth_triangle {<-14.3514, -2.97818, 14.8746>, <0.330677, 0.0288902, -0.128974>,
                         <-14.2536, -3.91101, 14.9435>, <0.355254, 0.0906461, -0.148363>,
                         <-14.3384, -3.9356, 14.5>, <0.383044, 0.0773305, -0.0774596> }
        smooth_triangle {<-14.4229, -2.99896, 14.5>, <0.325396, 0.0368874, -0.0642045>,
                         <-14.553, -2.07211, 14.5>, <0.318592, 0.154205, -0.0694109>,
                         <-14.4912, -2.05417, 14.8236>, <0.278346, 0.10696, -0.151651> }
        smooth_triangle {<-14.4912, -2.05417, 14.8236>, <0.295568, 0.0924045, -0.130996>,
                         <-14.3514, -2.97818, 14.8746>, <0.313637, 0.0316984, -0.125875>,
                         <-14.4229, -2.99896, 14.5>, <0.332676, 0.0408376, -0.0658141> }
        smooth_triangle {<-14.553, -2.07211, 14.5>, <0.318592, 0.154205, -0.0694109>,
                         <-15.1338, -1.33651, 14.5>, <0.359546, 0.170411, -0.078133>,
                         <-15.0462, -1.31108, 14.9585>, <0.313843, 0.191265, -0.174736> }
        smooth_triangle {<-15.0462, -1.31108, 14.9585>, <0.294885, 0.19043, -0.145024>,
                         <-14.4912, -2.05417, 14.8236>, <0.268262, 0.127202, -0.12771>,
                         <-14.553, -2.07211, 14.5>, <0.291731, 0.165446, -0.0649033> }
        smooth_triangle {<-15.1338, -1.33651, 14.5>, <0.359546, 0.170411, -0.078133>,
                         <-15.3082, -0.442931, 14.5>, <0.320098, 0.0181932, -0.0621555>,
                         <-15.2266, -0.419235, 14.9273>, <0.310208, 0.028121, -0.143691> }
        smooth_triangle {<-15.2266, -0.419235, 14.9273>, <0.335089, 0.0410792, -0.128444>,
                         <-15.0462, -1.31108, 14.9585>, <0.337815, 0.163437, -0.151728>,
                         <-15.1338, -1.33651, 14.5>, <0.376274, 0.140259, -0.0796563> }
        smooth_triangle {<-15.3082, -0.442931, 14.5>, <0.320098, 0.0181932, -0.0621555>,
                         <-15.1708, 0.488686, 14.5>, <0.267025, 0.0539454, -0.0540001>,
                         <-15.1178, 0.504068, 14.7774>, <0.237688, 0.0155758, -0.118268> }
        smooth_triangle {<-15.1178, 0.504068, 14.7774>, <0.277778, -0.00299767, -0.106896>,
                         <-15.2266, -0.419235, 14.9273>, <0.332168, 0.00641121, -0.125963>,
                         <-15.3082, -0.442931, 14.5>, <0.346082, -0.0074439, -0.0656974> }
        smooth_triangle {<-15.1708, 0.488686, 14.5>, <0.267025, 0.0539454, -0.0540001>,
                         <-15.5913, 1.28261, 14.5>, <0.315575, 0.207071, -0.0717664>,
                         <-15.525, 1.30187, 14.8472>, <0.267101, 0.176507, -0.1565> }
        smooth_triangle {<-15.525, 1.30187, 14.8472>, <0.255377, 0.16154, -0.129509>,
                         <-15.1178, 0.504068, 14.7774>, <0.233317, 0.0408416, -0.100835>,
                         <-15.1708, 0.488686, 14.5>, <0.251419, 0.0748432, -0.0521779> }
        smooth_triangle {<-15.5913, 1.28261, 14.5>, <0.315575, 0.207071, -0.0717664>,
                         <-16.156, 2.03127, 14.5>, <0.370604, 0.160304, -0.0796849>,
                         <-16.0653, 2.0576, 14.9748>, <0.326522, 0.184911, -0.178875> }
        smooth_triangle {<-16.0653, 2.0576, 14.9748>, <0.309875, 0.187697, -0.149288>,
                         <-15.525, 1.30187, 14.8472>, <0.26531, 0.181394, -0.132507>,
                         <-15.5913, 1.28261, 14.5>, <0.297028, 0.203399, -0.06802> }
        smooth_triangle {<-16.156, 2.03127, 14.5>, <0.370604, 0.160304, -0.0796849>,
                         <-16.28, 2.94276, 14.5>, <0.274976, -0.0102709, -0.0519576>,
                         <-16.1992, 2.96623, 14.9232>, <0.286428, 0.00325268, -0.124172> }
        smooth_triangle {<-16.1992, 2.96623, 14.9232>, <0.323026, 0.0171603, -0.114615>,
                         <-16.0653, 2.0576, 14.9748>, <0.353096, 0.153404, -0.155643>,
                         <-16.156, 2.03127, 14.5>, <0.391342, 0.126497, -0.0817714> }
        smooth_triangle {<-16.28, 2.94276, 14.5>, <0.274976, -0.0102709, -0.0519576>,
                         <-15.8984, 3.80111, 14.5>, <0.164239, -0.0730163, 3.46945e-18>,
                         <-15.8618, 3.81173, 14.6913>, <0.154197, -0.0759317, -0.0525687> }
        smooth_triangle {<-15.8618, 3.81173, 14.6913>, <0.223874, -0.104448, -0.0551891>,
                         <-16.1992, 2.96623, 14.9232>, <0.305628, -0.0379308, -0.108236>,
                         <-16.28, 2.94276, 14.5>, <0.304393, -0.0606743, -0.0547817> }
        texture { Semi_smooth_steel }
    }
}

union {  // Layer name: sundial
    box { <0.0, 0.0, 0.0>, <5, 2, 0.1> 
        texture { Rok }
        rotate <.0, .0, 20>
        rotate <.0, 333.435, .0>
        translate <-9.26375, 0.784963, 2.58394>
    }
    height_field { gif "clock2.gif"  water_level 0.01 smooth 
        texture { Rok }
        scale <10, 2, 10>
        rotate <.0, 333.435, .0>
        translate <-11.7361, 2, -4.2082>
    }
    cone { <0.0, 0.0, 0.0>, 5, <0.0, 2, 0.0>, 5  
        texture { Rok }
        rotate <.0, 333.435, .0>
        translate <-9.5, 1, 2.5>
    }
}

union {  // Layer name: lights
    plane { y, 0.0 
        texture { bigsky }
        scale <66.5, 66.5, 66.5>
        translate <-5, 89.5, 28>
    }
    plane { y, 0.0 
        texture { CheckerFloor }
        scale <39.5032, 39.5032, 39.5032>
        translate <-4.5, -53, 29>
    }
    light_source {  <22.5, 46, -25.5>
        color rgb<1, 1, 1>
    }
}

union {  // Layer name: hourglass
    torus { 4, 0.25 
        texture { DMFWood4 }
        translate <0, 6.5, 0>
    }
    box { <0.0, 0.0, 0.0>, <2, 0.1, 0.25> 
        texture { Red_clear_plastic }
        rotate <.0, 121.608, .0>
        translate <0, 6.5, 0>
    }
    box { <0.0, 0.0, 0.0>, <3, 0.1, 0.25> 
        texture { Red_clear_plastic }
        translate <0, 6.5, 0>
    }
    union { // Surface of Revolution
        smooth_triangle {<-2.77164, 6, 1.14805>, <1.03465, 0.0094996, -0.205806>,
                         <-2.76397, 5.09627, 1.14487>, <0.974192, 0.0292245, -0.330983>,
                         <-2.9917, 5.09627, 0>, <1.03465, 0.0094996, -0.205806> }
        smooth_triangle {<-2.9917, 5.09627, 0>, <1.03609, 0.00951277, -0.206091>,
                         <-3, 6, 0>, <1.03752, 0.00952595, -0.206376>,
                         <-2.77164, 6, 1.14805>, <1.03609, 0.00951277, -0.206091> }
        smooth_triangle {<-2.76397, 5.09627, 1.14487>, <0.974192, 0.0292245, -0.330983>,
                         <-2.7074, 4.19494, 1.12144>, <0.932947, 0.108953, -0.319613>,
                         <-2.93046, 4.19494, 0>, <1.01078, 0.0686744, -0.201057> }
        smooth_triangle {<-2.93046, 4.19494, 0>, <1.02134, 0.0693919, -0.203158>,
                         <-2.9917, 5.09627, 0>, <1.03328, 0.0398045, -0.205532>,
                         <-2.76397, 5.09627, 1.14487>, <0.988621, 0.0394457, -0.299552> }
        smooth_triangle {<-2.7074, 4.19494, 1.12144>, <0.932947, 0.108953, -0.319613>,
                         <-2.54105, 3.31026, 1.05254>, <0.839471, 0.220555, -0.29046>,
                         <-2.75041, 3.31026, 0>, <0.931156, 0.189511, -0.185218> }
        smooth_triangle {<-2.75041, 3.31026, 0>, <0.961634, 0.195713, -0.191281>,
                         <-2.93046, 4.19494, 0>, <1.00145, 0.135295, -0.1992>,
                         <-2.7074, 4.19494, 1.12144>, <0.947738, 0.132194, -0.289046> }
        smooth_triangle {<-2.54105, 3.31026, 1.05254>, <0.839471, 0.220555, -0.29046>,
                         <-2.2624, 2.45886, 0.937114>, <0.691201, 0.302351, -0.243291>,
                         <-2.4488, 2.45886, 0>, <0.79786, 0.282644, -0.158704> }
        smooth_triangle {<-2.4488, 2.45886, 0>, <0.846996, 0.300051, -0.168478>,
                         <-2.75041, 3.31026, 0>, <0.913643, 0.253484, -0.181735>,
                         <-2.54105, 3.31026, 1.05254>, <0.853636, 0.24478, -0.262408> }
        smooth_triangle {<-2.2624, 2.45886, 0.937114>, <0.691201, 0.302351, -0.243291>,
                         <-1.85045, 1.67691, 0.76648>, <0.464042, 0.344056, -0.171782>,
                         <-2.00291, 1.67691, 0>, <0.59935, 0.341765, -0.119218> }
        smooth_triangle {<-2.00291, 1.67691, 0>, <0.666064, 0.379806, -0.132488>,
                         <-2.4488, 2.45886, 0>, <0.765319, 0.350246, -0.152231>,
                         <-2.2624, 2.45886, 0.937114>, <0.701595, 0.331225, -0.218908> }
        smooth_triangle {<-1.85045, 1.67691, 0.76648>, <0.464042, 0.344056, -0.171782>,
                         <-1.20527, 1.1067, 0.499236>, <0.241893, 0.285517, -0.0858652>,
                         <-1.30457, 1.1067, 0>, <0.28467, 0.348638, -0.0566244> }
        smooth_triangle {<-1.30457, 1.1067, 0>, <0.360863, 0.441952, -0.0717802>,
                         <-2.00291, 1.67691, 0>, <0.518203, 0.438515, -0.103077>,
                         <-1.85045, 1.67691, 0.76648>, <0.457295, 0.391858, -0.150571> }
        smooth_triangle {<-1.20527, 1.1067, 0.499236>, <0.241893, 0.285517, -0.0858652>,
                         <-0.69157, 0.409636, 0.286456>, <0.209506, 0.103818, -0.0681522>,
                         <-0.748549, 0.409636, 0>, <0.199678, 0.159275, -0.0397183> }
        smooth_triangle {<-0.748549, 0.409636, 0>, <0.273838, 0.21843, -0.0544698>,
                         <-1.30457, 1.1067, 0>, <0.316334, 0.313112, -0.0629228>,
                         <-1.20527, 1.1067, 0.499236>, <0.268419, 0.283534, -0.0817042> }
        smooth_triangle {<-0.69157, 0.409636, 0.286456>, <0.209506, 0.103818, -0.0681522>,
                         <-0.713747, -0.468324, 0.295642>, <0.276813, -0.105473, -0.0894816>,
                         <-0.772554, -0.468324, 0>, <0.259562, -0.00709685, -0.0516301> }
        smooth_triangle {<-0.772554, -0.468324, 0>, <0.255529, -0.00698659, -0.050828>,
                         <-0.748549, 0.409636, 0>, <0.225587, 0.0761995, -0.0448721>,
                         <-0.69157, 0.409636, 0.286456>, <0.220004, 0.0761444, -0.0636206> }
        smooth_triangle {<-0.713747, -0.468324, 0.295642>, <0.276813, -0.105473, -0.0894816>,
                         <-1.25211, -1.14477, 0.518641>, <0.367716, -0.380318, -0.119666>,
                         <-1.35528, -1.14477, 0>, <0.350831, -0.302224, -0.0697846> }
        smooth_triangle {<-1.35528, -1.14477, 0>, <0.275408, -0.237251, -0.0547821>,
                         <-0.772554, -0.468324, 0>, <0.229774, -0.0896872, -0.0457048>,
                         <-0.713747, -0.468324, 0.295642>, <0.257606, -0.122174, -0.0770561> }
        smooth_triangle {<-1.25211, -1.14477, 0.518641>, <0.367716, -0.380318, -0.119666>,
                         <-1.88645, -1.72693, 0.781393>, <0.531299, -0.479732, -0.166005>,
                         <-2.04188, -1.72693, 0>, <0.454895, -0.536508, -0.0904843> }
        smooth_triangle {<-2.04188, -1.72693, 0>, <0.378414, -0.446304, -0.0752711>,
                         <-1.35528, -1.14477, 0>, <0.326382, -0.329162, -0.0649213>,
                         <-1.25211, -1.14477, 0.518641>, <0.35127, -0.374264, -0.104764> }
        smooth_triangle {<-1.88645, -1.72693, 0.781393>, <0.531299, -0.479732, -0.166005>,
                         <-2.24953, -2.53544, 0.931784>, <0.760994, -0.322019, -0.251273>,
                         <-2.43487, -2.53544, 0>, <0.753358, -0.366181, -0.149852> }
        smooth_triangle {<-2.43487, -2.53544, 0>, <0.692562, -0.33663, -0.137759>,
                         <-2.04188, -1.72693, 0>, <0.543331, -0.421793, -0.108075>,
                         <-1.88645, -1.72693, 0.781393>, <0.556415, -0.436569, -0.15592> }
        smooth_triangle {<-2.24953, -2.53544, 0.931784>, <0.760994, -0.322019, -0.251273>,
                         <-2.4613, -3.40935, 1.0195>, <0.869527, -0.216512, -0.291108>,
                         <-2.6641, -3.40935, 0>, <0.890956, -0.233696, -0.177222> }
        smooth_triangle {<-2.6641, -3.40935, 0>, <0.852626, -0.223642, -0.169598>,
                         <-2.43487, -2.53544, 0>, <0.783827, -0.289885, -0.155913>,
                         <-2.24953, -2.53544, 0.931784>, <0.774319, -0.294911, -0.228948> }
        smooth_triangle {<-2.4613, -3.40935, 1.0195>, <0.869527, -0.216512, -0.291108>,
                         <-2.61657, -4.29724, 1.08382>, <0.929449, -0.163489, -0.312489>,
                         <-2.83215, -4.29724, 0>, <0.962309, -0.182144, -0.191415> }
        smooth_triangle {<-2.83215, -4.29724, 0>, <0.933757, -0.17674, -0.185736>,
                         <-2.6641, -3.40935, 0>, <0.898081, -0.202516, -0.178639>,
                         <-2.4613, -3.40935, 1.0195>, <0.878447, -0.205218, -0.263345> }
        smooth_triangle {<-2.61657, -4.29724, 1.08382>, <0.929449, -0.163489, -0.312489>,
                         <-2.72004, -5.19389, 1.12668>, <0.966636, -0.102419, -0.326241>,
                         <-2.94414, -5.19389, 0>, <1.01023, -0.126178, -0.200947> }
        smooth_triangle {<-2.94414, -5.19389, 0>, <0.991017, -0.123778, -0.197125>,
                         <-2.83215, -4.29724, 0>, <0.967056, -0.151761, -0.192359>,
                         <-2.61657, -4.29724, 1.08382>, <0.940037, -0.152961, -0.282693> }
        smooth_triangle {<-2.72004, -5.19389, 1.12668>, <0.966636, -0.102419, -0.326241>,
                         <-2.76433, -6.09626, 1.14502>, <0.98224, -0.039627, -0.332396>,
                         <-2.99209, -6.09626, 0>, <1.03324, -0.0549015, -0.205525> }
        smooth_triangle {<-2.99209, -6.09626, 0>, <1.02496, -0.0544616, -0.203878>,
                         <-2.94414, -5.19389, 0>, <1.01346, -0.0901, -0.201589>,
                         <-2.72004, -5.19389, 1.12668>, <0.979148, -0.0903199, -0.295238> }
        smooth_triangle {<-2.76433, -6.09626, 1.14502>, <0.98224, -0.039627, -0.332396>,
                         <-2.77164, -7, 1.14805>, <0.958557, -0.00907808, -0.397047>,
                         <-3, -7, 0>, <1.03754, -0.00907803, -0.206379> }
        smooth_triangle {<-3, -7, 0>, <1.03617, -0.00906607, -0.206107>,
                         <-2.99209, -6.09626, 0>, <1.03402, -0.0319778, -0.20568>,
                         <-2.76433, -6.09626, 1.14502>, <0.99538, -0.0319838, -0.300756> }
        smooth_triangle {<-2.12132, 6, 2.12132>, <0.877138, 0.00949951, -0.586085>,
                         <-2.11546, 5.09627, 2.11545>, <0.773375, 0.0292244, -0.678595>,
                         <-2.76397, 5.09627, 1.14487>, <0.974192, 0.0292245, -0.330983> }
        smooth_triangle {<-2.76397, 5.09627, 1.14487>, <0.950537, 0.0242998, -0.395165>,
                         <-2.77164, 6, 1.14805>, <0.957113, 0.00951273, -0.396758>,
                         <-2.12132, 6, 2.12132>, <0.878354, 0.00951269, -0.586898> }
        smooth_triangle {<-2.11546, 5.09627, 2.11545>, <0.773375, 0.0292244, -0.678595>,
                         <-2.07215, 4.19494, 2.07215>, <0.73962, 0.108953, -0.652307>,
                         <-2.7074, 4.19494, 1.12144>, <0.932947, 0.108953, -0.319613> }
        smooth_triangle {<-2.7074, 4.19494, 1.12144>, <0.918412, 0.0992421, -0.385842>,
                         <-2.76397, 5.09627, 1.14487>, <0.949346, 0.0394457, -0.394369>,
                         <-2.11546, 5.09627, 2.11545>, <0.798733, 0.0394456, -0.655078> }
        smooth_triangle {<-2.07215, 4.19494, 2.07215>, <0.73962, 0.108953, -0.652307>,
                         <-1.94484, 3.31026, 1.94483>, <0.664415, 0.220555, -0.589602>,
                         <-2.54105, 3.31026, 1.05254>, <0.839471, 0.220555, -0.29046> }
        smooth_triangle {<-2.54105, 3.31026, 1.05254>, <0.839871, 0.215895, -0.358342>,
                         <-2.7074, 4.19494, 1.12144>, <0.909978, 0.132194, -0.380206>,
                         <-2.07215, 4.19494, 2.07215>, <0.764983, 0.132194, -0.629727> }
        smooth_triangle {<-1.94484, 3.31026, 1.94483>, <0.664415, 0.220555, -0.589602>,
                         <-1.73157, 2.45886, 1.73156>, <0.545483, 0.302351, -0.489283>,
                         <-2.2624, 2.45886, 0.937114>, <0.691201, 0.302351, -0.243291> }
        smooth_triangle {<-2.2624, 2.45886, 0.937114>, <0.708327, 0.306127, -0.309373>,
                         <-2.54105, 3.31026, 1.05254>, <0.819529, 0.24478, -0.344749>,
                         <-1.94484, 3.31026, 1.94483>, <0.688237, 0.24478, -0.569106> }
        smooth_triangle {<-1.73157, 2.45886, 1.73156>, <0.545483, 0.302351, -0.489283>,
                         <-1.41628, 1.67691, 1.41627>, <0.36298, 0.344056, -0.336287>,
                         <-1.85045, 1.67691, 0.76648>, <0.464042, 0.344056, -0.171782> }
        smooth_triangle {<-1.85045, 1.67691, 0.76648>, <0.503336, 0.362504, -0.232608>,
                         <-2.2624, 2.45886, 0.937114>, <0.673706, 0.331225, -0.28624>,
                         <-1.73157, 2.45886, 1.73156>, <0.564417, 0.331225, -0.470734> }
        smooth_triangle {<-1.41628, 1.67691, 1.41627>, <0.36298, 0.344056, -0.336287>,
                         <-0.922472, 1.1067, 0.922467>, <0.190621, 0.285517, -0.171898>,
                         <-1.20527, 1.1067, 0.499236>, <0.241893, 0.285517, -0.0858652> }
        smooth_triangle {<-1.20527, 1.1067, 0.499236>, <0.274049, 0.347954, -0.126292>,
                         <-1.85045, 1.67691, 0.76648>, <0.440661, 0.391858, -0.19073>,
                         <-1.41628, 1.67691, 1.41627>, <0.364865, 0.391858, -0.314109> }
        smooth_triangle {<-0.922472, 1.1067, 0.922467>, <0.190621, 0.285517, -0.171898>,
                         <-0.529306, 0.409636, 0.529301>, <0.167478, 0.103818, -0.143139>,
                         <-0.69157, 0.409636, 0.286456>, <0.209506, 0.103818, -0.0681522> }
        smooth_triangle {<-0.69157, 0.409636, 0.286456>, <0.230884, 0.14726, -0.100395>,
                         <-1.20527, 1.1067, 0.499236>, <0.255174, 0.283534, -0.11368>,
                         <-0.922472, 1.1067, 0.922467>, <0.21672, 0.283534, -0.178204> }
        smooth_triangle {<-0.529306, 0.409636, 0.529301>, <0.167478, 0.103818, -0.143139>,
                         <-0.546279, -0.468324, 0.546276>, <0.221499, -0.105473, -0.188602>,
                         <-0.713747, -0.468324, 0.295642>, <0.276813, -0.105473, -0.0894816> }
        smooth_triangle {<-0.713747, -0.468324, 0.295642>, <0.260912, -0.0808235, -0.102727>,
                         <-0.69157, 0.409636, 0.286456>, <0.210432, 0.0761444, -0.0867295>,
                         <-0.529306, 0.409636, 0.529301>, <0.17891, 0.0761444, -0.14297> }
        smooth_triangle {<-0.546279, -0.468324, 0.546276>, <0.221499, -0.105473, -0.188602>,
                         <-0.958327, -1.14477, 0.958323>, <0.293931, -0.380318, -0.251276>,
                         <-1.25211, -1.14477, 0.518641>, <0.367716, -0.380318, -0.119666> }
        smooth_triangle {<-1.25211, -1.14477, 0.518641>, <0.318172, -0.328308, -0.11807>,
                         <-0.713747, -0.468324, 0.295642>, <0.249995, -0.122174, -0.0954318>,
                         <-0.546279, -0.468324, 0.546276>, <0.208509, -0.122174, -0.169772> }
        smooth_triangle {<-0.958327, -1.14477, 0.958323>, <0.293931, -0.380318, -0.251276>,
                         <-1.44383, -1.72693, 1.44383>, <0.427329, -0.479732, -0.356687>,
                         <-1.88645, -1.72693, 0.781393>, <0.531299, -0.479732, -0.166005> }
        smooth_triangle {<-1.88645, -1.72693, 0.781393>, <0.462465, -0.448824, -0.167261>,
                         <-1.25211, -1.14477, 0.518641>, <0.339778, -0.374264, -0.132507>,
                         <-0.958327, -1.14477, 0.958323>, <0.284439, -0.374264, -0.231214> }
        smooth_triangle {<-1.44383, -1.72693, 1.44383>, <0.427329, -0.479732, -0.356687>,
                         <-1.72171, -2.53544, 1.72171>, <0.606909, -0.322019, -0.523365>,
                         <-2.24953, -2.53544, 0.931784>, <0.760994, -0.322019, -0.251273> }
        smooth_triangle {<-2.24953, -2.53544, 0.931784>, <0.704642, -0.318284, -0.277921>,
                         <-1.88645, -1.72693, 0.781393>, <0.53237, -0.436569, -0.21397>,
                         <-1.44383, -1.72693, 1.44383>, <0.454393, -0.436569, -0.356982> }
        smooth_triangle {<-1.72171, -2.53544, 1.72171>, <0.606909, -0.322019, -0.523365>,
                         <-1.8838, -3.40935, 1.8838>, <0.691936, -0.216512, -0.601702>,
                         <-2.4613, -3.40935, 1.0195>, <0.869527, -0.216512, -0.291108> }
        smooth_triangle {<-2.4613, -3.40935, 1.0195>, <0.824727, -0.215781, -0.333646>,
                         <-2.24953, -2.53544, 0.931784>, <0.743327, -0.294912, -0.30377>,
                         <-1.72171, -2.53544, 1.72171>, <0.627763, -0.294912, -0.507839> }
        smooth_triangle {<-1.8838, -3.40935, 1.8838>, <0.691936, -0.216512, -0.601702>,
                         <-2.00264, -4.29724, 2.00263>, <0.739114, -0.163489, -0.644387>,
                         <-2.61657, -4.29724, 1.08382>, <0.929449, -0.163489, -0.312489> }
        smooth_triangle {<-2.61657, -4.29724, 1.08382>, <0.888936, -0.16545, -0.362556>,
                         <-2.4613, -3.40935, 1.0195>, <0.843994, -0.205218, -0.34652>,
                         <-1.8838, -3.40935, 1.8838>, <0.710801, -0.205218, -0.579466> }
        smooth_triangle {<-2.00264, -4.29724, 2.00263>, <0.739114, -0.163489, -0.644387>,
                         <-2.08183, -5.19389, 2.08182>, <0.768208, -0.102419, -0.671322>,
                         <-2.72004, -5.19389, 1.12668>, <0.966636, -0.102419, -0.326241> }
        smooth_triangle {<-2.72004, -5.19389, 1.12668>, <0.93094, -0.107159, -0.382301>,
                         <-2.61657, -4.29724, 1.08382>, <0.90305, -0.152961, -0.371987>,
                         <-2.00264, -4.29724, 2.00263>, <0.760299, -0.152961, -0.62091> }
        smooth_triangle {<-2.08183, -5.19389, 2.08182>, <0.768208, -0.102419, -0.671322>,
                         <-2.11573, -6.09626, 2.11573>, <0.780269, -0.0396272, -0.682981>,
                         <-2.76433, -6.09626, 1.14502>, <0.98224, -0.039627, -0.332396> }
        smooth_triangle {<-2.76433, -6.09626, 1.14502>, <0.952156, -0.0432257, -0.393274>,
                         <-2.72004, -5.19389, 1.12668>, <0.940453, -0.09032, -0.388657>,
                         <-2.08183, -5.19389, 2.08182>, <0.791632, -0.09032, -0.647468> }
        smooth_triangle {<-2.11573, -6.09626, 2.11573>, <0.780269, -0.0396272, -0.682981>,
                         <-2.12132, -7, 2.12132>, <0.733648, -0.0090782, -0.733648>,
                         <-2.77164, -7, 1.14805>, <0.958557, -0.00907808, -0.397047> }
        smooth_triangle {<-2.77164, -7, 1.14805>, <0.931459, -0.00907011, -0.460087>,
                         <-2.76433, -6.09626, 1.14502>, <0.955995, -0.0319838, -0.395839>,
                         <-2.11573, -6.09626, 2.11573>, <0.804517, -0.0319839, -0.658778> }
        smooth_triangle {<-1.14805, 6, 2.77163>, <0.586085, 0.00949935, -0.877138>,
                         <-1.14488, 5.09627, 2.76397>, <0.454818, 0.0292242, -0.922898>,
                         <-2.11546, 5.09627, 2.11545>, <0.773375, 0.0292244, -0.678595> }
        smooth_triangle {<-2.11546, 5.09627, 2.11545>, <0.726958, 0.0242997, -0.728839>,
                         <-2.12132, 6, 2.12132>, <0.732424, 0.0095126, -0.732828>,
                         <-1.14805, 6, 2.77163>, <0.586898, 0.00951252, -0.878354> }
        smooth_triangle {<-1.14488, 5.09627, 2.76397>, <0.454818, 0.0292242, -0.922898>,
                         <-1.12144, 4.19494, 2.70739>, <0.433693, 0.108953, -0.885694>,
                         <-2.07215, 4.19494, 2.07215>, <0.73962, 0.108953, -0.652307> }
        smooth_triangle {<-2.07215, 4.19494, 2.07215>, <0.700847, 0.099242, -0.707932>,
                         <-2.11546, 5.09627, 2.11545>, <0.726163, 0.0394456, -0.727648>,
                         <-1.14488, 5.09627, 2.76397>, <0.487245, 0.0394454, -0.910875> }
        smooth_triangle {<-1.12144, 4.19494, 2.70739>, <0.433693, 0.108953, -0.885694>,
                         <-1.05254, 3.31026, 2.54105>, <0.388209, 0.220555, -0.798982>,
                         <-1.94484, 3.31026, 1.94483>, <0.664415, 0.220555, -0.589602> }
        smooth_triangle {<-1.94484, 3.31026, 1.94483>, <0.638808, 0.215895, -0.652469>,
                         <-2.07215, 4.19494, 2.07215>, <0.695211, 0.132194, -0.699498>,
                         <-1.12144, 4.19494, 2.70739>, <0.465766, 0.132194, -0.874538> }
        smooth_triangle {<-1.05254, 3.31026, 2.54105>, <0.388209, 0.220555, -0.798982>,
                         <-0.937119, 2.45886, 2.26239>, <0.31672, 0.302351, -0.660786>,
                         <-1.73157, 2.45886, 1.73156>, <0.545483, 0.302351, -0.489283> }
        smooth_triangle {<-1.73157, 2.45886, 1.73156>, <0.536017, 0.306127, -0.556888>,
                         <-1.94484, 3.31026, 1.94483>, <0.625216, 0.24478, -0.632127>,
                         <-1.05254, 3.31026, 2.54105>, <0.418061, 0.24478, -0.789162> }
        smooth_triangle {<-0.937119, 2.45886, 2.26239>, <0.31672, 0.302351, -0.660786>,
                         <-0.766485, 1.67691, 1.85045>, <0.206658, 0.344055, -0.449596>,
                         <-1.41628, 1.67691, 1.41627>, <0.36298, 0.344056, -0.336287> }
        smooth_triangle {<-1.41628, 1.67691, 1.41627>, <0.376006, 0.362504, -0.40752>,
                         <-1.73157, 2.45886, 1.73156>, <0.512884, 0.331225, -0.522267>,
                         <-0.937119, 2.45886, 2.26239>, <0.341311, 0.331225, -0.650895> }
        smooth_triangle {<-0.766485, 1.67691, 1.85045>, <0.206658, 0.344055, -0.449596>,
                         <-0.49924, 1.1067, 1.20526>, <0.110328, 0.285517, -0.23176>,
                         <-0.922472, 1.1067, 0.922467>, <0.190621, 0.285517, -0.171898> }
        smooth_triangle {<-0.922472, 1.1067, 0.922467>, <0.204859, 0.347954, -0.221553>,
                         <-1.41628, 1.67691, 1.41627>, <0.334128, 0.391858, -0.344845>,
                         <-0.766485, 1.67691, 1.85045>, <0.216887, 0.391858, -0.429826> }
        smooth_triangle {<-0.49924, 1.1067, 1.20526>, <0.110328, 0.285517, -0.23176>,
                         <-0.28646, 0.409636, 0.691566>, <0.0999522, 0.103818, -0.196334>,
                         <-0.529306, 0.409636, 0.529301>, <0.167478, 0.103818, -0.143139> }
        smooth_triangle {<-0.529306, 0.409636, 0.529301>, <0.174889, 0.14726, -0.181109>,
                         <-0.922472, 1.1067, 0.922467>, <0.192247, 0.283534, -0.202678>,
                         <-0.49924, 1.1067, 1.20526>, <0.132028, 0.283534, -0.247575> }
        smooth_triangle {<-0.28646, 0.409636, 0.691566>, <0.0999522, 0.103818, -0.196334>,
                         <-0.295646, -0.468323, 0.713744>, <0.132463, -0.105473, -0.259009>,
                         <-0.546279, -0.468324, 0.546276>, <0.221499, -0.105473, -0.188602> }
        smooth_triangle {<-0.546279, -0.468324, 0.546276>, <0.20174, -0.0808235, -0.194754>,
                         <-0.529306, 0.409636, 0.529301>, <0.161224, 0.0761443, -0.160656>,
                         <-0.28646, 0.409636, 0.691566>, <0.11058, 0.0761443, -0.200553> }
        smooth_triangle {<-0.295646, -0.468323, 0.713744>, <0.132463, -0.105473, -0.259009>,
                         <-0.518644, -1.14477, 1.25211>, <0.175398, -0.380319, -0.344631>,
                         <-0.958327, -1.14477, 0.958323>, <0.293931, -0.380318, -0.251276> }
        smooth_triangle {<-0.958327, -1.14477, 0.958323>, <0.248769, -0.328308, -0.230842>,
                         <-0.546279, -0.468324, 0.546276>, <0.194445, -0.122174, -0.183836>,
                         <-0.295646, -0.468323, 0.713744>, <0.127668, -0.122174, -0.236642> }
        smooth_triangle {<-0.518644, -1.14477, 1.25211>, <0.175398, -0.380319, -0.344631>,
                         <-0.781396, -1.72693, 1.88645>, <0.258302, -0.479732, -0.493068>,
                         <-1.44383, -1.72693, 1.44383>, <0.427329, -0.479732, -0.356687> }
        smooth_triangle {<-1.44383, -1.72693, 1.44383>, <0.363254, -0.448824, -0.331507>,
                         <-0.958327, -1.14477, 0.958323>, <0.263206, -0.374264, -0.252448>,
                         <-0.518644, -1.14477, 1.25211>, <0.174306, -0.374264, -0.322464> }
        smooth_triangle {<-0.781396, -1.72693, 1.88645>, <0.258302, -0.479732, -0.493068>,
                         <-0.931786, -2.53544, 2.24952>, <0.360427, -0.32202, -0.71578>,
                         <-1.72171, -2.53544, 1.72171>, <0.606909, -0.322019, -0.523365> }
        smooth_triangle {<-1.72171, -2.53544, 1.72171>, <0.544648, -0.318284, -0.52642>,
                         <-1.44383, -1.72693, 1.44383>, <0.409963, -0.436569, -0.401412>,
                         <-0.781396, -1.72693, 1.88645>, <0.283193, -0.436569, -0.503697> }
        smooth_triangle {<-0.931786, -2.53544, 2.24952>, <0.360427, -0.32202, -0.71578>,
                         <-1.01951, -3.40935, 2.4613>, <0.409004, -0.216512, -0.820693>,
                         <-1.8838, -3.40935, 1.8838>, <0.691936, -0.216512, -0.601702> }
        smooth_triangle {<-1.8838, -3.40935, 1.8838>, <0.634268, -0.215781, -0.623858>,
                         <-1.72171, -2.53544, 1.72171>, <0.570497, -0.294912, -0.565106>,
                         <-0.931786, -2.53544, 2.24952>, <0.385636, -0.294912, -0.709417> }
        smooth_triangle {<-1.01951, -3.40935, 2.4613>, <0.409004, -0.216512, -0.820693>,
                         <-1.08382, -4.29724, 2.61657>, <0.436256, -0.163489, -0.878182>,
                         <-2.00264, -4.29724, 2.00263>, <0.739114, -0.163489, -0.644387> }
        smooth_triangle {<-2.00264, -4.29724, 2.00263>, <0.682525, -0.165451, -0.675139>,
                         <-1.8838, -3.40935, 1.8838>, <0.647142, -0.205218, -0.643126>,
                         <-1.01951, -3.40935, 2.4613>, <0.434943, -0.205218, -0.807369> }
        smooth_triangle {<-1.08382, -4.29724, 2.61657>, <0.436256, -0.163489, -0.878182>,
                         <-1.12668, -5.19389, 2.72003>, <0.452828, -0.10242, -0.914201>,
                         <-2.08183, -5.19389, 2.08182>, <0.768208, -0.102419, -0.671322> }
        smooth_triangle {<-2.08183, -5.19389, 2.08182>, <0.713776, -0.107159, -0.709455>,
                         <-2.00264, -4.29724, 2.00263>, <0.691956, -0.152961, -0.689254>,
                         <-1.08382, -4.29724, 2.61657>, <0.464813, -0.152961, -0.8646> }
        smooth_triangle {<-1.12668, -5.19389, 2.72003>, <0.452828, -0.10242, -0.914201>,
                         <-1.14502, -6.09626, 2.76433>, <0.459509, -0.0396273, -0.929588>,
                         <-2.11573, -6.09626, 2.11573>, <0.780269, -0.0396272, -0.682981> }
        smooth_triangle {<-2.11573, -6.09626, 2.11573>, <0.729178, -0.0432259, -0.727712>,
                         <-2.08183, -5.19389, 2.08182>, <0.720132, -0.0903201, -0.718968>,
                         <-1.12668, -5.19389, 2.72003>, <0.483597, -0.0903202, -0.901127> }
        smooth_triangle {<-1.14502, -6.09626, 2.76433>, <0.459509, -0.0396273, -0.929588>,
                         <-1.14805, -7, 2.77164>, <0.397047, -0.00907839, -0.958557>,
                         <-2.12132, -7, 2.12132>, <0.733648, -0.0090782, -0.733648> }
        smooth_triangle {<-2.12132, -7, 2.12132>, <0.684488, -0.00907025, -0.781519>,
                         <-2.11573, -6.09626, 2.11573>, <0.731743, -0.031984, -0.731551>,
                         <-1.14502, -6.09626, 2.76433>, <0.491173, -0.0319841, -0.916506> }
        smooth_triangle {<-7.30159e-06, 6, 2.99999>, <0.205806, 0.00949914, -1.03465>,
                         <-6.794e-06, 5.09627, 2.9917>, <0.0670191, 0.029224, -1.0267>,
                         <-1.14488, 5.09627, 2.76397>, <0.454818, 0.0292242, -0.922898> }
        smooth_triangle {<-1.14488, 5.09627, 2.76397>, <0.392707, 0.0242995, -0.951554>,
                         <-1.14805, 6, 2.77163>, <0.396231, 0.00951242, -0.957331>,
                         <-7.30159e-06, 6, 2.99999>, <0.206091, 0.00951231, -1.03609> }
        smooth_triangle {<-6.794e-06, 5.09627, 2.9917>, <0.0670191, 0.029224, -1.0267>,
                         <-6.28776e-06, 4.19494, 2.93046>, <0.0617394, 0.108953, -0.984241>,
                         <-1.12144, 4.19494, 2.70739>, <0.433693, 0.108953, -0.885694> }
        smooth_triangle {<-1.12144, 4.19494, 2.70739>, <0.376584, 0.0992418, -0.922247>,
                         <-1.14488, 5.09627, 2.76397>, <0.392428, 0.0394454, -0.95015>,
                         <-6.794e-06, 5.09627, 2.9917>, <0.101579, 0.0394452, -1.028> }
        smooth_triangle {<-6.28776e-06, 4.19494, 2.93046>, <0.0617394, 0.108953, -0.984241>,
                         <-5.79087e-06, 3.31027, 2.75041>, <0.0529013, 0.220555, -0.886724>,
                         <-1.05254, 3.31026, 2.54105>, <0.388209, 0.220555, -0.798982> }
        smooth_triangle {<-1.05254, 3.31026, 2.54105>, <0.340493, 0.215895, -0.847264>,
                         <-1.12144, 4.19494, 2.70739>, <0.374605, 0.132194, -0.912298>,
                         <-6.28776e-06, 4.19494, 2.93046>, <0.0956404, 0.132193, -0.986209> }
        smooth_triangle {<-5.79087e-06, 3.31027, 2.75041>, <0.0529013, 0.220555, -0.886724>,
                         <-5.31267e-06, 2.45886, 2.4488>, <0.0397392, 0.302351, -0.731691>,
                         <-0.937119, 2.45886, 2.26239>, <0.31672, 0.302351, -0.660786> }
        smooth_triangle {<-0.937119, 2.45886, 2.26239>, <0.282103, 0.306127, -0.719622>,
                         <-1.05254, 3.31026, 2.54105>, <0.33572, 0.24478, -0.823269>,
                         <-5.79087e-06, 3.31027, 2.75041>, <0.0842388, 0.24478, -0.889076> }
        smooth_triangle {<-5.31267e-06, 2.45886, 2.4488>, <0.0397392, 0.302351, -0.731691>,
                         <-4.87348e-06, 1.67691, 2.00291>, <0.0188746, 0.344055, -0.494457>,
                         <-0.766485, 1.67691, 1.85045>, <0.206658, 0.344055, -0.449596> }
        smooth_triangle {<-0.766485, 1.67691, 1.85045>, <0.191433, 0.362504, -0.520391>,
                         <-0.937119, 2.45886, 2.26239>, <0.27398, 0.331225, -0.678784>,
                         <-5.31267e-06, 2.45886, 2.4488>, <0.066244, 0.331225, -0.731962> }
        smooth_triangle {<-4.87348e-06, 1.67691, 2.00291>, <0.0188746, 0.344055, -0.494457>,
                         <-4.55321e-06, 1.1067, 1.30457>, <0.0132393, 0.285517, -0.256339>,
                         <-0.49924, 1.1067, 1.20526>, <0.110328, 0.285517, -0.23176> }
        smooth_triangle {<-0.49924, 1.1067, 1.20526>, <0.10448, 0.347954, -0.283084>,
                         <-0.766485, 1.67691, 1.85045>, <0.176728, 0.391858, -0.446461>,
                         <-4.87348e-06, 1.67691, 2.00291>, <0.0358899, 0.391858, -0.480107> }
        smooth_triangle {<-4.55321e-06, 1.1067, 1.30457>, <0.0132393, 0.285517, -0.256339>,
                         <-4.1617e-06, 0.409637, 0.748545>, <0.01721, 0.103818, -0.219639>,
                         <-0.28646, 0.409636, 0.691566>, <0.0999522, 0.103818, -0.196334> }
        smooth_triangle {<-0.28646, 0.409636, 0.691566>, <0.0922694, 0.14726, -0.23425>,
                         <-0.49924, 1.1067, 1.20526>, <0.100051, 0.283534, -0.26082>,
                         <-4.55321e-06, 1.1067, 1.30457>, <0.0272347, 0.283534, -0.279254> }
        smooth_triangle {<-4.1617e-06, 0.409637, 0.748545>, <0.01721, 0.103818, -0.219639>,
                         <-3.66858e-06, -0.468323, 0.772551>, <0.0232616, -0.105473, -0.289985>,
                         <-0.295646, -0.468323, 0.713744>, <0.132463, -0.105473, -0.259009> }
        smooth_triangle {<-0.295646, -0.468323, 0.713744>, <0.111854, -0.0808236, -0.257131>,
                         <-0.28646, 0.409636, 0.691566>, <0.0874706, 0.0761443, -0.210125>,
                         <-4.1617e-06, 0.409637, 0.748545>, <0.0254139, 0.0761443, -0.227604> }
        smooth_triangle {<-3.66858e-06, -0.468323, 0.772551>, <0.0232616, -0.105473, -0.289985>,
                         <-3.28865e-06, -1.14477, 1.35527>, <0.0301616, -0.380319, -0.385519>,
                         <-0.518644, -1.14477, 1.25211>, <0.175398, -0.380319, -0.344631> }
        smooth_triangle {<-0.518644, -1.14477, 1.25211>, <0.141493, -0.328308, -0.30847>,
                         <-0.295646, -0.468323, 0.713744>, <0.109292, -0.122174, -0.244253>,
                         <-3.66858e-06, -0.468323, 0.772551>, <0.0273911, -0.122174, -0.267485> }
        smooth_triangle {<-3.28865e-06, -1.14477, 1.35527>, <0.0301616, -0.380319, -0.385519>,
                         <-2.96168e-06, -1.72693, 2.04188>, <0.049951, -0.479732, -0.554383>,
                         <-0.781396, -1.72693, 1.88645>, <0.258302, -0.479732, -0.493068> }
        smooth_triangle {<-0.781396, -1.72693, 1.88645>, <0.208741, -0.448824, -0.445284>,
                         <-0.518644, -1.14477, 1.25211>, <0.146563, -0.374264, -0.333956>,
                         <-3.28865e-06, -1.14477, 1.35527>, <0.0376358, -0.374264, -0.364622> }
        smooth_triangle {<-2.96168e-06, -1.72693, 2.04188>, <0.049951, -0.479732, -0.554383>,
                         <-2.50757e-06, -2.53544, 2.43487>, <0.0590742, -0.32202, -0.799224>,
                         <-0.931786, -2.53544, 2.24952>, <0.360427, -0.32202, -0.71578> }
        smooth_triangle {<-0.931786, -2.53544, 2.24952>, <0.301737, -0.318285, -0.694777>,
                         <-0.781396, -1.72693, 1.88645>, <0.225143, -0.436569, -0.527742>,
                         <-2.96168e-06, -1.72693, 2.04188>, <0.0688798, -0.436569, -0.573728> }
        smooth_triangle {<-2.50757e-06, -2.53544, 2.43487>, <0.0590742, -0.32202, -0.799224>,
                         <-2.01673e-06, -3.40935, 2.66409>, <0.0638052, -0.216512, -0.91474>,
                         <-1.01951, -3.40935, 2.4613>, <0.409004, -0.216512, -0.820693> }
        smooth_triangle {<-1.01951, -3.40935, 2.4613>, <0.347247, -0.215781, -0.819094>,
                         <-0.931786, -2.53544, 2.24952>, <0.310814, -0.294912, -0.740409>,
                         <-2.50757e-06, -2.53544, 2.43487>, <0.0847991, -0.294912, -0.802992> }
        smooth_triangle {<-2.01673e-06, -3.40935, 2.66409>, <0.0638052, -0.216512, -0.91474>,
                         <-1.51804e-06, -4.29724, 2.83215>, <0.0669826, -0.163489, -0.978283>,
                         <-1.08382, -4.29724, 2.61657>, <0.436256, -0.163489, -0.878182> }
        smooth_triangle {<-1.08382, -4.29724, 2.61657>, <0.372207, -0.165451, -0.884938>,
                         <-1.01951, -3.40935, 2.4613>, <0.351767, -0.205218, -0.841821>,
                         <-2.01673e-06, -3.40935, 2.66409>, <0.0928681, -0.205218, -0.912357> }
        smooth_triangle {<-1.51804e-06, -4.29724, 2.83215>, <0.0669826, -0.163489, -0.978283>,
                         <-1.01442e-06, -5.19388, 2.94414>, <0.0685084, -0.10242, -1.0179>,
                         <-1.12668, -5.19389, 2.72003>, <0.452828, -0.10242, -0.914201> }
        smooth_triangle {<-1.12668, -5.19389, 2.72003>, <0.387947, -0.107159, -0.928602>,
                         <-1.08382, -4.29724, 2.61657>, <0.375518, -0.152961, -0.901587>,
                         <-1.51804e-06, -4.29724, 2.83215>, <0.0985628, -0.152962, -0.976663> }
        smooth_triangle {<-1.01442e-06, -5.19388, 2.94414>, <0.0685084, -0.10242, -1.0179>,
                         <-5.07594e-07, -6.09626, 2.99209>, <0.0687929, -0.0396276, -1.03467>,
                         <-1.14502, -6.09626, 2.76433>, <0.459509, -0.0396273, -0.929588> }
        smooth_triangle {<-1.14502, -6.09626, 2.76433>, <0.39519, -0.043226, -0.951363>,
                         <-1.12668, -5.19389, 2.72003>, <0.390179, -0.0903203, -0.939822>,
                         <-1.01442e-06, -5.19388, 2.94414>, <0.101939, -0.0903204, -1.0176> }
        smooth_triangle {<-5.07594e-07, -6.09626, 2.99209>, <0.0687929, -0.0396276, -1.03467>,
                         <-9.46571e-13, -7, 3>, <5.0991e-09, -0.00907861, -1.03754>,
                         <-1.14805, -7, 2.77164>, <0.397047, -0.00907839, -0.958557> }
        smooth_triangle {<-1.14805, -7, 2.77164>, <0.33331, -0.00907045, -0.983972>,
                         <-1.14502, -6.09626, 2.76433>, <0.39609, -0.0319841, -0.955891>,
                         <-5.07594e-07, -6.09626, 2.99209>, <0.103053, -0.0319843, -1.03471> }
        smooth_triangle {<1.14804, 6, 2.77163>, <-0.205806, 0.00949891, -1.03465>,
                         <1.14487, 5.09627, 2.76397>, <-0.330983, 0.0292238, -0.974192>,
                         <-6.794e-06, 5.09627, 2.9917>, <0.0670191, 0.029224, -1.0267> }
        smooth_triangle {<-6.794e-06, 5.09627, 2.9917>, <-0.00132976, 0.0242993, -1.0294>,
                         <-7.30159e-06, 6, 2.99999>, <-0.000285391, 0.00951219, -1.03609>,
                         <1.14804, 6, 2.77163>, <-0.206091, 0.00951208, -1.03609> }
        smooth_triangle {<1.14487, 5.09627, 2.76397>, <-0.330983, 0.0292238, -0.974192>,
                         <1.12143, 4.19494, 2.70739>, <-0.319613, 0.108952, -0.932947>,
                         <-6.28776e-06, 4.19494, 2.93046>, <0.0617394, 0.108953, -0.984241> }
        smooth_triangle {<-6.28776e-06, 4.19494, 2.93046>, <-0.00501017, 0.0992416, -0.996157>,
                         <-6.794e-06, 5.09627, 2.9917>, <-0.00105039, 0.0394452, -1.028>,
                         <1.14487, 5.09627, 2.76397>, <-0.299552, 0.039445, -0.988621> }
        smooth_triangle {<1.12143, 4.19494, 2.70739>, <-0.319613, 0.108952, -0.932947>,
                         <1.05253, 3.31027, 2.54105>, <-0.29046, 0.220554, -0.839471>,
                         <-5.79087e-06, 3.31027, 2.75041>, <0.0529013, 0.220555, -0.886724> }
        smooth_triangle {<-5.79087e-06, 3.31027, 2.75041>, <-0.00965988, 0.215895, -0.913071>,
                         <-6.28776e-06, 4.19494, 2.93046>, <-0.00303133, 0.132193, -0.986209>,
                         <1.12143, 4.19494, 2.70739>, <-0.289046, 0.132193, -0.947738> }
        smooth_triangle {<1.05253, 3.31027, 2.54105>, <-0.29046, 0.220554, -0.839471>,
                         <0.937109, 2.45886, 2.26239>, <-0.243292, 0.30235, -0.691202>,
                         <-5.31267e-06, 2.45886, 2.4488>, <0.0397392, 0.302351, -0.731691> }
        smooth_triangle {<-5.31267e-06, 2.45886, 2.4488>, <-0.0147585, 0.306127, -0.772801>,
                         <-5.79087e-06, 3.31027, 2.75041>, <-0.00488692, 0.24478, -0.889076>,
                         <1.05253, 3.31027, 2.54105>, <-0.262408, 0.24478, -0.853636> }
        smooth_triangle {<0.937109, 2.45886, 2.26239>, <-0.243292, 0.30235, -0.691202>,
                         <0.766475, 1.67691, 1.85045>, <-0.171783, 0.344055, -0.464042>,
                         <-4.87348e-06, 1.67691, 2.00291>, <0.0188746, 0.344055, -0.494457> }
        smooth_triangle {<-4.87348e-06, 1.67691, 2.00291>, <-0.0222837, 0.362503, -0.554037>,
                         <-5.31267e-06, 2.45886, 2.4488>, <-0.00663528, 0.331225, -0.731962>,
                         <0.937109, 2.45886, 2.26239>, <-0.218908, 0.331225, -0.701596> }
        smooth_triangle {<0.766475, 1.67691, 1.85045>, <-0.171783, 0.344055, -0.464042>,
                         <0.499231, 1.1067, 1.20526>, <-0.0858653, 0.285517, -0.241893>,
                         <-4.55321e-06, 1.1067, 1.30457>, <0.0132393, 0.285517, -0.256339> }
        smooth_triangle {<-4.55321e-06, 1.1067, 1.30457>, <-0.0118046, 0.347954, -0.301519>,
                         <-4.87348e-06, 1.67691, 2.00291>, <-0.00757808, 0.391858, -0.480107>,
                         <0.766475, 1.67691, 1.85045>, <-0.150571, 0.391858, -0.457295> }
        smooth_triangle {<0.499231, 1.1067, 1.20526>, <-0.0858653, 0.285517, -0.241893>,
                         <0.286452, 0.409637, 0.691566>, <-0.0681523, 0.103818, -0.209506>,
                         <-4.1617e-06, 0.409637, 0.748545>, <0.01721, 0.103818, -0.219639> }
        smooth_triangle {<-4.1617e-06, 0.409637, 0.748545>, <-0.00439785, 0.14726, -0.251729>,
                         <-4.55321e-06, 1.1067, 1.30457>, <-0.00737587, 0.283534, -0.279254>,
                         <0.499231, 1.1067, 1.20526>, <-0.0817043, 0.283534, -0.268419> }
        smooth_triangle {<0.286452, 0.409637, 0.691566>, <-0.0681523, 0.103818, -0.209506>,
                         <0.295639, -0.468323, 0.713744>, <-0.0894816, -0.105473, -0.276813>,
                         <-3.66858e-06, -0.468323, 0.772551>, <0.0232616, -0.105473, -0.289985> }
        smooth_triangle {<-3.66858e-06, -0.468323, 0.772551>, <0.00493975, -0.0808236, -0.280363>,
                         <-4.1617e-06, 0.409637, 0.748545>, <0.000401031, 0.0761443, -0.227604>,
                         <0.286452, 0.409637, 0.691566>, <-0.0636207, 0.0761442, -0.220004> }
        smooth_triangle {<0.295639, -0.468323, 0.713744>, <-0.0894816, -0.105473, -0.276813>,
                         <0.518638, -1.14477, 1.25211>, <-0.119666, -0.380319, -0.367715>,
                         <-3.28865e-06, -1.14477, 1.35527>, <0.0301616, -0.380319, -0.385519> }
        smooth_triangle {<-3.28865e-06, -1.14477, 1.35527>, <0.0126764, -0.328308, -0.339136>,
                         <-3.66858e-06, -0.468323, 0.772551>, <0.00750135, -0.122174, -0.267485>,
                         <0.295639, -0.468323, 0.713744>, <-0.077056, -0.122174, -0.257606> }
        smooth_triangle {<0.518638, -1.14477, 1.25211>, <-0.119666, -0.380319, -0.367715>,
                         <0.78139, -1.72693, 1.88645>, <-0.166004, -0.479733, -0.531298>,
                         <-2.96168e-06, -1.72693, 2.04188>, <0.049951, -0.479732, -0.554383> }
        smooth_triangle {<-2.96168e-06, -1.72693, 2.04188>, <0.0224488, -0.448825, -0.49127>,
                         <-3.28865e-06, -1.14477, 1.35527>, <0.0076068, -0.374264, -0.364622>,
                         <0.518638, -1.14477, 1.25211>, <-0.104764, -0.374264, -0.351269> }
        smooth_triangle {<0.78139, -1.72693, 1.88645>, <-0.166004, -0.479733, -0.531298>,
                         <0.931781, -2.53544, 2.24952>, <-0.251272, -0.32202, -0.760994>,
                         <-2.50757e-06, -2.53544, 2.43487>, <0.0590742, -0.32202, -0.799224> }
        smooth_triangle {<-2.50757e-06, -2.53544, 2.43487>, <0.0128892, -0.318285, -0.75736>,
                         <-2.96168e-06, -1.72693, 2.04188>, <0.00604682, -0.436569, -0.573728>,
                         <0.78139, -1.72693, 1.88645>, <-0.15592, -0.436569, -0.556415> }
        smooth_triangle {<0.931781, -2.53544, 2.24952>, <-0.251272, -0.32202, -0.760994>,
                         <1.0195, -3.40935, 2.4613>, <-0.291108, -0.216512, -0.869527>,
                         <-2.01673e-06, -3.40935, 2.66409>, <0.0638052, -0.216512, -0.91474> }
        smooth_triangle {<-2.01673e-06, -3.40935, 2.66409>, <0.00736052, -0.215781, -0.889629>,
                         <-2.50757e-06, -2.53544, 2.43487>, <0.00381232, -0.294912, -0.802992>,
                         <0.931781, -2.53544, 2.24952>, <-0.228948, -0.294912, -0.774319> }
        smooth_triangle {<1.0195, -3.40935, 2.4613>, <-0.291108, -0.216512, -0.869527>,
                         <1.08382, -4.29724, 2.61657>, <-0.312489, -0.163489, -0.929449>,
                         <-1.51804e-06, -4.29724, 2.83215>, <0.0669826, -0.163489, -0.978283> }
        smooth_triangle {<-1.51804e-06, -4.29724, 2.83215>, <0.00522277, -0.165451, -0.960014>,
                         <-2.01673e-06, -3.40935, 2.66409>, <0.00283973, -0.205218, -0.912357>,
                         <1.0195, -3.40935, 2.4613>, <-0.263345, -0.205218, -0.878447> }
        smooth_triangle {<1.08382, -4.29724, 2.61657>, <-0.312489, -0.163489, -0.929449>,
                         <1.12667, -5.19388, 2.72003>, <-0.326241, -0.10242, -0.966635>,
                         <-1.01442e-06, -5.19388, 2.94414>, <0.0685084, -0.10242, -1.0179> }
        smooth_triangle {<-1.01442e-06, -5.19388, 2.94414>, <0.00305539, -0.10716, -1.00638>,
                         <-1.51804e-06, -4.29724, 2.83215>, <0.00191104, -0.152962, -0.976663>,
                         <1.08382, -4.29724, 2.61657>, <-0.282692, -0.152962, -0.940037> }
        smooth_triangle {<1.12667, -5.19388, 2.72003>, <-0.326241, -0.10242, -0.966635>,
                         <1.14502, -6.09626, 2.76433>, <-0.332396, -0.0396278, -0.98224>,
                         <-5.07594e-07, -6.09626, 2.99209>, <0.0687929, -0.0396276, -1.03467> }
        smooth_triangle {<-5.07594e-07, -6.09626, 2.99209>, <0.00103683, -0.0432263, -1.03018>,
                         <-1.01442e-06, -5.19388, 2.94414>, <0.000823437, -0.0903205, -1.0176>,
                         <1.12667, -5.19388, 2.72003>, <-0.295238, -0.0903207, -0.979148> }
        smooth_triangle {<1.14502, -6.09626, 2.76433>, <-0.332396, -0.0396278, -0.98224>,
                         <1.14805, -7, 2.77164>, <-0.397047, -0.00907884, -0.958557>,
                         <-9.46571e-13, -7, 3>, <5.0991e-09, -0.00907861, -1.03754> }
        smooth_triangle {<-9.46571e-13, -7, 3>, <-0.0686115, -0.00907068, -1.03662>,
                         <-5.07594e-07, -6.09626, 2.99209>, <0.000136019, -0.0319844, -1.03471>,
                         <1.14502, -6.09626, 2.76433>, <-0.300756, -0.0319845, -0.99538> }
        smooth_triangle {<2.12131, 6, 2.12132>, <-0.586085, 0.00949869, -0.877138>,
                         <2.11544, 5.09627, 2.11545>, <-0.678595, 0.0292236, -0.773375>,
                         <1.14487, 5.09627, 2.76397>, <-0.330983, 0.0292238, -0.974192> }
        smooth_triangle {<1.14487, 5.09627, 2.76397>, <-0.395165, 0.0242991, -0.950537>,
                         <1.14804, 6, 2.77163>, <-0.396758, 0.00951197, -0.957113>,
                         <2.12131, 6, 2.12132>, <-0.586898, 0.00951186, -0.878354> }
        smooth_triangle {<2.11544, 5.09627, 2.11545>, <-0.678595, 0.0292236, -0.773375>,
                         <2.07214, 4.19495, 2.07215>, <-0.652307, 0.108952, -0.73962>,
                         <1.12143, 4.19494, 2.70739>, <-0.319613, 0.108952, -0.932947> }
        smooth_triangle {<1.12143, 4.19494, 2.70739>, <-0.385842, 0.0992414, -0.918412>,
                         <1.14487, 5.09627, 2.76397>, <-0.394369, 0.0394449, -0.949346>,
                         <2.11544, 5.09627, 2.11545>, <-0.655078, 0.0394448, -0.798733> }
        smooth_triangle {<2.07214, 4.19495, 2.07215>, <-0.652307, 0.108952, -0.73962>,
                         <1.94483, 3.31027, 1.94483>, <-0.589602, 0.220554, -0.664416>,
                         <1.05253, 3.31027, 2.54105>, <-0.29046, 0.220554, -0.839471> }
        smooth_triangle {<1.05253, 3.31027, 2.54105>, <-0.358342, 0.215895, -0.839871>,
                         <1.12143, 4.19494, 2.70739>, <-0.380206, 0.132193, -0.909978>,
                         <2.07214, 4.19495, 2.07215>, <-0.629727, 0.132193, -0.764983> }
        smooth_triangle {<1.94483, 3.31027, 1.94483>, <-0.589602, 0.220554, -0.664416>,
                         <1.73156, 2.45886, 1.73156>, <-0.489284, 0.30235, -0.545483>,
                         <0.937109, 2.45886, 2.26239>, <-0.243292, 0.30235, -0.691202> }
        smooth_triangle {<0.937109, 2.45886, 2.26239>, <-0.309373, 0.306127, -0.708327>,
                         <1.05253, 3.31027, 2.54105>, <-0.344749, 0.24478, -0.819529>,
                         <1.94483, 3.31027, 1.94483>, <-0.569106, 0.24478, -0.688237> }
        smooth_triangle {<1.73156, 2.45886, 1.73156>, <-0.489284, 0.30235, -0.545483>,
                         <1.41627, 1.67691, 1.41627>, <-0.336288, 0.344055, -0.36298>,
                         <0.766475, 1.67691, 1.85045>, <-0.171783, 0.344055, -0.464042> }
        smooth_triangle {<0.766475, 1.67691, 1.85045>, <-0.232608, 0.362503, -0.503336>,
                         <0.937109, 2.45886, 2.26239>, <-0.28624, 0.331225, -0.673706>,
                         <1.73156, 2.45886, 1.73156>, <-0.470734, 0.331225, -0.564417> }
        smooth_triangle {<1.41627, 1.67691, 1.41627>, <-0.336288, 0.344055, -0.36298>,
                         <0.922462, 1.1067, 0.922467>, <-0.171898, 0.285517, -0.190621>,
                         <0.499231, 1.1067, 1.20526>, <-0.0858653, 0.285517, -0.241893> }
        smooth_triangle {<0.499231, 1.1067, 1.20526>, <-0.126292, 0.347954, -0.274049>,
                         <0.766475, 1.67691, 1.85045>, <-0.19073, 0.391858, -0.440661>,
                         <1.41627, 1.67691, 1.41627>, <-0.314109, 0.391858, -0.364865> }
        smooth_triangle {<0.922462, 1.1067, 0.922467>, <-0.171898, 0.285517, -0.190621>,
                         <0.529297, 0.409637, 0.529301>, <-0.143139, 0.103818, -0.167478>,
                         <0.286452, 0.409637, 0.691566>, <-0.0681523, 0.103818, -0.209506> }
        smooth_triangle {<0.286452, 0.409637, 0.691566>, <-0.100396, 0.14726, -0.230884>,
                         <0.499231, 1.1067, 1.20526>, <-0.11368, 0.283534, -0.255175>,
                         <0.922462, 1.1067, 0.922467>, <-0.178205, 0.283534, -0.21672> }
        smooth_triangle {<0.529297, 0.409637, 0.529301>, <-0.143139, 0.103818, -0.167478>,
                         <0.546272, -0.468323, 0.546276>, <-0.188602, -0.105473, -0.221499>,
                         <0.295639, -0.468323, 0.713744>, <-0.0894816, -0.105473, -0.276813> }
        smooth_triangle {<0.295639, -0.468323, 0.713744>, <-0.102727, -0.0808237, -0.260912>,
                         <0.286452, 0.409637, 0.691566>, <-0.0867296, 0.0761442, -0.210432>,
                         <0.529297, 0.409637, 0.529301>, <-0.14297, 0.0761442, -0.17891> }
        smooth_triangle {<0.546272, -0.468323, 0.546276>, <-0.188602, -0.105473, -0.221499>,
                         <0.95832, -1.14477, 0.958323>, <-0.251276, -0.380319, -0.293931>,
                         <0.518638, -1.14477, 1.25211>, <-0.119666, -0.380319, -0.367715> }
        smooth_triangle {<0.518638, -1.14477, 1.25211>, <-0.11807, -0.328308, -0.318171>,
                         <0.295639, -0.468323, 0.713744>, <-0.0954318, -0.122174, -0.249995>,
                         <0.546272, -0.468323, 0.546276>, <-0.169772, -0.122174, -0.208509> }
        smooth_triangle {<0.95832, -1.14477, 0.958323>, <-0.251276, -0.380319, -0.293931>,
                         <1.44382, -1.72692, 1.44383>, <-0.356687, -0.479733, -0.427328>,
                         <0.78139, -1.72693, 1.88645>, <-0.166004, -0.479733, -0.531298> }
        smooth_triangle {<0.78139, -1.72693, 1.88645>, <-0.167261, -0.448825, -0.462465>,
                         <0.518638, -1.14477, 1.25211>, <-0.132507, -0.374264, -0.339778>,
                         <0.95832, -1.14477, 0.958323>, <-0.231214, -0.374264, -0.284439> }
        smooth_triangle {<1.44382, -1.72692, 1.44383>, <-0.356687, -0.479733, -0.427328>,
                         <1.72171, -2.53544, 1.72171>, <-0.523365, -0.32202, -0.606909>,
                         <0.931781, -2.53544, 2.24952>, <-0.251272, -0.32202, -0.760994> }
        smooth_triangle {<0.931781, -2.53544, 2.24952>, <-0.277921, -0.318285, -0.704641>,
                         <0.78139, -1.72693, 1.88645>, <-0.21397, -0.436569, -0.53237>,
                         <1.44382, -1.72692, 1.44383>, <-0.356982, -0.436569, -0.454393> }
        smooth_triangle {<1.72171, -2.53544, 1.72171>, <-0.523365, -0.32202, -0.606909>,
                         <1.8838, -3.40935, 1.8838>, <-0.601702, -0.216513, -0.691936>,
                         <1.0195, -3.40935, 2.4613>, <-0.291108, -0.216512, -0.869527> }
        smooth_triangle {<1.0195, -3.40935, 2.4613>, <-0.333646, -0.215781, -0.824727>,
                         <0.931781, -2.53544, 2.24952>, <-0.30377, -0.294912, -0.743327>,
                         <1.72171, -2.53544, 1.72171>, <-0.507839, -0.294912, -0.627763> }
        smooth_triangle {<1.8838, -3.40935, 1.8838>, <-0.601702, -0.216513, -0.691936>,
                         <2.00263, -4.29724, 2.00263>, <-0.644387, -0.16349, -0.739114>,
                         <1.08382, -4.29724, 2.61657>, <-0.312489, -0.163489, -0.929449> }
        smooth_triangle {<1.08382, -4.29724, 2.61657>, <-0.362556, -0.165451, -0.888936>,
                         <1.0195, -3.40935, 2.4613>, <-0.34652, -0.205218, -0.843994>,
                         <1.8838, -3.40935, 1.8838>, <-0.579466, -0.205218, -0.710801> }
        smooth_triangle {<2.00263, -4.29724, 2.00263>, <-0.644387, -0.16349, -0.739114>,
                         <2.08182, -5.19388, 2.08182>, <-0.671322, -0.10242, -0.768208>,
                         <1.12667, -5.19388, 2.72003>, <-0.326241, -0.10242, -0.966635> }
        smooth_triangle {<1.12667, -5.19388, 2.72003>, <-0.382301, -0.10716, -0.93094>,
                         <1.08382, -4.29724, 2.61657>, <-0.371987, -0.152962, -0.90305>,
                         <2.00263, -4.29724, 2.00263>, <-0.62091, -0.152962, -0.760299> }
        smooth_triangle {<2.08182, -5.19388, 2.08182>, <-0.671322, -0.10242, -0.768208>,
                         <2.11573, -6.09626, 2.11573>, <-0.682981, -0.039628, -0.780269>,
                         <1.14502, -6.09626, 2.76433>, <-0.332396, -0.0396278, -0.98224> }
        smooth_triangle {<1.14502, -6.09626, 2.76433>, <-0.393274, -0.0432265, -0.952156>,
                         <1.12667, -5.19388, 2.72003>, <-0.388657, -0.0903207, -0.940453>,
                         <2.08182, -5.19388, 2.08182>, <-0.647468, -0.0903208, -0.791632> }
        smooth_triangle {<2.11573, -6.09626, 2.11573>, <-0.682981, -0.039628, -0.780269>,
                         <2.12132, -7, 2.12132>, <-0.733648, -0.00907903, -0.733648>,
                         <1.14805, -7, 2.77164>, <-0.397047, -0.00907884, -0.958557> }
        smooth_triangle {<1.14805, -7, 2.77164>, <-0.460087, -0.00907089, -0.931459>,
                         <1.14502, -6.09626, 2.76433>, <-0.395839, -0.0319846, -0.955995>,
                         <2.11573, -6.09626, 2.11573>, <-0.658778, -0.0319847, -0.804517> }
        smooth_triangle {<2.77162, 6, 1.14805>, <-0.877138, 0.00949853, -0.586085>,
                         <2.76396, 5.09627, 1.14487>, <-0.922898, 0.0292234, -0.454818>,
                         <2.11544, 5.09627, 2.11545>, <-0.678595, 0.0292236, -0.773375> }
        smooth_triangle {<2.11544, 5.09627, 2.11545>, <-0.728839, 0.0242989, -0.726959>,
                         <2.12131, 6, 2.12132>, <-0.732828, 0.00951178, -0.732424>,
                         <2.77162, 6, 1.14805>, <-0.878354, 0.0095117, -0.586898> }
        smooth_triangle {<2.76396, 5.09627, 1.14487>, <-0.922898, 0.0292234, -0.454818>,
                         <2.70738, 4.19495, 1.12144>, <-0.885694, 0.108952, -0.433693>,
                         <2.07214, 4.19495, 2.07215>, <-0.652307, 0.108952, -0.73962> }
        smooth_triangle {<2.07214, 4.19495, 2.07215>, <-0.707932, 0.0992412, -0.700847>,
                         <2.11544, 5.09627, 2.11545>, <-0.727648, 0.0394448, -0.726163>,
                         <2.76396, 5.09627, 1.14487>, <-0.910875, 0.0394447, -0.487245> }
        smooth_triangle {<2.70738, 4.19495, 1.12144>, <-0.885694, 0.108952, -0.433693>,
                         <2.54104, 3.31027, 1.05254>, <-0.798982, 0.220554, -0.388209>,
                         <1.94483, 3.31027, 1.94483>, <-0.589602, 0.220554, -0.664416> }
        smooth_triangle {<1.94483, 3.31027, 1.94483>, <-0.652469, 0.215895, -0.638808>,
                         <2.07214, 4.19495, 2.07215>, <-0.699498, 0.132193, -0.695212>,
                         <2.70738, 4.19495, 1.12144>, <-0.874538, 0.132193, -0.465766> }
        smooth_triangle {<2.54104, 3.31027, 1.05254>, <-0.798982, 0.220554, -0.388209>,
                         <2.26239, 2.45886, 0.937114>, <-0.660787, 0.30235, -0.31672>,
                         <1.73156, 2.45886, 1.73156>, <-0.489284, 0.30235, -0.545483> }
        smooth_triangle {<1.73156, 2.45886, 1.73156>, <-0.556888, 0.306127, -0.536017>,
                         <1.94483, 3.31027, 1.94483>, <-0.632127, 0.24478, -0.625216>,
                         <2.54104, 3.31027, 1.05254>, <-0.789162, 0.24478, -0.418061> }
        smooth_triangle {<2.26239, 2.45886, 0.937114>, <-0.660787, 0.30235, -0.31672>,
                         <1.85044, 1.67691, 0.76648>, <-0.449596, 0.344055, -0.206659>,
                         <1.41627, 1.67691, 1.41627>, <-0.336288, 0.344055, -0.36298> }
        smooth_triangle {<1.41627, 1.67691, 1.41627>, <-0.407521, 0.362503, -0.376007>,
                         <1.73156, 2.45886, 1.73156>, <-0.522267, 0.331225, -0.512884>,
                         <2.26239, 2.45886, 0.937114>, <-0.650895, 0.331225, -0.341312> }
        smooth_triangle {<1.85044, 1.67691, 0.76648>, <-0.449596, 0.344055, -0.206659>,
                         <1.20526, 1.1067, 0.499236>, <-0.23176, 0.285517, -0.110328>,
                         <0.922462, 1.1067, 0.922467>, <-0.171898, 0.285517, -0.190621> }
        smooth_triangle {<0.922462, 1.1067, 0.922467>, <-0.221553, 0.347954, -0.204859>,
                         <1.41627, 1.67691, 1.41627>, <-0.344845, 0.391858, -0.334128>,
                         <1.85044, 1.67691, 0.76648>, <-0.429827, 0.391858, -0.216887> }
        smooth_triangle {<1.20526, 1.1067, 0.499236>, <-0.23176, 0.285517, -0.110328>,
                         <0.691561, 0.409637, 0.286456>, <-0.196334, 0.103818, -0.0999522>,
                         <0.529297, 0.409637, 0.529301>, <-0.143139, 0.103818, -0.167478> }
        smooth_triangle {<0.529297, 0.409637, 0.529301>, <-0.181109, 0.14726, -0.17489>,
                         <0.922462, 1.1067, 0.922467>, <-0.202678, 0.283534, -0.192247>,
                         <1.20526, 1.1067, 0.499236>, <-0.247575, 0.283534, -0.132028> }
        smooth_triangle {<0.691561, 0.409637, 0.286456>, <-0.196334, 0.103818, -0.0999522>,
                         <0.71374, -0.468323, 0.295642>, <-0.259009, -0.105473, -0.132463>,
                         <0.546272, -0.468323, 0.546276>, <-0.188602, -0.105473, -0.221499> }
        smooth_triangle {<0.546272, -0.468323, 0.546276>, <-0.194754, -0.0808237, -0.201739>,
                         <0.529297, 0.409637, 0.529301>, <-0.160656, 0.0761442, -0.161224>,
                         <0.691561, 0.409637, 0.286456>, <-0.200553, 0.0761441, -0.11058> }
        smooth_triangle {<0.71374, -0.468323, 0.295642>, <-0.259009, -0.105473, -0.132463>,
                         <1.25211, -1.14477, 0.518641>, <-0.344631, -0.380319, -0.175397>,
                         <0.95832, -1.14477, 0.958323>, <-0.251276, -0.380319, -0.293931> }
        smooth_triangle {<0.95832, -1.14477, 0.958323>, <-0.230842, -0.328309, -0.248769>,
                         <0.546272, -0.468323, 0.546276>, <-0.183836, -0.122174, -0.194445>,
                         <0.71374, -0.468323, 0.295642>, <-0.236642, -0.122174, -0.127668> }
        smooth_triangle {<1.25211, -1.14477, 0.518641>, <-0.344631, -0.380319, -0.175397>,
                         <1.88645, -1.72692, 0.781393>, <-0.493067, -0.479733, -0.258302>,
                         <1.44382, -1.72692, 1.44383>, <-0.356687, -0.479733, -0.427328> }
        smooth_triangle {<1.44382, -1.72692, 1.44383>, <-0.331507, -0.448825, -0.363254>,
                         <0.95832, -1.14477, 0.958323>, <-0.252448, -0.374264, -0.263206>,
                         <1.25211, -1.14477, 0.518641>, <-0.322464, -0.374264, -0.174306> }
        smooth_triangle {<1.88645, -1.72692, 0.781393>, <-0.493067, -0.479733, -0.258302>,
                         <2.24952, -2.53544, 0.931784>, <-0.71578, -0.32202, -0.360427>,
                         <1.72171, -2.53544, 1.72171>, <-0.523365, -0.32202, -0.606909> }
        smooth_triangle {<1.72171, -2.53544, 1.72171>, <-0.52642, -0.318285, -0.544648>,
                         <1.44382, -1.72692, 1.44383>, <-0.401411, -0.436569, -0.409963>,
                         <1.88645, -1.72692, 0.781393>, <-0.503697, -0.43657, -0.283193> }
        smooth_triangle {<2.24952, -2.53544, 0.931784>, <-0.71578, -0.32202, -0.360427>,
                         <2.4613, -3.40935, 1.0195>, <-0.820693, -0.216513, -0.409004>,
                         <1.8838, -3.40935, 1.8838>, <-0.601702, -0.216513, -0.691936> }
        smooth_triangle {<1.8838, -3.40935, 1.8838>, <-0.623858, -0.215782, -0.634267>,
                         <1.72171, -2.53544, 1.72171>, <-0.565105, -0.294912, -0.570497>,
                         <2.24952, -2.53544, 0.931784>, <-0.709417, -0.294912, -0.385636> }
        smooth_triangle {<2.4613, -3.40935, 1.0195>, <-0.820693, -0.216513, -0.409004>,
                         <2.61657, -4.29724, 1.08382>, <-0.878182, -0.16349, -0.436256>,
                         <2.00263, -4.29724, 2.00263>, <-0.644387, -0.16349, -0.739114> }
        smooth_triangle {<2.00263, -4.29724, 2.00263>, <-0.675139, -0.165451, -0.682525>,
                         <1.8838, -3.40935, 1.8838>, <-0.643126, -0.205219, -0.647142>,
                         <2.4613, -3.40935, 1.0195>, <-0.807369, -0.205219, -0.434943> }
        smooth_triangle {<2.61657, -4.29724, 1.08382>, <-0.878182, -0.16349, -0.436256>,
                         <2.72003, -5.19388, 1.12668>, <-0.914201, -0.10242, -0.452827>,
                         <2.08182, -5.19388, 2.08182>, <-0.671322, -0.10242, -0.768208> }
        smooth_triangle {<2.08182, -5.19388, 2.08182>, <-0.709455, -0.10716, -0.713776>,
                         <2.00263, -4.29724, 2.00263>, <-0.689254, -0.152962, -0.691956>,
                         <2.61657, -4.29724, 1.08382>, <-0.8646, -0.152962, -0.464813> }
        smooth_triangle {<2.72003, -5.19388, 1.12668>, <-0.914201, -0.10242, -0.452827>,
                         <2.76433, -6.09626, 1.14502>, <-0.929588, -0.0396281, -0.459509>,
                         <2.11573, -6.09626, 2.11573>, <-0.682981, -0.039628, -0.780269> }
        smooth_triangle {<2.11573, -6.09626, 2.11573>, <-0.727712, -0.0432267, -0.729178>,
                         <2.08182, -5.19388, 2.08182>, <-0.718968, -0.0903209, -0.720132>,
                         <2.72003, -5.19388, 1.12668>, <-0.901127, -0.090321, -0.483597> }
        smooth_triangle {<2.76433, -6.09626, 1.14502>, <-0.929588, -0.0396281, -0.459509>,
                         <2.77164, -7, 1.14805>, <-0.958557, -0.00907915, -0.397047>,
                         <2.12132, -7, 2.12132>, <-0.733648, -0.00907903, -0.733648> }
        smooth_triangle {<2.12132, -7, 2.12132>, <-0.781519, -0.00907108, -0.684488>,
                         <2.11573, -6.09626, 2.11573>, <-0.731551, -0.0319848, -0.731743>,
                         <2.76433, -6.09626, 1.14502>, <-0.916506, -0.0319849, -0.491173> }
        smooth_triangle {<2.99999, 6, 3.67381e-16>, <-1.03465, 0.00949844, -0.205806>,
                         <2.99169, 5.09627, 3.66365e-16>, <-1.0267, 0.0292234, -0.0670191>,
                         <2.76396, 5.09627, 1.14487>, <-0.922898, 0.0292234, -0.454818> }
        smooth_triangle {<2.76396, 5.09627, 1.14487>, <-0.951554, 0.0242988, -0.392707>,
                         <2.77162, 6, 1.14805>, <-0.957331, 0.00951166, -0.396231>,
                         <2.99999, 6, 3.67381e-16>, <-1.03609, 0.00951161, -0.206091> }
        smooth_triangle {<2.99169, 5.09627, 3.66365e-16>, <-1.0267, 0.0292234, -0.0670191>,
                         <2.93045, 4.19495, 3.58866e-16>, <-0.984241, 0.108952, -0.0617395>,
                         <2.70738, 4.19495, 1.12144>, <-0.885694, 0.108952, -0.433693> }
        smooth_triangle {<2.70738, 4.19495, 1.12144>, <-0.922247, 0.0992411, -0.376584>,
                         <2.76396, 5.09627, 1.14487>, <-0.95015, 0.0394446, -0.392428>,
                         <2.99169, 5.09627, 3.66365e-16>, <-1.028, 0.0394446, -0.101579> }
        smooth_triangle {<2.93045, 4.19495, 3.58866e-16>, <-0.984241, 0.108952, -0.0617395>,
                         <2.7504, 3.31027, 3.36817e-16>, <-0.886724, 0.220554, -0.0529015>,
                         <2.54104, 3.31027, 1.05254>, <-0.798982, 0.220554, -0.388209> }
        smooth_triangle {<2.54104, 3.31027, 1.05254>, <-0.847264, 0.215894, -0.340493>,
                         <2.70738, 4.19495, 1.12144>, <-0.912298, 0.132193, -0.374605>,
                         <2.93045, 4.19495, 3.58866e-16>, <-0.986209, 0.132193, -0.0956404> }
        smooth_triangle {<2.7504, 3.31027, 3.36817e-16>, <-0.886724, 0.220554, -0.0529015>,
                         <2.44879, 2.45886, 2.99881e-16>, <-0.731691, 0.30235, -0.0397394>,
                         <2.26239, 2.45886, 0.937114>, <-0.660787, 0.30235, -0.31672> }
        smooth_triangle {<2.26239, 2.45886, 0.937114>, <-0.719623, 0.306127, -0.282103>,
                         <2.54104, 3.31027, 1.05254>, <-0.823269, 0.24478, -0.33572>,
                         <2.7504, 3.31027, 3.36817e-16>, <-0.889076, 0.24478, -0.084239> }
        smooth_triangle {<2.44879, 2.45886, 2.99881e-16>, <-0.731691, 0.30235, -0.0397394>,
                         <2.0029, 1.67691, 2.45277e-16>, <-0.494457, 0.344055, -0.0188748>,
                         <1.85044, 1.67691, 0.76648>, <-0.449596, 0.344055, -0.206659> }
        smooth_triangle {<1.85044, 1.67691, 0.76648>, <-0.520391, 0.362503, -0.191434>,
                         <2.26239, 2.45886, 0.937114>, <-0.678784, 0.331225, -0.27398>,
                         <2.44879, 2.45886, 2.99881e-16>, <-0.731963, 0.331225, -0.0662442> }
        smooth_triangle {<2.0029, 1.67691, 2.45277e-16>, <-0.494457, 0.344055, -0.0188748>,
                         <1.30456, 1.1067, 1.59758e-16>, <-0.25634, 0.285517, -0.0132394>,
                         <1.20526, 1.1067, 0.499236>, <-0.23176, 0.285517, -0.110328> }
        smooth_triangle {<1.20526, 1.1067, 0.499236>, <-0.283084, 0.347954, -0.10448>,
                         <1.85044, 1.67691, 0.76648>, <-0.446461, 0.391858, -0.176728>,
                         <2.0029, 1.67691, 2.45277e-16>, <-0.480107, 0.391858, -0.0358901> }
        smooth_triangle {<1.30456, 1.1067, 1.59758e-16>, <-0.25634, 0.285517, -0.0132394>,
                         <0.748541, 0.409637, 9.16673e-17>, <-0.219639, 0.103818, -0.01721>,
                         <0.691561, 0.409637, 0.286456>, <-0.196334, 0.103818, -0.0999522> }
        smooth_triangle {<0.691561, 0.409637, 0.286456>, <-0.23425, 0.14726, -0.0922695>,
                         <1.20526, 1.1067, 0.499236>, <-0.26082, 0.283534, -0.100052>,
                         <1.30456, 1.1067, 1.59758e-16>, <-0.279254, 0.283534, -0.0272349> }
        smooth_triangle {<0.748541, 0.409637, 9.16673e-17>, <-0.219639, 0.103818, -0.01721>,
                         <0.772547, -0.468323, 9.4607e-17>, <-0.289985, -0.105473, -0.0232615>,
                         <0.71374, -0.468323, 0.295642>, <-0.259009, -0.105473, -0.132463> }
        smooth_triangle {<0.71374, -0.468323, 0.295642>, <-0.257131, -0.0808238, -0.111854>,
                         <0.691561, 0.409637, 0.286456>, <-0.210125, 0.0761441, -0.0874706>,
                         <0.748541, 0.409637, 9.16673e-17>, <-0.227604, 0.0761441, -0.025414> }
        smooth_triangle {<0.772547, -0.468323, 9.4607e-17>, <-0.289985, -0.105473, -0.0232615>,
                         <1.35527, -1.14477, 1.65968e-16>, <-0.385519, -0.380319, -0.0301614>,
                         <1.25211, -1.14477, 0.518641>, <-0.344631, -0.380319, -0.175397> }
        smooth_triangle {<1.25211, -1.14477, 0.518641>, <-0.308469, -0.328309, -0.141493>,
                         <0.71374, -0.468323, 0.295642>, <-0.244253, -0.122174, -0.109292>,
                         <0.772547, -0.468323, 9.4607e-17>, <-0.267485, -0.122174, -0.027391> }
        smooth_triangle {<1.35527, -1.14477, 1.65968e-16>, <-0.385519, -0.380319, -0.0301614>,
                         <2.04188, -1.72692, 2.5005e-16>, <-0.554383, -0.479733, -0.0499508>,
                         <1.88645, -1.72692, 0.781393>, <-0.493067, -0.479733, -0.258302> }
        smooth_triangle {<1.88645, -1.72692, 0.781393>, <-0.445283, -0.448825, -0.208741>,
                         <1.25211, -1.14477, 0.518641>, <-0.333956, -0.374264, -0.146562>,
                         <1.35527, -1.14477, 1.65968e-16>, <-0.364622, -0.374264, -0.0376355> }
        smooth_triangle {<2.04188, -1.72692, 2.5005e-16>, <-0.554383, -0.479733, -0.0499508>,
                         <2.43487, -2.53544, 2.98176e-16>, <-0.799224, -0.32202, -0.0590741>,
                         <2.24952, -2.53544, 0.931784>, <-0.71578, -0.32202, -0.360427> }
        smooth_triangle {<2.24952, -2.53544, 0.931784>, <-0.694776, -0.318285, -0.301737>,
                         <1.88645, -1.72692, 0.781393>, <-0.527742, -0.43657, -0.225143>,
                         <2.04188, -1.72692, 2.5005e-16>, <-0.573728, -0.43657, -0.0688796> }
        smooth_triangle {<2.43487, -2.53544, 2.98176e-16>, <-0.799224, -0.32202, -0.0590741>,
                         <2.66409, -3.40935, 3.26247e-16>, <-0.91474, -0.216513, -0.063805>,
                         <2.4613, -3.40935, 1.0195>, <-0.820693, -0.216513, -0.409004> }
        smooth_triangle {<2.4613, -3.40935, 1.0195>, <-0.819093, -0.215782, -0.347246>,
                         <2.24952, -2.53544, 0.931784>, <-0.740409, -0.294912, -0.310814>,
                         <2.43487, -2.53544, 2.98176e-16>, <-0.802992, -0.294912, -0.0847989> }
        smooth_triangle {<2.66409, -3.40935, 3.26247e-16>, <-0.91474, -0.216513, -0.063805>,
                         <2.83215, -4.29724, 3.46827e-16>, <-0.978283, -0.16349, -0.0669825>,
                         <2.61657, -4.29724, 1.08382>, <-0.878182, -0.16349, -0.436256> }
        smooth_triangle {<2.61657, -4.29724, 1.08382>, <-0.884938, -0.165451, -0.372206>,
                         <2.4613, -3.40935, 1.0195>, <-0.841821, -0.205219, -0.351767>,
                         <2.66409, -3.40935, 3.26247e-16>, <-0.912357, -0.205219, -0.0928679> }
        smooth_triangle {<2.83215, -4.29724, 3.46827e-16>, <-0.978283, -0.16349, -0.0669825>,
                         <2.94414, -5.19388, 3.60542e-16>, <-1.0179, -0.10242, -0.0685083>,
                         <2.72003, -5.19388, 1.12668>, <-0.914201, -0.10242, -0.452827> }
        smooth_triangle {<2.72003, -5.19388, 1.12668>, <-0.928602, -0.10716, -0.387947>,
                         <2.61657, -4.29724, 1.08382>, <-0.901587, -0.152962, -0.375518>,
                         <2.83215, -4.29724, 3.46827e-16>, <-0.976663, -0.152962, -0.0985627> }
        smooth_triangle {<2.94414, -5.19388, 3.60542e-16>, <-1.0179, -0.10242, -0.0685083>,
                         <2.99209, -6.09626, 3.66414e-16>, <-1.03467, -0.0396282, -0.0687929>,
                         <2.76433, -6.09626, 1.14502>, <-0.929588, -0.0396281, -0.459509> }
        smooth_triangle {<2.76433, -6.09626, 1.14502>, <-0.951363, -0.0432268, -0.395189>,
                         <2.72003, -5.19388, 1.12668>, <-0.939822, -0.090321, -0.390178>,
                         <2.94414, -5.19388, 3.60542e-16>, <-1.0176, -0.0903211, -0.101939> }
        smooth_triangle {<2.99209, -6.09626, 3.66414e-16>, <-1.03467, -0.0396282, -0.0687929>,
                         <3, -7, 3.67382e-16>, <-1.03754, -0.0090792, -1.80411e-16>,
                         <2.77164, -7, 1.14805>, <-0.958557, -0.00907915, -0.397047> }
        smooth_triangle {<2.77164, -7, 1.14805>, <-0.983972, -0.00907119, -0.33331>,
                         <2.76433, -6.09626, 1.14502>, <-0.955891, -0.0319849, -0.39609>,
                         <2.99209, -6.09626, 3.66414e-16>, <-1.03471, -0.0319849, -0.103053> }
        smooth_triangle {<2.77162, 6, -1.14805>, <-1.03465, 0.00949844, 0.205806>,
                         <2.76396, 5.09627, -1.14487>, <-0.974192, 0.0292234, 0.330983>,
                         <2.99169, 5.09627, 3.66365e-16>, <-1.0267, 0.0292234, -0.0670191> }
        smooth_triangle {<2.99169, 5.09627, 3.66365e-16>, <-1.0294, 0.0242987, 0.00132975>,
                         <2.99999, 6, 3.67381e-16>, <-1.03609, 0.00951161, 0.000285385>,
                         <2.77162, 6, -1.14805>, <-1.03609, 0.00951161, 0.206091> }
        smooth_triangle {<2.76396, 5.09627, -1.14487>, <-0.974192, 0.0292234, 0.330983>,
                         <2.70738, 4.19495, -1.12144>, <-0.932947, 0.108952, 0.319613>,
                         <2.93045, 4.19495, 3.58866e-16>, <-0.984241, 0.108952, -0.0617395> }
        smooth_triangle {<2.93045, 4.19495, 3.58866e-16>, <-0.996157, 0.099241, 0.00501012>,
                         <2.99169, 5.09627, 3.66365e-16>, <-1.028, 0.0394446, 0.00105037>,
                         <2.76396, 5.09627, -1.14487>, <-0.988621, 0.0394446, 0.299552> }
        smooth_triangle {<2.70738, 4.19495, -1.12144>, <-0.932947, 0.108952, 0.319613>,
                         <2.54104, 3.31027, -1.05254>, <-0.839471, 0.220554, 0.29046>,
                         <2.7504, 3.31027, 3.36817e-16>, <-0.886724, 0.220554, -0.0529015> }
        smooth_triangle {<2.7504, 3.31027, 3.36817e-16>, <-0.913071, 0.215894, 0.00965976>,
                         <2.93045, 4.19495, 3.58866e-16>, <-0.986209, 0.132193, 0.00303125>,
                         <2.70738, 4.19495, -1.12144>, <-0.947738, 0.132193, 0.289046> }
        smooth_triangle {<2.54104, 3.31027, -1.05254>, <-0.839471, 0.220554, 0.29046>,
                         <2.26239, 2.45886, -0.937114>, <-0.691202, 0.30235, 0.243291>,
                         <2.44879, 2.45886, 2.99881e-16>, <-0.731691, 0.30235, -0.0397394> }
        smooth_triangle {<2.44879, 2.45886, 2.99881e-16>, <-0.772801, 0.306127, 0.0147583>,
                         <2.7504, 3.31027, 3.36817e-16>, <-0.889076, 0.24478, 0.00488679>,
                         <2.54104, 3.31027, -1.05254>, <-0.853636, 0.24478, 0.262408> }
        smooth_triangle {<2.26239, 2.45886, -0.937114>, <-0.691202, 0.30235, 0.243291>,
                         <1.85044, 1.67691, -0.76648>, <-0.464042, 0.344055, 0.171782>,
                         <2.0029, 1.67691, 2.45277e-16>, <-0.494457, 0.344055, -0.0188748> }
        smooth_triangle {<2.0029, 1.67691, 2.45277e-16>, <-0.554037, 0.362503, 0.0222835>,
                         <2.44879, 2.45886, 2.99881e-16>, <-0.731963, 0.331225, 0.0066351>,
                         <2.26239, 2.45886, -0.937114>, <-0.701596, 0.331225, 0.218908> }
        smooth_triangle {<1.85044, 1.67691, -0.76648>, <-0.464042, 0.344055, 0.171782>,
                         <1.20526, 1.1067, -0.499236>, <-0.241893, 0.285517, 0.0858652>,
                         <1.30456, 1.1067, 1.59758e-16>, <-0.25634, 0.285517, -0.0132394> }
        smooth_triangle {<1.30456, 1.1067, 1.59758e-16>, <-0.301519, 0.347954, 0.0118044>,
                         <2.0029, 1.67691, 2.45277e-16>, <-0.480107, 0.391858, 0.00757786>,
                         <1.85044, 1.67691, -0.76648>, <-0.457296, 0.391858, 0.150571> }
        smooth_triangle {<1.20526, 1.1067, -0.499236>, <-0.241893, 0.285517, 0.0858652>,
                         <0.691561, 0.409637, -0.286456>, <-0.209506, 0.103818, 0.0681522>,
                         <0.748541, 0.409637, 9.16673e-17>, <-0.219639, 0.103818, -0.01721> }
        smooth_triangle {<0.748541, 0.409637, 9.16673e-17>, <-0.251729, 0.147259, 0.00439777>,
                         <1.30456, 1.1067, 1.59758e-16>, <-0.279254, 0.283534, 0.00737571>,
                         <1.20526, 1.1067, -0.499236>, <-0.26842, 0.283534, 0.0817042> }
        smooth_triangle {<0.691561, 0.409637, -0.286456>, <-0.209506, 0.103818, 0.0681522>,
                         <0.71374, -0.468323, -0.295642>, <-0.276813, -0.105473, 0.0894816>,
                         <0.772547, -0.468323, 9.4607e-17>, <-0.289985, -0.105473, -0.0232615> }
        smooth_triangle {<0.772547, -0.468323, 9.4607e-17>, <-0.280363, -0.0808238, -0.00493971>,
                         <0.748541, 0.409637, 9.16673e-17>, <-0.227604, 0.0761441, -0.000401074>,
                         <0.691561, 0.409637, -0.286456>, <-0.220004, 0.0761441, 0.0636206> }
        smooth_triangle {<0.71374, -0.468323, -0.295642>, <-0.276813, -0.105473, 0.0894816>,
                         <1.25211, -1.14477, -0.518641>, <-0.367715, -0.380319, 0.119666>,
                         <1.35527, -1.14477, 1.65968e-16>, <-0.385519, -0.380319, -0.0301614> }
        smooth_triangle {<1.35527, -1.14477, 1.65968e-16>, <-0.339135, -0.328309, -0.0126762>,
                         <0.772547, -0.468323, 9.4607e-17>, <-0.267485, -0.122174, -0.00750128>,
                         <0.71374, -0.468323, -0.295642>, <-0.257606, -0.122174, 0.0770561> }
        smooth_triangle {<1.25211, -1.14477, -0.518641>, <-0.367715, -0.380319, 0.119666>,
                         <1.88645, -1.72692, -0.781393>, <-0.531298, -0.479733, 0.166005>,
                         <2.04188, -1.72692, 2.5005e-16>, <-0.554383, -0.479733, -0.0499508> }
        smooth_triangle {<2.04188, -1.72692, 2.5005e-16>, <-0.49127, -0.448825, -0.0224486>,
                         <1.35527, -1.14477, 1.65968e-16>, <-0.364622, -0.374264, -0.00760659>,
                         <1.25211, -1.14477, -0.518641>, <-0.351269, -0.374264, 0.104764> }
        smooth_triangle {<1.88645, -1.72692, -0.781393>, <-0.531298, -0.479733, 0.166005>,
                         <2.24952, -2.53544, -0.931784>, <-0.760993, -0.32202, 0.251273>,
                         <2.43487, -2.53544, 2.98176e-16>, <-0.799224, -0.32202, -0.0590741> }
        smooth_triangle {<2.43487, -2.53544, 2.98176e-16>, <-0.757359, -0.318285, -0.0128891>,
                         <2.04188, -1.72692, 2.5005e-16>, <-0.573728, -0.43657, -0.00604657>,
                         <1.88645, -1.72692, -0.781393>, <-0.556415, -0.43657, 0.15592> }
        smooth_triangle {<2.24952, -2.53544, -0.931784>, <-0.760993, -0.32202, 0.251273>,
                         <2.4613, -3.40935, -1.0195>, <-0.869527, -0.216513, 0.291108>,
                         <2.66409, -3.40935, 3.26247e-16>, <-0.91474, -0.216513, -0.063805> }
        smooth_triangle {<2.66409, -3.40935, 3.26247e-16>, <-0.889629, -0.215782, -0.0073604>,
                         <2.43487, -2.53544, 2.98176e-16>, <-0.802992, -0.294912, -0.00381216>,
                         <2.24952, -2.53544, -0.931784>, <-0.774319, -0.294912, 0.228948> }
        smooth_triangle {<2.4613, -3.40935, -1.0195>, <-0.869527, -0.216513, 0.291108>,
                         <2.61657, -4.29724, -1.08382>, <-0.929448, -0.16349, 0.312489>,
                         <2.83215, -4.29724, 3.46827e-16>, <-0.978283, -0.16349, -0.0669825> }
        smooth_triangle {<2.83215, -4.29724, 3.46827e-16>, <-0.960013, -0.165452, -0.00522268>,
                         <2.66409, -3.40935, 3.26247e-16>, <-0.912357, -0.205219, -0.00283962>,
                         <2.4613, -3.40935, -1.0195>, <-0.878447, -0.205219, 0.263345> }
        smooth_triangle {<2.61657, -4.29724, -1.08382>, <-0.929448, -0.16349, 0.312489>,
                         <2.72003, -5.19388, -1.12668>, <-0.966635, -0.10242, 0.326241>,
                         <2.94414, -5.19388, 3.60542e-16>, <-1.0179, -0.10242, -0.0685083> }
        smooth_triangle {<2.94414, -5.19388, 3.60542e-16>, <-1.00638, -0.10716, -0.00305533>,
                         <2.83215, -4.29724, 3.46827e-16>, <-0.976663, -0.152962, -0.00191096>,
                         <2.61657, -4.29724, -1.08382>, <-0.940037, -0.152962, 0.282693> }
        smooth_triangle {<2.72003, -5.19388, -1.12668>, <-0.966635, -0.10242, 0.326241>,
                         <2.76433, -6.09626, -1.14502>, <-0.98224, -0.0396281, 0.332396>,
                         <2.99209, -6.09626, 3.66414e-16>, <-1.03467, -0.0396282, -0.0687929> }
        smooth_triangle {<2.99209, -6.09626, 3.66414e-16>, <-1.03018, -0.0432268, -0.00103681>,
                         <2.94414, -5.19388, 3.60542e-16>, <-1.0176, -0.0903211, -0.000823386>,
                         <2.72003, -5.19388, -1.12668>, <-0.979148, -0.090321, 0.295238> }
        smooth_triangle {<2.76433, -6.09626, -1.14502>, <-0.98224, -0.0396281, 0.332396>,
                         <2.77164, -7, -1.14805>, <-0.958557, -0.00907915, 0.397047>,
                         <3, -7, 3.67382e-16>, <-1.03754, -0.0090792, -1.80411e-16> }
        smooth_triangle {<3, -7, 3.67382e-16>, <-1.03662, -0.00907122, 0.0686115>,
                         <2.99209, -6.09626, 3.66414e-16>, <-1.03471, -0.0319849, -0.000136001>,
                         <2.76433, -6.09626, -1.14502>, <-0.99538, -0.0319849, 0.300756> }
        smooth_triangle {<2.12131, 6, -2.12132>, <-0.877138, 0.00949853, 0.586085>,
                         <2.11544, 5.09627, -2.11545>, <-0.86702, 0.0390859, 0.579324>,
                         <2.76396, 5.09627, -1.14487>, <-0.974192, 0.0292234, 0.330983> }
        smooth_triangle {<2.76396, 5.09627, -1.14487>, <-0.950537, 0.0242988, 0.395165>,
                         <2.77162, 6, -1.14805>, <-0.957113, 0.00951166, 0.396758>,
                         <2.12131, 6, -2.12132>, <-0.878354, 0.0095117, 0.586898> }
        smooth_triangle {<2.11544, 5.09627, -2.11545>, <-0.86702, 0.0390859, 0.579324>,
                         <2.07214, 4.19495, -2.07215>, <-0.823148, 0.129091, 0.55001>,
                         <2.70738, 4.19495, -1.12144>, <-0.932947, 0.108952, 0.319613> }
        smooth_triangle {<2.70738, 4.19495, -1.12144>, <-0.918412, 0.0992411, 0.385842>,
                         <2.76396, 5.09627, -1.14487>, <-0.949346, 0.0394446, 0.394369>,
                         <2.11544, 5.09627, -2.11545>, <-0.869616, 0.0494267, 0.581059> }
        smooth_triangle {<2.07214, 4.19495, -2.07215>, <-0.823148, 0.129091, 0.55001>,
                         <1.94483, 3.31027, -1.94483>, <-0.732895, 0.236077, 0.489705>,
                         <2.54104, 3.31027, -1.05254>, <-0.839471, 0.220554, 0.29046> }
        smooth_triangle {<2.54104, 3.31027, -1.05254>, <-0.839871, 0.215894, 0.358342>,
                         <2.70738, 4.19495, -1.12144>, <-0.909978, 0.132193, 0.380206>,
                         <2.07214, 4.19495, -2.07215>, <-0.829123, 0.153366, 0.554002> }
        smooth_triangle {<1.94483, 3.31027, -1.94483>, <-0.732895, 0.236077, 0.489705>,
                         <1.73156, 2.45886, -1.73156>, <-0.592249, 0.312204, 0.395728>,
                         <2.26239, 2.45886, -0.937114>, <-0.691202, 0.30235, 0.243291> }
        smooth_triangle {<2.26239, 2.45886, -0.937114>, <-0.708327, 0.306127, 0.309373>,
                         <2.54104, 3.31027, -1.05254>, <-0.819529, 0.24478, 0.344749>,
                         <1.94483, 3.31027, -1.94483>, <-0.741831, 0.263203, 0.495675> }
        smooth_triangle {<1.73156, 2.45886, -1.73156>, <-0.592249, 0.312204, 0.395728>,
                         <1.41627, 1.67691, -1.41627>, <-0.374718, 0.345201, 0.250379>,
                         <1.85044, 1.67691, -0.76648>, <-0.464042, 0.344055, 0.171782> }
        smooth_triangle {<1.85044, 1.67691, -0.76648>, <-0.503336, 0.362503, 0.232608>,
                         <2.26239, 2.45886, -0.937114>, <-0.673706, 0.331225, 0.28624>,
                         <1.73156, 2.45886, -1.73156>, <-0.601906, 0.347418, 0.402181> }
        smooth_triangle {<1.41627, 1.67691, -1.41627>, <-0.374718, 0.345201, 0.250379>,
                         <0.922462, 1.1067, -0.922467>, <-0.205305, 0.253956, 0.137181>,
                         <1.20526, 1.1067, -0.499236>, <-0.241893, 0.285517, 0.0858652> }
        smooth_triangle {<1.20526, 1.1067, -0.499236>, <-0.27405, 0.347954, 0.126292>,
                         <1.85044, 1.67691, -0.76648>, <-0.440661, 0.391858, 0.19073>,
                         <1.41627, 1.67691, -1.41627>, <-0.373319, 0.408556, 0.249443> }
        smooth_triangle {<0.922462, 1.1067, -0.922467>, <-0.205305, 0.253956, 0.137181>,
                         <0.529297, 0.409637, -0.529301>, <-0.194662, 0.076089, 0.130069>,
                         <0.691561, 0.409637, -0.286456>, <-0.209506, 0.103818, 0.0681522> }
        smooth_triangle {<0.691561, 0.409637, -0.286456>, <-0.230884, 0.14726, 0.100395>,
                         <1.20526, 1.1067, -0.499236>, <-0.255175, 0.283534, 0.11368>,
                         <0.922462, 1.1067, -0.922467>, <-0.23521, 0.261833, 0.157162> }
        smooth_triangle {<0.529297, 0.409637, -0.529301>, <-0.194662, 0.076089, 0.130069>,
                         <0.546272, -0.468323, -0.546276>, <-0.258733, -0.154661, 0.17288>,
                         <0.71374, -0.468323, -0.295642>, <-0.276813, -0.105473, 0.0894816> }
        smooth_triangle {<0.71374, -0.468323, -0.295642>, <-0.260912, -0.0808238, 0.102727>,
                         <0.691561, 0.409637, -0.286456>, <-0.210432, 0.0761441, 0.0867295>,
                         <0.529297, 0.409637, -0.529301>, <-0.200844, 0.0484338, 0.1342> }
        smooth_triangle {<0.546272, -0.468323, -0.546276>, <-0.258733, -0.154661, 0.17288>,
                         <0.95832, -1.14477, -0.958323>, <-0.341531, -0.419366, 0.228204>,
                         <1.25211, -1.14477, -0.518641>, <-0.367715, -0.380319, 0.119666> }
        smooth_triangle {<1.25211, -1.14477, -0.518641>, <-0.318171, -0.328309, 0.11807>,
                         <0.71374, -0.468323, -0.295642>, <-0.249995, -0.122174, 0.0954318>,
                         <0.546272, -0.468323, -0.546276>, <-0.229002, -0.160533, 0.153014> }
        smooth_triangle {<0.95832, -1.14477, -0.958323>, <-0.341531, -0.419366, 0.228204>,
                         <1.44382, -1.72692, -1.44383>, <-0.512154, -0.451345, 0.34221>,
                         <1.88645, -1.72692, -0.781393>, <-0.531298, -0.479733, 0.166005> }
        smooth_triangle {<1.88645, -1.72692, -0.781393>, <-0.462465, -0.448825, 0.167261>,
                         <1.25211, -1.14477, -0.518641>, <-0.339778, -0.374264, 0.132507>,
                         <0.95832, -1.14477, -0.958323>, <-0.313009, -0.398278, 0.209146> }
        smooth_triangle {<1.44382, -1.72692, -1.44383>, <-0.512154, -0.451345, 0.34221>,
                         <1.72171, -2.53544, -1.72171>, <-0.696991, -0.299939, 0.465715>,
                         <2.24952, -2.53544, -0.931784>, <-0.760993, -0.32202, 0.251273> }
        smooth_triangle {<2.24952, -2.53544, -0.931784>, <-0.704641, -0.318285, 0.277921>,
                         <1.88645, -1.72692, -0.781393>, <-0.53237, -0.43657, 0.21397>,
                         <1.44382, -1.72692, -1.44383>, <-0.519964, -0.403257, 0.347429> }
        smooth_triangle {<1.72171, -2.53544, -1.72171>, <-0.696991, -0.299939, 0.465715>,
                         <1.8838, -3.40935, -1.8838>, <-0.785561, -0.207921, 0.524895>,
                         <2.4613, -3.40935, -1.0195>, <-0.869527, -0.216513, 0.291108> }
        smooth_triangle {<2.4613, -3.40935, -1.0195>, <-0.824727, -0.215782, 0.333646>,
                         <2.24952, -2.53544, -0.931784>, <-0.743327, -0.294912, 0.30377>,
                         <1.72171, -2.53544, -1.72171>, <-0.69477, -0.271156, 0.46423> }
        smooth_triangle {<1.8838, -3.40935, -1.8838>, <-0.785561, -0.207921, 0.524895>,
                         <2.00263, -4.29724, -2.00263>, <-0.836119, -0.154162, 0.558677>,
                         <2.61657, -4.29724, -1.08382>, <-0.929448, -0.16349, 0.312489> }
        smooth_triangle {<2.61657, -4.29724, -1.08382>, <-0.888935, -0.165451, 0.362556>,
                         <2.4613, -3.40935, -1.0195>, <-0.843994, -0.205219, 0.34652>,
                         <1.8838, -3.40935, -1.8838>, <-0.779506, -0.195726, 0.520849> }
        smooth_triangle {<2.00263, -4.29724, -2.00263>, <-0.836119, -0.154162, 0.558677>,
                         <2.08182, -5.19388, -2.08182>, <-0.866187, -0.0905409, 0.578768>,
                         <2.72003, -5.19388, -1.12668>, <-0.966635, -0.10242, 0.326241> }
        smooth_triangle {<2.72003, -5.19388, -1.12668>, <-0.93094, -0.10716, 0.382301>,
                         <2.61657, -4.29724, -1.08382>, <-0.90305, -0.152962, 0.371987>,
                         <2.00263, -4.29724, -2.00263>, <-0.832031, -0.143235, 0.555945> }
        smooth_triangle {<2.08182, -5.19388, -2.08182>, <-0.866187, -0.0905409, 0.578768>,
                         <2.11573, -6.09626, -2.11573>, <-0.877761, -0.0319908, 0.586501>,
                         <2.76433, -6.09626, -1.14502>, <-0.98224, -0.0396281, 0.332396> }
        smooth_triangle {<2.76433, -6.09626, -1.14502>, <-0.952156, -0.0432268, 0.393274>,
                         <2.72003, -5.19388, -1.12668>, <-0.940453, -0.090321, 0.388657>,
                         <2.08182, -5.19388, -2.08182>, <-0.864759, -0.0783682, 0.577814> }
        smooth_triangle {<2.11573, -6.09626, -2.11573>, <-0.877761, -0.0319908, 0.586501>,
                         <2.12132, -7, -2.12132>, <-0.87958, -0.00907911, 0.587716>,
                         <2.77164, -7, -1.14805>, <-0.958557, -0.00907915, 0.397047> }
        smooth_triangle {<2.77164, -7, -1.14805>, <-0.931459, -0.00907116, 0.460087>,
                         <2.76433, -6.09626, -1.14502>, <-0.955995, -0.0319849, 0.395839>,
                         <2.11573, -6.09626, -2.11573>, <-0.877594, -0.0243456, 0.58639> }
        smooth_triangle {<1.14804, 6, -2.77163>, <-0.586085, 0.00949869, 0.877138>,
                         <1.14487, 5.09627, -2.76397>, <-0.454818, 0.0292237, 0.922898>,
                         <2.11544, 5.09627, -2.11545>, <-0.586085, 0.00949869, 0.877138> }
        smooth_triangle {<2.11544, 5.09627, -2.11545>, <-0.586898, 0.00951186, 0.878354>,
                         <2.12131, 6, -2.12132>, <-0.58771, 0.00952503, 0.87957>,
                         <1.14804, 6, -2.77163>, <-0.586898, 0.00951186, 0.878354> }
        smooth_triangle {<1.14487, 5.09627, -2.76397>, <-0.454818, 0.0292237, 0.922898>,
                         <1.12143, 4.19494, -2.70739>, <-0.433693, 0.108952, 0.885694>,
                         <2.07214, 4.19495, -2.07215>, <-0.572563, 0.0686735, 0.856901> }
        smooth_triangle {<2.07214, 4.19495, -2.07215>, <-0.578545, 0.069391, 0.865854>,
                         <2.11544, 5.09627, -2.11545>, <-0.585306, 0.0398036, 0.875973>,
                         <1.14487, 5.09627, -2.76397>, <-0.487245, 0.0394449, 0.910875> }
        smooth_triangle {<1.12143, 4.19494, -2.70739>, <-0.433693, 0.108952, 0.885694>,
                         <1.05253, 3.31027, -2.54105>, <-0.388209, 0.220554, 0.798982>,
                         <1.94483, 3.31027, -1.94483>, <-0.527457, 0.18951, 0.789396> }
        smooth_triangle {<1.94483, 3.31027, -1.94483>, <-0.544722, 0.195713, 0.815234>,
                         <2.07214, 4.19495, -2.07215>, <-0.567275, 0.135295, 0.848987>,
                         <1.12143, 4.19494, -2.70739>, <-0.465766, 0.132193, 0.874538> }
        smooth_triangle {<1.05253, 3.31027, -2.54105>, <-0.388209, 0.220554, 0.798982>,
                         <0.937109, 2.45886, -2.26239>, <-0.31672, 0.30235, 0.660786>,
                         <1.73156, 2.45886, -1.73156>, <-0.451952, 0.282644, 0.676394> }
        smooth_triangle {<1.73156, 2.45886, -1.73156>, <-0.479785, 0.30005, 0.718048>,
                         <1.94483, 3.31027, -1.94483>, <-0.517537, 0.253483, 0.774549>,
                         <1.05253, 3.31027, -2.54105>, <-0.418061, 0.24478, 0.789162> }
        smooth_triangle {<0.937109, 2.45886, -2.26239>, <-0.31672, 0.30235, 0.660786>,
                         <0.766475, 1.67691, -1.85045>, <-0.206659, 0.344055, 0.449596>,
                         <1.41627, 1.67691, -1.41627>, <-0.339505, 0.341764, 0.508105> }
        smooth_triangle {<1.41627, 1.67691, -1.41627>, <-0.377295, 0.379806, 0.564662>,
                         <1.73156, 2.45886, -1.73156>, <-0.433519, 0.350246, 0.648806>,
                         <0.937109, 2.45886, -2.26239>, <-0.341312, 0.331225, 0.650895> }
        smooth_triangle {<0.766475, 1.67691, -1.85045>, <-0.206659, 0.344055, 0.449596>,
                         <0.499231, 1.1067, -1.20526>, <-0.110329, 0.285517, 0.23176>,
                         <0.922462, 1.1067, -0.922467>, <-0.161253, 0.348638, 0.241332> }
        smooth_triangle {<0.922462, 1.1067, -0.922467>, <-0.204413, 0.441952, 0.305925>,
                         <1.41627, 1.67691, -1.41627>, <-0.293539, 0.438515, 0.439312>,
                         <0.766475, 1.67691, -1.85045>, <-0.216887, 0.391858, 0.429826> }
        smooth_triangle {<0.499231, 1.1067, -1.20526>, <-0.110329, 0.285517, 0.23176>,
                         <0.286452, 0.409637, -0.691566>, <-0.0999523, 0.103818, 0.196334>,
                         <0.529297, 0.409637, -0.529301>, <-0.113108, 0.159275, 0.169279> }
        smooth_triangle {<0.529297, 0.409637, -0.529301>, <-0.155117, 0.21843, 0.232149>,
                         <0.922462, 1.1067, -0.922467>, <-0.179189, 0.313111, 0.268175>,
                         <0.499231, 1.1067, -1.20526>, <-0.132028, 0.283534, 0.247575> }
        smooth_triangle {<0.286452, 0.409637, -0.691566>, <-0.0999523, 0.103818, 0.196334>,
                         <0.295639, -0.468323, -0.713744>, <-0.132463, -0.105473, 0.259009>,
                         <0.546272, -0.468323, -0.546276>, <-0.14703, -0.00709708, 0.220046> }
        smooth_triangle {<0.546272, -0.468323, -0.546276>, <-0.144746, -0.00698682, 0.216627>,
                         <0.529297, 0.409637, -0.529301>, <-0.127785, 0.0761993, 0.191244>,
                         <0.286452, 0.409637, -0.691566>, <-0.11058, 0.0761442, 0.200553> }
        smooth_triangle {<0.295639, -0.468323, -0.713744>, <-0.132463, -0.105473, 0.259009>,
                         <0.518638, -1.14477, -1.25211>, <-0.175397, -0.380319, 0.344631>,
                         <0.95832, -1.14477, -0.958323>, <-0.19873, -0.302224, 0.29742> }
        smooth_triangle {<0.95832, -1.14477, -0.958323>, <-0.156006, -0.237251, 0.23348>,
                         <0.546272, -0.468323, -0.546276>, <-0.130156, -0.0896874, 0.194793>,
                         <0.295639, -0.468323, -0.713744>, <-0.127668, -0.122174, 0.236642> }
        smooth_triangle {<0.518638, -1.14477, -1.25211>, <-0.175397, -0.380319, 0.344631>,
                         <0.78139, -1.72693, -1.88645>, <-0.258301, -0.479733, 0.493068>,
                         <1.44382, -1.72692, -1.44383>, <-0.257677, -0.536508, 0.385641> }
        smooth_triangle {<1.44382, -1.72692, -1.44383>, <-0.214354, -0.446305, 0.320803>,
                         <0.95832, -1.14477, -0.958323>, <-0.18488, -0.329163, 0.276693>,
                         <0.518638, -1.14477, -1.25211>, <-0.174305, -0.374264, 0.322464> }
        smooth_triangle {<0.78139, -1.72693, -1.88645>, <-0.258301, -0.479733, 0.493068>,
                         <0.931781, -2.53544, -2.24952>, <-0.360427, -0.32202, 0.71578>,
                         <1.72171, -2.53544, -1.72171>, <-0.426743, -0.366182, 0.638666> }
        smooth_triangle {<1.72171, -2.53544, -1.72171>, <-0.392305, -0.336631, 0.587126>,
                         <1.44382, -1.72692, -1.44383>, <-0.307772, -0.421794, 0.460613>,
                         <0.78139, -1.72693, -1.88645>, <-0.283193, -0.436569, 0.503697> }
        smooth_triangle {<0.931781, -2.53544, -2.24952>, <-0.360427, -0.32202, 0.71578>,
                         <1.0195, -3.40935, -2.4613>, <-0.409004, -0.216512, 0.820693>,
                         <1.8838, -3.40935, -1.8838>, <-0.504686, -0.233696, 0.755316> }
        smooth_triangle {<1.8838, -3.40935, -1.8838>, <-0.482974, -0.223642, 0.722821>,
                         <1.72171, -2.53544, -1.72171>, <-0.444002, -0.289885, 0.664497>,
                         <0.931781, -2.53544, -2.24952>, <-0.385636, -0.294912, 0.709417> }
        smooth_triangle {<1.0195, -3.40935, -2.4613>, <-0.409004, -0.216512, 0.820693>,
                         <1.08382, -4.29724, -2.61657>, <-0.436256, -0.163489, 0.878182>,
                         <2.00263, -4.29724, -2.00263>, <-0.545104, -0.182145, 0.815806> }
        smooth_triangle {<2.00263, -4.29724, -2.00263>, <-0.528931, -0.176741, 0.791601>,
                         <1.8838, -3.40935, -1.8838>, <-0.508722, -0.202516, 0.761356>,
                         <1.0195, -3.40935, -2.4613>, <-0.434942, -0.205218, 0.807369> }
        smooth_triangle {<1.08382, -4.29724, -2.61657>, <-0.436256, -0.163489, 0.878182>,
                         <1.12667, -5.19388, -2.72003>, <-0.452827, -0.10242, 0.914201>,
                         <2.08182, -5.19388, -2.08182>, <-0.57225, -0.126179, 0.856432> }
        smooth_triangle {<2.08182, -5.19388, -2.08182>, <-0.561366, -0.123779, 0.840143>,
                         <2.00263, -4.29724, -2.00263>, <-0.547793, -0.151762, 0.81983>,
                         <1.08382, -4.29724, -2.61657>, <-0.464813, -0.152962, 0.8646> }
        smooth_triangle {<1.12667, -5.19388, -2.72003>, <-0.452827, -0.10242, 0.914201>,
                         <1.14502, -6.09626, -2.76433>, <-0.459509, -0.0396279, 0.929588>,
                         <2.11573, -6.09626, -2.11573>, <-0.585285, -0.0549024, 0.875941> }
        smooth_triangle {<2.11573, -6.09626, -2.11573>, <-0.580596, -0.0544625, 0.868923>,
                         <2.08182, -5.19388, -2.08182>, <-0.574078, -0.0901009, 0.859168>,
                         <1.12667, -5.19388, -2.72003>, <-0.483597, -0.0903208, 0.901127> }
        smooth_triangle {<1.14502, -6.09626, -2.76433>, <-0.459509, -0.0396279, 0.929588>,
                         <1.14805, -7, -2.77164>, <-0.397047, -0.00907884, 0.958557>,
                         <2.12132, -7, -2.12132>, <-0.587716, -0.00907894, 0.87958> }
        smooth_triangle {<2.12132, -7, -2.12132>, <-0.586942, -0.00906698, 0.878421>,
                         <2.11573, -6.09626, -2.11573>, <-0.585726, -0.0319787, 0.876601>,
                         <1.14502, -6.09626, -2.76433>, <-0.491173, -0.0319846, 0.916506> }
        smooth_triangle {<-7.30159e-06, 6, -2.99999>, <-0.205806, 0.00949891, 1.03465>,
                         <-6.794e-06, 5.09627, -2.9917>, <-0.0670191, 0.0292239, 1.0267>,
                         <1.14487, 5.09627, -2.76397>, <-0.454818, 0.0292237, 0.922898> }
        smooth_triangle {<1.14487, 5.09627, -2.76397>, <-0.392707, 0.0242991, 0.951554>,
                         <1.14804, 6, -2.77163>, <-0.396231, 0.00951197, 0.957331>,
                         <-7.30159e-06, 6, -2.99999>, <-0.206091, 0.00951208, 1.03609> }
        smooth_triangle {<-6.794e-06, 5.09627, -2.9917>, <-0.0670191, 0.0292239, 1.0267>,
                         <-6.28776e-06, 4.19494, -2.93046>, <-0.0617395, 0.108952, 0.984241>,
                         <1.12143, 4.19494, -2.70739>, <-0.433693, 0.108952, 0.885694> }
        smooth_triangle {<1.12143, 4.19494, -2.70739>, <-0.376584, 0.0992414, 0.922247>,
                         <1.14487, 5.09627, -2.76397>, <-0.392428, 0.0394449, 0.95015>,
                         <-6.794e-06, 5.09627, -2.9917>, <-0.101579, 0.0394451, 1.028> }
        smooth_triangle {<-6.28776e-06, 4.19494, -2.93046>, <-0.0617395, 0.108952, 0.984241>,
                         <-5.79087e-06, 3.31027, -2.75041>, <-0.0529016, 0.220555, 0.886724>,
                         <1.05253, 3.31027, -2.54105>, <-0.388209, 0.220554, 0.798982> }
        smooth_triangle {<1.05253, 3.31027, -2.54105>, <-0.340493, 0.215895, 0.847264>,
                         <1.12143, 4.19494, -2.70739>, <-0.374605, 0.132193, 0.912298>,
                         <-6.28776e-06, 4.19494, -2.93046>, <-0.0956405, 0.132193, 0.986209> }
        smooth_triangle {<-5.79087e-06, 3.31027, -2.75041>, <-0.0529016, 0.220555, 0.886724>,
                         <-5.31267e-06, 2.45886, -2.4488>, <-0.0397396, 0.302351, 0.731691>,
                         <0.937109, 2.45886, -2.26239>, <-0.31672, 0.30235, 0.660786> }
        smooth_triangle {<0.937109, 2.45886, -2.26239>, <-0.282103, 0.306127, 0.719622>,
                         <1.05253, 3.31027, -2.54105>, <-0.33572, 0.24478, 0.823269>,
                         <-5.79087e-06, 3.31027, -2.75041>, <-0.0842391, 0.24478, 0.889076> }
        smooth_triangle {<-5.31267e-06, 2.45886, -2.4488>, <-0.0397396, 0.302351, 0.731691>,
                         <-4.87348e-06, 1.67691, -2.00291>, <-0.018875, 0.344055, 0.494457>,
                         <0.766475, 1.67691, -1.85045>, <-0.206659, 0.344055, 0.449596> }
        smooth_triangle {<0.766475, 1.67691, -1.85045>, <-0.191434, 0.362503, 0.520391>,
                         <0.937109, 2.45886, -2.26239>, <-0.27398, 0.331225, 0.678784>,
                         <-5.31267e-06, 2.45886, -2.4488>, <-0.0662444, 0.331225, 0.731962> }
        smooth_triangle {<-4.87348e-06, 1.67691, -2.00291>, <-0.018875, 0.344055, 0.494457>,
                         <-4.55321e-06, 1.1067, -1.30457>, <-0.0132396, 0.285517, 0.256339>,
                         <0.499231, 1.1067, -1.20526>, <-0.110329, 0.285517, 0.23176> }
        smooth_triangle {<0.499231, 1.1067, -1.20526>, <-0.104481, 0.347954, 0.283084>,
                         <0.766475, 1.67691, -1.85045>, <-0.176728, 0.391858, 0.446461>,
                         <-4.87348e-06, 1.67691, -2.00291>, <-0.0358903, 0.391858, 0.480107> }
        smooth_triangle {<-4.55321e-06, 1.1067, -1.30457>, <-0.0132396, 0.285517, 0.256339>,
                         <-4.1617e-06, 0.409637, -0.748545>, <-0.0172101, 0.103818, 0.219639>,
                         <0.286452, 0.409637, -0.691566>, <-0.0999523, 0.103818, 0.196334> }
        smooth_triangle {<0.286452, 0.409637, -0.691566>, <-0.0922696, 0.14726, 0.23425>,
                         <0.499231, 1.1067, -1.20526>, <-0.100052, 0.283534, 0.26082>,
                         <-4.55321e-06, 1.1067, -1.30457>, <-0.027235, 0.283534, 0.279254> }
        smooth_triangle {<-4.1617e-06, 0.409637, -0.748545>, <-0.0172101, 0.103818, 0.219639>,
                         <-3.66858e-06, -0.468323, -0.772551>, <-0.0232615, -0.105473, 0.289985>,
                         <0.295639, -0.468323, -0.713744>, <-0.132463, -0.105473, 0.259009> }
        smooth_triangle {<0.295639, -0.468323, -0.713744>, <-0.111854, -0.0808237, 0.257131>,
                         <0.286452, 0.409637, -0.691566>, <-0.0874707, 0.0761442, 0.210125>,
                         <-4.1617e-06, 0.409637, -0.748545>, <-0.025414, 0.0761442, 0.227604> }
        smooth_triangle {<-3.66858e-06, -0.468323, -0.772551>, <-0.0232615, -0.105473, 0.289985>,
                         <-3.28865e-06, -1.14477, -1.35527>, <-0.0301612, -0.380319, 0.385519>,
                         <0.518638, -1.14477, -1.25211>, <-0.175397, -0.380319, 0.344631> }
        smooth_triangle {<0.518638, -1.14477, -1.25211>, <-0.141493, -0.328308, 0.30847>,
                         <0.295639, -0.468323, -0.713744>, <-0.109292, -0.122174, 0.244253>,
                         <-3.66858e-06, -0.468323, -0.772551>, <-0.027391, -0.122174, 0.267485> }
        smooth_triangle {<-3.28865e-06, -1.14477, -1.35527>, <-0.0301612, -0.380319, 0.385519>,
                         <-2.96168e-06, -1.72693, -2.04188>, <-0.0499505, -0.479732, 0.554383>,
                         <0.78139, -1.72693, -1.88645>, <-0.258301, -0.479733, 0.493068> }
        smooth_triangle {<0.78139, -1.72693, -1.88645>, <-0.20874, -0.448825, 0.445284>,
                         <0.518638, -1.14477, -1.25211>, <-0.146562, -0.374264, 0.333956>,
                         <-3.28865e-06, -1.14477, -1.35527>, <-0.0376353, -0.374264, 0.364622> }
        smooth_triangle {<-2.96168e-06, -1.72693, -2.04188>, <-0.0499505, -0.479732, 0.554383>,
                         <-2.50757e-06, -2.53544, -2.43487>, <-0.0590739, -0.32202, 0.799224>,
                         <0.931781, -2.53544, -2.24952>, <-0.360427, -0.32202, 0.71578> }
        smooth_triangle {<0.931781, -2.53544, -2.24952>, <-0.301737, -0.318285, 0.694777>,
                         <0.78139, -1.72693, -1.88645>, <-0.225142, -0.436569, 0.527742>,
                         <-2.96168e-06, -1.72693, -2.04188>, <-0.0688793, -0.436569, 0.573728> }
        smooth_triangle {<-2.50757e-06, -2.53544, -2.43487>, <-0.0590739, -0.32202, 0.799224>,
                         <-2.01673e-06, -3.40935, -2.66409>, <-0.0638049, -0.216512, 0.91474>,
                         <1.0195, -3.40935, -2.4613>, <-0.409004, -0.216512, 0.820693> }
        smooth_triangle {<1.0195, -3.40935, -2.4613>, <-0.347246, -0.215781, 0.819094>,
                         <0.931781, -2.53544, -2.24952>, <-0.310814, -0.294912, 0.740409>,
                         <-2.50757e-06, -2.53544, -2.43487>, <-0.0847988, -0.294912, 0.802992> }
        smooth_triangle {<-2.01673e-06, -3.40935, -2.66409>, <-0.0638049, -0.216512, 0.91474>,
                         <-1.51804e-06, -4.29724, -2.83215>, <-0.0669824, -0.163489, 0.978283>,
                         <1.08382, -4.29724, -2.61657>, <-0.436256, -0.163489, 0.878182> }
        smooth_triangle {<1.08382, -4.29724, -2.61657>, <-0.372206, -0.165451, 0.884938>,
                         <1.0195, -3.40935, -2.4613>, <-0.351767, -0.205218, 0.841821>,
                         <-2.01673e-06, -3.40935, -2.66409>, <-0.0928678, -0.205218, 0.912357> }
        smooth_triangle {<-1.51804e-06, -4.29724, -2.83215>, <-0.0669824, -0.163489, 0.978283>,
                         <-1.01442e-06, -5.19388, -2.94414>, <-0.0685082, -0.10242, 1.0179>,
                         <1.12667, -5.19388, -2.72003>, <-0.452827, -0.10242, 0.914201> }
        smooth_triangle {<1.12667, -5.19388, -2.72003>, <-0.387946, -0.10716, 0.928602>,
                         <1.08382, -4.29724, -2.61657>, <-0.375518, -0.152962, 0.901587>,
                         <-1.51804e-06, -4.29724, -2.83215>, <-0.0985626, -0.152962, 0.976663> }
        smooth_triangle {<-1.01442e-06, -5.19388, -2.94414>, <-0.0685082, -0.10242, 1.0179>,
                         <-5.07594e-07, -6.09626, -2.99209>, <-0.0687928, -0.0396276, 1.03467>,
                         <1.14502, -6.09626, -2.76433>, <-0.459509, -0.0396279, 0.929588> }
        smooth_triangle {<1.14502, -6.09626, -2.76433>, <-0.395189, -0.0432265, 0.951363>,
                         <1.12667, -5.19388, -2.72003>, <-0.390178, -0.0903207, 0.939822>,
                         <-1.01442e-06, -5.19388, -2.94414>, <-0.101939, -0.0903205, 1.0176> }
        smooth_triangle {<-5.07594e-07, -6.09626, -2.99209>, <-0.0687928, -0.0396276, 1.03467>,
                         <-9.45836e-13, -7, -3>, <5.0991e-09, -0.00907861, 1.03754>,
                         <1.14805, -7, -2.77164>, <-0.397047, -0.00907884, 0.958557> }
        smooth_triangle {<1.14805, -7, -2.77164>, <-0.33331, -0.00907082, 0.983972>,
                         <1.14502, -6.09626, -2.76433>, <-0.39609, -0.0319846, 0.955891>,
                         <-5.07594e-07, -6.09626, -2.99209>, <-0.103053, -0.0319844, 1.03471> }
        smooth_triangle {<-1.14805, 6, -2.77163>, <0.205806, 0.00949914, 1.03465>,
                         <-1.14488, 5.09627, -2.76397>, <0.330983, 0.0292241, 0.974192>,
                         <-6.794e-06, 5.09627, -2.9917>, <-0.0670191, 0.0292239, 1.0267> }
        smooth_triangle {<-6.794e-06, 5.09627, -2.9917>, <0.00132973, 0.0242993, 1.0294>,
                         <-7.30159e-06, 6, -2.99999>, <0.00028538, 0.00951219, 1.03609>,
                         <-1.14805, 6, -2.77163>, <0.206091, 0.00951231, 1.03609> }
        smooth_triangle {<-1.14488, 5.09627, -2.76397>, <0.330983, 0.0292241, 0.974192>,
                         <-1.12144, 4.19494, -2.70739>, <0.319613, 0.108953, 0.932947>,
                         <-6.28776e-06, 4.19494, -2.93046>, <-0.0617395, 0.108952, 0.984241> }
        smooth_triangle {<-6.28776e-06, 4.19494, -2.93046>, <0.00501006, 0.0992416, 0.996157>,
                         <-6.794e-06, 5.09627, -2.9917>, <0.00105034, 0.0394452, 1.028>,
                         <-1.14488, 5.09627, -2.76397>, <0.299552, 0.0394453, 0.988621> }
        smooth_triangle {<-1.12144, 4.19494, -2.70739>, <0.319613, 0.108953, 0.932947>,
                         <-1.05254, 3.31026, -2.54105>, <0.29046, 0.220555, 0.839471>,
                         <-5.79087e-06, 3.31027, -2.75041>, <-0.0529016, 0.220555, 0.886724> }
        smooth_triangle {<-5.79087e-06, 3.31027, -2.75041>, <0.00965964, 0.215895, 0.913071>,
                         <-6.28776e-06, 4.19494, -2.93046>, <0.00303118, 0.132193, 0.986209>,
                         <-1.12144, 4.19494, -2.70739>, <0.289045, 0.132194, 0.947738> }
        smooth_triangle {<-1.05254, 3.31026, -2.54105>, <0.29046, 0.220555, 0.839471>,
                         <-0.937119, 2.45886, -2.26239>, <0.243291, 0.302351, 0.691202>,
                         <-5.31267e-06, 2.45886, -2.4488>, <-0.0397396, 0.302351, 0.731691> }
        smooth_triangle {<-5.31267e-06, 2.45886, -2.4488>, <0.0147582, 0.306127, 0.772801>,
                         <-5.79087e-06, 3.31027, -2.75041>, <0.00488665, 0.24478, 0.889076>,
                         <-1.05254, 3.31026, -2.54105>, <0.262408, 0.24478, 0.853636> }
        smooth_triangle {<-0.937119, 2.45886, -2.26239>, <0.243291, 0.302351, 0.691202>,
                         <-0.766485, 1.67691, -1.85045>, <0.171782, 0.344055, 0.464042>,
                         <-4.87348e-06, 1.67691, -2.00291>, <-0.018875, 0.344055, 0.494457> }
        smooth_triangle {<-4.87348e-06, 1.67691, -2.00291>, <0.0222833, 0.362503, 0.554037>,
                         <-5.31267e-06, 2.45886, -2.4488>, <0.00663491, 0.331225, 0.731962>,
                         <-0.937119, 2.45886, -2.26239>, <0.218908, 0.331225, 0.701596> }
        smooth_triangle {<-0.766485, 1.67691, -1.85045>, <0.171782, 0.344055, 0.464042>,
                         <-0.49924, 1.1067, -1.20526>, <0.085865, 0.285517, 0.241893>,
                         <-4.55321e-06, 1.1067, -1.30457>, <-0.0132396, 0.285517, 0.256339> }
        smooth_triangle {<-4.55321e-06, 1.1067, -1.30457>, <0.0118042, 0.347954, 0.301519>,
                         <-4.87348e-06, 1.67691, -2.00291>, <0.00757764, 0.391858, 0.480107>,
                         <-0.766485, 1.67691, -1.85045>, <0.150571, 0.391858, 0.457295> }
        smooth_triangle {<-0.49924, 1.1067, -1.20526>, <0.085865, 0.285517, 0.241893>,
                         <-0.28646, 0.409636, -0.691566>, <0.0681522, 0.103818, 0.209506>,
                         <-4.1617e-06, 0.409637, -0.748545>, <-0.0172101, 0.103818, 0.219639> }
        smooth_triangle {<-4.1617e-06, 0.409637, -0.748545>, <0.00439769, 0.14726, 0.251729>,
                         <-4.55321e-06, 1.1067, -1.30457>, <0.00737555, 0.283534, 0.279254>,
                         <-0.49924, 1.1067, -1.20526>, <0.081704, 0.283534, 0.268419> }
        smooth_triangle {<-0.28646, 0.409636, -0.691566>, <0.0681522, 0.103818, 0.209506>,
                         <-0.295646, -0.468323, -0.713744>, <0.0894817, -0.105473, 0.276813>,
                         <-3.66858e-06, -0.468323, -0.772551>, <-0.0232615, -0.105473, 0.289985> }
        smooth_triangle {<-3.66858e-06, -0.468323, -0.772551>, <-0.00493966, -0.0808236, 0.280363>,
                         <-4.1617e-06, 0.409637, -0.748545>, <-0.000401116, 0.0761442, 0.227604>,
                         <-0.28646, 0.409636, -0.691566>, <0.0636206, 0.0761443, 0.220004> }
        smooth_triangle {<-0.295646, -0.468323, -0.713744>, <0.0894817, -0.105473, 0.276813>,
                         <-0.518644, -1.14477, -1.25211>, <0.119666, -0.380319, 0.367715>,
                         <-3.28865e-06, -1.14477, -1.35527>, <-0.0301612, -0.380319, 0.385519> }
        smooth_triangle {<-3.28865e-06, -1.14477, -1.35527>, <-0.012676, -0.328308, 0.339136>,
                         <-3.66858e-06, -0.468323, -0.772551>, <-0.00750121, -0.122174, 0.267485>,
                         <-0.295646, -0.468323, -0.713744>, <0.0770562, -0.122174, 0.257606> }
        smooth_triangle {<-0.518644, -1.14477, -1.25211>, <0.119666, -0.380319, 0.367715>,
                         <-0.781396, -1.72693, -1.88645>, <0.166005, -0.479732, 0.531298>,
                         <-2.96168e-06, -1.72693, -2.04188>, <-0.0499505, -0.479732, 0.554383> }
        smooth_triangle {<-2.96168e-06, -1.72693, -2.04188>, <-0.0224483, -0.448825, 0.49127>,
                         <-3.28865e-06, -1.14477, -1.35527>, <-0.00760638, -0.374264, 0.364622>,
                         <-0.518644, -1.14477, -1.25211>, <0.104764, -0.374264, 0.351269> }
        smooth_triangle {<-0.781396, -1.72693, -1.88645>, <0.166005, -0.479732, 0.531298>,
                         <-0.931786, -2.53544, -2.24952>, <0.251273, -0.32202, 0.760994>,
                         <-2.50757e-06, -2.53544, -2.43487>, <-0.0590739, -0.32202, 0.799224> }
        smooth_triangle {<-2.50757e-06, -2.53544, -2.43487>, <-0.0128889, -0.318285, 0.75736>,
                         <-2.96168e-06, -1.72693, -2.04188>, <-0.00604633, -0.436569, 0.573728>,
                         <-0.781396, -1.72693, -1.88645>, <0.15592, -0.436569, 0.556415> }
        smooth_triangle {<-0.931786, -2.53544, -2.24952>, <0.251273, -0.32202, 0.760994>,
                         <-1.01951, -3.40935, -2.4613>, <0.291108, -0.216512, 0.869527>,
                         <-2.01673e-06, -3.40935, -2.66409>, <-0.0638049, -0.216512, 0.91474> }
        smooth_triangle {<-2.01673e-06, -3.40935, -2.66409>, <-0.00736027, -0.215781, 0.889629>,
                         <-2.50757e-06, -2.53544, -2.43487>, <-0.00381199, -0.294912, 0.802992>,
                         <-0.931786, -2.53544, -2.24952>, <0.228948, -0.294912, 0.774319> }
        smooth_triangle {<-1.01951, -3.40935, -2.4613>, <0.291108, -0.216512, 0.869527>,
                         <-1.08382, -4.29724, -2.61657>, <0.312489, -0.163489, 0.929449>,
                         <-1.51804e-06, -4.29724, -2.83215>, <-0.0669824, -0.163489, 0.978283> }
        smooth_triangle {<-1.51804e-06, -4.29724, -2.83215>, <-0.00522259, -0.165451, 0.960014>,
                         <-2.01673e-06, -3.40935, -2.66409>, <-0.0028395, -0.205218, 0.912357>,
                         <-1.01951, -3.40935, -2.4613>, <0.263345, -0.205218, 0.878447> }
        smooth_triangle {<-1.08382, -4.29724, -2.61657>, <0.312489, -0.163489, 0.929449>,
                         <-1.12668, -5.19389, -2.72003>, <0.326241, -0.10242, 0.966635>,
                         <-1.01442e-06, -5.19388, -2.94414>, <-0.0685082, -0.10242, 1.0179> }
        smooth_triangle {<-1.01442e-06, -5.19388, -2.94414>, <-0.00305527, -0.10716, 1.00638>,
                         <-1.51804e-06, -4.29724, -2.83215>, <-0.00191087, -0.152962, 0.976663>,
                         <-1.08382, -4.29724, -2.61657>, <0.282693, -0.152962, 0.940037> }
        smooth_triangle {<-1.12668, -5.19389, -2.72003>, <0.326241, -0.10242, 0.966635>,
                         <-1.14502, -6.09626, -2.76433>, <0.332396, -0.0396274, 0.98224>,
                         <-5.07594e-07, -6.09626, -2.99209>, <-0.0687928, -0.0396276, 1.03467> }
        smooth_triangle {<-5.07594e-07, -6.09626, -2.99209>, <-0.00103678, -0.0432263, 1.03018>,
                         <-1.01442e-06, -5.19388, -2.94414>, <-0.000823336, -0.0903205, 1.0176>,
                         <-1.12668, -5.19389, -2.72003>, <0.295238, -0.0903203, 0.979148> }
        smooth_triangle {<-1.14502, -6.09626, -2.76433>, <0.332396, -0.0396274, 0.98224>,
                         <-1.14805, -7, -2.77164>, <0.397047, -0.00907839, 0.958557>,
                         <-9.45836e-13, -7, -3>, <5.0991e-09, -0.00907861, 1.03754> }
        smooth_triangle {<-9.45836e-13, -7, -3>, <0.0686115, -0.0090706, 1.03662>,
                         <-5.07594e-07, -6.09626, -2.99209>, <-0.000135983, -0.0319844, 1.03471>,
                         <-1.14502, -6.09626, -2.76433>, <0.300756, -0.0319842, 0.99538> }
        smooth_triangle {<-2.12132, 6, -2.12132>, <0.586085, 0.00949935, 0.877138>,
                         <-2.11546, 5.09627, -2.11545>, <0.678595, 0.0292243, 0.773375>,
                         <-1.14488, 5.09627, -2.76397>, <0.330983, 0.0292241, 0.974192> }
        smooth_triangle {<-1.14488, 5.09627, -2.76397>, <0.395164, 0.0242995, 0.950537>,
                         <-1.14805, 6, -2.77163>, <0.396758, 0.00951242, 0.957113>,
                         <-2.12132, 6, -2.12132>, <0.586898, 0.00951252, 0.878354> }
        smooth_triangle {<-2.11546, 5.09627, -2.11545>, <0.678595, 0.0292243, 0.773375>,
                         <-2.07215, 4.19494, -2.07215>, <0.652307, 0.108953, 0.73962>,
                         <-1.12144, 4.19494, -2.70739>, <0.319613, 0.108953, 0.932947> }
        smooth_triangle {<-1.12144, 4.19494, -2.70739>, <0.385842, 0.0992418, 0.918412>,
                         <-1.14488, 5.09627, -2.76397>, <0.394369, 0.0394454, 0.949346>,
                         <-2.11546, 5.09627, -2.11545>, <0.655078, 0.0394455, 0.798733> }
        smooth_triangle {<-2.07215, 4.19494, -2.07215>, <0.652307, 0.108953, 0.73962>,
                         <-1.94484, 3.31026, -1.94483>, <0.589601, 0.220555, 0.664416>,
                         <-1.05254, 3.31026, -2.54105>, <0.29046, 0.220555, 0.839471> }
        smooth_triangle {<-1.05254, 3.31026, -2.54105>, <0.358342, 0.215895, 0.839871>,
                         <-1.12144, 4.19494, -2.70739>, <0.380206, 0.132194, 0.909978>,
                         <-2.07215, 4.19494, -2.07215>, <0.629727, 0.132194, 0.764983> }
        smooth_triangle {<-1.94484, 3.31026, -1.94483>, <0.589601, 0.220555, 0.664416>,
                         <-1.73157, 2.45886, -1.73156>, <0.489283, 0.302351, 0.545483>,
                         <-0.937119, 2.45886, -2.26239>, <0.243291, 0.302351, 0.691202> }
        smooth_triangle {<-0.937119, 2.45886, -2.26239>, <0.309373, 0.306127, 0.708327>,
                         <-1.05254, 3.31026, -2.54105>, <0.344749, 0.24478, 0.819529>,
                         <-1.94484, 3.31026, -1.94483>, <0.569105, 0.24478, 0.688237> }
        smooth_triangle {<-1.73157, 2.45886, -1.73156>, <0.489283, 0.302351, 0.545483>,
                         <-1.41628, 1.67691, -1.41627>, <0.336287, 0.344056, 0.36298>,
                         <-0.766485, 1.67691, -1.85045>, <0.171782, 0.344055, 0.464042> }
        smooth_triangle {<-0.766485, 1.67691, -1.85045>, <0.232608, 0.362504, 0.503336>,
                         <-0.937119, 2.45886, -2.26239>, <0.28624, 0.331225, 0.673706>,
                         <-1.73157, 2.45886, -1.73156>, <0.470734, 0.331225, 0.564417> }
        smooth_triangle {<-1.41628, 1.67691, -1.41627>, <0.336287, 0.344056, 0.36298>,
                         <-0.922472, 1.1067, -0.922467>, <0.171897, 0.285517, 0.190621>,
                         <-0.49924, 1.1067, -1.20526>, <0.085865, 0.285517, 0.241893> }
        smooth_triangle {<-0.49924, 1.1067, -1.20526>, <0.126292, 0.347954, 0.274049>,
                         <-0.766485, 1.67691, -1.85045>, <0.19073, 0.391858, 0.440661>,
                         <-1.41628, 1.67691, -1.41627>, <0.314108, 0.391858, 0.364865> }
        smooth_triangle {<-0.922472, 1.1067, -0.922467>, <0.171897, 0.285517, 0.190621>,
                         <-0.529306, 0.409636, -0.529301>, <0.143139, 0.103818, 0.167478>,
                         <-0.28646, 0.409636, -0.691566>, <0.0681522, 0.103818, 0.209506> }
        smooth_triangle {<-0.28646, 0.409636, -0.691566>, <0.100395, 0.14726, 0.230884>,
                         <-0.49924, 1.1067, -1.20526>, <0.11368, 0.283534, 0.255175>,
                         <-0.922472, 1.1067, -0.922467>, <0.178204, 0.283534, 0.21672> }
        smooth_triangle {<-0.529306, 0.409636, -0.529301>, <0.143139, 0.103818, 0.167478>,
                         <-0.546279, -0.468324, -0.546276>, <0.188602, -0.105473, 0.221499>,
                         <-0.295646, -0.468323, -0.713744>, <0.0894817, -0.105473, 0.276813> }
        smooth_triangle {<-0.295646, -0.468323, -0.713744>, <0.102727, -0.0808236, 0.260912>,
                         <-0.28646, 0.409636, -0.691566>, <0.0867295, 0.0761443, 0.210432>,
                         <-0.529306, 0.409636, -0.529301>, <0.14297, 0.0761443, 0.17891> }
        smooth_triangle {<-0.546279, -0.468324, -0.546276>, <0.188602, -0.105473, 0.221499>,
                         <-0.958327, -1.14477, -0.958323>, <0.251276, -0.380318, 0.293931>,
                         <-0.518644, -1.14477, -1.25211>, <0.119666, -0.380319, 0.367715> }
        smooth_triangle {<-0.518644, -1.14477, -1.25211>, <0.118071, -0.328308, 0.318171>,
                         <-0.295646, -0.468323, -0.713744>, <0.0954319, -0.122174, 0.249995>,
                         <-0.546279, -0.468324, -0.546276>, <0.169772, -0.122174, 0.208509> }
        smooth_triangle {<-0.958327, -1.14477, -0.958323>, <0.251276, -0.380318, 0.293931>,
                         <-1.44383, -1.72693, -1.44383>, <0.356688, -0.479732, 0.427328>,
                         <-0.781396, -1.72693, -1.88645>, <0.166005, -0.479732, 0.531298> }
        smooth_triangle {<-0.781396, -1.72693, -1.88645>, <0.167261, -0.448824, 0.462465>,
                         <-0.518644, -1.14477, -1.25211>, <0.132508, -0.374264, 0.339778>,
                         <-0.958327, -1.14477, -0.958323>, <0.231215, -0.374264, 0.284439> }
        smooth_triangle {<-1.44383, -1.72693, -1.44383>, <0.356688, -0.479732, 0.427328>,
                         <-1.72171, -2.53544, -1.72171>, <0.523365, -0.32202, 0.606909>,
                         <-0.931786, -2.53544, -2.24952>, <0.251273, -0.32202, 0.760994> }
        smooth_triangle {<-0.931786, -2.53544, -2.24952>, <0.277921, -0.318285, 0.704641>,
                         <-0.781396, -1.72693, -1.88645>, <0.21397, -0.436569, 0.53237>,
                         <-1.44383, -1.72693, -1.44383>, <0.356982, -0.436569, 0.454393> }
        smooth_triangle {<-1.72171, -2.53544, -1.72171>, <0.523365, -0.32202, 0.606909>,
                         <-1.8838, -3.40935, -1.8838>, <0.601702, -0.216512, 0.691936>,
                         <-1.01951, -3.40935, -2.4613>, <0.291108, -0.216512, 0.869527> }
        smooth_triangle {<-1.01951, -3.40935, -2.4613>, <0.333646, -0.215781, 0.824727>,
                         <-0.931786, -2.53544, -2.24952>, <0.30377, -0.294912, 0.743327>,
                         <-1.72171, -2.53544, -1.72171>, <0.507839, -0.294912, 0.627763> }
        smooth_triangle {<-1.8838, -3.40935, -1.8838>, <0.601702, -0.216512, 0.691936>,
                         <-2.00264, -4.29724, -2.00263>, <0.644387, -0.163489, 0.739114>,
                         <-1.08382, -4.29724, -2.61657>, <0.312489, -0.163489, 0.929449> }
        smooth_triangle {<-1.08382, -4.29724, -2.61657>, <0.362556, -0.165451, 0.888936>,
                         <-1.01951, -3.40935, -2.4613>, <0.34652, -0.205218, 0.843994>,
                         <-1.8838, -3.40935, -1.8838>, <0.579466, -0.205218, 0.710801> }
        smooth_triangle {<-2.00264, -4.29724, -2.00263>, <0.644387, -0.163489, 0.739114>,
                         <-2.08183, -5.19389, -2.08182>, <0.671323, -0.10242, 0.768208>,
                         <-1.12668, -5.19389, -2.72003>, <0.326241, -0.10242, 0.966635> }
        smooth_triangle {<-1.12668, -5.19389, -2.72003>, <0.382301, -0.107159, 0.93094>,
                         <-1.08382, -4.29724, -2.61657>, <0.371987, -0.152961, 0.90305>,
                         <-2.00264, -4.29724, -2.00263>, <0.620911, -0.152961, 0.760299> }
        smooth_triangle {<-2.08183, -5.19389, -2.08182>, <0.671323, -0.10242, 0.768208>,
                         <-2.11573, -6.09626, -2.11573>, <0.682981, -0.0396272, 0.780269>,
                         <-1.14502, -6.09626, -2.76433>, <0.332396, -0.0396274, 0.98224> }
        smooth_triangle {<-1.14502, -6.09626, -2.76433>, <0.393274, -0.043226, 0.952156>,
                         <-1.12668, -5.19389, -2.72003>, <0.388657, -0.0903203, 0.940453>,
                         <-2.08183, -5.19389, -2.08182>, <0.647468, -0.0903201, 0.791632> }
        smooth_triangle {<-2.11573, -6.09626, -2.11573>, <0.682981, -0.0396272, 0.780269>,
                         <-2.12132, -7, -2.12132>, <0.733648, -0.0090782, 0.733648>,
                         <-1.14805, -7, -2.77164>, <0.397047, -0.00907839, 0.958557> }
        smooth_triangle {<-1.14805, -7, -2.77164>, <0.460087, -0.00907038, 0.931459>,
                         <-1.14502, -6.09626, -2.76433>, <0.395839, -0.0319841, 0.955995>,
                         <-2.11573, -6.09626, -2.11573>, <0.658778, -0.031984, 0.804517> }
        smooth_triangle {<-2.77164, 6, -1.14805>, <0.877138, 0.00949951, 0.586085>,
                         <-2.76397, 5.09627, -1.14487>, <0.922898, 0.0292245, 0.454818>,
                         <-2.11546, 5.09627, -2.11545>, <0.678595, 0.0292243, 0.773375> }
        smooth_triangle {<-2.11546, 5.09627, -2.11545>, <0.728839, 0.0242997, 0.726959>,
                         <-2.12132, 6, -2.12132>, <0.732828, 0.0095126, 0.732424>,
                         <-2.77164, 6, -1.14805>, <0.878354, 0.00951269, 0.586898> }
        smooth_triangle {<-2.76397, 5.09627, -1.14487>, <0.922898, 0.0292245, 0.454818>,
                         <-2.7074, 4.19494, -1.12144>, <0.885693, 0.108953, 0.433693>,
                         <-2.07215, 4.19494, -2.07215>, <0.652307, 0.108953, 0.73962> }
        smooth_triangle {<-2.07215, 4.19494, -2.07215>, <0.707932, 0.099242, 0.700847>,
                         <-2.11546, 5.09627, -2.11545>, <0.727648, 0.0394456, 0.726163>,
                         <-2.76397, 5.09627, -1.14487>, <0.910875, 0.0394457, 0.487245> }
        smooth_triangle {<-2.7074, 4.19494, -1.12144>, <0.885693, 0.108953, 0.433693>,
                         <-2.54105, 3.31026, -1.05254>, <0.798982, 0.220555, 0.388209>,
                         <-1.94484, 3.31026, -1.94483>, <0.589601, 0.220555, 0.664416> }
        smooth_triangle {<-1.94484, 3.31026, -1.94483>, <0.652469, 0.215895, 0.638808>,
                         <-2.07215, 4.19494, -2.07215>, <0.699498, 0.132194, 0.695212>,
                         <-2.7074, 4.19494, -1.12144>, <0.874538, 0.132194, 0.465766> }
        smooth_triangle {<-2.54105, 3.31026, -1.05254>, <0.798982, 0.220555, 0.388209>,
                         <-2.2624, 2.45886, -0.937114>, <0.660786, 0.302351, 0.31672>,
                         <-1.73157, 2.45886, -1.73156>, <0.489283, 0.302351, 0.545483> }
        smooth_triangle {<-1.73157, 2.45886, -1.73156>, <0.556888, 0.306127, 0.536017>,
                         <-1.94484, 3.31026, -1.94483>, <0.632127, 0.24478, 0.625216>,
                         <-2.54105, 3.31026, -1.05254>, <0.789162, 0.24478, 0.418061> }
        smooth_triangle {<-2.2624, 2.45886, -0.937114>, <0.660786, 0.302351, 0.31672>,
                         <-1.85045, 1.67691, -0.76648>, <0.449595, 0.344056, 0.206659>,
                         <-1.41628, 1.67691, -1.41627>, <0.336287, 0.344056, 0.36298> }
        smooth_triangle {<-1.41628, 1.67691, -1.41627>, <0.40752, 0.362504, 0.376007>,
                         <-1.73157, 2.45886, -1.73156>, <0.522267, 0.331225, 0.512884>,
                         <-2.2624, 2.45886, -0.937114>, <0.650894, 0.331225, 0.341312> }
        smooth_triangle {<-1.85045, 1.67691, -0.76648>, <0.449595, 0.344056, 0.206659>,
                         <-1.20527, 1.1067, -0.499236>, <0.23176, 0.285517, 0.110328>,
                         <-0.922472, 1.1067, -0.922467>, <0.171897, 0.285517, 0.190621> }
        smooth_triangle {<-0.922472, 1.1067, -0.922467>, <0.221553, 0.347954, 0.204859>,
                         <-1.41628, 1.67691, -1.41627>, <0.344845, 0.391858, 0.334128>,
                         <-1.85045, 1.67691, -0.76648>, <0.429826, 0.391858, 0.216887> }
        smooth_triangle {<-1.20527, 1.1067, -0.499236>, <0.23176, 0.285517, 0.110328>,
                         <-0.69157, 0.409636, -0.286456>, <0.196334, 0.103818, 0.0999522>,
                         <-0.529306, 0.409636, -0.529301>, <0.143139, 0.103818, 0.167478> }
        smooth_triangle {<-0.529306, 0.409636, -0.529301>, <0.181109, 0.14726, 0.17489>,
                         <-0.922472, 1.1067, -0.922467>, <0.202678, 0.283534, 0.192247>,
                         <-1.20527, 1.1067, -0.499236>, <0.247575, 0.283534, 0.132028> }
        smooth_triangle {<-0.69157, 0.409636, -0.286456>, <0.196334, 0.103818, 0.0999522>,
                         <-0.713747, -0.468324, -0.295642>, <0.25901, -0.105473, 0.132463>,
                         <-0.546279, -0.468324, -0.546276>, <0.188602, -0.105473, 0.221499> }
        smooth_triangle {<-0.546279, -0.468324, -0.546276>, <0.194754, -0.0808235, 0.201739>,
                         <-0.529306, 0.409636, -0.529301>, <0.160656, 0.0761443, 0.161224>,
                         <-0.69157, 0.409636, -0.286456>, <0.200553, 0.0761444, 0.11058> }
        smooth_triangle {<-0.713747, -0.468324, -0.295642>, <0.25901, -0.105473, 0.132463>,
                         <-1.25211, -1.14477, -0.518641>, <0.344631, -0.380318, 0.175397>,
                         <-0.958327, -1.14477, -0.958323>, <0.251276, -0.380318, 0.293931> }
        smooth_triangle {<-0.958327, -1.14477, -0.958323>, <0.230842, -0.328308, 0.248769>,
                         <-0.546279, -0.468324, -0.546276>, <0.183836, -0.122174, 0.194445>,
                         <-0.713747, -0.468324, -0.295642>, <0.236642, -0.122174, 0.127668> }
        smooth_triangle {<-1.25211, -1.14477, -0.518641>, <0.344631, -0.380318, 0.175397>,
                         <-1.88645, -1.72693, -0.781393>, <0.493068, -0.479732, 0.258302>,
                         <-1.44383, -1.72693, -1.44383>, <0.356688, -0.479732, 0.427328> }
        smooth_triangle {<-1.44383, -1.72693, -1.44383>, <0.331507, -0.448824, 0.363254>,
                         <-0.958327, -1.14477, -0.958323>, <0.252448, -0.374264, 0.263206>,
                         <-1.25211, -1.14477, -0.518641>, <0.322465, -0.374264, 0.174306> }
        smooth_triangle {<-1.88645, -1.72693, -0.781393>, <0.493068, -0.479732, 0.258302>,
                         <-2.24953, -2.53544, -0.931784>, <0.71578, -0.322019, 0.360427>,
                         <-1.72171, -2.53544, -1.72171>, <0.523365, -0.32202, 0.606909> }
        smooth_triangle {<-1.72171, -2.53544, -1.72171>, <0.52642, -0.318284, 0.544648>,
                         <-1.44383, -1.72693, -1.44383>, <0.401412, -0.436569, 0.409963>,
                         <-1.88645, -1.72693, -0.781393>, <0.503697, -0.436569, 0.283193> }
        smooth_triangle {<-2.24953, -2.53544, -0.931784>, <0.71578, -0.322019, 0.360427>,
                         <-2.4613, -3.40935, -1.0195>, <0.820693, -0.216512, 0.409004>,
                         <-1.8838, -3.40935, -1.8838>, <0.601702, -0.216512, 0.691936> }
        smooth_triangle {<-1.8838, -3.40935, -1.8838>, <0.623858, -0.215781, 0.634267>,
                         <-1.72171, -2.53544, -1.72171>, <0.565106, -0.294912, 0.570497>,
                         <-2.24953, -2.53544, -0.931784>, <0.709417, -0.294912, 0.385636> }
        smooth_triangle {<-2.4613, -3.40935, -1.0195>, <0.820693, -0.216512, 0.409004>,
                         <-2.61657, -4.29724, -1.08382>, <0.878182, -0.163489, 0.436256>,
                         <-2.00264, -4.29724, -2.00263>, <0.644387, -0.163489, 0.739114> }
        smooth_triangle {<-2.00264, -4.29724, -2.00263>, <0.675139, -0.165451, 0.682525>,
                         <-1.8838, -3.40935, -1.8838>, <0.643126, -0.205218, 0.647142>,
                         <-2.4613, -3.40935, -1.0195>, <0.807369, -0.205218, 0.434943> }
        smooth_triangle {<-2.61657, -4.29724, -1.08382>, <0.878182, -0.163489, 0.436256>,
                         <-2.72004, -5.19389, -1.12668>, <0.914202, -0.102419, 0.452827>,
                         <-2.08183, -5.19389, -2.08182>, <0.671323, -0.10242, 0.768208> }
        smooth_triangle {<-2.08183, -5.19389, -2.08182>, <0.709456, -0.107159, 0.713776>,
                         <-2.00264, -4.29724, -2.00263>, <0.689254, -0.152961, 0.691956>,
                         <-2.61657, -4.29724, -1.08382>, <0.8646, -0.152961, 0.464813> }
        smooth_triangle {<-2.72004, -5.19389, -1.12668>, <0.914202, -0.102419, 0.452827>,
                         <-2.76433, -6.09626, -1.14502>, <0.929588, -0.0396271, 0.459509>,
                         <-2.11573, -6.09626, -2.11573>, <0.682981, -0.0396272, 0.780269> }
        smooth_triangle {<-2.11573, -6.09626, -2.11573>, <0.727712, -0.0432259, 0.729178>,
                         <-2.08183, -5.19389, -2.08182>, <0.718968, -0.0903201, 0.720132>,
                         <-2.72004, -5.19389, -1.12668>, <0.901127, -0.09032, 0.483597> }
        smooth_triangle {<-2.76433, -6.09626, -1.14502>, <0.929588, -0.0396271, 0.459509>,
                         <-2.77164, -7, -1.14805>, <0.958557, -0.00907808, 0.397047>,
                         <-2.12132, -7, -2.12132>, <0.733648, -0.0090782, 0.733648> }
        smooth_triangle {<-2.12132, -7, -2.12132>, <0.781519, -0.0090702, 0.684488>,
                         <-2.11573, -6.09626, -2.11573>, <0.731551, -0.031984, 0.731743>,
                         <-2.76433, -6.09626, -1.14502>, <0.916506, -0.0319839, 0.491173> }
        smooth_triangle {<-3, 6, 4.5943e-15>, <1.03465, 0.0094996, 0.205806>,
                         <-2.9917, 5.09627, 4.58159e-15>, <1.02272, 0.039087, 0.203432>,
                         <-2.76397, 5.09627, -1.14487>, <0.922898, 0.0292245, 0.454818> }
        smooth_triangle {<-2.76397, 5.09627, -1.14487>, <0.951554, 0.0242998, 0.392707>,
                         <-2.77164, 6, -1.14805>, <0.957331, 0.00951273, 0.396231>,
                         <-3, 6, 4.5943e-15>, <1.03609, 0.00951277, 0.206091> }
        smooth_triangle {<-2.9917, 5.09627, 4.58159e-15>, <1.02272, 0.039087, 0.203432>,
                         <-2.93046, 4.19494, 4.48781e-15>, <0.97097, 0.129092, 0.193138>,
                         <-2.7074, 4.19494, -1.12144>, <0.885693, 0.108953, 0.433693> }
        smooth_triangle {<-2.7074, 4.19494, -1.12144>, <0.922247, 0.0992421, 0.376584>,
                         <-2.76397, 5.09627, -1.14487>, <0.95015, 0.0394457, 0.392428>,
                         <-2.9917, 5.09627, 4.58159e-15>, <1.02578, 0.0494278, 0.204041> }
        smooth_triangle {<-2.93046, 4.19494, 4.48781e-15>, <0.97097, 0.129092, 0.193138>,
                         <-2.75041, 3.31026, 4.21207e-15>, <0.864508, 0.236077, 0.171961>,
                         <-2.54105, 3.31026, -1.05254>, <0.798982, 0.220555, 0.388209> }
        smooth_triangle {<-2.54105, 3.31026, -1.05254>, <0.847264, 0.215895, 0.340493>,
                         <-2.7074, 4.19494, -1.12144>, <0.912298, 0.132194, 0.374605>,
                         <-2.93046, 4.19494, 4.48781e-15>, <0.978017, 0.153367, 0.19454> }
        smooth_triangle {<-2.75041, 3.31026, 4.21207e-15>, <0.864508, 0.236077, 0.171961>,
                         <-2.4488, 2.45886, 3.75017e-15>, <0.698605, 0.312204, 0.138961>,
                         <-2.2624, 2.45886, -0.937114>, <0.660786, 0.302351, 0.31672> }
        smooth_triangle {<-2.2624, 2.45886, -0.937114>, <0.719622, 0.306127, 0.282103>,
                         <-2.54105, 3.31026, -1.05254>, <0.823269, 0.24478, 0.33572>,
                         <-2.75041, 3.31026, 4.21207e-15>, <0.875049, 0.263204, 0.174058> }
        smooth_triangle {<-2.4488, 2.45886, 3.75017e-15>, <0.698605, 0.312204, 0.138961>,
                         <-2.00291, 1.67691, 3.06733e-15>, <0.44201, 0.345201, 0.0879213>,
                         <-1.85045, 1.67691, -0.76648>, <0.449595, 0.344056, 0.206659> }
        smooth_triangle {<-1.85045, 1.67691, -0.76648>, <0.520391, 0.362504, 0.191434>,
                         <-2.2624, 2.45886, -0.937114>, <0.678784, 0.331225, 0.27398>,
                         <-2.4488, 2.45886, 3.75017e-15>, <0.709996, 0.347419, 0.141227> }
        smooth_triangle {<-2.00291, 1.67691, 3.06733e-15>, <0.44201, 0.345201, 0.0879213>,
                         <-1.30457, 1.1067, 1.99786e-15>, <0.242174, 0.253957, 0.0481714>,
                         <-1.20527, 1.1067, -0.499236>, <0.23176, 0.285517, 0.110328> }
        smooth_triangle {<-1.20527, 1.1067, -0.499236>, <0.283084, 0.347954, 0.10448>,
                         <-1.85045, 1.67691, -0.76648>, <0.446461, 0.391858, 0.176728>,
                         <-2.00291, 1.67691, 3.06733e-15>, <0.440359, 0.408556, 0.0875928> }
        smooth_triangle {<-1.30457, 1.1067, 1.99786e-15>, <0.242174, 0.253957, 0.0481714>,
                         <-0.748549, 0.409636, 1.14635e-15>, <0.22962, 0.0760892, 0.0456742>,
                         <-0.69157, 0.409636, -0.286456>, <0.196334, 0.103818, 0.0999522> }
        smooth_triangle {<-0.69157, 0.409636, -0.286456>, <0.23425, 0.14726, 0.0922695>,
                         <-1.20527, 1.1067, -0.499236>, <0.26082, 0.283534, 0.100052>,
                         <-1.30457, 1.1067, 1.99786e-15>, <0.277449, 0.261833, 0.055188> }
        smooth_triangle {<-0.748549, 0.409636, 1.14635e-15>, <0.22962, 0.0760892, 0.0456742>,
                         <-0.772554, -0.468324, 1.18311e-15>, <0.305197, -0.15466, 0.0607074>,
                         <-0.713747, -0.468324, -0.295642>, <0.25901, -0.105473, 0.132463> }
        smooth_triangle {<-0.713747, -0.468324, -0.295642>, <0.257131, -0.0808235, 0.111854>,
                         <-0.69157, 0.409636, -0.286456>, <0.210125, 0.0761444, 0.0874706>,
                         <-0.748549, 0.409636, 1.14635e-15>, <0.236912, 0.0484341, 0.0471248> }
        smooth_triangle {<-0.772554, -0.468324, 1.18311e-15>, <0.305197, -0.15466, 0.0607074>,
                         <-1.35528, -1.14477, 2.07551e-15>, <0.402863, -0.419366, 0.0801345>,
                         <-1.25211, -1.14477, -0.518641>, <0.344631, -0.380318, 0.175397> }
        smooth_triangle {<-1.25211, -1.14477, -0.518641>, <0.30847, -0.328308, 0.141493>,
                         <-0.713747, -0.468324, -0.295642>, <0.244253, -0.122174, 0.109292>,
                         <-0.772554, -0.468324, 1.18311e-15>, <0.270126, -0.160533, 0.0537314> }
        smooth_triangle {<-1.35528, -1.14477, 2.07551e-15>, <0.402863, -0.419366, 0.0801345>,
                         <-2.04188, -1.72693, 3.127e-15>, <0.604127, -0.451344, 0.120168>,
                         <-1.88645, -1.72693, -0.781393>, <0.493068, -0.479732, 0.258302> }
        smooth_triangle {<-1.88645, -1.72693, -0.781393>, <0.445284, -0.448824, 0.208741>,
                         <-1.25211, -1.14477, -0.518641>, <0.333956, -0.374264, 0.146562>,
                         <-1.35528, -1.14477, 2.07551e-15>, <0.369219, -0.398277, 0.0734423> }
        smooth_triangle {<-2.04188, -1.72693, 3.127e-15>, <0.604127, -0.451344, 0.120168>,
                         <-2.43487, -2.53544, 3.72884e-15>, <0.822157, -0.299938, 0.163537>,
                         <-2.24953, -2.53544, -0.931784>, <0.71578, -0.322019, 0.360427> }
        smooth_triangle {<-2.24953, -2.53544, -0.931784>, <0.694777, -0.318284, 0.301737>,
                         <-1.88645, -1.72693, -0.781393>, <0.527742, -0.436569, 0.225143>,
                         <-2.04188, -1.72693, 3.127e-15>, <0.61334, -0.403256, 0.122001> }
        smooth_triangle {<-2.43487, -2.53544, 3.72884e-15>, <0.822157, -0.299938, 0.163537>,
                         <-2.6641, -3.40935, 4.07989e-15>, <0.926633, -0.20792, 0.184319>,
                         <-2.4613, -3.40935, -1.0195>, <0.820693, -0.216512, 0.409004> }
        smooth_triangle {<-2.4613, -3.40935, -1.0195>, <0.819094, -0.215781, 0.347246>,
                         <-2.24953, -2.53544, -0.931784>, <0.740409, -0.294912, 0.310814>,
                         <-2.43487, -2.53544, 3.72884e-15>, <0.819537, -0.271155, 0.163016> }
        smooth_triangle {<-2.6641, -3.40935, 4.07989e-15>, <0.926633, -0.20792, 0.184319>,
                         <-2.83215, -4.29724, 4.33726e-15>, <0.98627, -0.154161, 0.196181>,
                         <-2.61657, -4.29724, -1.08382>, <0.878182, -0.163489, 0.436256> }
        smooth_triangle {<-2.61657, -4.29724, -1.08382>, <0.884938, -0.16545, 0.372206>,
                         <-2.4613, -3.40935, -1.0195>, <0.841821, -0.205218, 0.351767>,
                         <-2.6641, -3.40935, 4.07989e-15>, <0.91949, -0.195725, 0.182898> }
        smooth_triangle {<-2.83215, -4.29724, 4.33726e-15>, <0.98627, -0.154161, 0.196181>,
                         <-2.94414, -5.19389, 4.50877e-15>, <1.02174, -0.0905399, 0.203236>,
                         <-2.72004, -5.19389, -1.12668>, <0.914202, -0.102419, 0.452827> }
        smooth_triangle {<-2.72004, -5.19389, -1.12668>, <0.928602, -0.107159, 0.387947>,
                         <-2.61657, -4.29724, -1.08382>, <0.901588, -0.152961, 0.375518>,
                         <-2.83215, -4.29724, 4.33726e-15>, <0.981447, -0.143234, 0.195222> }
        smooth_triangle {<-2.94414, -5.19389, 4.50877e-15>, <1.02174, -0.0905399, 0.203236>,
                         <-2.99209, -6.09626, 4.5822e-15>, <1.03539, -0.0319898, 0.205952>,
                         <-2.76433, -6.09626, -1.14502>, <0.929588, -0.0396271, 0.459509> }
        smooth_triangle {<-2.76433, -6.09626, -1.14502>, <0.951363, -0.0432257, 0.395189>,
                         <-2.72004, -5.19389, -1.12668>, <0.939823, -0.09032, 0.390178>,
                         <-2.94414, -5.19389, 4.50877e-15>, <1.02005, -0.0783671, 0.202901> }
        smooth_triangle {<-2.99209, -6.09626, 4.5822e-15>, <1.03539, -0.0319898, 0.205952>,
                         <-3, -7, 4.59431e-15>, <1.03754, -0.00907803, 0.206379>,
                         <-2.77164, -7, -1.14805>, <0.958557, -0.00907808, 0.397047> }
        smooth_triangle {<-2.77164, -7, -1.14805>, <0.983972, -0.00907008, 0.33331>,
                         <-2.76433, -6.09626, -1.14502>, <0.955891, -0.0319838, 0.39609>,
                         <-2.99209, -6.09626, 4.5822e-15>, <1.03519, -0.0243445, 0.205913> }
        texture { Glass }
    }
    height_field { gif "clock1.gif"  water_level 0.001 smooth 
        texture { Plane_Black }
        scale <8, 0.5, 8>
        translate <-4, 6.24, -4>
    }
    disc { <0.0, 0.0, 0.0>, <0.0, 1.0, 0.0>, 4, 0 
        texture { Plane_White }
        translate <0, 6.5, 0>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 13, 0.0>, 0.25  
        texture { DMFWood4 }
        rotate <.0, 113.199, .0>
        translate <-1.37872, -7, -3.21701>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 13, 0.0>, 0.25  
        texture { DMFWood4 }
        rotate <.0, 246.371, .0>
        translate <-1.40287, -7, 3.20655>
    }
    cone { <0.0, 0.0, 0.0>, 0.25, <0.0, 13, 0.0>, 0.25  
        texture { DMFWood4 }
        translate <3.5, -7, 0>
    }
    cone { <0.0, 0.0, 0.0>, 4, <0.0, 0.25, 0.0>, 4  
        texture { DMFWood4 }
        translate <0, -7, 0>
    }
    cone { <0.0, 0.0, 0.0>, 4, <0.0, 0.25, 0.0>, 4  
        texture { DMFWood4 }
        translate <0, 6, 0>
    }
}
