//  POV-RAY 3.0 Scene File
//
//  Created : May 7th, 1996 
//  Author  : Bryan Garnett-Law
//  

global_settings { max_trace_level 5}


// *** CAMERA(S) ***


camera {  //  Wide-angle Camera
  location  <-47.664, 4.845, -15.684>
  direction <0.0,     0.0,  1.1547>
  sky       <0.0,     0.0,  1.0>  
  up        <0.0,     0.0,  1.0>  
  right     <1.3333,  0.0,  0.0>
  look_at   <-33.087, 27.823, -20.517>
}

// *** LIGHT SOURCES

light_source {   // mainlight
  <-20.689, 11.005, -2.201>
  color rgb <0.5, 0.5, 0.5>
}

light_source {   // lamp_light1
  <-4.489, 31.354, -11.878>
  color rgb <0.599, 0.599, 0.599>
}

light_source {   // lamp_light
  <-38.178, 31.354, -11.878>
  color rgb <0.599, 0.599, 0.599>
}


// *** INCLUDE FILES ***

#include "timeless.inc"

// *** OBJECT DEFINITIONS

box { // Ceiling
  <-1, -1, -1>, <1, 1, 1>
  texture {
    ceiling_tex
    scale <0.037146, 0.075405, 1.0>
  }
  scale <38.535458, 28.612289, 1.0>
  translate  <-23.729311, 7.667729, 0.969562>
}



union { // quilt
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.558578, -2.000000, -3.158941>, <-1.952591, -2.000000, -0.275273>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>,
      <-1.558578, -1.000000, -3.158941>, <-1.952591, -1.000000, -0.275273>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>,
      <-1.558578, 0.000000, -3.158941>, <-1.952591, 0.000000, -0.275273>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>,
      <-1.558578, 1.000000, -3.158941>, <-1.952591, 1.000000, -0.275273>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <1.982913, -2.000000, -0.262843>, <1.486665, -2.000000, -3.103151>,
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <1.982913, -1.000000, -0.262843>, <1.486665, -1.000000, -3.103151>,
      <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <1.982913, 0.000000, -0.262843>, <1.486665, 0.000000, -3.103151>,
      <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <1.982913, 1.000000, -0.262843>, <1.486665, 1.000000, -3.103151>
    }
  }
  texture {
    quilt_tex
    scale <3.228094, 2.988219, 1.0>
  translate <-1.657484, -1.988219, 0.000000>
  }
  scale <8.1, 4.760022, 1.0>
  translate  <-20.748787, 21.665628, -23.131064>
}


#declare lampshade_2 = difference {
  cone { // lampshade_bas2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.3, 3.3, 4.6>
    rotate <180.0, 0.0, 180.0>
    translate  1.3*z
  }
  cone { // lampshade_bas3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.27, 3.27, 4.6>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.001747, 0.000519, 1.242792>
  }
  translate  <-1.3, 7.0, 0.0>
}
#declare lampshade1 = difference {
  object { lampshade_2 }
  box { // lampshade_cut1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 2.2, 1.5>
    translate  <-1.3, 7.0, 0.9>
  }
  texture {
    lamp_tex
  }
  translate  3.52019*z
}
#declare lamp_stand1 = merge {
  cylinder { // lamp_base1
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 0.35>
    translate  <-1.3, 7.0, -5.449331>
  }
  cylinder { // stand_part3
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 16.75>
    translate  <-1.309796, 7.000892, -4.933658>
  }
  sphere { // stand_part4
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  <-1.297421, 7.001911, -5.094625>
  }
  texture {
    Dark_Wood1
  translate <-1.306770, 6.966925, -3.779070>
  }
  translate  -10.018385*z
}
union { // the_lamp1
  object { lampshade1 }
  object { lamp_stand1 }
  translate  <-3.191297, 24.352846, -14.202365>
}


#declare side1 = merge {
  sphere { // partend1
    <0,0,0>,1
    scale <0.568083, 0.487844, 0.251278>
    translate  3.997515*x
  }
  cylinder { // part1
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.25, 8.327144>
    rotate <-90.0, 0.0, 90.0>
    translate  4.029929*x
  }
}
#declare side2 = merge {
  sphere { // partend2
    <0,0,0>,1
    scale <0.568083, 0.487844, 0.251278>
    translate  3.997515*x
  }
  cylinder { // part2
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.25, 8.327144>
    rotate <-90.0, 0.0, 90.0>
    translate  4.029929*x
  }
  rotate 90.0*z
  translate  <4.056087, 4.28398, 0.0>
}
#declare side_half1 = union {
  object { side1 }
  object { side2 }
}
#declare side3 = merge {
  sphere { // partend3
    <0,0,0>,1
    scale <0.568083, 0.487844, 0.251278>
    translate  3.997515*x
  }
  cylinder { // part3
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.25, 8.327144>
    rotate <-90.0, 0.0, 90.0>
    translate  4.029929*x
  }
}
#declare side4 = merge {
  sphere { // partend4
    <0,0,0>,1
    scale <0.568083, 0.487844, 0.251278>
    translate  3.997515*x
  }
  cylinder { // part4
    <0,0,1>, <0,0,0>, 1
    scale <0.5, 0.25, 8.327144>
    rotate <-90.0, 0.0, 90.0>
    translate  4.029929*x
  }
  rotate 90.0*z
  translate  <4.056087, 4.28398, 0.0>
}
#declare side_half2 = union {
  object { side3 }
  object { side4 }
  rotate 180.0*z
  translate  <-0.235352, 8.342549, 0.0>
}
#declare sides = union {
  object { side_half1 }
  object { side_half2 }
  texture {
    mywood
  }
  scale <1.0, 1.0, 0.280164>
}
#declare bench = merge {
  object { sides }
  box { // benchtop
    <-1, -1, -1>, <1, 1, 1>
    scale <4.13636, 4.13636, 0.124663>
    translate  <-0.104545, 4.181813, 0.0>
  }
  texture {
    mywood
  }
  translate  <0.0, -2.430679, 1.803407>
}
#declare draw_recess = difference {
  box { // draws_cube
    <-1, -1, -1>, <1, 1, 1>
    scale <4.412849, 4.358938, 2.659104>
    translate  <-0.144219, 1.696908, -0.900376>
  }
  box { // draws_cube1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.71201, 4.305027, 2.16799>
    translate  <-0.144219, 0.996069, -0.900376>
  }
}
#declare draws_v1 = union {
  object { bench }
  object { draw_recess }
  texture {
    mywood
  }
  scale <1.629131, 0.814261, 1.787263>
}
#declare draw_simple1 = difference {
  box { // draw_base1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.927165, 2.164466, 1.0>
    translate  <-0.13432, 0.609881, 0.157402>
  }
  box { // draw_cavity1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.728305, 2.005129, 1.068102>
    translate  <-0.157402, 0.603582, 0.354803>
  }
  scale <0.644001, 1.0, 0.967636>
}
#declare draw_knob7 = merge {
  sphere { // draw_knob4
    <0,0,0>,1
    scale <0.226514, 0.116016, 0.226514>
    translate  <0.0, -1.567245, 0.185595>
  }
  sphere { // draw_knob5
    <0,0,0>,1
    scale <0.226514, 0.054151, 0.123406>
    translate  <0.0, -1.711597, 0.185595>
  }
  sphere { // draw_knob6
    <0,0,0>,1
    scale <0.298864, 0.113269, 0.298864>
    translate  <0.0, -1.87657, 0.164973>
  }
}
#declare draw1 = merge {
  object { draw_simple1 }
  object { draw_knob7 }
  texture {
    mywood
  }
  translate  <-3.62472, 0.0, -0.873816>
}
#declare draw_simple = difference {
  box { // draw_base
    <-1, -1, -1>, <1, 1, 1>
    scale <3.927165, 2.164466, 1.0>
    translate  <-0.13432, 0.609881, 0.157402>
  }
  box { // draw_cavity
    <-1, -1, -1>, <1, 1, 1>
    scale <3.728305, 2.005129, 1.068102>
    translate  <-0.157402, 0.603582, 0.354803>
  }
  scale <0.644001, 1.0, 0.967636>
}
#declare draw_knob = merge {
  sphere { // draw_knob1
    <0,0,0>,1
    scale <0.226514, 0.116016, 0.226514>
    translate  <0.0, -1.567245, 0.185595>
  }
  sphere { // draw_knob2
    <0,0,0>,1
    scale <0.226514, 0.054151, 0.123406>
    translate  <0.0, -1.711597, 0.185595>
  }
  sphere { // draw_knob3
    <0,0,0>,1
    scale <0.298864, 0.113269, 0.298864>
    translate  <0.0, -1.87657, 0.164973>
  }
}
#declare draw = merge {
  object { draw_simple }
  object { draw_knob }
  texture {
    mywood
  }
  translate  <-3.62472, 0.0, 1.132725>
}
#declare draw_simple2 = difference {
  box { // draw_base2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.927165, 2.164466, 1.0>
    translate  <-0.13432, 0.609881, 0.157402>
  }
  box { // draw_cavity2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.728305, 2.005129, 1.068102>
    translate  <-0.157402, 0.603582, 0.354803>
  }
  scale <0.644001, 1.0, 0.967636>
}
#declare draw_knob11 = merge {
  sphere { // draw_knob8
    <0,0,0>,1
    scale <0.226514, 0.116016, 0.226514>
    translate  <0.0, -1.567245, 0.185595>
  }
  sphere { // draw_knob9
    <0,0,0>,1
    scale <0.226514, 0.054151, 0.123406>
    translate  <0.0, -1.711597, 0.185595>
  }
  sphere { // draw_knob10
    <0,0,0>,1
    scale <0.298864, 0.113269, 0.298864>
    translate  <0.0, -1.87657, 0.164973>
  }
}
#declare draw2 = merge {
  object { draw_simple2 }
  object { draw_knob11 }
  texture {
    mywood
  }
  translate  <-3.62472, 0.0, -2.880358>
}
#declare draw_simple3 = difference {
  box { // draw_base3
    <-1, -1, -1>, <1, 1, 1>
    scale <3.927165, 2.164466, 1.0>
    translate  <-0.13432, 0.609881, 0.157402>
  }
  box { // draw_cavity3
    <-1, -1, -1>, <1, 1, 1>
    scale <3.728305, 2.005129, 1.068102>
    translate  <-0.157402, 0.603582, 0.354803>
  }
  scale <1.53, 1.0, 0.838182>
  translate  -0.032364*x
}
#declare draw_knob15 = merge {
  sphere { // draw_knob12
    <0,0,0>,1
    scale <0.226514, 0.116016, 0.226514>
    translate  <0.0, -1.567245, 0.185595>
  }
  sphere { // draw_knob13
    <0,0,0>,1
    scale <0.226514, 0.054151, 0.123406>
    translate  <0.0, -1.711597, 0.185595>
  }
  sphere { // draw_knob14
    <0,0,0>,1
    scale <0.298864, 0.113269, 0.298864>
    translate  <0.0, -1.87657, 0.164973>
  }
}
#declare draw3 = merge {
  object { draw_simple3 }
  object { draw_knob15 }
  texture {
    mywood
  }
  translate  -4.725081*z
}
#declare draws = union {
  object { draw1 }
  object { draw }
  object { draw2 }
  object { draw3 }
  translate  <0.0, -0.744936, -0.067721>
}
#declare draw_knob19 = merge {
  sphere { // draw_knob16
    <0,0,0>,1
    scale <0.226514, 0.116016, 0.226514>
    translate  <0.0, -1.567245, 0.185595>
  }
  sphere { // draw_knob17
    <0,0,0>,1
    scale <0.226514, 0.054151, 0.123406>
    translate  <0.0, -1.711597, 0.185595>
  }
  sphere { // draw_knob18
    <0,0,0>,1
    scale <0.298864, 0.113269, 0.298864>
    translate  <0.0, -1.87657, 0.164973>
  }
  translate  <-0.517817, -0.753928, -0.873816>
}
#declare door = merge {
  box { // draws_door
    <-1, -1, -1>, <1, 1, 1>
    scale <3.558604, 0.053986, 3.032884>
    translate  <2.459757, -2.232787, -0.734648>
  }
  object { draw_knob19 }
  translate  <0.003984, 0.011671, 0.099078>
}
#declare backshape = merge {
  box { // backboard1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      mywood
    }
    scale <6.67051, 0.408749, 2.0>
    translate  <-0.265805, 0.494512, 5.335492>
  }
  cylinder { // curve1
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 1.0>
    rotate -90.0*x
    translate  <-3.915629, 0.0, 7.217251>
  }
  cylinder { // curve2
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 1.0>
    rotate -90.0*x
    translate  <3.456452, 0.0, 7.217251>
  }
  cylinder { // curve3
    <0,0,1>, <0,0,0>, 1
    scale <5.228769, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.229588, 0.0, 8.331635>
  }
  translate  <0.0, 4.117608, -0.028997>
}
#declare mirror_board = intersection {
  box { // backboard
    <-1, -1, -1>, <1, 1, 1>
    texture {
      mywood
    }
    scale <6.67051, 0.291186, 4.0>
    translate  <-0.265805, 4.583122, 7.336301>
  }
  object { backshape }
}
#declare backshape1 = merge {
  box { // backboard3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      mywood
    }
    scale <6.67051, 0.408749, 2.0>
    translate  <-0.265805, 0.494512, 5.335492>
  }
  cylinder { // curve4
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 1.0>
    rotate -90.0*x
    translate  <-3.915629, 0.0, 7.217251>
  }
  cylinder { // curve5
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 1.0>
    rotate -90.0*x
    translate  <3.456452, 0.0, 7.217251>
  }
  cylinder { // curve6
    <0,0,1>, <0,0,0>, 1
    scale <5.228769, 3.0, 1.0>
    rotate -90.0*x
    translate  <-0.229588, 0.0, 8.331635>
  }
  translate  <0.0, 4.117608, -0.028997>
}
#declare mirror_board1 = intersection {
  box { // backboard2
    <-1, -1, -1>, <1, 1, 1>
    scale <6.67051, 0.291186, 4.0>
    translate  <-0.265805, 4.583122, 7.336301>
  }
  object { backshape1 }
  texture {
    Polished_Chro1
  }
  scale 0.8
  translate  <0.0, 0.822937, 1.374009>
}
#declare draws_mirror = difference {
  object { mirror_board }
  object { mirror_board1 }
}
union { // chest_of_draws
  object { draws_v1 }
  object { draws }
  box { // recess_base
    <-1, -1, -1>, <1, 1, 1>
    scale <3.75, 3.234807, 0.067731>
    translate  <2.589211, 1.065789, -3.718241>
  }
  object { door }
  object { draws_mirror }
  texture {
    mywood
  }
  translate  <-48.639522, 30.681638, -23.109688>
}


disc { // lace_cloth
  <0,0,0>, <0,0,1>, 1.0
  texture {
    lace
    scale <0.2, 0.2, 1.0>
  }
  scale <4.617066, 2.710775, 1.0>
  translate  <-46.873921, 31.666967, -19.660926>
}


#declare Picture_Frame = difference {
  box { // P_Frame_Base
    <-1, -1, -1>, <1, 1, 1>
    scale <6.984322, 0.368068, 4.52019>
    translate  <-20.866001, 34.282252, -9.856531>
  }
  box { // P_Frame_Base1
    <-1, -1, -1>, <1, 1, 1>
    scale <6.293098, 0.368068, 4.031247>
    translate  <-20.866001, 33.908168, -9.856531>
  }
  texture {
    DMFWood2
  }
}
#declare Picture = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>,
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>,
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>,
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    Pict_Texture
    scale <3.011751, 3.037262, 1.0>
    rotate <0.0, 0.0, -180.0>
  translate <1.008805, 0.989797, 0.000000>
  }
  scale <4.25, 2.75, 1.0>
  rotate -90.0*x
  translate  <-18.74237, 34.040147, -11.239774>
}
union { // Picture_n_Frame
  object { Picture_Frame }
  object { Picture }
}


#declare bedbb_cuts1 = union {
  cylinder { // bedbb_cut4
    <0,0,1>, <0,0,0>, 1
    scale 4.833457
    rotate -90.0*x
    translate  <-21.810099, 47.713908, -18.314864>
  }
  cylinder { // bedbb_cut5
    <0,0,1>, <0,0,0>, 1
    scale 4.833457
    rotate -90.0*x
    translate  <-15.475907, 47.713908, -16.236558>
  }
  cylinder { // bedbb_cut6
    <0,0,1>, <0,0,0>, 1
    scale 4.833457
    rotate -90.0*x
    translate  <-8.910371, 47.713908, -18.438716>
  }
  box { // bedbbcut5
    <-1, -1, -1>, <1, 1, 1>
    scale <10.970008, 0.654281, 5.998338>
    rotate 0.0*y
    translate  <-15.204031, 49.943973, -23.273379>
  }
  scale <1.2, 1.0, 0.531033>
  translate  <1.832887, -15.146397, -10.779962>
}
#declare bedboard1 = intersection {
  box { // bedboard_base1
    <-1, -1, -1>, <1, 1, 1>
    scale <13.16401, 0.654281, 4.751735>
    translate  <-16.411952, 34.797576, -21.572477>
  }
  object { bedbb_cuts1 }
  texture {
    mywood
  }
  scale <1.0, 1.0, 0.6>
  translate  <0.0, -25.580582, -10.5781>
}
#declare bedbb_cuts = union {
  cylinder { // bedbb_cut1
    <0,0,1>, <0,0,0>, 1
    scale 4.833457
    rotate -90.0*x
    translate  <-21.810099, 47.713908, -18.314864>
  }
  cylinder { // bedbb_cut2
    <0,0,1>, <0,0,0>, 1
    scale 4.833457
    rotate -90.0*x
    translate  <-15.475907, 47.713908, -16.236558>
  }
  cylinder { // bedbb_cut3
    <0,0,1>, <0,0,0>, 1
    scale 4.833457
    rotate -90.0*x
    translate  <-8.910371, 47.713908, -18.438716>
  }
  box { // bedbbcut4
    <-1, -1, -1>, <1, 1, 1>
    scale <10.970008, 0.654281, 5.998338>
    rotate 0.0*y
    translate  <-15.204031, 49.943973, -23.273379>
  }
  scale <1.2, 1.0, 0.531033>
  translate  <1.832887, -15.146397, -10.779962>
}
#declare bedboard = intersection {
  box { // bedboard_base
    <-1, -1, -1>, <1, 1, 1>
    scale <13.16401, 0.654281, 4.751735>
    translate  <-16.411952, 34.797576, -21.572477>
  }
  object { bedbb_cuts }
  texture {
    mywood
  }
}
#declare bedleg1 = merge {
  sphere { // bed_supp1
    <0,0,0>,1
    scale 0.75
    translate  <-28.578044, 9.126029, -27.683636>
  }
  sphere { // bed_supp2
    <0,0,0>,1
    scale <0.75, 0.75, 0.333214>
    translate  <-28.578044, 9.126029, -26.850064>
  }
  sphere { // bed_supp3
    <0,0,0>,1
    scale <0.75, 0.75, 0.333214>
    translate  <-28.578044, 9.126029, -28.435939>
  }
  texture {
    mywood
  }
  translate  <0.0, 0.090621, 0.226554>
}
#declare bedleg2 = merge {
  sphere { // bed_supp4
    <0,0,0>,1
    scale 0.75
    translate  <-28.578044, 9.126029, -27.683636>
  }
  sphere { // bed_supp5
    <0,0,0>,1
    scale <0.75, 0.75, 0.333214>
    translate  <-28.578044, 9.126029, -26.850064>
  }
  sphere { // bed_supp6
    <0,0,0>,1
    scale <0.75, 0.75, 0.333214>
    translate  <-28.578044, 9.126029, -28.435939>
  }
  texture {
    mywood
  }
  translate  <24.284919, 0.090621, 0.226554>
}
#declare bedleg3 = merge {
  sphere { // bed_supp7
    <0,0,0>,1
    scale 0.75
    translate  <-28.578044, 9.126029, -27.683636>
  }
  sphere { // bed_supp8
    <0,0,0>,1
    scale <0.75, 0.75, 0.333214>
    translate  <-28.578044, 9.126029, -26.850064>
  }
  sphere { // bed_supp9
    <0,0,0>,1
    scale <0.75, 0.75, 0.333214>
    translate  <-28.578044, 9.126029, -28.435939>
  }
  texture {
    mywood
  }
  translate  <0.0, 25.699188, 0.226554>
}
#declare bedleg4 = merge {
  sphere { // bed_supp10
    <0,0,0>,1
    scale 0.75
    translate  <-28.578044, 9.126029, -27.683636>
  }
  sphere { // bed_supp11
    <0,0,0>,1
    scale <0.75, 0.75, 0.333214>
    translate  <-28.578044, 9.126029, -26.850064>
  }
  sphere { // bed_supp12
    <0,0,0>,1
    scale <0.75, 0.75, 0.333214>
    translate  <-28.578044, 9.126029, -28.435939>
  }
  texture {
    mywood
  }
  translate  <24.284919, 25.699188, 0.226554>
}
#declare barebed = union {
  object { bedboard1 }
  object { bedboard }
  box { // bedbase
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver3
    }
    scale <11.770771, 12.443945, 0.31957>
    translate  <-16.366198, 22.047752, -25.035495>
  }
  object { bedleg1 }
  object { bedleg2 }
  object { bedleg3 }
  object { bedleg4 }
  box { // matress
    <-1, -1, -1>, <1, 1, 1>
    texture {
      bedspread_tex
    }
    scale <11.770771, 11.984691, 0.75>
    translate  <-16.366198, 22.047752, -23.933285>
  }
  translate  <-4.811145, 0.0, -1.006984>
}
#declare pillow1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.700768, 0.000000, 0.309245>, <-0.700768, -0.162855, 0.309245>, <-0.700339, -0.296101, 0.308947>, <-0.699814, -0.296101, 0.308583>,
      <-0.486032, 0.000000, 0.472036>, <-0.486032, -0.255155, 0.472036>, <-0.485603, -0.463918, 0.393247>, <-0.485078, -0.463918, 0.296950>,
      <0.457902, 0.000000, 0.463333>, <0.457902, -0.255155, 0.463333>, <0.458332, -0.463918, 0.384544>, <0.458856, -0.463918, 0.288247>,
      <0.628710, 0.000000, 0.290629>, <0.628710, -0.170103, 0.290629>, <0.629140, -0.309278, 0.290509>, <0.629665, -0.309278, 0.290362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.699814, -0.296101, 0.308583>, <-0.699289, -0.296101, 0.308219>, <-0.698860, -0.162855, 0.307921>, <-0.698860, 0.000000, 0.307921>,
      <-0.485078, -0.463918, 0.296950>, <-0.484553, -0.463918, 0.200652>, <-0.484124, -0.255155, 0.121864>, <-0.484124, 0.000000, 0.121864>,
      <0.458856, -0.463918, 0.288247>, <0.459381, -0.463918, 0.191950>, <0.459811, -0.255155, 0.113161>, <0.459811, 0.000000, 0.113161>,
      <0.629665, -0.309278, 0.290362>, <0.630189, -0.309278, 0.290215>, <0.630619, -0.170103, 0.290095>, <0.630619, 0.000000, 0.290095>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.698860, 0.000000, 0.307921>, <-0.698860, 0.162855, 0.307921>, <-0.699289, 0.296101, 0.308219>, <-0.699814, 0.296101, 0.308583>,
      <-0.484124, 0.000000, 0.121864>, <-0.484124, 0.255155, 0.121864>, <-0.484553, 0.463918, 0.200652>, <-0.485078, 0.463918, 0.296950>,
      <0.459811, 0.000000, 0.113161>, <0.459811, 0.255155, 0.113161>, <0.459381, 0.463918, 0.191950>, <0.458856, 0.463918, 0.288247>,
      <0.630619, 0.000000, 0.290095>, <0.630619, 0.170103, 0.290095>, <0.630189, 0.309278, 0.290215>, <0.629665, 0.309278, 0.290362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.699814, 0.296101, 0.308583>, <-0.700339, 0.296101, 0.308947>, <-0.700768, 0.162855, 0.309245>, <-0.700768, 0.000000, 0.309245>,
      <-0.485078, 0.463918, 0.296950>, <-0.485603, 0.463918, 0.393247>, <-0.486032, 0.255155, 0.472036>, <-0.486032, 0.000000, 0.472036>,
      <0.458856, 0.463918, 0.288247>, <0.458332, 0.463918, 0.384544>, <0.457902, 0.255155, 0.463333>, <0.457902, 0.000000, 0.463333>,
      <0.629665, 0.309278, 0.290362>, <0.629140, 0.309278, 0.290509>, <0.628710, 0.170103, 0.290629>, <0.628710, 0.000000, 0.290629>
    }
  }
  texture {
    bedspread_tex
  }
  scale <6.30088, 6.799787, 7.0>
  translate  <-27.018154, 30.496418, -25.296551>
}
#declare pillow2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.700768, 0.000000, 0.309245>, <-0.700768, -0.162855, 0.309245>, <-0.700339, -0.296101, 0.308947>, <-0.699814, -0.296101, 0.308583>,
      <-0.486032, 0.000000, 0.472036>, <-0.486032, -0.255155, 0.472036>, <-0.485603, -0.463918, 0.393247>, <-0.485078, -0.463918, 0.296950>,
      <0.457902, 0.000000, 0.463333>, <0.457902, -0.255155, 0.463333>, <0.458332, -0.463918, 0.384544>, <0.458856, -0.463918, 0.288247>,
      <0.628710, 0.000000, 0.290629>, <0.628710, -0.170103, 0.290629>, <0.629140, -0.309278, 0.290509>, <0.629665, -0.309278, 0.290362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.699814, -0.296101, 0.308583>, <-0.699289, -0.296101, 0.308219>, <-0.698860, -0.162855, 0.307921>, <-0.698860, 0.000000, 0.307921>,
      <-0.485078, -0.463918, 0.296950>, <-0.484553, -0.463918, 0.200652>, <-0.484124, -0.255155, 0.121864>, <-0.484124, 0.000000, 0.121864>,
      <0.458856, -0.463918, 0.288247>, <0.459381, -0.463918, 0.191950>, <0.459811, -0.255155, 0.113161>, <0.459811, 0.000000, 0.113161>,
      <0.629665, -0.309278, 0.290362>, <0.630189, -0.309278, 0.290215>, <0.630619, -0.170103, 0.290095>, <0.630619, 0.000000, 0.290095>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.698860, 0.000000, 0.307921>, <-0.698860, 0.162855, 0.307921>, <-0.699289, 0.296101, 0.308219>, <-0.699814, 0.296101, 0.308583>,
      <-0.484124, 0.000000, 0.121864>, <-0.484124, 0.255155, 0.121864>, <-0.484553, 0.463918, 0.200652>, <-0.485078, 0.463918, 0.296950>,
      <0.459811, 0.000000, 0.113161>, <0.459811, 0.255155, 0.113161>, <0.459381, 0.463918, 0.191950>, <0.458856, 0.463918, 0.288247>,
      <0.630619, 0.000000, 0.290095>, <0.630619, 0.170103, 0.290095>, <0.630189, 0.309278, 0.290215>, <0.629665, 0.309278, 0.290362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.699814, 0.296101, 0.308583>, <-0.700339, 0.296101, 0.308947>, <-0.700768, 0.162855, 0.309245>, <-0.700768, 0.000000, 0.309245>,
      <-0.485078, 0.463918, 0.296950>, <-0.485603, 0.463918, 0.393247>, <-0.486032, 0.255155, 0.472036>, <-0.486032, 0.000000, 0.472036>,
      <0.458856, 0.463918, 0.288247>, <0.458332, 0.463918, 0.384544>, <0.457902, 0.255155, 0.463333>, <0.457902, 0.000000, 0.463333>,
      <0.629665, 0.309278, 0.290362>, <0.629140, 0.309278, 0.290509>, <0.628710, 0.170103, 0.290629>, <0.628710, 0.000000, 0.290629>
    }
  }
  texture {
    bedspread_tex
  }
  scale <6.30088, 6.799787, 7.0>
  translate  <-14.716358, 30.496418, -25.296551>
}
union { // Bed_Object
  object { barebed }
  object { pillow1 }
  object { pillow2 }
}


box { // The_Floor
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Dark_Wood2
    scale <0.037146, 0.075405, 1.0>
  }
  scale <38.535458, 28.612289, 1.0>
  translate  <-23.729311, 7.667729, -30.776848>
}


#declare halfwall = union {
  box { // backwall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      wall_texture
    }
    scale <40.0, 1.0, 15.0>
    translate  <-23.556504, 36.883287, -14.672636>
  }
  box { // backwall1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      wall_texture
    }
    scale <30.0, 1.0, 15.0>
    rotate -90.0*z
    translate  <15.319712, 7.937408, -14.672636>
  }
}
#declare doorcut = difference {
  box { // backwall2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      wall_texture
    }
    scale <40.0, 1.0, 15.0>
    rotate 180.0*z
    translate  <-23.692584, -20.920757, -14.672636>
  }
  box { // entry
    <-1, -1, -1>, <1, 1, 1>
    texture {
      wall_texture
    }
    scale <10.0, 1.647934, 11.690906>
    translate  <-43.144202, -21.057844, -18.142142>
  }
  rotate -180.0*z
  translate  <-47.249088, 15.96253, 0.0>
}
#declare halfwall1 = union {
  object { doorcut }
  box { // backwall3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      wall_texture
    }
    scale <30.0, 1.0, 15.0>
    rotate -90.0*z
    translate  <15.319712, 7.937408, -14.672636>
  }
  rotate 180.0*z
  translate  <-47.249088, 15.96253, 0.0>
}
merge { // walls
  object { halfwall }
  object { halfwall1 }
}


#declare hand_end3 = difference {
  box { // end_base4
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
  }
  box { // end_base5
    <-1, -1, -1>, <1, 1, 1>
    scale <2.21826, 1.0, 1.2>
    translate  -0.937123*y
  }
  translate  3.842205*y
}
#declare hand_end4 = difference {
  box { // end_base6
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
  }
  box { // end_base7
    <-1, -1, -1>, <1, 1, 1>
    scale <2.21826, 1.0, 1.2>
    translate  -0.937123*y
  }
  scale <1.0, 1.0, 1.1>
  translate  3.61106*y
}
#declare end_part4 = difference {
  object { hand_end3 }
  object { hand_end4 }
  scale <1.0, 1.0, 0.1>
  translate  1.585773*z
}
#declare end_slats1 = union {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.1, 0.075>
    translate  <0.0, 4.732867, 1.585773>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.1, 0.075>
    translate  <0.0, 4.38963, 1.585773>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.075, 0.1, 0.075>
    translate  <0.0, 4.072892, 1.585773>
  }
}
#declare end_part5 = merge {
  object { end_part4 }
  object { end_slats1 }
  texture {
    Polished_Bras1
  }
  translate  0.090987*z
}
#declare left_arm2 = difference {
  cylinder { // arm_l5
    <0,0,1>, <0,0,0>, 1
    scale <0.722626, 2.155725, 1.0>
    rotate 12.964602*z
    translate  <-0.919492, 1.741438, 0.0>
  }
  cylinder { // arm_l6
    <0,0,1>, <0,0,0>, 1
    scale <0.714962, 2.187404, 1.1>
    rotate 12.964602*z
    translate  <-1.055424, 1.653031, -0.025648>
  }
  translate  <0.131182, 0.131182, 0.0>
}
#declare right_arm2 = difference {
  cylinder { // arm_l7
    <0,0,1>, <0,0,0>, 1
    scale <0.722626, 2.155725, 1.0>
    rotate -12.964602*z
    translate  <-0.919492, 1.741438, 0.0>
  }
  cylinder { // arm_l8
    <0,0,1>, <0,0,0>, 1
    scale <0.714962, 2.187404, 1.1>
    rotate -12.964602*z
    translate  <-0.79306, 1.653031, -0.025648>
  }
  translate  <1.705365, 0.131182, 0.0>
}
#declare arms1 = union {
  object { left_arm2 }
  object { right_arm2 }
  texture {
    Polished_Bras1
  }
  scale <1.0, 1.0, 0.1>
  translate  1.628669*z
}
#declare min_hand = union {
  object { end_part5 }
  object { arms1 }
  texture {
    Tom_Wood1
  }
  rotate 168.000015*z
}
#declare hand_end1 = difference {
  box { // end_base
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
  }
  box { // end_base1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.21826, 1.0, 1.2>
    translate  -0.937123*y
  }
  translate  3.842205*y
}
#declare hand_end2 = difference {
  box { // end_base2
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
  }
  box { // end_base3
    <-1, -1, -1>, <1, 1, 1>
    scale <2.21826, 1.0, 1.2>
    translate  -0.937123*y
  }
  scale <1.0, 1.0, 1.1>
  translate  3.61106*y
}
#declare end_part2 = difference {
  object { hand_end1 }
  object { hand_end2 }
  scale <1.0, 1.0, 0.1>
  translate  1.585773*z
}
#declare end_slats = union {
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 0.1, 0.075>
    translate  <0.0, 4.732867, 1.585773>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 0.1, 0.075>
    translate  <0.0, 4.38963, 1.585773>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.075, 0.1, 0.075>
    translate  <0.0, 4.072892, 1.585773>
  }
}
#declare end_part3 = merge {
  object { end_part2 }
  object { end_slats }
  translate  <0.0, -1.021406, 0.090987>
}
#declare left_arm1 = difference {
  cylinder { // arm_l1
    <0,0,1>, <0,0,0>, 1
    scale <0.722626, 2.155725, 1.0>
    rotate 12.964602*z
    translate  <-0.919492, 1.741438, 0.0>
  }
  cylinder { // arm_l2
    <0,0,1>, <0,0,0>, 1
    scale <0.714962, 2.187404, 1.1>
    rotate 12.964602*z
    translate  <-1.055424, 1.653031, -0.025648>
  }
  translate  <0.131182, 0.131182, 0.0>
}
#declare right_arm1 = difference {
  cylinder { // arm_l3
    <0,0,1>, <0,0,0>, 1
    scale <0.722626, 2.155725, 1.0>
    rotate -12.964602*z
    translate  <-0.919492, 1.741438, 0.0>
  }
  cylinder { // arm_l4
    <0,0,1>, <0,0,0>, 1
    scale <0.714962, 2.187404, 1.1>
    rotate -12.964602*z
    translate  <-0.79306, 1.653031, -0.025648>
  }
  translate  <1.705365, 0.131182, 0.0>
}
#declare arms = union {
  object { left_arm1 }
  object { right_arm1 }
  scale <1.0, 0.75, 0.1>
  translate  1.628669*z
}
#declare hour_hand = union {
  object { end_part3 }
  object { arms }
  texture {
    DMFLightOak1
  }
  rotate -1.86*z
  translate  <0.0, 0.0, -0.290367>
}
#declare Font_X1 = merge {
  box { // X_bar3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 4.0, 1.0>
    rotate -45.0*z
  }
  box { // X_bar4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 4.0, 1.0>
    rotate 45.0*z
  }
  box { // X_serif5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <-2.621577, 2.828674, 0.0>
  }
  box { // X_serif6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <2.623972, 2.828674, 0.0>
  }
  box { // X_serif7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <-2.621577, -2.81214, 0.0>
  }
  box { // X_serif8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <2.623972, -2.81214, 0.0>
  }
  scale 0.15
  translate  <-0.503532, 6.508712, 0.0>
}
#declare Font_I6 = merge {
  box { // I_Base6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.2, 1.0>
    translate  0.226209*y
  }
  box { // I_Serif13
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  3.073321*y
  }
  box { // I_Serif14
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  -2.553041*y
  }
  scale 0.15
  translate  <0.30197, 6.471219, 0.0>
}
#declare number9 = union {
  object { Font_X1 }
  object { Font_I6 }
  texture {
    DMFWood2
  }
  rotate 180.0*z
  translate  <-6.320662, 6.52214, 0.907772>
}
#declare Font_I5 = merge {
  box { // I_Base5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.2, 1.0>
    translate  0.226209*y
  }
  box { // I_Serif11
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  3.073321*y
  }
  box { // I_Serif12
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  -2.553041*y
  }
  scale 0.15
  translate  <0.56393, -6.474606, 0.907772>
}
#declare Font_V1 = merge {
  box { // V_bar3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.3, 1.0>
    rotate -22.5*z
    translate  <0.826373, 0.112242, 0.0>
  }
  box { // V_bar4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.3, 1.0>
    rotate 22.5*z
    translate  <-0.860523, 0.112242, 0.0>
  }
  box { // V_serif5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <-2.657569, 2.84667, 0.0>
  }
  box { // V_serif6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <2.623972, 2.846245, 0.0>
  }
  box { // V_serif7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <-0.008912, -2.62692, 0.0>
  }
  texture {
    Brass_Metal1
  }
  scale 0.15
  translate  <-0.208709, -6.438392, 0.907772>
}
#declare number6 = union {
  object { Font_I5 }
  object { Font_V1 }
  texture {
    DMFWood2
  }
}
#declare Font_I2 = merge {
  box { // I_Base2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.2, 1.0>
    translate  0.226209*y
  }
  box { // I_Serif5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  3.073321*y
  }
  box { // I_Serif6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  -2.553041*y
  }
  scale 0.15
  translate  <0.30197, 2.44159, 0.0>
}
#declare Font_I3 = merge {
  box { // I_Base3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.2, 1.0>
    translate  0.226209*y
  }
  box { // I_Serif7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  3.073321*y
  }
  box { // I_Serif8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  -2.553041*y
  }
  scale 0.15
  translate  <0.70012, 2.442917, 0.0>
}
#declare Font_I4 = merge {
  box { // I_Base4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.2, 1.0>
    translate  0.226209*y
  }
  box { // I_Serif9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  3.073321*y
  }
  box { // I_Serif10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  -2.553041*y
  }
  scale 0.15
  translate  <1.09827, 2.444567, 0.0>
}
#declare number3 = union {
  object { Font_I2 }
  object { Font_I3 }
  object { Font_I4 }
  texture {
    DMFWood2
  }
  translate  <5.455024, -2.470079, 0.907772>
}
#declare Font_X = merge {
  box { // X_bar1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 4.0, 1.0>
    rotate -45.0*z
  }
  box { // X_bar2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 4.0, 1.0>
    rotate 45.0*z
  }
  box { // X_serif1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <-2.621577, 2.828674, 0.0>
  }
  box { // X_serif2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <2.623972, 2.828674, 0.0>
  }
  box { // X_serif3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <-2.621577, -2.81214, 0.0>
  }
  box { // X_serif4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 1.0>
    translate  <2.623972, -2.81214, 0.0>
  }
  scale 0.15
  translate  <-0.503532, 6.508712, 0.0>
}
#declare Font_I = merge {
  box { // I_Base
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.2, 1.0>
    translate  0.226209*y
  }
  box { // I_Serif1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  3.073321*y
  }
  box { // I_Serif2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  -2.553041*y
  }
  scale 0.15
  translate  <0.30197, 6.471219, 0.0>
}
#declare Font_I1 = merge {
  box { // I_Base1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 3.2, 1.0>
    translate  0.226209*y
  }
  box { // I_Serif3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  3.073321*y
  }
  box { // I_Serif4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.2, 0.515, 1.0>
    translate  -2.553041*y
  }
  scale 0.15
  translate  <0.720273, 6.471219, 0.0>
}
#declare number12 = union {
  object { Font_X }
  object { Font_I }
  object { Font_I1 }
  texture {
    DMFWood2
  }
  translate  <0.0, -0.187425, 0.907772>
}
#declare clock_face1 = difference {
  cylinder { // face_border
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFDarkOak1
    }
    scale <8.0, 8.0, 1.0>
  }
  cylinder { // face
    <0,0,1>, <0,0,0>, 1
    texture {
      White_Wood1
    }
    scale <7.5, 7.5, 1.0>
    translate  0.9*z
  }
}
#declare clock1 = union {
  object { min_hand }
  object { hour_hand }
  sphere { // hand_holder
    <0,0,0>,1
    texture {
      DMFDarkOak1
    }
    translate  0.896872*z
  }
  object { number9 }
  object { number6 }
  object { number3 }
  object { number12 }
  object { clock_face1 }
  rotate 90.0*x
  translate  <0.518719, 22.438147, 8.862008>
}
#declare clock_rear = merge {
  box { // rear_clock1
    <-1, -1, -1>, <1, 1, 1>
    scale <4.39461, 2.0, 4.204822>
    translate  <0.527394, 24.228524, 8.815176>
  }
  cylinder { // rear_clock2
    <0,0,1>, <0,0,0>, 1
    scale <4.39, 1.126716, 4.003785>
    rotate -90.0*x
    translate  <0.530606, 22.228359, 13.014648>
  }
  texture {
    DMFDarkOak1
  }
}
#declare clock_w_rear = union {
  object { clock1 }
  object { clock_rear }
  translate  <0.0, -1.221996, 4.55425>
}
#declare glass_dome = merge {
  cylinder { // glass_case1
    <0,0,1>, <0,0,0>, 1
    scale <9.5, 9.5, 25.0>
    translate  <0.274485, 23.067997, -7.522616>
  }
  sphere { // glass_case2
    <0,0,0>,1
    scale <9.5, 9.5, 8.0>
    translate  <0.281932, 23.070859, 17.420842>
  }
  texture {
    Glass1
  }
}
#declare clock_base = difference {
  cylinder { // base
    <0,0,1>, <0,0,0>, 1
    scale <10.5, 10.5, 2.0>
    translate  <0.273394, 23.079848, -0.81912>
  }
  torus { // dome_cut
    9.5, 0.5  rotate -x*90
    translate  <0.280263, 23.080747, 1.211647>
  }
  texture {
    DMFDarkOak1
  }
  translate  -8.32872*z
}
#declare clock_dome_base = union {
  object { clock_w_rear }
  object { glass_dome }
  object { clock_base }
}
#declare ball_arms = merge {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFLightOak1
    }
    scale <0.5, 0.5, 12.5>
    rotate 90.0*x
    translate  <0.28587, 29.276275, -5.474982>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFLightOak1
    }
    scale <0.5, 0.5, 12.5>
    rotate <90.0, 0.0, 90.0>
    translate  <-5.975777, 23.075707, -5.474982>
  }
  translate  0.894536*z
}
#declare b_arms_w_balls = merge {
  object { ball_arms }
  sphere { // ball1
    <0,0,0>,1
    scale 1.2
    translate  <0.288931, 16.780062, -4.671466>
  }
  sphere { // ball2
    <0,0,0>,1
    scale 1.2
    translate  <6.520361, 23.072251, -4.671466>
  }
  sphere { // ball3
    <0,0,0>,1
    scale 1.2
    translate  <0.29606, 29.273922, -4.671466>
  }
  sphere { // ball4
    <0,0,0>,1
    scale 1.2
    translate  <-5.976297, 23.073404, -4.671466>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFLightOak1
    }
    scale <0.5, 0.5, 18.0>
    translate  <0.28587, 23.102794, -7.761018>
  }
  texture {
    DMFLightOak1
  }
}
union { // dome_clock
  object { clock_dome_base }
  object { b_arms_w_balls }
  scale <0.15, 0.15, 0.15>
  rotate 20.0*z
  translate  <-42.976837, 28.127646, -18.275>
}


#declare lampshade_1 = difference {
  cone { // lampshade_base
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.3, 3.3, 4.6>
    rotate <180.0, 0.0, 180.0>
    translate  1.3*z
  }
  cone { // lampshade_bas1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.27, 3.27, 4.6>
    rotate <-180.0, 0.0, -180.0>
    translate  <0.001747, 0.000519, 1.242792>
  }
  translate  <-1.3, 7.0, 0.0>
}
#declare lampshade = difference {
  object { lampshade_1 }
  box { // lampshade_cut
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 2.2, 1.5>
    translate  <-1.3, 7.0, 0.9>
  }
  texture {
    lamp_tex
  }
  translate  3.52019*z
}
#declare lamp_stand = merge {
  cylinder { // lamp_base
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 0.35>
    translate  <-1.3, 7.0, -5.449331>
  }
  cylinder { // stand_part2
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 16.75>
    translate  <-1.309796, 7.000892, -4.933658>
  }
  sphere { // stand_part1
    <0,0,0>,1
    scale <1.0, 1.0, 0.2>
    translate  <-1.297421, 7.001911, -5.094625>
  }
  texture {
    Dark_Wood1
  translate <-1.306770, 6.966925, -3.779070>
  }
  translate  -10.018385*z
}
union { // the_lamp
  object { lampshade }
  object { lamp_stand }
  translate  <-36.880117, 24.352846, -14.202365>
}


