    /***********************************************************************/
//                       "The End of Time"                             //
//                            by Nathan Ostrowsky                      //
/***********************************************************************/

#include "colors.inc"
#include "metals.inc"
global_settings{ assumed_gamma 2.2}

//***************************** The Hourglass ****************************//

#declare HG_Size = 1.1
#declare H_Glass_Outside = sor{ 13,<0.5, -0.5>
                              <0.50, 0.0>
                              <0.48, 0.5>
                              <0.39, 0.7>
                              <0.30, 0.8>
                              <0.15, 0.9>
                              <0.10, 1.0>
                              <0.15, 1.1>
                              <0.30, 1.2>
                              <0.39, 1.3>
                              <0.48, 1.5>
                              <0.50, 2.0>
                              <0.50, 2.5>
                              sturm
                          }

#declare H_Glass_Inside = sor{ 13, <0.45, -0.5>
                              <0.45, -0.1>
                              <0.43, 0.5>
                              <0.34, 0.7>
                              <0.25, 0.8>
                              <0.10, 0.9>
                              <0.05, 1.0>
                              <0.10, 1.1>
                              <0.25, 1.2>
                              <0.34, 1.3>
                              <0.43, 1.5>
                              <0.45, 2.1>
                              <0.45, 2.5>
                              sturm
                          }

#declare Clear_Glass = texture {
                    pigment{rgbt <1,1,1,0.95>}
                    finish{ambient 0.1 diffuse 0.1 reflection 0.15
                         specular 0.9 roughness 0.003
                         refraction 1 ior 1.5
                    }
                }

#declare H_Glass_Texture = texture{ Clear_Glass }
//#declare H_Glass_Texture = texture{ pigment{rgb 1} }

#declare H_Glass = intersection{
                         object{H_Glass_Outside}
                         object{H_Glass_Inside inverse}
                         translate -1*y
                    }

#declare Hole = intersection{  //-1.7 to 1.7 on z,  sand 1.26 high
                      height_field{gif "hole.gif"  translate <-0.5,0,-0.5>}
                      plane{-y,0}
                  }
#declare Smashed_H_Glass = difference{
                object{H_Glass}
                object{Hole  scale 0.7
                             rotate -90*z
                             translate <0.3,-0.9,0>
                             rotate (40+7)*y
                }
        }

#declare Frame_Texture = texture{
              bozo
              texture_map{ [0.0 T_Copper_4A]
                           [0.1 T_Copper_3B] }
              turbulence 0.2  omega 0.8
              scale 1.0
             }


#declare HG_End = difference{
                    union{
                        cylinder{0*y, 3*y, 5.5}
                        cylinder{0.5*y, 2.5*y, 6.0}
                        torus{5.5,0.5 translate 0.5*y}
                        torus{5.5,0.5 translate 2.5*y}
                    }
                    torus{6.0,0.25 translate 1*y}
                    torus{6.0,0.25 translate 2*y}
                    scale <1.2,1,1.2>
                  }

#declare Bead = sphere{0,0.5 scale <1,1.3,1>}
#declare Supports = union{
                #declare Trans = -(HG_Size*10 - 0.5)
                #while(Trans <= HG_Size*10 - 0.5)
                    object{Bead translate <6.1,Trans,0>}
                    object{Bead translate <6.1,Trans,0> rotate 120*y}
                    object{Bead translate <6.1,Trans,0> rotate -120*y}
                    #declare Trans = Trans + 1
                #end
            }

#declare HG_Frame = union{
                       object{HG_End translate (HG_Size-0.01)*10*y}
                       object{HG_End translate (HG_Size-0.01)*10*y rotate 180*x}
                       object{Supports}
                       texture{Frame_Texture}
                    }


#declare Sand_Texture = texture{
            pigment{bozo
                    color_map{[0.00 Tan*0.6]
                              [0.02 NewTan]}
                    turbulence 0.8
                    scale 0.07
                }
            finish{ambient 0.2 diffuse 0.8}
    }

//mound of sand inside
#declare Sand_in = intersection{
        cylinder{0*y, 8*y, 4.499}
        sphere{0,1 scale <8,10,8> translate <-1,-3,0>}
        texture{ Sand_Texture }
    }

//sand pouring out
#declare Sand_mid = union {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.122346, -2.213660, -0.026701>, <-0.916982, -1.515698, -0.026701>, <-0.148772, -1.132439, -0.026701>, <0.619438, -0.082365, -0.026701>,
      <-1.668927, -1.462316, 1.457952>, <-0.856961, -0.668619, 0.143244>, <-0.165269, -0.516008, 0.111331>, <0.619438, -0.054707, -0.026701>,
      <-1.662835, -1.839493, 1.260907>, <-1.046881, -0.529418, 1.379303>, <0.079055, -0.408550, 0.362898>, <0.619438, -0.027049, -0.026701>,
      <-1.662835, 0.000153, 1.260907>, <-1.046881, 0.000609, 1.379303>, <0.079055, 0.000609, 0.362898>, <0.619438, 0.000609, -0.026701>
    }
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.662835, 0.000153, 1.260907>, <-1.046881, 0.000609, 1.379303>, <0.079055, 0.000609, 0.362898>, <0.619438, 0.000609, -0.026701>,
      <-1.662835, 1.839799, 1.260907>, <-1.046881, 0.530635, 1.379303>, <0.079055, 0.409767, 0.362898>, <0.619438, 0.028266, -0.026701>,
      <-1.668927, 1.451751, 1.438849>, <-0.856961, 0.669836, 0.143244>, <-0.165269, 0.517225, 0.111331>, <0.619438, 0.055924, -0.026701>,
      <-2.122346, 2.197438, -0.026701>, <-0.916982, 1.515132, -0.026701>, <-0.148772, 1.131620, -0.026701>, <0.619438, 0.083582, -0.026701>
    }
    rotate -90*x
    texture { Sand_Texture }
}

//pile of sand that has poured out
#declare Sand_out = union {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.170186, -3.945489, 0.038766>, <-2.028640, -3.730118, 0.038766>, <-1.033823, -3.628433, 0.038766>, <-0.039007, -3.526748, 0.038766>,
      <-3.785968, -2.000000, 0.240697>, <-1.961234, -2.000000, 0.298793>, <-0.961234, -1.802216, 0.298793>, <-0.088950, -1.516778, 0.168780>,
      <-3.689909, -1.122829, 2.762689>, <-2.957717, -1.000000, 2.982753>, <-2.101363, -1.000000, 1.514995>, <-0.546135, -0.962841, 0.875389>,
      <-3.689909, 0.000000, 2.762689>, <-2.957717, 0.000000, 2.982753>, <-2.101363, 0.000000, 1.514995>, <-0.546135, 0.037159, 0.875389>
    }
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.689909, 0.000000, 2.762689>, <-2.957717, 0.000000, 2.982753>, <-2.101363, 0.000000, 1.514995>, <-0.546135, 0.037159, 0.875389>,
      <-3.689909, 1.122829, 2.762689>, <-2.957717, 1.000000, 2.982753>, <-2.101363, 1.000000, 1.514995>, <-0.546135, 1.037159, 0.875389>,
      <-3.785968, 2.000000, 0.240697>, <-1.961234, 2.000000, 0.298793>, <-0.961234, 1.802216, 0.298793>, <-0.088950, 1.516778, 0.168780>,
      <-5.054032, 3.945489, 0.038766>, <-1.926923, 3.820751, 0.038766>, <-0.952656, 3.595353, 0.038766>, <0.021611, 3.369956, 0.038766>
    }
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.039007, -3.526748, 0.038766>, <0.955810, -3.425063, 0.038766>, <2.038766, -3.000000, 0.038766>, <2.518545, -2.426866, 0.038766>,
      <-0.088950, -1.516778, 0.168780>, <0.783334, -1.231339, 0.038766>, <2.038766, -0.593935, 0.038766>, <2.874509, -1.546559, 0.038766>,
      <-0.546135, -0.962841, 0.875389>, <1.009093, -0.925683, 0.235783>, <1.360923, -1.000000, 0.038766>, <3.038766, -1.000000, 0.038766>,
      <-0.546135, 0.037159, 0.875389>, <1.009093, 0.074317, 0.235783>, <1.360923, 0.000000, 0.038766>, <3.038766, 0.000000, 0.038766>
    }
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.546135, 0.037159, 0.875389>, <1.009093, 0.074317, 0.235783>, <1.360923, 0.000000, 0.038766>, <3.038766, 0.000000, 0.038766>,
      <-0.546135, 1.037159, 0.875389>, <1.009093, 1.074317, 0.235783>, <1.360923, 1.000000, 0.038766>, <3.038766, 1.000000, 0.038766>,
      <-0.088950, 1.516778, 0.168780>, <0.783334, 1.231339, 0.038766>, <2.038766, 0.593935, 0.038766>, <2.874509, 1.546559, 0.038766>,
      <0.021611, 3.369956, 0.038766>, <0.995878, 3.144558, 0.038766>, <2.038766, 3.000000, 0.038766>, <2.518545, 2.426866, 0.038766>
    }
    rotate -90*x
    texture{ gradient y
            texture_map{[0.00 pigment{Clear}]
                        [0.08 Sand_Texture scale 0.33]
            }
            scale 3
     }
}

//the Hourglass   12 x 28 x 12 units
#declare Hour_Glass = union{
         object{Smashed_H_Glass  texture{H_Glass_Texture} scale <1,HG_Size,1>*10}
         object{HG_Frame}
         object{Sand_in  translate -14*y  rotate 40*y}
         object{Sand_mid  scale <1.1,1.15,1.2>  translate <5.9,-11,0>  rotate 40*y}
         object{Sand_out   scale <1.1,1,1.1>  translate <10.9,-14,0>  rotate 41*y}
       }


//****************************** the Sky ******************************//
#declare Cloud_P = pigment {
    wrinkles
    turbulence 0.1
    lambda 2.2
    omega 0.707
    color_map {
        [0.20 SkyBlue * 0.85 ]
        [0.60 Gray90 ]
        [1.00 Gray70 ]
    }
    scale <0.4, 0.15, 0.9>
}

#declare TimeSky =
    sky_sphere{
        pigment {
            gradient y
            pigment_map {
                [0.05 SkyBlue * 0.9] // horizon
                [0.15 Cloud_P ]
            }
        }
    }

//background{SkyBlue*1.1}

//**************************** The Terrain ********************************//

#declare Grass_Tex = texture{
                pigment{ForestGreen*1.2}
                normal{bumps 1 turbulence 0.2 scale <0.04,0.01,0.005>}
                finish{ambient 0.2 diffuse 0.6 phong 0.1}
            }

#declare Ground =
    height_field{ gif "timrnge3.ghf" smooth
        texture{ gradient y
            texture_map{ [0.09 pigment{Tan} finish{ambient 0.2 diffuse 0.6 phong 0.1}]
                         [0.11 Grass_Tex]
                         [0.65 pigment{rgb <0.65, 0.6, 0.5>} finish{ambient 0.2 diffuse 0.6 phong 0.1}]
                         [0.83 pigment{White} finish{ambient 0.2 diffuse 0.6 phong 0.1}] }
            turbulence 0.2
            translate -22*y
        }
        translate <-0.5,0,0>
        scale <600,136,1600>
        translate <10,-14.9,-100>
    }

#declare Lake =
    plane{y,-2
        pigment{rgb<0,0.1,0.2>}
        finish{ambient 0.2 diffuse 0.2 phong 0.9 reflection 0.6}
        normal{bumps 0.02 scale 0.5}
    }

//******************************!!!!Main Scene!!!!******************************//

camera{location <0,9,-80>
       look_at <0,14,0>
       angle 25
}

light_source{<300,200,-200> color rgb 1}

#declare l_base = cylinder { <0,0,0> <0,1.5,0> 0.75 }
#declare t_base = finish { ambient 0.4 diffuse 0.5 phong 0.2 }
#declare t_leaf = finish { ambient 0.5 diffuse 0.4 phong 0.4}
#declare col_1  = colour red 0.8 green 0.5 blue 0.2
#declare col_8  = colour red 0.2 green 0.6 blue 0.1
#include "tree04.inc"
object{Tree scale 0.004 rotate 0*y translate <4.4,1.8,-7.2>+<-8,0,5>}
object{Tree scale 0.004 rotate 0*y translate <6,1.6,-8>+<-8,0,5>}
object{Tree scale 0.004 rotate 0*y translate <6.8,0,-12>+<-8,0,5>}
object{Tree scale 0.004 rotate 0*y translate <2.9,3.8,-4.3>+<-8,0,5>}
object{Tree scale 0.004 rotate 0*y translate <1.4,5.8,-2.3>+<-8,0,5>}
object{Tree scale 0.004 rotate 0*y translate <-0.8,6.3,-1.7>+<-8,0,5>}
object{Tree scale 0.004 rotate 0*y translate <0.4,6.8,0.5>+<-8,0,5>}
object{Tree scale 0.004 rotate 0*y translate <9,0,-7.7>+<-8,0,5>}

sky_sphere{TimeSky}
object{Ground}
object{Lake}

object{Hour_Glass rotate 10*y translate <-8,13.9,5>}

#include "cow.inc"
object{Cow translate <0,3.2,0> rotate -10*y scale 0.15 translate <-6.8,0,-3.6>}
