//The Temple of Time by Roland Vansteenkiste
global_settings { assumed_gamma 2.2}

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "glass.inc"
#include "hrglass.inc"
#include "pillar.inc"
#include "skies.inc"
#include "woods.inc"

camera {location <0,20,-370>
	right<4/3, 0, 0>
        angle 30
	look_at <0, 20, 0>
}

light_source{<0, 200,-10>  color rgb 1}
light_source{<0, 40,-370> color rgb 0.81}

sky_sphere {S_Cloud2}

object{HourGlass rotate 45*y translate 34*y}

box //floor
{  <-55, -1, -300>  // one corner position <X1 Y1 Z1>
   < 55,  0,  55>  // other corner position <X2 Y2 Z2>
 texture {
    brick texture{T_Gold_1A}, texture{T_Stone14 scale 20}
    brick_size <15,15,15> mortar 0.2
    translate 7.5*x
  }
}

box //platform
{  <-55, 0, -55>  // one corner position <X1 Y1 Z1>
   < 55, 5, 55>  // other corner position <X2 Y2 Z2>
   texture {T_Stone17 scale 10}
}

cylinder //rounded backwall
{  5*y,  63*y,  55
   open
   texture {T_Silver_5E}
   clipped_by {plane{-z,0}}
}

sphere //dome
{  65*y,  50
   texture{T_Glass3}
   clipped_by {plane{-y,-65}}
}

difference{ //ceiling
    box {
        <-56, 63, -300>
        < 56, 65,  55>}
    sphere {63*y,50}
    texture {T_Stone17 scale 10}
}

#declare Gal=union{
object{Pillar translate <0,0, -60>}
object{Pillar translate <0,0, -80>}
object{Pillar translate <0,0,-100>}
object{Pillar translate <0,0,-120>}
object{Pillar translate <0,0,-140>}
object{Pillar translate <0,0,-160>}
object{Pillar translate <0,0,-180>}
object{Pillar translate <0,0,-200>}
object{Pillar translate <0,0,-220>}
object{Pillar translate <0,0,-240>}
object{Pillar translate <0,0,-260>}
object{Pillar translate <0,0,-280>}

box //beam 1 middle
{  <-3, 26, -58>
   < 3, 30, -300>
   texture {T_Stone8 scale 20}
}

box //beam 2 middle
{  <-4, 30, -58>
   < 4, 31, -300>
   texture {T_Stone8 scale 20}
}

object{Pillar translate <0,31, -60>}
object{Pillar translate <0,31, -80>}
object{Pillar translate <0,31,-100>}
object{Pillar translate <0,31,-120>}
object{Pillar translate <0,31,-140>}
object{Pillar translate <0,31,-160>}
object{Pillar translate <0,31,-180>}
object{Pillar translate <0,31,-200>}
object{Pillar translate <0,31,-220>}
object{Pillar translate <0,31,-240>}
object{Pillar translate <0,31,-260>}
object{Pillar translate <0,31,-280>}

box // beam upper
{  <-3, 57, -58>  // one corner position <X1 Y1 Z1>
   < 3, 61, -300>  // other corner position <X2 Y2 Z2>
   texture {T_Stone8 scale 20}
  }
}

object{Gal texture {T_Stone12 scale 20} translate 30*x}
object{Gal texture {T_Stone12 scale 20} translate -30*x}

box //wall right
{  <55, 0, 0>  // one corner position <X1 Y1 Z1>
   <56, 63, -300>  // other corner position <X2 Y2 Z2>
   texture {T_Stone15 scale 20}
}

box //wall left
{  <-55, 0, 0>  // one corner position <X1 Y1 Z1>
   <-56, 63, -300>  // other corner position <X2 Y2 Z2>
   texture {T_Stone15 scale 20}
}

#declare Balk= //wooden beam
box
{  <-56, 61, -1>  // one corner position <X1 Y1 Z1>
   <56, 63, 1.>  // other corner position <X2 Y2 Z2>
   texture {T_Wood6 scale <20,1,1>}
}

object{Balk translate  -60*z}
object{Balk translate  -80*z}
object{Balk translate -100*z}
object{Balk translate -120*z}
object{Balk translate -140*z}
object{Balk translate -160*z}
object{Balk translate -180*z}
object{Balk translate -200*z}
object{Balk translate -220*z}
object{Balk translate -240*z}
object{Balk translate -260*z}
object{Balk translate -280*z}
